/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.channel.Impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.EnableEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgPjOrgCustomerRelationExtRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemRateDgRespDto;
import com.yunxi.dg.base.center.price.dto.response.SkuPolicyPriceRespDto;
import com.yunxi.dg.base.center.share.constants.ShopWarehouseEnum;
import com.yunxi.dg.base.center.share.dto.entity.DgInventorySupplyStrategyDto;
import com.yunxi.dg.base.center.share.dto.entity.DgInventorySupplyStrategyQueryReqDto;
import com.yunxi.dg.base.center.share.proxy.strategy.IDgInventorySupplyStrategyQueryApiProxy;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.trade.action.oms.channel.IPreInfoQueryAction;
import com.yunxi.dg.base.center.trade.action.oms.channel.PrepareOrderData;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAdvanceOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAdvanceRelevanceOrderDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.entity.BeforeOrderItemNumDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BOrderContextVo;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.activity.DgOrderActivityBizReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.cost.CostAccountDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.DgOrderPreviewReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.OrderPreviewItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.advance.DgAdvanceOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgAdvanceRelevanceOrderEo;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderService;
import com.yunxi.dg.base.center.trade.service.oms.common.ICommonOrderQueryService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgCalcActivityService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="prepareStandardOrderData")
public class PrepareStandardOrderData
implements PrepareOrderData {
    private static final Logger log = LoggerFactory.getLogger(PrepareStandardOrderData.class);
    @Resource
    private IDgCalcActivityService dgCalcActivityService;
    @Resource
    private IPreInfoQueryAction preInfoQueryAction;
    @Resource
    private IDgInventorySupplyStrategyQueryApiProxy dgInventorySupplyStrategyQueryApiProxy;
    @Resource
    private IDgAdvanceOrderDomain dgAdvanceOrderDomain;
    @Resource
    private IDgAdvanceRelevanceOrderDomain dgAdvanceRelevanceOrderDomain;
    @Resource
    private IDgAfterSaleOrderItemService dgAfterSaleOrderItemService;
    @Resource
    private IDgAfterSaleOrderService dgAfterSaleOrderService;
    @Resource
    private ICommonOrderQueryService commonOrderQueryService;

    @Override
    public void execute(DgF2BOrderContextVo vo) {
        DgOrderPreviewReqDto previewReqDto = vo.getPreviewReqDto();
        List<Long> itemIdList = previewReqDto.getItemList().stream().map(OrderPreviewItemReqDto::getItemId).collect(Collectors.toList());
        ArrayList shopIdList = Lists.newArrayList(vo.getShopItemGroup().keySet());
        DgCustomerRespDto dgCustomerRespDto = this.preInfoQueryAction.getCustomerRespDto(previewReqDto.getCustomerId());
        vo.setDgCustomerRespDto(dgCustomerRespDto);
        List<DgShopRespDto> dgShopRespDtos = this.preInfoQueryAction.queryListShop(shopIdList);
        Map shopMap = dgShopRespDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
        vo.setShopMap(shopMap);
        List<DgPjOrgCustomerRelationExtRespDto> customerRelationExtRespDtos = this.preInfoQueryAction.queryByShopIdsAndCustomerIds(Collections.singletonList(previewReqDto.getCustomerId()), dgShopRespDtos.stream().map(BaseDto::getId).collect(Collectors.toList()));
        Map shopRelationCompanyIdMap = customerRelationExtRespDtos.stream().collect(Collectors.toMap(DgPjOrgCustomerRelationExtRespDto::getShopId, Function.identity()));
        vo.setShopEnterPriseMap(shopRelationCompanyIdMap);
        this.queryItemInfos(vo);
        if (CollectionUtil.isNotEmpty((Collection)previewReqDto.getMaterialList())) {
            List<Long> materialSkuIds = previewReqDto.getMaterialList().stream().map(OrderPreviewItemReqDto::getSkuId).collect(Collectors.toList());
            List<DgItemSkuDetailRespDto> materialSkuRespDtos = this.preInfoQueryAction.queryMaterialSkuList(materialSkuIds);
            Map materialMap = materialSkuRespDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
            vo.setMaterialMap(materialMap);
            List mateRialItemIds = previewReqDto.getMaterialList().stream().map(OrderPreviewItemReqDto::getItemId).collect(Collectors.toList());
            itemIdList.addAll(mateRialItemIds);
        }
        this.queryPrice(vo);
        ItemRateDgRespDto itemRateDgRespDto = this.preInfoQueryAction.queryTaxRateByItemIds(itemIdList);
        if (itemRateDgRespDto != null && CollUtil.isNotEmpty((Map)itemRateDgRespDto.getItemRateMap())) {
            vo.setItemRateDgRespDtoMap(itemRateDgRespDto.getItemRateMap());
        }
        Map shopAccountDtoMap = Optional.ofNullable(vo.getPreviewReqDto().getCostAccountRespDtos()).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(CostAccountDto::getShopId, Function.identity(), (e1, e2) -> e1));
        vo.setShopAccountDtoMap(shopAccountDtoMap);
        this.queryActivity(vo);
        List shopCodes = dgShopRespDtos.stream().map(DgShopRespDto::getStoreCode).collect(Collectors.toList());
        DgInventorySupplyStrategyQueryReqDto strategyQueryReqDto = new DgInventorySupplyStrategyQueryReqDto();
        strategyQueryReqDto.setShopCodeList(shopCodes);
        strategyQueryReqDto.setStatus(EnableEnum.ENABLE.getCodeEn());
        strategyQueryReqDto.setFunctionModule(ShopWarehouseEnum.SHOP.getCode().toUpperCase());
        List supplyStrategyDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgInventorySupplyStrategyQueryApiProxy.queryByList(strategyQueryReqDto));
        Map supplyStrategyDtoMap = Optional.ofNullable(supplyStrategyDtos).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(DgInventorySupplyStrategyDto::getShopCode, Function.identity(), (e1, e2) -> e1));
        vo.setSupplyStrategyDtoMap(supplyStrategyDtoMap);
        if (Objects.equals(previewReqDto.getOrderType(), DgSaleOrderTypeEnum.CUSTOM_ORDER.getType()) && StringUtils.isNotEmpty((CharSequence)previewReqDto.getBeforeOrderNo())) {
            DgAdvanceOrderRespDto dgAdvanceOrderRespDto = this.dgAdvanceOrderDomain.queryByOrderNo(previewReqDto.getBeforeOrderNo());
            AssertUtils.notNull((Object)dgAdvanceOrderRespDto, (String)"\u9884\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            AssertUtils.isTrue((boolean)shopIdList.contains(dgAdvanceOrderRespDto.getShopId()), (String)"\u9884\u8ba2\u5355\u5e97\u94fa\u4fe1\u606f\u4e0d\u5339\u914d");
            List itemLineDtoList = dgAdvanceOrderRespDto.getItemLineDtoList().stream().filter(i -> i.getStatus().equals(0)).collect(Collectors.toList());
            AssertUtils.notEmpty(itemLineDtoList, (String)"\u9884\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u5df2\u4f7f\u7528\u5b8c");
            dgAdvanceOrderRespDto.setItemLineDtoList(itemLineDtoList);
            vo.setAdvanceOrderDto(dgAdvanceOrderRespDto);
            if (StringUtils.isNotEmpty((CharSequence)previewReqDto.getSaleOrderNo())) {
                LambdaQueryWrapper advanceRelevanceQuery = new LambdaQueryWrapper();
                advanceRelevanceQuery.eq(DgAdvanceRelevanceOrderEo::getAdvanceOrderNo, (Object)previewReqDto.getBeforeOrderNo());
                advanceRelevanceQuery.eq(DgAdvanceRelevanceOrderEo::getRelevanceOrderNo, (Object)previewReqDto.getSaleOrderNo());
                List dgAdvanceRelevanceOrderEos = this.dgAdvanceRelevanceOrderDomain.getMapper().selectList((Wrapper)advanceRelevanceQuery);
                if (CollectionUtils.isNotEmpty((Collection)dgAdvanceRelevanceOrderEos)) {
                    Map<Long, BigDecimal> advanceRelevanceMap = dgAdvanceRelevanceOrderEos.stream().collect(Collectors.toMap(DgAdvanceRelevanceOrderEo::getSkuId, DgAdvanceRelevanceOrderEo::getDeliveryNum, (k1, k2) -> k1));
                    vo.setAdvanceRelevanceMap(advanceRelevanceMap);
                }
            }
        }
        if (Objects.equals(previewReqDto.getOrderType(), DgSaleOrderTypeEnum.ACCOUNT_REGULATION_ORDER.getType()) && StringUtils.isNotEmpty((CharSequence)previewReqDto.getBeforeOrderNo())) {
            DgAfterSaleOrderRespDto dgAfterSaleOrderRespDto = this.dgAfterSaleOrderService.queryReturnOrderByNo(previewReqDto.getBeforeOrderNo());
            AssertUtils.isTrue((boolean)Objects.equals(dgAfterSaleOrderRespDto.getCustomerCode(), dgCustomerRespDto.getCode()), (String)"\u9000\u8d27\u5355\u5ba2\u6237\u4fe1\u606f\u4e0d\u5339\u914d");
            AssertUtils.isTrue((boolean)shopIdList.contains(dgAfterSaleOrderRespDto.getShopId()), (String)"\u9000\u8d27\u5355\u5e97\u94fa\u4fe1\u606f\u4e0d\u5339\u914d");
            List<DgAfterSaleOrderItemRespDto> dgAfterSaleOrderItemRespDtos = this.dgAfterSaleOrderItemService.queryByAfterSale(previewReqDto.getBeforeOrderNo(), "0");
            AssertUtils.notEmpty(dgAfterSaleOrderItemRespDtos, (String)"\u9000\u8d27\u5355\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
            Map<Object, Object> beforeItemNumMap = new HashMap();
            List<Object> beforeOrderItemNumDtoList = this.commonOrderQueryService.queryRelBeforeItemNum(previewReqDto.getBeforeOrderNo());
            if (CollectionUtils.isNotEmpty(beforeOrderItemNumDtoList)) {
                if (StringUtils.isNotEmpty((CharSequence)previewReqDto.getSaleOrderNo())) {
                    beforeOrderItemNumDtoList = beforeOrderItemNumDtoList.stream().filter(b -> !Objects.equals(b.getSaleOrderNo(), previewReqDto.getSaleOrderNo())).collect(Collectors.toList());
                }
                if (CollectionUtils.isNotEmpty(beforeOrderItemNumDtoList)) {
                    beforeItemNumMap = beforeOrderItemNumDtoList.stream().collect(Collectors.toMap(BeforeOrderItemNumDto::getBeforeOrderItemId, BeforeOrderItemNumDto::getItemNum, (k1, k2) -> {
                        k1 = k1.add((BigDecimal)k2);
                        return k1;
                    }));
                }
            }
            HashMap<Long, BigDecimal> orderReturnItemNumMap = new HashMap<Long, BigDecimal>();
            for (DgAfterSaleOrderItemRespDto itemRespDto : dgAfterSaleOrderItemRespDtos) {
                if (beforeItemNumMap.containsKey(itemRespDto.getId())) {
                    Integer orderItemNum = ((BigDecimal)beforeItemNumMap.get(itemRespDto.getId())).intValue();
                    itemRespDto.setActualReturnNum(Integer.valueOf(itemRespDto.getActualReturnNum() - orderItemNum));
                }
                if (ObjectUtil.isNotEmpty((Object)itemRespDto.getActualReturnNum()) && itemRespDto.getActualReturnNum() > 0) {
                    orderReturnItemNumMap.put(itemRespDto.getSkuId(), new BigDecimal(itemRespDto.getActualReturnNum()));
                    continue;
                }
                orderReturnItemNumMap.put(itemRespDto.getSkuId(), new BigDecimal(itemRespDto.getReturnNum()));
            }
            vo.setOrderReturnItemNumMap(orderReturnItemNumMap);
        }
    }

    protected void queryActivity(DgF2BOrderContextVo vo) {
        DgOrderPreviewReqDto previewReqDto = vo.getPreviewReqDto();
        DgCustomerRespDto dgCustomerRespDto = vo.getDgCustomerRespDto();
        Map shopMap = vo.getShopMap();
        List activityList = Optional.ofNullable(vo.getPreviewReqDto().getActivityList()).orElse(Lists.newArrayList());
        if (previewReqDto.isImportOrderMatchActivity() || previewReqDto.getMatchActivity().booleanValue()) {
            shopMap.keySet().forEach(shopId -> {
                List<Long> itemIds = ((List)vo.getShopItemGroup().get(shopId)).stream().map(OrderPreviewItemReqDto::getItemId).collect(Collectors.toList());
                long activityStartTime = System.currentTimeMillis();
                List<DgOrderActivityBizReqDto> promotionActivityList = this.dgCalcActivityService.getPromotionActivityList(Lists.newArrayList((Object[])new Long[]{shopId}), itemIds, dgCustomerRespDto.getId());
                long activityEndTime = System.currentTimeMillis();
                log.info("\u67e5\u8be2\u6d3b\u52a8\u8017\u65f6:{}", (Object)(activityEndTime - activityStartTime));
                if (CollectionUtils.isNotEmpty(promotionActivityList)) {
                    activityList.addAll(promotionActivityList);
                }
            });
        }
        Map<Long, List<DgOrderActivityBizReqDto>> shopJoinActivityMap = activityList.stream().collect(Collectors.groupingBy(DgOrderActivityBizReqDto::getShopId));
        vo.setActivityList(activityList);
        vo.setShopJoinActivityMap(shopJoinActivityMap);
    }

    protected void queryItemInfos(DgF2BOrderContextVo vo) {
        DgOrderPreviewReqDto previewReqDto = vo.getPreviewReqDto();
        List<Long> skuIds = previewReqDto.getItemList().stream().map(OrderPreviewItemReqDto::getSkuId).collect(Collectors.toList());
        List<Long> itemIdList = previewReqDto.getItemList().stream().map(OrderPreviewItemReqDto::getItemId).collect(Collectors.toList());
        ArrayList shopIdList = Lists.newArrayList(vo.getShopItemGroup().keySet());
        PageInfo<DgItemSkuPageRespDto> pageInfo = this.preInfoQueryAction.queryShopSkuList(shopIdList, skuIds, itemIdList, Lists.newArrayList((Object[])new Integer[]{YesNoEnum.YES.getValue()}));
        Map shelfItemMap = pageInfo.getList().stream().collect(Collectors.groupingBy(DgItemSkuRespDto::getShopId, Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1)));
        vo.setShelfItemMap(shelfItemMap);
    }

    protected void queryPrice(DgF2BOrderContextVo vo) {
        DgOrderPreviewReqDto previewReqDto = vo.getPreviewReqDto();
        Map shopRelationCompanyIdMap = vo.getShopEnterPriseMap();
        List<SkuPolicyPriceRespDto> priceRespDtos = this.preInfoQueryAction.queryCustomerSkuPolicySupplyPrice(previewReqDto.getItemList(), previewReqDto.getMaterialList(), shopRelationCompanyIdMap, previewReqDto.getCustomerId());
        Map policyPriceDtoMap = priceRespDtos.stream().collect(Collectors.groupingBy(SkuPolicyPriceRespDto::getShopId, Collectors.toMap(SkuPolicyPriceRespDto::getSkuId, Function.identity(), (e1, e2) -> e1)));
        vo.setPolicyPriceDtoMap(policyPriceDtoMap);
    }
}

