/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.account.dto.biz.AccountTradeRespDto;
import com.yunxi.dg.base.center.openapi.dto.request.AccountBalanceOrderLineReqDto;
import com.yunxi.dg.base.center.openapi.dto.request.AccountPreemptionReqDto;
import com.yunxi.dg.base.center.openapi.proxy.account.IAccountBalanceApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.common.IOrderPayAction;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.pay.base.DgBasePayReqDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="orderPayExternalActionImpl")
public class OrderPayExternalActionImpl
implements IOrderPayAction {
    private static final Logger log = LoggerFactory.getLogger(OrderPayExternalActionImpl.class);
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain dgPerformOrderSnapshotDomain;
    @Resource
    private IAccountBalanceApiProxy accountBalanceApiProxy;

    @Override
    public RestResponse<Void> pay(Long id, List<DgPerformOrderLineDto> orderLineDtoList, List<DgBasePayReqDto> payReqDtoList) {
        log.info("OrderPayExternalActionImpl_\u53d1\u8d77\u652f\u4ed8id{},orderLine{},payReqDto{},", new Object[]{id, orderLineDtoList, payReqDtoList});
        DgPerformOrderInfoEo performOrderInfo = this.dgPerformOrderInfoDomain.queryEoById(id);
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)performOrderInfo), (String)("\u627e\u4e0d\u5230\u5355\u636e\u4fe1\u606f\uff1a" + id));
        DgPerformOrderSnapshotEo performOrderSnapshot = this.dgPerformOrderSnapshotDomain.selectByOrderId(performOrderInfo.getId());
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)performOrderInfo), (String)("\u627e\u4e0d\u5230\u5355\u636e\u5feb\u7167\u4fe1\u606f\uff1a" + id));
        BigDecimal amount = payReqDtoList.stream().map(DgBasePayReqDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        AccountPreemptionReqDto preemptionReqDto = new AccountPreemptionReqDto();
        preemptionReqDto.setOrderNo(performOrderInfo.getSaleOrderNo());
        preemptionReqDto.setCustomerId(performOrderSnapshot.getCustomerId());
        preemptionReqDto.setCustomerCode(performOrderSnapshot.getCustomerCode());
        preemptionReqDto.setShopCode(performOrderSnapshot.getShopCode());
        preemptionReqDto.setAmount(amount);
        ArrayList orderLineList = new ArrayList();
        preemptionReqDto.setOrderLineList(orderLineList);
        ((List)Optional.ofNullable(orderLineDtoList).orElse(new ArrayList())).forEach(orderLine -> {
            AccountBalanceOrderLineReqDto dto = new AccountBalanceOrderLineReqDto();
            orderLineList.add(dto);
            dto.setGiftFlag(orderLine.getGiftFlag());
            dto.setSkuCode(orderLine.getSkuCode());
            dto.setSkuId(orderLine.getSkuId());
            dto.setItemNum(orderLine.getItemNum());
            dto.setSettlementPrice(orderLine.getPayAmount());
        });
        log.info("\u8bf7\u6c42\u8d26\u6237\u5904\u7406\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)preemptionReqDto));
        RestResponseHelper.extractData((RestResponse)this.accountBalanceApiProxy.freezeAccountPreemptionBalance(preemptionReqDto));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> preemptionToActualPayment(Long id, List<DgBasePayReqDto> payReqDtoList) {
        log.info("OrderPayExternalActionImpl_\u9884\u5360\u989d\u5ea6\u8f6c\u5b9e\u4ed8\uff1a{}\uff0c{}", (Object)id, (Object)JSON.toJSONString(payReqDtoList));
        DgPerformOrderInfoEo performOrderInfo = this.dgPerformOrderInfoDomain.queryEoById(id);
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)performOrderInfo), (String)("\u627e\u4e0d\u5230\u5355\u636e\u4fe1\u606f\uff1a" + id));
        DgPerformOrderSnapshotEo performOrderSnapshot = this.dgPerformOrderSnapshotDomain.selectByOrderId(performOrderInfo.getId());
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)performOrderInfo), (String)("\u627e\u4e0d\u5230\u5355\u636e\u5feb\u7167\u4fe1\u606f\uff1a" + id));
        BigDecimal amount = payReqDtoList.stream().map(DgBasePayReqDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        AccountPreemptionReqDto preemptionReqDto = new AccountPreemptionReqDto();
        preemptionReqDto.setOrderNo(performOrderInfo.getSaleOrderNo());
        preemptionReqDto.setCustomerId(performOrderSnapshot.getCustomerId());
        preemptionReqDto.setCustomerCode(performOrderSnapshot.getCustomerCode());
        preemptionReqDto.setShopCode(performOrderSnapshot.getShopCode());
        preemptionReqDto.setAmount(amount);
        log.info("\u8bf7\u6c42\u8d26\u6237\u5904\u7406\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)preemptionReqDto));
        RestResponseHelper.extractData((RestResponse)this.accountBalanceApiProxy.thawAccountPreemptionBalanceAndDeductBalance(preemptionReqDto));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> preemptionToReturn(Long orderId, List<DgPerformOrderLineDto> orderLineList, List<DgBasePayReqDto> payReqDtoList) {
        log.info("OrderPayExternalActionImpl_\u9884\u5360\u989d\u5ea6\u8f6c\u9000\u56de\uff1a{}\uff0c{}", (Object)orderId, (Object)JSON.toJSONString(payReqDtoList));
        DgPerformOrderInfoEo performOrderInfo = this.dgPerformOrderInfoDomain.queryEoById(orderId);
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)performOrderInfo), (String)("\u627e\u4e0d\u5230\u5355\u636e\u4fe1\u606f\uff1a" + orderId));
        DgPerformOrderSnapshotEo performOrderSnapshot = this.dgPerformOrderSnapshotDomain.selectByOrderId(performOrderInfo.getId());
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)performOrderInfo), (String)("\u627e\u4e0d\u5230\u5355\u636e\u5feb\u7167\u4fe1\u606f\uff1a" + orderId));
        BigDecimal amount = payReqDtoList.stream().map(DgBasePayReqDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        AccountPreemptionReqDto preemptionReqDto = new AccountPreemptionReqDto();
        preemptionReqDto.setOrderNo(performOrderInfo.getSaleOrderNo());
        preemptionReqDto.setCustomerId(performOrderSnapshot.getCustomerId());
        preemptionReqDto.setCustomerCode(performOrderSnapshot.getCustomerCode());
        preemptionReqDto.setShopCode(performOrderSnapshot.getShopCode());
        preemptionReqDto.setAmount(amount);
        ArrayList lineList = new ArrayList();
        preemptionReqDto.setOrderLineList(lineList);
        orderLineList.forEach(orderLine -> {
            AccountBalanceOrderLineReqDto dto = new AccountBalanceOrderLineReqDto();
            lineList.add(dto);
            dto.setGiftFlag(orderLine.getGiftFlag());
            dto.setSkuId(orderLine.getSkuId());
            dto.setSkuCode(orderLine.getSkuCode());
            dto.setItemNum(orderLine.getItemNum());
            dto.setSettlementPrice(orderLine.getPayAmount());
        });
        log.info("\u8bf7\u6c42\u8d26\u6237\u5904\u7406\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)preemptionReqDto));
        RestResponseHelper.extractData((RestResponse)this.accountBalanceApiProxy.thawAccountPreemptionBalance(preemptionReqDto));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<List<AccountTradeRespDto>> refund(Long id, List<DgBasePayReqDto> payReqDtoList, DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        log.info("OrderPayExternalActionImpl_\u5b9e\u4ed8\u989d\u5ea6\u9000\u6b3e\uff1a{}\uff0c{}\uff0c{}", new Object[]{id, JSON.toJSONString(payReqDtoList), JSON.toJSON((Object)afterSaleOrderRespDto)});
        BigDecimal amount = payReqDtoList.stream().map(DgBasePayReqDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        AccountPreemptionReqDto preemptionReqDto = new AccountPreemptionReqDto();
        preemptionReqDto.setOrderNo(afterSaleOrderRespDto.getAfterSaleOrderNo());
        preemptionReqDto.setCustomerId(afterSaleOrderRespDto.getCustomerId());
        preemptionReqDto.setCustomerCode(afterSaleOrderRespDto.getCustomerCode());
        preemptionReqDto.setShopCode(afterSaleOrderRespDto.getShopCode());
        preemptionReqDto.setAmount(amount);
        log.info("\u8bf7\u6c42\u8d26\u6237\u5904\u7406\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)preemptionReqDto));
        String flowNo = (String)RestResponseHelper.extractData((RestResponse)this.accountBalanceApiProxy.increaseAccountBalance(preemptionReqDto));
        log.info("\u8bf7\u6c42\u8d26\u6237\u5904\u7406\u54cd\u5e94\uff1a{}", (Object)flowNo);
        List respDtoList = payReqDtoList.stream().map(m -> {
            AccountTradeRespDto respDto = new AccountTradeRespDto();
            respDto.setAccountType(m.getPayMethod());
            respDto.setFlowNo(flowNo);
            return respDto;
        }).collect(Collectors.toList());
        return new RestResponse(respDtoList);
    }

    @Override
    public RestResponse<List<AccountTradeRespDto>> noOrignaleOrderRefund(Long id, List<DgBasePayReqDto> payReqDtoList, DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        log.info("OrderPayExternalActionImpl_\u65e0\u539f\u5355\u9000\u6b3e\uff1a{}\uff0c{}\uff0c{}", new Object[]{id, JSON.toJSONString(payReqDtoList), JSON.toJSON((Object)afterSaleOrderRespDto)});
        BigDecimal amount = payReqDtoList.stream().map(DgBasePayReqDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        AccountPreemptionReqDto preemptionReqDto = new AccountPreemptionReqDto();
        preemptionReqDto.setOrderNo(afterSaleOrderRespDto.getAfterSaleOrderNo());
        preemptionReqDto.setCustomerCode(afterSaleOrderRespDto.getCustomerCode());
        preemptionReqDto.setAmount(amount);
        log.info("\u8bf7\u6c42\u8d26\u6237\u5904\u7406\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)preemptionReqDto));
        String flowNo = (String)RestResponseHelper.extractData((RestResponse)this.accountBalanceApiProxy.increaseAccountBalance(preemptionReqDto));
        log.info("\u8bf7\u6c42\u8d26\u6237\u5904\u7406\u54cd\u5e94\uff1a{}", (Object)flowNo);
        List respDtoList = payReqDtoList.stream().map(m -> {
            AccountTradeRespDto respDto = new AccountTradeRespDto();
            respDto.setAccountType(m.getPayMethod());
            respDto.setFlowNo(flowNo);
            return respDto;
        }).collect(Collectors.toList());
        return new RestResponse(respDtoList);
    }
}

