/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.after.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicalWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderAggDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderComboReqDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderReqDto;
import com.yunxi.dg.base.center.inventory.proxy.order.ITransferOrderApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuDgRespDto;
import com.yunxi.dg.base.center.item.proxy.sku.impl.ItemSkuDgQueryApiProxyImpl;
import com.yunxi.dg.base.center.report.dto.entity.DgOrderAfterReportDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgPhysicsWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgPhysicsWarehousePageReqDto;
import com.yunxi.dg.base.center.report.proxy.inventory.IDgPhysicsWarehouseApiProxy;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.service.after.IAfterSaleOrderInventoryHandleService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AfterSaleOrderInventoryHandleServiceImpl
implements IAfterSaleOrderInventoryHandleService {
    private static final Logger log = LoggerFactory.getLogger(AfterSaleOrderInventoryHandleServiceImpl.class);
    @Resource
    private ITransferOrderApiProxy transferOrderApiProxy;
    @Resource
    private ItemSkuDgQueryApiProxyImpl itemSkuDgQueryApiProxy;
    @Resource
    private ILogicWarehouseApiProxy logicWarehouseApiProxy;
    @Resource
    private IDgPhysicsWarehouseApiProxy physicsWarehouseApiProxy;
    @Resource
    private IDgAfterSaleOrderDomain dgAfterSaleOrderDomain;

    @Override
    public void doGenerateTransferOrder(List<DgOrderAfterReportDto> orderDetails) {
        String inLogicWarehouseCode;
        Set skuCodes = orderDetails.stream().map(DgOrderAfterReportDto::getSkuCode).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toSet());
        HashMap<String, String> skuCode2UnitMap = new HashMap<String, String>();
        List skuSubLists = CollectionUtil.split(skuCodes, (int)500);
        for (List skuCodeList : skuSubLists) {
            skuCode2UnitMap.putAll(((List)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.queryBySkuCode(skuCodeList))).stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, ItemSkuDgRespDto::getUnit, (k1, k2) -> k1)));
        }
        Map<String, List<DgOrderAfterReportDto>> skuDetailMap = orderDetails.stream().collect(Collectors.groupingBy(DgOrderAfterReportDto::getSkuCode));
        List preOrderNoList = orderDetails.stream().map(DgOrderAfterReportDto::getAfterSaleOrderNo).distinct().collect(Collectors.toList());
        Set ids = orderDetails.stream().map(DgOrderAfterReportDto::getAfterSaleOrderId).collect(Collectors.toSet());
        BigDecimal totalQuantity = BigDecimal.ZERO;
        ArrayList transferOrderDetailDtos = Lists.newArrayList();
        ArrayList adjustmentOrderDetailDtos = Lists.newArrayList();
        for (Map.Entry<String, List<DgOrderAfterReportDto>> skuDetailEntry : skuDetailMap.entrySet()) {
            String skuCode = skuDetailEntry.getKey();
            DgOrderAfterReportDto orderLine = skuDetailEntry.getValue().get(0);
            AssertUtils.notNull((Object)orderLine, (String)"\u8ba2\u5355\u884c\u4e0d\u5b58\u5728");
            orderLine.setUnit((String)skuCode2UnitMap.get(orderLine.getSkuCode()));
            this.buildTransferOrderDetail(skuDetailEntry, orderLine, skuCode, transferOrderDetailDtos);
            this.buildAdjustmentOrderDetail(skuDetailEntry, orderLine, adjustmentOrderDetailDtos);
        }
        String outLogicWarehouseCode = orderDetails.get(0).getSettlementWarehouseCode();
        if (Objects.equals(outLogicWarehouseCode, inLogicWarehouseCode = orderDetails.get(0).getReturnWarehouseCode())) {
            log.info("\u8c03\u62e8\u51fa\u4e0e\u8c03\u62e8\u5165\u7684\u903b\u8f91\u4ed3\u4e00\u81f4\uff0c\u65e0\u6cd5\u521b\u5efa\u8c03\u62e8\u5355");
            return;
        }
        LogicalWarehouseRespDto outLogicWarehouseRespDto = (LogicalWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryLogicWarehouseByCode(outLogicWarehouseCode));
        AssertUtils.notNull((Object)outLogicWarehouseRespDto, (String)String.format("\u8c03\u62e8\u5355\u6307\u5b9a\u8c03\u51fa%s\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728", outLogicWarehouseCode));
        LogicalWarehouseRespDto inLogicWarehouseRespDto = (LogicalWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryLogicWarehouseByCode(inLogicWarehouseCode));
        AssertUtils.notNull((Object)inLogicWarehouseRespDto, (String)String.format("\u8c03\u62e8\u5355\u6307\u5b9a\u8c03\u5165%s\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728", inLogicWarehouseCode));
        DgPhysicsWarehousePageReqDto physicsWarehouseQueryDto = new DgPhysicsWarehousePageReqDto();
        physicsWarehouseQueryDto.setWarehouseCode(inLogicWarehouseRespDto.getPhysicsWarehouseCode());
        List dgPhysicsWarehouseDtos = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.physicsWarehouseApiProxy.page(physicsWarehouseQueryDto))).getList();
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dgPhysicsWarehouseDtos), (String)"\u7269\u7406\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
        DgPhysicsWarehouseDto dgPhysicsWarehouseDto = dgPhysicsWarehouseDtos.stream().findFirst().orElse(new DgPhysicsWarehouseDto());
        AdjustmentOrderDto adjustmentOrderDto = this.buildAdjustmentOrderReqDto(inLogicWarehouseRespDto, dgPhysicsWarehouseDto, adjustmentOrderDetailDtos);
        TransferOrderComboReqDto trOrderReqDto = this.buildTransferOrderReqDto(totalQuantity, outLogicWarehouseRespDto, inLogicWarehouseRespDto, dgPhysicsWarehouseDto, transferOrderDetailDtos);
        String transferOrderNo = trOrderReqDto.getTransferOrderReqDto().getSettledTransferOrderNo();
        if (StringUtils.isBlank((CharSequence)transferOrderNo)) {
            log.info("\u751f\u6210\u8c03\u62e8\u5355\u53f7\u5931\u8d25\uff01");
            return;
        }
        log.info("\u751f\u6210\u8c03\u62e8\u5355\u53f7,transferOrderNo:{}", (Object)transferOrderNo);
        TransferOrderAggDto transferOrderAggDto = new TransferOrderAggDto();
        transferOrderAggDto.setAdjustmentOrderDto(adjustmentOrderDto);
        transferOrderAggDto.setTransferOrderComboReqDto(trOrderReqDto);
        transferOrderAggDto.setReverse(Boolean.valueOf(false));
        log.info("\u5e73\u53f0\u5382\u9001\u9000\u8d27\u5165\u5e93\u81ea\u52a8\u4ece\u7ed3\u7b97\u4ed3\u8c03\u62e8\u56de\u552e\u540e\u4ed3-\u5165\u53c2\uff1a{}, \u524d\u7f6e\u5355\u636e\u53f7:{}", JSON.toJSON((Object)transferOrderAggDto), (Object)String.join((CharSequence)",", preOrderNoList));
        List transferOrderNos = (List)RestResponseHelper.extractData((RestResponse)this.transferOrderApiProxy.autoGenerateTransferOrder(transferOrderAggDto));
        if (CollectionUtils.isNotEmpty((Collection)transferOrderNos)) {
            this.dgAfterSaleOrderDomain.batchModifyAfterSaleOrderTransferNoByAfsIds(ids, transferOrderNos.stream().filter(part -> !part.isEmpty()).collect(Collectors.joining(",")));
        }
    }

    private AdjustmentOrderDto buildAdjustmentOrderReqDto(LogicalWarehouseRespDto outLogicWarehouseRespDto, DgPhysicsWarehouseDto dgPhysicsWarehouseDto, List<AdjustmentOrderDetailDto> adjustmentOrderDetailDtos) {
        AdjustmentOrderDto adjumentOrderDto = new AdjustmentOrderDto();
        adjumentOrderDto.setAdjustmentOrderDetailDtos(new ArrayList());
        adjumentOrderDto.setEvent("audit_success");
        adjumentOrderDto.setOrderType("INVENTORY_ADJUSTMENT");
        adjumentOrderDto.setPushSap(Integer.valueOf(0));
        adjumentOrderDto.setPushWms(Integer.valueOf(0));
        adjumentOrderDto.setBusinessType("inventory_adjustment");
        adjumentOrderDto.setBizDate(new Date());
        adjumentOrderDto.setWarehouseCode(outLogicWarehouseRespDto.getWarehouseCode());
        adjumentOrderDto.setWarehouseName(outLogicWarehouseRespDto.getWarehouseName());
        adjumentOrderDto.setOrganizationCode(outLogicWarehouseRespDto.getOrganizationCode());
        adjumentOrderDto.setOrganizationName(outLogicWarehouseRespDto.getOrganizationName());
        adjumentOrderDto.setPhysicsWarehouseCode(dgPhysicsWarehouseDto.getWarehouseCode());
        adjumentOrderDto.setPhysicsWarehouseName(dgPhysicsWarehouseDto.getWarehouseName());
        adjumentOrderDto.setAdjustmentOrderDetailDtos(adjustmentOrderDetailDtos);
        return adjumentOrderDto;
    }

    private TransferOrderComboReqDto buildTransferOrderReqDto(BigDecimal totalQuantity, LogicalWarehouseRespDto outLogicWarehouseRespDto, LogicalWarehouseRespDto inLogicWarehouseRespDto, DgPhysicsWarehouseDto dgPhysicsWarehouseDto, List<TransferOrderDetailReqDto> transferOrderDetailDtos) {
        String transferOrderNo = (String)RestResponseHelper.extractData((RestResponse)this.transferOrderApiProxy.generateTransferOrderNo());
        TransferOrderReqDto transferOrderReqDto = new TransferOrderReqDto();
        transferOrderReqDto.setType("REVERSE_O_TO_O_TRANSFER");
        transferOrderReqDto.setTotalQuantity(totalQuantity);
        transferOrderReqDto.setIsVirtual(Integer.valueOf(0));
        transferOrderReqDto.setSettledTransferOrderNo(transferOrderNo);
        transferOrderReqDto.setOrderType("transfer_order");
        transferOrderReqDto.setOutLogicWarehouseCode(outLogicWarehouseRespDto.getWarehouseCode());
        transferOrderReqDto.setOutLogicWarehouseName(outLogicWarehouseRespDto.getWarehouseName());
        transferOrderReqDto.setOutOrganizationId(outLogicWarehouseRespDto.getOrganizationId());
        transferOrderReqDto.setOutOrganizationCode(outLogicWarehouseRespDto.getOrganizationCode());
        transferOrderReqDto.setOutOrganization(outLogicWarehouseRespDto.getOrganizationName());
        transferOrderReqDto.setInLogicWarehouseCode(inLogicWarehouseRespDto.getWarehouseCode());
        transferOrderReqDto.setInLogicWarehouseName(inLogicWarehouseRespDto.getWarehouseName());
        transferOrderReqDto.setInOrganizationId(inLogicWarehouseRespDto.getOrganizationId());
        transferOrderReqDto.setInOrganizationCode(inLogicWarehouseRespDto.getOrganizationCode());
        transferOrderReqDto.setInOrganization(inLogicWarehouseRespDto.getOrganizationName());
        transferOrderReqDto.setBizDate(new Date());
        transferOrderReqDto.setContact(dgPhysicsWarehouseDto.getContact());
        transferOrderReqDto.setContactPhone(dgPhysicsWarehouseDto.getPhone());
        transferOrderReqDto.setProvince(dgPhysicsWarehouseDto.getProvince());
        transferOrderReqDto.setProvinceCode(dgPhysicsWarehouseDto.getProvinceCode());
        transferOrderReqDto.setCity(dgPhysicsWarehouseDto.getCity());
        transferOrderReqDto.setCityCode(dgPhysicsWarehouseDto.getCityCode());
        transferOrderReqDto.setArea(dgPhysicsWarehouseDto.getDistrict());
        transferOrderReqDto.setAreaCode(dgPhysicsWarehouseDto.getDistrictCode());
        transferOrderReqDto.setAddress(dgPhysicsWarehouseDto.getDetailAddress());
        TransferOrderComboReqDto trOrderReqDto = new TransferOrderComboReqDto();
        trOrderReqDto.setTransferOrderReqDto(transferOrderReqDto);
        trOrderReqDto.setDetailList(transferOrderDetailDtos);
        return trOrderReqDto;
    }

    private void buildAdjustmentOrderDetail(Map.Entry<String, List<DgOrderAfterReportDto>> skuDetailEntry, DgOrderAfterReportDto orderLine, List<AdjustmentOrderDetailDto> adjustmentOrderDetailDtos) {
        AdjustmentOrderDetailDto detailDto = new AdjustmentOrderDetailDto();
        detailDto.setSkuCode(orderLine.getSkuCode());
        detailDto.setChangeType("decrease");
        detailDto.setInventoryProperty("qualified");
        detailDto.setChangeQuantity(skuDetailEntry.getValue().stream().map(DgOrderAfterReportDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
        detailDto.setUnit(orderLine.getUnit());
        detailDto.setPlatformOrderNo(orderLine.getPlatformOrderNo());
        detailDto.setInnerOrderNo(orderLine.getInnerOrderNo());
        detailDto.setOrderItemId(orderLine.getOrderItemId());
        adjustmentOrderDetailDtos.add(detailDto);
    }

    private void buildTransferOrderDetail(Map.Entry<String, List<DgOrderAfterReportDto>> skuDetailEntry, DgOrderAfterReportDto orderLine, String skuCode, List<TransferOrderDetailReqDto> detailReqDtos) {
        TransferOrderDetailReqDto detailReqDto = new TransferOrderDetailReqDto();
        detailReqDto.setQuantity(skuDetailEntry.getValue().stream().map(DgOrderAfterReportDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
        detailReqDto.setSpecification(orderLine.getSkuDesc());
        detailReqDto.setBasicUnit(orderLine.getUnit());
        detailReqDto.setBasicUnitName(orderLine.getUnit());
        detailReqDto.setSkuName(orderLine.getSkuName());
        detailReqDto.setUnit(orderLine.getUnit());
        detailReqDto.setSkuCode(skuCode);
        detailReqDto.setPlatformOrderNo(orderLine.getPlatformOrderNo());
        detailReqDto.setInnerOrderNo(orderLine.getInnerOrderNo());
        detailReqDto.setOrderItemId(orderLine.getOrderItemId());
        detailReqDtos.add(detailReqDto);
    }
}

