/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BAdvanceOrderExtStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BAdvanceOrderStatus;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.data.dto.DictDto;
import com.yunxi.dg.base.center.data.dto.DictValueDto;
import com.yunxi.dg.base.center.data.proxy.api.IDictApiProxy;
import com.yunxi.dg.base.center.data.proxy.api.IDictQueryApiProxy;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAdvanceOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceOrderItemLinePageReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceOrderItemLinePageRespDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.advance.DgAdvanceOrderAdditiveRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.advance.DgAdvanceOrderAdditiveRuleRespDto;
import com.yunxi.dg.base.center.trade.eo.DgAdvanceOrderItemLineEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgAdvanceOrderAdditiveRuleService;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgAdvanceOrderAdditiveRuleServiceImpl
implements IDgAdvanceOrderAdditiveRuleService {
    private static final Logger log = LoggerFactory.getLogger(DgAdvanceOrderAdditiveRuleServiceImpl.class);
    @Resource
    private IDictQueryApiProxy dictQueryApiProxy;
    @Resource
    private IDictApiProxy dictApiProxy;
    @Resource
    private IDgAdvanceOrderItemLineDomain dgAdvanceOrderItemLineDomain;
    private static final String DICT_GROUP_CODE = "yunxi-dg-base-center-trade";
    private static final String DICT_CODE = "advance_order_additive_rule";

    @Override
    public void configAdditiveRule(DgAdvanceOrderAdditiveRuleReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto.getInputTimeDays(), (String)"\u4ea7\u54c1\u5165\u5e93\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto.getAdditiveRatio(), (String)"\u4ea7\u54c1\u5165\u5e93\u5929\u6570\u540e\u52a0\u4ef7\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto.getDelayDays(), (String)"\u5ef6\u8fdf\u5929\u6570\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto.getDelayAdditiveRatio(), (String)"\u5ef6\u8fdf\u5929\u6570\u5468\u671f\u52a0\u4ef7\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApiProxy.queryByGroupCodeAndCode(DICT_GROUP_CODE, DICT_CODE));
        AssertUtils.notNull((Object)dictDto, (String)"\u672a\u627e\u5230\u52a0\u4ef7\u89c4\u5219\u521d\u59cb\u5316\u914d\u7f6e");
        AssertUtils.isTrue((CollectionUtils.isNotEmpty((Collection)dictDto.getDictValueList()) && dictDto.getDictValueList().size() == 4 ? 1 : 0) != 0, (String)"\u52a0\u4ef7\u89c4\u5219\u521d\u59cb\u5316\u914d\u7f6e\u4e0d\u5b8c\u6574");
        List dictValueList = dictDto.getDictValueList().stream().sorted(Comparator.comparing(DictValueDto::getSort)).collect(Collectors.toList());
        DictValueDto dictValueDto0 = (DictValueDto)dictValueList.get(0);
        dictValueDto0.setValue(reqDto.getInputTimeDays().toString());
        DictValueDto dictValueDto1 = (DictValueDto)dictValueList.get(1);
        dictValueDto1.setValue(reqDto.getAdditiveRatio().setScale(2, RoundingMode.HALF_UP).toPlainString());
        DictValueDto dictValueDto2 = (DictValueDto)dictValueList.get(2);
        dictValueDto2.setValue(reqDto.getDelayDays().toString());
        DictValueDto dictValueDto3 = (DictValueDto)dictValueList.get(3);
        dictValueDto3.setValue(reqDto.getDelayAdditiveRatio().setScale(2, RoundingMode.HALF_UP).toPlainString());
        List<DictValueDto> newDictValueList = Arrays.asList(dictValueDto0, dictValueDto1, dictValueDto2, dictValueDto3);
        dictDto.setDictValueList(newDictValueList);
        RestResponseHelper.checkOrThrow((RestResponse)this.dictApiProxy.modifyDict(dictDto));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void calcAdditivePriceByRule() {
        DgAdvanceOrderAdditiveRuleRespDto additiveRule = this.getAdditiveRule();
        int inputTimeDays = additiveRule.getInputTimeDays();
        BigDecimal additiveRatio = additiveRule.getAdditiveRatio().divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP);
        int delayDays = additiveRule.getDelayDays();
        BigDecimal delayAdditiveRatio = additiveRule.getDelayAdditiveRatio().divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP);
        if (inputTimeDays <= 0 && delayDays <= 0 && additiveRatio.compareTo(BigDecimal.ZERO) <= 0 && delayAdditiveRatio.compareTo(BigDecimal.ZERO) <= 0) {
            log.info("[\u8ba1\u7b97\u9884\u8ba2\u5355\u52a0\u4ef7\u5355\u4ef7]\u52a0\u4ef7\u89c4\u5219\u7684\u914d\u7f6e\u5168\u4e3a0");
            return;
        }
        int pageSize = 1000;
        int pageNum = 1;
        int size = 0;
        do {
            DgAdvanceOrderItemLinePageReqDto reqDto = new DgAdvanceOrderItemLinePageReqDto();
            reqDto.setPageSize(Integer.valueOf(pageSize));
            reqDto.setPageNum(Integer.valueOf(pageNum));
            reqDto.setOrderStatus(DgF2BAdvanceOrderStatus.CHECKED.getCode());
            reqDto.setOrderType(DgF2BAdvanceOrderExtStatus.CUSTOM_ORDER.getCode());
            reqDto.setEntryStatus(YesNoEnum.YES.getValue());
            PageInfo page = this.dgAdvanceOrderItemLineDomain.queryByPage(reqDto);
            size = page.getSize();
            ++pageNum;
            ArrayList<DgAdvanceOrderItemLineEo> updateList = new ArrayList<DgAdvanceOrderItemLineEo>();
            Date now = new Date();
            for (DgAdvanceOrderItemLinePageRespDto itemLineDto : page.getList()) {
                Date date1 = com.dtyunxi.util.DateUtil.addDay((Date)itemLineDto.getEntryTime(), (int)inputTimeDays);
                Date date2 = com.dtyunxi.util.DateUtil.addDay((Date)itemLineDto.getEntryTime(), (int)(inputTimeDays + delayDays));
                DgAdvanceOrderItemLineEo updateLineEo = new DgAdvanceOrderItemLineEo();
                updateLineEo.setId(itemLineDto.getId());
                updateLineEo.setAdditivePrice(itemLineDto.getAdditivePrice());
                if (now.getTime() >= date1.getTime()) {
                    BigDecimal salePrice = itemLineDto.getSalePrice();
                    itemLineDto.setAdditivePrice(salePrice.add(salePrice.multiply(additiveRatio)));
                    updateLineEo.setAdditivePrice(itemLineDto.getAdditivePrice());
                    if (now.getTime() >= date2.getTime()) {
                        BigDecimal additivePrice = itemLineDto.getAdditivePrice();
                        int differDay = (int)DateUtil.between((Date)date1, (Date)now, (DateUnit)DateUnit.DAY);
                        int loopTimes = differDay / delayDays;
                        for (int i = 0; i < loopTimes; ++i) {
                            additivePrice = additivePrice.add(additivePrice.multiply(delayAdditiveRatio));
                        }
                        itemLineDto.setAdditivePrice(additivePrice);
                        updateLineEo.setAdditivePrice(itemLineDto.getAdditivePrice());
                    }
                } else {
                    updateLineEo.setAdditivePrice(itemLineDto.getSalePrice());
                }
                updateList.add(updateLineEo);
            }
            if (!CollectionUtils.isNotEmpty(updateList)) continue;
            this.dgAdvanceOrderItemLineDomain.updateAdditivePriceBatch(updateList);
        } while (size > 0);
    }

    @Override
    public DgAdvanceOrderAdditiveRuleRespDto getAdditiveRule() {
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApiProxy.queryByGroupCodeAndCode(DICT_GROUP_CODE, DICT_CODE));
        AssertUtils.notNull((Object)dictDto, (String)"[\u8ba1\u7b97\u9884\u8ba2\u5355\u52a0\u4ef7\u5355\u4ef7]\u672a\u627e\u5230\u52a0\u4ef7\u89c4\u5219\u521d\u59cb\u5316\u914d\u7f6e");
        AssertUtils.isTrue((CollectionUtils.isNotEmpty((Collection)dictDto.getDictValueList()) && dictDto.getDictValueList().size() == 4 ? 1 : 0) != 0, (String)"[\u8ba1\u7b97\u9884\u8ba2\u5355\u52a0\u4ef7\u5355\u4ef7]\u52a0\u4ef7\u89c4\u5219\u521d\u59cb\u5316\u914d\u7f6e\u4e0d\u5b8c\u6574");
        List dictValueList = dictDto.getDictValueList().stream().sorted(Comparator.comparing(DictValueDto::getSort)).collect(Collectors.toList());
        DictValueDto dictValueDto0 = (DictValueDto)dictValueList.get(0);
        int inputTimeDays = Integer.parseInt(dictValueDto0.getValue());
        DictValueDto dictValueDto1 = (DictValueDto)dictValueList.get(1);
        BigDecimal additiveRatio = new BigDecimal(dictValueDto1.getValue()).setScale(2, RoundingMode.HALF_UP);
        DictValueDto dictValueDto2 = (DictValueDto)dictValueList.get(2);
        int delayDays = Integer.parseInt(dictValueDto2.getValue());
        DictValueDto dictValueDto3 = (DictValueDto)dictValueList.get(3);
        BigDecimal delayAdditiveRatio = new BigDecimal(dictValueDto3.getValue());
        DgAdvanceOrderAdditiveRuleRespDto ruleRespDto = new DgAdvanceOrderAdditiveRuleRespDto();
        ruleRespDto.setInputTimeDays(Integer.valueOf(inputTimeDays));
        ruleRespDto.setAdditiveRatio(additiveRatio);
        ruleRespDto.setDelayDays(Integer.valueOf(delayDays));
        ruleRespDto.setDelayAdditiveRatio(delayAdditiveRatio);
        return ruleRespDto;
    }
}

