/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BAdvanceOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemMediasDgRespDto;
import com.yunxi.dg.base.center.price.dto.request.SkuSupplyPriceQueryV2ReqDto;
import com.yunxi.dg.base.center.price.dto.response.SkuPolicyPriceRespDto;
import com.yunxi.dg.base.center.price.proxy.query.IDgPriceQueryV2ApiProxy;
import com.yunxi.dg.base.center.report.dto.item.ItemSkuDgDto;
import com.yunxi.dg.base.center.report.dto.item.ShopItemEsRespDto;
import com.yunxi.dg.base.center.report.dto.request.DgEsCustomerBuyScopeItemQueryDto;
import com.yunxi.dg.base.center.report.proxy.customer.IDgCustomerBuyScopeItemQueryApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.channel.IPreInfoQueryAction;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAdvanceOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAdvanceOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceOrderItemLinePageReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceOrderItemLinePageRespDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.advance.DgAdvanceOrderItemLineReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.advance.DgAdvanceOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.advance.DgAdvanceOrderItemLineRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.advance.DgAdvanceOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.AdvanceOrderItemLineStatusEnum;
import com.yunxi.dg.base.center.trade.eo.DgAdvanceOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgAdvanceOrderItemLineEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgAdvanceOrderItemLineService;
import com.yunxi.dg.base.center.trade.utils.UnitConverUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgAdvanceOrderItemLineServiceImpl
implements IDgAdvanceOrderItemLineService {
    @Resource
    private IPreInfoQueryAction preInfoQueryAction;
    @Resource
    private IDgAdvanceOrderItemLineDomain dgAdvanceOrderItemLineDomain;
    @Resource
    private IDgAdvanceOrderDomain dgAdvanceOrderDomain;
    @Resource
    private IDgPriceQueryV2ApiProxy dgPriceQueryV2ApiProxy;
    @Resource
    private IDgCustomerBuyScopeItemQueryApiProxy dgCustomerBuyScopeItemQueryApiProxy;
    private static final int priceScale = 4;
    private static final int amountScale = 2;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void wasteItemLineById(Long id) {
        AssertUtils.notNull((Object)id, (String)"\u5546\u54c1\u884cid\u4e0d\u80fd\u4e3a\u7a7a");
        DgAdvanceOrderItemLineEo itemLineEo = (DgAdvanceOrderItemLineEo)this.dgAdvanceOrderItemLineDomain.selectByPrimaryKey(id);
        AssertUtils.notNull((Object)itemLineEo, (String)"\u5546\u54c1\u884c\u4e0d\u5b58\u5728");
        DgAdvanceOrderRespDto orderDto = this.dgAdvanceOrderDomain.queryByOrderId(itemLineEo.getOrderId());
        AssertUtils.notNull((Object)orderDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        AssertUtils.isTrue((DgF2BAdvanceOrderStatus.WAIT_CHECK.getCode().equals(orderDto.getOrderStatus()) || DgF2BAdvanceOrderStatus.CHECKED.getCode().equals(orderDto.getOrderStatus()) ? 1 : 0) != 0, (String)"\u975e'\u5f85\u786e\u8ba4'/'\u5df2\u786e\u8ba4'\u72b6\u6001\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u5ba2\u6237");
        AssertUtils.isTrue((boolean)AdvanceOrderItemLineStatusEnum.NOT_DELIVERY.getStatus().equals(itemLineEo.getDeliveryPlan()), (String)"\u5df2\u751f\u6210\u843d\u8d27\u8ba1\u5212\uff0c\u5219\u5148\u53d6\u6d88\u843d\u8d27\u8ba1\u5212\u540e\u4fee\u6539");
        AssertUtils.isFalse((itemLineEo.getDeliveryNum().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u8be5\u5546\u54c1\u5df2\u4e0b\u5355\uff0c\u4e0d\u53ef\u4f5c\u5e9f");
        if (DgF2BAdvanceOrderStatus.CHECKED.getCode().equals(orderDto.getOrderStatus())) {
            List itemLineDtoList = orderDto.getItemLineDtoList().stream().filter(l -> Objects.equals(l.getStatus(), AdvanceOrderItemLineStatusEnum.NORMAL.getStatus())).collect(Collectors.toList());
            AssertUtils.isFalse((CollectionUtils.isNotEmpty(itemLineDtoList) && itemLineDtoList.size() == 1 ? 1 : 0) != 0, (String)"\u5df2\u786e\u8ba4\u7684\u9884\u8ba2\u5355\u4e0d\u53ef\u4f5c\u5e9f\u5168\u90e8\u5546\u54c1");
        }
        itemLineEo.setStatus(Integer.valueOf(1));
        itemLineEo.setWasteTime(new Date());
        itemLineEo.setAdvanceAmount(BigDecimal.ZERO.setScale(2));
        this.dgAdvanceOrderItemLineDomain.updateSelective((BaseEo)itemLineEo);
        BigDecimal advanceAmount = orderDto.getAdvanceAmount();
        BigDecimal totalAmount = orderDto.getTotalAmount().subtract(itemLineEo.getTotalAmount());
        BigDecimal depositRatio = BigDecimal.ZERO;
        if (totalAmount.compareTo(BigDecimal.ZERO) > 0) {
            depositRatio = advanceAmount.divide(totalAmount.setScale(6), 6, RoundingMode.HALF_UP);
        }
        DgAdvanceOrderEo orderEo = new DgAdvanceOrderEo();
        orderEo.setId(orderDto.getId());
        orderEo.setTotalAmount(totalAmount);
        orderEo.setDepositRatio(depositRatio.setScale(4, RoundingMode.HALF_UP).multiply(new BigDecimal("100")));
        this.dgAdvanceOrderDomain.updateSelective((BaseEo)orderEo);
        ArrayList<DgAdvanceOrderItemLineEo> orderItemLineUpdateEoList = new ArrayList<DgAdvanceOrderItemLineEo>();
        for (DgAdvanceOrderItemLineRespDto itemLineRespDto : orderDto.getItemLineDtoList()) {
            if (itemLineRespDto.getDeliveryNum().compareTo(BigDecimal.ZERO) != 0 || !Objects.equals(itemLineRespDto.getStatus(), AdvanceOrderItemLineStatusEnum.NORMAL.getStatus()) || Objects.equals(itemLineRespDto.getId(), id)) continue;
            DgAdvanceOrderItemLineEo itemLineUpdateEo = new DgAdvanceOrderItemLineEo();
            itemLineUpdateEo.setId(itemLineRespDto.getId());
            itemLineUpdateEo.setAdvanceAmount(itemLineRespDto.getTotalAmount().multiply(depositRatio).setScale(2, RoundingMode.HALF_DOWN));
            orderItemLineUpdateEoList.add(itemLineUpdateEo);
        }
        if (CollectionUtils.isNotEmpty(orderItemLineUpdateEoList)) {
            this.dgAdvanceOrderItemLineDomain.updateAdditivePriceBatch(orderItemLineUpdateEoList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateItemLineByOrderId(DgAdvanceOrderItemLineReqDto itemLineReqDto) {
        AssertUtils.notNull((Object)itemLineReqDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)itemLineReqDto.getOrderId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)itemLineReqDto.getId(), (String)"\u5546\u54c1\u884cid\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)itemLineReqDto.getSkuId(), (String)"skuId\u4e0d\u80fd\u4e3a\u7a7a");
        DgAdvanceOrderEo orderEo = (DgAdvanceOrderEo)this.dgAdvanceOrderDomain.selectByPrimaryKey(itemLineReqDto.getOrderId());
        AssertUtils.notNull((Object)orderEo, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        DgAdvanceOrderItemLineEo itemLineEo = (DgAdvanceOrderItemLineEo)this.dgAdvanceOrderItemLineDomain.selectByPrimaryKey(itemLineReqDto.getId());
        AssertUtils.notNull((Object)itemLineEo, (String)"\u5546\u54c1\u884c\u4e0d\u5b58\u5728");
        AssertUtils.isTrue((boolean)itemLineEo.getOrderId().equals(orderEo.getId()), (String)"\u8be5\u8ba2\u5355\u5546\u54c1\u884c\u4e0d\u5b58\u5728");
        AssertUtils.isTrue((DgF2BAdvanceOrderStatus.WAIT_CHECK.getCode().equals(orderEo.getOrderStatus()) || DgF2BAdvanceOrderStatus.CHECKED.getCode().equals(orderEo.getOrderStatus()) ? 1 : 0) != 0, (String)"\u975e'\u5f85\u786e\u8ba4'/'\u5df2\u786e\u8ba4'\u72b6\u6001\u4e0d\u5141\u8bb8\u66f4\u6362\u5546\u54c1");
        AssertUtils.isTrue((boolean)AdvanceOrderItemLineStatusEnum.NOT_DELIVERY.getStatus().equals(itemLineEo.getDeliveryPlan()), (String)"\u5df2\u751f\u6210\u843d\u8d27\u8ba1\u5212\uff0c\u5219\u5148\u53d6\u6d88\u843d\u8d27\u8ba1\u5212\u540e\u4fee\u6539");
        AssertUtils.isFalse((itemLineEo.getDeliveryNum().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u8be5\u5546\u54c1\u5df2\u4e0b\u5355\uff0c\u4e0d\u5141\u8bb8\u66f4\u6362\u5546\u54c1");
        List<Long> shopIds = Collections.singletonList(orderEo.getShopId());
        List<Long> skuIds = Collections.singletonList(itemLineReqDto.getSkuId());
        PageInfo<DgItemSkuPageRespDto> pageInfo = this.preInfoQueryAction.queryItemShopListByPage(shopIds, skuIds, null, Lists.newArrayList((Object[])new Integer[]{YesNoEnum.YES.getValue()}));
        DgItemSkuPageRespDto itemSkuDto = pageInfo.getList().stream().filter(o -> o.getId().equals(itemLineReqDto.getSkuId())).findFirst().orElse(null);
        AssertUtils.notNull((Object)itemSkuDto, (String)"\u8be5sku\u672a\u627e\u5230\u4e0a\u67b6\u4fe1\u606f");
        DgAdvanceOrderItemLineEo orderItemLineUpdateEo = new DgAdvanceOrderItemLineEo();
        if (Objects.equals(itemLineEo.getVirtualItem(), YesNoEnum.YES.getValue())) {
            SkuSupplyPriceQueryV2ReqDto priceQueryReqDto = new SkuSupplyPriceQueryV2ReqDto();
            priceQueryReqDto.setSaleCompanyId(orderEo.getOrganizationId());
            priceQueryReqDto.setShopId(orderEo.getShopId());
            priceQueryReqDto.setSkuId(itemLineReqDto.getSkuId());
            List<SkuSupplyPriceQueryV2ReqDto> priceReqDtoList = Collections.singletonList(priceQueryReqDto);
            List priceRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgPriceQueryV2ApiProxy.queryCustomerSkuPolicySupplyPrice(orderEo.getCustomerId(), priceReqDtoList));
            SkuPolicyPriceRespDto skuIdPolicyPriceDto = ((List)Optional.ofNullable(priceRespDtoList).orElse(new ArrayList())).stream().filter(o -> o.getSkuId().equals(itemLineReqDto.getSkuId())).findFirst().orElse(null);
            AssertUtils.notNull((Object)skuIdPolicyPriceDto, (String)"\u8be5sku\u672a\u627e\u5230\u4ef7\u683c\u653f\u7b56");
            BigDecimal supplyPrice = skuIdPolicyPriceDto.getSupplyPrice();
            AssertUtils.notNull((Object)supplyPrice, (String)("\u8d27\u54c1" + itemLineReqDto.getSkuId() + "\u672a\u627e\u5230\u4f9b\u8d27\u4ef7"));
            orderItemLineUpdateEo.setSupplyPrice(supplyPrice);
            BigDecimal salePrice = this.numScale(itemLineEo.getSalePrice(), 4);
            BigDecimal oneHundred = this.numScale(new BigDecimal("100"), 4);
            orderItemLineUpdateEo.setHandmadeDiscount(salePrice.multiply(oneHundred).divide(orderItemLineUpdateEo.getSupplyPrice(), 2, RoundingMode.HALF_UP));
        }
        orderItemLineUpdateEo.setId(itemLineReqDto.getId());
        orderItemLineUpdateEo.setSkuId(itemSkuDto.getId());
        orderItemLineUpdateEo.setSkuCode(itemSkuDto.getSkuCode());
        orderItemLineUpdateEo.setSkuName(itemSkuDto.getSkuName());
        orderItemLineUpdateEo.setItemName(itemSkuDto.getItemName());
        orderItemLineUpdateEo.setImgUrl(CollectionUtil.isNotEmpty((Collection)itemSkuDto.getImgUrlList()) ? ((ItemMediasDgRespDto)itemSkuDto.getImgUrlList().get(0)).getPath1() : (CollectionUtil.isNotEmpty((Collection)itemSkuDto.getMediaMainList()) ? ((ItemMediasDgRespDto)itemSkuDto.getMediaMainList().get(0)).getPath1() : null));
        orderItemLineUpdateEo.setUnitCode(itemSkuDto.getUnit());
        orderItemLineUpdateEo.setUnitName(itemSkuDto.getUnitName());
        orderItemLineUpdateEo.setVirtualItem(YesNoEnum.NO.getValue());
        orderItemLineUpdateEo.setPurchaseChannel(itemSkuDto.getPurchaseChannel());
        orderItemLineUpdateEo.setItemNum(itemLineEo.getItemNum());
        orderItemLineUpdateEo.setWeightUnit(StringUtils.isBlank((CharSequence)itemSkuDto.getWeightUnit()) ? "kg" : itemSkuDto.getWeightUnit());
        BigDecimal weight = UnitConverUtil.toKg(Optional.ofNullable(itemSkuDto.getGrossWeight()).orElse(BigDecimal.ZERO), itemSkuDto.getWeightUnit());
        orderItemLineUpdateEo.setWeight(weight.multiply(orderItemLineUpdateEo.getItemNum()));
        BigDecimal volume = UnitConverUtil.convertToCubicMeter(Optional.ofNullable(itemSkuDto.getVolume()).orElse(BigDecimal.ZERO), itemSkuDto.getVolumeUnit());
        orderItemLineUpdateEo.setVolume(volume.multiply(orderItemLineUpdateEo.getItemNum()));
        orderItemLineUpdateEo.setPackageNum(itemSkuDto.getPackageNum());
        if (DgF2BAdvanceOrderStatus.CHECKED.getCode().equals(orderEo.getOrderStatus())) {
            orderItemLineUpdateEo.setInputTime(new Date());
        }
        this.dgAdvanceOrderItemLineDomain.updateSelective((BaseEo)orderItemLineUpdateEo);
    }

    private BigDecimal numScale(BigDecimal value, int scale) {
        if (Objects.isNull(value)) {
            return BigDecimal.ZERO;
        }
        return value.setScale(scale, RoundingMode.HALF_UP);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addItemLineByOrderId(DgAdvanceOrderReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto.getId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)reqDto.getItemLineDtoList()), (String)"\u8ba2\u5355\u5546\u54c1\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        DgAdvanceOrderRespDto orderDto = this.dgAdvanceOrderDomain.queryByOrderId(reqDto.getId());
        AssertUtils.isTrue((Objects.equals(orderDto.getOrderStatus(), DgF2BAdvanceOrderStatus.WAIT_CHECK.getCode()) || Objects.equals(orderDto.getOrderStatus(), DgF2BAdvanceOrderStatus.CHECKED.getCode()) ? 1 : 0) != 0, (String)"\u8ba2\u5355\u8ba2\u5355\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1");
        List itemLineDtoList = orderDto.getItemLineDtoList();
        Map<Long, DgAdvanceOrderItemLineRespDto> itemLineDtoMap = itemLineDtoList.stream().filter(o -> Objects.equals(o.getStatus(), AdvanceOrderItemLineStatusEnum.NORMAL.getStatus())).collect(Collectors.toMap(DgAdvanceOrderItemLineDto::getSkuId, Function.identity(), (k1, k2) -> k1));
        BigDecimal advanceAmount = orderDto.getAdvanceAmount();
        BigDecimal orderTotalAddAmount = orderDto.getTotalAmount();
        HashMap<Long, DgItemSkuPageRespDto> skuIdDtoMap = new HashMap<Long, DgItemSkuPageRespDto>();
        HashMap<Long, ItemSkuDgDto> skuDgDtoMap = new HashMap<Long, ItemSkuDgDto>();
        HashMap<Long, SkuPolicyPriceRespDto> policyPriceMap = new HashMap<Long, SkuPolicyPriceRespDto>();
        orderTotalAddAmount = this.fillItemData(reqDto, orderDto, orderTotalAddAmount, itemLineDtoMap, skuIdDtoMap, skuDgDtoMap, policyPriceMap);
        BigDecimal orderSubAdvanceAmount = advanceAmount;
        BigDecimal orderTotalSubAmount = orderTotalAddAmount;
        for (DgAdvanceOrderItemLineRespDto itemLineRespDto : orderDto.getItemLineDtoList()) {
            if (itemLineRespDto.getDeliveryNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            orderTotalSubAmount = orderTotalSubAmount.subtract(itemLineRespDto.getTotalAmount());
            orderSubAdvanceAmount = orderSubAdvanceAmount.subtract(itemLineRespDto.getAdvanceAmount());
        }
        BigDecimal depositRatio = orderSubAdvanceAmount.setScale(6).divide(orderTotalSubAmount.setScale(6), 4, RoundingMode.HALF_UP);
        orderDto.setDepositRatio(depositRatio.multiply(new BigDecimal("100")));
        orderDto.setTotalAmount(orderTotalAddAmount);
        ArrayList<DgAdvanceOrderItemLineEo> orderItemLineUpdateEoList = new ArrayList<DgAdvanceOrderItemLineEo>();
        for (Object itemLineRespDto : orderDto.getItemLineDtoList()) {
            if (itemLineRespDto.getDeliveryNum().compareTo(BigDecimal.ZERO) != 0 || !Objects.equals(itemLineRespDto.getStatus(), AdvanceOrderItemLineStatusEnum.NORMAL.getStatus())) continue;
            DgAdvanceOrderItemLineEo itemLineEo = new DgAdvanceOrderItemLineEo();
            itemLineEo.setId(itemLineRespDto.getId());
            itemLineEo.setAdvanceAmount(itemLineRespDto.getTotalAmount().multiply(depositRatio).setScale(2, RoundingMode.HALF_UP));
            orderItemLineUpdateEoList.add(itemLineEo);
        }
        ArrayList<DgAdvanceOrderItemLineEo> orderItemLineEoList = new ArrayList<DgAdvanceOrderItemLineEo>();
        for (DgAdvanceOrderItemLineReqDto orderItemLineDto : reqDto.getItemLineDtoList()) {
            if (!Objects.isNull(orderItemLineDto.getId())) continue;
            DgAdvanceOrderItemLineEo itemLineEo = (DgAdvanceOrderItemLineEo)BeanUtil.toBean((Object)orderItemLineDto, DgAdvanceOrderItemLineEo.class);
            ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuDgDtoMap.get(orderItemLineDto.getSkuId());
            DgItemSkuPageRespDto skuPageRespDto = (DgItemSkuPageRespDto)skuIdDtoMap.get(orderItemLineDto.getSkuId());
            SkuPolicyPriceRespDto policyPriceRespDto = (SkuPolicyPriceRespDto)policyPriceMap.get(orderItemLineDto.getSkuId());
            AssertUtils.notNull((Object)skuPageRespDto, (String)String.format("\u5546\u54c1\u4e0a\u67b6\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a%s", orderItemLineDto.getSkuId()));
            AssertUtils.notNull((Object)itemSkuDgDto, (String)String.format("\u5546\u54c1\u5141\u8d2d\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a%s", orderItemLineDto.getSkuId()));
            AssertUtils.notNull((Object)policyPriceRespDto, (String)String.format("\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a%s", orderItemLineDto.getSkuId()));
            itemLineEo.setSkuCode(skuPageRespDto.getSkuCode());
            itemLineEo.setSkuName(skuPageRespDto.getSkuName());
            itemLineEo.setItemName(skuPageRespDto.getItemName());
            itemLineEo.setUnitCode(skuPageRespDto.getUnit());
            itemLineEo.setUnitName(skuPageRespDto.getUnitName());
            itemLineEo.setOrderId(orderDto.getId());
            itemLineEo.setOrderNo(orderDto.getOrderNo());
            itemLineEo.setStatus(AdvanceOrderItemLineStatusEnum.NORMAL.getStatus());
            itemLineEo.setEntryStatus(AdvanceOrderItemLineStatusEnum.NOT_ENTRY.getStatus());
            itemLineEo.setDeliveryPlan(AdvanceOrderItemLineStatusEnum.NOT_DELIVERY.getStatus());
            if (DgF2BAdvanceOrderStatus.CHECKED.getCode().equals(orderDto.getOrderStatus())) {
                itemLineEo.setInputTime(new Date());
            }
            itemLineEo.setSupplyPrice(policyPriceRespDto.getSupplyPrice());
            itemLineEo.setAdditivePrice(itemLineEo.getSalePrice());
            itemLineEo.setRemainNum(itemLineEo.getItemNum());
            itemLineEo.setHandmadeDiscount(orderItemLineDto.getSalePrice().setScale(6, RoundingMode.HALF_DOWN).multiply(new BigDecimal("100")).divide(itemLineEo.getSupplyPrice(), 2, RoundingMode.HALF_DOWN));
            itemLineEo.setAdvanceAmount(itemLineEo.getTotalAmount().multiply(depositRatio).setScale(2, RoundingMode.HALF_UP));
            itemLineEo.setImgUrl(CollectionUtil.isNotEmpty((Collection)skuPageRespDto.getImgUrlList()) ? ((ItemMediasDgRespDto)skuPageRespDto.getImgUrlList().get(0)).getPath1() : (CollectionUtil.isNotEmpty((Collection)skuPageRespDto.getMediaMainList()) ? ((ItemMediasDgRespDto)skuPageRespDto.getMediaMainList().get(0)).getPath1() : null));
            orderItemLineEoList.add(itemLineEo);
        }
        this.dgAdvanceOrderItemLineDomain.insertBatch(orderItemLineEoList);
        this.dgAdvanceOrderItemLineDomain.updateAdditivePriceBatch(orderItemLineUpdateEoList);
        DgAdvanceOrderEo advanceOrderEo = new DgAdvanceOrderEo();
        advanceOrderEo.setId(orderDto.getId());
        advanceOrderEo.setDepositRatio(orderDto.getDepositRatio());
        advanceOrderEo.setTotalAmount(orderDto.getTotalAmount());
        this.dgAdvanceOrderDomain.updateSelective((BaseEo)advanceOrderEo);
    }

    @Override
    public PageInfo<DgAdvanceOrderItemLinePageRespDto> queryByPage(DgAdvanceOrderItemLinePageReqDto reqDto) {
        return this.dgAdvanceOrderItemLineDomain.queryByPage(reqDto);
    }

    @Override
    public List<DgAdvanceOrderItemLinePageRespDto> queryByList(DgAdvanceOrderItemLinePageReqDto reqDto) {
        return this.dgAdvanceOrderItemLineDomain.queryByList(reqDto);
    }

    private BigDecimal fillItemData(DgAdvanceOrderReqDto reqDto, DgAdvanceOrderRespDto orderDto, BigDecimal orderTotalAddAmount, Map<Long, DgAdvanceOrderItemLineRespDto> itemLineDtoMap, Map<Long, DgItemSkuPageRespDto> skuIdDtoMap, Map<Long, ItemSkuDgDto> skuDgDtoMap, Map<Long, SkuPolicyPriceRespDto> policyPriceMap) {
        ArrayList<SkuSupplyPriceQueryV2ReqDto> priceReqDtoList = new ArrayList<SkuSupplyPriceQueryV2ReqDto>();
        for (DgAdvanceOrderItemLineReqDto orderItemLineDto : reqDto.getItemLineDtoList()) {
            if (!Objects.isNull(orderItemLineDto.getId())) continue;
            AssertUtils.notNull((Object)orderItemLineDto.getSkuId(), (String)"skuId\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)orderItemLineDto.getItemId(), (String)"\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)orderItemLineDto.getItemNum(), (String)"\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)orderItemLineDto.getSalePrice(), (String)"\u7533\u8bf7\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            DgAdvanceOrderItemLineRespDto itemLineRespDto = itemLineDtoMap.get(orderItemLineDto.getSkuId());
            if (Objects.nonNull(itemLineRespDto)) {
                throw new BizException(StrUtil.format((CharSequence)"\u5546\u54c1SKU\uff1a{}\u5df2\u5b58\u5728\u4e8e\u8ba2\u5355\u4e2d", (Object[])new Object[]{itemLineRespDto.getSkuCode()}));
            }
            BigDecimal totalAmount = orderItemLineDto.getItemNum().multiply(orderItemLineDto.getSalePrice());
            orderTotalAddAmount = orderTotalAddAmount.add(totalAmount);
            orderItemLineDto.setTotalAmount(totalAmount);
            SkuSupplyPriceQueryV2ReqDto skuSupplyPriceQueryV2ReqDto = new SkuSupplyPriceQueryV2ReqDto();
            skuSupplyPriceQueryV2ReqDto.setSkuId(orderItemLineDto.getSkuId());
            skuSupplyPriceQueryV2ReqDto.setSaleCompanyId(orderDto.getOrganizationId());
            skuSupplyPriceQueryV2ReqDto.setShopId(orderDto.getShopId());
            priceReqDtoList.add(skuSupplyPriceQueryV2ReqDto);
        }
        List<Long> skuIds = reqDto.getItemLineDtoList().stream().map(DgAdvanceOrderItemLineReqDto::getSkuId).collect(Collectors.toList());
        List<Long> itemIdList = reqDto.getItemLineDtoList().stream().map(DgAdvanceOrderItemLineReqDto::getItemId).collect(Collectors.toList());
        DgEsCustomerBuyScopeItemQueryDto queryDto = new DgEsCustomerBuyScopeItemQueryDto();
        queryDto.setShopId(orderDto.getShopId());
        queryDto.setCustomerId(orderDto.getCustomerId());
        queryDto.setShelfStatus(YesNoEnum.YES.getValue());
        queryDto.setSkuIdList(skuIds);
        queryDto.setStatus(YesNoEnum.NO.getValue());
        queryDto.setPageSize(Integer.valueOf(1000));
        PageInfo itemRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dgCustomerBuyScopeItemQueryApiProxy.queryTobEsBuyScopeItemPage(queryDto));
        AssertUtils.isTrue((itemRespDtoPageInfo != null && CollectionUtil.isNotEmpty((Collection)itemRespDtoPageInfo.getList()) ? 1 : 0) != 0, (String)"\u6240\u6709\u4e0b\u5355\u5546\u54c1\u67e5\u8be2\u4e0d\u5230\u4e0a\u67b6\u5141\u8d2d\u4fe1\u606f");
        skuDgDtoMap.putAll(itemRespDtoPageInfo.getList().stream().map(ShopItemEsRespDto::getItemSkuList).flatMap(Collection::stream).collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1)));
        PageInfo<DgItemSkuPageRespDto> pageInfo = this.preInfoQueryAction.queryItemShopListByPage(Collections.singletonList(orderDto.getShopId()), skuIds, itemIdList, Lists.newArrayList((Object[])new Integer[]{YesNoEnum.YES.getValue()}));
        skuIdDtoMap.putAll(pageInfo.getList().stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1)));
        List priceRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgPriceQueryV2ApiProxy.queryCustomerSkuPolicySupplyPrice(orderDto.getCustomerId(), priceReqDtoList));
        policyPriceMap.putAll(((List)Optional.ofNullable(priceRespDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(SkuPolicyPriceRespDto::getSkuId, o -> o, (k1, k2) -> k1)));
        return orderTotalAddAmount;
    }
}

