/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.yunxi.dg.base.center.trade.convert.entity.DgPerformOrderLineConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLinePageReqDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformOrderLineService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgPerformOrderLineServiceImpl
extends BaseServiceImpl<DgPerformOrderLineDto, DgPerformOrderLineEo, IDgPerformOrderLineDomain>
implements IDgPerformOrderLineService {
    private final Logger logger = LoggerFactory.getLogger(DgPerformOrderLineServiceImpl.class);
    @Resource
    private IDgPerformOrderItemLineDomain dgPerformOrderItemLineDomain;

    public DgPerformOrderLineServiceImpl(IDgPerformOrderLineDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgPerformOrderLineDto, DgPerformOrderLineEo> converter() {
        return DgPerformOrderLineConverter.INSTANCE;
    }

    @Override
    public List<DgPerformOrderLineDto> queryListByOrderId(Long orderId) {
        this.logger.info("\u67e5\u8be2\u8ba2\u8d27\u5355\u884c\u4fe1\u606f\uff1a{}", (Object)orderId);
        List dgPerformOrderLine = ((IDgPerformOrderLineDomain)this.domain).queryByOrderId(orderId);
        List dgPerformOrderItemLineList = this.dgPerformOrderItemLineDomain.queryInfoByOrderId(orderId);
        Map<Long, List<DgPerformOrderItemLineDto>> dgPerformOrderItemLineGroup = dgPerformOrderItemLineList.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getOrderLineId));
        dgPerformOrderLine.forEach(orderLine -> {
            List dgPerformOrderItemLineDtoList = (List)dgPerformOrderItemLineGroup.get(orderLine.getId());
            BigDecimal returnNum = dgPerformOrderItemLineDtoList.stream().filter(f -> f.getReturnStatus() == 1).map(DgPerformOrderItemLineDto::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderLine.setReturnNum(returnNum);
            BigDecimal deliveryNum = dgPerformOrderItemLineDtoList.stream().filter(f -> f.getDeliveryStatus() == 1).map(DgPerformOrderItemLineDto::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderLine.setDeliveryNum(deliveryNum);
            orderLine.setEnabledReturnNum(BigDecimal.ZERO);
            if (deliveryNum.compareTo(returnNum) >= 0) {
                orderLine.setEnabledReturnNum(deliveryNum.subtract(returnNum));
            }
        });
        this.logger.info("\u67e5\u8be2\u8ba2\u8d27\u5355\u884c\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)dgPerformOrderLine));
        return dgPerformOrderLine;
    }

    @Override
    public List<DgPerformOrderLineDto> queryList(DgPerformOrderLinePageReqDto dto) {
        this.logger.info("\u67e5\u8be2\u8ba2\u8d27\u5355\u884c\u4fe1\u606f\uff1a{}", (Object)dto);
        List dgPerformOrderLine = ((IDgPerformOrderLineDomain)this.domain).queryList(dto);
        List dgPerformOrderItemLineList = this.dgPerformOrderItemLineDomain.queryInfoByOrderIds(dto.getOrderIds());
        Map<Long, List<DgPerformOrderItemLineDto>> dgPerformOrderItemLineGroup = dgPerformOrderItemLineList.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getOrderLineId));
        dgPerformOrderLine.forEach(orderLine -> {
            List dgPerformOrderItemLineDtoList = (List)dgPerformOrderItemLineGroup.get(orderLine.getId());
            BigDecimal returnNum = dgPerformOrderItemLineDtoList.stream().filter(f -> f.getReturnStatus() == 1).map(DgPerformOrderItemLineDto::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderLine.setReturnNum(returnNum);
            BigDecimal deliveryNum = dgPerformOrderItemLineDtoList.stream().filter(f -> f.getDeliveryStatus() == 1).map(DgPerformOrderItemLineDto::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderLine.setDeliveryNum(deliveryNum);
            orderLine.setEnabledReturnNum(BigDecimal.ZERO);
            if (deliveryNum.compareTo(returnNum) >= 0) {
                orderLine.setEnabledReturnNum(deliveryNum.subtract(returnNum));
            }
        });
        this.logger.info("\u67e5\u8be2\u8ba2\u8d27\u5355\u884c\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)dgPerformOrderLine));
        return dgPerformOrderLine;
    }
}

