/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.yunxi.dg.base.center.trade.constants.SelectListConstant;
import com.yunxi.dg.base.center.trade.convert.entity.DgTrolleyItemConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IDgTrolleyItemDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgTrolleyItemDto;
import com.yunxi.dg.base.center.trade.eo.DgTrolleyItemEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgTrolleyItemService;
import com.yunxi.dg.base.center.trade.utils.ObjectUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgTrolleyItemServiceImpl
extends BaseServiceImpl<DgTrolleyItemDto, DgTrolleyItemEo, IDgTrolleyItemDomain>
implements IDgTrolleyItemService {
    private static Logger logger = LoggerFactory.getLogger(DgTrolleyItemServiceImpl.class);
    @Resource
    protected ICacheService cacheService;
    @Resource
    private IDgTrolleyItemDomain dgTrolleyItemDomain;

    public DgTrolleyItemServiceImpl(IDgTrolleyItemDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgTrolleyItemDto, DgTrolleyItemEo> converter() {
        return DgTrolleyItemConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addDgTrolleyItem(List<DgTrolleyItemDto> reqDtos) {
        for (DgTrolleyItemDto dto : reqDtos) {
            DgTrolleyItemEo dgTrolleyItemEo = (DgTrolleyItemEo)this.converter().toEo((BaseDto)dto);
            String cacheKey = ObjectUtil.objectToString(dgTrolleyItemEo);
            boolean isSuccess = this.cacheService.add(cacheKey, (Object)1, 3);
            if (!isSuccess) {
                throw new BizException("\u4f60\u7684\u70b9\u51fb\u6b21\u6570\u592a\u5feb\u4e86");
            }
            try {
                DgTrolleyItemEo queryItem = new DgTrolleyItemEo();
                queryItem.setTrolleyId(dgTrolleyItemEo.getTrolleyId());
                queryItem.setItemId(dgTrolleyItemEo.getItemId());
                queryItem.setSkuId(dgTrolleyItemEo.getSkuId());
                queryItem.setShopId(dgTrolleyItemEo.getShopId());
                queryItem.setClassify(dgTrolleyItemEo.getClassify());
                DgTrolleyItemEo trolleyItem = (DgTrolleyItemEo)this.dgTrolleyItemDomain.selectOne((BaseEo)queryItem);
                if (trolleyItem != null) {
                    DgTrolleyItemEo result = trolleyItem;
                    DgTrolleyItemEo updateItem = new DgTrolleyItemEo();
                    updateItem.setId(result.getId());
                    Integer updateNum = dto.getOperate() != null && dto.getOperate() == 2 ? dto.getItemNum() : result.getItemNum() + dgTrolleyItemEo.getItemNum();
                    updateItem.setItemNum(updateNum);
                    this.dgTrolleyItemDomain.updateSelective((BaseEo)updateItem);
                } else {
                    this.dgTrolleyItemDomain.insert((BaseEo)dgTrolleyItemEo);
                }
                this.cacheService.delCache(cacheKey);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            finally {
                this.cacheService.delCache(cacheKey);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> ids) {
        ids.stream().forEach(id -> this.dgTrolleyItemDomain.deleteById(id));
    }

    @Override
    public List<DgTrolleyItemDto> getByTrolleyId(Long trolleyId) {
        DgTrolleyItemEo queryEo = new DgTrolleyItemEo();
        queryEo.setTrolleyId(trolleyId);
        List dgTrolleyItemEos = this.dgTrolleyItemDomain.selectList((BaseEo)queryEo, SelectListConstant.DEFAULT_PAGE_NUMBER, SelectListConstant.DEFAULT_PAGE_SIZE);
        return this.converter().toDtoList(dgTrolleyItemEos);
    }
}

