/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.b2b.Impl;

import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.source.dto.entity.DgClueWarehouseGroupRuleShipmentDto;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeShipmentEnterpriseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.oms.b2b.IB2BOrderPickService;
import com.yunxi.dg.base.center.trade.service.oms.common.IDgCommonLabelManageService;
import com.yunxi.dg.base.center.trade.service.oms.common.IOrderCommonHandleService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.center.trade.vo.BatchLogisticsSourceResultVo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class B2BOrderPickServiceImpl
implements IB2BOrderPickService {
    private static final Logger log = LoggerFactory.getLogger(B2BOrderPickServiceImpl.class);
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IOrderCommonHandleService orderCommonHandleService;
    @Resource
    private IDgCommonLabelManageService commonLabelManageService;

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void cancelPick(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        Boolean releaseLogicalAndChannel = this.inventoryApiServcie.releaseLogicalAndPhysics(saleOrderRespDto);
        if (Boolean.FALSE.equals(releaseLogicalAndChannel)) {
            throw DgPcpTradeExceptionCode.CANCEL_PICK_FAIL_EXCEPTION.buildBizException(new Object[]{saleOrderRespDto.getSaleOrderNo()});
        }
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> logisticsSourceResult(Long orderId, BatchLogisticsSourceResultVo logisticsSourceResultVo) {
        if (logisticsSourceResultVo.isFlag() && CollectionUtils.isNotEmpty((Collection)logisticsSourceResultVo.getDgClueWarehouseGroupRuleShipmentDtos())) {
            DgClueWarehouseGroupRuleShipmentDto shipmentDto = (DgClueWarehouseGroupRuleShipmentDto)logisticsSourceResultVo.getDgClueWarehouseGroupRuleShipmentDtos().get(0);
            DgArrangeShipmentEnterpriseReqDto shipmentEnterpriseReqDto = new DgArrangeShipmentEnterpriseReqDto();
            shipmentEnterpriseReqDto.setOrderId(orderId);
            shipmentEnterpriseReqDto.setShipmentEnterpriseCode(shipmentDto.getShipmentEnterpriseCode());
            shipmentEnterpriseReqDto.setShipmentEnterpriseName(shipmentDto.getShipmentEnterpriseName());
            shipmentEnterpriseReqDto.setShipmentEnterpriseId(shipmentDto.getShipmentEnterpriseId());
            shipmentEnterpriseReqDto.setTransportTypeCode(shipmentDto.getTransportTypeCode());
            shipmentEnterpriseReqDto.setTransportTypeName(shipmentDto.getTransportTypeName());
            shipmentEnterpriseReqDto.setLineCode(shipmentDto.getLineCode());
            shipmentEnterpriseReqDto.setLineName(shipmentDto.getLineName());
            this.orderCommonHandleService.assignPlanShipmentEnterprise(shipmentEnterpriseReqDto);
            this.commonLabelManageService.removeLogisticsSourceErrorByOrderId(orderId);
            logisticsSourceResultVo.setErrMsg("");
        } else {
            this.commonLabelManageService.markLogisticsSourceErrorByOrderId(orderId);
        }
        this.orderCommonHandleService.modifyInterceptReason(orderId, logisticsSourceResultVo.getErrMsg());
        return RestResponse.VOID;
    }
}

