/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.b2b.Impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.IdGenrator;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.source.dto.entity.DgOrderItemResultDto;
import com.yunxi.dg.base.center.source.dto.entity.DgSourceOrderResultRespDto;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.SaleItemStatusEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAttachmentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSplitReleationDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderWarehouseInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderLineReleationItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.ISourceRecordDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderSplitSaleOrderModeDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitChildOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAttachmentEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderExtensionEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderPaymentEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSplitReleationEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderWarehouseInfoEo;
import com.yunxi.dg.base.center.trade.eo.OrderLineReleationItemLineEo;
import com.yunxi.dg.base.center.trade.service.oms.b2b.IB2BOrderSplitService;
import com.yunxi.dg.base.center.trade.utils.DgPerformOrderNoGreateUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class B2BOrderSplitServiceImpl
implements IB2BOrderSplitService {
    private static final Logger log = LoggerFactory.getLogger(B2BOrderSplitServiceImpl.class);
    private static final String DEFAULT_SPLIT_LOGIC_WAREHOUSE = "DEFAULT_SPLIT_LOGIC_WAREHOUSE";
    private static final String DEFAULT_SPLIT_GROUP_CODE = "DEFAULT_SPLIT_GROUP_CODE";
    private static final String SPLIT_GROUP_CHAR = "#";
    @Resource
    private DgPerformOrderNoGreateUtil performOrderNoGreateUtil;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgOmsOrderSplitSaleOrderModeDomain omsOrderSplitSaleOrderModeDomain;
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IDgPerformOrderPaymentDomain performOrderPaymentDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain performOrderSnapshotDomain;
    @Resource
    private IDgPerformOrderExtensionDomain performOrderExtensionDomain;
    @Resource
    private IDgPerformOrderAmountDomain performOrderAmountDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoDomain performOrderWarehouseInfoDomain;
    @Resource
    private IDgPerformOrderAddrDomain performOrderAddrDomain;
    @Resource
    private IDgPerformOrderAttachmentDomain performOrderAttachmentDomain;
    @Resource
    private IDgPerformOrderLineDomain performOrderLineDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain performOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain performOrderItemLineAmountDomain;
    @Resource
    private IDgPerformOrderSplitReleationDomain performOrderSplitReleationDomain;
    @Resource
    private IOrderLineReleationItemLineDomain orderLineReleationItemLineDomain;
    @Resource
    private ISourceRecordDomain sourceRecordDomain;

    @Override
    public List<DgPerformOrderRespDto> splitOrderBySourceResult(DgPerformOrderRespDto respDto, DgSourceOrderResultRespDto sourceOrderResultRespDto) {
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(respDto.getId());
        List sourceOrderResultList = this.omsOrderSplitSaleOrderModeDomain.getSourceOrderResultList(respDto, sourceOrderResultRespDto, orderLineDtoList);
        this.sourceRecordDomain.saveSourceRecord(sourceOrderResultRespDto);
        DgSplitOrderReqDto splitOrderReqDto = this.getSplitOrderReqDto(respDto, sourceOrderResultList);
        return this.splitOrder(respDto, orderLineDtoList, splitOrderReqDto);
    }

    public DgSplitOrderReqDto getSplitOrderReqDto(DgPerformOrderRespDto saleOrderRespDto, List<List<DgOrderItemResultDto>> sourceOrderResultList) {
        ArrayList orderList = Lists.newArrayList();
        DgSplitOrderReqDto splitOrderReqDto = new DgSplitOrderReqDto();
        splitOrderReqDto.setInitOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setInitOmsOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setSaleOrderId(saleOrderRespDto.getId());
        splitOrderReqDto.setPerformOrderRespDto(saleOrderRespDto);
        sourceOrderResultList.stream().filter(Objects::nonNull).forEach(sourceOrderResultRespDto -> {
            sourceOrderResultRespDto.stream().forEach(dto -> {
                if (Objects.isNull(dto.getGroupCode())) {
                    dto.setGroupCode(DEFAULT_SPLIT_GROUP_CODE);
                }
                if (Objects.isNull(dto.getDeliveryLogicWarehouseCode())) {
                    dto.setDeliveryLogicWarehouseCode(DEFAULT_SPLIT_LOGIC_WAREHOUSE);
                }
            });
            Map<String, List<DgOrderItemResultDto>> orderItemResultMap = sourceOrderResultRespDto.stream().collect(Collectors.groupingBy(d -> d.getGroupCode() + SPLIT_GROUP_CHAR + d.getDeliveryLogicWarehouseCode()));
            orderItemResultMap.forEach((deliveryLogicWarehouseCode, orderItemList) -> {
                DgSplitChildOrderReqDto splitChildOrderReqDto = new DgSplitChildOrderReqDto();
                if (!deliveryLogicWarehouseCode.equals("DEFAULT_SPLIT_GROUP_CODE#DEFAULT_SPLIT_LOGIC_WAREHOUSE")) {
                    DgSplitChildOrderReqDto.LogicWarehouse logicWarehouse = new DgSplitChildOrderReqDto.LogicWarehouse();
                    int i = deliveryLogicWarehouseCode.lastIndexOf(SPLIT_GROUP_CHAR);
                    deliveryLogicWarehouseCode = deliveryLogicWarehouseCode.substring(i + 1);
                    logicWarehouse.setDeliveryLogicWarehouseCode(deliveryLogicWarehouseCode);
                    logicWarehouse.setSgLogicWarehouseCode(deliveryLogicWarehouseCode);
                    splitChildOrderReqDto.setLogicWarehouse(logicWarehouse);
                }
                ArrayList orderLineDtoList = Lists.newArrayList();
                Map<Long, List<DgOrderItemResultDto>> linkOrderItemIdMap = orderItemList.stream().collect(Collectors.groupingBy(DgOrderItemResultDto::getLinkOrderItemId));
                linkOrderItemIdMap.forEach((itemId, itemList) -> {
                    DgOrderItemResultDto orderItemResultDto = (DgOrderItemResultDto)itemList.get(0);
                    BigDecimal deliveryItemNum = itemList.stream().map(DgOrderItemResultDto::getDeliveryItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                    DgPerformOrderLineDto splitOrderItemReqDto = new DgPerformOrderLineDto();
                    splitOrderItemReqDto.setId(orderItemResultDto.getLinkOrderItemId());
                    splitOrderItemReqDto.setSplitItemNum(deliveryItemNum);
                    splitOrderItemReqDto.setLinkSourceResultItemId(orderItemResultDto.getId());
                    splitOrderItemReqDto.setDeliveryItemBatchNo(orderItemResultDto.getDeliveryItemBatchNo());
                    orderLineDtoList.add(splitOrderItemReqDto);
                });
                AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)orderLineDtoList), (String)"\u62c6\u5355\u5546\u54c1\u884c\u4e0d\u80fd\u4e3a\u7a7a");
                splitChildOrderReqDto.setOrderLineDtoList((List)orderLineDtoList);
                orderList.add(splitChildOrderReqDto);
            });
        });
        splitOrderReqDto.setOrderList((List)orderList);
        return splitOrderReqDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<DgPerformOrderRespDto> splitOrder(DgPerformOrderRespDto respDto, List<DgPerformOrderLineDto> orderLineDtoList, DgSplitOrderReqDto splitOrderReqDto) {
        log.info("\u62c6\u5355\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderReqDto));
        Map orderLineMap = orderLineDtoList.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
        List orderItemLineDtos = this.performOrderItemLineDomain.queryInfoByOrderId(respDto.getId());
        Map<Long, List<DgPerformOrderItemLineDto>> orderItemLineMap = orderItemLineDtos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getOrderLineId));
        DgPerformOrderInfoEo orderInfoEo = this.omsOrderSplitSaleOrderModeDomain.checkSplitOrder(splitOrderReqDto, orderLineDtoList);
        ArrayList<DgPerformOrderLineDto> performOrderLineDtoList = new ArrayList<DgPerformOrderLineDto>();
        ArrayList<DgPerformOrderItemLineDto> performOrderItemLineDtoList = new ArrayList<DgPerformOrderItemLineDto>();
        ArrayList performOrderLineAmountDtoList = new ArrayList();
        ArrayList performOrderItemLineAmountDtoList = new ArrayList();
        ArrayList<OrderLineReleationItemLineEo> releationItemLineEos = new ArrayList<OrderLineReleationItemLineEo>();
        ArrayList<Long> returnIdList = new ArrayList<Long>();
        HashMap<Long, DgPerformOrderLineDto> orderLineNumMap = new HashMap<Long, DgPerformOrderLineDto>();
        HashMap<Long, DgPerformOrderLineAmountDto> orderLineAmountMap = new HashMap<Long, DgPerformOrderLineAmountDto>();
        orderLineDtoList.forEach(orderLine -> {
            DgPerformOrderLineDto copyDto = new DgPerformOrderLineDto();
            CubeBeanUtils.copyProperties((Object)copyDto, (Object)orderLine, (String[])new String[0]);
            orderLineNumMap.put(copyDto.getId(), copyDto);
            orderLine.getAmountDtoList().forEach(amount -> {
                DgPerformOrderLineAmountDto copyAmountDto = new DgPerformOrderLineAmountDto();
                CubeBeanUtils.copyProperties((Object)copyAmountDto, (Object)amount, (String[])new String[0]);
                orderLineAmountMap.put(copyAmountDto.getId(), copyAmountDto);
            });
        });
        HashMap<Long, DgPerformOrderItemLineDto> orderItemLineNumMap = new HashMap<Long, DgPerformOrderItemLineDto>();
        HashMap<Long, DgPerformOrderItemLineAmountDto> orderItemLineAmountMap = new HashMap<Long, DgPerformOrderItemLineAmountDto>();
        orderItemLineDtos.forEach(orderItemLine -> {
            DgPerformOrderItemLineDto copyDto = new DgPerformOrderItemLineDto();
            CubeBeanUtils.copyProperties((Object)copyDto, (Object)orderItemLine, (String[])new String[0]);
            orderItemLineNumMap.put(copyDto.getId(), copyDto);
            orderItemLine.getPerformOrderItemLineAmountDtoList().forEach(amount -> {
                DgPerformOrderItemLineAmountDto copyAmountDto = new DgPerformOrderItemLineAmountDto();
                CubeBeanUtils.copyProperties((Object)copyAmountDto, (Object)amount, (String[])new String[0]);
                orderItemLineAmountMap.put(copyAmountDto.getId(), copyAmountDto);
            });
        });
        int i = 1;
        for (DgSplitChildOrderReqDto splitOrder : splitOrderReqDto.getOrderList()) {
            log.info("\u5f53\u524d\u7b2c{}\u4e2a\u5b50\u5355", (Object)i);
            DgPerformOrderInfoEo performOrderInfoEo = this.getDgPerformOrderInfoEo(respDto, splitOrderReqDto, orderInfoEo, splitOrder);
            log.info("\u5f53\u524d\u7b2c{}\u4e2a\u5b50\u5355\u5f00\u59cb\u62c6\u5206\u5546\u54c1==========================begin:{}", (Object)i, (Object)JSON.toJSONString((Object)splitOrder));
            for (DgPerformOrderLineDto orderLineDto : splitOrder.getOrderLineDtoList()) {
                DgPerformOrderLineDto oriOrderLineDto = (DgPerformOrderLineDto)orderLineMap.get(orderLineDto.getId());
                if (null == oriOrderLineDto) {
                    log.error("\u8ba2\u5355\u884c\u4e0d\u5b58\u5728\uff1a{}", (Object)orderLineDto.getId());
                }
                boolean flag = oriOrderLineDto.getItemNum().compareTo(orderLineDto.getSplitItemNum()) == 0;
                DgPerformOrderLineDto newOrderLine = this.buildSplitOrderLineDto(orderLineDto.getSplitItemNum(), performOrderInfoEo, oriOrderLineDto, orderLineNumMap, orderLineAmountMap, flag);
                if (null == newOrderLine) {
                    log.error("\u8ba2\u5355\u884c\u62c6\u5206\u5931\u8d25\uff1a{}", (Object)orderLineDto.getId());
                }
                performOrderLineDtoList.add(newOrderLine);
                performOrderLineAmountDtoList.addAll(newOrderLine.getAmountDtoList());
                List<DgPerformOrderItemLineDto> orderItemLineDtoList = orderItemLineMap.get(orderLineDto.getId());
                if (CollectionUtils.isNotEmpty(orderItemLineDtoList)) {
                    for (DgPerformOrderItemLineDto oriOrderItemLine : orderItemLineDtoList) {
                        DgPerformOrderItemLineDto newOrderItemLine = this.buildSplitOrderItemLineDto(orderLineDto.getSplitItemNum(), performOrderInfoEo, oriOrderItemLine, orderItemLineNumMap, orderItemLineAmountMap, flag);
                        newOrderItemLine.setOrderLineId(newOrderLine.getId());
                        performOrderItemLineDtoList.add(newOrderItemLine);
                        performOrderItemLineAmountDtoList.addAll(newOrderItemLine.getPerformOrderItemLineAmountDtoList());
                        OrderLineReleationItemLineEo releationItemLineEo = new OrderLineReleationItemLineEo();
                        releationItemLineEo.setOrderLineId(newOrderLine.getId());
                        releationItemLineEo.setOrderItemLineId(newOrderItemLine.getId());
                        releationItemLineEos.add(releationItemLineEo);
                    }
                    continue;
                }
                log.error("\u8ba2\u5355\u884c\u5bf9\u5e94\u5546\u54c1\u884c\u4e0d\u5b58\u5728\uff1a{}", (Object)orderLineDto.getId());
            }
            returnIdList.add(performOrderInfoEo.getId());
            log.info("\u5f53\u524d\u7b2c{}\u4e2a\u5b50\u5355\u5f00\u59cb\u62c6\u5206\u5546\u54c1==========================end", (Object)(++i));
        }
        ArrayList performOrderLineEoList = new ArrayList();
        ArrayList performOrderItemLineEoList = new ArrayList();
        ArrayList performOrderLineAmountEoList = new ArrayList();
        ArrayList performOrderItemLineAmountEoList = new ArrayList();
        CubeBeanUtils.copyCollection(performOrderLineEoList, performOrderLineDtoList, DgPerformOrderLineEo.class);
        CubeBeanUtils.copyCollection(performOrderItemLineEoList, performOrderItemLineDtoList, DgPerformOrderItemLineEo.class);
        CubeBeanUtils.copyCollection(performOrderLineAmountEoList, performOrderLineAmountDtoList, DgPerformOrderLineAmountEo.class);
        CubeBeanUtils.copyCollection(performOrderItemLineAmountEoList, performOrderItemLineAmountDtoList, DgPerformOrderItemLineAmountEo.class);
        this.performOrderLineDomain.insertBatch(performOrderLineEoList);
        this.performOrderItemLineDomain.insertBatch(performOrderItemLineEoList);
        this.performOrderLineAmountDomain.insertBatch(performOrderLineAmountEoList);
        this.performOrderItemLineAmountDomain.insertBatch(performOrderItemLineAmountEoList);
        this.orderLineReleationItemLineDomain.insertBatch(releationItemLineEos);
        ArrayList performOrderSplitReleationEos = new ArrayList();
        returnIdList.forEach(id -> {
            DgPerformOrderSplitReleationEo performOrderSplitReleationEo = new DgPerformOrderSplitReleationEo();
            performOrderSplitReleationEo.setOrderId(respDto.getId());
            performOrderSplitReleationEo.setChildOrderId(id);
            performOrderSplitReleationEos.add(performOrderSplitReleationEo);
        });
        this.performOrderSplitReleationDomain.insertBatch(performOrderSplitReleationEos);
        return this.omsOrderInfoQueryDomain.queryDtoByIds(returnIdList);
    }

    private DgPerformOrderInfoEo getDgPerformOrderInfoEo(DgPerformOrderRespDto respDto, DgSplitOrderReqDto splitOrderReqDto, DgPerformOrderInfoEo orderInfoEo, DgSplitChildOrderReqDto splitOrder) {
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        CubeBeanUtils.copyProperties((Object)performOrderInfoEo, (Object)orderInfoEo, (String[])new String[]{"id", "saleOrderNo", "createTime", "createPerson", "updateTime", "updatePerson"});
        performOrderInfoEo.setSaleOrderNo(this.performOrderNoGreateUtil.generateOrderNo());
        if (StringUtils.isNotBlank((CharSequence)splitOrderReqDto.getInitOrderStatus())) {
            performOrderInfoEo.setOrderStatus(splitOrderReqDto.getInitOrderStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)splitOrderReqDto.getInitOmsOrderStatus())) {
            performOrderInfoEo.setOmsSaleOrderStatus(splitOrderReqDto.getInitOmsOrderStatus());
        }
        this.performOrderInfoDomain.insert((BaseEo)performOrderInfoEo);
        DgPerformOrderExtensionEo extensionEo = new DgPerformOrderExtensionEo();
        CubeBeanUtils.copyProperties((Object)extensionEo, (Object)respDto.getPerformOrderExtensionDto(), (String[])new String[]{"id"});
        extensionEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderExtensionDomain.insert((BaseEo)extensionEo);
        DgPerformOrderSnapshotEo snapshotEo = new DgPerformOrderSnapshotEo();
        CubeBeanUtils.copyProperties((Object)snapshotEo, (Object)respDto.getPerformOrderSnapshotDto(), (String[])new String[]{"id"});
        snapshotEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderSnapshotDomain.insert((BaseEo)snapshotEo);
        DgPerformOrderAmountEo amountEo = new DgPerformOrderAmountEo();
        amountEo.setOrderId(performOrderInfoEo.getId());
        amountEo.setOrderNo(performOrderInfoEo.getSaleOrderNo());
        this.performOrderAmountDomain.insert((BaseEo)amountEo);
        DgPerformOrderPaymentEo paymentEo = new DgPerformOrderPaymentEo();
        CubeBeanUtils.copyProperties((Object)paymentEo, (Object)respDto.getPerformOrderPaymentDto(), (String[])new String[]{"id"});
        paymentEo.setOrderId(performOrderInfoEo.getId());
        paymentEo.setRemainingPayAmount(BigDecimal.ZERO);
        this.performOrderPaymentDomain.insert((BaseEo)paymentEo);
        DgPerformOrderWarehouseInfoEo warehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
        CubeBeanUtils.copyProperties((Object)warehouseInfoEo, (Object)respDto.getPerformOrderWarehouseInfoDto(), (String[])new String[]{"id"});
        warehouseInfoEo.setOrderId(performOrderInfoEo.getId());
        if (StringUtils.isNotBlank((CharSequence)splitOrder.getLogicWarehouse().getDeliveryLogicWarehouseCode())) {
            warehouseInfoEo.setLogicalWarehouseId(splitOrder.getLogicWarehouse().getDeliveryLogicWarehouseId());
            warehouseInfoEo.setLogicalWarehouseCode(splitOrder.getLogicWarehouse().getDeliveryLogicWarehouseCode());
            warehouseInfoEo.setLogicalWarehouseName(splitOrder.getLogicWarehouse().getDeliveryLogicWarehouseName());
            warehouseInfoEo.setDefaultLogicalWarehouseName(splitOrder.getLogicWarehouse().getDeliveryLogicWarehouseName());
            warehouseInfoEo.setDeliveryLogicalWarehouseCode(splitOrder.getLogicWarehouse().getDeliveryLogicWarehouseCode());
        }
        this.performOrderWarehouseInfoDomain.insert((BaseEo)warehouseInfoEo);
        DgPerformOrderAddrDto orderAddrDasOne = this.performOrderAddrDomain.queryAddressByOrderId(respDto.getId());
        DgPerformOrderAddrEo performOrderAddrEo = new DgPerformOrderAddrEo();
        CubeBeanUtils.copyProperties((Object)performOrderAddrEo, (Object)orderAddrDasOne, (String[])new String[]{"id"});
        performOrderAddrEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderAddrDomain.insert((BaseEo)performOrderAddrEo);
        List attachmentEos = this.performOrderAttachmentDomain.queryAttachmentByOrderId(respDto.getId());
        if (CollectionUtils.isNotEmpty((Collection)attachmentEos)) {
            attachmentEos = attachmentEos.stream().map(attachmentEo -> {
                DgPerformOrderAttachmentEo dgPerformOrderAttachmentEo = new DgPerformOrderAttachmentEo();
                CubeBeanUtils.copyProperties((Object)dgPerformOrderAttachmentEo, (Object)attachmentEo, (String[])new String[]{"id"});
                dgPerformOrderAttachmentEo.setOrderId(performOrderInfoEo.getId());
                return dgPerformOrderAttachmentEo;
            }).collect(Collectors.toList());
            this.performOrderAttachmentDomain.insertBatch(attachmentEos);
        }
        return performOrderInfoEo;
    }

    private DgPerformOrderLineDto buildSplitOrderLineDto(BigDecimal splitItemNum, DgPerformOrderInfoEo performOrderInfoEo, DgPerformOrderLineDto performOrderLineDto, Map<Long, DgPerformOrderLineDto> orderLineNumMap, Map<Long, DgPerformOrderLineAmountDto> orderLineAmountMap, boolean flag) {
        DgPerformOrderLineDto orderLineNumDro = orderLineNumMap.get(performOrderLineDto.getId());
        if (null == orderLineNumDro) {
            log.info("\u8ba2\u5355\u884c\u5df2\u7ecf\u5206\u914d\u5b8c\u6bd5\uff1a{}", (Object)performOrderLineDto.getId());
            return null;
        }
        DgPerformOrderLineDto newOrderLine = new DgPerformOrderLineDto();
        CubeBeanUtils.copyProperties((Object)newOrderLine, (Object)performOrderLineDto, (String[])new String[]{"id"});
        Long orderLineId = IdGenrator.getDistributedId();
        newOrderLine.setId(orderLineId);
        newOrderLine.setOrderId(performOrderInfoEo.getId());
        newOrderLine.setOrderNo(performOrderInfoEo.getSaleOrderNo());
        ArrayList<DgPerformOrderLineAmountDto> amounts = new ArrayList<DgPerformOrderLineAmountDto>();
        if (flag) {
            log.info("\u8ba2\u5355\u884c\uff1a{}\u6574\u884c\u590d\u5236\u7ed9\u65b0\u8ba2\u5355\uff1a{}", (Object)performOrderLineDto.getId(), (Object)performOrderInfoEo.getId());
            orderLineNumMap.put(performOrderLineDto.getId(), null);
            performOrderLineDto.getAmountDtoList().forEach(orderLineAmount -> {
                DgPerformOrderLineAmountDto copyDto = (DgPerformOrderLineAmountDto)orderLineAmountMap.get(orderLineAmount.getId());
                copyDto.setId(null);
                copyDto.setOrderId(performOrderInfoEo.getId());
                copyDto.setOrderLineId(orderLineId);
                amounts.add(copyDto);
                orderLineAmountMap.put(orderLineAmount.getId(), null);
            });
        } else if (orderLineNumDro.getItemNum().compareTo(splitItemNum) > 0) {
            BigDecimal proportion = splitItemNum.divide(performOrderLineDto.getItemNum(), 6, RoundingMode.HALF_UP);
            log.info("\u8ba2\u5355\u884c\u5206\u914d\u6bd4\u4f8b\uff1a{}", (Object)proportion);
            BigDecimal itemNum = splitItemNum.setScale(2, RoundingMode.HALF_UP);
            BigDecimal calcItemNum = performOrderLineDto.getCalcItemNum().multiply(proportion).setScale(2, RoundingMode.HALF_UP);
            BigDecimal basicNum = performOrderLineDto.getBasicNum().multiply(proportion).setScale(2, RoundingMode.HALF_UP);
            BigDecimal placeItemNum = performOrderLineDto.getPlaceItemNum().multiply(proportion).setScale(2, RoundingMode.HALF_UP);
            BigDecimal volume = performOrderLineDto.getVolume().multiply(proportion).setScale(6, RoundingMode.HALF_UP);
            BigDecimal weight = performOrderLineDto.getWeight().multiply(proportion).setScale(6, RoundingMode.HALF_UP);
            newOrderLine.setItemNum(itemNum);
            newOrderLine.setCalcItemNum(calcItemNum);
            newOrderLine.setBasicNum(basicNum);
            newOrderLine.setPlaceItemNum(placeItemNum);
            newOrderLine.setVolume(volume);
            newOrderLine.setWeight(weight);
            log.info("1-\u65b0\u8ba2\u5355\u884c[{}]\u6570\u91cf\u4e3a\uff1a{}", (Object)orderLineId, (Object)newOrderLine.getItemNum());
            for (DgPerformOrderLineAmountDto orderLineAmount2 : performOrderLineDto.getAmountDtoList()) {
                BigDecimal lineAmount = orderLineAmount2.getAmount().multiply(proportion).setScale(2, RoundingMode.HALF_UP);
                DgPerformOrderLineAmountDto newLineAmountDto = new DgPerformOrderLineAmountDto();
                CubeBeanUtils.copyProperties((Object)newLineAmountDto, (Object)orderLineAmount2, (String[])new String[]{"id"});
                newLineAmountDto.setOrderId(performOrderInfoEo.getId());
                newLineAmountDto.setOrderLineId(newOrderLine.getId());
                newLineAmountDto.setAmount(lineAmount);
                amounts.add(newLineAmountDto);
                DgPerformOrderLineAmountDto orderLineAmountDto = orderLineAmountMap.get(orderLineAmount2.getId());
                orderLineAmountDto.setAmount(orderLineAmountDto.getAmount().subtract(lineAmount));
                orderLineAmountMap.put(orderLineAmount2.getId(), orderLineAmountDto);
            }
            orderLineNumDro.setItemNum(orderLineNumDro.getItemNum().subtract(itemNum));
            orderLineNumDro.setCalcItemNum(orderLineNumDro.getCalcItemNum().subtract(calcItemNum));
            orderLineNumDro.setBasicNum(orderLineNumDro.getBasicNum().subtract(basicNum));
            orderLineNumDro.setPlaceItemNum(orderLineNumDro.getPlaceItemNum().subtract(placeItemNum));
            orderLineNumDro.setVolume(orderLineNumDro.getVolume().subtract(volume));
            orderLineNumDro.setWeight(orderLineNumDro.getWeight().subtract(weight));
            orderLineNumMap.put(performOrderLineDto.getId(), orderLineNumDro);
        } else if (splitItemNum.compareTo(BigDecimal.ZERO) > 0) {
            log.info("\u5546\u54c1\u884c\u5269\u4f59\u6570\u91cf\u8d4b\u503c");
            newOrderLine.setItemNum(orderLineNumDro.getItemNum());
            newOrderLine.setCalcItemNum(orderLineNumDro.getCalcItemNum());
            newOrderLine.setBasicNum(orderLineNumDro.getBasicNum());
            newOrderLine.setPlaceItemNum(orderLineNumDro.getPlaceItemNum());
            newOrderLine.setVolume(orderLineNumDro.getVolume());
            newOrderLine.setWeight(orderLineNumDro.getWeight());
            log.info("2-\u65b0\u8ba2\u5355\u884c[{}]\u6570\u91cf\u4e3a\uff1a{}", (Object)orderLineId, (Object)newOrderLine.getItemNum());
            for (DgPerformOrderLineAmountDto orderLineAmount3 : performOrderLineDto.getAmountDtoList()) {
                DgPerformOrderLineAmountDto orderLineAmountDto = orderLineAmountMap.get(orderLineAmount3.getId());
                DgPerformOrderLineAmountDto newLineAmountDto = new DgPerformOrderLineAmountDto();
                CubeBeanUtils.copyProperties((Object)newLineAmountDto, (Object)orderLineAmount3, (String[])new String[]{"id"});
                newLineAmountDto.setOrderId(performOrderInfoEo.getId());
                newLineAmountDto.setOrderLineId(newOrderLine.getId());
                newLineAmountDto.setAmount(orderLineAmountDto.getAmount());
                amounts.add(newLineAmountDto);
                orderLineAmountMap.put(orderLineAmount3.getId(), null);
            }
            orderLineNumMap.put(performOrderLineDto.getId(), null);
        } else {
            log.error("\u8ba2\u5355\u884c\u5df2\u7ecf\u6ca1\u6709\u5269\u4f59\u6570\u91cf\u5206\u914d\u4e86");
            return null;
        }
        newOrderLine.setAmountDtoList(amounts);
        return newOrderLine;
    }

    private DgPerformOrderItemLineDto buildSplitOrderItemLineDto(BigDecimal splitItemNum, DgPerformOrderInfoEo performOrderInfoEo, DgPerformOrderItemLineDto oriOrderItemLine, Map<Long, DgPerformOrderItemLineDto> orderItemLineNumMap, Map<Long, DgPerformOrderItemLineAmountDto> orderItemLineAmountMap, boolean flag) {
        DgPerformOrderItemLineDto orderItemLineNumDto = orderItemLineNumMap.get(oriOrderItemLine.getId());
        if (null == orderItemLineNumDto) {
            log.info("\u8ba2\u5355\u884c\u5df2\u7ecf\u5206\u914d\u5b8c\u6bd5\uff1a{}", (Object)oriOrderItemLine.getId());
            return null;
        }
        Long orderItemLineId = IdGenrator.getDistributedId();
        DgPerformOrderItemLineDto newOrderItemLineDto = new DgPerformOrderItemLineDto();
        CubeBeanUtils.copyProperties((Object)newOrderItemLineDto, (Object)oriOrderItemLine, (String[])new String[]{"id"});
        newOrderItemLineDto.setId(orderItemLineId);
        newOrderItemLineDto.setOrderId(performOrderInfoEo.getId());
        ArrayList<DgPerformOrderItemLineAmountDto> amounts = new ArrayList<DgPerformOrderItemLineAmountDto>();
        if (flag) {
            log.info("\u5546\u54c1\u884c\uff1a{}\u6574\u884c\u590d\u5236\u7ed9\u65b0\u8ba2\u5355\uff1a{}", (Object)oriOrderItemLine.getId(), (Object)performOrderInfoEo.getId());
            orderItemLineNumMap.put(oriOrderItemLine.getId(), null);
            oriOrderItemLine.getPerformOrderItemLineAmountDtoList().forEach(amount -> {
                DgPerformOrderItemLineAmountDto copyDto = (DgPerformOrderItemLineAmountDto)orderItemLineAmountMap.get(amount.getId());
                copyDto.setId(null);
                copyDto.setOrderId(performOrderInfoEo.getId());
                copyDto.setOrderItemLineId(orderItemLineId);
                amounts.add(copyDto);
                orderItemLineAmountMap.put(amount.getId(), null);
            });
            newOrderItemLineDto.setPerformOrderItemLineAmountDtoList(amounts);
        } else if (orderItemLineNumDto.getItemNum().compareTo(splitItemNum) > 0) {
            BigDecimal proportion = splitItemNum.divide(oriOrderItemLine.getItemNum(), 6, RoundingMode.HALF_UP);
            log.info("\u5546\u54c1\u884c\u5206\u914d\u6bd4\u4f8b\uff1a{}", (Object)proportion);
            BigDecimal itemNum = splitItemNum.setScale(2, RoundingMode.HALF_UP);
            BigDecimal calcItemNum = oriOrderItemLine.getCalcItemNum().multiply(proportion).setScale(2, RoundingMode.HALF_UP);
            newOrderItemLineDto.setItemNum(itemNum);
            newOrderItemLineDto.setCalcItemNum(calcItemNum);
            log.info("1-\u65b0\u5546\u54c1\u884c[{}]\u6570\u91cf\u4e3a\uff1a{}", (Object)orderItemLineId, (Object)newOrderItemLineDto.getItemNum());
            for (DgPerformOrderItemLineAmountDto orderLineAmount : oriOrderItemLine.getPerformOrderItemLineAmountDtoList()) {
                BigDecimal lineAmount = orderLineAmount.getAmount().multiply(proportion).setScale(2, RoundingMode.HALF_UP);
                DgPerformOrderItemLineAmountDto newOrderItemLineAmountDto = new DgPerformOrderItemLineAmountDto();
                CubeBeanUtils.copyProperties((Object)newOrderItemLineAmountDto, (Object)orderLineAmount, (String[])new String[]{"id"});
                newOrderItemLineAmountDto.setOrderId(performOrderInfoEo.getId());
                newOrderItemLineAmountDto.setOrderItemLineId(newOrderItemLineDto.getId());
                newOrderItemLineAmountDto.setAmount(lineAmount);
                amounts.add(newOrderItemLineAmountDto);
                DgPerformOrderItemLineAmountDto orderItemLineAmountDto = orderItemLineAmountMap.get(orderLineAmount.getId());
                orderItemLineAmountDto.setAmount(orderItemLineAmountDto.getAmount().subtract(lineAmount));
                orderItemLineAmountMap.put(orderLineAmount.getId(), orderItemLineAmountDto);
            }
            orderItemLineNumDto.setItemNum(orderItemLineNumDto.getItemNum().subtract(itemNum));
            orderItemLineNumDto.setCalcItemNum(orderItemLineNumDto.getCalcItemNum().subtract(calcItemNum));
            orderItemLineNumMap.put(oriOrderItemLine.getId(), orderItemLineNumDto);
        } else if (splitItemNum.compareTo(BigDecimal.ZERO) > 0) {
            newOrderItemLineDto.setItemNum(orderItemLineNumDto.getItemNum());
            newOrderItemLineDto.setCalcItemNum(orderItemLineNumDto.getCalcItemNum());
            log.info("2-\u65b0\u5546\u54c1\u884c[{}]\u6570\u91cf\u4e3a\uff1a{}", (Object)orderItemLineId, (Object)newOrderItemLineDto.getItemNum());
            for (DgPerformOrderItemLineAmountDto orderItemLineAmount : oriOrderItemLine.getPerformOrderItemLineAmountDtoList()) {
                DgPerformOrderItemLineAmountDto orderItemLineAmountDto = orderItemLineAmountMap.get(orderItemLineAmount.getId());
                DgPerformOrderItemLineAmountDto newItemLineAmountDto = new DgPerformOrderItemLineAmountDto();
                CubeBeanUtils.copyProperties((Object)newItemLineAmountDto, (Object)orderItemLineAmount, (String[])new String[]{"id"});
                newItemLineAmountDto.setOrderId(performOrderInfoEo.getId());
                newItemLineAmountDto.setOrderItemLineId(newOrderItemLineDto.getId());
                newItemLineAmountDto.setAmount(orderItemLineAmountDto.getAmount());
                amounts.add(newItemLineAmountDto);
                orderItemLineAmountMap.put(orderItemLineAmount.getId(), null);
            }
            orderItemLineNumMap.put(oriOrderItemLine.getId(), null);
        }
        newOrderItemLineDto.setPerformOrderItemLineAmountDtoList(amounts);
        return newOrderItemLineDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyChildOrderBySplit(DgPerformOrderRespDto dto, List<DgPerformOrderRespDto> childOrderList) {
        List orderIdList = childOrderList.stream().map(BaseDto::getId).collect(Collectors.toList());
        List orderAmountEos = this.performOrderAmountDomain.selectByOrderIds(orderIdList);
        Map orderAmountMap = orderAmountEos.stream().collect(Collectors.toMap(DgPerformOrderAmountEo::getOrderId, Function.identity(), (a, b) -> a));
        log.info("\u8ba2\u5355\u884cID\u96c6\u5408:{}", (Object)JSON.toJSONString(orderIdList));
        List orderLineDtos = this.performOrderLineDomain.queryByOrderIds(orderIdList);
        AssertUtils.notEmpty((Collection)orderLineDtos, (String)"\u8ba2\u5355\u5546\u54c1\u4e3a\u7a7a");
        Map<Long, List<DgPerformOrderLineDto>> orderLineMap = orderLineDtos.stream().collect(Collectors.groupingBy(DgPerformOrderLineDto::getOrderId));
        for (Map.Entry<Long, List<DgPerformOrderLineDto>> map : orderLineMap.entrySet()) {
            log.info("\u5b50\u8ba2\u5355ID:{}", (Object)map.getKey());
            log.info("\u5b50\u8ba2\u5355\u8ba2\u5355\u884cID\u96c6\u5408:{}", map.getValue().stream().map(BaseDto::getId).collect(Collectors.toList()));
        }
        List orderLineAmountDtos = this.performOrderLineAmountDomain.queryByOrderIds(orderIdList);
        Map<Long, List<DgPerformOrderLineAmountDto>> orderLineAmountMap = orderLineAmountDtos.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountDto::getOrderId));
        List snapshotEoList = this.performOrderSnapshotDomain.selectByOrderIds(childOrderList.stream().map(BaseDto::getId).distinct().collect(Collectors.toSet()));
        Map snapshotEoMap = snapshotEoList.stream().collect(Collectors.toMap(DgPerformOrderSnapshotEo::getOrderId, Function.identity(), (a, b) -> a));
        childOrderList.forEach(childSaleOrderRespDto -> {
            log.info("\u5b50\u8ba2\u5355ID:{}", (Object)childSaleOrderRespDto.getId());
            List saleOrderLineList = (List)orderLineMap.get(childSaleOrderRespDto.getId());
            List orderLineAmounts = (List)orderLineAmountMap.get(childSaleOrderRespDto.getId());
            BigDecimal goodsTotalNum = saleOrderLineList.stream().map(DgPerformOrderLineDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal goodsTotalAmount = orderLineAmounts.stream().filter(e -> e.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode())).map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal payAmount = orderLineAmounts.stream().filter(e -> e.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode())).map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal realPayAmount = orderLineAmounts.stream().filter(e -> e.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode())).map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal discountAmount = orderLineAmounts.stream().filter(e -> e.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode())).map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalCostAmount = orderLineAmounts.stream().filter(e -> e.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_COST_AMOUNT.getCode())).map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal promotionKneadTotalAmount = orderLineAmounts.stream().filter(e -> e.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_PROMOTION_KNEAD_TOTAL.getCode())).map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal costKneadTotalAmount = orderLineAmounts.stream().filter(e -> e.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_COST_KNEAD_TOTAL.getCode())).map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal kneadLaterPayAmount = orderLineAmounts.stream().filter(e -> e.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_KNEAD_LATER_PAY_AMOUNT.getCode())).map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal kneadLaterAmount = orderLineAmounts.stream().filter(e -> e.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_KNEAD_LATER_SETTLEMENT_AMOUNT.getCode())).map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal merchantReceivableAmount = goodsTotalAmount.subtract(discountAmount);
            log.info("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u5546\u54c1\u603b\u6570\u91cf\uff1a{}\uff0c\u5546\u54c1\u603b\u91d1\u989d\uff1a{}\uff0c\u6210\u4ea4\u603b\u91d1\u989d\uff1a{}, \u5b9e\u4ed8\u603b\u91d1\u989d\uff1a{}, \u4f18\u60e0\u603b\u91d1\u989d\uff1a{},\u5e94\u6536\u603b\u91d1\u989d\uff1a{}", new Object[]{goodsTotalNum, goodsTotalAmount, payAmount, realPayAmount, discountAmount, merchantReceivableAmount});
            boolean kneadeFlag = snapshotEoMap.get(childSaleOrderRespDto.getId()) != null && ((DgPerformOrderSnapshotEo)snapshotEoMap.get(childSaleOrderRespDto.getId())).getKneadeFlag() == 1;
            List cancelOrderLineList = saleOrderLineList.stream().filter(line -> StringUtils.isNotBlank((CharSequence)line.getStatus()) && line.getStatus().equals(SaleItemStatusEnum.CANCEL.getCode())).collect(Collectors.toList());
            boolean cancelFlag = cancelOrderLineList.size() == saleOrderLineList.size();
            DgPerformOrderInfoEo modifyReqEo = new DgPerformOrderInfoEo();
            modifyReqEo.setId(childSaleOrderRespDto.getId());
            modifyReqEo.setGoodsTotalNum(goodsTotalNum);
            modifyReqEo.setGoodsTotalAmount(goodsTotalAmount);
            modifyReqEo.setPayAmount(kneadeFlag ? payAmount : kneadLaterPayAmount);
            modifyReqEo.setRealPayAmount(kneadeFlag ? realPayAmount : kneadLaterAmount);
            modifyReqEo.setDiscountAmount(discountAmount);
            modifyReqEo.setMerchantReceivableAmount(merchantReceivableAmount);
            if (cancelFlag) {
                log.info("\u5f53\u524d\u8ba2\u5355\u6240\u6709\u5546\u54c1\u5df2\u7ecf\u53d6\u6d88");
                modifyReqEo.setOrderStatus(DgOmsSaleOrderStatus.CANCEL.getCode());
                modifyReqEo.setOmsSaleOrderStatus(DgOmsSaleOrderStatus.CANCEL.getCode());
            }
            this.performOrderInfoDomain.updateSelective((BaseEo)modifyReqEo);
            DgPerformOrderAmountEo orderAmountEo = (DgPerformOrderAmountEo)orderAmountMap.get(childSaleOrderRespDto.getId());
            DgPerformOrderAmountEo modifyAmountReqEo = new DgPerformOrderAmountEo();
            modifyAmountReqEo.setId(orderAmountEo.getId());
            modifyAmountReqEo.setGoodsTotalNum(goodsTotalNum);
            modifyAmountReqEo.setGoodsTotalAmount(goodsTotalAmount);
            modifyAmountReqEo.setPayAmount(kneadeFlag ? payAmount : kneadLaterPayAmount);
            modifyAmountReqEo.setRealPayAmount(kneadeFlag ? realPayAmount : kneadLaterAmount);
            modifyAmountReqEo.setDiscountAmount(discountAmount);
            modifyAmountReqEo.setMerchantReceivableAmount(merchantReceivableAmount);
            this.performOrderAmountDomain.updateSelective((BaseEo)modifyAmountReqEo);
        });
    }

    @Override
    public void recoveryOrderSplitReleation(Long orderId) {
        List releationEos = this.performOrderSplitReleationDomain.queryByOrderId(orderId);
        if (CollectionUtils.isNotEmpty((Collection)releationEos)) {
            releationEos.forEach(releation -> this.performOrderSplitReleationDomain.logicDeleteById(releation.getId()));
        }
    }
}

