/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.b2c.Impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.yunxi.dg.base.center.data.proxy.api.IDictQueryApiProxy;
import com.yunxi.dg.base.center.openapi.dto.reponse.SkuSupplyPriceRespDto;
import com.yunxi.dg.base.center.openapi.dto.request.AccountBalanceOrderLineReqDto;
import com.yunxi.dg.base.center.openapi.dto.request.SkuSupplyPriceQueryReqDto;
import com.yunxi.dg.base.center.openapi.proxy.price.IPlaceOrderGoodsApiProxy;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.common.IDgAfterSaleOrderOptAction;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.DgGiftTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgOmsOrderLineStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderSourceEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountCategoryEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformNoticeSyncRecordShippingDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderWarehouseInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizOptDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.response.DgPerformOrderLineDetailDto;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderItemTypeEnum;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.enums.ShippingOrderTypeEnum;
import com.yunxi.dg.base.center.trade.enums.SyncRecordShippingTypeEnum;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformNoticeSyncRecordShippingEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.exception.PcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderItemService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderService;
import com.yunxi.dg.base.center.trade.service.oms.common.IDgCommonLabelManageService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.transform.dto.response.TfOrderItemRespDto;
import com.yunxi.dg.base.center.transform.dto.response.TfOrderRefundRespDto;
import com.yunxi.dg.base.center.transform.dto.response.TfOrderRespDto;
import com.yunxi.dg.base.center.transform.dto.response.TfOrderReturnRefundRespDto;
import com.yunxi.dg.base.center.transform.proxy.query.ITfOrderQueryApiProxy;
import com.yunxi.dg.base.center.transform.proxy.query.ITfOrderRefundQueryApiProxy;
import com.yunxi.dg.base.center.transform.proxy.query.ITfOrderReturnRefundQueryApiProxy;
import com.yunxi.dg.base.center.transform.proxy.query.ITrOrderItemQueryApiProxy;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgOmsOrderServiceImpl
implements IDgOmsOrderService {
    private static final Logger log = LoggerFactory.getLogger(DgOmsOrderServiceImpl.class);
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private IDgOmsOrderItemService omsOrderItemService;
    @Resource
    private IDgCommonLabelManageService commonLabelManageService;
    @Resource
    private IDgOmsOrderInfoDomain dgOmsOrderDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain performOrderSnapshotDomain;
    @Resource
    private IDgOmsOrderLineBizOptDomain dgOmsOrderLineBizOptDomain;
    @Resource
    private IDgPerformOrderLineDomain orderLineDomain;
    @Resource
    private IDgPerformOrderAmountDomain orderAmountDomain;
    @Resource
    private IDgPerformOrderItemLineDomain orderItemLineDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain orderLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain orderItemLineAmountDomain;
    @Resource
    private IDgAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private IDgAfterSaleOrderItemDomain afterSaleOrderItemDomain;
    @Resource
    private IDgPerformNoticeSyncRecordShippingDomain performNoticeSyncRecordShippingDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoDomain performOrderWarehouseInfoDomain;
    @Resource
    private IDgAfterSaleOrderOptAction dgAfterSaleOrderOptAction;
    @Resource
    private IDictQueryApiProxy dictQueryApiProxy;
    @Resource
    private ITrOrderItemQueryApiProxy trOrderItemQueryApiProxy;
    @Resource
    private ITfOrderQueryApiProxy tfOrderQueryApiProxy;
    @Resource
    private ITfOrderRefundQueryApiProxy tfOrderRefundQueryApiProxy;
    @Resource
    private ITfOrderReturnRefundQueryApiProxy tfOrderReturnRefundQueryApiProxy;
    @Resource
    private IPlaceOrderGoodsApiProxy placeOrderGoodsApiProxy;

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_UNCOMMITTED)
    @DgRedisLock(lockName="saleOrder", key="#addReqDto.platformOrderNo", condition="#addReqDto.platformOrderNo!=null")
    public String addCisSaleOrder(DgBizPerformOrderReqDto addReqDto) {
        DgPerformOrderRespDto performOrderRespDto = this.dgOmsOrderDomain.addCisSaleOrder(addReqDto);
        addReqDto.setId(performOrderRespDto.getId());
        performOrderRespDto.setHomeInstallation(addReqDto.getHomeInstallation());
        List<DgPerformOrderLineDetailDto> performOrderLineDtos = this.calculateOrderItems(addReqDto, performOrderRespDto);
        if (DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode().equals(addReqDto.getBizModel())) {
            this.dgOmsOrderLineBizOptDomain.batchSaveOrderItemByNum(performOrderLineDtos, performOrderRespDto);
        } else if (DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode().equals(addReqDto.getBizModel())) {
            this.dgOmsOrderLineBizOptDomain.batchSaveOrderItemByLine(performOrderLineDtos, performOrderRespDto);
        }
        this.commonLabelManageService.markOrderSourcePromotion(addReqDto);
        return performOrderRespDto.getSaleOrderNo();
    }

    private List<DgPerformOrderLineDetailDto> calculateOrderItems(DgBizPerformOrderReqDto addReqDto, DgPerformOrderRespDto performOrderRespDto) {
        String homeInstallation = addReqDto.getHomeInstallation();
        List<DgPerformOrderItemReqDto> allItemList = this.getAllItemList(addReqDto);
        LinkedList<DgPerformOrderLineDetailDto> dgPerformOrderLineDtos = new LinkedList<DgPerformOrderLineDetailDto>();
        for (DgPerformOrderItemReqDto itemReqDto : allItemList) {
            if (StringUtils.equals((CharSequence)itemReqDto.getType(), (CharSequence)DgSaleOrderItemTypeEnum.COMBINATION.getType())) {
                log.info("[\u91d1\u989d\u8ba1\u7b97]\u8ba1\u7b97\u7ec4\u5408\u5546\u54c1\u5747\u644a\u91d1\u989d\uff0c\u7ec4\u5408\u5546\u54c1\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)itemReqDto));
                List<DgPerformOrderLineDetailDto> subItemEos = this.omsOrderItemService.bundleItemDivide(itemReqDto, performOrderRespDto);
                dgPerformOrderLineDtos.addAll(subItemEos);
                continue;
            }
            DgPerformOrderLineDetailDto orderLineDetailDto = new DgPerformOrderLineDetailDto();
            CubeBeanUtils.copyProperties((Object)orderLineDetailDto, (Object)itemReqDto, (String[])new String[0]);
            orderLineDetailDto.setOrderId(performOrderRespDto.getId());
            orderLineDetailDto.setOrderNo(performOrderRespDto.getSaleOrderNo());
            orderLineDetailDto.setItemType(itemReqDto.getType());
            orderLineDetailDto.setGiftFlag(itemReqDto.getGift());
            orderLineDetailDto.setSaleAmount(itemReqDto.getSalePrice().multiply(itemReqDto.getCalcItemNum()));
            log.info("\u5546\u54c1\u884c\u72b6\u6001:{}", (Object)itemReqDto.getStatus());
            orderLineDetailDto.setStatus(StringUtils.isBlank((CharSequence)itemReqDto.getStatus()) ? DgOmsOrderLineStatusEnum.NORMAL.getCode() : itemReqDto.getStatus());
            itemReqDto.setHomeInstallation(homeInstallation);
            dgPerformOrderLineDtos.add(orderLineDetailDto);
        }
        log.info("[\u8ba2\u5355\u65b0\u589e]\u8ba1\u7b97\u8ba2\u5355\u5546\u54c1\u7684\u76f8\u5173\u91d1\u989d\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString(dgPerformOrderLineDtos));
        BigDecimal totalItemCount = dgPerformOrderLineDtos.stream().map(DgPerformOrderLineDto::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (!totalItemCount.equals(performOrderRespDto.getGoodsTotalNum())) {
            DgPerformOrderInfoEo updateCountEo = new DgPerformOrderInfoEo();
            updateCountEo.setId(performOrderRespDto.getId());
            updateCountEo.setGoodsTotalNum(totalItemCount);
            this.performOrderInfoDomain.updateSelective((BaseEo)updateCountEo);
        }
        return dgPerformOrderLineDtos;
    }

    private List<DgPerformOrderItemReqDto> getAllItemList(DgBizPerformOrderReqDto addReqDto) {
        ArrayList<DgPerformOrderItemReqDto> allItemList = new ArrayList<DgPerformOrderItemReqDto>();
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getItemList())) {
            allItemList.addAll(addReqDto.getItemList());
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getGiftList())) {
            addReqDto.getGiftList().forEach(dto -> {
                if (dto.getGift() != null) {
                    if (DgGiftEnum.GIFT.getType().equals(dto.getGift()) && !Objects.equals(DgGiftTypeEnum.AUTO.getType(), dto.getGiftType())) {
                        dto.setGiftType(addReqDto.getManualCreate() != false ? DgGiftTypeEnum.MANUAL.getType() : DgGiftTypeEnum.PLATFORM.getType());
                    }
                } else if (dto.getPayAmount() == null || dto.getPayAmount().compareTo(BigDecimal.ZERO) == 0) {
                    dto.setGiftType(addReqDto.getManualCreate() != false ? DgGiftTypeEnum.MANUAL.getType() : DgGiftTypeEnum.PLATFORM.getType());
                }
            });
            allItemList.addAll(addReqDto.getGiftList());
        }
        return allItemList;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void cancelSaleOrder(Long orderId, String cancelReason) {
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        Boolean cancelResult = this.inventoryApiServcie.releaseChannelInventory(performOrderRespDto);
        if (!cancelResult.booleanValue()) {
            throw PcpTradeExceptionCode.CHECK_STATUS_ORDER_CANCEL_INVENTORY_CANCEL_FAIL.builderException();
        }
        DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
        updateReqDto.setId(orderId);
        updateReqDto.setCancelReason(cancelReason);
        this.performOrderInfoDomain.modifySaleOrder((DgPerformOrderInfoDto)updateReqDto);
    }

    @Override
    public void modifyHomeInstallation(DgPerformOrderReqDto orderReqDto) {
        this.omsOrderItemService.modifyHomeInstallation(orderReqDto);
    }

    @Override
    public void installationPush(DgPerformOrderReqDto orderReqDto) {
        this.omsOrderItemService.installationPush(orderReqDto);
    }

    @Override
    public void updateParcelSignStatus(DgPerformOrderReqDto reqDto) {
        log.info("\u66f4\u65b0\u5305\u88f9\u7b7e\u6536\u72b6\u6001\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        DgPerformOrderInfoEo orderInfoEo = (DgPerformOrderInfoEo)this.performOrderInfoDomain.selectByPrimaryKey(reqDto.getId());
        if (ObjectUtil.isNotEmpty((Object)orderInfoEo)) {
            AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)orderInfoEo.getId()), (String)"\u53c2\u6570\u5f02\u5e38");
            DgPerformOrderInfoEo updateEo = new DgPerformOrderInfoEo();
            updateEo.setId(orderInfoEo.getId());
            updateEo.setParcelSignStatus(reqDto.getParcelSignStatus());
            this.performOrderInfoDomain.updateSelective((BaseEo)updateEo);
        }
    }

    @Override
    public void batchUpdateTransferNo(List<String> orderNos, String transferNo) {
        DgPerformOrderInfoEo updateEo = new DgPerformOrderInfoEo();
        updateEo.setIsSettledTransfer(YesOrNoEnum.YES.getType());
        updateEo.setSettledTransferOrderNo(transferNo);
        List orderList = CollectionUtil.split(orderNos, (int)200);
        for (List orders : orderList) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
            updateWrapper.in((Object)"sale_order_no", (Collection)orders);
            this.performOrderInfoDomain.getMapper().update((Object)updateEo, (Wrapper)updateWrapper);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String reCalByOrderNo(String orderNo) {
        DgPerformOrderInfoEo orderInfo = this.performOrderInfoDomain.queryByOrderNo(orderNo);
        if (Objects.equals(orderInfo.getOrderSource(), DgSaleOrderSourceEnum.SPLIT.getType())) {
            throw new BizException("\u5355\u53f7" + orderNo + "\u4e3a\u62c6\u5355\u540e\u7684\u5b50\u5355,\u4e0d\u53c2\u4e0e\u91cd\u65b0\u8ba1\u7b97");
        }
        TfOrderRespDto tfOrder = (TfOrderRespDto)RestResponseHelper.extractData((RestResponse)this.tfOrderQueryApiProxy.queryBySaleOrderNo(orderNo));
        List tfOrderItemList = (List)RestResponseHelper.extractData((RestResponse)this.trOrderItemQueryApiProxy.queryByOrderNo(tfOrder.getPlatformOrderNo()));
        tfOrderItemList = tfOrderItemList.stream().filter(item -> item.getGift() == 0).collect(Collectors.toList());
        List orderLineEoList = this.orderLineDomain.queryEosByOrderId(orderInfo.getId()).stream().filter(line -> line.getGiftFlag() == 0).collect(Collectors.toList());
        orderLineEoList = orderLineEoList.stream().filter(line -> line.getGiftFlag() == 0).collect(Collectors.toList());
        Map<String, List<DgPerformOrderLineEo>> orderLineMapOid = orderLineEoList.stream().collect(Collectors.groupingBy(DgPerformOrderLineEo::getPlatformOrderItemNo));
        List orderItemLineEoList = this.orderItemLineDomain.queryByOrderId(orderInfo.getId());
        Map<Long, List<DgPerformOrderItemLineEo>> orderItemLineMapOrderLineId = orderItemLineEoList.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getOrderLineId));
        orderInfo.setId(orderInfo.getId());
        orderInfo.setPayAmount(tfOrder.getRealPayAmount());
        orderInfo.setRealPayAmount(tfOrder.getRealPayAmount());
        orderInfo.setStateSubsidiesAmount(tfOrder.getStateSubsidiesAmount());
        Optional.ofNullable(tfOrder.getStateSubsidiesAmount()).ifPresent(subsidiesAmount -> orderInfo.setSubsidiesType(subsidiesAmount.compareTo(BigDecimal.ZERO) > 0 ? Integer.valueOf(1) : null));
        this.performOrderInfoDomain.updateSelective((BaseEo)orderInfo);
        DgPerformOrderAmountEo updateOrderAmountEo = this.orderAmountDomain.selectByOrderId(orderInfo.getId());
        updateOrderAmountEo.setRealPayAmount(orderInfo.getRealPayAmount());
        updateOrderAmountEo.setPayAmount(orderInfo.getPayAmount());
        this.orderAmountDomain.updateSelective((BaseEo)updateOrderAmountEo);
        for (TfOrderItemRespDto tfOrderItem : tfOrderItemList) {
            if (!orderLineMapOid.containsKey(tfOrderItem.getOid())) continue;
            List<DgPerformOrderLineEo> orderLineList = orderLineMapOid.get(tfOrderItem.getOid());
            if (orderLineList.size() == 1) {
                DgPerformOrderLineEo orderLine = orderLineList.get(0);
                List orderItemLineList2 = orderItemLineMapOrderLineId.getOrDefault(orderLine.getId(), new ArrayList());
                this.calOrderLineAndOrderItemLine(orderInfo, tfOrderItem.getRealPayAmount(), tfOrderItem.getStateSubsidiesAmount(), orderLine, orderItemLineList2);
                continue;
            }
            if (orderLineList.size() <= 1) continue;
            BigDecimal amount = tfOrderItem.getRealPayAmount();
            BigDecimal total = orderLineList.stream().map(DgPerformOrderLineEo::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal remainAmount = new BigDecimal(amount.toString());
            BigDecimal subsidiesAmount2 = Optional.ofNullable(tfOrderItem.getStateSubsidiesAmount()).orElse(BigDecimal.ZERO);
            BigDecimal subsidiesAmountRemain = new BigDecimal(subsidiesAmount2.toString());
            for (int i = 0; i < orderLineList.size(); ++i) {
                BigDecimal lineSubsidiesAmount;
                BigDecimal lineAmount;
                DgPerformOrderLineEo orderLine = orderLineList.get(i);
                List orderItemLineList3 = orderItemLineMapOrderLineId.getOrDefault(orderLine.getId(), new ArrayList());
                BigDecimal ratio = orderLine.getPayAmount().divide(total, 10, RoundingMode.HALF_UP);
                if (i == orderLineList.size() - 1) {
                    lineAmount = remainAmount;
                    lineSubsidiesAmount = subsidiesAmountRemain;
                } else {
                    lineAmount = amount.multiply(ratio).setScale(2, RoundingMode.HALF_UP);
                    lineSubsidiesAmount = subsidiesAmount2.multiply(ratio).setScale(2, RoundingMode.HALF_UP);
                    remainAmount = remainAmount.subtract(lineAmount).setScale(2, RoundingMode.HALF_UP);
                    subsidiesAmountRemain = subsidiesAmountRemain.subtract(lineSubsidiesAmount).setScale(2, RoundingMode.HALF_UP);
                }
                this.calOrderLineAndOrderItemLine(orderInfo, lineAmount, lineSubsidiesAmount, orderLine, orderItemLineList3);
            }
        }
        if (!Objects.equals(orderInfo.getOrderStatus(), DgOmsSaleOrderStatus.SPLIT.getCode())) {
            return "";
        }
        List splitedOrderList = this.performOrderInfoDomain.querySplitEoByPlatformOrderNo(orderInfo.getPlatformOrderNo());
        for (DgPerformOrderInfoEo splitOrderInfo : splitedOrderList) {
            List splitOrderLineList = this.orderLineDomain.queryEosByOrderId(splitOrderInfo.getId());
            List splitOrderItemLineList = this.orderItemLineDomain.queryItemLineByOrderLineIds(splitOrderLineList.stream().map(BaseEo::getId).collect(Collectors.toList())).stream().filter(line -> line.getGiftFlag() == 0).collect(Collectors.toList());
            Map<Long, List<DgPerformOrderItemLineEo>> orderItemLineMapByOrderLineId = splitOrderItemLineList.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getOrderLineId));
            orderItemLineMapByOrderLineId.forEach((orderLineId, orderItemLineList) -> {
                DgPerformOrderLineEo orderLineEo = this.orderLineDomain.queryById(orderLineId);
                orderLineEo.setPayAmount(orderItemLineList.stream().map(DgPerformOrderItemLineEo::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                DgPerformOrderLineAmountEo orderLineAmountActual = this.orderLineAmountDomain.queryByLineId(orderLineEo.getId(), DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode());
                orderLineAmountActual.setAmount(orderLineEo.getPayAmount());
                this.orderLineDomain.updateSelective((BaseEo)orderLineEo);
                this.orderLineAmountDomain.updateSelective((BaseEo)orderLineAmountActual);
            });
            splitOrderInfo.setPayAmount(splitOrderItemLineList.stream().map(DgPerformOrderItemLineEo::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            splitOrderInfo.setRealPayAmount(splitOrderInfo.getPayAmount());
            this.performOrderInfoDomain.updateSelective((BaseEo)splitOrderInfo);
            DgPerformOrderAmountEo splitOrderAmount = this.orderAmountDomain.selectByOrderId(splitOrderInfo.getId());
            splitOrderAmount.setRealPayAmount(splitOrderInfo.getRealPayAmount());
            splitOrderAmount.setPayAmount(splitOrderInfo.getPayAmount());
            this.orderAmountDomain.updateSelective((BaseEo)splitOrderAmount);
        }
        return "";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String reCalByAfterOrderNo(String orderNo) {
        DgAfterSaleOrderEo afterSaleOrder = this.afterSaleOrderDomain.queryByAfterSaleOrderNo(orderNo);
        if (!Objects.equals(afterSaleOrder.getAfterSaleOrderType(), AfterSaleOrderTypeEnum.HH.getCode())) {
            throw new BizException("\u552e\u540e\u5355\u4e0d\u662f\u6362\u8d27\u5355");
        }
        List afterItemList = this.afterSaleOrderItemDomain.queryEosByAfterSaleOrderId(afterSaleOrder.getId()).stream().filter(item -> Objects.equals(item.getAfterSaleOrderItemType(), AfterSaleOrderItemTypeEnum.SH.getType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(afterItemList)) {
            throw new BizException("\u67e5\u8be2\u4e0d\u5230\u660e\u7ec6");
        }
        DgPerformOrderInfoEo orderInfo = this.performOrderInfoDomain.queryEoById(afterSaleOrder.getExchangeSaleOrderId());
        if (Objects.isNull(orderInfo)) {
            throw new BizException("\u67e5\u8be2\u4e0d\u5230\u6362\u8d27\u53d1\u51fa\u5355");
        }
        List orderLineEos = this.orderLineDomain.queryEosByOrderId(orderInfo.getId());
        if (CollectionUtils.isEmpty((Collection)orderLineEos)) {
            throw new BizException("\u67e5\u8be2\u4e0d\u5230\u6362\u8d27\u53d1\u51fa\u5355\u660e\u7ec6");
        }
        afterSaleOrder.setRefundFee(orderInfo.getRealPayAmount());
        this.afterSaleOrderDomain.updateSelective((BaseEo)afterSaleOrder);
        for (DgAfterSaleOrderItemEo afterItem : afterItemList) {
            DgPerformOrderLineAmountEo dgPerformOrderLineAmountEo = null;
            Iterator iterator = orderLineEos.iterator();
            if (iterator.hasNext()) {
                DgPerformOrderLineEo orderLine = (DgPerformOrderLineEo)iterator.next();
                if (Objects.equals(afterItem.getSkuCode(), orderLine.getSkuCode()) && Objects.equals(afterItem.getItemNum(), orderLine.getItemNum().intValue())) {
                    dgPerformOrderLineAmountEo = this.orderLineAmountDomain.queryByLineId(orderLine.getId(), DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode());
                }
            }
            if (!Objects.nonNull(dgPerformOrderLineAmountEo)) continue;
            afterItem.setRefundAmount(dgPerformOrderLineAmountEo.getAmount());
            afterItem.setOrigPayAmount(dgPerformOrderLineAmountEo.getAmount());
            this.afterSaleOrderItemDomain.updateSelective((BaseEo)afterItem);
        }
        return "";
    }

    @Override
    public String reCalAfterOrder(String orderNo, BigDecimal refundAmount) {
        DgAfterSaleOrderEo order = this.afterSaleOrderDomain.queryByAfterSaleOrderNo(orderNo);
        order.setRefundFee(refundAmount);
        this.afterSaleOrderDomain.updateSelective((BaseEo)order);
        HashMap<Long, BigDecimal> itemAmountMap = new HashMap<Long, BigDecimal>();
        List orderItemList = this.afterSaleOrderItemDomain.queryEosByAfterSaleOrderId(order.getId());
        BigDecimal totalRefundAmount = orderItemList.stream().map(DgAfterSaleOrderItemEo::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal remain = new BigDecimal(refundAmount.toString());
        for (int i = 0; i < orderItemList.size(); ++i) {
            BigDecimal newRefundAmount;
            DgAfterSaleOrderItemEo item = (DgAfterSaleOrderItemEo)orderItemList.get(i);
            BigDecimal limit = this.getLimit(item.getSaleOrderItemId());
            BigDecimal itemRefundAmount2 = item.getRefundAmount();
            log.info("\u91cd\u8ba1\u7b97,\u552e\u540e\u5355\u552e\u540e\u5355\u53f7{},\u660e\u7ec6{},limit{},remain{}", new Object[]{order.getAfterSaleOrderNo(), item.getSkuCode() + item.getSkuName(), limit, remain});
            if (i == orderItemList.size() - 1) {
                newRefundAmount = remain;
            } else {
                BigDecimal radio = itemRefundAmount2.divide(totalRefundAmount, 10, RoundingMode.HALF_UP);
                newRefundAmount = refundAmount.multiply(radio).setScale(2, RoundingMode.HALF_UP);
            }
            if (newRefundAmount.compareTo(limit) > 0) {
                newRefundAmount = limit;
            }
            remain = remain.subtract(newRefundAmount);
            log.info("\u91cd\u8ba1\u7b97,\u552e\u540e\u5355\u552e\u540e\u5355\u53f7{},\u660e\u7ec6{},\u91d1\u989d{},remain{}", new Object[]{order.getAfterSaleOrderNo(), item.getSkuCode() + item.getSkuName(), newRefundAmount, remain});
            itemAmountMap.put(item.getId(), newRefundAmount);
            item.setRefundAmount(newRefundAmount);
        }
        if (remain.compareTo(BigDecimal.ZERO) > 0) {
            for (DgAfterSaleOrderItemEo orderItem : orderItemList) {
                BigDecimal itemRefundAmount3 = orderItem.getRefundAmount();
                BigDecimal limit = this.getLimit(orderItem.getSaleOrderItemId());
                if (limit.compareTo(itemRefundAmount3) <= 0) continue;
                if (limit.subtract(itemRefundAmount3).compareTo(remain) >= 0) {
                    itemRefundAmount3 = itemRefundAmount3.add(remain);
                    remain = BigDecimal.ZERO;
                } else {
                    remain = remain.subtract(limit.subtract(itemRefundAmount3));
                    itemRefundAmount3 = limit;
                }
                orderItem.setRefundAmount(itemRefundAmount3);
            }
        }
        if (remain.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal totalItemRefund = orderItemList.stream().map(DgAfterSaleOrderItemEo::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal lastRemain = new BigDecimal(remain.toString());
            for (int i = 0; i < orderItemList.size(); ++i) {
                BigDecimal refundDivide;
                DgAfterSaleOrderItemEo item = (DgAfterSaleOrderItemEo)orderItemList.get(i);
                BigDecimal itemRefundAmount4 = item.getRefundAmount();
                if (i == orderItemList.size() - 1) {
                    refundDivide = lastRemain;
                } else {
                    BigDecimal radio = itemRefundAmount4.divide(totalItemRefund, 10, RoundingMode.HALF_UP);
                    refundDivide = remain.multiply(radio).setScale(2, RoundingMode.HALF_UP);
                }
                lastRemain = lastRemain.subtract(refundDivide);
                itemRefundAmount4 = itemRefundAmount4.add(refundDivide);
                item.setRefundAmount(itemRefundAmount4);
            }
        }
        orderItemList.forEach(arg_0 -> ((IDgAfterSaleOrderItemDomain)this.afterSaleOrderItemDomain).updateSelective(arg_0));
        itemAmountMap.forEach((afterOrderItemId, itemRefundAmount) -> {
            List<DgPerformOrderItemLineEo> orderItemLineList = this.orderItemLineDomain.queryItemLineByAfterOrderItemId(afterOrderItemId);
            orderItemLineList = orderItemLineList.stream().filter(s -> s.getItemNum() != null && s.getItemNum().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
            BigDecimal totalItemNum = orderItemLineList.stream().map(DgPerformOrderItemLineEo::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add).abs();
            BigDecimal lineRemain = new BigDecimal(itemRefundAmount.toString()).setScale(2, RoundingMode.HALF_UP);
            for (int i = 0; i < orderItemLineList.size(); ++i) {
                BigDecimal newRefundAmount;
                DgPerformOrderItemLineEo itemLine = (DgPerformOrderItemLineEo)orderItemLineList.get(i);
                if (i == orderItemList.size() - 1) {
                    newRefundAmount = lineRemain;
                } else {
                    BigDecimal itemNum = itemLine.getItemNum().abs();
                    BigDecimal radio = itemNum.divide(totalItemNum, 10, RoundingMode.HALF_UP);
                    newRefundAmount = itemRefundAmount.multiply(radio).setScale(2, RoundingMode.HALF_UP);
                    lineRemain = lineRemain.subtract(newRefundAmount);
                }
                itemLine.setPayAmount(newRefundAmount.abs().negate());
            }
            orderItemLineList.forEach(arg_0 -> ((IDgPerformOrderItemLineDomain)this.orderItemLineDomain).updateSelective(arg_0));
        });
        return "";
    }

    @Override
    public String reCalAfterOrderByPlatformRefundOrderSn(String platformRefundOrderSn) {
        BigDecimal amount = BigDecimal.ZERO;
        TfOrderRefundRespDto tfOrderRefundRespDto = (TfOrderRefundRespDto)RestResponseHelper.extractData((RestResponse)this.tfOrderRefundQueryApiProxy.queryByAfterSaleOrderNo(platformRefundOrderSn));
        amount = Optional.ofNullable(tfOrderRefundRespDto).map(TfOrderRefundRespDto::getRefundFee).orElse(BigDecimal.ZERO);
        if (amount.compareTo(BigDecimal.ZERO) <= 0) {
            TfOrderReturnRefundRespDto tfOrderReturnRefundRespDto = (TfOrderReturnRefundRespDto)RestResponseHelper.extractData((RestResponse)this.tfOrderReturnRefundQueryApiProxy.queryByAfterSaleOrderNo(platformRefundOrderSn));
            amount = Optional.ofNullable(tfOrderReturnRefundRespDto).map(TfOrderReturnRefundRespDto::getRefundFee).orElse(BigDecimal.ZERO);
        }
        log.info("\u91cd\u8ba1\u7b97,\u5e73\u53f0\u552e\u540e\u5355\u53f7{}\u91d1\u989d{}", (Object)platformRefundOrderSn, (Object)amount);
        AssertUtils.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)("\u5e73\u53f0\u5355\u91d1\u989d\u6709\u8bef" + platformRefundOrderSn + "\u9000\u6b3e\u91d1\u989d\u4e3a" + amount));
        List afterOrderList = this.afterSaleOrderDomain.queryByPlatformRefundOrderSn(platformRefundOrderSn);
        BigDecimal totalRefundAmount = afterOrderList.stream().map(DgAfterSaleOrderEo::getRefundFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>();
        BigDecimal remain = new BigDecimal(amount.toString());
        for (int i = 0; i < afterOrderList.size(); ++i) {
            BigDecimal newRefundRee;
            DgAfterSaleOrderEo order = (DgAfterSaleOrderEo)afterOrderList.get(i);
            BigDecimal limit = this.getLimit(order.getAfterSaleOrderNo());
            BigDecimal refundFee = order.getRefundFee();
            if (i == afterOrderList.size() - 1) {
                newRefundRee = remain;
            } else {
                BigDecimal radio = refundFee.divide(totalRefundAmount, 10, RoundingMode.HALF_UP);
                newRefundRee = amount.multiply(radio).setScale(2, RoundingMode.HALF_UP);
            }
            if (newRefundRee.compareTo(limit) > 0) {
                newRefundRee = limit;
            }
            remain = remain.subtract(newRefundRee);
            log.info("\u91cd\u8ba1\u7b97,\u552e\u540e\u5355\u552e\u540e\u5355\u53f7{}\u91d1\u989d{}", (Object)order.getAfterSaleOrderNo(), (Object)newRefundRee);
            amountMap.put(order.getAfterSaleOrderNo(), newRefundRee);
        }
        if (remain.compareTo(BigDecimal.ZERO) > 0) {
            for (Map.Entry entry : amountMap.entrySet()) {
                String orderNo = (String)entry.getKey();
                BigDecimal refundAmount = (BigDecimal)entry.getValue();
                BigDecimal limit = this.getLimit(orderNo);
                if (limit.compareTo(refundAmount) > 0) {
                    if (limit.subtract(refundAmount).compareTo(remain) >= 0) {
                        refundAmount = refundAmount.add(remain);
                        remain = BigDecimal.ZERO;
                    } else {
                        remain = remain.subtract(limit.subtract(refundAmount));
                        refundAmount = limit;
                    }
                }
                amountMap.put(orderNo, refundAmount);
            }
        }
        if (remain.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal lastRemain = new BigDecimal(remain.toString());
            BigDecimal totalRefund = amountMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            int i = 0;
            for (Map.Entry entry : amountMap.entrySet()) {
                String orderNo = (String)entry.getKey();
                BigDecimal refundAmount = (BigDecimal)entry.getValue();
                BigDecimal radio = refundAmount.divide(totalRefund, 10, RoundingMode.HALF_UP);
                BigDecimal refundAmountDivide = i == amountMap.size() - 1 ? lastRemain : remain.multiply(radio).setScale(2, RoundingMode.HALF_UP);
                lastRemain = lastRemain.subtract(refundAmountDivide);
                refundAmount = refundAmount.add(refundAmountDivide);
                amountMap.put(orderNo, refundAmount);
                ++i;
            }
        }
        amountMap.forEach(this::reCalAfterOrder);
        return "";
    }

    @Override
    public String reSaveSupplyPrice(String orderNo) {
        DgPerformOrderInfoEo orderInfo = this.performOrderInfoDomain.queryByOrderNo(orderNo);
        DgPerformOrderSnapshotEo snapshotEo = this.performOrderSnapshotDomain.selectByOrderId(orderInfo.getId());
        List orderLineEoList = this.orderLineDomain.queryEosByOrderId(orderInfo.getId());
        SkuSupplyPriceQueryReqDto reqDto = new SkuSupplyPriceQueryReqDto();
        reqDto.setCustomerId(snapshotEo.getCustomerId());
        reqDto.setCustomerCode(snapshotEo.getCustomerCode());
        reqDto.setShopCode(snapshotEo.getShopCode());
        ArrayList orderLineList = new ArrayList();
        reqDto.setOrderLineList(orderLineList);
        orderLineEoList.forEach(line -> {
            AccountBalanceOrderLineReqDto dto = new AccountBalanceOrderLineReqDto();
            dto.setSkuId(line.getSkuId());
            dto.setSkuCode(line.getSkuCode());
            dto.setGiftFlag(line.getGiftFlag());
            dto.setSettlementPrice(line.getPayAmount());
            orderLineList.add(dto);
        });
        RestResponse skuSupplyPriceResp = this.placeOrderGoodsApiProxy.getSkuSupplyPrice(reqDto);
        log.info("\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u653f\u7b56\u8bf7\u6c42\u7ed3\u679c,reqDtso:{}", (Object)JSON.toJSONString((Object)skuSupplyPriceResp));
        List skuSupplyPriceRespDtos = (List)skuSupplyPriceResp.getData();
        if (CollectionUtils.isNotEmpty((Collection)skuSupplyPriceRespDtos) && Objects.equals(skuSupplyPriceResp.getResultCode(), "0")) {
            HashMap policyPriceRespDtoMap = CollectionUtil.isNotEmpty((Collection)skuSupplyPriceRespDtos) ? skuSupplyPriceRespDtos.stream().collect(Collectors.toMap(SkuSupplyPriceRespDto::getSkuId, Function.identity(), (a, b) -> a)) : new HashMap();
            for (DgPerformOrderLineEo orderLine : orderLineEoList) {
                BigDecimal itemPrice = BigDecimal.ZERO;
                SkuSupplyPriceRespDto skuPolicyPriceRespDto = (SkuSupplyPriceRespDto)policyPriceRespDtoMap.get(orderLine.getSkuId());
                log.info("\u91cd\u65b0\u4fdd\u5b58\u4f9b\u8d27\u4ef7-\u5546\u54c1\u3010{}\u3011\u4f9b\u8d27\u4ef7\u4e3a\uff1a{}", (Object)orderLine.getSkuCode(), skuPolicyPriceRespDto != null ? skuPolicyPriceRespDto.getSupplyPrice() : "");
                if (skuPolicyPriceRespDto == null || skuPolicyPriceRespDto.getSupplyPrice() == null) continue;
                itemPrice = skuPolicyPriceRespDto.getSupplyPrice();
                DgPerformOrderLineAmountEo lineAmount = this.orderLineAmountDomain.queryByLineId(orderLine.getId(), DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode());
                if (Objects.isNull(lineAmount)) {
                    log.info("\u91cd\u65b0\u4fdd\u5b58\u4f9b\u8d27\u4ef7\u8ba2\u5355\u884c-\u65b0\u589e,sku{}", (Object)orderLine.getSkuCode());
                    lineAmount = new DgPerformOrderLineAmountEo();
                    lineAmount.setOrderId(orderLine.getOrderId());
                    lineAmount.setOrderLineId(orderLine.getId());
                    lineAmount.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode());
                    lineAmount.setAccountCategory(DgOrderAmountCategoryEnum.OMS_B2C.getCode());
                    lineAmount.setAccountType(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode());
                    lineAmount.setAmount(itemPrice.multiply(orderLine.getCalcItemNum()));
                    this.orderLineAmountDomain.insert((BaseEo)lineAmount);
                } else {
                    log.info("\u91cd\u65b0\u4fdd\u5b58\u4f9b\u8d27\u4ef7\u8ba2\u5355\u884c-\u66f4\u65b0,amount-id{}", (Object)lineAmount.getId());
                    lineAmount.setAmount(itemPrice.multiply(orderLine.getCalcItemNum()));
                    this.orderLineAmountDomain.updateSelective((BaseEo)lineAmount);
                }
                List itemLineList = this.orderItemLineDomain.queryItemLineByOrderLineId(orderLine.getId());
                for (DgPerformOrderItemLineEo itemLine : (List)Optional.ofNullable(itemLineList).orElse(new ArrayList())) {
                    DgPerformOrderItemLineAmountEo itemLineAmount = this.orderItemLineAmountDomain.queryByOrderItemLineId(itemLine.getId(), DgOmsOrderAmountTypeEnum.ITEM_SUPPLY_PRICE.getCode());
                    if (Objects.isNull(itemLineAmount)) {
                        itemLineAmount = new DgPerformOrderItemLineAmountEo();
                        itemLineAmount.setOrderId(itemLine.getOrderId());
                        itemLineAmount.setOrderItemLineId(itemLine.getId());
                        itemLineAmount.setAmountSource(DgOrderAmountSourceEnum.ORDER_ITEM_BASE.getCode());
                        itemLineAmount.setAccountType(DgOmsOrderAmountTypeEnum.ITEM_SUPPLY_PRICE.getCode());
                        itemLineAmount.setAmount(itemPrice);
                        log.info("\u91cd\u65b0\u4fdd\u5b58\u4f9b\u8d27\u4ef7\u5546\u54c1\u884c-\u65b0\u589e,orderItemLine-id{}", (Object)itemLine.getId());
                        this.orderItemLineAmountDomain.insert((BaseEo)itemLineAmount);
                        continue;
                    }
                    log.info("\u91cd\u65b0\u4fdd\u5b58\u4f9b\u8d27\u4ef7\u5546\u54c1\u884c-\u66f4\u65b0,amount-id{}", (Object)itemLineAmount.getId());
                    itemLineAmount.setAmount(itemPrice);
                    this.orderItemLineAmountDomain.updateSelective((BaseEo)itemLineAmount);
                }
            }
        }
        return "";
    }

    @Override
    public DgBizAfterSaleOrderReqDto reSaveReturnShippingNo(String afterOrderNo) {
        DgAfterSaleOrderEo dgAfterSaleOrderEo = this.afterSaleOrderDomain.queryByAfterSaleOrderNo(afterOrderNo);
        DgPerformOrderInfoEo dgPerformOrderInfoEo = this.performOrderInfoDomain.queryEoById(dgAfterSaleOrderEo.getSaleOrderId());
        TfOrderRespDto tfOrderRespDto = (TfOrderRespDto)RestResponseHelper.extractData((RestResponse)this.tfOrderQueryApiProxy.queryBySaleOrderNo(dgAfterSaleOrderEo.getSaleOrderNo()));
        String shippingNo = tfOrderRespDto.getShippingNo();
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)shippingNo), (String)"\u5e73\u53f0\u7269\u6d41\u5355\u53f7\u4e3a\u7a7a");
        List dgPerformNoticeSyncRecordShippingEos = this.performNoticeSyncRecordShippingDomain.queryByOrderId(dgPerformOrderInfoEo.getId());
        if (((List)Optional.ofNullable(dgPerformNoticeSyncRecordShippingEos).orElse(new ArrayList())).stream().noneMatch(eo -> Objects.equals(eo.getConsignmentNo(), shippingNo))) {
            DgPerformNoticeSyncRecordShippingEo recordShippingEo = new DgPerformNoticeSyncRecordShippingEo();
            recordShippingEo.setOrderId(dgPerformOrderInfoEo.getId());
            recordShippingEo.setShippingType(SyncRecordShippingTypeEnum.ACTUAL_SHIPPING.getCode());
            recordShippingEo.setConsignmentNo(shippingNo);
            recordShippingEo.setShippingCompanyCode(tfOrderRespDto.getShippingCode());
            recordShippingEo.setShippingCompany(tfOrderRespDto.getShippingName());
            recordShippingEo.setOrderType(ShippingOrderTypeEnum.SALE.getCode());
            recordShippingEo.setStatus("NORMAL");
            this.performNoticeSyncRecordShippingDomain.insert((BaseEo)recordShippingEo);
        }
        DgBizAfterSaleOrderReqDto dto = new DgBizAfterSaleOrderReqDto();
        dto.setShippingCode(tfOrderRespDto.getShippingCode());
        dto.setReturnShippingSn(shippingNo);
        dto.setShippingName(tfOrderRespDto.getShippingName());
        dto.setId(dgAfterSaleOrderEo.getId());
        this.performOrderInfoDomain.updateSelective((BaseEo)dgPerformOrderInfoEo);
        return dto;
    }

    @Override
    public String reSaveShippingNo(String orderNo) {
        DgPerformOrderInfoEo dgPerformOrderInfoEo = this.performOrderInfoDomain.queryByOrderNo(orderNo);
        TfOrderRespDto tfOrderRespDto = (TfOrderRespDto)RestResponseHelper.extractData((RestResponse)this.tfOrderQueryApiProxy.queryBySaleOrderNo(orderNo));
        String shippingNo = tfOrderRespDto.getShippingNo();
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)shippingNo), (String)"\u5e73\u53f0\u7269\u6d41\u5355\u53f7\u4e3a\u7a7a");
        DgPerformNoticeSyncRecordShippingEo recordShippingEo = new DgPerformNoticeSyncRecordShippingEo();
        recordShippingEo.setOrderId(dgPerformOrderInfoEo.getId());
        recordShippingEo.setShippingType(SyncRecordShippingTypeEnum.ACTUAL_SHIPPING.getCode());
        recordShippingEo.setConsignmentNo(shippingNo);
        recordShippingEo.setShippingCompanyCode(tfOrderRespDto.getShippingCode());
        recordShippingEo.setShippingCompany(tfOrderRespDto.getShippingName());
        recordShippingEo.setOrderType(ShippingOrderTypeEnum.SALE.getCode());
        recordShippingEo.setStatus("NORMAL");
        this.performNoticeSyncRecordShippingDomain.insert((BaseEo)recordShippingEo);
        this.performOrderInfoDomain.updateSelective((BaseEo)dgPerformOrderInfoEo);
        return "";
    }

    private BigDecimal getLimit(String orderNo) {
        DgAfterSaleOrderEo order = this.afterSaleOrderDomain.queryByAfterSaleOrderNo(orderNo);
        List orderItemList = this.afterSaleOrderItemDomain.queryEosByAfterSaleOrderId(order.getId());
        List orderLineList = this.orderLineDomain.queryByIds(orderItemList.stream().map(DgAfterSaleOrderItemEo::getSaleOrderItemId).collect(Collectors.toList()));
        BigDecimal limit = BigDecimal.ZERO;
        for (DgPerformOrderLineEo line : orderLineList) {
            DgPerformOrderLineAmountEo orderLineAmountActual = this.orderLineAmountDomain.queryByLineId(line.getId(), DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode());
            limit = limit.add(orderLineAmountActual.getAmount());
        }
        return limit;
    }

    private BigDecimal getLimit(Long orderLineId) {
        DgPerformOrderLineEo orderLine = this.orderLineDomain.queryById(orderLineId);
        DgPerformOrderLineAmountEo orderLineAmountActual = this.orderLineAmountDomain.queryByLineId(orderLine.getId(), DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode());
        return orderLineAmountActual.getAmount();
    }

    private void calOrderLineAndOrderItemLine(DgPerformOrderInfoEo orderInfo, BigDecimal amount, BigDecimal stateSubsidiesAmount, DgPerformOrderLineEo orderLine, List<DgPerformOrderItemLineEo> orderItemLineList) {
        if (Objects.equals(orderInfo.getOrderStatus(), DgSaleOrderStatusEnum.SPLIT.getCode())) {
            List splitedOrderList = this.performOrderInfoDomain.querySplitEoByPlatformOrderNo(orderInfo.getPlatformOrderNo());
            List splitOrderLineList = this.orderLineDomain.queryEosByOrderIds(splitedOrderList.stream().map(BaseEo::getId).collect(Collectors.toList()));
            List splitOrderItemLineList = this.orderItemLineDomain.queryItemLineByOrderLineIds(splitOrderLineList.stream().map(BaseEo::getId).collect(Collectors.toList())).stream().filter(line -> line.getGiftFlag() == 0).collect(Collectors.toList());
            Map<String, List<DgPerformOrderItemLineEo>> orderItemLineMapBySkuCode = splitOrderItemLineList.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getSkuCode));
            orderItemLineList = orderItemLineMapBySkuCode.getOrDefault(orderLine.getSkuCode(), new ArrayList());
        }
        orderLine.setPayAmount(amount);
        orderLine.setStateSubsidiesAmount(stateSubsidiesAmount);
        this.orderLineDomain.updateSelective((BaseEo)orderLine);
        DgPerformOrderLineAmountEo orderLineAmountActual = this.orderLineAmountDomain.queryByLineId(orderLine.getId(), DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode());
        DgPerformOrderLineAmountEo orderLineAmountCanRefund = this.orderLineAmountDomain.queryByLineId(orderLine.getId(), DgOmsOrderAmountTypeEnum.LINE_SURPLIUS_CAN_REFUND_PAY_AMOUNT.getCode());
        orderLineAmountActual.setAmount(amount);
        this.orderLineAmountDomain.updateSelective((BaseEo)orderLineAmountActual);
        orderLineAmountCanRefund.setAmount(amount);
        BigDecimal remainAmount = new BigDecimal(amount.toString());
        BigDecimal calDenominator = amount.divide(orderLine.getItemNum(), 2, RoundingMode.HALF_UP);
        for (int i = 0; i < orderItemLineList.size(); ++i) {
            DgPerformOrderItemLineEo orderItemLine = (DgPerformOrderItemLineEo)orderItemLineList.get(i);
            DgPerformOrderItemLineAmountEo orderItemLineAmountActual = (DgPerformOrderItemLineAmountEo)this.orderItemLineAmountDomain.queryByOrderItemLineIdsAndAmountTypes((List)Lists.newArrayList((Object[])new Long[]{orderItemLine.getId()}), (List)Lists.newArrayList((Object[])new String[]{DgOmsOrderAmountTypeEnum.ITEM_ACTUAL_PRICE.getCode()})).get(0);
            DgPerformOrderItemLineAmountEo orderItemLineAmountCanRefund = (DgPerformOrderItemLineAmountEo)this.orderItemLineAmountDomain.queryByOrderItemLineIdsAndAmountTypes((List)Lists.newArrayList((Object[])new Long[]{orderItemLine.getId()}), (List)Lists.newArrayList((Object[])new String[]{DgOmsOrderAmountTypeEnum.ITEM_SURPLIUS_CAN_REFUND_PAY_AMOUNT.getCode()})).get(0);
            if (i == orderItemLineList.size() - 1) {
                orderItemLineAmountCanRefund.setAmount(remainAmount);
                orderItemLineAmountActual.setAmount(remainAmount);
                orderItemLine.setPayAmount(remainAmount);
            } else {
                orderItemLineAmountCanRefund.setAmount(calDenominator);
                orderItemLineAmountActual.setAmount(calDenominator);
                orderItemLine.setPayAmount(calDenominator);
            }
            remainAmount = remainAmount.subtract(calDenominator).setScale(2, RoundingMode.HALF_UP);
            this.orderItemLineAmountDomain.updateSelective((BaseEo)orderItemLineAmountActual);
            this.orderItemLineDomain.updateSelective((BaseEo)orderItemLine);
        }
    }
}

