/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.b2c.Impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.api.inventory.ILogicInventoryExposedQueryApi;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryBasicsQueryReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryBasicsQueryRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuDgRespDto;
import com.yunxi.dg.base.center.item.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.center.trade.constants.DgOmsOrderLineStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemRefundInterceptStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemRefundStatusEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformNoticeSyncRecordItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformNoticeSyncRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemExtRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.ItemLineCancelStatusEnum;
import com.yunxi.dg.base.center.trade.enums.ItemLineReturnStatusEnum;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsQueryOrderItemService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class DgOmsQueryOrderItemServiceImpl
implements IDgOmsQueryOrderItemService {
    private static final Logger log = LoggerFactory.getLogger(DgOmsQueryOrderItemServiceImpl.class);
    @Resource
    private IDgPerformNoticeSyncRecordService dgPerformNoticeSyncRecordService;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private ILogicInventoryExposedQueryApi inventoryExposedQueryApi;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain performOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;

    @Override
    public PageInfo<DgPerformOrderItemExtRespDto> queryByPage(Long orderId, Integer pageNum, Integer pageSize) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto performOrderInfoEo = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)performOrderInfoEo, (String)String.format("orderId=%s\u8ba2\u5355\u4e0d\u5b58\u5728", orderId));
        PageInfo dtoPageInfo = this.omsOrderLineBizQueryDomain.queryPageById(orderId, pageNum, pageSize);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)dtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List<DgPerformOrderItemExtRespDto> list = this.fillItemInfo(dtoPageInfo.getList(), performOrderInfoEo);
        respDtoPageInfo.setList(list);
        return respDtoPageInfo;
    }

    private List<DgPerformOrderItemExtRespDto> fillItemInfo(List<DgPerformOrderLineDto> dtoList, DgPerformOrderRespDto performOrderRespDto) {
        ArrayList<DgPerformOrderItemExtRespDto> list = new ArrayList<DgPerformOrderItemExtRespDto>();
        Map<Object, Object> outQuantityMap = Maps.newHashMap();
        List<DgBizPerformNoticeSyncRecordDto> dgBizPerformNoticeSyncRecordDtos = this.dgPerformNoticeSyncRecordService.queryByOrderId(performOrderRespDto.getId());
        if (CollectionUtils.isNotEmpty(dgBizPerformNoticeSyncRecordDtos)) {
            outQuantityMap = dgBizPerformNoticeSyncRecordDtos.stream().map(DgBizPerformNoticeSyncRecordDto::getDgPerformNoticeSyncRecordDtoItems).flatMap(Collection::stream).collect(Collectors.groupingBy(DgPerformNoticeSyncRecordItemDto::getOrderItemId, Collectors.collectingAndThen(Collectors.toList(), items -> items.stream().map(DgPerformNoticeSyncRecordItemDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }
        List itemCodeList = dtoList.stream().map(DgPerformOrderLineDto::getItemCode).collect(Collectors.toList());
        RestResponse listRestResponse = this.itemSkuDgQueryApiProxy.queryBySkuCode(itemCodeList);
        List itemRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        Map itemRespDtoMap = Optional.ofNullable(itemRespDtos).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, Function.identity(), (v1, v2) -> v2));
        log.info("[\u5206\u9875\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8d27\u54c1\u4fe1\u606f]\u8d27\u54c1\u7684\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(itemRespDtoMap));
        List longCodeList = dtoList.stream().map(DgPerformOrderLineDto::getSkuCode).collect(Collectors.toList());
        InventoryBasicsQueryReqDto inventoryBasicsQueryReqDto = new InventoryBasicsQueryReqDto();
        inventoryBasicsQueryReqDto.setWarehouseCodeList((List)Lists.newArrayList((Object[])new String[]{performOrderRespDto.getDefaultLogicalWarehouseCode()}));
        inventoryBasicsQueryReqDto.setLongCodeList(longCodeList);
        inventoryBasicsQueryReqDto.setInventoryStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        RestResponse commonInventory = this.inventoryExposedQueryApi.queryCommonInventory(inventoryBasicsQueryReqDto);
        List inventoryBasicsQueryRespDtos = (List)RestResponseHelper.extractData((RestResponse)commonInventory);
        Map longCodeInventoryCountMap = Optional.ofNullable(inventoryBasicsQueryRespDtos).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(InventoryBasicsQueryRespDto::getLongCode, Function.identity(), (v1, v2) -> v2));
        Map<Object, Object> finalOutQuantityMap = outQuantityMap;
        List orderLineIdList = dtoList.stream().map(BaseDto::getId).collect(Collectors.toList());
        List amountDtoList = this.performOrderLineAmountDomain.queryByOrderLineIds(orderLineIdList);
        Map<Object, Object> orderLineAmountMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)amountDtoList)) {
            orderLineAmountMap = amountDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountDto::getOrderLineId));
        }
        List orderItemLineEos = this.performOrderItemLineDomain.queryItemLineByOrderLineIds(orderLineIdList);
        Map<Long, String> orderLingIdSnCodeMap = orderItemLineEos.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSnCode())).collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getOrderLineId, Collectors.mapping(DgPerformOrderItemLineEo::getSnCode, Collectors.joining(","))));
        for (DgPerformOrderLineDto orderLineDto : dtoList) {
            ItemSkuDgRespDto itemRespDto = (ItemSkuDgRespDto)itemRespDtoMap.get(orderLineDto.getItemCode());
            orderLineDto.setOutItemNum((BigDecimal)finalOutQuantityMap.get(orderLineDto.getId()));
            if (itemRespDto != null) {
                BigDecimal totalVolume = Optional.ofNullable(itemRespDto.getVolume()).orElse(BigDecimal.ZERO).multiply(orderLineDto.getItemNum());
                BigDecimal totalWeight = Optional.ofNullable(itemRespDto.getGrossWeight()).orElse(BigDecimal.ZERO).multiply(orderLineDto.getItemNum());
                orderLineDto.setVolume(Optional.ofNullable(orderLineDto.getVolume()).orElse(totalVolume));
                orderLineDto.setWeight(Optional.ofNullable(orderLineDto.getWeight()).orElse(totalWeight));
                orderLineDto.setWeightUnit(Optional.ofNullable(orderLineDto.getWeightUnit()).orElse(itemRespDto.getGrossWeightUnit()));
            }
            DgPerformOrderItemExtRespDto respDto = new DgPerformOrderItemExtRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)orderLineDto, (String[])new String[0]);
            respDto.setStatus(StringUtils.isNotBlank((CharSequence)orderLineDto.getStatus()) ? orderLineDto.getStatus() : DgOmsOrderLineStatusEnum.NORMAL.getCode());
            if (null != performOrderRespDto.getPerformOrderSnapshotDto()) {
                if (StringUtils.isNotBlank((CharSequence)performOrderRespDto.getPerformOrderSnapshotDto().getHsCustomerCode())) {
                    respDto.setHsCustomerCode(performOrderRespDto.getPerformOrderSnapshotDto().getHsCustomerCode());
                }
                if (StringUtils.isNotBlank((CharSequence)performOrderRespDto.getPerformOrderSnapshotDto().getHsCustomerName())) {
                    respDto.setHsCustomerName(performOrderRespDto.getPerformOrderSnapshotDto().getHsCustomerName());
                }
            }
            respDto.setGift(orderLineDto.getGiftFlag());
            InventoryBasicsQueryRespDto basicsQueryRespDto = (InventoryBasicsQueryRespDto)longCodeInventoryCountMap.get(orderLineDto.getSkuCode());
            if (basicsQueryRespDto != null) {
                respDto.setAvailableInventory(basicsQueryRespDto.getAvailable());
            }
            respDto.setSaleAmount(orderLineDto.getSalePrice().multiply(Optional.ofNullable(orderLineDto.getCalcItemNum()).orElse(orderLineDto.getItemNum())).setScale(2, 4));
            List orderLineAmountDtos = (List)orderLineAmountMap.get(orderLineDto.getId());
            if (CollectionUtils.isNotEmpty((Collection)orderLineAmountDtos)) {
                Map amountDtoMap = orderLineAmountDtos.stream().filter(e -> e.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode())).collect(Collectors.toMap(DgPerformOrderLineAmountDto::getAccountType, Function.identity(), (a, b) -> a));
                DgPerformOrderLineAmountDto priceAmountDto = (DgPerformOrderLineAmountDto)amountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode());
                respDto.setPrice(null != priceAmountDto ? priceAmountDto.getAmount().divide(Optional.ofNullable(orderLineDto.getCalcItemNum()).orElse(orderLineDto.getItemNum()), 2, 4) : BigDecimal.ZERO);
                respDto.setPayAmount(null != priceAmountDto ? priceAmountDto.getAmount() : BigDecimal.ZERO);
                DgPerformOrderLineAmountDto realPayAmountDto = (DgPerformOrderLineAmountDto)amountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode());
                respDto.setRealPayPrice(null != realPayAmountDto ? realPayAmountDto.getAmount().divide(Optional.ofNullable(orderLineDto.getCalcItemNum()).orElse(orderLineDto.getItemNum()), 2, 4) : BigDecimal.ZERO);
                respDto.setRealPayAmount(null != realPayAmountDto ? realPayAmountDto.getAmount() : BigDecimal.ZERO);
                DgPerformOrderLineAmountDto discountAmountDto = (DgPerformOrderLineAmountDto)amountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode());
                respDto.setDiscountAmount(null != discountAmountDto ? discountAmountDto.getAmount() : BigDecimal.ZERO);
                DgPerformOrderLineAmountDto surplusCanRefundPayAmountDto = (DgPerformOrderLineAmountDto)amountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_SURPLIUS_CAN_REFUND_PAY_AMOUNT.getCode());
                respDto.setSurplusCanRefundPayAmount(null != surplusCanRefundPayAmountDto ? surplusCanRefundPayAmountDto.getAmount() : BigDecimal.ZERO);
                List totalUseCostAmountAmountDtos = amountDtoList.stream().filter(e -> e.getOrderLineId().equals(orderLineDto.getId())).filter(e -> e.getAccountCategory().equals(DgOmsOrderAmountTypeEnum.LINE_COST_AMOUNT.getCode()) && e.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode())).collect(Collectors.toList());
                log.info("\u5546\u54c1\u8d39\u7528\u91d1\u989d\u660e\u7ec6:{}", (Object)JSON.toJSONString(totalUseCostAmountAmountDtos));
                DgPerformOrderLineAmountDto supplyPriceAmountDto = (DgPerformOrderLineAmountDto)amountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode());
                respDto.setSupplyPrice(Optional.ofNullable(supplyPriceAmountDto).map(DgPerformOrderLineAmountDto::getAmount).orElse(BigDecimal.ZERO));
                if (CollectionUtil.isNotEmpty(totalUseCostAmountAmountDtos)) {
                    BigDecimal totalUseCostAmount = totalUseCostAmountAmountDtos.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    respDto.setTotalUseCostAmount(totalUseCostAmount);
                    BigDecimal costAmountProportion = totalUseCostAmount.divide(respDto.getPayAmount(), 4, 4);
                    if (costAmountProportion.compareTo(BigDecimal.ONE) > 0) {
                        costAmountProportion = BigDecimal.ONE;
                        log.error("\u8fd4\u5229\u5206\u644a\u6bd4\u4f8b\u8ba1\u7b97\u9519\u8bef");
                    }
                    costAmountProportion = BigDecimal.ONE.subtract(costAmountProportion);
                    costAmountProportion = costAmountProportion.multiply(new BigDecimal(100));
                    respDto.setCostAmountProportion(costAmountProportion);
                } else {
                    respDto.setTotalUseCostAmount(BigDecimal.ZERO);
                    respDto.setCostAmountProportion(new BigDecimal(100));
                }
                if (null != performOrderRespDto.getPerformOrderSnapshotDto().getKneadeFlag() && performOrderRespDto.getPerformOrderSnapshotDto().getKneadeFlag() == 1) {
                    DgPerformOrderLineAmountDto kneadPayAmountDto = (DgPerformOrderLineAmountDto)amountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_KNEAD_LATER_PAY_AMOUNT.getCode());
                    respDto.setPrice(null != kneadPayAmountDto ? kneadPayAmountDto.getAmount().divide(Optional.ofNullable(orderLineDto.getCalcItemNum()).orElse(orderLineDto.getItemNum()), 2, 4) : BigDecimal.ZERO);
                    respDto.setPayAmount(null != kneadPayAmountDto ? kneadPayAmountDto.getAmount() : BigDecimal.ZERO);
                    DgPerformOrderLineAmountDto kneadRealPayAmountDto = (DgPerformOrderLineAmountDto)amountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_KNEAD_LATER_SETTLEMENT_AMOUNT.getCode());
                    respDto.setRealPayPrice(null != kneadRealPayAmountDto ? kneadRealPayAmountDto.getAmount().divide(Optional.ofNullable(orderLineDto.getCalcItemNum()).orElse(orderLineDto.getItemNum()), 2, 4) : BigDecimal.ZERO);
                    respDto.setRealPayAmount(null != kneadRealPayAmountDto ? kneadRealPayAmountDto.getAmount() : BigDecimal.ZERO);
                    List kneadTotalUseCostAmountAmountDtos = amountDtoList.stream().filter(e -> e.getOrderLineId().equals(orderLineDto.getId())).filter(e -> e.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_COST_KNEAD_TOTAL.getCode()) && e.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode())).collect(Collectors.toList());
                    respDto.setTotalUseCostAmount(CollectionUtil.isNotEmpty(kneadTotalUseCostAmountAmountDtos) ? kneadTotalUseCostAmountAmountDtos.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO);
                }
            }
            respDto.setSnCodes(orderLingIdSnCodeMap.get(orderLineDto.getId()));
            list.add(respDto);
        }
        List afsOrderItemLineEos = this.performOrderItemLineDomain.queryItemLineByAfsOrderItemIds(orderLineIdList);
        if (CollectionUtils.isNotEmpty((Collection)afsOrderItemLineEos)) {
            Map<Long, List<DgPerformOrderItemLineEo>> afsOrderItemLineMap = afsOrderItemLineEos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getOrderLineId));
            this.buildAfsSummary(afsOrderItemLineMap, list);
        } else {
            for (DgPerformOrderItemExtRespDto itemExtRespDto : list) {
                itemExtRespDto.setRefundStatus(DgSaleOrderItemRefundStatusEnum.NOT_REFUND.getCode());
                itemExtRespDto.setRefundedItemNum(BigDecimal.ZERO);
                itemExtRespDto.setRefundedPayAmount(BigDecimal.ZERO);
            }
        }
        this.buildDgSaleOrderItemRefundInterceptStatus(list);
        return list;
    }

    private void buildDgSaleOrderItemRefundInterceptStatus(List<DgPerformOrderItemExtRespDto> list) {
        List orderLineIds = list.stream().map(BaseDto::getId).collect(Collectors.toList());
        List itemLineDtoList = this.performOrderItemLineDomain.queryItemLineDtosByOrderLineIds(orderLineIds);
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)itemLineDtoList), (String)"\u672a\u627e\u5230\u8ba2\u5355\u5173\u8054\u7684\u9500\u552e\u5546\u54c1\u884c");
        Map<Long, List<DgPerformOrderItemLineDto>> orderLineMap = itemLineDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getOrderLineId));
        for (DgPerformOrderItemExtRespDto itemExtRespDto : list) {
            List<DgPerformOrderItemLineDto> orderItemLineDtos = orderLineMap.get(itemExtRespDto.getId());
            if (CollectionUtils.isNotEmpty(orderItemLineDtos)) {
                itemExtRespDto.setRefundInterceptStatus(orderItemLineDtos.get(0).getRefundInterceptStatus());
                continue;
            }
            itemExtRespDto.setRefundInterceptStatus(DgSaleOrderItemRefundInterceptStatusEnum.NORMAL.getCode());
        }
    }

    private void buildAfsSummary(Map<Long, List<DgPerformOrderItemLineEo>> afsOrderItemLineMap, List<DgPerformOrderItemExtRespDto> dtoList) {
        for (DgPerformOrderItemExtRespDto orderLineDto : dtoList) {
            List refundingItemLineEos;
            List exchangeItemLineEos;
            List refundSuccessItemLineEos;
            List<DgPerformOrderItemLineEo> afsOrderItemLineEos = afsOrderItemLineMap.get(orderLineDto.getId());
            if (CollectionUtils.isEmpty(afsOrderItemLineEos)) {
                orderLineDto.setRefundStatus(DgSaleOrderItemRefundStatusEnum.NOT_REFUND.getCode());
                orderLineDto.setRefundedItemNum(BigDecimal.ZERO);
                orderLineDto.setRefundedPayAmount(BigDecimal.ZERO);
                continue;
            }
            BigDecimal refundingNumber = BigDecimal.ZERO;
            BigDecimal refundingAmount = BigDecimal.ZERO;
            BigDecimal refundNumber = BigDecimal.ZERO;
            BigDecimal refundAmount = BigDecimal.ZERO;
            BigDecimal exchangeNumber = BigDecimal.ZERO;
            BigDecimal exchangeAmount = BigDecimal.ZERO;
            orderLineDto.setRefundStatus(DgSaleOrderItemRefundStatusEnum.NOT_REFUND.getCode());
            List returnedSuccessItemLineEos = afsOrderItemLineEos.stream().filter(eo -> ItemLineReturnStatusEnum.YES.getType().equals(eo.getReturnStatus())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(returnedSuccessItemLineEos)) {
                refundNumber = returnedSuccessItemLineEos.stream().map(DgPerformOrderItemLineEo::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add).negate();
            }
            if (CollectionUtils.isNotEmpty(refundSuccessItemLineEos = afsOrderItemLineEos.stream().filter(eo -> eo.getRefundStatus().equals(DgSaleOrderItemRefundStatusEnum.REFUNDED.getCode()) && eo.getReturnStatus() > 0).collect(Collectors.toList()))) {
                refundAmount = refundSuccessItemLineEos.stream().map(DgPerformOrderItemLineEo::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add).negate();
                orderLineDto.setRefundStatus(DgSaleOrderItemRefundStatusEnum.REFUNDED.getCode());
            }
            if (CollectionUtils.isNotEmpty(exchangeItemLineEos = afsOrderItemLineEos.stream().filter(eo -> eo.getRefundStatus().equals(DgSaleOrderItemRefundStatusEnum.NORMAL.getCode())).collect(Collectors.toList()))) {
                exchangeNumber = exchangeItemLineEos.stream().map(DgPerformOrderItemLineEo::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add).negate();
                exchangeAmount = exchangeItemLineEos.stream().map(DgPerformOrderItemLineEo::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add).negate();
            }
            if (CollectionUtils.isNotEmpty(refundingItemLineEos = afsOrderItemLineEos.stream().filter(eo -> eo.getRefundStatus().equals(DgSaleOrderItemRefundStatusEnum.REFUNDING.getCode())).collect(Collectors.toList()))) {
                refundingAmount = refundingItemLineEos.stream().map(DgPerformOrderItemLineEo::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add).negate();
            }
            if (CollectionUtils.isNotEmpty(refundingItemLineEos)) {
                orderLineDto.setRefundStatus(DgSaleOrderItemRefundStatusEnum.REFUNDING.getCode());
            }
            orderLineDto.setRefundedItemNum(refundNumber);
            orderLineDto.setRefundedPayAmount(refundAmount);
            orderLineDto.setRefundingNumber(refundingNumber);
            orderLineDto.setRefundingAmount(refundingAmount);
            orderLineDto.setSurplusCanReturnItemNum(orderLineDto.getItemNum().subtract(refundingNumber).subtract(refundNumber).subtract(exchangeNumber));
            orderLineDto.setSurplusCanRefundPayAmount(orderLineDto.getPayAmount().subtract(refundingAmount).subtract(refundAmount).subtract(exchangeAmount));
            log.info("\u8ba2\u5355\u884cID:{},\u9000\u6b3e\u72b6\u6001:{},\u6362\u8d27\u9000\u56de\u7684\u6570\u91cf:{},\u9000\u6b3e\u4e2d\u6570\u91cf:{},\u9000\u6b3e\u4e2d\u91d1\u989d:{},\u5df2\u9000\u6570\u91cf:{},\u5df2\u9000\u91d1\u989d:{},\u53ef\u7533\u8bf7\u9000\u6b3e\u6570\u91cf:{},\u53ef\u7533\u8bf7\u9000\u6b3e\u91d1\u989d:{}", new Object[]{orderLineDto.getId(), orderLineDto.getRefundStatus(), exchangeNumber, orderLineDto.getRefundingNumber(), orderLineDto.getRefundingAmount(), orderLineDto.getRefundedItemNum(), orderLineDto.getRefundedPayAmount(), orderLineDto.getSurplusCanReturnItemNum(), orderLineDto.getSurplusCanRefundPayAmount()});
        }
    }

    @Override
    public List<DgPerformOrderItemExtRespDto> queryAllByOrderIds(List<Long> orderIds) {
        List orderLineEos = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderIds(orderIds);
        if (CollectionUtils.isEmpty((Collection)orderLineEos)) {
            return new ArrayList<DgPerformOrderItemExtRespDto>();
        }
        List orderItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.performOrderItemLineDomain.filter().in((Object)"order_id", orderIds)).eq((Object)"dr", (Object)0)).list();
        if (CollectionUtils.isEmpty((Collection)orderItemLineEos)) {
            return new ArrayList<DgPerformOrderItemExtRespDto>();
        }
        ArrayList respDtos = Lists.newArrayList();
        Map<Long, List<DgPerformOrderItemLineEo>> itemLineMap = orderItemLineEos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getOrderLineId));
        orderLineEos.forEach(e -> {
            DgPerformOrderItemExtRespDto respDto = new DgPerformOrderItemExtRespDto();
            BeanUtils.copyProperties((Object)e, (Object)respDto);
            List itemLineEos = (List)itemLineMap.get(e.getId());
            BigDecimal waitDeliveryNum = BigDecimal.ZERO;
            BigDecimal deliveryNum = BigDecimal.ZERO;
            BigDecimal cancelNum = BigDecimal.ZERO;
            for (DgPerformOrderItemLineEo itemLineEo : itemLineEos) {
                waitDeliveryNum = waitDeliveryNum.add(itemLineEo.getItemNum().subtract(itemLineEo.getOutItemNum()));
                deliveryNum = deliveryNum.add(itemLineEo.getOutItemNum());
                if (!ItemLineCancelStatusEnum.YES.getType().equals(itemLineEo.getCancelStatus())) continue;
                cancelNum = cancelNum.add(itemLineEo.getItemNum().subtract(itemLineEo.getOutItemNum()));
            }
            respDto.setDeliveredNum(deliveryNum);
            respDto.setCancelNum(cancelNum);
            respDto.setNotDeliveredNum(waitDeliveryNum);
            respDto.setRefundedItemNum(cancelNum);
            respDto.setItemMarketPrice(e.getSalePrice());
            List amountList = e.getAmountDtoList();
            List saleAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode())).collect(Collectors.toList());
            BigDecimal saleAmount = CollectionUtil.isNotEmpty(saleAmountList) ? saleAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
            List payAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode())).collect(Collectors.toList());
            BigDecimal payAmount = CollectionUtil.isNotEmpty(payAmountList) ? payAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
            List realPayAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode())).collect(Collectors.toList());
            BigDecimal realPayAmount = CollectionUtil.isNotEmpty(realPayAmountList) ? realPayAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
            List costAmountList = amountList.stream().filter(a -> a.getAccountCategory().equals(DgOmsOrderAmountTypeEnum.LINE_COST_AMOUNT.getCode()) && a.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode())).collect(Collectors.toList());
            BigDecimal costAmount = CollectionUtil.isNotEmpty(costAmountList) ? costAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
            List discountAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode())).collect(Collectors.toList());
            BigDecimal discountAmount = CollectionUtil.isNotEmpty(discountAmountList) ? discountAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
            List promotionKneadAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_PROMOTION_KNEAD_TOTAL.getCode())).collect(Collectors.toList());
            BigDecimal promotionKneadAmount = CollectionUtil.isNotEmpty(promotionKneadAmountList) ? promotionKneadAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
            List costKneadAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_COST_KNEAD_TOTAL.getCode())).collect(Collectors.toList());
            BigDecimal costKneadAmount = CollectionUtil.isNotEmpty(costKneadAmountList) ? costKneadAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
            BigDecimal kneadAmount = promotionKneadAmount.add(costKneadAmount);
            List kneadLaterAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_KNEAD_LATER_SETTLEMENT_AMOUNT.getCode())).collect(Collectors.toList());
            BigDecimal kneadLaterAmount = CollectionUtil.isNotEmpty(kneadLaterAmountList) ? kneadLaterAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
            respDto.setItemOrigPrice(payAmount.divide(e.getItemNum(), 2, 4));
            respDto.setTotalUseCostAmount(costAmount);
            respDto.setPrice(payAmount.divide(e.getItemNum(), 2, 4));
            respDto.setOrderDiscountAmount(BigDecimal.ZERO);
            respDto.setGoodsDiscountAmount(discountAmount);
            respDto.setDiscountAmount(discountAmount);
            respDto.setItemAttr(e.getItemAttribute());
            respDto.setGift(e.getGiftFlag());
            respDtos.add(respDto);
        });
        return respDtos;
    }
}

