/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.channel.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ItemPromotionDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.account.constants.ItemCountsTypeEnum;
import com.yunxi.dg.base.center.account.dto.biz.AccountMatchesItemRespDto;
import com.yunxi.dg.base.center.account.dto.entity.AccountDto;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgF2BPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPreviewPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.OrderFeeControlRespDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BOrderContextVo;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.cost.AccountPreviewDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.cost.CostAccountDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.DgOrderPreviewReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgF2BOrderPreviewContext;
import com.yunxi.dg.base.center.trade.dto.strategy.DgMatchStrategyResultDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgOrderFeeAmountDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgOrderFeeScaleControllerReqDto;
import com.yunxi.dg.base.center.trade.enums.GiftEnum;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelAccountService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelFeeControlService;
import com.yunxi.dg.base.center.trade.service.oms.common.ICalculateAmountService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgFeeScaleStrategyRuleService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ChannelFeeControlServiceImpl
implements IChannelFeeControlService {
    private static final Logger log = LoggerFactory.getLogger(ChannelFeeControlServiceImpl.class);
    @Resource
    private IDgFeeScaleStrategyRuleService dgFeeScaleStrategyRuleService;
    @Resource
    private IChannelAccountService channelAccountService;
    @Resource
    private ICalculateAmountService channelCalculateAmountService;

    @Override
    public void supplementAndCheckInfo(DgF2BOrderContextVo dgF2BOrderContextVo, DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        DgOrderPreviewReqDto previewReqDto = dgF2BOrderContextVo.getPreviewReqDto();
        DgF2BPerformOrderReqDto f2BPerformOrderReqDto = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
        f2BPerformOrderReqDto.setNeedFeeThrow(previewReqDto.isNeedFeeThrow());
    }

    @Override
    public OrderFeeControlRespDto feeControl(DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        OrderFeeControlRespDto orderFeeControlRespDto = new OrderFeeControlRespDto();
        DgF2BPerformOrderReqDto performOrderReqDto = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
        CostAccountDto costAccountRespDto = performOrderReqDto.getCostAccountRespDto();
        if (costAccountRespDto != null && CollectionUtil.isNotEmpty((Collection)costAccountRespDto.getAccountPreviewDtos())) {
            DgOrderFeeScaleControllerReqDto orderFeeScaleControllerReqDto = new DgOrderFeeScaleControllerReqDto();
            orderFeeScaleControllerReqDto.setOrderType(performOrderReqDto.getOrderType());
            orderFeeScaleControllerReqDto.setShopCode(performOrderReqDto.getPerformOrderSnapshotDto().getShopCode());
            orderFeeScaleControllerReqDto.setCustomerCode(performOrderReqDto.getPerformOrderSnapshotDto().getCustomerCode());
            List itemList = performOrderReqDto.getItemList();
            this.buildItemFeeType(costAccountRespDto, itemList);
            List materialList = Optional.ofNullable(performOrderReqDto.getMaterialList()).orElse(Lists.newArrayList());
            this.buildMaterialItemFeeType(costAccountRespDto, materialList);
            List allItemList = Stream.of(itemList, materialList).flatMap(Collection::stream).collect(Collectors.toList());
            List dgOrderFeeAmountDtos = allItemList.stream().map(e -> {
                DgOrderFeeAmountDto dgOrderFeeAmountDto = new DgOrderFeeAmountDto();
                dgOrderFeeAmountDto.setItemCode(e.getItemCode());
                dgOrderFeeAmountDto.setSkuCode(e.getSkuCode());
                dgOrderFeeAmountDto.setFeeType(e.getFeeType());
                dgOrderFeeAmountDto.setItemPromotionDtos(e.getItemPromotionDtos());
                dgOrderFeeAmountDto.setTotalAmount(e.getItemMarketPrice().multiply(e.getCalcItemNum()));
                dgOrderFeeAmountDto.setNoTaxTotalAmount(e.getItemMarketPrice().multiply(e.getCalcItemNum()));
                dgOrderFeeAmountDto.setPayAmount(e.getPayAmount());
                dgOrderFeeAmountDto.setRealPayAmount(e.getRealPayAmount());
                dgOrderFeeAmountDto.setGift(GiftEnum.NOT_GIFT.getType());
                return dgOrderFeeAmountDto;
            }).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty((Collection)f2BOrderPreviewContext.getGiftItemList())) {
                List dgGiftOrderFeeAmountDtos = f2BOrderPreviewContext.getGiftItemList().stream().map(e -> {
                    DgOrderFeeAmountDto dgOrderFeeAmountDto = new DgOrderFeeAmountDto();
                    dgOrderFeeAmountDto.setItemCode(e.getItemCode());
                    dgOrderFeeAmountDto.setSkuCode(e.getSkuCode());
                    dgOrderFeeAmountDto.setFeeType(e.getFeeType());
                    dgOrderFeeAmountDto.setItemPromotionDtos(e.getItemPromotionDtos());
                    dgOrderFeeAmountDto.setTotalAmount(e.getItemMarketPrice().multiply(e.getCalcItemNum()));
                    dgOrderFeeAmountDto.setNoTaxTotalAmount(e.getItemMarketPrice().multiply(e.getCalcItemNum()));
                    dgOrderFeeAmountDto.setPayAmount(e.getPayAmount());
                    dgOrderFeeAmountDto.setRealPayAmount(e.getRealPayAmount());
                    dgOrderFeeAmountDto.setGift(GiftEnum.GIFT.getType());
                    return dgOrderFeeAmountDto;
                }).collect(Collectors.toList());
                dgOrderFeeAmountDtos.addAll(dgGiftOrderFeeAmountDtos);
            }
            orderFeeScaleControllerReqDto.setOrderFeeAmountDtoList(dgOrderFeeAmountDtos);
            orderFeeScaleControllerReqDto.setCostAccountRespDto(costAccountRespDto);
            DgMatchStrategyResultDto matchStrategyResultDto = this.dgFeeScaleStrategyRuleService.matchOrderStaretegyOfFeeScale(orderFeeScaleControllerReqDto);
            if (performOrderReqDto.isNeedFeeThrow() && matchStrategyResultDto.getFeeScaleFlag().booleanValue()) {
                throw new BizException(matchStrategyResultDto.getMessage());
            }
            if (matchStrategyResultDto.getFeeScaleFlag().booleanValue()) {
                log.info("\u8fdb\u5165\u8d26\u6237\u4f59\u989d\u91cd\u65b0\u8bbe\u7f6e\u6d41\u7a0b");
                List accountPreviewDtos = costAccountRespDto.getAccountPreviewDtos().stream().sorted(Comparator.comparing(AccountPreviewDto::getPriority)).collect(Collectors.toList());
                BigDecimal otherAmount = matchStrategyResultDto.getUpperLimitAmount();
                for (AccountPreviewDto payReqDto : accountPreviewDtos) {
                    if (!payReqDto.getAccountCategory().equals(AccountCategoryEnum.COST.getCode())) {
                        payReqDto.setOrderAvaBalance(payReqDto.getAvaBalance());
                        log.info("\u975e\u8d39\u7528\u8d26\u6237\u53ef\u7528\u91d1\u989d\u8bbe\u7f6e\u4e3a\u4f59\u989d\uff1a{}", (Object)payReqDto.getAvaBalance());
                        continue;
                    }
                    if (CollectionUtil.isEmpty((Collection)matchStrategyResultDto.getFeeType()) || !matchStrategyResultDto.getFeeType().contains(payReqDto.getAccountType())) {
                        payReqDto.setOrderAvaBalance(payReqDto.getAvaBalance());
                        log.info("\u5f53\u524d\u8d39\u7528\u8d26\u6237\u4e0d\u518d\u63a7\u5236\u8303\u56f4\u5185\uff0c\u91d1\u989d\u8bbe\u7f6e\u4e3a\u4f59\u989d\uff1a{}", (Object)payReqDto.getAvaBalance());
                        continue;
                    }
                    if (otherAmount.compareTo(BigDecimal.ZERO) <= 0) {
                        payReqDto.setOrderAvaBalance(BigDecimal.ZERO);
                        log.info("\u8d26\u6237 \uff1a{} \u4f59\u989d\u91cd\u8bbe\u4e3a0", (Object)payReqDto.getAccountType());
                        continue;
                    }
                    if (payReqDto.getOrderAvaBalance().compareTo(otherAmount) > 0) {
                        payReqDto.setOrderAvaBalance(otherAmount);
                        log.info("\u8d26\u6237 \uff1a{} \u4f59\u989d\u91cd\u8bbe\u4e3a:{}", (Object)payReqDto.getAccountType(), (Object)otherAmount);
                    }
                    otherAmount = otherAmount.subtract(payReqDto.getOrderAvaBalance());
                }
                costAccountRespDto.setAccountPreviewDtos(accountPreviewDtos);
            }
            orderFeeControlRespDto.setCostAccountRespDto(matchStrategyResultDto.getCostAccountRespDto());
            f2BOrderPreviewContext.setOrderFeeControlRespDto(orderFeeControlRespDto);
        }
        return orderFeeControlRespDto;
    }

    @Override
    public void feeControlByAutoPay(List<AccountDto> accountDtoList, DgPerformOrderRespDto order) {
        List orderLineDtos = order.getOrderLineList();
        DgOrderFeeScaleControllerReqDto orderFeeScaleControllerReqDto = new DgOrderFeeScaleControllerReqDto();
        orderFeeScaleControllerReqDto.setOrderType(order.getOrderType());
        orderFeeScaleControllerReqDto.setShopCode(order.getPerformOrderSnapshotDto().getShopCode());
        orderFeeScaleControllerReqDto.setCustomerCode(order.getPerformOrderSnapshotDto().getCustomerCode());
        orderFeeScaleControllerReqDto.setOrderFeeAmountDtoList(this.buildOrderLineFeeType(accountDtoList, orderLineDtos));
        orderFeeScaleControllerReqDto.setCostAccountRespDto(this.buildCostAccountRespDto(accountDtoList));
        DgMatchStrategyResultDto matchStrategyResultDto = this.dgFeeScaleStrategyRuleService.matchOrderStaretegyOfFeeScale(orderFeeScaleControllerReqDto);
        if (matchStrategyResultDto.getFeeScaleFlag().booleanValue()) {
            log.info("\u8fdb\u5165\u8d26\u6237\u989d\u5ea6\u91cd\u65b0\u5206\u644a\u8bbe\u7f6e");
            BigDecimal otherAmount = matchStrategyResultDto.getUpperLimitAmount();
            accountDtoList = accountDtoList.stream().sorted(Comparator.comparing(AccountDto::getPriority)).collect(Collectors.toList());
            for (AccountDto accountDto : accountDtoList) {
                if (!accountDto.getAccountCategory().equals(AccountCategoryEnum.COST.getCode())) {
                    accountDto.setDisposable(accountDto.getDisposable());
                    log.info("\u975e\u8d39\u7528\u8d26\u6237\u53ef\u7528\u91d1\u989d\u8bbe\u7f6e\u4e3a\u4f59\u989d\uff1a{}", (Object)accountDto.getDisposable());
                    continue;
                }
                if (CollectionUtil.isEmpty((Collection)matchStrategyResultDto.getFeeType()) || !matchStrategyResultDto.getFeeType().contains(accountDto.getAccountType())) {
                    accountDto.setDisposable(accountDto.getDisposable());
                    log.info("\u5f53\u524d\u8d39\u7528\u8d26\u6237\u4e0d\u518d\u63a7\u5236\u8303\u56f4\u5185\uff0c\u91d1\u989d\u8bbe\u7f6e\u4e3a\u4f59\u989d\uff1a{}", (Object)accountDto.getDisposable());
                    continue;
                }
                if (otherAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    accountDto.setDisposable(BigDecimal.ZERO);
                    log.info("\u8d26\u6237 \uff1a{} \u4f59\u989d\u91cd\u8bbe\u4e3a0", (Object)accountDto.getAccountType());
                    continue;
                }
                if (accountDto.getDisposable().compareTo(otherAmount) > 0) {
                    accountDto.setDisposable(otherAmount);
                    log.info("\u8d26\u6237 \uff1a{} \u4f59\u989d\u91cd\u8bbe\u4e3a:{}", (Object)accountDto.getAccountType(), (Object)otherAmount);
                }
                otherAmount = otherAmount.subtract(accountDto.getDisposable());
            }
        }
    }

    private List<DgOrderFeeAmountDto> buildOrderLineFeeType(List<AccountDto> accountDtoList, List<DgPerformOrderLineDto> orderLineDtos) {
        if (CollectionUtil.isEmpty(accountDtoList) || CollectionUtil.isEmpty(orderLineDtos)) {
            return new ArrayList<DgOrderFeeAmountDto>();
        }
        String costAccountType = accountDtoList.stream().filter(e -> e.getAccountCategory().equals(AccountCategoryEnum.COST.getCode())).map(AccountDto::getAccountType).collect(Collectors.joining(","));
        String feeType = StringUtils.isNotBlank((CharSequence)costAccountType) ? costAccountType : "";
        Map<Long, BigDecimal> orderLineAmountMap = this.channelCalculateAmountService.calculateOrderLineBasicAmount(orderLineDtos, DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode(), DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode());
        ArrayList<DgOrderFeeAmountDto> orderFeeAmountDtos = new ArrayList<DgOrderFeeAmountDto>();
        for (DgPerformOrderLineDto orderLineDto : orderLineDtos) {
            DgOrderFeeAmountDto orderFeeAmountDto = new DgOrderFeeAmountDto();
            orderFeeAmountDto.setItemCode(orderLineDto.getItemCode());
            orderFeeAmountDto.setSkuCode(orderLineDto.getSkuCode());
            orderFeeAmountDto.setTotalAmount(orderLineAmountMap.get(orderLineDto.getId()) != null ? orderLineAmountMap.get(orderLineDto.getId()) : BigDecimal.ZERO);
            orderFeeAmountDto.setNoTaxTotalAmount(orderLineAmountMap.get(orderLineDto.getId()) != null ? orderLineAmountMap.get(orderLineDto.getId()) : BigDecimal.ZERO);
            orderFeeAmountDto.setGift(orderLineDto.getGiftFlag());
            if (orderLineDto.getGiftFlag().equals(GiftEnum.GIFT.getType())) {
                orderFeeAmountDto.setFeeType(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getType());
            } else {
                if (StringUtils.isNotBlank((CharSequence)orderLineDto.getPromotionDiscountDetails()) && orderLineDto.getPromotionDiscountDetails().contains("promotionType")) {
                    feeType = feeType.concat(",").concat(JSON.parseArray((String)orderLineDto.getPromotionDiscountDetails(), ItemPromotionDto.class).stream().filter(e -> Objects.nonNull(e.getPromotionType())).map(ItemPromotionDto::getPromotionType).collect(Collectors.joining(",")));
                }
                orderFeeAmountDto.setFeeType(feeType);
            }
            orderFeeAmountDtos.add(orderFeeAmountDto);
        }
        return orderFeeAmountDtos;
    }

    private CostAccountDto buildCostAccountRespDto(List<AccountDto> accountDtoList) {
        CostAccountDto costAccountDto = new CostAccountDto();
        ArrayList<AccountPreviewDto> accountPreviewDtos = new ArrayList<AccountPreviewDto>();
        for (AccountDto accountDto : accountDtoList) {
            AccountPreviewDto accountPreviewDto = new AccountPreviewDto();
            accountPreviewDto.setAccountCategory(accountDto.getAccountCategory());
            accountPreviewDto.setAccountType(accountDto.getAccountType());
            accountPreviewDto.setOrderAvaBalance(accountDto.getDisposable());
            accountPreviewDto.setPriority(accountDto.getPriority());
            accountPreviewDtos.add(accountPreviewDto);
        }
        costAccountDto.setAccountPreviewDtos(accountPreviewDtos);
        return costAccountDto;
    }

    private void buildItemFeeType(CostAccountDto costAccountDto, List<DgPreviewPerformOrderItemReqDto> performOrderItemReqDtos) {
        if (costAccountDto == null || CollectionUtils.isEmpty((Collection)costAccountDto.getAccountPreviewDtos())) {
            return;
        }
        for (DgPreviewPerformOrderItemReqDto orderItem : performOrderItemReqDtos) {
            String feeType = orderItem.getFeeType() == null ? "" : orderItem.getFeeType();
            for (AccountPreviewDto accountPreviewDto : costAccountDto.getAccountPreviewDtos()) {
                if (CollectionUtils.isNotEmpty((Collection)accountPreviewDto.getItems())) {
                    for (AccountMatchesItemRespDto item : accountPreviewDto.getItems()) {
                        if (!orderItem.getSkuCode().equals(item.getSkuCode())) continue;
                        feeType = feeType.concat(",").concat(accountPreviewDto.getAccountType());
                    }
                    continue;
                }
                feeType = feeType.concat(",").concat(accountPreviewDto.getAccountType());
            }
            orderItem.setFeeType(feeType);
            log.info("\u3010\u5546\u54c1SKU:{}\u7684\u8d26\u6237\u8d39\u7528\u7c7b\u578b\u4e3a:{}\u3011", (Object)orderItem.getSkuName(), (Object)feeType);
        }
    }

    private void buildMaterialItemFeeType(CostAccountDto costAccountDto, List<DgPreviewPerformOrderItemReqDto> materialList) {
        if (costAccountDto == null || CollectionUtils.isEmpty((Collection)costAccountDto.getAccountPreviewDtos()) || CollectionUtils.isEmpty(materialList)) {
            return;
        }
        for (DgPreviewPerformOrderItemReqDto orderItem : materialList) {
            String feeType = orderItem.getFeeType() == null ? "" : orderItem.getFeeType();
            for (AccountPreviewDto accountPreviewDto : costAccountDto.getAccountPreviewDtos()) {
                if (!ItemCountsTypeEnum.YES.getCode().equals(accountPreviewDto.getItemCountsType()) || !CollectionUtils.isNotEmpty((Collection)accountPreviewDto.getAccountDtos())) continue;
                for (AccountDto accountDto : accountPreviewDto.getAccountDtos()) {
                    if (!orderItem.getSkuCode().equals(accountDto.getSkuCode())) continue;
                    feeType = feeType.concat(",").concat(accountPreviewDto.getAccountType());
                }
            }
            orderItem.setFeeType(feeType);
            log.info("\u3010\u5546\u54c1SKU:{}\u7684\u6309\u5546\u54c1\u8ba1\u6570\u7684\u8d26\u6237\u8d39\u7528\u7c7b\u578b\u4e3a:{}\u3011", (Object)orderItem.getSkuName(), (Object)feeType);
        }
    }
}

