/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.channel.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.account.dto.biz.AccountMatchesItemRespDto;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountCategoryEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.PayRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.cost.ApportionContext;
import com.yunxi.dg.base.center.trade.enums.GiftEnum;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelOrderKneadPriceService;
import com.yunxi.dg.base.center.trade.service.oms.channel.impl.ChannelOrderKneadPriceService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="channelOrderBasicKneadPriceServiceImpl")
public class ChannelOrderBasicKneadPriceServiceImpl
extends ChannelOrderKneadPriceService
implements IChannelOrderKneadPriceService {
    private static final Logger log = LoggerFactory.getLogger(ChannelOrderBasicKneadPriceServiceImpl.class);

    @Override
    public void execute(ApportionContext apportionContext) {
        List<DgPerformOrderLineAmountDto> amountDtoList = this.executeKneadPrice(apportionContext.getOrderLineDtos(), apportionContext.getPayRecordDtos());
        super.saveAmountInfo(amountDtoList, apportionContext.getPerformOrderRespDto());
    }

    public List<DgPerformOrderLineAmountDto> executeKneadPrice(List<DgPerformOrderLineDto> orderLineDtos, List<PayRecordDto> payRecordDtos) {
        ArrayList<DgPerformOrderLineAmountDto> amountDtoList = new ArrayList<DgPerformOrderLineAmountDto>();
        Map<Integer, List<DgPerformOrderLineDto>> map = orderLineDtos.stream().collect(Collectors.groupingBy(DgPerformOrderLineDto::getGiftFlag));
        List<DgPerformOrderLineAmountDto> kneadPromitionItemAmountDtoList = this.executePromotionKneadPrice(new ArrayList<DgPerformOrderLineDto>((Collection)map.get(YesNoEnum.NO.getValue())), new ArrayList<DgPerformOrderLineDto>((Collection)Optional.ofNullable(map.get(YesNoEnum.YES.getValue())).orElse(Lists.newArrayList())));
        Map<Long, List<DgPerformOrderLineAmountDto>> kneadPromitionItemAmountDtoMap = kneadPromitionItemAmountDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountDto::getOrderLineId));
        log.info("\u4fc3\u9500\u63c9\u4ef7\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(kneadPromitionItemAmountDtoList));
        List<DgPerformOrderLineAmountDto> kneadCostItemAmountDtoList = this.executeCostKneadPrice(new ArrayList<DgPerformOrderLineDto>((Collection)map.get(YesNoEnum.NO.getValue())), new ArrayList<DgPerformOrderLineDto>((Collection)Optional.ofNullable(map.get(YesNoEnum.YES.getValue())).orElse(Lists.newArrayList())), payRecordDtos);
        Map<Long, List<DgPerformOrderLineAmountDto>> kneadCostItemAmountDtoMap = kneadCostItemAmountDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountDto::getOrderLineId));
        log.info("\u8d39\u7528\u63c9\u4ef7\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(kneadCostItemAmountDtoList));
        amountDtoList.addAll(kneadPromitionItemAmountDtoList);
        amountDtoList.addAll(kneadCostItemAmountDtoList);
        ArrayList<DgPerformOrderLineAmountDto> kneadLaterAmounts = new ArrayList<DgPerformOrderLineAmountDto>();
        orderLineDtos.forEach(orderLineDto -> {
            BigDecimal kneadPromitionAmount = BigDecimal.ZERO;
            List kneadPromitionItemAmounts = (List)kneadPromitionItemAmountDtoMap.get(orderLineDto.getId());
            if (CollectionUtil.isNotEmpty((Collection)kneadPromitionItemAmounts)) {
                DgPerformOrderLineAmountDto kneadPromitionItemAmountDto = new DgPerformOrderLineAmountDto();
                kneadPromitionItemAmountDto.setOrderId(orderLineDto.getOrderId());
                kneadPromitionItemAmountDto.setOrderLineId(orderLineDto.getId());
                kneadPromitionItemAmountDto.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode());
                kneadPromitionItemAmountDto.setAccountCategory(DgOrderAmountCategoryEnum.OMS_F2B.getCode());
                kneadPromitionItemAmountDto.setAccountType(DgOmsOrderAmountTypeEnum.LINE_PROMOTION_KNEAD_TOTAL.getCode());
                kneadPromitionAmount = kneadPromitionItemAmounts.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                kneadPromitionItemAmountDto.setAmount(kneadPromitionAmount);
                amountDtoList.add(kneadPromitionItemAmountDto);
            }
            BigDecimal kneadCostAmount = BigDecimal.ZERO;
            List kneadCostItemAmounts = (List)kneadCostItemAmountDtoMap.get(orderLineDto.getId());
            if (CollectionUtil.isNotEmpty((Collection)kneadCostItemAmounts)) {
                DgPerformOrderLineAmountDto kneadCostItemAmountDto = new DgPerformOrderLineAmountDto();
                kneadCostItemAmountDto.setOrderId(orderLineDto.getOrderId());
                kneadCostItemAmountDto.setOrderLineId(orderLineDto.getId());
                kneadCostItemAmountDto.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode());
                kneadCostItemAmountDto.setAccountCategory(DgOrderAmountCategoryEnum.OMS_F2B.getCode());
                kneadCostItemAmountDto.setAccountType(DgOmsOrderAmountTypeEnum.LINE_COST_KNEAD_TOTAL.getCode());
                kneadCostAmount = kneadCostItemAmounts.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                kneadCostItemAmountDto.setAmount(kneadCostAmount);
                amountDtoList.add(kneadCostItemAmountDto);
            }
            List saleAmountDtos = orderLineDto.getAmountDtoList().stream().filter(amount -> amount.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode())).collect(Collectors.toList());
            BigDecimal saleAmount = saleAmountDtos.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            List payAmountDtos = orderLineDto.getAmountDtoList().stream().filter(amount -> amount.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode())).collect(Collectors.toList());
            BigDecimal payAmount = payAmountDtos.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            List discountAmountDtos = orderLineDto.getAmountDtoList().stream().filter(amount -> amount.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode())).collect(Collectors.toList());
            BigDecimal discountAmount = discountAmountDtos.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            log.info("\u5546\u54c1\uff1a{} ===>>\u6210\u4ea4\u91d1\u989d:{} || \u4fc3\u9500\u63c9\u4ef7\u6c47\u603b\u91d1\u989d\uff1a{} || \u8d39\u7528\u63c9\u4ef7\u6c47\u603b\u91d1\u989d\uff1a{} || \u5546\u54c1\u4f18\u60e0\u91d1\u989d\uff1a{}", new Object[]{orderLineDto.getId(), payAmount, kneadPromitionAmount, kneadCostAmount, discountAmount});
            BigDecimal kneadLaterPayAmount = BigDecimal.ZERO;
            kneadLaterPayAmount = orderLineDto.getGiftFlag().equals(DgGiftEnum.NOT_GIFT.getType()) ? payAmount.subtract(kneadPromitionAmount) : saleAmount.subtract(kneadPromitionAmount);
            log.info("\u5546\u54c1\uff1a{} ===>>\u63c9\u4ef7\u540e\u6210\u4ea4\u91d1\u989d:{}", (Object)orderLineDto.getId(), (Object)kneadLaterPayAmount);
            DgPerformOrderLineAmountDto kneadLaterPayAmountDto = new DgPerformOrderLineAmountDto();
            kneadLaterPayAmountDto.setOrderId(orderLineDto.getOrderId());
            kneadLaterPayAmountDto.setOrderLineId(orderLineDto.getId());
            kneadLaterPayAmountDto.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode());
            kneadLaterPayAmountDto.setAccountCategory(DgOrderAmountCategoryEnum.OMS_F2B.getCode());
            kneadLaterPayAmountDto.setAccountType(DgOmsOrderAmountTypeEnum.LINE_KNEAD_LATER_PAY_AMOUNT.getCode());
            kneadLaterPayAmountDto.setAmount(kneadLaterPayAmount);
            amountDtoList.add(kneadLaterPayAmountDto);
            BigDecimal kneadLaterAmount = BigDecimal.ZERO;
            kneadLaterAmount = orderLineDto.getGiftFlag().equals(DgGiftEnum.NOT_GIFT.getType()) ? payAmount.subtract(kneadPromitionAmount).subtract(kneadCostAmount) : saleAmount.subtract(kneadPromitionAmount).subtract(kneadCostAmount);
            log.info("\u5546\u54c1\uff1a{} ===>>\u63c9\u4ef7\u540e\u7ed3\u7b97\u91d1\u989d:{}", (Object)orderLineDto.getId(), (Object)kneadLaterAmount);
            DgPerformOrderLineAmountDto kneadCostItemAmountDto = new DgPerformOrderLineAmountDto();
            kneadCostItemAmountDto.setOrderId(orderLineDto.getOrderId());
            kneadCostItemAmountDto.setOrderLineId(orderLineDto.getId());
            kneadCostItemAmountDto.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode());
            kneadCostItemAmountDto.setAccountCategory(DgOrderAmountCategoryEnum.OMS_F2B.getCode());
            kneadCostItemAmountDto.setAccountType(DgOmsOrderAmountTypeEnum.LINE_KNEAD_LATER_SETTLEMENT_AMOUNT.getCode());
            kneadCostItemAmountDto.setAmount(kneadLaterAmount);
            amountDtoList.add(kneadCostItemAmountDto);
            kneadLaterAmounts.add(kneadCostItemAmountDto);
        });
        List<DgPerformOrderLineAmountDto> kneadCapitalItemAmountDtoList = this.executeCapitalKneadPrice(new ArrayList<DgPerformOrderLineDto>((Collection)map.get(YesNoEnum.NO.getValue())), new ArrayList<DgPerformOrderLineDto>((Collection)Optional.ofNullable(map.get(YesNoEnum.YES.getValue())).orElse(Lists.newArrayList())), kneadLaterAmounts, payRecordDtos);
        amountDtoList.addAll(kneadCapitalItemAmountDtoList);
        return amountDtoList;
    }

    private List<DgPerformOrderLineAmountDto> executePromotionKneadPrice(List<DgPerformOrderLineDto> items, List<DgPerformOrderLineDto> giftItems) {
        log.info("\u8ba1\u7b97\u4fc3\u9500\u63c9\u4ef7");
        ArrayList<DgPerformOrderLineAmountDto> kneadPromitionItemAmountDtoList = new ArrayList<DgPerformOrderLineAmountDto>();
        if (CollectionUtil.isNotEmpty(giftItems)) {
            block0: for (DgPerformOrderLineDto giftItem : giftItems) {
                BigDecimal giftPromotionAmount = BigDecimal.ZERO;
                for (DgPerformOrderLineAmountDto orderLineAmount : giftItem.getAmountDtoList()) {
                    if (!DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode().equals(orderLineAmount.getAccountType())) continue;
                    giftPromotionAmount = giftPromotionAmount.add(orderLineAmount.getAmount());
                }
                List skuIds = Arrays.stream(giftItem.getGiftSkuIds().split(",")).map(Long::parseLong).collect(Collectors.toList());
                List subItems = items.stream().filter(item -> skuIds.contains(item.getSkuId())).collect(Collectors.toList());
                BigDecimal totalAmount = BigDecimal.ZERO.add(giftPromotionAmount);
                for (DgPerformOrderLineDto item2 : subItems) {
                    if (CollectionUtil.isNotEmpty((Collection)item2.getAmountDtoList())) {
                        BigDecimal itemAmount = CollectionUtil.isNotEmpty((Collection)item2.getAmountDtoList()) ? this.getAmount(item2.getAmountDtoList(), DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode()) : BigDecimal.ZERO;
                        totalAmount = totalAmount.add(itemAmount);
                        continue;
                    }
                    log.error("\u8ba2\u5355\u884c\uff1a{} \u4e0d\u5b58\u5728\u91d1\u989d\u6570\u636e", (Object)item2.getSkuCode());
                }
                LinkedList kneadPromitionItems = new LinkedList(subItems);
                kneadPromitionItems.add(giftItem);
                log.info("\u9700\u8981\u63c9\u4ef7\u7684\u8d60\u54c1\u4fc3\u9500\u603b\u989d:{},\u5546\u54c1\u9500\u552e\u603b\u989d(\u975e\u8d60\u54c1\u4f7f\u7528\u6210\u4ea4\u91d1\u989d\uff08\u5b9e\u9645\u91d1\u989d\uff09,\u8d60\u54c1\u4f7f\u7528\u9500\u552e\u91d1\u989d,\u4fc3\u9500\u7269\u6599\u4f7f\u7528\u9500\u552e\u91d1\u989d):{}", (Object)giftPromotionAmount, (Object)totalAmount);
                log.info("\u53c2\u4e0e\u63c9\u4ef7\u7684\u5546\u54c1\u4fe1\u606f===\u300b\u300b\u300b{}", (Object)JSON.toJSONString(kneadPromitionItems));
                BigDecimal allocatedAmount = BigDecimal.ZERO;
                for (DgPerformOrderLineDto kneadPromitionItem : kneadPromitionItems) {
                    DgPerformOrderLineAmountDto performOrderLineAmountDto = new DgPerformOrderLineAmountDto();
                    performOrderLineAmountDto.setOrderId(kneadPromitionItem.getOrderId());
                    performOrderLineAmountDto.setOrderLineId(kneadPromitionItem.getId());
                    performOrderLineAmountDto.setAmountSource(DgOrderAmountSourceEnum.KNEAD.getCode());
                    performOrderLineAmountDto.setAccountCategory(DgOrderAmountCategoryEnum.OMS_F2B.getCode());
                    performOrderLineAmountDto.setAccountType(DgOmsOrderAmountTypeEnum.LINE_PROMOTION_KNEAD_AMOUNT.getCode());
                    performOrderLineAmountDto.setExtension(giftItem.getId().toString());
                    if (giftPromotionAmount.compareTo(allocatedAmount) <= 0) {
                        performOrderLineAmountDto.setAmount(BigDecimal.ZERO);
                        kneadPromitionItemAmountDtoList.add(performOrderLineAmountDto);
                        continue block0;
                    }
                    if (GiftEnum.GIFT.getType().equals(kneadPromitionItem.getGiftFlag())) {
                        BigDecimal promotionKneadeAmount = giftPromotionAmount.subtract(allocatedAmount);
                        performOrderLineAmountDto.setAmount(promotionKneadeAmount);
                        kneadPromitionItemAmountDtoList.add(performOrderLineAmountDto);
                        log.info("\u8d60\u54c1\u3010{}\u3011:\u8ba1\u7b97\u51fa\u8d60\u54c1\u4fc3\u9500\u63c9\u4ef7\u91d1\u989d\u4e3a:{}", (Object)kneadPromitionItem.getSkuCode(), (Object)promotionKneadeAmount);
                        continue block0;
                    }
                    BigDecimal itemAmount = BigDecimal.ZERO;
                    itemAmount = kneadPromitionItem.getGiftFlag().equals(DgGiftEnum.NOT_GIFT.getType()) ? (CollectionUtil.isNotEmpty((Collection)kneadPromitionItem.getAmountDtoList()) ? this.getAmount(kneadPromitionItem.getAmountDtoList(), DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode()) : BigDecimal.ZERO) : (CollectionUtil.isNotEmpty((Collection)kneadPromitionItem.getAmountDtoList()) ? this.getAmount(kneadPromitionItem.getAmountDtoList(), DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode()) : BigDecimal.ZERO);
                    BigDecimal promotionKneadAmount = giftPromotionAmount.multiply(itemAmount).divide(totalAmount, 2, RoundingMode.HALF_UP);
                    log.info("\u5546\u54c1\u3010{}\u3011:\u6210\u4ea4\u91d1\u989d\uff1a{} ,\u8ba1\u7b97\u51fa\u8d60\u54c1\u4fc3\u9500\u63c9\u4ef7\u91d1\u989d\u4e3a:{}", new Object[]{kneadPromitionItem.getSkuCode(), itemAmount, promotionKneadAmount});
                    allocatedAmount = allocatedAmount.add(promotionKneadAmount);
                    performOrderLineAmountDto.setAmount(promotionKneadAmount);
                    kneadPromitionItemAmountDtoList.add(performOrderLineAmountDto);
                }
            }
        }
        return kneadPromitionItemAmountDtoList;
    }

    private List<DgPerformOrderLineAmountDto> executeCostKneadPrice(List<DgPerformOrderLineDto> items, List<DgPerformOrderLineDto> giftItems, List<PayRecordDto> payRecordDtos) {
        log.info("\u8ba1\u7b97\u8d39\u7528\u63c9\u4ef7");
        Map giftMap = giftItems.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (a, b) -> a));
        HashMap giftItemMap = new HashMap();
        if (CollectionUtil.isNotEmpty(giftItems)) {
            for (DgPerformOrderLineDto gift2 : giftItems) {
                if (!StringUtils.isNotBlank((CharSequence)gift2.getGiftSkuIds())) continue;
                log.info("\u8d60\u54c1\u8ba2\u5355\u884c\uff1a{} \u5bf9\u5e94\u7684\u672c\u54c1\u662f\uff1a{}", (Object)gift2.getId(), (Object)gift2.getGiftSkuIds());
                List<Long> skuIds = Arrays.stream(gift2.getGiftSkuIds().split(",")).map(Long::parseLong).collect(Collectors.toList());
                skuIds.forEach(skuId -> {
                    ArrayList<Long> ids = (ArrayList<Long>)giftItemMap.get(skuId);
                    if (CollectionUtil.isEmpty((Collection)ids)) {
                        ids = new ArrayList<Long>();
                    }
                    ids.add(gift2.getId());
                    giftItemMap.put(skuId, ids);
                });
            }
            log.info("\u672c\u54c1 || \u8d60\u54c1\u6620\u5c04\u7ed3\u679c\uff1a{}", giftItemMap);
        }
        ArrayList<DgPerformOrderLineAmountDto> kneadCostItemAmountDtoList = new ArrayList<DgPerformOrderLineAmountDto>();
        HashMap<Long, BigDecimal> itemAmountMap = new HashMap<Long, BigDecimal>();
        Map<String, List<PayRecordDto>> payRecordMap = payRecordDtos.stream().filter(e -> e.getAccountCategory().equals(AccountCategoryEnum.COST.getCode())).collect(Collectors.groupingBy(payRecord -> payRecord.getPayMethod() + "&" + payRecord.getSellerId()));
        if (CollectionUtil.isEmpty(payRecordMap)) {
            log.info("\u6ca1\u6709\u8d39\u7528\u8d26\u6237\u53c2\u4e0e\u652f\u4ed8");
        }
        block1: for (Map.Entry<String, List<PayRecordDto>> entry : payRecordMap.entrySet()) {
            if (CollectionUtil.isEmpty((Collection)entry.getValue())) {
                log.error("\u8d26\u6237\uff1a{}\u6ca1\u6709\u652f\u4ed8\u8bb0\u5f55", (Object)entry.getKey());
                continue;
            }
            List<PayRecordDto> subPayRecordDtos = entry.getValue();
            PayRecordDto payRecordDto = subPayRecordDtos.get(0);
            List matchesItems = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)payRecordDto.getExtension()) && payRecordDto.getExtension().contains("orderItemId")) {
                matchesItems = JSON.parseArray((String)payRecordDto.getExtension(), AccountMatchesItemRespDto.class);
            }
            List<Object> subItems = new ArrayList();
            if (CollectionUtil.isNotEmpty(matchesItems)) {
                List matchItems = matchesItems.stream().map(AccountMatchesItemRespDto::getOrderItemId).collect(Collectors.toList());
                subItems = items.stream().filter(item -> matchItems.contains(item.getId())).collect(Collectors.toList());
            } else {
                subItems = items;
            }
            List<Object> giftIds = new ArrayList();
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal totalCost = BigDecimal.ZERO;
            for (Object line : subItems) {
                BigDecimal payAmount = (BigDecimal)itemAmountMap.get(line.getId());
                if (null == payAmount) {
                    List payAmountList;
                    payAmount = line.getGiftFlag().equals(DgGiftEnum.NOT_GIFT.getType()) ? (CollectionUtil.isNotEmpty(payAmountList = line.getAmountDtoList().stream().filter(amount -> DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode().equals(amount.getAccountType())).collect(Collectors.toList())) ? payAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO) : (CollectionUtil.isNotEmpty(payAmountList = line.getAmountDtoList().stream().filter(amount -> DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode().equals(amount.getAccountType())).collect(Collectors.toList())) ? payAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO);
                    itemAmountMap.put(line.getId(), payAmount);
                }
                totalAmount = totalAmount.add(payAmount);
                List costList = line.getAmountDtoList().stream().filter(amount -> DgOrderAmountSourceEnum.COST.getCode().equals(amount.getAmountSource()) && amount.getAccountType().equals(payRecordDto.getPayMethod())).collect(Collectors.toList());
                totalCost = totalCost.add(CollectionUtil.isNotEmpty(costList) ? costList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO);
                if (!giftItemMap.containsKey(line.getSkuId())) continue;
                List list = (List)giftItemMap.get(line.getSkuId());
                log.info("\u6620\u5c04\u7684\u8d60\u54c1id\u662f\uff1a{}", (Object)list);
                giftIds.addAll(list);
            }
            ArrayList subGiftItems = new ArrayList();
            if (CollectionUtil.isNotEmpty(giftIds)) {
                Object line;
                giftIds = giftIds.stream().distinct().collect(Collectors.toList());
                giftIds.forEach(gift -> subGiftItems.add(giftMap.get(gift)));
                line = subGiftItems.iterator();
                while (line.hasNext()) {
                    DgPerformOrderLineDto giftLine = (DgPerformOrderLineDto)line.next();
                    BigDecimal discountAmount = (BigDecimal)itemAmountMap.get(giftLine.getId());
                    if (null == discountAmount) {
                        List list = giftLine.getAmountDtoList().stream().filter(amount -> DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode().equals(amount.getAccountType())).collect(Collectors.toList());
                        discountAmount = CollectionUtil.isNotEmpty(list) ? list.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
                        itemAmountMap.put(giftLine.getId(), discountAmount);
                    }
                    totalAmount = totalAmount.add(discountAmount);
                }
                log.info("\u5173\u8054\u8d60\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(subGiftItems));
            }
            log.info("\u8d26\u6237\u7c7b\u578b\uff1a{}\u5173\u8054\u7684\u5546\u54c1\u603b\u989d\uff1a{},\u8d39\u7528\u4f7f\u7528\u91d1\u989d\uff1a{}", new Object[]{payRecordDto.getPayMethod(), totalAmount, totalCost});
            if (totalCost.compareTo(BigDecimal.ZERO) > 0) {
                subItems.addAll(subGiftItems);
                subItems = subItems.stream().sorted(Comparator.comparing(DgPerformOrderLineDto::getGiftFlag)).collect(Collectors.toList());
                BigDecimal allocatedAmount = BigDecimal.ZERO;
                int i = 1;
                for (DgPerformOrderLineDto dgPerformOrderLineDto : subItems) {
                    DgPerformOrderLineAmountDto performOrderLineAmountDto = new DgPerformOrderLineAmountDto();
                    performOrderLineAmountDto.setOrderId(dgPerformOrderLineDto.getOrderId());
                    performOrderLineAmountDto.setOrderLineId(dgPerformOrderLineDto.getId());
                    performOrderLineAmountDto.setAmountSource(DgOrderAmountSourceEnum.KNEAD.getCode());
                    performOrderLineAmountDto.setAccountCategory(payRecordDto.getAccountCategory());
                    performOrderLineAmountDto.setAccountType(payRecordDto.getPayMethod());
                    performOrderLineAmountDto.setSellerId(payRecordDto.getSellerId());
                    if (totalCost.compareTo(allocatedAmount) <= 0) {
                        performOrderLineAmountDto.setAmount(BigDecimal.ZERO);
                        kneadCostItemAmountDtoList.add(performOrderLineAmountDto);
                        log.info("\u8ba2\u5355\u884c\uff1a{} || \u6ca1\u6709\u91d1\u989d\u53ef\u4ee5\u5206\u914d\u4e86", (Object)dgPerformOrderLineDto.getId());
                        continue block1;
                    }
                    if (i == subItems.size()) {
                        performOrderLineAmountDto.setAmount(totalCost.subtract(allocatedAmount));
                        log.info("\u8ba2\u5355\u884c\uff1a{}  || \u5206\u914d\u91d1\u989d\u4e3a\uff1a{}", (Object)dgPerformOrderLineDto.getId(), (Object)totalCost.subtract(allocatedAmount));
                        kneadCostItemAmountDtoList.add(performOrderLineAmountDto);
                        continue block1;
                    }
                    BigDecimal payAmount = (BigDecimal)itemAmountMap.get(dgPerformOrderLineDto.getId());
                    BigDecimal itemCostKneadAmount = totalCost.multiply(payAmount).divide(totalAmount, 2, RoundingMode.HALF_UP);
                    log.info("\u8ba2\u5355\u884c\uff1a{} || \u6210\u4ea4\u91d1\u989d\u4e3a\uff1a{} || \u5206\u914d\u91d1\u989d\u4e3a\uff1a{}", new Object[]{dgPerformOrderLineDto.getId(), payAmount, itemCostKneadAmount});
                    performOrderLineAmountDto.setAmount(itemCostKneadAmount);
                    kneadCostItemAmountDtoList.add(performOrderLineAmountDto);
                    allocatedAmount = allocatedAmount.add(itemCostKneadAmount);
                    ++i;
                }
                continue;
            }
            log.error("\u8ba2\u5355\uff1a{} \u6ca1\u6709\u4f7f\u7528\u8d39\u7528\u8d26\u6237\u7c7b\u578b\uff1a{} \u652f\u4ed8", (Object)entry.getValue().get(0).getOrderNo(), (Object)entry.getKey());
        }
        return kneadCostItemAmountDtoList;
    }

    private List<DgPerformOrderLineAmountDto> executeCapitalKneadPrice(List<DgPerformOrderLineDto> items, List<DgPerformOrderLineDto> giftItems, List<DgPerformOrderLineAmountDto> kneadLaterAmounts, List<PayRecordDto> payRecordDtos) {
        ArrayList<DgPerformOrderLineAmountDto> kneadCapitalItemAmountDtoList = new ArrayList<DgPerformOrderLineAmountDto>();
        Map<Long, BigDecimal> kneadLaterAmountMap = kneadLaterAmounts.stream().collect(Collectors.toMap(DgPerformOrderLineAmountDto::getOrderLineId, DgPerformOrderLineAmountDto::getAmount));
        HashMap<Long, BigDecimal> surplusKneadAmountMap = new HashMap<Long, BigDecimal>(kneadLaterAmountMap);
        Map<String, List<PayRecordDto>> payRecordMap = payRecordDtos.stream().filter(e -> e.getAccountCategory().equals(AccountCategoryEnum.CAPITAL.getCode())).collect(Collectors.groupingBy(payRecord -> payRecord.getPayMethod() + "&" + payRecord.getSellerId()));
        if (CollectionUtil.isEmpty(payRecordMap)) {
            log.info("\u6ca1\u6709\u8d44\u91d1\u8d26\u6237\u53c2\u4e0e\u652f\u4ed8");
        }
        Map giftMap = giftItems.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (a, b) -> a));
        HashMap giftItemMap = new HashMap();
        if (CollectionUtil.isNotEmpty(giftItems)) {
            for (DgPerformOrderLineDto dgPerformOrderLineDto : giftItems) {
                if (!StringUtils.isNotBlank((CharSequence)dgPerformOrderLineDto.getGiftSkuIds())) continue;
                log.info("\u8d60\u54c1\u8ba2\u5355\u884c\uff1a{} \u5bf9\u5e94\u7684\u672c\u54c1\u662f\uff1a{}", (Object)dgPerformOrderLineDto.getId(), (Object)dgPerformOrderLineDto.getGiftSkuIds());
                List<Long> skuIds = Arrays.stream(dgPerformOrderLineDto.getGiftSkuIds().split(",")).map(Long::parseLong).collect(Collectors.toList());
                skuIds.forEach(skuId -> {
                    ArrayList<Long> ids = (ArrayList<Long>)giftItemMap.get(skuId);
                    if (CollectionUtil.isEmpty((Collection)ids)) {
                        ids = new ArrayList<Long>();
                    }
                    ids.add(gift2.getId());
                    giftItemMap.put(skuId, ids);
                });
            }
            log.info("\u672c\u54c1 || \u8d60\u54c1\u6620\u5c04\u7ed3\u679c\uff1a{}", giftItemMap);
        }
        for (Map.Entry entry : payRecordMap.entrySet()) {
            for (PayRecordDto payRecordDto : (List)entry.getValue()) {
                BigDecimal totalCost = payRecordDto.getPayAmount();
                log.info("\u5f53\u524d\u8d26\u6237" + (String)entry.getKey() + "\u4f7f\u7528\u603b\u91d1\u989d\u4e3a\uff1a" + totalCost);
                BigDecimal allocatedAmount = BigDecimal.ZERO;
                List<Object> subItems = new ArrayList();
                ArrayList subGiftItems = new ArrayList();
                if (StringUtils.isNotBlank((CharSequence)payRecordDto.getExtension()) && payRecordDto.getExtension().contains("orderItemId")) {
                    List matchesItems = JSON.parseArray((String)payRecordDto.getExtension(), AccountMatchesItemRespDto.class);
                    List matchesItemIds = matchesItems.stream().map(AccountMatchesItemRespDto::getOrderItemId).collect(Collectors.toList());
                    subItems = items.stream().filter(item -> matchesItemIds.contains(item.getId())).collect(Collectors.toList());
                } else {
                    subItems = new ArrayList<DgPerformOrderLineDto>(items);
                }
                if (CollectionUtil.isEmpty(subItems)) {
                    log.error("\u9002\u7528\u5546\u54c1\u4e3a\u7a7a");
                }
                List<Object> giftIds = new ArrayList();
                for (DgPerformOrderLineDto dgPerformOrderLineDto : subItems) {
                    if (!giftItemMap.containsKey(dgPerformOrderLineDto.getSkuId())) continue;
                    List ids = (List)giftItemMap.get(dgPerformOrderLineDto.getSkuId());
                    log.info("\u6620\u5c04\u7684\u8d60\u54c1id\u662f\uff1a{}", (Object)ids);
                    giftIds.addAll(ids);
                }
                if (CollectionUtil.isNotEmpty(giftIds)) {
                    giftIds = giftIds.stream().distinct().collect(Collectors.toList());
                    giftIds.forEach(gift -> subGiftItems.add(giftMap.get(gift)));
                    log.info("\u5173\u8054\u8d60\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(subGiftItems));
                }
                subItems.addAll(subGiftItems);
                List ids = subItems.stream().map(BaseDto::getId).collect(Collectors.toList());
                BigDecimal bigDecimal = kneadLaterAmounts.stream().filter(e -> ids.contains(e.getOrderLineId())).map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                log.info("\u9002\u7528\u5546\u54c1\u63c9\u4ef7\u540e\u603b\u91d1\u989d\uff1a{}", (Object)bigDecimal);
                ArrayList<DgPerformOrderLineAmountDto> subItemAmountDtoList = new ArrayList<DgPerformOrderLineAmountDto>();
                int i = 1;
                for (DgPerformOrderLineDto dgPerformOrderLineDto : subItems) {
                    BigDecimal surplusKneadAmount = (BigDecimal)surplusKneadAmountMap.get(dgPerformOrderLineDto.getId());
                    if (surplusKneadAmount.compareTo(BigDecimal.ZERO) <= 0) {
                        log.info("\u5546\u54c1:{} \u5f53\u524d\u5df2\u65e0\u5269\u4f59\u63c9\u4ef7\u91d1\u989d\u53ef\u4f9b\u5206\u914d:{}", (Object)dgPerformOrderLineDto.getId(), (Object)surplusKneadAmount);
                        continue;
                    }
                    DgPerformOrderLineAmountDto performOrderLineAmountDto = new DgPerformOrderLineAmountDto();
                    performOrderLineAmountDto.setOrderId(dgPerformOrderLineDto.getOrderId());
                    performOrderLineAmountDto.setOrderLineId(dgPerformOrderLineDto.getId());
                    performOrderLineAmountDto.setAmountSource(DgOrderAmountSourceEnum.KNEAD.getCode());
                    performOrderLineAmountDto.setAccountCategory(payRecordDto.getAccountCategory());
                    performOrderLineAmountDto.setAccountType(payRecordDto.getPayMethod());
                    performOrderLineAmountDto.setSellerId(payRecordDto.getSellerId());
                    BigDecimal itemCostKneadAmount = BigDecimal.ZERO;
                    if (bigDecimal.compareTo(allocatedAmount) <= 0) {
                        log.error("\u8ba2\u5355\u884c\uff1a{} \u6ca1\u6709\u53ef\u5206\u914d\u91d1\u989d", (Object)dgPerformOrderLineDto.getId());
                        performOrderLineAmountDto.setAmount(BigDecimal.ZERO);
                        subItemAmountDtoList.add(performOrderLineAmountDto);
                        break;
                    }
                    BigDecimal kneadLaterAmount = kneadLaterAmountMap.get(dgPerformOrderLineDto.getId());
                    if (null == kneadLaterAmount) {
                        List amountDtos;
                        if (dgPerformOrderLineDto.getGiftFlag().equals(DgGiftEnum.NOT_GIFT.getType())) {
                            log.info("\u5546\u54c1:{} \u6ca1\u6709\u63c9\u4ef7\u91d1\u989d\u4f7f\u7528\u6210\u4ea4\u91d1\u989d", (Object)dgPerformOrderLineDto.getId());
                            amountDtos = dgPerformOrderLineDto.getAmountDtoList().stream().filter(amount -> amount.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode())).collect(Collectors.toList());
                            kneadLaterAmount = amountDtos.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                        } else {
                            log.info("\u5546\u54c1:{} \u6ca1\u6709\u63c9\u4ef7\u91d1\u989d\u4f7f\u7528\u5b9e\u9645\u91d1\u989d", (Object)dgPerformOrderLineDto.getId());
                            amountDtos = dgPerformOrderLineDto.getAmountDtoList().stream().filter(amount -> amount.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode())).collect(Collectors.toList());
                            kneadLaterAmount = amountDtos.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                        }
                    }
                    log.info("\u5546\u54c1:{} \u63c9\u4ef7\u7ed3\u7b97\u91d1\u989d:{}", (Object)dgPerformOrderLineDto.getId(), (Object)kneadLaterAmount);
                    itemCostKneadAmount = i == subItems.size() ? totalCost.subtract(allocatedAmount) : totalCost.multiply(kneadLaterAmount.divide(bigDecimal, 6, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
                    if (itemCostKneadAmount.compareTo(surplusKneadAmount) > 0) {
                        itemCostKneadAmount = surplusKneadAmount;
                        surplusKneadAmount = BigDecimal.ZERO;
                    } else {
                        surplusKneadAmount = surplusKneadAmount.subtract(itemCostKneadAmount);
                    }
                    performOrderLineAmountDto.setAmount(itemCostKneadAmount);
                    subItemAmountDtoList.add(performOrderLineAmountDto);
                    allocatedAmount = allocatedAmount.add(itemCostKneadAmount);
                    surplusKneadAmountMap.put(dgPerformOrderLineDto.getId(), surplusKneadAmount);
                    log.info("\u5546\u54c1:{} \u5206\u914d\u5230\u7684\u63c9\u4ef7\u7ed3\u7b97\u91d1\u989d:{} || \u5269\u4f59\u63c9\u4ef7\u7ed3\u7b97\u91d1\u989d:{}", new Object[]{dgPerformOrderLineDto.getId(), itemCostKneadAmount, surplusKneadAmount});
                    log.info("\u5f53\u524d\u8d26\u6237" + (String)entry.getKey() + "\u5f53\u524d\u5df2\u5206\u914d\u91d1\u989d\uff1a" + allocatedAmount);
                    ++i;
                }
                if (totalCost.compareTo(allocatedAmount) > 0) {
                    log.info("\u5f53\u524d\u8d26\u6237" + (String)entry.getKey() + "\u8fdb\u5165\u4fee\u6b63\u8865\u507f\u5206\u914d");
                    BigDecimal surplusAllocatedAmount = totalCost.subtract(allocatedAmount);
                    log.info("\u5f53\u524d\u8d26\u6237" + (String)entry.getKey() + "\u5269\u4f59\u53ef\u5206\u914d\u91d1\u989d\uff1a" + surplusAllocatedAmount);
                    for (DgPerformOrderLineAmountDto amount2 : subItemAmountDtoList) {
                        BigDecimal surplusKneadAmount = (BigDecimal)surplusKneadAmountMap.get(amount2.getOrderLineId());
                        log.info("\u5546\u54c1:{} \u5269\u4f59\u63c9\u4ef7\u7ed3\u7b97\u91d1\u989d:{}  || \u539f\u63c9\u4ef7\u5206\u644a\u91d1\u989d\uff1a{}", new Object[]{amount2.getOrderLineId(), surplusKneadAmount, amount2.getAmount()});
                        if (surplusKneadAmount.compareTo(BigDecimal.ZERO) > 0) {
                            BigDecimal newAmount = BigDecimal.ZERO;
                            if (surplusKneadAmount.compareTo(surplusAllocatedAmount) >= 0) {
                                amount2.setExtension("\u4fee\u6b63\u8865\u507f\u91d1\u989d" + surplusAllocatedAmount);
                                newAmount = amount2.getAmount().add(surplusAllocatedAmount);
                                surplusKneadAmount = surplusKneadAmount.subtract(surplusAllocatedAmount);
                                surplusAllocatedAmount = BigDecimal.ZERO;
                            } else {
                                amount2.setExtension("\u4fee\u6b63\u8865\u507f\u91d1\u989d" + surplusKneadAmount);
                                newAmount = amount2.getAmount().add(surplusKneadAmount);
                                surplusAllocatedAmount = surplusAllocatedAmount.subtract(surplusKneadAmount);
                                surplusKneadAmount = BigDecimal.ZERO;
                            }
                            amount2.setAmount(newAmount);
                            surplusKneadAmountMap.put(amount2.getOrderLineId(), surplusKneadAmount);
                            log.info("\u5546\u54c1:{} \u65b0\u5206\u914d\u5230\u7684\u63c9\u4ef7\u91d1\u989d\uff1a{}", (Object)amount2.getOrderLineId(), (Object)newAmount);
                        } else {
                            log.info("\u5546\u54c1:{} \u6ca1\u6709\u5269\u4f59\u53ef\u5206\u914d\u91d1\u989d", (Object)amount2.getOrderLineId());
                        }
                        if (surplusAllocatedAmount.compareTo(BigDecimal.ZERO) > 0) continue;
                        break;
                    }
                }
                kneadCapitalItemAmountDtoList.addAll(subItemAmountDtoList);
                log.info("\u5f53\u524d\u8d26\u6237" + (String)entry.getKey() + "\u63c9\u4ef7\u5206\u644a\u7ed3\u675f==================end");
            }
        }
        return kneadCapitalItemAmountDtoList;
    }

    private BigDecimal getAmount(List<DgPerformOrderLineAmountDto> amountDtoList, String amountType) {
        return amountDtoList.stream().filter(amount -> amount.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode()) && amount.getAccountType().equals(amountType)).map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private List<DgPerformOrderLineAmountDto> getAmountDtoList(List<DgPerformOrderLineAmountDto> amountDtoList, String amountType) {
        return amountDtoList.stream().filter(amount -> amount.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode()) && amount.getAccountType().equals(amountType)).collect(Collectors.toList());
    }
}

