/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.common.Impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.logistics.dto.LogisticsInfoDto;
import com.yunxi.dg.base.center.logistics.dto.LogisticsInfoPageReqDto;
import com.yunxi.dg.base.center.logistics.proxy.entity.ILogisticsInfoApiProxy;
import com.yunxi.dg.base.center.report.dto.agg.DgBasisOrderRelOrderInfoRespDto;
import com.yunxi.dg.base.center.report.dto.agg.DgRelOrderReqDto;
import com.yunxi.dg.base.center.report.proxy.agg.IDgBasisOrderRelOrderInfoApiProxy;
import com.yunxi.dg.base.center.share.dto.entity.TransferGoodsOrderDto;
import com.yunxi.dg.base.center.share.dto.entity.TransferGoodsOrderPageReqDto;
import com.yunxi.dg.base.center.share.proxy.entity.ITransferGoodsOrderApiProxy;
import com.yunxi.dg.base.center.trade.constants.DgConsignTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgPlatFormOrderSelectTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.SaleOrderStatusFlowTemplate;
import com.yunxi.dg.base.center.trade.constants.SplitStatusEnum;
import com.yunxi.dg.base.center.trade.constants.TradeStatusFlowSelector;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderWarehouseInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.BeforeOrderItemNumDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformNoticeSyncRecordShippingDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderWarehouseInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.SaleOrderAuditDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPlatformSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderStatusLogRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRelevanceDetailRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRelevanceRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.b2c.DgOrderExistReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.b2c.DgOrderExistRespDto;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderExtensionEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderWarehouseInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.exception.PcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordService;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordShippingService;
import com.yunxi.dg.base.center.trade.service.oms.b2b.IB2BOrderQueryService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderQueryService;
import com.yunxi.dg.base.center.trade.service.oms.common.ICommonOrderQueryService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CommonOrderQueryServiceImpl
implements ICommonOrderQueryService {
    private static final Logger log = LoggerFactory.getLogger(CommonOrderQueryServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonOrderQueryServiceImpl.class);
    @Resource
    private IDgOmsOrderQueryService omsOrderQueryService;
    @Resource
    private IB2BOrderQueryService b2BOrderQueryService;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain dgPerformOrderSnapshotDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgAfterSaleOrderDomain dgAfterSaleOrderDomain;
    @Resource
    private IDgBasisOrderRelOrderInfoApiProxy dgBasisOrderRelOrderInfoApiProxy;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IDgOrderLabelRecordDomain dgOrderLabelRecordDomain;
    @Resource
    private ITransferGoodsOrderApiProxy transferGoodsOrderApiProxy;
    @Resource
    private IDgPerformOrderExtensionDomain performOrderExtensionDomain;
    @Resource
    private IDgPerformOrderItemLineDomain dgPerformOrderItemLineDomain;
    @Resource
    private IDgPerformNoticeSyncRecordService performNoticeSyncRecordService;
    @Resource
    private IDgPerformNoticeSyncRecordShippingService performNoticeSyncRecordShippingService;
    @Resource
    private ILogisticsInfoApiProxy logisticsInfoApiProxy;
    @Resource
    private IDgPerformOrderWarehouseInfoDomain dgPerformOrderWarehouseInfoDomain;
    private List<String> filterUnexecuteStatus = Lists.newArrayList((Object[])new String[]{DgOmsSaleOrderStatus.LACK.getCode()});

    @Override
    public DgPerformOrderRespDto querySaleOrderById(Long id) {
        AssertUtils.notNull((Object)id, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(id);
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728");
        return saleOrderRespDto;
    }

    @Override
    public DgBizPerformOrderRespDto queryByOrderNo(String orderNo) {
        LOGGER.info("\u83b7\u53d6\u8ba2\u8d27\u5355\u8be6\u60c5\u4fe1\u606f\uff1a{}", (Object)orderNo);
        AssertUtils.notNull((Object)orderNo, (String)"\u8ba2\u5355orderNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgPerformOrderReqDto queryDto = new DgPerformOrderReqDto();
        queryDto.setSaleOrderNo(orderNo);
        DgPerformOrderRespDto orderInfoDto = this.omsOrderInfoQueryDomain.queryByDtoNoReleationInfo(queryDto);
        AssertUtils.isFalse((orderInfoDto == null ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u9500\u552e\u8ba2\u5355\u4fe1\u606f");
        if (DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode().equals(orderInfoDto.getBizModel())) {
            return this.omsOrderQueryService.queryByOrderNo(orderNo);
        }
        if (DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode().equals(orderInfoDto.getBizModel())) {
            return this.b2BOrderQueryService.queryByOrderNo(orderNo);
        }
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderEo::getSaleOrderNo, (Object)orderNo);
        DgPerformOrderRespDto performOrderInfoDto = this.omsOrderInfoQueryDomain.queryDtoByOrderNo(orderNo);
        AssertUtils.notNull((Object)performOrderInfoDto, (String)"%s\u8ba2\u5355\u4e0d\u5b58\u5728", (Object[])new Object[]{orderNo});
        DgBizPerformOrderRespDto saleOrderRespDto = new DgBizPerformOrderRespDto();
        BeanUtil.copyProperties((Object)performOrderInfoDto, (Object)saleOrderRespDto, (String[])new String[0]);
        return saleOrderRespDto;
    }

    @Override
    public List<DgPerformOrderRespDto> queryByPlatFormOrderNo(String platFormOrderNo, String platFormOrderSelectTypeCode) {
        AssertUtils.notBlank((String)platFormOrderNo, (String)"\u5e73\u53f0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)platFormOrderSelectTypeCode, (String)"\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        List list = this.omsOrderInfoQueryDomain.queryDtoByPlatformOrderNo(platFormOrderNo);
        DgPlatFormOrderSelectTypeEnum platFormOrderSelectTypeEnum = DgPlatFormOrderSelectTypeEnum.forCode((String)platFormOrderSelectTypeCode);
        switch (platFormOrderSelectTypeEnum) {
            case NOW_USE: {
                list = list.stream().filter(e -> !e.getOrderStatus().equals(DgOmsSaleOrderStatus.SPLIT.getCode())).collect(Collectors.toList());
                break;
            }
            case ORIGIN: {
                list = list.stream().filter(e -> !e.getOrderType().equals(DgSaleOrderTypeEnum.REPLENISH_ORDER.getType()) || !e.getOrderType().equals(DgSaleOrderTypeEnum.EXCHANGE_ORDER.getType())).sorted(Comparator.comparing(BaseDto::getCreateTime)).collect(Collectors.toList());
                break;
            }
            case ALL: {
                break;
            }
            default: {
                throw PcpTradeExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u9519\u8befplatFormOrderSelectTypeCode"});
            }
        }
        return list;
    }

    @Override
    public List<DgPerformOrderRespDto> queryByOrderIds(List<Long> orderIds) {
        AssertUtils.notEmpty(orderIds, (String)"orderId\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        List saleOrderEos = this.omsOrderInfoQueryDomain.queryDtoByIds(orderIds);
        if (CollectionUtils.isEmpty((Collection)saleOrderEos)) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)saleOrderEos, DgPerformOrderRespDto.class);
        return resultList;
    }

    @Override
    public PageInfo<DgPerformOrderRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return null;
    }

    @Override
    public PageInfo<DgPerformOrderRespDto> queryByPage(DgPerformOrderReqDto reqDto, Integer pageNum, Integer pageSize) {
        ExtQueryChainWrapper filter = this.dgPerformOrderInfoDomain.filter();
        if (Objects.nonNull(reqDto.getSaleOrderNo())) {
            filter.eq((Object)"sale_order_no", (Object)reqDto.getSaleOrderNo());
        }
        if (Objects.nonNull(reqDto.getPlatformOrderNo())) {
            filter.eq((Object)"platform_order_no", (Object)reqDto.getPlatformOrderNo());
        }
        if (Objects.nonNull(reqDto.getId())) {
            filter.eq((Object)"id", (Object)reqDto.getId());
        }
        if (Objects.nonNull(reqDto.getOrderStatus())) {
            filter.eq((Object)"order_status", (Object)reqDto.getOrderStatus());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrderStatusList())) {
            filter.in((Object)"order_status", (Collection)reqDto.getOrderStatusList());
        }
        if (Objects.nonNull(reqDto.getBizModel())) {
            filter.in((Object)"biz_model", new Object[]{reqDto.getBizModel()});
        }
        if (Objects.nonNull(reqDto.getOrderType())) {
            filter.in((Object)"order_type", new Object[]{reqDto.getOrderType()});
        }
        PageInfo page = filter.page(pageNum, pageSize);
        PageInfo dgPerformOrderRespDtoPageInfo = new PageInfo();
        BeanUtil.copyProperties((Object)page, (Object)dgPerformOrderRespDtoPageInfo, (String[])new String[]{"list"});
        List dgPerformOrderRespDtos = BeanUtil.copyToList((Collection)page.getList(), DgPerformOrderRespDto.class);
        if (CollectionUtils.isNotEmpty((Collection)dgPerformOrderRespDtos)) {
            List orderIds = dgPerformOrderRespDtos.stream().map(BaseDto::getId).collect(Collectors.toList());
            LinkedHashSet orderIdSet = new LinkedHashSet(orderIds);
            List dgPerformOrderSnapshotEos = this.dgPerformOrderSnapshotDomain.selectByOrderIds(orderIdSet);
            Map orderMap = dgPerformOrderSnapshotEos.stream().collect(Collectors.toMap(DgPerformOrderSnapshotEo::getOrderId, Function.identity()));
            for (DgPerformOrderRespDto dgPerformOrderRespDto : dgPerformOrderRespDtos) {
                DgPerformOrderSnapshotEo snapshotEo = (DgPerformOrderSnapshotEo)orderMap.get(dgPerformOrderRespDto.getId());
                DgPerformOrderSnapshotDto snapshotDto = new DgPerformOrderSnapshotDto();
                CubeBeanUtils.copyProperties((Object)snapshotDto, (Object)snapshotEo, (String[])new String[0]);
                dgPerformOrderRespDto.setPerformOrderSnapshotDto(snapshotDto);
            }
        }
        dgPerformOrderRespDtoPageInfo.setList(dgPerformOrderRespDtos);
        return dgPerformOrderRespDtoPageInfo;
    }

    @Override
    public PageInfo<DgPerformOrderRespDto> queryPerformOrderPage(DgPerformOrderReqDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        PageInfo pageInfo = new PageInfo(this.dgPerformOrderInfoDomain.queryPerformOrderList(reqDto));
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List orderIds = pageInfo.getList().stream().map(BaseDto::getId).collect(Collectors.toList());
            List performOrderDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderIds(orderIds);
            Map<Long, List<DgPerformOrderLineDto>> orderLineMap = performOrderDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderLineDto::getOrderId));
            for (DgPerformOrderRespDto dgPerformOrderRespDto : pageInfo.getList()) {
                DgPerformOrderWarehouseInfoEo dgPerformOrderWarehouseInfoEo = this.dgPerformOrderWarehouseInfoDomain.selectByOrderId(dgPerformOrderRespDto.getId());
                DgPerformOrderWarehouseInfoDto warehouseInfoDto = new DgPerformOrderWarehouseInfoDto();
                CubeBeanUtils.copyProperties((Object)warehouseInfoDto, (Object)dgPerformOrderWarehouseInfoEo, (String[])new String[0]);
                dgPerformOrderRespDto.setOrderLineList(orderLineMap.get(dgPerformOrderRespDto.getId()));
                dgPerformOrderRespDto.setPerformOrderWarehouseInfoDto(warehouseInfoDto);
            }
        }
        return pageInfo;
    }

    @Override
    public List<DgOrderStatusLogRespDto> queryOrderStatus(Long orderId) {
        return this.queryOrderStatus(orderId, TradeStatusFlowSelector.TC.getCode());
    }

    @Override
    public List<DgOrderStatusLogRespDto> queryOrderStatus(Long orderId, String type) {
        Map<String, List<DgOrderStatusLogRespDto>> orderStatusHistoryListMap;
        List orderStatusLogRespDtos;
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto orderDasOne = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)orderDasOne, (String)String.format("orderId=%s\u7684\u8ba2\u5355\u4e0d\u5b58\u5728", orderId));
        TradeStatusFlowSelector statusFlowSelector = TradeStatusFlowSelector.enumOf((String)type);
        Map orderStatusMap = statusFlowSelector.getLookup();
        List saleOrderStatusList = statusFlowSelector.getSaleOrderStatusList();
        List<DgOrderStatusLogRespDto> orderStatusTemplateList = this.getOrderStatusTemplate(saleOrderStatusList);
        String orderSteps = orderDasOne.getOrderSteps();
        if (StringUtils.isNotBlank((CharSequence)orderSteps)) {
            orderStatusLogRespDtos = JSON.parseArray((String)orderSteps, DgOrderStatusLogRespDto.class);
            orderStatusLogRespDtos.sort(Comparator.comparing(DgOrderStatusLogRespDto::getOptDate).reversed());
            orderStatusHistoryListMap = orderStatusLogRespDtos.stream().collect(Collectors.groupingBy(DgOrderStatusLogRespDto::getOrderStatus));
            LOGGER.info("[\u8ba2\u5355\u72b6\u6001]\u5f53\u524d\u9500\u552e\u8ba2\u5355\uff08orderId={}\uff09\u7684\u72b6\u6001\u5217\u8868:{}", (Object)orderId, (Object)orderSteps);
            for (int i = 0; i < orderStatusTemplateList.size() && i <= orderStatusLogRespDtos.size(); ++i) {
                DgOrderStatusLogRespDto templateItem = orderStatusTemplateList.get(i);
                List<DgOrderStatusLogRespDto> statusList = orderStatusHistoryListMap.get(templateItem.getOrderStatus());
                if (statusList != null) {
                    DgOrderStatusLogRespDto statusLogRespDto = statusList.get(0);
                    templateItem.setOptDate(statusLogRespDto.getOptDate());
                } else if (i == 0) {
                    templateItem.setOptDate(orderDasOne.getCreateTime());
                }
                if (!orderDasOne.getOrderStatus().equals(templateItem.getOrderStatus()) || i <= orderStatusLogRespDtos.size() - 1) continue;
                templateItem.setActive(Boolean.TRUE);
                break;
            }
        }
        orderStatusTemplateList.parallelStream().forEach(arg_0 -> CommonOrderQueryServiceImpl.lambda$queryOrderStatus$2((DgPerformOrderInfoDto)orderDasOne, orderStatusMap, arg_0));
        if (Objects.equals(orderDasOne.getOrderStatus(), DgSaleOrderStatusEnum.LACK.getCode()) && Objects.equals(orderDasOne.getConsignType(), DgConsignTypeEnum.THIRD.getType())) {
            orderStatusLogRespDtos = JSON.parseArray((String)orderSteps, DgOrderStatusLogRespDto.class);
            orderStatusLogRespDtos.sort(Comparator.comparing(DgOrderStatusLogRespDto::getOptDate).reversed());
            orderStatusHistoryListMap = orderStatusLogRespDtos.stream().collect(Collectors.groupingBy(DgOrderStatusLogRespDto::getOrderStatus));
            orderStatusTemplateList.forEach(arg_0 -> CommonOrderQueryServiceImpl.lambda$queryOrderStatus$3((DgPerformOrderInfoDto)orderDasOne, orderStatusHistoryListMap, arg_0));
        }
        Iterator<DgOrderStatusLogRespDto> iterator = orderStatusTemplateList.iterator();
        while (iterator.hasNext()) {
            DgOrderStatusLogRespDto statusLogRespDto = iterator.next();
            if (!this.filterUnexecuteStatus.contains(statusLogRespDto.getOrderStatusCode()) || !Objects.isNull(statusLogRespDto.getOptDate())) continue;
            iterator.remove();
        }
        LOGGER.info("[\u8ba2\u5355\u72b6\u6001]\u5f53\u524d\u9500\u552e\u8ba2\u5355\uff08orderId={}\uff09\u7684\u72b6\u6001\u5217\u8868:{}", (Object)orderId, (Object)JSON.toJSONString(orderStatusTemplateList));
        return orderStatusTemplateList;
    }

    private List<DgOrderStatusLogRespDto> getOrderStatusTemplate(List<SaleOrderStatusFlowTemplate> saleOrderStatusList) {
        return saleOrderStatusList.stream().map(item -> {
            DgOrderStatusLogRespDto orderStatusLogRespDto = new DgOrderStatusLogRespDto();
            orderStatusLogRespDto.setOrderStatus(item.getCode());
            return orderStatusLogRespDto;
        }).collect(Collectors.toList());
    }

    @Override
    public List<DgWmsShippingInfoReqDto> queryOrderShippingInfoList(Long orderId) {
        log.info("\u67e5\u8be2\u7269\u6d41\u4fe1\u606fqueryOrderShippingInfoList\uff1a{}", (Object)orderId);
        List<DgPerformNoticeSyncRecordShippingDto> recordShippingDtoList = this.performNoticeSyncRecordShippingService.queryByRecordId(orderId);
        if (CollectionUtils.isNotEmpty(recordShippingDtoList)) {
            return recordShippingDtoList.stream().map(dto -> {
                DgWmsShippingInfoReqDto infoReqDto = (DgWmsShippingInfoReqDto)BeanUtil.copyProperties((Object)dto, DgWmsShippingInfoReqDto.class, (String[])new String[0]);
                infoReqDto.setShippingNo(dto.getConsignmentNo());
                infoReqDto.setShippingCompanyName(dto.getShippingCompany());
                infoReqDto.setShippingCompanyCode(dto.getShippingCompanyCode());
                infoReqDto.setConsignNo(dto.getConsignmentNo());
                return infoReqDto;
            }).collect(Collectors.toList());
        }
        return new ArrayList<DgWmsShippingInfoReqDto>();
    }

    @Override
    public List<DgPerformOrderRespDto> queryNeedConfirmGoodsOrderList(Long lastOrderId, Integer pageSize) {
        return null;
    }

    @Override
    public List<DgPerformOrderRespDto> listByPlatFormOrderNo(DgPlatformSaleOrderReqDto platformDto) {
        if (Objects.isNull(platformDto) || CollectionUtils.isEmpty((Collection)platformDto.getPlatformOrderNos())) {
            return Collections.emptyList();
        }
        return this.omsOrderInfoQueryDomain.queryDtoByPlatformOrderNos(platformDto.getPlatformOrderNos());
    }

    @Override
    public List<DgPerformOrderRespDto> listByDeliveryOrderNo(List<String> deliveryOrderNos) {
        if (CollectionUtils.isEmpty(deliveryOrderNos)) {
            return Collections.emptyList();
        }
        List saleOrderEos = this.omsOrderInfoQueryDomain.queryDtoByOrderNoList(deliveryOrderNos);
        ArrayList respDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respDtoList, (Collection)saleOrderEos, DgPerformOrderRespDto.class);
        return respDtoList;
    }

    @Override
    public DgPerformOrderRelevanceRespDto queryF2bOrderDetailRel(Long orderId) {
        DgPerformOrderExtensionEo dgPerformOrderExtensionEo;
        AssertUtils.notNull((Object)orderId, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRelevanceRespDto respDto = new DgPerformOrderRelevanceRespDto();
        List dgPerformOrderRespDtos = this.omsOrderInfoQueryDomain.queryDtoByPlatformId(orderId);
        ArrayList deliveryList = Lists.newArrayList();
        ArrayList deliveryNoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dgPerformOrderRespDtos)) {
            for (DgPerformOrderRespDto dgPerformOrderRespDto : dgPerformOrderRespDtos) {
                DgPerformOrderRelevanceDetailRespDto detailRespDto = new DgPerformOrderRelevanceDetailRespDto();
                detailRespDto.setRelevanceId(dgPerformOrderRespDto.getId());
                detailRespDto.setRelevanceNo(dgPerformOrderRespDto.getSaleOrderNo());
                detailRespDto.setOrderType("delivery");
                detailRespDto.setOrderStatus(dgPerformOrderRespDto.getOrderStatus());
                detailRespDto.setCreateTime(dgPerformOrderRespDto.getCreateTime());
                deliveryList.add(detailRespDto);
                deliveryNoList.add(dgPerformOrderRespDto.getSaleOrderNo());
            }
        }
        if (ObjectUtil.isNotEmpty((Object)(dgPerformOrderExtensionEo = this.performOrderExtensionDomain.selectByOrderId(orderId))) && StringUtils.isNotBlank((CharSequence)dgPerformOrderExtensionEo.getFreightReissueOrderNo())) {
            DgPerformOrderInfoEo dgPerformOrderInfoEo = this.dgPerformOrderInfoDomain.queryByOrderNo(dgPerformOrderExtensionEo.getFreightReissueOrderNo());
            Optional.ofNullable(dgPerformOrderInfoEo).ifPresent(order -> {
                DgPerformOrderRelevanceDetailRespDto detailRespDto = new DgPerformOrderRelevanceDetailRespDto();
                detailRespDto.setRelevanceId(order.getId());
                detailRespDto.setRelevanceNo(order.getSaleOrderNo());
                detailRespDto.setOrderType("delivery");
                detailRespDto.setOrderStatus(order.getOrderStatus());
                detailRespDto.setCreateTime(order.getCreateTime());
                deliveryList.add(detailRespDto);
            });
        }
        respDto.setDeliveryList((List)deliveryList);
        LambdaQueryWrapper afterEoQuery = new LambdaQueryWrapper();
        afterEoQuery.eq(BaseEo::getDr, (Object)0);
        afterEoQuery.eq(DgAfterSaleOrderEo::getSaleOrderId, (Object)orderId);
        List dgRefundEos = this.dgAfterSaleOrderDomain.getMapper().selectList((Wrapper)afterEoQuery);
        ArrayList refundList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dgRefundEos)) {
            for (DgAfterSaleOrderEo afterEo : dgRefundEos) {
                DgPerformOrderRelevanceDetailRespDto detailRespDto = new DgPerformOrderRelevanceDetailRespDto();
                detailRespDto.setRelevanceId(afterEo.getId());
                detailRespDto.setRelevanceNo(afterEo.getAfterSaleOrderNo());
                detailRespDto.setOrderType("after");
                detailRespDto.setOrderStatus(afterEo.getStatus());
                detailRespDto.setCreateTime(afterEo.getCreateTime());
                refundList.add(detailRespDto);
            }
        }
        respDto.setRefundList((List)refundList);
        DgPerformOrderRespDto dgPerformOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)dgPerformOrderRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        TransferGoodsOrderPageReqDto reqDto = new TransferGoodsOrderPageReqDto();
        reqDto.setPreOrderNo(dgPerformOrderRespDto.getSaleOrderNo());
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(9999));
        PageInfo transferGoodsOrderDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.transferGoodsOrderApiProxy.page(reqDto));
        List transferGoodsOrderDtoList = transferGoodsOrderDtoPageInfo.getList();
        ArrayList<DgPerformOrderRelevanceDetailRespDto> channelTransferList = new ArrayList<DgPerformOrderRelevanceDetailRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)transferGoodsOrderDtoList)) {
            for (TransferGoodsOrderDto transferGoodsOrderDto : transferGoodsOrderDtoList) {
                DgPerformOrderRelevanceDetailRespDto detailRespDto = new DgPerformOrderRelevanceDetailRespDto();
                detailRespDto.setRelevanceId(transferGoodsOrderDto.getId());
                detailRespDto.setRelevanceNo(transferGoodsOrderDto.getOrderNo());
                detailRespDto.setOrderType("channelTransfer");
                detailRespDto.setOrderStatus(transferGoodsOrderDto.getOrderStatus());
                detailRespDto.setCreateTime(transferGoodsOrderDto.getCreateTime());
                channelTransferList.add(detailRespDto);
            }
        }
        respDto.setChannelTransferList(channelTransferList);
        ArrayList inventoryList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)deliveryNoList)) {
            for (String delvieryNo : deliveryNoList) {
                DgRelOrderReqDto dgRelOrderReqDto = new DgRelOrderReqDto();
                dgRelOrderReqDto.setRelevanceNo(delvieryNo);
                List dgBasisOrderRelOrderInfoRespDtos = null;
                try {
                    dgBasisOrderRelOrderInfoRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgBasisOrderRelOrderInfoApiProxy.queryRelOrderByRelevanceNo(dgRelOrderReqDto));
                }
                catch (Exception e) {
                    LOGGER.info("\u6839\u636e\u53d1\u8d27\u5355\u53f7\u67e5\u8be2\u5e93\u5b58\u5355\u636e\u4fe1\u606f\u5f02\u5e38:", (Object)e.getMessage());
                }
                if (!CollectionUtils.isNotEmpty((Collection)dgBasisOrderRelOrderInfoRespDtos)) continue;
                for (DgBasisOrderRelOrderInfoRespDto inventoryOrder : dgBasisOrderRelOrderInfoRespDtos) {
                    DgPerformOrderRelevanceDetailRespDto detailRespDto = new DgPerformOrderRelevanceDetailRespDto();
                    detailRespDto.setRelevanceId(inventoryOrder.getId());
                    detailRespDto.setRelevanceNo(inventoryOrder.getDocumentNo());
                    detailRespDto.setOrderStatus(inventoryOrder.getOrderStatus());
                    detailRespDto.setOrderType(inventoryOrder.getOrderType());
                    detailRespDto.setCreateTime(inventoryOrder.getCreateTime());
                    inventoryList.add(detailRespDto);
                }
            }
        }
        respDto.setInventoryList((List)inventoryList);
        return respDto;
    }

    @Override
    public DgPerformOrderRespDto queryByPlatFormOrderNoAndFSG(String platFormOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)platFormOrderNo), (String)"\u5e73\u53f0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List dgPerformOrderInfoEos = this.dgPerformOrderInfoDomain.queryEoByPlatformOrderNo(platFormOrderNo);
        if (CollectionUtils.isNotEmpty((Collection)dgPerformOrderInfoEos)) {
            List dgOrderLabelRecordDtos = this.dgOrderLabelRecordDomain.queryByOrderIdsAndLabelCodes(dgPerformOrderInfoEos.stream().map(BaseEo::getId).collect(Collectors.toList()), DgOrderLabelEnum.SALE_ORDER_CREATE.getCode());
            if (CollectionUtils.isNotEmpty((Collection)dgOrderLabelRecordDtos)) {
                return null;
            }
            if (dgPerformOrderInfoEos.size() == 1) {
                DgPerformOrderRespDto respDto = new DgPerformOrderRespDto();
                CubeBeanUtils.copyProperties((Object)respDto, dgPerformOrderInfoEos.get(0), (String[])new String[0]);
            } else {
                List orderInfoEos = dgPerformOrderInfoEos.stream().filter(eo -> eo.getSplitStatus().equals(SplitStatusEnum.SPLIT.getType())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(orderInfoEos)) {
                    throw new BizException("\u5b58\u5728\u591a\u6761\u4e00\u6837\u7684\u975e\u624b\u5de5\u521b\u5efa\u7684\u5e73\u53f0\u9500\u552e\u5355");
                }
                if (orderInfoEos.size() > 1) {
                    throw new BizException("\u5b58\u5728\u591a\u6761\u4e00\u6837\u7684\u975e\u624b\u5de5\u521b\u5efa\u7684\u5e73\u53f0\u9500\u552e\u5355");
                }
                DgPerformOrderRespDto respDto = new DgPerformOrderRespDto();
                CubeBeanUtils.copyProperties((Object)respDto, orderInfoEos.get(0), (String[])new String[0]);
            }
        }
        return null;
    }

    @Override
    public List<DgPerformOrderRespDto> queryOrderByPlatformOrderNo(List<String> platformOrderNos) {
        AssertUtils.isFalse((boolean)CollectionUtil.isEmpty(platformOrderNos), (String)"\u5e73\u53f0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<DgPerformOrderRespDto> result = new ArrayList<DgPerformOrderRespDto>();
        List dgPerformOrderInfoEos = this.dgPerformOrderInfoDomain.queryEoByPlatformOrderNos(platformOrderNos);
        if (CollectionUtils.isNotEmpty((Collection)dgPerformOrderInfoEos)) {
            CubeBeanUtils.copyCollection(result, (Collection)dgPerformOrderInfoEos, DgPerformOrderRespDto.class);
        }
        return result;
    }

    @Override
    public List<BeforeOrderItemNumDto> queryRelBeforeItemNum(String beforeOrderNo) {
        List beforeOrderItemNumVos = this.dgPerformOrderLineDomain.queryRelBeforeItemNum(beforeOrderNo);
        ArrayList beforeOrderItemNumDtoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)beforeOrderItemNumVos)) {
            return beforeOrderItemNumDtoList;
        }
        CubeBeanUtils.copyCollection((Collection)beforeOrderItemNumDtoList, (Collection)beforeOrderItemNumVos, BeforeOrderItemNumDto.class);
        return beforeOrderItemNumDtoList;
    }

    @Override
    public List<DgPerformOrderRespDto> queryOrderByPlatformOrderNoInstallation(List<String> saleOrderNos) {
        log.info("\u8bf7\u6c42\u5185\u90e8\u9500\u552e\u5355\u636e\u53f7\uff1a{}", (Object)JSON.toJSONString(saleOrderNos));
        AssertUtils.isFalse((boolean)CollectionUtil.isEmpty(saleOrderNos), (String)"\u5185\u90e8\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<DgPerformOrderRespDto> result = new ArrayList<DgPerformOrderRespDto>();
        List dgPerformOrderInfoEos = this.dgPerformOrderInfoDomain.queryEoBySaleOrderNos(saleOrderNos);
        if (CollectionUtils.isNotEmpty((Collection)dgPerformOrderInfoEos)) {
            CubeBeanUtils.copyCollection(result, (Collection)dgPerformOrderInfoEos, DgPerformOrderRespDto.class);
            List ids = dgPerformOrderInfoEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            List dgPerformOrderItemLineEos = this.dgPerformOrderItemLineDomain.queryItemLineByOrderIds(ids);
            Map<Long, List<DgPerformOrderItemLineEo>> map = dgPerformOrderItemLineEos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getOrderId));
            for (DgPerformOrderRespDto dgPerformOrderRespDto : result) {
                Long id = dgPerformOrderRespDto.getId();
                if (CollectionUtil.isNotEmpty(map) && CollectionUtil.isNotEmpty((Collection)map.get(id))) {
                    DgPerformOrderItemLineEo dgPerformOrderItemLineEo = map.get(id).get(0);
                    dgPerformOrderRespDto.setHomeInstallation(dgPerformOrderItemLineEo.getHomeInstallation());
                    continue;
                }
                dgPerformOrderRespDto.setHomeInstallation("0");
            }
        }
        return result;
    }

    @Override
    public List<DgPerformNoticeSyncRecordShippingDto> queryOrderShippingInfoList2(Long orderId) {
        log.info("\u6839\u636e\u8ba2\u5355id\u67e5\u8be2\u8ba2\u5355\u7684\u7269\u6d41\u4fe1\u606f\uff1a{}", (Object)orderId);
        List<DgPerformNoticeSyncRecordShippingDto> recordShippingDtoList = this.performNoticeSyncRecordShippingService.queryByOrderId(orderId);
        if (CollectionUtils.isNotEmpty(recordShippingDtoList)) {
            List consignmentNoList = recordShippingDtoList.stream().map(DgPerformNoticeSyncRecordShippingDto::getConsignmentNo).collect(Collectors.toList());
            LogisticsInfoPageReqDto reqDto = new LogisticsInfoPageReqDto();
            reqDto.setOrderNoList(consignmentNoList);
            PageInfo logisticsInfoDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.logisticsInfoApiProxy.pageList(reqDto));
            Map logisticsInfoDtoMap = Optional.ofNullable(logisticsInfoDtoPageInfo.getList()).map(list -> logisticsInfoDtoPageInfo.getList().stream().collect(Collectors.toMap(LogisticsInfoDto::getLogisticsOrderNo, Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
            recordShippingDtoList.forEach(shipping -> shipping.setLogisticsInfoDto((LogisticsInfoDto)logisticsInfoDtoMap.get(shipping.getConsignmentNo())));
            return recordShippingDtoList;
        }
        return new ArrayList<DgPerformNoticeSyncRecordShippingDto>();
    }

    @Override
    public Boolean platformOrderExist(String platformOrderNo) {
        if (StringUtils.isBlank((CharSequence)platformOrderNo)) {
            return false;
        }
        List dgPerformOrderInfoEos = this.dgPerformOrderInfoDomain.queryEoByPlatformOrderNo(platformOrderNo);
        return CollectionUtils.isNotEmpty((Collection)dgPerformOrderInfoEos);
    }

    @Override
    public Boolean deliveryOrderExist(String orderNo) {
        if (StringUtils.isBlank((CharSequence)orderNo)) {
            return false;
        }
        DgPerformOrderInfoEo dgPerformOrderInfoEo = this.dgPerformOrderInfoDomain.queryByOrderNo(orderNo);
        return dgPerformOrderInfoEo != null;
    }

    @Override
    public DgOrderExistRespDto orderExist(DgOrderExistReqDto reqDto) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)reqDto.getPlatformOrderNo()), (String)"\u8bf7\u6c42\u53c2\u6570platformOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)reqDto.getOrderType()), (String)"\u8bf7\u6c42\u53c2\u6570orderType\u4e0d\u80fd\u4e3a\u7a7a");
        List dgPerformOrderInfoEos = this.dgPerformOrderInfoDomain.queryEoByPlatformOrderNoAndOrderType(reqDto.getPlatformOrderNo(), reqDto.getOrderType());
        DgOrderExistRespDto respDto = new DgOrderExistRespDto();
        respDto.setOrderExist(Boolean.valueOf(false));
        respDto.setAbolishExist(Boolean.valueOf(false));
        if (CollectionUtils.isNotEmpty((Collection)dgPerformOrderInfoEos)) {
            respDto.setOrderExist(Boolean.valueOf(true));
            List abolishOrders = dgPerformOrderInfoEos.stream().filter(e -> e.getOrderStatus().equals(DgSaleOrderStatusEnum.OBSOLETE.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(abolishOrders)) {
                respDto.setAbolishExist(Boolean.valueOf(true));
            }
        }
        return respDto;
    }

    @Override
    public List<SaleOrderAuditDto> queryOrderAuditByOrderNos(List<String> saleOrderNos) {
        if (CollectionUtils.isEmpty(saleOrderNos)) {
            return Lists.newArrayList();
        }
        List list = this.dgPerformOrderInfoDomain.queryOrderAuditByOrderNos(saleOrderNos);
        ArrayList result = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)result, (Collection)list, SaleOrderAuditDto.class);
        return result;
    }

    @Override
    public List<DgPerformOrderRespDto> queryOrderByDistributionOrderNos(List<String> distributionOrderNos) {
        AssertUtils.isFalse((boolean)CollectionUtil.isEmpty(distributionOrderNos), (String)"\u5206\u9500\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<DgPerformOrderRespDto> result = new ArrayList<DgPerformOrderRespDto>();
        List dgPerformOrderInfoEos = this.dgPerformOrderInfoDomain.queryEoByDistributionOrderNos(distributionOrderNos);
        if (CollectionUtils.isNotEmpty((Collection)dgPerformOrderInfoEos)) {
            CubeBeanUtils.copyCollection(result, (Collection)dgPerformOrderInfoEos, DgPerformOrderRespDto.class);
        }
        return result;
    }

    @Override
    public Boolean isDeliveredByPlatformOrderNo(String platformOrderNo) {
        List list = this.dgPerformOrderInfoDomain.queryEoByPlatformOrderNo(platformOrderNo);
        HashSet deliveredStatus = Sets.newHashSet((Object[])new String[]{DgSaleOrderStatusEnum.DELIVERED.getCode(), DgSaleOrderStatusEnum.DELIVERY_ALL.getCode(), DgSaleOrderStatusEnum.COMPLETE.getCode()});
        return Optional.ofNullable(list).orElse(Collections.emptyList()).stream().anyMatch(e -> StringUtils.isNotBlank((CharSequence)e.getOrderStatus()) && deliveredStatus.contains(e.getOrderStatus()));
    }

    private static /* synthetic */ void lambda$queryOrderStatus$3(DgPerformOrderInfoDto orderDasOne, Map orderStatusHistoryListMap, DgOrderStatusLogRespDto status) {
        if (status.getOrderStatusCode().equals(orderDasOne.getOrderStatus())) {
            List steps = orderStatusHistoryListMap.getOrDefault(status.getOrderStatusCode(), new ArrayList());
            status.setActive(Boolean.TRUE);
            status.setOptDate(CollectionUtils.isNotEmpty((Collection)steps) ? ((DgOrderStatusLogRespDto)steps.get(0)).getOptDate() : null);
        }
    }

    private static /* synthetic */ void lambda$queryOrderStatus$2(DgPerformOrderInfoDto orderDasOne, Map orderStatusMap, DgOrderStatusLogRespDto item) {
        SaleOrderStatusFlowTemplate saleOrderStatus;
        if (Objects.equals(orderDasOne.getOrderStatus(), item.getOrderStatus())) {
            item.setActive(Boolean.TRUE);
        }
        if ((saleOrderStatus = (SaleOrderStatusFlowTemplate)orderStatusMap.get(item.getOrderStatus())) != null) {
            item.setOrderStatus(saleOrderStatus.getDesc());
            item.setOrderStatusCode(saleOrderStatus.getCode());
        }
    }
}

