/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.common.Impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountScopeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderItemAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderActivityDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderItemAmountDto;
import com.yunxi.dg.base.center.trade.eo.DgOrderAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgOrderItemAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemEo;
import com.yunxi.dg.base.center.trade.service.oms.common.IDgF2BRepairDataService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgF2BRepairDataServiceImpl
implements IDgF2BRepairDataService {
    private static final Logger log = LoggerFactory.getLogger(DgF2BRepairDataServiceImpl.class);
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgPerformOrderItemDomain dgPerformOrderItemDomain;
    @Resource
    private IOrderActivityDomain orderActivityDomain;
    @Resource
    private IDgOrderAmountDomain dgOrderAmountDomain;
    @Resource
    private IDgOrderItemAmountDomain dgOrderItemAmountDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<String> repairKneadPriceData(List<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            log.info("\u5355\u53f7\u4e3a\u7a7a\uff0c\u7ed3\u675f\u63c9\u4ef7\u6570\u636e\u4fee\u590d");
            return RestResponse.SUCCEED;
        }
        List dgPerformOrderInfoEos = ((ExtQueryChainWrapper)this.dgPerformOrderInfoDomain.filter().in((Object)"sale_order_no", orderNos)).list();
        List orderIds = dgPerformOrderInfoEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List orderItemEos = ((ExtQueryChainWrapper)this.dgPerformOrderItemDomain.filter().in((Object)"order_id", orderIds)).list();
        Map<Long, List<DgPerformOrderItemEo>> orderItemGroup = orderItemEos.stream().collect(Collectors.groupingBy(DgPerformOrderItemEo::getOrderId));
        AtomicLong activityIdAtom = new AtomicLong(0L);
        for (DgPerformOrderInfoEo dgPerformOrderInfoEo : dgPerformOrderInfoEos) {
            List<DgPerformOrderItemEo> dgPerformOrderItemEos = orderItemGroup.get(dgPerformOrderInfoEo.getId());
            Map group = dgPerformOrderItemEos.stream().collect(Collectors.groupingBy(DgPerformOrderItemEo::getGift, Collectors.toMap(DgPerformOrderItemEo::getSkuId, Function.identity(), (e1, e2) -> e1)));
            Map giftItemDataMap = group.get(YesNoEnum.YES.getValue());
            Map itemDataMap = group.get(YesNoEnum.NO.getValue());
            if (!CollectionUtil.isNotEmpty(giftItemDataMap)) continue;
            ArrayList dgOrderAmountDtos = Lists.newArrayList();
            for (Map.Entry entry : giftItemDataMap.entrySet()) {
                ArrayList giftItemAmountDtos = Lists.newArrayList();
                long activityId = activityIdAtom.incrementAndGet();
                DgPerformOrderItemEo giftItem = (DgPerformOrderItemEo)entry.getValue();
                BigDecimal itemMarketPrice = giftItem.getItemMarketPrice();
                BigDecimal currGiftAmount = itemMarketPrice.multiply(giftItem.getItemNum());
                DgOrderItemAmountDto itemAmountDto2 = new DgOrderItemAmountDto();
                itemAmountDto2.setOrderId(dgPerformOrderInfoEo.getId());
                itemAmountDto2.setOrderItemId(giftItem.getId());
                itemAmountDto2.setAmountSource(DgOrderAmountSourceEnum.PROMOTION.getCode());
                itemAmountDto2.setSourceRuleId(Long.valueOf(activityId));
                itemAmountDto2.setAmount(currGiftAmount);
                itemAmountDto2.setSourceRuleType(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getType());
                itemAmountDto2.setAmountType(DgOrderAmountTypeEnum.GIFT_ORDER.getCode());
                giftItemAmountDtos.add(itemAmountDto2);
                DgPerformOrderItemEo masterItem = (DgPerformOrderItemEo)itemDataMap.get(Long.valueOf(giftItem.getGiftSkuIds()));
                DgOrderItemAmountDto masterItemAmountDto = new DgOrderItemAmountDto();
                masterItemAmountDto.setOrderId(dgPerformOrderInfoEo.getId());
                masterItemAmountDto.setOrderItemId(masterItem.getId());
                masterItemAmountDto.setAmountSource(DgOrderAmountSourceEnum.PROMOTION.getCode());
                masterItemAmountDto.setSourceRuleId(Long.valueOf(activityId));
                masterItemAmountDto.setSourceRuleType(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getType());
                masterItemAmountDto.setAmountType(DgOrderAmountTypeEnum.GIFT_ORDER.getCode());
                giftItemAmountDtos.add(masterItemAmountDto);
                DgOrderAmountDto giftAmoutDto = new DgOrderAmountDto();
                giftAmoutDto.setOrderId(dgPerformOrderInfoEo.getId());
                giftAmoutDto.setOrderNo(dgPerformOrderInfoEo.getSaleOrderNo());
                giftAmoutDto.setSourceRuleId(Long.valueOf(activityId));
                giftAmoutDto.setSourceRuleType(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getType());
                giftAmoutDto.setScope(DgOrderAmountScopeEnum.ASSIGN.getCode());
                giftAmoutDto.setAmountType(DgOrderAmountTypeEnum.GIFT_ORDER.getCode());
                giftAmoutDto.setAmount(currGiftAmount);
                giftAmoutDto.setItemAmountDtoList((List)giftItemAmountDtos);
                DgOrderItemAmountDto giftDiscountAmount = new DgOrderItemAmountDto();
                giftDiscountAmount.setOrderId(dgPerformOrderInfoEo.getId());
                giftDiscountAmount.setOrderItemId(giftItem.getId());
                giftDiscountAmount.setAmountSource(DgOrderAmountSourceEnum.PROMOTION.getCode());
                giftDiscountAmount.setSourceRuleId(Long.valueOf(activityId));
                giftDiscountAmount.setSourceRuleType(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getType());
                giftDiscountAmount.setAmountType(DgOrderAmountTypeEnum.TOTAL_DISCOUNT_AMOUNT.getCode());
                giftDiscountAmount.setAmount(currGiftAmount);
                DgOrderAmountDto dgOrderAmountDto = new DgOrderAmountDto();
                dgOrderAmountDto.setOrderId(dgPerformOrderInfoEo.getId());
                dgOrderAmountDto.setOrderNo(dgPerformOrderInfoEo.getSaleOrderNo());
                dgOrderAmountDto.setSourceRuleId(Long.valueOf(activityId));
                dgOrderAmountDto.setSourceRuleType(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getType());
                dgOrderAmountDto.setScope(DgOrderAmountScopeEnum.ASSIGN.getCode());
                dgOrderAmountDto.setAmountType(DgOrderAmountTypeEnum.TOTAL_DISCOUNT_AMOUNT.getCode());
                dgOrderAmountDto.setAmount(currGiftAmount);
                dgOrderAmountDto.setItemAmountDtoList((List)Lists.newArrayList((Object[])new DgOrderItemAmountDto[]{giftDiscountAmount}));
                dgOrderAmountDtos.add(giftAmoutDto);
                dgOrderAmountDtos.add(dgOrderAmountDto);
            }
            if (!CollectionUtil.isNotEmpty((Collection)dgOrderAmountDtos)) continue;
            for (DgOrderAmountDto dgOrderAmountDto : dgOrderAmountDtos) {
                DgOrderAmountEo dgOrderAmountEo = new DgOrderAmountEo();
                CubeBeanUtils.copyProperties((Object)dgOrderAmountEo, (Object)dgOrderAmountDto, (String[])new String[0]);
                this.dgOrderAmountDomain.insert((BaseEo)dgOrderAmountEo);
                List orderItemAmountEos = dgOrderAmountDto.getItemAmountDtoList().stream().map(itemAmountDto -> {
                    DgOrderItemAmountEo dgOrderItemAmountEo = new DgOrderItemAmountEo();
                    CubeBeanUtils.copyProperties((Object)dgOrderItemAmountEo, (Object)itemAmountDto, (String[])new String[0]);
                    dgOrderItemAmountEo.setOrderAmountId(dgOrderAmountEo.getId());
                    return dgOrderItemAmountEo;
                }).collect(Collectors.toList());
                this.dgOrderItemAmountDomain.insertBatch(orderItemAmountEos);
            }
        }
        return RestResponse.SUCCEED;
    }
}

