/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.common.Impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicalWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateRespDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderAggDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderComboReqDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderReqDto;
import com.yunxi.dg.base.center.inventory.proxy.order.ITransferOrderApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuDgRespDto;
import com.yunxi.dg.base.center.item.proxy.sku.impl.ItemSkuDgQueryApiProxyImpl;
import com.yunxi.dg.base.center.report.dto.inventory.DgPhysicsWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgPhysicsWarehousePageReqDto;
import com.yunxi.dg.base.center.report.proxy.inventory.IDgPhysicsWarehouseApiProxy;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderWarehouseInfoDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderDeliveryReportDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderExtensionEo;
import com.yunxi.dg.base.center.trade.exception.PcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderService;
import com.yunxi.dg.base.center.trade.service.oms.common.IOrderInventoryHandleService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IOrderInventoryHandleServiceImpl
implements IOrderInventoryHandleService {
    private static final Logger log = LoggerFactory.getLogger(IOrderInventoryHandleServiceImpl.class);
    private static final String MODIFICATE_CODE = "modification";
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgOmsOrderInfoDomain omsOrderInfoDomain;
    @Resource
    private IDgPerformOrderExtensionDomain dgPerformOrderExtensionDomain;
    @Resource
    private ILogicWarehouseApiProxy logicWarehouseApiProxy;
    @Resource
    private ItemSkuDgQueryApiProxyImpl itemSkuDgQueryApiProxy;
    @Resource
    private IDgPhysicsWarehouseApiProxy physicsWarehouseApiProxy;
    @Resource
    private ITransferOrderApiProxy transferOrderApiProxy;
    @Resource
    private IDgOmsOrderService dgOmsOrderService;

    @Override
    public InventoryOperateRespDto preemptLogicInventoryByOrderAppointDeliveryWarehouse(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        Long orderId = respDto.getId();
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        if (StringUtils.isBlank((CharSequence)saleOrderRespDto.getPerformOrderWarehouseInfoDto().getDeliveryLogicalWarehouseCode()) && StringUtils.isBlank((CharSequence)saleOrderRespDto.getPerformOrderWarehouseInfoDto().getLogicalWarehouseCode())) {
            AssertUtils.notBlank((String)"", (String)"\u8ba2\u5355\u5c1a\u672a\u6307\u5b9a\u53d1\u8d27\u903b\u8f91\u4ed3");
        }
        if (StringUtils.isBlank((CharSequence)saleOrderRespDto.getPerformOrderWarehouseInfoDto().getDeliveryLogicalWarehouseCode())) {
            saleOrderRespDto.getPerformOrderWarehouseInfoDto().setDeliveryLogicalWarehouseCode(saleOrderRespDto.getPerformOrderWarehouseInfoDto().getLogicalWarehouseCode());
        }
        LogicalWarehouseRespDto physicsWarehouseByLogic = this.inventoryApiServcie.getPhysicsWarehouseByLogic(saleOrderRespDto.getPerformOrderWarehouseInfoDto().getDeliveryLogicalWarehouseCode());
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(orderId);
        InventoryOperateRespDto inventoryOperateRespDto = this.inventoryApiServcie.omsPreemptLogicInventoryBackResult(saleOrderRespDto, orderLineDtoList);
        log.info("[\u6307\u5b9a\u4ed3\u5e93\u9884\u5360\u5e93\u5b58]\u9884\u5360\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOperateRespDto));
        if (inventoryOperateRespDto.getFailList() == null || inventoryOperateRespDto.getFailList().isEmpty()) {
            log.info("[\u6307\u5b9a\u4ed3\u5e93\u9884\u5360\u5e93\u5b58]\u9884\u5360\u6210\u529f");
            DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
            updateReqDto.setId(orderId);
            updateReqDto.setDeliveryLogicalWarehouseCode(saleOrderRespDto.getLogicalWarehouseCode());
            updateReqDto.setPhysicsWarehouseCode(physicsWarehouseByLogic.getPhysicsWarehouseCode());
            updateReqDto.setPhysicsWarehouseName(physicsWarehouseByLogic.getPhysicsWarehouseName());
            DgPerformOrderWarehouseInfoDto warehouseInfoDto = new DgPerformOrderWarehouseInfoDto();
            warehouseInfoDto.setDeliveryLogicalWarehouseCode(saleOrderRespDto.getLogicalWarehouseCode());
            warehouseInfoDto.setPhysicsWarehouseCode(physicsWarehouseByLogic.getPhysicsWarehouseCode());
            warehouseInfoDto.setPhysicsWarehouseName(physicsWarehouseByLogic.getPhysicsWarehouseName());
            updateReqDto.setPerformOrderWarehouseInfoDto(warehouseInfoDto);
            this.omsOrderInfoDomain.update(updateReqDto);
            this.updateChangeCodeWarehouse(warehouseInfoDto.getDeliveryLogicalWarehouseCode(), respDto);
        }
        return inventoryOperateRespDto;
    }

    private void updateChangeCodeWarehouse(String saleOrderRespDto, DgPerformOrderRespDto saleOrderRespDto1) {
        log.info("\u66f4\u65b0\u662f\u5426\u6539\u7801\u4ed3\u4fe1\u606f={}", (Object)saleOrderRespDto);
        LogicalWarehouseRespDto logicalWarehouseRespDto = (LogicalWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryLogicWarehouseByCode(saleOrderRespDto));
        AssertUtils.notNull((Object)logicalWarehouseRespDto, (String)"\u903b\u8f91\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
        DgPerformOrderExtensionEo dgPerformOrderExtensionEo = new DgPerformOrderExtensionEo();
        dgPerformOrderExtensionEo.setId(saleOrderRespDto1.getPerformOrderExtensionDto().getId());
        dgPerformOrderExtensionEo.setChangeCodeWarehouse(Objects.equals(logicalWarehouseRespDto.getWarehouseProperty(), MODIFICATE_CODE) ? YesNoEnum.YES.getValue() : YesNoEnum.NO.getValue());
        this.dgPerformOrderExtensionDomain.updateSelective((BaseEo)dgPerformOrderExtensionEo);
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void releaseChannelInventory(Long orderId) {
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        Boolean cancelResult = this.inventoryApiServcie.releaseChannelInventory(performOrderRespDto);
        if (!cancelResult.booleanValue()) {
            throw PcpTradeExceptionCode.CHECK_STATUS_ORDER_CANCEL_INVENTORY_CANCEL_FAIL.builderException();
        }
    }

    @Override
    public void doGenerateTransferOrder(List<DgOrderDeliveryReportDto> orderDetails) {
        String inLogicWarehouseCode;
        log.info("DgOrderDeliveryReportDto:{}", (Object)JSONObject.toJSONString(orderDetails));
        Set skuCodes = orderDetails.stream().map(DgOrderDeliveryReportDto::getSkuCode).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toSet());
        HashMap<String, String> skuCode2UnitMap = new HashMap<String, String>();
        List skuSubLists = CollectionUtil.split(skuCodes, (int)500);
        for (List skuCodeList : skuSubLists) {
            skuCode2UnitMap.putAll(((List)com.dtyunxi.icommerce.utils.RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.queryBySkuCode(skuCodeList))).stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, ItemSkuDgRespDto::getUnit, (k1, k2) -> k1)));
        }
        List<String> preOrderNoList = orderDetails.stream().map(DgOrderDeliveryReportDto::getSaleOrderNo).distinct().collect(Collectors.toList());
        Map<String, List<DgOrderDeliveryReportDto>> skuDetailMap = orderDetails.stream().collect(Collectors.groupingBy(DgOrderDeliveryReportDto::getSkuCode));
        BigDecimal totalQuantity = BigDecimal.ZERO;
        ArrayList transferOrderDetailDtos = Lists.newArrayList();
        ArrayList adjustmentOrderDetailDtos = Lists.newArrayList();
        for (Map.Entry<String, List<DgOrderDeliveryReportDto>> skuDetailEntry : skuDetailMap.entrySet()) {
            String skuCode = skuDetailEntry.getKey();
            DgOrderDeliveryReportDto orderLine = skuDetailEntry.getValue().get(0);
            AssertUtils.notNull((Object)orderLine, (String)"\u8ba2\u5355\u884c\u4e0d\u5b58\u5728");
            orderLine.setUnit((String)skuCode2UnitMap.get(orderLine.getSkuCode()));
            this.buildTransferOrderDetail(skuDetailEntry, orderLine, skuCode, transferOrderDetailDtos);
            this.buildAdjustmentOrderDetail(skuDetailEntry, orderLine, adjustmentOrderDetailDtos);
        }
        String outLogicWarehouseCode = orderDetails.get(0).getDeliveryLogicWarehouseCode();
        if (Objects.equals(outLogicWarehouseCode, inLogicWarehouseCode = orderDetails.get(0).getSettlementWarehouseCode())) {
            log.info("\u8c03\u62e8\u51fa\u4e0e\u8c03\u62e8\u5165\u7684\u903b\u8f91\u4ed3\u4e00\u81f4\uff0c\u65e0\u6cd5\u521b\u5efa\u8c03\u62e8\u5355");
            return;
        }
        LogicalWarehouseRespDto outLogicWarehouseRespDto = (LogicalWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryLogicWarehouseByCode(outLogicWarehouseCode));
        AssertUtils.notNull((Object)outLogicWarehouseRespDto, (String)String.format("\u8c03\u62e8\u5355\u6307\u5b9a\u8c03\u51fa%s\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728", outLogicWarehouseCode));
        LogicalWarehouseRespDto inLogicWarehouseRespDto = (LogicalWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryLogicWarehouseByCode(inLogicWarehouseCode));
        AssertUtils.notNull((Object)inLogicWarehouseRespDto, (String)String.format("\u8c03\u62e8\u5355\u6307\u5b9a\u8c03\u5165%s\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728", inLogicWarehouseCode));
        DgPhysicsWarehousePageReqDto physicsWarehouseQueryDto = new DgPhysicsWarehousePageReqDto();
        physicsWarehouseQueryDto.setWarehouseCode(inLogicWarehouseRespDto.getPhysicsWarehouseCode());
        List dgPhysicsWarehouseDtos = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.physicsWarehouseApiProxy.page(physicsWarehouseQueryDto))).getList();
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dgPhysicsWarehouseDtos), (String)"\u7269\u7406\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
        DgPhysicsWarehouseDto dgPhysicsWarehouseDto = dgPhysicsWarehouseDtos.stream().findFirst().orElse(new DgPhysicsWarehouseDto());
        AdjustmentOrderDto adjustmentOrderDto = this.buildAdjustmentOrderReqDto(outLogicWarehouseRespDto, dgPhysicsWarehouseDto, adjustmentOrderDetailDtos);
        TransferOrderComboReqDto trOrderReqDto = this.buildTransferOrderReqDto(totalQuantity, outLogicWarehouseRespDto, inLogicWarehouseRespDto, dgPhysicsWarehouseDto, transferOrderDetailDtos);
        String transferOrderNo = trOrderReqDto.getTransferOrderReqDto().getSettledTransferOrderNo();
        if (StringUtils.isBlank((CharSequence)transferOrderNo)) {
            log.info("\u751f\u6210\u8c03\u62e8\u5355\u53f7\u5931\u8d25\uff01");
            return;
        }
        TransferOrderAggDto transferOrderAggDto = new TransferOrderAggDto();
        transferOrderAggDto.setAdjustmentOrderDto(adjustmentOrderDto);
        transferOrderAggDto.setTransferOrderComboReqDto(trOrderReqDto);
        log.info("\u5e73\u53f0\u5382\u9001\u8ba2\u5355\u5c65\u7ea6\u53d1\u8d27\u5b8c\u6210\u81ea\u52a8\u8c03\u62e8\u5230\u7ed3\u7b97\u4ed3-\u5165\u53c2\uff1a{}, \u5173\u8054\u5355\u53f7\uff1a{}", JSON.toJSON((Object)transferOrderAggDto), (Object)String.join((CharSequence)",", preOrderNoList));
        List transferOrderNos = (List)RestResponseHelper.extractData((RestResponse)this.transferOrderApiProxy.autoGenerateTransferOrder(transferOrderAggDto));
        if (CollectionUtils.isNotEmpty((Collection)transferOrderNos)) {
            log.info("\u6210\u529f\u751f\u6210\u8c03\u62e8\u5355:{}\uff0c\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u4fe1\u606f:{}", (Object)transferOrderNo, preOrderNoList);
            this.dgOmsOrderService.batchUpdateTransferNo(preOrderNoList, transferOrderNo);
        }
    }

    private void buildAdjustmentOrderDetail(Map.Entry<String, List<DgOrderDeliveryReportDto>> skuDetailEntry, DgOrderDeliveryReportDto orderLine, List<AdjustmentOrderDetailDto> adjustmentOrderDetailDtos) {
        AdjustmentOrderDetailDto detailDto = new AdjustmentOrderDetailDto();
        detailDto.setSkuCode(orderLine.getSkuCode());
        detailDto.setSkuName(orderLine.getSkuName());
        detailDto.setChangeType("increase");
        detailDto.setInventoryProperty("qualified");
        detailDto.setUnit(orderLine.getUnit());
        detailDto.setChangeQuantity(skuDetailEntry.getValue().stream().map(DgOrderDeliveryReportDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
        detailDto.setPlatformOrderNo(orderLine.getPlatformOrderNo());
        detailDto.setOrderItemId(orderLine.getOrderItemId());
        detailDto.setInnerOrderNo(orderLine.getSaleOrderNo());
        adjustmentOrderDetailDtos.add(detailDto);
    }

    private void buildTransferOrderDetail(Map.Entry<String, List<DgOrderDeliveryReportDto>> skuDetailEntry, DgOrderDeliveryReportDto orderLine, String skuCode, List<TransferOrderDetailReqDto> detailReqDtos) {
        TransferOrderDetailReqDto detailReqDto = new TransferOrderDetailReqDto();
        detailReqDto.setQuantity(skuDetailEntry.getValue().stream().map(DgOrderDeliveryReportDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
        detailReqDto.setSpecification(orderLine.getSkuDesc());
        detailReqDto.setBasicUnit(orderLine.getUnit());
        detailReqDto.setBasicUnitName(orderLine.getUnit());
        detailReqDto.setSkuName(orderLine.getSkuName());
        detailReqDto.setCargoId(orderLine.getItemId());
        detailReqDto.setUnit(orderLine.getUnit());
        detailReqDto.setSkuCode(skuCode);
        detailReqDto.setPlatformOrderNo(orderLine.getPlatformOrderNo());
        detailReqDto.setInnerOrderNo(orderLine.getSaleOrderNo());
        detailReqDto.setOrderItemId(orderLine.getOrderItemId());
        detailReqDtos.add(detailReqDto);
    }

    private AdjustmentOrderDto buildAdjustmentOrderReqDto(LogicalWarehouseRespDto outLogicWarehouseRespDto, DgPhysicsWarehouseDto dgPhysicsWarehouseDto, List<AdjustmentOrderDetailDto> adjustmentOrderDetailDtos) {
        AdjustmentOrderDto adjumentOrderDto = new AdjustmentOrderDto();
        adjumentOrderDto.setAdjustmentOrderDetailDtos(new ArrayList());
        adjumentOrderDto.setEvent("audit_success");
        adjumentOrderDto.setOrderType("INVENTORY_ADJUSTMENT");
        adjumentOrderDto.setPushSap(Integer.valueOf(0));
        adjumentOrderDto.setPushWms(Integer.valueOf(0));
        adjumentOrderDto.setBusinessType("inventory_adjustment");
        adjumentOrderDto.setBizDate(new Date());
        adjumentOrderDto.setWarehouseCode(outLogicWarehouseRespDto.getWarehouseCode());
        adjumentOrderDto.setWarehouseName(outLogicWarehouseRespDto.getWarehouseName());
        adjumentOrderDto.setOrganizationCode(outLogicWarehouseRespDto.getOrganizationCode());
        adjumentOrderDto.setOrganizationName(outLogicWarehouseRespDto.getOrganizationName());
        adjumentOrderDto.setPhysicsWarehouseCode(dgPhysicsWarehouseDto.getWarehouseCode());
        adjumentOrderDto.setPhysicsWarehouseName(dgPhysicsWarehouseDto.getWarehouseName());
        adjumentOrderDto.setAdjustmentOrderDetailDtos(adjustmentOrderDetailDtos);
        return adjumentOrderDto;
    }

    private TransferOrderComboReqDto buildTransferOrderReqDto(BigDecimal totalQuantity, LogicalWarehouseRespDto outLogicWarehouseRespDto, LogicalWarehouseRespDto inLogicWarehouseRespDto, DgPhysicsWarehouseDto dgPhysicsWarehouseDto, List<TransferOrderDetailReqDto> transferOrderDetailDtos) {
        String transferOrderNo = (String)RestResponseHelper.extractData((RestResponse)this.transferOrderApiProxy.generateTransferOrderNo());
        TransferOrderReqDto transferOrderReqDto = new TransferOrderReqDto();
        transferOrderReqDto.setType("O_TO_O_TRANSFER");
        transferOrderReqDto.setOrderType("transfer_order");
        transferOrderReqDto.setIsVirtual(Integer.valueOf(0));
        transferOrderReqDto.setTotalQuantity(totalQuantity);
        transferOrderReqDto.setSettledTransferOrderNo(transferOrderNo);
        transferOrderReqDto.setOutLogicWarehouseCode(outLogicWarehouseRespDto.getWarehouseCode());
        transferOrderReqDto.setOutLogicWarehouseName(outLogicWarehouseRespDto.getWarehouseName());
        transferOrderReqDto.setOutOrganizationId(outLogicWarehouseRespDto.getOrganizationId());
        transferOrderReqDto.setOutOrganizationCode(outLogicWarehouseRespDto.getOrganizationCode());
        transferOrderReqDto.setOutOrganization(outLogicWarehouseRespDto.getOrganizationName());
        transferOrderReqDto.setInLogicWarehouseCode(inLogicWarehouseRespDto.getWarehouseCode());
        transferOrderReqDto.setInLogicWarehouseName(inLogicWarehouseRespDto.getWarehouseName());
        transferOrderReqDto.setInOrganizationId(inLogicWarehouseRespDto.getOrganizationId());
        transferOrderReqDto.setInOrganizationCode(inLogicWarehouseRespDto.getOrganizationCode());
        transferOrderReqDto.setInOrganization(inLogicWarehouseRespDto.getOrganizationName());
        transferOrderReqDto.setCustomerCode(inLogicWarehouseRespDto.getWarehouseCode());
        transferOrderReqDto.setCustomerName(inLogicWarehouseRespDto.getWarehouseName());
        transferOrderReqDto.setBizDate(new Date());
        transferOrderReqDto.setContact(dgPhysicsWarehouseDto.getContact());
        transferOrderReqDto.setContactPhone(dgPhysicsWarehouseDto.getPhone());
        transferOrderReqDto.setProvince(dgPhysicsWarehouseDto.getProvince());
        transferOrderReqDto.setProvinceCode(dgPhysicsWarehouseDto.getProvinceCode());
        transferOrderReqDto.setCity(dgPhysicsWarehouseDto.getCity());
        transferOrderReqDto.setCityCode(dgPhysicsWarehouseDto.getCityCode());
        transferOrderReqDto.setArea(dgPhysicsWarehouseDto.getDistrict());
        transferOrderReqDto.setAreaCode(dgPhysicsWarehouseDto.getDistrictCode());
        transferOrderReqDto.setAddress(dgPhysicsWarehouseDto.getDetailAddress());
        TransferOrderComboReqDto trOrderReqDto = new TransferOrderComboReqDto();
        trOrderReqDto.setCommitType("AUDIT");
        trOrderReqDto.setTransferOrderReqDto(transferOrderReqDto);
        trOrderReqDto.setDetailList(transferOrderDetailDtos);
        return trOrderReqDto;
    }
}

