/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.common.Impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ScheduleParam;
import com.dtyunxi.yundt.cube.center.trade.api.constants.TradeSchedulerEnum;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.service.oms.common.IScheduleService;
import com.yunxi.dg.base.center.trade.utils.CornUtil;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ScheduleServiceImpl
implements IScheduleService {
    @Resource
    private ITaskApi iTaskApi;
    @Resource
    private ITaskQueryApi iTaskQueryApi;
    @Value(value="${scheduler.client.app_code}")
    private String appCode;

    @Override
    public void addScheduleOrderTask(String tradeNo, Date endTime, Long tenantId, Long instanceId) {
        this.addScheduleTask(tradeNo, null, endTime, "\u4ea4\u6613\u4e2d\u5fc3_\u4e0b\u5355_" + tradeNo, tenantId, instanceId);
    }

    @Override
    public void addPayTask(String orderTradeNum, String payTradeNum, Date endTime, Long tenantId, Long instanceId) {
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setInstanceId(instanceId);
        taskQueryReqDto.setTenantId(tenantId);
        taskQueryReqDto.setTaskName("\u4ea4\u6613\u4e2d\u5fc3_\u53d1\u8d77\u652f\u4ed8_" + orderTradeNum);
        RestResponse restResponse = this.iTaskQueryApi.queryByPage(ObjectHelper.bean2Json((Object)taskQueryReqDto), Integer.valueOf(1), Integer.valueOf(10));
        if ("0".equals(restResponse.getResultCode()) && !((PageInfo)restResponse.getData()).getList().isEmpty()) {
            this.updateTask(((TaskQueryRespDto)((PageInfo)restResponse.getData()).getList().get(0)).getId(), CornUtil.getCron(endTime), tenantId, instanceId);
        } else {
            this.addScheduleTask(orderTradeNum, payTradeNum, endTime, "\u4ea4\u6613\u4e2d\u5fc3_\u53d1\u8d77\u652f\u4ed8_" + orderTradeNum, tenantId, instanceId);
            this.cancelTask("\u4ea4\u6613\u4e2d\u5fc3_\u4e0b\u5355_" + orderTradeNum, tenantId, instanceId);
        }
    }

    @Override
    public void cancelTask(String name, Long tenantId, Long instanceId) {
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setInstanceId(instanceId);
        taskQueryReqDto.setTenantId(tenantId);
        taskQueryReqDto.setTaskName(name);
        RestResponse restResponse = this.iTaskQueryApi.queryByPage(ObjectHelper.bean2Json((Object)taskQueryReqDto), Integer.valueOf(1), Integer.valueOf(10));
        if ("0".equals(restResponse.getResultCode()) && !((PageInfo)restResponse.getData()).getList().isEmpty() && CornUtil.parseDate(((TaskQueryRespDto)((PageInfo)restResponse.getData()).getList().get(0)).getScheduleExpression()).after(new Date())) {
            RequestDto requestDto = new RequestDto();
            requestDto.setInstanceId(instanceId);
            requestDto.setTenantId(tenantId);
            this.iTaskApi.disableById(((TaskQueryRespDto)((PageInfo)restResponse.getData()).getList().get(0)).getId(), ObjectHelper.bean2Json((Object)requestDto));
        }
    }

    private void addScheduleTask(String orderTradeNum, String payTradeNum, Date endTime, String taskName, Long tenantId, Long instanceId) {
        if (orderTradeNum == null || taskName == null) {
            throw new BizException(TradeExceptionCode.MISSING_PARAMETER.getCode(), TradeExceptionCode.MISSING_PARAMETER.getMsg());
        }
        if (endTime == null || endTime.before(new Date())) {
            throw new BizException(TradeExceptionCode.CLOSETIME_ILLEGAL.getCode(), TradeExceptionCode.CLOSETIME_ILLEGAL.getMsg());
        }
        TaskAndBizCreateReqDto taskAndBizCreateReqDto = new TaskAndBizCreateReqDto();
        taskAndBizCreateReqDto.setInstanceId(instanceId);
        taskAndBizCreateReqDto.setTenantId(tenantId);
        taskAndBizCreateReqDto.setTaskName(taskName);
        taskAndBizCreateReqDto.setAppCode(this.appCode);
        taskAndBizCreateReqDto.setBizCode("releaseCouponAndInventory");
        taskAndBizCreateReqDto.setBizName("\u8ba2\u5355\u5b9a\u65f6\u53d6\u6d88");
        taskAndBizCreateReqDto.setShardType("SINGLE");
        taskAndBizCreateReqDto.setTaskBatchId(null);
        ScheduleParam scheduleParam = new ScheduleParam();
        scheduleParam.setOrderTradeNum(orderTradeNum);
        scheduleParam.setPayTradeNum(payTradeNum);
        taskAndBizCreateReqDto.setParams(ObjectHelper.bean2Json((Object)scheduleParam));
        taskAndBizCreateReqDto.setScheduleExpression(CornUtil.getCron(endTime));
        RestResponse restResponse = this.iTaskApi.addWithBiz(taskAndBizCreateReqDto);
        if ("0".equals(restResponse.getResultCode())) {
            RequestDto requestDto = new RequestDto();
            requestDto.setInstanceId(instanceId);
            requestDto.setTenantId(tenantId);
            this.iTaskApi.enableById((Long)restResponse.getData(), ObjectHelper.bean2Json((Object)requestDto));
        }
    }

    private void updateTask(Long taskId, String corn, Long tenantId, Long instanceId) {
        TaskUpdateReqDto taskUpdateReqDto = new TaskUpdateReqDto();
        taskUpdateReqDto.setScheduleExpression(corn);
        taskUpdateReqDto.setInstanceId(instanceId);
        taskUpdateReqDto.setTenantId(tenantId);
        this.iTaskApi.modifyById(taskId, taskUpdateReqDto);
    }

    @Override
    public void addOrderTask(String orderTradeNum, TradeSchedulerEnum tradeSchedulerEnum, Date endTime, Long tenantId, Long instanceId) {
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setInstanceId(instanceId);
        taskQueryReqDto.setTenantId(tenantId);
        taskQueryReqDto.setTaskName(tradeSchedulerEnum.getBizName() + orderTradeNum);
        RestResponse restResponse = this.iTaskQueryApi.queryByPage(ObjectHelper.bean2Json((Object)taskQueryReqDto), Integer.valueOf(1), Integer.valueOf(10));
        if ("0".equals(restResponse.getResultCode()) && !((PageInfo)restResponse.getData()).getList().isEmpty()) {
            this.updateTask(((TaskQueryRespDto)((PageInfo)restResponse.getData()).getList().get(0)).getId(), CornUtil.getCron(endTime), tenantId, instanceId);
        } else {
            this.addScheduleCancelTask(orderTradeNum, tradeSchedulerEnum, endTime, tenantId, instanceId);
        }
    }

    private void addScheduleCancelTask(String orderTradeNum, TradeSchedulerEnum tradeSchedulerEnum, Date endTime, Long tenantId, Long instanceId) {
        if (orderTradeNum == null) {
            return;
        }
        if (endTime == null || endTime.before(new Date())) {
            return;
        }
        TaskAndBizCreateReqDto taskAndBizCreateReqDto = new TaskAndBizCreateReqDto();
        taskAndBizCreateReqDto.setInstanceId(instanceId);
        taskAndBizCreateReqDto.setTenantId(tenantId);
        taskAndBizCreateReqDto.setTaskName(tradeSchedulerEnum.getBizName() + orderTradeNum);
        taskAndBizCreateReqDto.setTaskDesc(tradeSchedulerEnum.getBizName());
        taskAndBizCreateReqDto.setAppCode(this.appCode);
        taskAndBizCreateReqDto.setBizCode(tradeSchedulerEnum.getBizCode());
        taskAndBizCreateReqDto.setBizName(tradeSchedulerEnum.getBizName());
        taskAndBizCreateReqDto.setShardType("SINGLE");
        taskAndBizCreateReqDto.setTaskBatchId(null);
        taskAndBizCreateReqDto.setParams(orderTradeNum);
        taskAndBizCreateReqDto.setScheduleExpression(CornUtil.getCron(endTime));
        RestResponse restResponse = this.iTaskApi.addWithBiz(taskAndBizCreateReqDto);
        if ("0".equals(restResponse.getResultCode())) {
            RequestDto requestDto = new RequestDto();
            requestDto.setInstanceId(instanceId);
            requestDto.setTenantId(tenantId);
            this.iTaskApi.enableById((Long)restResponse.getData(), ObjectHelper.bean2Json((Object)requestDto));
        }
    }
}

