/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.orderConfig.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderChannelDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IResetRedisNoIndexCommon;
import com.yunxi.dg.base.center.trade.dto.orderreq.OrderChannelReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.OrderChannelRespDto;
import com.yunxi.dg.base.center.trade.eo.DgOrderChannelEo;
import com.yunxi.dg.base.center.trade.service.orderConfig.IDgOrderChannelService;
import com.yunxi.dg.base.center.trade.utils.DgNoGreateUtil;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgOrderChannelServiceImpl
implements IDgOrderChannelService,
IResetRedisNoIndexCommon {
    @Resource
    private DgNoGreateUtil dgNoGreateUtil;
    @Resource
    private IDgOrderChannelDomain orderChannelDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addOrderChannel(OrderChannelReqDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto.getChannelName(), (String)"\u8ba2\u5355\u6e20\u9053\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        DgOrderChannelEo dgOrderChannelEo = new DgOrderChannelEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)dgOrderChannelEo);
        dgOrderChannelEo.setChannelCode(this.dgNoGreateUtil.generateChannelNo());
        this.orderChannelDomain.insert((BaseEo)dgOrderChannelEo);
        return dgOrderChannelEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyOrderChannel(OrderChannelReqDto modifyReqDto) {
        DgOrderChannelEo dgOrderChannelEo = new DgOrderChannelEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)dgOrderChannelEo);
        this.orderChannelDomain.updateSelective((BaseEo)dgOrderChannelEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrderChannel(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.orderChannelDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOrderChannelStatus(String ids, Integer status) {
        List idList = Arrays.asList(ids.split(",")).stream().collect(Collectors.toList());
        this.orderChannelDomain.updateOrderChannelStatus(idList.stream().map(Long::valueOf).collect(Collectors.toList()), status);
    }

    @Override
    public OrderChannelRespDto queryById(Long id) {
        DgOrderChannelEo dgOrderChannelEo = (DgOrderChannelEo)this.orderChannelDomain.selectByPrimaryKey(id);
        OrderChannelRespDto orderChannelRespDto = new OrderChannelRespDto();
        DtoHelper.eo2Dto((BaseEo)dgOrderChannelEo, (BaseVo)orderChannelRespDto);
        return orderChannelRespDto;
    }

    @Override
    public PageInfo<OrderChannelRespDto> queryByPage(OrderChannelReqDto orderChannelReqDto, Integer pageNum, Integer pageSize) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        if (orderChannelReqDto.getStatus() != null) {
            queryWrapper.eq(DgOrderChannelEo::getStatus, (Object)orderChannelReqDto.getStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)orderChannelReqDto.getChannelCode())) {
            queryWrapper.like(DgOrderChannelEo::getChannelCode, (Object)("%" + orderChannelReqDto.getChannelCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)orderChannelReqDto.getChannelName())) {
            queryWrapper.like(DgOrderChannelEo::getChannelName, (Object)("%" + orderChannelReqDto.getChannelName() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)orderChannelReqDto.getCreateTimeStart()) && StringUtils.isNotBlank((CharSequence)orderChannelReqDto.getCreateTimeEnd())) {
            ((LambdaQueryWrapper)queryWrapper.ge(BaseEo::getCreateTime, (Object)(orderChannelReqDto.getCreateTimeStart() + " 00:00:00"))).le(BaseEo::getCreateTime, (Object)(orderChannelReqDto.getCreateTimeEnd() + " 23:59:59"));
        }
        queryWrapper.orderByDesc(BaseEo::getUpdateTime);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List dgOrderChannelEos = this.orderChannelDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)dgOrderChannelEos)) {
            return new PageInfo();
        }
        PageInfo info = new PageInfo(dgOrderChannelEos);
        PageInfo dtoPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)dtoPageInfo);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)info, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)info.getList(), dtoList, OrderChannelRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<OrderChannelRespDto> queryByList(OrderChannelReqDto reqDto) {
        DgOrderChannelEo dgOrderChannelEo = new DgOrderChannelEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)dgOrderChannelEo);
        dgOrderChannelEo.setOrderByDesc("create_time");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)reqDto.getChannelCode())) {
            queryWrapper.like(DgOrderChannelEo::getChannelCode, (Object)("%" + reqDto.getChannelCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getChannelName())) {
            queryWrapper.like(DgOrderChannelEo::getChannelName, (Object)("%" + reqDto.getChannelName() + "%"));
        }
        if (reqDto.getStatus() != null) {
            queryWrapper.eq(DgOrderChannelEo::getStatus, (Object)reqDto.getStatus());
        }
        List dgOrderChannelEos = this.orderChannelDomain.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList<OrderChannelRespDto> dtoList = new ArrayList<OrderChannelRespDto>();
        DtoHelper.eoList2DtoList((Collection)dgOrderChannelEos, dtoList, OrderChannelRespDto.class);
        return dtoList;
    }

    public String getLatestNo() {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderWrapper.orderByDesc(BaseEo::getId)).orderByDesc(BaseEo::getCreateTime)).last(" limit 1");
        DgOrderChannelEo dgOrderChannelEo = (DgOrderChannelEo)this.orderChannelDomain.getMapper().selectOne((Wrapper)queryOrderWrapper);
        if (dgOrderChannelEo == null) {
            return "";
        }
        return dgOrderChannelEo.getChannelCode();
    }
}

