/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.orderConfig.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderTypeDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderTypeRelationDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.OrderTypeReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.OrderTypeRespDto;
import com.yunxi.dg.base.center.trade.eo.DgOrderTypeEo;
import com.yunxi.dg.base.center.trade.eo.DgOrderTypeRelationEo;
import com.yunxi.dg.base.center.trade.service.orderConfig.IDgOrderTypeService;
import com.yunxi.dg.base.center.trade.utils.DgNoGreateUtil;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgOrderTypeServiceImpl
implements IDgOrderTypeService {
    @Resource
    private IDgOrderTypeDomain orderTypeDomain;
    @Resource
    private DgNoGreateUtil dgNoGreateUtil;
    @Resource
    private IDgOrderTypeRelationDomain orderTypeRelationDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addOrderType(OrderTypeReqDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto.getTypeName(), (String)"\u8ba2\u5355\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        DgOrderTypeEo dgOrderTypeEo = new DgOrderTypeEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)dgOrderTypeEo);
        dgOrderTypeEo.setTypeCode(this.dgNoGreateUtil.generateOrderTypeNo());
        this.orderTypeDomain.insert((BaseEo)dgOrderTypeEo);
        ArrayList relationEoList = Lists.newArrayList();
        addReqDto.getOrderChannelCodeList().forEach(orderChannelCode -> {
            DgOrderTypeRelationEo relationEo = new DgOrderTypeRelationEo();
            relationEo.setOrderTypeId(dgOrderTypeEo.getId());
            relationEo.setOrderChannelCode(orderChannelCode);
            relationEoList.add(relationEo);
        });
        if (CollectionUtils.isNotEmpty((Collection)relationEoList)) {
            this.orderTypeRelationDomain.insertBatch((List)relationEoList);
        }
        return dgOrderTypeEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyOrderType(OrderTypeReqDto modifyReqDto) {
        DgOrderTypeEo dgOrderTypeEo = new DgOrderTypeEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)dgOrderTypeEo);
        this.orderTypeDomain.updateSelective((BaseEo)dgOrderTypeEo);
        DgOrderTypeRelationEo deleteRelationEo = new DgOrderTypeRelationEo();
        deleteRelationEo.setOrderTypeId(modifyReqDto.getId());
        this.orderTypeRelationDomain.delete((BaseEo)deleteRelationEo);
        ArrayList relationEoList = Lists.newArrayList();
        modifyReqDto.getOrderChannelCodeList().forEach(orderChannelCode -> {
            DgOrderTypeRelationEo relationEo = new DgOrderTypeRelationEo();
            relationEo.setOrderTypeId(dgOrderTypeEo.getId());
            relationEo.setOrderChannelCode(orderChannelCode);
            relationEoList.add(relationEo);
        });
        if (CollectionUtils.isNotEmpty((Collection)relationEoList)) {
            this.orderTypeRelationDomain.insertBatch((List)relationEoList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrderType(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.orderTypeDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOrderTypeStatus(String ids, Integer status) {
        List idList = Arrays.asList(ids.split(",")).stream().collect(Collectors.toList());
        this.orderTypeDomain.updateOrderTypeStatus(idList.stream().map(Long::valueOf).collect(Collectors.toList()), status);
    }

    @Override
    public OrderTypeRespDto queryById(Long id) {
        OrderTypeReqDto reqDto = new OrderTypeReqDto();
        reqDto.setId(id);
        List list = this.orderTypeDomain.queryList(reqDto);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (OrderTypeRespDto)list.get(0);
    }

    @Override
    public PageInfo<OrderTypeRespDto> queryByPage(OrderTypeReqDto reqDto, Integer pageNum, Integer pageSize) {
        return this.orderTypeDomain.queryPage(reqDto, pageNum, pageSize);
    }

    @Override
    public List<OrderTypeRespDto> queryByList(OrderTypeReqDto reqDto) {
        return this.orderTypeDomain.queryList(reqDto);
    }
}

