/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.orderStrategy.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.action.oms.B2C.IDgMqMessageAction;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.config.DgPerformOrderGlobalConfig;
import com.yunxi.dg.base.center.trade.constants.strategy.CisStrategyFitStatusEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisSaleOrderPushTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.dto.entity.DgStrategyPoolReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgMatchStrategyResultDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyPoolRespDto;
import com.yunxi.dg.base.center.trade.service.oms.common.ICommonOrderQueryService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgAutoAuditOrderService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgBusinessStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgCustomerStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgOrderAutoStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgStrategyOrderService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgStrategyPickRuleService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgStrategyPickedRuleService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgStrategyPoolService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.impl.DgStrategyRuleServiceImpl;
import com.yunxi.dg.base.center.trade.threads.MultiTaskHandleHelper;
import com.yunxi.dg.base.center.trade.utils.StrategyHelper;
import com.yunxi.dg.base.center.trade.vo.SaleTradeMessageVo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service
public class DgAutoAuditOrderServiceImpl
implements IDgAutoAuditOrderService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgAutoAuditOrderServiceImpl.class);
    private static final Integer SINGLE_QUERY_LIMIT = 2000;
    @Resource
    private IDgStrategyOrderService strategyOrderService;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IDgStrategyPoolService strategyPoolService;
    @Resource
    private IDgCustomerStrategyRuleService customerStrategyRuleService;
    @Resource
    private IDgBusinessStrategyRuleService businessStrategyRuleService;
    @Resource
    private IDgOrderAutoStrategyRuleService dgOrderAutoStrategyRuleService;
    @Resource
    private DgPerformOrderGlobalConfig saleGlobalConfig;
    @Resource
    private IDgMqMessageAction mqMessageAction;
    @Resource
    private ICommonOrderQueryService commonOrderQueryService;
    @Resource
    private IDgStrategyPickRuleService strategyPickRuleService;
    @Resource
    private IDgStrategyPickedRuleService strategyPickedRuleService;

    @Override
    @DgRedisLock(lockName="LOCK_SCHEDULED_TABLE", key="AutoAuditOrderServiceImpl-handleAutoAuditTask")
    public void handleAutoAuditTask() {
        MultiTaskHandleHelper.handleTask("\u81ea\u52a8\u5ba2\u5ba1\u3001\u5546\u5ba1\u4efb\u52a1", SINGLE_QUERY_LIMIT, (pageNo, pageSize) -> this.strategyOrderService.queryPerformOrdersPageForPlan(pageNo, pageSize), this::sendDelayMessageForHandle);
    }

    private void sendDelayMessageForHandle(List<DgStrategyOrderRespDto> strategyOrderList) {
        if (CollectionUtils.isNotEmpty(strategyOrderList)) {
            strategyOrderList.parallelStream().forEach(strategyOrderRespDto -> {
                MessageVo messageVo = new MessageVo();
                SaleTradeMessageVo saleTradeMessageVo = new SaleTradeMessageVo();
                saleTradeMessageVo.setOrderId(strategyOrderRespDto.getSaleOrderId());
                saleTradeMessageVo.setRuleId(strategyOrderRespDto.getRuleId());
                saleTradeMessageVo.setStrategyOrderId(strategyOrderRespDto.getId());
                saleTradeMessageVo.setNextOptType(StrategyHelper.chooseNextOptTypeByStrategyType(DgCisStrategyOrderTypeEnum.forCode((String)strategyOrderRespDto.getType())));
                AssertUtils.notBlank((String)saleTradeMessageVo.getNextOptType(), (String)"nextOptType \u4e0d\u80fd\u4e3a\u7a7a");
                messageVo.setData((Object)saleTradeMessageVo);
                long delayTimeSeconds = strategyOrderRespDto.getPlanExeTime().getTime() / 1000L - new Date().getTime() / 1000L;
                long delaySeconds = Math.max(delayTimeSeconds, 0L);
                LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u89c4\u5219orderNo={}\u53d1\u9001mq\u6d88\u606f\uff1a{}\uff0c\u5ef6\u8fdf\uff1a{}s", new Object[]{strategyOrderRespDto.getSaleOrderNo(), JSON.toJSONString((Object)messageVo), delaySeconds});
                MessageResponse messageResponse = this.commonsMqService.sendDelaySingleMessage("TRADE_DELAY_TOPIC", "DELAY_AUTO_AUDIT_TAG", (Object)messageVo, Long.valueOf(delaySeconds));
                LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u89c4\u5219orderNo={}\u53d1\u9001mq\u7ed3\u679c\uff1a{}", (Object)strategyOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)messageResponse));
            });
        }
    }

    @Override
    @DgRedisLock(lockName="LOCK_SCHEDULED_TABLE", key="AutoAuditOrderServiceImpl-scanCustomerAutoAuditTask")
    public void scanCustomerAutoAuditTask() {
        MultiTaskHandleHelper.handleTask("\u626b\u63cf\u5ba2\u5ba1\u7f13\u51b2\u6c60\u4efb\u52a1", SINGLE_QUERY_LIMIT, (pageNo, pageSize) -> this.strategyPoolService.queryPayge(pageNo, pageSize, DgCisStrategyOrderTypeEnum.CUSTOMER.getCode()), this::handleCustomerAutoAuditTask);
    }

    private void handleCustomerAutoAuditTask(List<DgStrategyPoolRespDto> poolRespDtoPageInfoList) {
        if (CollectionUtils.isNotEmpty(poolRespDtoPageInfoList)) {
            ArrayList removePoolList = Lists.newArrayList();
            for (DgStrategyPoolRespDto strategyPoolRespDto : poolRespDtoPageInfoList) {
                try {
                    String requestId = RequestId.createReqId();
                    MDC.put((String)"yes.req.requestId", (String)requestId);
                    ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
                    DgStrategyRuleServiceImpl.MatchStrategyResult matchStrategyResult = this.customerStrategyRuleService.matchOrderStrtegyOfCustomer(strategyPoolRespDto.getSaleOrderId());
                    if (matchStrategyResult.getMatchStrategy().booleanValue()) {
                        DgStrategyPoolReqDto strategyPoolReqDto = new DgStrategyPoolReqDto();
                        strategyPoolReqDto.setId(strategyPoolRespDto.getId());
                        strategyPoolReqDto.setFitStatus(CisStrategyFitStatusEnum.FITED.getCode());
                        this.strategyPoolService.modifyStrategyPool(strategyPoolReqDto);
                        if (!matchStrategyResult.getIntercepted().booleanValue()) continue;
                        removePoolList.add(strategyPoolRespDto.getId());
                        DgPerformOrderRespDto saleOrderRespDto = this.commonOrderQueryService.querySaleOrderById(strategyPoolRespDto.getSaleOrderId());
                        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u5ba2\u5ba1\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u53d1\u9001mq\u63a8\u9001\u7ed9\u7528\u670d\u7cfb\u7edf\uff0c\u8ba2\u5355\u53f7\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo());
                        this.mqMessageAction.sendMsgSaleOrderPush(saleOrderRespDto, DgCisSaleOrderPushTypeEnum.CS_AUDIT_PUSH);
                        continue;
                    }
                    removePoolList.add(strategyPoolRespDto.getId());
                    DgPerformOrderRespDto saleOrderRespDto = this.commonOrderQueryService.querySaleOrderById(strategyPoolRespDto.getSaleOrderId());
                    LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u5ba2\u5ba1\u6ca1\u6709\u5339\u914d\u4e0a\u7b56\u7565\uff0c\u53d1\u9001mq\u63a8\u9001\u7ed9\u7528\u670d\u7cfb\u7edf\uff0c\u8ba2\u5355\u53f7\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo());
                    this.mqMessageAction.sendMsgSaleOrderPush(saleOrderRespDto, DgCisSaleOrderPushTypeEnum.CS_AUDIT_PUSH);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)removePoolList)) {
                this.strategyPoolService.removeStrategyPool(removePoolList);
            }
        }
    }

    @Override
    @DgRedisLock(lockName="LOCK_SCHEDULED_TABLE", key="AutoAuditOrderServiceImpl-scanBusinessAutoAuditTask")
    public void scanBusinessAutoAuditTask() {
        MultiTaskHandleHelper.handleTask("\u626b\u63cf\u5546\u5ba1\u7f13\u51b2\u6c60\u4efb\u52a1", SINGLE_QUERY_LIMIT, (pageNo, pageSize) -> this.strategyPoolService.queryPayge(pageNo, pageSize, DgCisStrategyOrderTypeEnum.BUSINESS.getCode()), this::handleBusinessAutoAuditTask);
    }

    private void handleBusinessAutoAuditTask(List<DgStrategyPoolRespDto> poolRespDtoPageInfoList) {
        if (CollectionUtils.isNotEmpty(poolRespDtoPageInfoList)) {
            ArrayList removePoolList = Lists.newArrayList();
            for (DgStrategyPoolRespDto strategyPoolRespDto : poolRespDtoPageInfoList) {
                try {
                    String requestId = RequestId.createReqId();
                    MDC.put((String)"yes.req.requestId", (String)requestId);
                    ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
                    DgStrategyRuleServiceImpl.MatchStrategyResult matchStrategyResult = this.businessStrategyRuleService.matchOrderStrtegyOfBusiness(strategyPoolRespDto.getSaleOrderId());
                    if (!matchStrategyResult.getMatchStrategy().booleanValue()) continue;
                    DgStrategyPoolReqDto strategyPoolReqDto = new DgStrategyPoolReqDto();
                    strategyPoolReqDto.setId(strategyPoolRespDto.getId());
                    strategyPoolReqDto.setFitStatus(CisStrategyFitStatusEnum.FITED.getCode());
                    this.strategyPoolService.modifyStrategyPool(strategyPoolReqDto);
                    removePoolList.add(strategyPoolRespDto.getId());
                    if (matchStrategyResult.getIntercepted().booleanValue()) continue;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)removePoolList)) {
                this.strategyPoolService.removeStrategyPool(removePoolList);
            }
        }
    }

    @Override
    @DgRedisLock(lockName="LOCK_SCHEDULED_TABLE", key="AutoAuditOrderServiceImpl-scanPickAutoAuditTask")
    public void scanPickAutoAuditTask() {
        MultiTaskHandleHelper.handleTask("\u626b\u63cf\u81ea\u52a8\u914d\u8d27\u7f13\u51b2\u6c60\u4efb\u52a1", SINGLE_QUERY_LIMIT, (pageNo, pageSize) -> this.strategyPoolService.queryPayge(pageNo, pageSize, DgCisStrategyOrderTypeEnum.PICK.getCode()), this::handlePickAutoAuditTask);
    }

    private void handlePickAutoAuditTask(List<DgStrategyPoolRespDto> poolRespDtoPageInfoList) {
        if (CollectionUtils.isNotEmpty(poolRespDtoPageInfoList)) {
            this.strategyPickRuleService.autoStrategyPick(poolRespDtoPageInfoList);
        }
    }

    @Override
    @DgRedisLock(lockName="LOCK_SCHEDULED_TABLE", key="AutoAuditOrderServiceImpl-scanPickedAutoAuditTask")
    public void scanPickedAutoAuditTask() {
        MultiTaskHandleHelper.handleTask("\u626b\u63cf\u81ea\u52a8\u4e0b\u53d1\u7f13\u51b2\u6c60\u4efb\u52a1", SINGLE_QUERY_LIMIT, (pageNo, pageSize) -> this.strategyPoolService.queryPayge(pageNo, pageSize, DgCisStrategyOrderTypeEnum.PICKED.getCode()), this::handlePickedAutoAuditTask);
    }

    private void handlePickedAutoAuditTask(List<DgStrategyPoolRespDto> poolRespDtoPageInfoList) {
        if (CollectionUtils.isNotEmpty(poolRespDtoPageInfoList)) {
            this.strategyPickedRuleService.autoStrategyPicked(poolRespDtoPageInfoList);
        }
    }

    @Override
    @DgRedisLock(lockName="LOCK_SCHEDULED_TABLE", key="AutoAuditOrderServiceImpl-scanOrderHitPoolTask")
    public void scanOrderHitPoolTask(DgCisStrategyOrderTypeEnum dgCisStrategyOrderTypeEnum) {
        MultiTaskHandleHelper.handleTask("\u626b\u63cf" + dgCisStrategyOrderTypeEnum.getDesc() + "\u7f13\u51b2\u6c60\u4efb\u52a1", SINGLE_QUERY_LIMIT, (pageNo, pageSize) -> this.strategyPoolService.queryPayge(pageNo, pageSize, dgCisStrategyOrderTypeEnum.getCode()), list -> this.handleOrderAutoMatchTask((List<DgStrategyPoolRespDto>)list, dgCisStrategyOrderTypeEnum));
    }

    private void handleOrderAutoMatchTask(List<DgStrategyPoolRespDto> poolRespDtoPageInfoList, DgCisStrategyOrderTypeEnum dgCisStrategyOrderTypeEnum) {
        if (CollectionUtils.isNotEmpty(poolRespDtoPageInfoList)) {
            ArrayList removePoolList = Lists.newArrayList();
            for (DgStrategyPoolRespDto strategyPoolRespDto : poolRespDtoPageInfoList) {
                try {
                    String requestId = RequestId.createReqId();
                    MDC.put((String)"yes.req.requestId", (String)requestId);
                    ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
                    DgMatchStrategyResultDto matchStrategyResult = this.dgOrderAutoStrategyRuleService.matchOrderStrategy(strategyPoolRespDto.getSaleOrderId(), dgCisStrategyOrderTypeEnum);
                    if (!matchStrategyResult.getMatchStrategy().booleanValue()) continue;
                    DgStrategyPoolReqDto strategyPoolReqDto = new DgStrategyPoolReqDto();
                    strategyPoolReqDto.setId(strategyPoolRespDto.getId());
                    strategyPoolReqDto.setFitStatus(CisStrategyFitStatusEnum.FITED.getCode());
                    this.strategyPoolService.modifyStrategyPool(strategyPoolReqDto);
                    removePoolList.add(strategyPoolRespDto.getId());
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)removePoolList)) {
                this.strategyPoolService.removeStrategyPool(removePoolList);
            }
        }
    }

    @Override
    @DgRedisLock(lockName="LOCK_SCHEDULED_TABLE", key="AutoAuditOrderServiceImpl-cleanStrategyPool")
    public void cleanStrategyPool() {
        this.strategyPoolService.cleanStrategyPool(Integer.parseInt(this.saleGlobalConfig.getStrategyPoolClean()));
    }
}

