/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.orderStrategy.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.MD5Util;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerSearchListReqDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCustomerQueryApiProxy;
import com.yunxi.dg.base.center.trade.constants.strategy.CisStrategyContentTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyConfItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyRuleSuitTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfItemSuitDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleSuitDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IResetRedisNoIndexCommon;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgAccountPayScaleDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgCustomerAuditStrategyRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgCustomerAuditStrategyRuleRespDto;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleEo;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleSuitEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemSuitEo;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgCustomerStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.impl.DgStrategyRuleServiceImpl;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateInUtil;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgCustomerDgStrategyRuleServiceImpl
extends DgStrategyRuleServiceImpl
implements IDgCustomerStrategyRuleService,
IResetRedisNoIndexCommon {
    private static final Logger log = LoggerFactory.getLogger(DgCustomerDgStrategyRuleServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(DgCustomerDgStrategyRuleServiceImpl.class);
    @Resource
    private NoGreateInUtil noGreateInUtil;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgStrategyRuleDomain strategyRuleDas;
    @Resource
    private IDgStrategyRuleSuitDomain strategyRuleSuitDas;
    @Resource
    private IDgStrategyConfItemSuitDomain strategyConfItemSuitDas;
    @Resource
    private IDgCustomerQueryApiProxy dgCustomerQueryApiProxy;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addCustomerAuditStrategyRule(DgCustomerAuditStrategyRuleReqDto addReqDto) {
        if (Objects.nonNull(addReqDto.getId())) {
            this.modifyCustomerAuditStrategyRule(addReqDto);
            return addReqDto.getId();
        }
        if (!DgCisStrategyOrderTypeEnum.noPeriodicTimeCodes.contains(addReqDto.getStrategyType()) && (Objects.isNull(addReqDto.getPeriodicEnd()) || Objects.isNull(addReqDto.getPeriodicStart())) && addReqDto.getPlatForm().equals("2b")) {
            throw new BizException("\u5468\u671f\u5f00\u59cb\u65f6\u95f4\u548c\u5468\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DgStrategyRuleEo dgStrategyRuleEo = new DgStrategyRuleEo();
        CubeBeanUtils.copyProperties((Object)dgStrategyRuleEo, (Object)addReqDto, (String[])new String[0]);
        switch ((DgCisStrategyOrderTypeEnum)DgCisStrategyOrderTypeEnum.CODE_LOOKUP.get(addReqDto.getStrategyType())) {
            case CUSTOMER: {
                dgStrategyRuleEo.setRuleCode(this.noGreateInUtil.generateCustomerRuleNo());
                break;
            }
            case AUTOMATIC_ALLOCATION: {
                dgStrategyRuleEo.setRuleCode(this.noGreateInUtil.generateAutoMaticAllocationRuleNo());
                break;
            }
            case AUTOMATIC_DELIVERY: {
                dgStrategyRuleEo.setRuleCode(this.noGreateInUtil.generateAutoDeliveryRuleNo());
                break;
            }
            case ORDER_REVIEW: {
                dgStrategyRuleEo.setRuleCode(this.noGreateInUtil.generateAutoAuditRuleNo());
                break;
            }
            case ORDER_CONFIRM: {
                dgStrategyRuleEo.setRuleCode(this.noGreateInUtil.generateOrderConfirmRuleNo());
                break;
            }
            case SALES: {
                dgStrategyRuleEo.setRuleCode(this.noGreateInUtil.generateF2bAutoAuditRuleNo("ZDXSS"));
                break;
            }
            case PRODUCTION: {
                dgStrategyRuleEo.setRuleCode(this.noGreateInUtil.generateF2bAutoAuditRuleNo("ZDCXS"));
                break;
            }
            case DEFAULT_ACCOUNT_PAY: {
                dgStrategyRuleEo.setRuleCode(this.noGreateInUtil.generateF2bAutoAuditRuleNo("MRZH"));
                break;
            }
            case SPECIAL_CUSTOMER_ACCOUNT_PAY: {
                dgStrategyRuleEo.setRuleCode(this.noGreateInUtil.generateF2bAutoAuditRuleNo("TSKHZH"));
                break;
            }
            case AUTOMATIC_ORDER_SPLIT: {
                dgStrategyRuleEo.setRuleCode(this.noGreateInUtil.generateF2bAutoAuditRuleNo("ZDZPCD"));
                break;
            }
            case ORDER_INSTALL_STRATEGY: {
                dgStrategyRuleEo.setRuleCode(this.noGreateInUtil.generateF2bAutoAuditRuleNo("OIS"));
                break;
            }
            default: {
                throw new BizException("\u7b56\u7565\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u7a7a");
            }
        }
        if (Objects.isNull(dgStrategyRuleEo.getPriority())) {
            dgStrategyRuleEo.setPriority(Integer.valueOf(1));
        }
        dgStrategyRuleEo.setStrategyType(addReqDto.getStrategyType());
        this.strategyRuleDas.insert((BaseEo)dgStrategyRuleEo);
        this.popStrategyConfItems(addReqDto, dgStrategyRuleEo);
        ArrayList dgStrategyRuleSuitEoList = Lists.newArrayList();
        this.popStrategyRuleSuits(addReqDto, dgStrategyRuleEo, dgStrategyRuleSuitEoList);
        this.strategyRuleSuitDas.insertBatch((List)dgStrategyRuleSuitEoList);
        return dgStrategyRuleEo.getId();
    }

    private void popStrategyRuleSuits(DgCustomerAuditStrategyRuleReqDto addReqDto, DgStrategyRuleEo dgStrategyRuleEo, List<DgStrategyRuleSuitEo> dgStrategyRuleSuitEoList) {
        if (addReqDto.getPlatForm().equals("2c")) {
            DgCustomerAuditStrategyRuleReqDto.ApplyOrderType applyOrderType;
            DgCustomerAuditStrategyRuleReqDto.ApplyShop applyShop = addReqDto.getApplyShop();
            if (Objects.nonNull(applyShop)) {
                DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)applyShop, DgStrategyRuleSuitTypeEnum.SUITTYPE_SHOP.getCode(), addReqDto);
            }
            if (Objects.nonNull(applyOrderType = addReqDto.getApplyOrderType())) {
                DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)applyOrderType, DgStrategyRuleSuitTypeEnum.SUITTYPE_ORDER_TYPE.getCode(), addReqDto);
            }
        } else {
            DgCustomerAuditStrategyRuleReqDto.ApplyClient clientBlack;
            DgCustomerAuditStrategyRuleReqDto.ApplyClient clientGroup;
            DgCustomerAuditStrategyRuleReqDto.ApplyClient clientGrade;
            DgCustomerAuditStrategyRuleReqDto.ApplyClient clientType;
            DgCustomerAuditStrategyRuleReqDto.ApplyClient businessArea;
            DgCustomerAuditStrategyRuleReqDto.ApplyOrderLabel applyOrderLabel;
            DgCustomerAuditStrategyRuleReqDto.ApplyOrg applyOrg;
            DgCustomerAuditStrategyRuleReqDto.ApplyChannelWarehouse applyChannelWarehouse;
            DgCustomerAuditStrategyRuleReqDto.ApplyClient applyClient;
            DgCustomerAuditStrategyRuleReqDto.ApplyChannel applyChannel;
            DgCustomerAuditStrategyRuleReqDto.ApplyCompany applyCompany;
            DgCustomerAuditStrategyRuleReqDto.ApplyShop applyShop;
            DgCustomerAuditStrategyRuleReqDto.ApplyOrderType applyOrderType = addReqDto.getApplyOrderType();
            if (Objects.nonNull(applyOrderType)) {
                DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)applyOrderType, DgStrategyRuleSuitTypeEnum.SUITTYPE_ORDER_TYPE.getCode(), addReqDto);
            }
            if (Objects.nonNull(applyShop = addReqDto.getApplyShop())) {
                DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)applyShop, DgStrategyRuleSuitTypeEnum.SUITTYPE_SHOP.getCode(), addReqDto);
            }
            if (Objects.nonNull(applyCompany = addReqDto.getApplyCompany())) {
                DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)applyCompany, DgStrategyRuleSuitTypeEnum.SUITTYPE_COMPANY.getCode(), addReqDto);
            }
            if (Objects.nonNull(applyChannel = addReqDto.getApplyChannel())) {
                DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)applyChannel, DgStrategyRuleSuitTypeEnum.SUITTYPE_CHANNEL.getCode(), addReqDto);
            }
            if (Objects.nonNull(applyClient = addReqDto.getApplyClient())) {
                DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)applyClient, DgStrategyRuleSuitTypeEnum.SUITTYPE_CLEINT.getCode(), addReqDto);
            }
            if (Objects.nonNull(applyChannelWarehouse = addReqDto.getApplyChannelWarehouse())) {
                DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)applyChannelWarehouse, DgStrategyRuleSuitTypeEnum.SUITTYPE_CHANNEL_WAREHOUSE.getCode(), addReqDto);
            }
            if (Objects.nonNull(applyOrg = addReqDto.getApplyOrg())) {
                DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)applyOrg, DgStrategyRuleSuitTypeEnum.SUITTYPE_ORG.getCode(), addReqDto);
            }
            if (Objects.nonNull(applyOrderLabel = addReqDto.getApplyOrderLabel())) {
                DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)applyOrderLabel, DgStrategyRuleSuitTypeEnum.SUITTYPE_ORDER_LABEL.getCode(), addReqDto);
            }
            if (Objects.nonNull(businessArea = addReqDto.getApplyBusinessArea())) {
                DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)businessArea, DgStrategyRuleSuitTypeEnum.SUITTYPE_BUSINESS_AREA.getCode(), addReqDto);
            }
            if (Objects.nonNull(clientType = addReqDto.getApplyClientType())) {
                DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)clientType, DgStrategyRuleSuitTypeEnum.SUITTYPE_CLIENT_TYPE.getCode(), addReqDto);
            }
            if (Objects.nonNull(clientGrade = addReqDto.getApplyClientGrade())) {
                DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)clientGrade, DgStrategyRuleSuitTypeEnum.SUITTYPE_CLIENT_GRADE.getCode(), addReqDto);
            }
            if (Objects.nonNull(clientGroup = addReqDto.getApplyClientGroup())) {
                DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)clientGroup, DgStrategyRuleSuitTypeEnum.SUITTYPE_CLIENT_GROUP.getCode(), addReqDto);
            }
            if (Objects.nonNull(clientBlack = addReqDto.getApplyClientBlack())) {
                DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)clientBlack, DgStrategyRuleSuitTypeEnum.SUITTYPE_CLIENT_BLACK.getCode(), addReqDto);
            }
        }
    }

    private static void extractedAddRange(DgStrategyRuleEo dgStrategyRuleEo, List<DgStrategyRuleSuitEo> dgStrategyRuleSuitEoList, DgCustomerAuditStrategyRuleReqDto.Apply apply, String suitType, DgCustomerAuditStrategyRuleReqDto addReqDto) {
        DgStrategyRuleSuitEo dgStrategyRuleSuitEo = new DgStrategyRuleSuitEo();
        dgStrategyRuleSuitEo.setRuleId(dgStrategyRuleEo.getId());
        dgStrategyRuleSuitEo.setSuitType(suitType);
        dgStrategyRuleSuitEo.setStrategyType(addReqDto.getStrategyType());
        dgStrategyRuleSuitEo.setMd5(MD5Util.getMd5ByString((String)apply.getMD5Content()));
        if (StringUtils.equals((CharSequence)apply.getApplicableType(), (CharSequence)ALL) || StringUtils.equals((CharSequence)apply.getApplicableType(), (CharSequence)CLOSE) || StringUtils.equals((CharSequence)apply.getApplicableType(), (CharSequence)RANG)) {
            dgStrategyRuleSuitEo.setSuitKey(apply.getApplicableType());
            dgStrategyRuleSuitEo.setSuitSelectType(apply.getApplicableType());
            dgStrategyRuleSuitEo.setSuitMatchCode(dgStrategyRuleSuitEo.getSuitType() + "_" + dgStrategyRuleSuitEo.getSuitSelectType() + "_" + dgStrategyRuleSuitEo.getSuitKey());
            dgStrategyRuleSuitEoList.add(dgStrategyRuleSuitEo);
        } else if (CollectionUtils.isNotEmpty((Collection)apply.getApplicableList())) {
            for (String shopCode : apply.getApplicableList()) {
                dgStrategyRuleSuitEo = new DgStrategyRuleSuitEo();
                dgStrategyRuleSuitEo.setRuleId(dgStrategyRuleEo.getId());
                dgStrategyRuleSuitEo.setSuitType(suitType);
                dgStrategyRuleSuitEo.setStrategyType(addReqDto.getStrategyType());
                dgStrategyRuleSuitEo.setSuitKey(shopCode);
                dgStrategyRuleSuitEo.setSuitSelectType(SELECT);
                dgStrategyRuleSuitEo.setSuitMatchCode(dgStrategyRuleSuitEo.getSuitType() + "_" + dgStrategyRuleSuitEo.getSuitSelectType() + "_" + shopCode);
                dgStrategyRuleSuitEo.setMd5(MD5Util.getMd5ByString((String)apply.getMD5Content()));
                dgStrategyRuleSuitEoList.add(dgStrategyRuleSuitEo);
            }
        }
    }

    private void popStrategyConfItems(DgCustomerAuditStrategyRuleReqDto addReqDto, DgStrategyRuleEo dgStrategyRuleEo) {
        StrategyConfItemEo delayAuditConfEo;
        ArrayList confItemEoList = Lists.newArrayList();
        if (Objects.nonNull(addReqDto.getAutoSplit())) {
            this.setAddConfList(dgStrategyRuleEo, confItemEoList, DgStrategyConfItemTypeEnum.AUTO_SPLIT, addReqDto.getAutoSplit());
        }
        if (Objects.nonNull(addReqDto.getInstallationVerificationStrategy())) {
            this.setAddConfList(dgStrategyRuleEo, confItemEoList, DgStrategyConfItemTypeEnum.INSTALLATION_VERIFICATION_STRATEGY, addReqDto.getInstallationVerificationStrategy());
        }
        if (Objects.nonNull(addReqDto.getAutomaticPushInstallation())) {
            this.setAddConfList(dgStrategyRuleEo, confItemEoList, DgStrategyConfItemTypeEnum.AUTOMATIC_PUSH_INSTALLATION, addReqDto.getAutomaticPushInstallation());
        }
        if (Objects.nonNull(addReqDto.getNeedlessPersonAudit())) {
            this.setAddConfList(dgStrategyRuleEo, confItemEoList, DgStrategyConfItemTypeEnum.NEEDLESS_PERSON_AUDIT, addReqDto.getNeedlessPersonAudit());
        }
        if (Objects.nonNull(addReqDto.getDelayAudit())) {
            delayAuditConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)delayAuditConfEo, (Object)addReqDto.getDelayAudit(), (String[])new String[0]);
            delayAuditConfEo.setContent(addReqDto.getDelayAudit().getContent());
            delayAuditConfEo.setRuleId(dgStrategyRuleEo.getId());
            delayAuditConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getDelayAudit().getMD5Content()));
            confItemEoList.add(delayAuditConfEo);
        }
        if (Objects.nonNull(addReqDto.getOrderNumberJudgment())) {
            delayAuditConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)delayAuditConfEo, (Object)addReqDto.getOrderNumberJudgment(), (String[])new String[0]);
            delayAuditConfEo.setContent(addReqDto.getDelayAudit().getContent());
            delayAuditConfEo.setRuleId(dgStrategyRuleEo.getId());
            delayAuditConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getDelayAudit().getMD5Content()));
            confItemEoList.add(delayAuditConfEo);
        }
        if (Objects.nonNull(addReqDto.getAutoDistribution())) {
            StrategyConfItemEo autoDistributionEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)autoDistributionEo, (Object)addReqDto.getAutoDistribution(), (String[])new String[0]);
            autoDistributionEo.setContent(addReqDto.getAutoDistribution().getContent());
            autoDistributionEo.setRuleId(dgStrategyRuleEo.getId());
            autoDistributionEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getAutoDistribution().getMD5Content()));
            confItemEoList.add(autoDistributionEo);
        }
        if (Objects.nonNull(addReqDto.getSpecialAmount())) {
            StrategyConfItemEo specialAmountConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)specialAmountConfEo, (Object)addReqDto.getSpecialAmount(), (String[])new String[0]);
            specialAmountConfEo.setRuleId(dgStrategyRuleEo.getId());
            specialAmountConfEo.setContent(addReqDto.getSpecialAmount().getContent());
            specialAmountConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getSpecialAmount().getMD5Content()));
            confItemEoList.add(specialAmountConfEo);
        }
        ArrayList strategyConfItemSuitEoList = Lists.newArrayList();
        if (Objects.nonNull(addReqDto.getSpecialWarehouse())) {
            this.setAddConfItemByList(dgStrategyRuleEo, confItemEoList, strategyConfItemSuitEoList, addReqDto.getSpecialWarehouse().getMD5Content(), DgStrategyConfItemTypeEnum.SPECIAL_WAREHOUSE, addReqDto.getSpecialWarehouse().getContent(), addReqDto.getSpecialWarehouse().getEnable(), addReqDto.getSpecialWarehouse().getWarehouseCodeList());
        }
        if (Objects.nonNull(addReqDto.getSpecialOrderType())) {
            this.setAddConfItemByList(dgStrategyRuleEo, confItemEoList, strategyConfItemSuitEoList, addReqDto.getSpecialOrderType().getMD5Content(), DgStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE, addReqDto.getSpecialOrderType().getContent(), addReqDto.getSpecialOrderType().getEnable(), addReqDto.getSpecialOrderType().getOrderTypeCodeList());
        }
        if (Objects.nonNull(addReqDto.getSpecialLabel())) {
            this.setAddConfItemByList(dgStrategyRuleEo, confItemEoList, strategyConfItemSuitEoList, addReqDto.getSpecialLabel().getMD5Content(), DgStrategyConfItemTypeEnum.SPECIAL_LABEL, addReqDto.getSpecialLabel().getContent(), addReqDto.getSpecialLabel().getEnable(), addReqDto.getSpecialLabel().getLabelCodeList());
        }
        if (Objects.nonNull(addReqDto.getSpecialSku())) {
            this.setAddConfItemByList(dgStrategyRuleEo, confItemEoList, strategyConfItemSuitEoList, addReqDto.getSpecialSku().getMD5Content(), DgStrategyConfItemTypeEnum.SPECIAL_SKU, addReqDto.getSpecialSku().getContent(), addReqDto.getSpecialSku().getEnable(), addReqDto.getSpecialSku().getSkuCodeList());
        }
        if (Objects.nonNull(addReqDto.getSpecialArea())) {
            this.setAddConfItemByList(dgStrategyRuleEo, confItemEoList, strategyConfItemSuitEoList, addReqDto.getSpecialArea().getMD5Content(), DgStrategyConfItemTypeEnum.SPECIAL_AREA, addReqDto.getSpecialArea().getContent(), addReqDto.getSpecialArea().getEnable(), addReqDto.getSpecialArea().getAreaCodeList());
        }
        if (Objects.nonNull(addReqDto.getSpecialCustomer())) {
            this.setAddConfItemByList(dgStrategyRuleEo, confItemEoList, strategyConfItemSuitEoList, addReqDto.getSpecialCustomer().getMD5Content(), DgStrategyConfItemTypeEnum.SPECIAL_CUSTOMER, addReqDto.getSpecialCustomer().getContent(), addReqDto.getSpecialCustomer().getEnable(), addReqDto.getSpecialCustomer().getCustomerCodeList());
        }
        if (Objects.nonNull(addReqDto.getBuyerRemark())) {
            StrategyConfItemEo buyerRemarkConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)buyerRemarkConfEo, (Object)addReqDto.getBuyerRemark(), (String[])new String[0]);
            buyerRemarkConfEo.setRuleId(dgStrategyRuleEo.getId());
            buyerRemarkConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getBuyerRemark().getMD5Content()));
            confItemEoList.add(buyerRemarkConfEo);
        }
        if (Objects.nonNull(addReqDto.getSellerRemark())) {
            StrategyConfItemEo sellerRemarkConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)sellerRemarkConfEo, (Object)addReqDto.getSellerRemark(), (String[])new String[0]);
            sellerRemarkConfEo.setStrategyType(DgStrategyConfItemTypeEnum.SELLER_REMARK.getCode());
            sellerRemarkConfEo.setStrategyTypeName(DgStrategyConfItemTypeEnum.SELLER_REMARK.getDesc());
            sellerRemarkConfEo.setRuleId(dgStrategyRuleEo.getId());
            sellerRemarkConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getSellerRemark().getMD5Content()));
            confItemEoList.add(sellerRemarkConfEo);
        }
        if (Objects.nonNull(addReqDto.getInternalRemark())) {
            StrategyConfItemEo internalRemarkConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)internalRemarkConfEo, (Object)addReqDto.getInternalRemark(), (String[])new String[0]);
            internalRemarkConfEo.setRuleId(dgStrategyRuleEo.getId());
            internalRemarkConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getInternalRemark().getMD5Content()));
            confItemEoList.add(internalRemarkConfEo);
        }
        if (Objects.nonNull(addReqDto.getSpecialPayTime())) {
            StrategyConfItemEo specialPayTimeConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)specialPayTimeConfEo, (Object)addReqDto.getSpecialPayTime(), (String[])new String[0]);
            specialPayTimeConfEo.setRuleId(dgStrategyRuleEo.getId());
            specialPayTimeConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getSpecialPayTime().getMD5Content()));
            confItemEoList.add(specialPayTimeConfEo);
        }
        if (Objects.nonNull(addReqDto.getAppointPersonAudit())) {
            this.setAddConfList(dgStrategyRuleEo, confItemEoList, DgStrategyConfItemTypeEnum.APPOINT_PERSON_AUDIT, addReqDto.getAppointPersonAudit());
        }
        if (Objects.nonNull(addReqDto.getSpecialPersonCustomer())) {
            this.setAddConfItemByList(dgStrategyRuleEo, confItemEoList, strategyConfItemSuitEoList, addReqDto.getSpecialPersonCustomer().getMD5Content(), DgStrategyConfItemTypeEnum.APPOINT_PERSON_CUSTOMER, addReqDto.getSpecialPersonCustomer().getContent(), addReqDto.getSpecialPersonCustomer().getEnable(), addReqDto.getSpecialPersonCustomer().getCustomerCodeList());
        }
        if (Objects.nonNull(addReqDto.getSpecialPersonItemTag())) {
            this.setAddConfItemByList(dgStrategyRuleEo, confItemEoList, strategyConfItemSuitEoList, addReqDto.getSpecialPersonItemTag().getMD5Content(), DgStrategyConfItemTypeEnum.APPOINT_PERSON_ITEM_TAG, addReqDto.getSpecialPersonItemTag().getContent(), addReqDto.getSpecialPersonItemTag().getEnable(), addReqDto.getSpecialPersonItemTag().getCodeList());
        }
        if (Objects.nonNull(addReqDto.getAppointAuditNoPass())) {
            this.setAddConfList(dgStrategyRuleEo, confItemEoList, DgStrategyConfItemTypeEnum.APPOINT_AUDIT_NO_PASS, addReqDto.getAppointAuditNoPass());
        }
        if (Objects.nonNull(addReqDto.getSpecialNoPassCustomer())) {
            this.setAddConfItemByList(dgStrategyRuleEo, confItemEoList, strategyConfItemSuitEoList, addReqDto.getSpecialNoPassCustomer().getMD5Content(), DgStrategyConfItemTypeEnum.APPOINT_AUDIT_NO_PASS_CUSTOMER, addReqDto.getSpecialNoPassCustomer().getContent(), addReqDto.getSpecialNoPassCustomer().getEnable(), addReqDto.getSpecialNoPassCustomer().getCustomerCodeList());
        }
        if (Objects.nonNull(addReqDto.getSpecialNoPassItemTag())) {
            this.setAddConfItemByList(dgStrategyRuleEo, confItemEoList, strategyConfItemSuitEoList, addReqDto.getSpecialNoPassItemTag().getMD5Content(), DgStrategyConfItemTypeEnum.APPOINT_AUDIT_NO_PASS_ITEM_TAG, addReqDto.getSpecialNoPassItemTag().getContent(), addReqDto.getSpecialNoPassItemTag().getEnable(), addReqDto.getSpecialNoPassItemTag().getCodeList());
        }
        if (Objects.nonNull(addReqDto.getAccountPayScale())) {
            DgStrategyConfItemTypeEnum typeEnum = DgStrategyConfItemTypeEnum.ACCOUNT_PAY_SCALE_CUSTOMER;
            if (Objects.equals(addReqDto.getStrategyType(), DgCisStrategyOrderTypeEnum.DEFAULT_ACCOUNT_PAY.getCode())) {
                typeEnum = DgStrategyConfItemTypeEnum.ACCOUNT_PAY_SCALE;
            }
            this.setAddConfItemByAccount(dgStrategyRuleEo, confItemEoList, strategyConfItemSuitEoList, addReqDto.getAccountPayScale().getMD5Content(), typeEnum, addReqDto.getAccountPayScale().getContent(), addReqDto.getAccountPayScale().getEnable(), addReqDto.getAccountPayScale().getAccountPayScaleList());
        }
        this.dgStrategyConfItemDomain.insertBatch((List)confItemEoList);
        this.strategyConfItemSuitDas.insertBatch((List)strategyConfItemSuitEoList);
    }

    private void setAddConfItemByList(DgStrategyRuleEo dgStrategyRuleEo, List<StrategyConfItemEo> confItemEoList, List<StrategyConfItemSuitEo> strategyConfItemSuitEoList, String md5Content, DgStrategyConfItemTypeEnum confItemTypeEnum, String content, Integer enable, List<String> codeList) {
        String md5ByString = MD5Util.getMd5ByString((String)md5Content);
        StrategyConfItemEo specialCustomerConfEo = new StrategyConfItemEo();
        specialCustomerConfEo.setStrategyType(confItemTypeEnum.getCode());
        specialCustomerConfEo.setStrategyTypeName(confItemTypeEnum.getDesc());
        specialCustomerConfEo.setRuleId(dgStrategyRuleEo.getId());
        specialCustomerConfEo.setEnable(enable);
        specialCustomerConfEo.setContentType(CisStrategyContentTypeEnum.LIST.getCode());
        specialCustomerConfEo.setContent(content);
        specialCustomerConfEo.setMd5(md5ByString);
        confItemEoList.add(specialCustomerConfEo);
        if (CollectionUtils.isNotEmpty(codeList)) {
            for (String code : codeList) {
                StrategyConfItemSuitEo confItemSuitEo = new StrategyConfItemSuitEo();
                confItemSuitEo.setRuleId(dgStrategyRuleEo.getId());
                confItemSuitEo.setSuitType(confItemTypeEnum.getCode());
                confItemSuitEo.setSuitValue(code);
                confItemSuitEo.setSuitMatchCode(confItemTypeEnum.getCode() + "_" + code);
                strategyConfItemSuitEoList.add(confItemSuitEo);
            }
        }
    }

    private void setAddConfList(DgStrategyRuleEo dgStrategyRuleEo, List<StrategyConfItemEo> confItemEoList, DgStrategyConfItemTypeEnum confItemTypeEnum, Integer addValue) {
        StrategyConfItemEo strategyConfItemEo = new StrategyConfItemEo();
        strategyConfItemEo.setRuleId(dgStrategyRuleEo.getId());
        strategyConfItemEo.setStrategyType(confItemTypeEnum.getCode());
        strategyConfItemEo.setStrategyTypeName(confItemTypeEnum.getDesc());
        strategyConfItemEo.setEnable(addValue);
        strategyConfItemEo.setMd5(MD5Util.getMd5ByString((String)String.valueOf(addValue)));
        confItemEoList.add(strategyConfItemEo);
    }

    private void setAddConfItemByAccount(DgStrategyRuleEo dgStrategyRuleEo, List<StrategyConfItemEo> confItemEoList, List<StrategyConfItemSuitEo> strategyConfItemSuitEoList, String md5Content, DgStrategyConfItemTypeEnum confItemTypeEnum, String content, Integer enable, List<DgAccountPayScaleDto> accountPayScaleList) {
        String md5ByString = MD5Util.getMd5ByString((String)md5Content);
        StrategyConfItemEo specialCustomerConfEo = new StrategyConfItemEo();
        specialCustomerConfEo.setStrategyType(confItemTypeEnum.getCode());
        specialCustomerConfEo.setStrategyTypeName(confItemTypeEnum.getDesc());
        specialCustomerConfEo.setRuleId(dgStrategyRuleEo.getId());
        specialCustomerConfEo.setEnable(enable);
        specialCustomerConfEo.setContentType(CisStrategyContentTypeEnum.LIST.getCode());
        specialCustomerConfEo.setContent(content);
        specialCustomerConfEo.setMd5(md5ByString);
        confItemEoList.add(specialCustomerConfEo);
        if (CollectionUtils.isNotEmpty(accountPayScaleList)) {
            for (DgAccountPayScaleDto scaleDto : accountPayScaleList) {
                StrategyConfItemSuitEo confItemSuitEo = new StrategyConfItemSuitEo();
                confItemSuitEo.setRuleId(dgStrategyRuleEo.getId());
                confItemSuitEo.setSuitType(confItemTypeEnum.getCode());
                confItemSuitEo.setSuitValue(scaleDto.getAccountCode());
                confItemSuitEo.setSuitMatchCode(confItemTypeEnum.getCode() + "_" + scaleDto.getAccountCode());
                confItemSuitEo.setExtension(scaleDto.getScaleValue());
                strategyConfItemSuitEoList.add(confItemSuitEo);
            }
        }
    }

    @Override
    public void modifyCustomerAuditStrategyRule(DgCustomerAuditStrategyRuleReqDto modifyReqDto) {
        AssertUtils.notNull((Object)modifyReqDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        DgStrategyRuleEo newDgStrategyRuleEo = new DgStrategyRuleEo();
        CubeBeanUtils.copyProperties((Object)newDgStrategyRuleEo, (Object)modifyReqDto, (String[])new String[0]);
        if (Objects.isNull(newDgStrategyRuleEo.getPriority())) {
            newDgStrategyRuleEo.setPriority(Integer.valueOf(1));
        }
        this.strategyRuleDas.updateSelective((BaseEo)newDgStrategyRuleEo);
        if (Objects.equals(modifyReqDto.getPeriodicStatus(), YesNoEnum.YES.getDesc())) {
            this.strategyRuleDas.updateStrategyPeriodicEnd(modifyReqDto.getId());
        }
        this.modifyStrategyConfItems(modifyReqDto);
        this.extractedModifyRange(modifyReqDto);
    }

    private void extractedModifyRange(DgCustomerAuditStrategyRuleReqDto modifyReqDto) {
        if (modifyReqDto.getPlatForm().equals("2c")) {
            if (Objects.nonNull(modifyReqDto.getApplyShop())) {
                DgCustomerAuditStrategyRuleReqDto.ApplyShop applyShop = modifyReqDto.getApplyShop();
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)applyShop, DgStrategyRuleSuitTypeEnum.SUITTYPE_SHOP.getCode());
            }
            if (Objects.nonNull(modifyReqDto.getApplyOrderType())) {
                DgCustomerAuditStrategyRuleReqDto.ApplyOrderType applyOrderType = modifyReqDto.getApplyOrderType();
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)applyOrderType, DgStrategyRuleSuitTypeEnum.SUITTYPE_ORDER_TYPE.getCode());
            }
        } else {
            if (Objects.nonNull(modifyReqDto.getApplyChannel())) {
                DgCustomerAuditStrategyRuleReqDto.ApplyChannel applyChannel = modifyReqDto.getApplyChannel();
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)applyChannel, DgStrategyRuleSuitTypeEnum.SUITTYPE_CHANNEL.getCode());
            }
            if (Objects.nonNull(modifyReqDto.getApplyShop())) {
                DgCustomerAuditStrategyRuleReqDto.ApplyShop applyShop = modifyReqDto.getApplyShop();
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)applyShop, DgStrategyRuleSuitTypeEnum.SUITTYPE_SHOP.getCode());
            }
            if (Objects.nonNull(modifyReqDto.getApplyCompany())) {
                DgCustomerAuditStrategyRuleReqDto.ApplyCompany applyCompany = modifyReqDto.getApplyCompany();
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)applyCompany, DgStrategyRuleSuitTypeEnum.SUITTYPE_COMPANY.getCode());
            }
            if (Objects.nonNull(modifyReqDto.getApplyOrderType())) {
                DgCustomerAuditStrategyRuleReqDto.ApplyOrderType applyOrderType = modifyReqDto.getApplyOrderType();
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)applyOrderType, DgStrategyRuleSuitTypeEnum.SUITTYPE_ORDER_TYPE.getCode());
            }
            if (Objects.nonNull(modifyReqDto.getApplyClient())) {
                DgCustomerAuditStrategyRuleReqDto.ApplyClient applyClient = modifyReqDto.getApplyClient();
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)applyClient, DgStrategyRuleSuitTypeEnum.SUITTYPE_CLEINT.getCode());
            }
            if (Objects.nonNull(modifyReqDto.getApplyChannelWarehouse())) {
                DgCustomerAuditStrategyRuleReqDto.ApplyChannelWarehouse applyChannelWarehouse = modifyReqDto.getApplyChannelWarehouse();
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)applyChannelWarehouse, DgStrategyRuleSuitTypeEnum.SUITTYPE_CHANNEL_WAREHOUSE.getCode());
            }
            if (Objects.nonNull(modifyReqDto.getApplyOrderLabel())) {
                DgCustomerAuditStrategyRuleReqDto.ApplyOrderLabel applyOrderLabel = modifyReqDto.getApplyOrderLabel();
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)applyOrderLabel, DgStrategyRuleSuitTypeEnum.SUITTYPE_ORDER_LABEL.getCode());
            }
            if (Objects.nonNull(modifyReqDto.getApplyOrg())) {
                DgCustomerAuditStrategyRuleReqDto.ApplyOrg applyOrg = modifyReqDto.getApplyOrg();
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)applyOrg, DgStrategyRuleSuitTypeEnum.SUITTYPE_ORG.getCode());
            }
            if (Objects.nonNull(modifyReqDto.getApplyBusinessArea())) {
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)modifyReqDto.getApplyBusinessArea(), DgStrategyRuleSuitTypeEnum.SUITTYPE_BUSINESS_AREA.getCode());
            }
            if (Objects.nonNull(modifyReqDto.getApplyClientType())) {
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)modifyReqDto.getApplyClientType(), DgStrategyRuleSuitTypeEnum.SUITTYPE_CLIENT_TYPE.getCode());
            }
            if (Objects.nonNull(modifyReqDto.getApplyClientGrade())) {
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)modifyReqDto.getApplyClientGrade(), DgStrategyRuleSuitTypeEnum.SUITTYPE_CLIENT_GRADE.getCode());
            }
            if (Objects.nonNull(modifyReqDto.getApplyClientGroup())) {
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)modifyReqDto.getApplyClientGroup(), DgStrategyRuleSuitTypeEnum.SUITTYPE_CLIENT_GROUP.getCode());
            }
            if (Objects.nonNull(modifyReqDto.getApplyClientBlack())) {
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)modifyReqDto.getApplyClientBlack(), DgStrategyRuleSuitTypeEnum.SUITTYPE_CLIENT_BLACK.getCode());
            }
        }
    }

    private void extractedModifyRange(DgCustomerAuditStrategyRuleReqDto modifyReqDto, DgCustomerAuditStrategyRuleReqDto.Apply apply, String suitType) {
        DgStrategyRuleSuitEo deleteEo = new DgStrategyRuleSuitEo();
        deleteEo.setRuleId(modifyReqDto.getId());
        deleteEo.setSuitType(suitType);
        this.strategyRuleSuitDas.logicDeleteByExample(deleteEo);
        ArrayList dgStrategyRuleSuitEoList = Lists.newArrayList();
        DgStrategyRuleSuitEo dgStrategyRuleSuitEo = new DgStrategyRuleSuitEo();
        dgStrategyRuleSuitEo.setRuleId(modifyReqDto.getId());
        dgStrategyRuleSuitEo.setSuitType(suitType);
        dgStrategyRuleSuitEo.setStrategyType(modifyReqDto.getStrategyType());
        dgStrategyRuleSuitEo.setMd5(MD5Util.getMd5ByString((String)apply.getMD5Content()));
        if (StringUtils.equals((CharSequence)apply.getApplicableType(), (CharSequence)ALL) || StringUtils.equals((CharSequence)apply.getApplicableType(), (CharSequence)CLOSE) || StringUtils.equals((CharSequence)apply.getApplicableType(), (CharSequence)RANG)) {
            dgStrategyRuleSuitEo.setSuitKey(apply.getApplicableType());
            dgStrategyRuleSuitEo.setSuitSelectType(apply.getApplicableType());
            dgStrategyRuleSuitEo.setSuitMatchCode(dgStrategyRuleSuitEo.getSuitType() + "_" + dgStrategyRuleSuitEo.getSuitSelectType() + "_" + dgStrategyRuleSuitEo.getSuitKey());
            dgStrategyRuleSuitEoList.add(dgStrategyRuleSuitEo);
        } else if (CollectionUtils.isNotEmpty((Collection)apply.getApplicableList())) {
            for (String shopCode : apply.getApplicableList()) {
                dgStrategyRuleSuitEo = new DgStrategyRuleSuitEo();
                dgStrategyRuleSuitEo.setRuleId(modifyReqDto.getId());
                dgStrategyRuleSuitEo.setSuitType(suitType);
                dgStrategyRuleSuitEo.setStrategyType(modifyReqDto.getStrategyType());
                dgStrategyRuleSuitEo.setSuitKey(shopCode);
                dgStrategyRuleSuitEo.setSuitSelectType(SELECT);
                dgStrategyRuleSuitEo.setSuitMatchCode(dgStrategyRuleSuitEo.getSuitType() + "_" + dgStrategyRuleSuitEo.getSuitSelectType() + "_" + shopCode);
                dgStrategyRuleSuitEo.setMd5(MD5Util.getMd5ByString((String)apply.getMD5Content()));
                dgStrategyRuleSuitEoList.add(dgStrategyRuleSuitEo);
            }
        }
        this.strategyRuleSuitDas.insertBatch((List)dgStrategyRuleSuitEoList);
    }

    private void modifyStrategyConfItems(DgCustomerAuditStrategyRuleReqDto modifyReqDto) {
        LambdaQueryWrapper queryStrategyConfItemEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyConfItemEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemEo::getRuleId, (Object)modifyReqDto.getId());
        List strategyConfItemEoList = this.dgStrategyConfItemDomain.list(queryStrategyConfItemEo);
        Map<String, StrategyConfItemEo> groupStrategyMap = strategyConfItemEoList.stream().collect(Collectors.toMap(StrategyConfItemEo::getStrategyType, Function.identity(), (v1, v2) -> v2));
        if (Objects.nonNull(modifyReqDto.getAutoSplit())) {
            this.modifyConfItemOne(modifyReqDto, groupStrategyMap, DgStrategyConfItemTypeEnum.AUTO_SPLIT, modifyReqDto.getAutoSplit());
        }
        if (Objects.nonNull(modifyReqDto.getInstallationVerificationStrategy())) {
            this.modifyConfItemOne(modifyReqDto, groupStrategyMap, DgStrategyConfItemTypeEnum.INSTALLATION_VERIFICATION_STRATEGY, modifyReqDto.getInstallationVerificationStrategy());
        }
        if (Objects.nonNull(modifyReqDto.getAutomaticPushInstallation())) {
            this.modifyConfItemOne(modifyReqDto, groupStrategyMap, DgStrategyConfItemTypeEnum.AUTOMATIC_PUSH_INSTALLATION, modifyReqDto.getAutomaticPushInstallation());
        }
        if (Objects.nonNull(modifyReqDto.getNeedlessPersonAudit())) {
            this.modifyConfItemOne(modifyReqDto, groupStrategyMap, DgStrategyConfItemTypeEnum.NEEDLESS_PERSON_AUDIT, modifyReqDto.getNeedlessPersonAudit());
        }
        if (Objects.nonNull(modifyReqDto.getDelayAudit())) {
            this.modifyConfByStringAdd(modifyReqDto, groupStrategyMap, modifyReqDto.getDelayAudit().getMD5Content(), DgStrategyConfItemTypeEnum.DELAY_AUDIT, modifyReqDto.getDelayAudit().getEnable(), modifyReqDto.getDelayAudit().getContent());
        }
        if (Objects.nonNull(modifyReqDto.getOrderNumberJudgment())) {
            this.modifyConfByStringAdd(modifyReqDto, groupStrategyMap, modifyReqDto.getOrderNumberJudgment().getMD5Content(), DgStrategyConfItemTypeEnum.ORDER_NUMBER_JUDGMENT, modifyReqDto.getOrderNumberJudgment().getEnable(), modifyReqDto.getOrderNumberJudgment().getContent());
        }
        if (Objects.nonNull(modifyReqDto.getSpecialAmount())) {
            this.modifyConfByStringAdd(modifyReqDto, groupStrategyMap, modifyReqDto.getSpecialAmount().getMD5Content(), DgStrategyConfItemTypeEnum.SPECIAL_AMOUNT, modifyReqDto.getSpecialAmount().getEnable(), modifyReqDto.getSpecialAmount().getContent());
        }
        if (Objects.nonNull(modifyReqDto.getSpecialWarehouse())) {
            this.modifyConfItemListByCodes(modifyReqDto, groupStrategyMap, modifyReqDto.getSpecialWarehouse().getMD5Content(), DgStrategyConfItemTypeEnum.SPECIAL_WAREHOUSE, modifyReqDto.getSpecialWarehouse().getContent(), modifyReqDto.getSpecialWarehouse().getEnable(), modifyReqDto.getSpecialWarehouse().getWarehouseCodeList());
        }
        if (Objects.nonNull(modifyReqDto.getSpecialOrderType())) {
            this.modifyConfItemListByCodes(modifyReqDto, groupStrategyMap, modifyReqDto.getSpecialOrderType().getMD5Content(), DgStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE, modifyReqDto.getSpecialOrderType().getContent(), modifyReqDto.getSpecialOrderType().getEnable(), modifyReqDto.getSpecialOrderType().getOrderTypeCodeList());
        }
        if (Objects.nonNull(modifyReqDto.getSpecialLabel())) {
            this.modifyConfItemListByCodes(modifyReqDto, groupStrategyMap, modifyReqDto.getSpecialLabel().getMD5Content(), DgStrategyConfItemTypeEnum.SPECIAL_LABEL, modifyReqDto.getSpecialLabel().getContent(), modifyReqDto.getSpecialLabel().getEnable(), modifyReqDto.getSpecialLabel().getLabelCodeList());
        }
        if (Objects.nonNull(modifyReqDto.getSpecialSku())) {
            this.modifyConfItemListByCodes(modifyReqDto, groupStrategyMap, modifyReqDto.getSpecialSku().getMD5Content(), DgStrategyConfItemTypeEnum.SPECIAL_SKU, modifyReqDto.getSpecialSku().getContent(), modifyReqDto.getSpecialSku().getEnable(), modifyReqDto.getSpecialSku().getSkuCodeList());
        }
        if (Objects.nonNull(modifyReqDto.getSpecialCustomer())) {
            this.modifyConfItemListByCodes(modifyReqDto, groupStrategyMap, modifyReqDto.getSpecialCustomer().getMD5Content(), DgStrategyConfItemTypeEnum.SPECIAL_CUSTOMER, modifyReqDto.getSpecialCustomer().getContent(), modifyReqDto.getSpecialCustomer().getEnable(), modifyReqDto.getSpecialCustomer().getCustomerCodeList());
        }
        if (Objects.nonNull(modifyReqDto.getSpecialArea())) {
            this.modifyConfItemListByCodes(modifyReqDto, groupStrategyMap, modifyReqDto.getSpecialArea().getMD5Content(), DgStrategyConfItemTypeEnum.SPECIAL_AREA, modifyReqDto.getSpecialArea().getContent(), modifyReqDto.getSpecialArea().getEnable(), modifyReqDto.getSpecialArea().getAreaCodeList());
        }
        if (Objects.nonNull(modifyReqDto.getBuyerRemark())) {
            this.modifyConfByString(groupStrategyMap, modifyReqDto.getBuyerRemark().getMD5Content(), DgStrategyConfItemTypeEnum.BUYER_REMARK, modifyReqDto.getBuyerRemark().getEnable(), modifyReqDto.getBuyerRemark().getContent());
        }
        if (Objects.nonNull(modifyReqDto.getSellerRemark())) {
            this.modifyConfByString(groupStrategyMap, modifyReqDto.getSellerRemark().getMD5Content(), DgStrategyConfItemTypeEnum.SELLER_REMARK, modifyReqDto.getSellerRemark().getEnable(), modifyReqDto.getSellerRemark().getContent());
        }
        if (Objects.nonNull(modifyReqDto.getInternalRemark())) {
            this.modifyConfByString(groupStrategyMap, modifyReqDto.getInternalRemark().getMD5Content(), DgStrategyConfItemTypeEnum.INTERNAL_REMARK, modifyReqDto.getInternalRemark().getEnable(), modifyReqDto.getInternalRemark().getContent());
        }
        if (Objects.nonNull(modifyReqDto.getSpecialPayTime())) {
            this.modifyConfByString(groupStrategyMap, modifyReqDto.getSpecialPayTime().getMD5Content(), DgStrategyConfItemTypeEnum.SPECIAL_PAYTIME, modifyReqDto.getSpecialPayTime().getEnable(), modifyReqDto.getSpecialPayTime().getContent());
        }
        if (Objects.nonNull(modifyReqDto.getAutoDistribution())) {
            this.modifyConfByString(groupStrategyMap, modifyReqDto.getAutoDistribution().getMD5Content(), DgStrategyConfItemTypeEnum.AUTO_DISTRIBUTION, modifyReqDto.getAutoDistribution().getEnable(), modifyReqDto.getAutoDistribution().getContent());
        }
        if (Objects.nonNull(modifyReqDto.getAppointPersonAudit())) {
            this.modifyConfItemOne(modifyReqDto, groupStrategyMap, DgStrategyConfItemTypeEnum.APPOINT_PERSON_AUDIT, modifyReqDto.getAppointPersonAudit());
        }
        if (Objects.nonNull(modifyReqDto.getSpecialPersonCustomer())) {
            this.modifyConfItemListByCodes(modifyReqDto, groupStrategyMap, modifyReqDto.getSpecialPersonCustomer().getMD5Content(), DgStrategyConfItemTypeEnum.APPOINT_PERSON_CUSTOMER, modifyReqDto.getSpecialPersonCustomer().getContent(), modifyReqDto.getSpecialPersonCustomer().getEnable(), modifyReqDto.getSpecialPersonCustomer().getCustomerCodeList());
        }
        if (Objects.nonNull(modifyReqDto.getSpecialPersonItemTag())) {
            this.modifyConfItemListByCodes(modifyReqDto, groupStrategyMap, modifyReqDto.getSpecialPersonItemTag().getMD5Content(), DgStrategyConfItemTypeEnum.APPOINT_PERSON_ITEM_TAG, modifyReqDto.getSpecialPersonItemTag().getContent(), modifyReqDto.getSpecialPersonItemTag().getEnable(), modifyReqDto.getSpecialPersonItemTag().getCodeList());
        }
        if (Objects.nonNull(modifyReqDto.getAppointAuditNoPass())) {
            this.modifyConfItemOne(modifyReqDto, groupStrategyMap, DgStrategyConfItemTypeEnum.APPOINT_AUDIT_NO_PASS, modifyReqDto.getAppointAuditNoPass());
        }
        if (Objects.nonNull(modifyReqDto.getSpecialNoPassCustomer())) {
            this.modifyConfItemListByCodes(modifyReqDto, groupStrategyMap, modifyReqDto.getSpecialNoPassCustomer().getMD5Content(), DgStrategyConfItemTypeEnum.APPOINT_AUDIT_NO_PASS_CUSTOMER, modifyReqDto.getSpecialNoPassCustomer().getContent(), modifyReqDto.getSpecialNoPassCustomer().getEnable(), modifyReqDto.getSpecialNoPassCustomer().getCustomerCodeList());
        }
        if (Objects.nonNull(modifyReqDto.getSpecialNoPassItemTag())) {
            this.modifyConfItemListByCodes(modifyReqDto, groupStrategyMap, modifyReqDto.getSpecialNoPassItemTag().getMD5Content(), DgStrategyConfItemTypeEnum.APPOINT_AUDIT_NO_PASS_ITEM_TAG, modifyReqDto.getSpecialNoPassItemTag().getContent(), modifyReqDto.getSpecialNoPassItemTag().getEnable(), modifyReqDto.getSpecialNoPassItemTag().getCodeList());
        }
        if (Objects.nonNull(modifyReqDto.getAccountPayScale())) {
            DgStrategyConfItemTypeEnum typeEnum = DgStrategyConfItemTypeEnum.ACCOUNT_PAY_SCALE_CUSTOMER;
            if (Objects.equals(modifyReqDto.getStrategyType(), DgCisStrategyOrderTypeEnum.DEFAULT_ACCOUNT_PAY.getCode())) {
                typeEnum = DgStrategyConfItemTypeEnum.ACCOUNT_PAY_SCALE;
            }
            this.modifyConfItemListByAccount(modifyReqDto, groupStrategyMap, modifyReqDto.getAccountPayScale().getMD5Content(), typeEnum, modifyReqDto.getAccountPayScale().getContent(), modifyReqDto.getAccountPayScale().getEnable(), modifyReqDto.getAccountPayScale().getAccountPayScaleList());
        }
    }

    private void modifyConfByStringAdd(DgCustomerAuditStrategyRuleReqDto modifyReqDto, Map<String, StrategyConfItemEo> groupStrategyMap, String md5Content, DgStrategyConfItemTypeEnum confItemTypeEnum, Integer enable, String content) {
        String md5ByString = MD5Util.getMd5ByString((String)md5Content);
        StrategyConfItemEo confItemEo = groupStrategyMap.get(confItemTypeEnum.getCode());
        if (confItemEo != null && !StringUtils.equals((CharSequence)confItemEo.getMd5(), (CharSequence)md5ByString)) {
            LOGGER.info("\u3010\u4fee\u6539\u7b56\u7565\u3011{}\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)confItemTypeEnum.getDesc(), (Object)content);
            StrategyConfItemEo updateBuyerRemarkConfEo = new StrategyConfItemEo();
            updateBuyerRemarkConfEo.setId(confItemEo.getId());
            updateBuyerRemarkConfEo.setEnable(enable);
            updateBuyerRemarkConfEo.setContent(content);
            updateBuyerRemarkConfEo.setMd5(md5ByString);
            this.dgStrategyConfItemDomain.updateSelective((BaseEo)updateBuyerRemarkConfEo);
        }
        if (null == confItemEo) {
            StrategyConfItemEo confAddEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)confAddEo, (Object)modifyReqDto.getSpecialAmount(), (String[])new String[0]);
            confAddEo.setRuleId(modifyReqDto.getId());
            confAddEo.setStrategyType(confItemTypeEnum.getCode());
            confAddEo.setStrategyTypeName(confItemTypeEnum.getDesc());
            confAddEo.setEnable(enable);
            confAddEo.setContent(content);
            confAddEo.setMd5(md5ByString);
            this.dgStrategyConfItemDomain.insert((BaseEo)confAddEo);
        }
    }

    private void modifyConfByString(Map<String, StrategyConfItemEo> groupStrategyMap, String md5Content, DgStrategyConfItemTypeEnum confItemTypeEnum, Integer enable, String content) {
        String md5ByString = MD5Util.getMd5ByString((String)md5Content);
        StrategyConfItemEo confItemEo = groupStrategyMap.get(confItemTypeEnum.getCode());
        if (confItemEo != null && !StringUtils.equals((CharSequence)confItemEo.getMd5(), (CharSequence)md5ByString)) {
            LOGGER.info("\u3010\u4fee\u6539\u7b56\u7565\u3011{}\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)confItemTypeEnum.getDesc(), (Object)content);
            StrategyConfItemEo updateBuyerRemarkConfEo = new StrategyConfItemEo();
            updateBuyerRemarkConfEo.setId(confItemEo.getId());
            updateBuyerRemarkConfEo.setEnable(enable);
            updateBuyerRemarkConfEo.setContent(content);
            updateBuyerRemarkConfEo.setMd5(md5ByString);
            this.dgStrategyConfItemDomain.updateSelective((BaseEo)updateBuyerRemarkConfEo);
        }
        if (null == confItemEo) {
            StrategyConfItemEo addConfItemEo = new StrategyConfItemEo();
            addConfItemEo.setContentType(CisStrategyContentTypeEnum.STRING.getCode());
            addConfItemEo.setContent(content);
            addConfItemEo.setRuleId(confItemEo.getId());
            addConfItemEo.setStrategyType(confItemTypeEnum.getCode());
            addConfItemEo.setStrategyTypeName(confItemTypeEnum.getDesc());
            addConfItemEo.setEnable(enable);
            addConfItemEo.setMd5(md5ByString);
            this.dgStrategyConfItemDomain.insert((BaseEo)addConfItemEo);
        }
    }

    private void modifyConfItemListByCodes(DgCustomerAuditStrategyRuleReqDto modifyReqDto, Map<String, StrategyConfItemEo> groupStrategyMap, String md5Content, DgStrategyConfItemTypeEnum confItemTypeEnum, String content, Integer enable, List<String> codeList) {
        String specialMd5 = MD5Util.getMd5ByString((String)md5Content);
        StrategyConfItemEo confItemEo = groupStrategyMap.get(confItemTypeEnum.getCode());
        if (confItemEo != null && !StringUtils.equals((CharSequence)confItemEo.getMd5(), (CharSequence)specialMd5)) {
            LOGGER.info("\u3010\u4fee\u6539\u7b56\u7565\u3011\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)confItemTypeEnum.getDesc(), (Object)content);
            StrategyConfItemEo updateCustomerConfEo = new StrategyConfItemEo();
            updateCustomerConfEo.setId(confItemEo.getId());
            updateCustomerConfEo.setContent(content);
            updateCustomerConfEo.setEnable(enable);
            updateCustomerConfEo.setMd5(specialMd5);
            this.dgStrategyConfItemDomain.updateSelective((BaseEo)updateCustomerConfEo);
        }
        if (null == confItemEo) {
            StrategyConfItemEo addConfItemEo = new StrategyConfItemEo();
            addConfItemEo.setContentType(CisStrategyContentTypeEnum.LIST.getCode());
            addConfItemEo.setContent(content);
            addConfItemEo.setRuleId(modifyReqDto.getId());
            addConfItemEo.setStrategyType(confItemTypeEnum.getCode());
            addConfItemEo.setStrategyTypeName(confItemTypeEnum.getDesc());
            addConfItemEo.setEnable(enable);
            addConfItemEo.setMd5(specialMd5);
            this.dgStrategyConfItemDomain.insert((BaseEo)addConfItemEo);
        }
        StrategyConfItemSuitEo deleteEo = new StrategyConfItemSuitEo();
        deleteEo.setRuleId(modifyReqDto.getId());
        deleteEo.setSuitType(confItemTypeEnum.getCode());
        this.strategyConfItemSuitDas.logicDeleteByExample(deleteEo);
        if (CollectionUtils.isNotEmpty(codeList)) {
            ArrayList strategyConfItemSuitEoList = Lists.newArrayList();
            for (String code : codeList) {
                StrategyConfItemSuitEo confCustomerEo = new StrategyConfItemSuitEo();
                confCustomerEo.setRuleId(modifyReqDto.getId());
                confCustomerEo.setSuitType(confItemTypeEnum.getCode());
                confCustomerEo.setSuitValue(code);
                confCustomerEo.setSuitMatchCode(confItemTypeEnum.getCode() + "_" + code);
                strategyConfItemSuitEoList.add(confCustomerEo);
            }
            this.strategyConfItemSuitDas.insertBatch((List)strategyConfItemSuitEoList);
        }
    }

    private void modifyConfItemOne(DgCustomerAuditStrategyRuleReqDto modifyReqDto, Map<String, StrategyConfItemEo> groupStrategyMap, DgStrategyConfItemTypeEnum confItemTypeEnum, Integer updateValue) {
        StrategyConfItemEo updateConfItemEo = groupStrategyMap.get(confItemTypeEnum.getCode());
        String updateValueMd5 = MD5Util.getMd5ByString((String)String.valueOf(updateValue));
        if (updateConfItemEo != null && !StringUtils.equals((CharSequence)updateConfItemEo.getMd5(), (CharSequence)updateValueMd5)) {
            LOGGER.info("\u3010\u4fee\u6539\u7b56\u7565\u3011{}\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)confItemTypeEnum.getDesc(), (Object)updateValue);
            StrategyConfItemEo updateAppointAuditNoPassConfEo = new StrategyConfItemEo();
            updateAppointAuditNoPassConfEo.setId(updateConfItemEo.getId());
            updateAppointAuditNoPassConfEo.setEnable(updateValue);
            updateAppointAuditNoPassConfEo.setMd5(updateValueMd5);
            this.dgStrategyConfItemDomain.updateSelective((BaseEo)updateAppointAuditNoPassConfEo);
        }
        if (null == updateConfItemEo) {
            StrategyConfItemEo addConfItemEo = new StrategyConfItemEo();
            addConfItemEo.setRuleId(modifyReqDto.getId());
            addConfItemEo.setStrategyType(confItemTypeEnum.getCode());
            addConfItemEo.setStrategyTypeName(confItemTypeEnum.getDesc());
            addConfItemEo.setEnable(updateValue);
            addConfItemEo.setMd5(MD5Util.getMd5ByString((String)String.valueOf(updateValue)));
            this.dgStrategyConfItemDomain.insert((BaseEo)addConfItemEo);
        }
    }

    private void modifyConfItemListByAccount(DgCustomerAuditStrategyRuleReqDto modifyReqDto, Map<String, StrategyConfItemEo> groupStrategyMap, String md5Content, DgStrategyConfItemTypeEnum confItemTypeEnum, String content, Integer enable, List<DgAccountPayScaleDto> accountPayScaleDtos) {
        String specialMd5 = MD5Util.getMd5ByString((String)md5Content);
        StrategyConfItemEo confItemEo = groupStrategyMap.get(confItemTypeEnum.getCode());
        if (confItemEo != null && !StringUtils.equals((CharSequence)confItemEo.getMd5(), (CharSequence)specialMd5)) {
            LOGGER.info("\u3010\u4fee\u6539\u7b56\u7565\u3011\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)confItemTypeEnum.getDesc(), (Object)content);
            StrategyConfItemEo updateCustomerConfEo = new StrategyConfItemEo();
            updateCustomerConfEo.setId(confItemEo.getId());
            updateCustomerConfEo.setContent(content);
            updateCustomerConfEo.setEnable(enable);
            updateCustomerConfEo.setMd5(specialMd5);
            this.dgStrategyConfItemDomain.updateSelective((BaseEo)updateCustomerConfEo);
        }
        if (null == confItemEo) {
            StrategyConfItemEo addConfItemEo = new StrategyConfItemEo();
            addConfItemEo.setContentType(CisStrategyContentTypeEnum.STRING.getCode());
            addConfItemEo.setContent(content);
            addConfItemEo.setRuleId(modifyReqDto.getId());
            addConfItemEo.setStrategyType(confItemTypeEnum.getCode());
            addConfItemEo.setStrategyTypeName(confItemTypeEnum.getDesc());
            addConfItemEo.setEnable(enable);
            addConfItemEo.setMd5(specialMd5);
            this.dgStrategyConfItemDomain.insert((BaseEo)addConfItemEo);
        }
        StrategyConfItemSuitEo deleteEo = new StrategyConfItemSuitEo();
        deleteEo.setRuleId(modifyReqDto.getId());
        deleteEo.setSuitType(confItemTypeEnum.getCode());
        this.strategyConfItemSuitDas.logicDeleteByExample(deleteEo);
        if (CollectionUtils.isNotEmpty(accountPayScaleDtos)) {
            ArrayList strategyConfItemSuitEoList = Lists.newArrayList();
            for (DgAccountPayScaleDto dto : accountPayScaleDtos) {
                StrategyConfItemSuitEo confCustomerEo = new StrategyConfItemSuitEo();
                confCustomerEo.setRuleId(modifyReqDto.getId());
                confCustomerEo.setSuitType(confItemTypeEnum.getCode());
                confCustomerEo.setSuitValue(dto.getAccountCode());
                confCustomerEo.setSuitMatchCode(confItemTypeEnum.getCode() + "_" + dto.getAccountCode());
                confCustomerEo.setExtension(dto.getScaleValue());
                strategyConfItemSuitEoList.add(confCustomerEo);
            }
            this.strategyConfItemSuitDas.insertBatch((List)strategyConfItemSuitEoList);
        }
    }

    @Override
    public DgCustomerAuditStrategyRuleRespDto queryCustomerAuditStrategyById(Long id) {
        LambdaQueryWrapper queryStrategyRuleEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyRuleEo.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)id);
        DgStrategyRuleEo dgStrategyRuleEo = this.strategyRuleDas.getOne(queryStrategyRuleEo);
        AssertUtils.notNull((Object)dgStrategyRuleEo, (String)"\u7b56\u7565\u4e0d\u5b58\u5728");
        DgCustomerAuditStrategyRuleRespDto strategyRuleRespDto = new DgCustomerAuditStrategyRuleRespDto();
        DtoHelper.eo2Dto((BaseEo)dgStrategyRuleEo, (BaseVo)strategyRuleRespDto);
        this.getStrategyConfItems(id, strategyRuleRespDto);
        this.buildEffectiveDesc(strategyRuleRespDto);
        LambdaQueryWrapper queryStrategyRuleSuitEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyRuleSuitEo.eq(BaseEo::getDr, (Object)0)).eq(DgStrategyRuleSuitEo::getRuleId, (Object)id);
        List strategyRuleSuitList = this.strategyRuleSuitDas.list(queryStrategyRuleSuitEo);
        strategyRuleSuitList.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getSuitType())).collect(Collectors.groupingBy(DgStrategyRuleSuitEo::getSuitType)).forEach((k, v) -> {
            DgStrategyRuleSuitTypeEnum dgStrategyRuleSuitTypeEnum = DgStrategyRuleSuitTypeEnum.forCode((String)k);
            switch (dgStrategyRuleSuitTypeEnum) {
                case SUITTYPE_SHOP: {
                    DgCustomerAuditStrategyRuleRespDto.ApplyShop applyShop = new DgCustomerAuditStrategyRuleRespDto.ApplyShop();
                    DgStrategyRuleSuitEo dgStrategyRuleSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyRuleSuitEo, (DgCustomerAuditStrategyRuleRespDto.Apply)applyShop);
                    strategyRuleRespDto.setApplyShop(applyShop);
                    break;
                }
                case SUITTYPE_COMPANY: {
                    DgCustomerAuditStrategyRuleRespDto.ApplyCompany applyCompany = new DgCustomerAuditStrategyRuleRespDto.ApplyCompany();
                    DgStrategyRuleSuitEo dgStrategyRuleSuitCompanyEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyRuleSuitCompanyEo, (DgCustomerAuditStrategyRuleRespDto.Apply)applyCompany);
                    strategyRuleRespDto.setApplyCompany(applyCompany);
                    break;
                }
                case SUITTYPE_CHANNEL: {
                    DgCustomerAuditStrategyRuleRespDto.ApplyChannel applyChannel = new DgCustomerAuditStrategyRuleRespDto.ApplyChannel();
                    DgStrategyRuleSuitEo dgStrategyRuleChannelSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyRuleChannelSuitEo, (DgCustomerAuditStrategyRuleRespDto.Apply)applyChannel);
                    strategyRuleRespDto.setApplyChannel(applyChannel);
                    break;
                }
                case SUITTYPE_CHANNEL_WAREHOUSE: {
                    DgCustomerAuditStrategyRuleRespDto.ApplyChannelWarehouse applyChannelWarehouse = new DgCustomerAuditStrategyRuleRespDto.ApplyChannelWarehouse();
                    DgStrategyRuleSuitEo dgStrategyRuleChannelWarehouseSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyRuleChannelWarehouseSuitEo, (DgCustomerAuditStrategyRuleRespDto.Apply)applyChannelWarehouse);
                    strategyRuleRespDto.setApplyChannelWarehouse(applyChannelWarehouse);
                    break;
                }
                case SUITTYPE_ORDER_TYPE: {
                    DgCustomerAuditStrategyRuleRespDto.ApplyOrderType applyOrderType = new DgCustomerAuditStrategyRuleRespDto.ApplyOrderType();
                    DgStrategyRuleSuitEo dgStrategyRuleOrderTypeSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyRuleOrderTypeSuitEo, (DgCustomerAuditStrategyRuleRespDto.Apply)applyOrderType);
                    strategyRuleRespDto.setApplyOrderType(applyOrderType);
                    break;
                }
                case SUITTYPE_CLEINT: {
                    DgCustomerAuditStrategyRuleRespDto.ApplyClient applyClient = new DgCustomerAuditStrategyRuleRespDto.ApplyClient();
                    DgStrategyRuleSuitEo dgStrategyClientRuleSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyClientRuleSuitEo, (DgCustomerAuditStrategyRuleRespDto.Apply)applyClient);
                    strategyRuleRespDto.setApplyClient(applyClient);
                    break;
                }
                case SUITTYPE_ORDER_LABEL: {
                    DgCustomerAuditStrategyRuleRespDto.ApplyOrderLabel applyOrderLabel = new DgCustomerAuditStrategyRuleRespDto.ApplyOrderLabel();
                    DgStrategyRuleSuitEo dgStrategyRuleOrderLabelSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyRuleOrderLabelSuitEo, (DgCustomerAuditStrategyRuleRespDto.Apply)applyOrderLabel);
                    strategyRuleRespDto.setApplyOrderLabel(applyOrderLabel);
                    break;
                }
                case SUITTYPE_ORG: {
                    DgCustomerAuditStrategyRuleRespDto.ApplyOrg applyOrg = new DgCustomerAuditStrategyRuleRespDto.ApplyOrg();
                    DgStrategyRuleSuitEo dgStrategyRuleOrgSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyRuleOrgSuitEo, (DgCustomerAuditStrategyRuleRespDto.Apply)applyOrg);
                    strategyRuleRespDto.setApplyOrg(applyOrg);
                    break;
                }
                case SUITTYPE_BUSINESS_AREA: {
                    DgCustomerAuditStrategyRuleRespDto.ApplyClient businessArea = new DgCustomerAuditStrategyRuleRespDto.ApplyClient();
                    DgStrategyRuleSuitEo dgStrategyRuleAreaSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyRuleAreaSuitEo, (DgCustomerAuditStrategyRuleRespDto.Apply)businessArea);
                    strategyRuleRespDto.setApplyBusinessArea(businessArea);
                    break;
                }
                case SUITTYPE_CLIENT_TYPE: {
                    DgCustomerAuditStrategyRuleRespDto.ApplyClient clientType = new DgCustomerAuditStrategyRuleRespDto.ApplyClient();
                    DgStrategyRuleSuitEo dgStrategyRuleClientTypeSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyRuleClientTypeSuitEo, (DgCustomerAuditStrategyRuleRespDto.Apply)clientType);
                    strategyRuleRespDto.setApplyClientType(clientType);
                    break;
                }
                case SUITTYPE_CLIENT_GRADE: {
                    DgCustomerAuditStrategyRuleRespDto.ApplyClient grade = new DgCustomerAuditStrategyRuleRespDto.ApplyClient();
                    DgStrategyRuleSuitEo dgStrategyRuleGradeSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyRuleGradeSuitEo, (DgCustomerAuditStrategyRuleRespDto.Apply)grade);
                    strategyRuleRespDto.setApplyClientGrade(grade);
                    break;
                }
                case SUITTYPE_CLIENT_GROUP: {
                    DgCustomerAuditStrategyRuleRespDto.ApplyClient group = new DgCustomerAuditStrategyRuleRespDto.ApplyClient();
                    DgStrategyRuleSuitEo dgStrategyRuleGroupSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyRuleGroupSuitEo, (DgCustomerAuditStrategyRuleRespDto.Apply)group);
                    strategyRuleRespDto.setApplyClientGroup(group);
                    break;
                }
                case SUITTYPE_CLIENT_BLACK: {
                    DgCustomerAuditStrategyRuleRespDto.ApplyClientBlack black = new DgCustomerAuditStrategyRuleRespDto.ApplyClientBlack();
                    DgStrategyRuleSuitEo dgStrategyRuleBlackSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyRuleBlackSuitEo, (DgCustomerAuditStrategyRuleRespDto.Apply)black);
                    DgCustomerSearchListReqDto dgCustomerSearchListReqDto = new DgCustomerSearchListReqDto();
                    dgCustomerSearchListReqDto.setCustomerCodeList(black.getApplicableList());
                    List customerSearchListRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgCustomerQueryApiProxy.queryList(dgCustomerSearchListReqDto));
                    black.setDgCustomerRespDto(customerSearchListRespDtos);
                    strategyRuleRespDto.setApplyClientBlack(black);
                    break;
                }
            }
        });
        return strategyRuleRespDto;
    }

    private void buildEffectiveDesc(DgCustomerAuditStrategyRuleRespDto dgStrategyRuleRespDto) {
        String effectiveDesc = "";
        if (dgStrategyRuleRespDto.getPeriodicStart() != null && dgStrategyRuleRespDto.getPeriodicEnd() != null) {
            Long time = new Date().getTime();
            effectiveDesc = dgStrategyRuleRespDto.getPeriodicStart().getTime() < time ? (dgStrategyRuleRespDto.getPeriodicEnd().getTime() > time ? "\u5df2\u751f\u6548" : "\u5df2\u5931\u6548") : "\u672a\u751f\u6548";
        }
        dgStrategyRuleRespDto.setEffectiveDesc(effectiveDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DgStrategyRuleServiceImpl.MatchStrategyResult matchOrderStrtegyOfCustomer(Long orderId) {
        DgStrategyRuleServiceImpl.MatchStrategyResult matchStrategyResult = null;
        try {
            AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
            DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
            AssertUtils.notNull((Object)saleOrderRespDto, (String)String.format("orderNo=%s\u7684\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728", orderId));
            LOGGER.info("\u3010\u81ea\u52a8\u7b56\u7565\u3011\u8ba2\u5355\uff08orderId={}\uff09\u8ba2\u5355\u7684\u8be6\u60c5\u4e3a\uff1a{}", (Object)orderId, (Object)JSON.toJSONString((Object)saleOrderRespDto));
            matchStrategyResult = new DgStrategyRuleServiceImpl.MatchStrategyResult();
            DgStrategyRuleEo strategyRuleEo = this.queryValidRule(saleOrderRespDto, DgCisStrategyOrderTypeEnum.CUSTOMER.getCode());
            if (strategyRuleEo == null) {
                matchStrategyResult.setMatchStrategy(false);
                DgStrategyRuleServiceImpl.MatchStrategyResult matchStrategyResult2 = matchStrategyResult;
                return matchStrategyResult2;
            }
            List<StrategyConfItemEo> strategyConfItemEoList = this.queryValidRuleConfItemList(strategyRuleEo);
            Boolean checkResult = this.checkRule(strategyConfItemEoList, saleOrderRespDto, DgCisStrategyOrderTypeEnum.CUSTOMER);
            if (!checkResult.booleanValue()) {
                this.saveHitConfItem();
                matchStrategyResult.setIntercepted(true);
                DgStrategyRuleServiceImpl.MatchStrategyResult matchStrategyResult3 = matchStrategyResult;
                return matchStrategyResult3;
            }
            Map strategyConfItemEoMap = strategyConfItemEoList.stream().collect(Collectors.toMap(StrategyConfItemEo::getStrategyType, Function.identity(), (v1, v2) -> v2));
            StrategyConfItemEo strategyConfItemEo = (StrategyConfItemEo)strategyConfItemEoMap.get(DgStrategyConfItemTypeEnum.DELAY_AUDIT.getCode());
            if (strategyConfItemEo != null) {
                LOGGER.info("\u3010\u81ea\u52a8\u7b56\u7565\u3011\u8ba2\u5355\u53f7={}\uff0c\u5ef6\u8fdf\u5ba1\u6838\u65f6\u95f4\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)strategyConfItemEo.getContent());
                this.handleDelayAuditByConf(strategyConfItemEo, saleOrderRespDto, saleOrderRespDto.getSaleCreateTime(), DgCisStrategyOrderTypeEnum.CUSTOMER);
            } else {
                LOGGER.info("\u3010\u81ea\u52a8\u7b56\u7565\u3011\u8ba2\u5355\u53f7={}\uff0c\u5ef6\u8fdf\u5ba1\u6838\u65f6\u95f4\u672a\u5339\u914d\u5230", (Object)saleOrderRespDto.getSaleOrderNo());
                strategyConfItemEo = new StrategyConfItemEo();
                strategyConfItemEo.setRuleId(strategyRuleEo.getId());
                strategyConfItemEo.setContent("0");
                this.handleDelayAuditByConf(strategyConfItemEo, saleOrderRespDto, saleOrderRespDto.getSaleCreateTime(), DgCisStrategyOrderTypeEnum.CUSTOMER);
            }
            DgStrategyRuleServiceImpl.MatchStrategyResult matchStrategyResult4 = matchStrategyResult;
            return matchStrategyResult4;
        }
        finally {
            this.cleanHitStrategyOrder();
        }
    }

    private void extractedAttributeAssignment(List<DgStrategyRuleSuitEo> strategyRuleSuitList, DgStrategyRuleSuitEo dgStrategyRuleSuitEo, DgCustomerAuditStrategyRuleRespDto.Apply apply) {
        apply.setApplicableType(dgStrategyRuleSuitEo.getSuitSelectType());
        if (StringUtils.equals((CharSequence)dgStrategyRuleSuitEo.getSuitSelectType(), (CharSequence)SELECT)) {
            List shopCodeList = strategyRuleSuitList.stream().map(DgStrategyRuleSuitEo::getSuitKey).collect(Collectors.toList());
            apply.setApplicableList(shopCodeList);
        }
    }

    private void getStrategyConfItems(Long id, DgCustomerAuditStrategyRuleRespDto strategyRuleRespDto) {
        LambdaQueryWrapper queryStrategyConfItemEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyConfItemEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemEo::getRuleId, (Object)id);
        List strategyConfItemEoList = this.dgStrategyConfItemDomain.list(queryStrategyConfItemEo);
        AssertUtils.notEmpty((Collection)strategyConfItemEoList, (String)"\u7b56\u7565\u914d\u7f6e\u9879\u4e3a\u7a7a");
        LambdaQueryWrapper queryStrategyConfItemSuitEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyConfItemSuitEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemSuitEo::getRuleId, (Object)id);
        List strategyConfItemSuitEoList = this.strategyConfItemSuitDas.list(queryStrategyConfItemSuitEo);
        Map<String, List<StrategyConfItemSuitEo>> strategyConfItemSuitMap = Optional.ofNullable(strategyConfItemSuitEoList).orElseGet(Collections::emptyList).stream().collect(Collectors.groupingBy(StrategyConfItemSuitEo::getSuitType));
        for (StrategyConfItemEo strategyConfItemEo : strategyConfItemEoList) {
            List codeList;
            DgCustomerAuditStrategyRuleRespDto.SpecialCustomer specialCustomer;
            Map map;
            String content2;
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.AUTO_SPLIT.getCode())) {
                strategyRuleRespDto.setAutoSplit(strategyConfItemEo.getEnable());
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.NEEDLESS_PERSON_AUDIT.getCode())) {
                strategyRuleRespDto.setNeedlessPersonAudit(strategyConfItemEo.getEnable());
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.DELAY_AUDIT.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.DelayAudit delayAudit = new DgCustomerAuditStrategyRuleRespDto.DelayAudit();
                CubeBeanUtils.copyProperties((Object)delayAudit, (Object)strategyConfItemEo, (String[])new String[0]);
                delayAudit.setContent(strategyConfItemEo.getContent());
                content2 = strategyConfItemEo.getContent();
                if (StringUtils.isNotBlank((CharSequence)content2)) {
                    map = (HashMap)JSON.parseObject((String)content2, HashMap.class);
                    delayAudit.setTimeType(Integer.valueOf(Integer.parseInt(((HashMap)map).get("timeType").toString())));
                    delayAudit.setValue(Integer.valueOf(Integer.parseInt(((HashMap)map).get("value").toString())));
                }
                strategyRuleRespDto.setDelayAudit(delayAudit);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.AUTO_DISTRIBUTION.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.AutoDistribution autoDistribution = new DgCustomerAuditStrategyRuleRespDto.AutoDistribution();
                CubeBeanUtils.copyProperties((Object)autoDistribution, (Object)strategyConfItemEo, (String[])new String[0]);
                autoDistribution.setContent(strategyConfItemEo.getContent());
                content2 = strategyConfItemEo.getContent();
                if (StringUtils.isNotBlank((CharSequence)content2)) {
                    map = (HashMap)JSON.parseObject((String)content2, HashMap.class);
                    autoDistribution.setType(Integer.valueOf(Integer.parseInt(((HashMap)map).get("type").toString())));
                    autoDistribution.setValue(Integer.valueOf(Integer.parseInt(((HashMap)map).get("value").toString())));
                    if (Objects.nonNull(((HashMap)map).get("timeArray"))) {
                        autoDistribution.setTimeArray(JSON.parseArray((String)((HashMap)map).get("timeArray").toString(), String.class));
                    } else {
                        autoDistribution.setTimeArray(new ArrayList());
                    }
                }
                strategyRuleRespDto.setAutoDistribution(autoDistribution);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.SPECIAL_AMOUNT.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.SpecialAmount specialAmount = new DgCustomerAuditStrategyRuleRespDto.SpecialAmount();
                CubeBeanUtils.copyProperties((Object)specialAmount, (Object)strategyConfItemEo, (String[])new String[0]);
                Optional.ofNullable(strategyConfItemEo.getContent()).ifPresent(content -> {
                    Map map = (Map)JSON.parseObject((String)content, Map.class);
                    if (StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)map, (Object)"minAmount"))) {
                        specialAmount.setMinAmount(new BigDecimal(MapUtils.getString((Map)map, (Object)"minAmount")));
                    }
                    if (StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)map, (Object)"maxAmount"))) {
                        specialAmount.setMaxAmount(new BigDecimal(MapUtils.getString((Map)map, (Object)"maxAmount")));
                    }
                });
                strategyRuleRespDto.setSpecialAmount(specialAmount);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.SpecialOrderType specialOrderType = new DgCustomerAuditStrategyRuleRespDto.SpecialOrderType();
                specialOrderType.setEnable(strategyConfItemEo.getEnable());
                List orderTypeCodeList = Optional.ofNullable(strategyConfItemSuitMap.get(DgStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                specialOrderType.setOrderTypeCodeList(orderTypeCodeList);
                strategyRuleRespDto.setSpecialOrderType(specialOrderType);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.SPECIAL_LABEL.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.SpecialLabel specialLabel = new DgCustomerAuditStrategyRuleRespDto.SpecialLabel();
                specialLabel.setEnable(strategyConfItemEo.getEnable());
                List specialLabelCodeList = Optional.ofNullable(strategyConfItemSuitMap.get(DgStrategyConfItemTypeEnum.SPECIAL_LABEL.getCode())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                specialLabel.setLabelCodeList(specialLabelCodeList);
                strategyRuleRespDto.setSpecialLabel(specialLabel);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.SPECIAL_CUSTOMER.getCode())) {
                specialCustomer = new DgCustomerAuditStrategyRuleRespDto.SpecialCustomer();
                specialCustomer.setEnable(strategyConfItemEo.getEnable());
                List specialCustomerList = Optional.ofNullable(strategyConfItemSuitMap.get(DgStrategyConfItemTypeEnum.SPECIAL_CUSTOMER.getCode())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                specialCustomer.setCustomerCodeList(specialCustomerList);
                strategyRuleRespDto.setSpecialCustomer(specialCustomer);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.SPECIAL_WAREHOUSE.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.SpecialWarehouse specialWarehouse = new DgCustomerAuditStrategyRuleRespDto.SpecialWarehouse();
                specialWarehouse.setEnable(strategyConfItemEo.getEnable());
                List warehouseCodeList = Optional.ofNullable(strategyConfItemSuitMap.get(DgStrategyConfItemTypeEnum.SPECIAL_WAREHOUSE.getCode())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                specialWarehouse.setWarehouseCodeList(warehouseCodeList);
                strategyRuleRespDto.setSpecialWarehouse(specialWarehouse);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.SPECIAL_SKU.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.SpecialSku specialSku = new DgCustomerAuditStrategyRuleRespDto.SpecialSku();
                specialSku.setEnable(strategyConfItemEo.getEnable());
                specialSku.setContent(Optional.ofNullable(strategyConfItemEo.getContent()).orElse(""));
                specialSku.setApplicableType(Optional.ofNullable(strategyConfItemEo.getContent()).orElse(""));
                List skuCodeList = Optional.ofNullable(strategyConfItemSuitMap.get(DgStrategyConfItemTypeEnum.SPECIAL_SKU.getCode())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                specialSku.setSkuCodeList(skuCodeList);
                strategyRuleRespDto.setSpecialSku(specialSku);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.SPECIAL_AREA.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.SpecialArea specialArea = new DgCustomerAuditStrategyRuleRespDto.SpecialArea();
                specialArea.setEnable(strategyConfItemEo.getEnable());
                List areaCodeList = Optional.ofNullable(strategyConfItemSuitMap.get(DgStrategyConfItemTypeEnum.SPECIAL_AREA.getCode())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                specialArea.setAreaCodeList(areaCodeList);
                strategyRuleRespDto.setSpecialArea(specialArea);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.BUYER_REMARK.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.BuyerRemark buyerRemark = new DgCustomerAuditStrategyRuleRespDto.BuyerRemark();
                CubeBeanUtils.copyProperties((Object)buyerRemark, (Object)strategyConfItemEo, (String[])new String[0]);
                content2 = strategyConfItemEo.getContent();
                map = (Map)JSON.parseObject((String)content2, Map.class);
                buyerRemark.setRemarkType(MapUtils.getString((Map)map, (Object)"remarkType", (String)"0"));
                buyerRemark.setKeyWords(MapUtils.getString((Map)map, (Object)"keyWords"));
                strategyRuleRespDto.setBuyerRemark(buyerRemark);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.SELLER_REMARK.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.SellerRemark sellerRemark = new DgCustomerAuditStrategyRuleRespDto.SellerRemark();
                CubeBeanUtils.copyProperties((Object)sellerRemark, (Object)strategyConfItemEo, (String[])new String[0]);
                content2 = strategyConfItemEo.getContent();
                map = (Map)JSON.parseObject((String)content2, Map.class);
                sellerRemark.setRemarkType(MapUtils.getString((Map)map, (Object)"remarkType", (String)"0"));
                sellerRemark.setKeyWords(MapUtils.getString((Map)map, (Object)"keyWords"));
                strategyRuleRespDto.setSellerRemark(sellerRemark);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.INTERNAL_REMARK.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.InternalRemark internalRemark = new DgCustomerAuditStrategyRuleRespDto.InternalRemark();
                CubeBeanUtils.copyProperties((Object)internalRemark, (Object)strategyConfItemEo, (String[])new String[0]);
                content2 = strategyConfItemEo.getContent();
                map = (Map)JSON.parseObject((String)content2, Map.class);
                internalRemark.setRemarkType(MapUtils.getString((Map)map, (Object)"remarkType", (String)"0"));
                internalRemark.setKeyWords(MapUtils.getString((Map)map, (Object)"keyWords"));
                strategyRuleRespDto.setInternalRemark(internalRemark);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.SPECIAL_PAYTIME.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.SpecialPayTime specialPayTime = new DgCustomerAuditStrategyRuleRespDto.SpecialPayTime();
                specialPayTime.setEnable(strategyConfItemEo.getEnable());
                Optional.ofNullable(strategyConfItemEo.getContent()).ifPresent(content -> {
                    Map map = (Map)JSON.parseObject((String)content, Map.class);
                    if (StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)map, (Object)"startTime"))) {
                        specialPayTime.setStartTime(DateUtil.parse((String)MapUtils.getString((Map)map, (Object)"startTime"), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    if (StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)map, (Object)"endTime"))) {
                        specialPayTime.setEndTime(DateUtil.parse((String)MapUtils.getString((Map)map, (Object)"endTime"), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                });
                strategyRuleRespDto.setSpecialPayTime(specialPayTime);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.APPOINT_PERSON_AUDIT.getCode())) {
                strategyRuleRespDto.setAppointPersonAudit(strategyConfItemEo.getEnable());
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.APPOINT_AUDIT_NO_PASS.getCode())) {
                strategyRuleRespDto.setAppointAuditNoPass(strategyConfItemEo.getEnable());
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.APPOINT_PERSON_CUSTOMER.getCode())) {
                specialCustomer = new DgCustomerAuditStrategyRuleRespDto.SpecialCustomer();
                CubeBeanUtils.copyProperties((Object)specialCustomer, (Object)strategyConfItemEo, (String[])new String[0]);
                specialCustomer.setEnable(strategyConfItemEo.getEnable());
                codeList = Optional.ofNullable(strategyConfItemSuitMap.get(DgStrategyConfItemTypeEnum.APPOINT_PERSON_CUSTOMER.getCode())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                specialCustomer.setCustomerCodeList(codeList);
                strategyRuleRespDto.setSpecialPersonCustomer(specialCustomer);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.APPOINT_AUDIT_NO_PASS_CUSTOMER.getCode())) {
                specialCustomer = new DgCustomerAuditStrategyRuleRespDto.SpecialCustomer();
                CubeBeanUtils.copyProperties((Object)specialCustomer, (Object)strategyConfItemEo, (String[])new String[0]);
                specialCustomer.setEnable(strategyConfItemEo.getEnable());
                codeList = Optional.ofNullable(strategyConfItemSuitMap.get(DgStrategyConfItemTypeEnum.APPOINT_AUDIT_NO_PASS_CUSTOMER.getCode())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                specialCustomer.setCustomerCodeList(codeList);
                strategyRuleRespDto.setSpecialNoPassCustomer(specialCustomer);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.APPOINT_PERSON_ITEM_TAG.getCode())) {
                specialCustomer = new DgCustomerAuditStrategyRuleRespDto.SpecialItemTag();
                CubeBeanUtils.copyProperties((Object)specialCustomer, (Object)strategyConfItemEo, (String[])new String[0]);
                specialCustomer.setEnable(strategyConfItemEo.getEnable());
                codeList = Optional.ofNullable(strategyConfItemSuitMap.get(DgStrategyConfItemTypeEnum.APPOINT_PERSON_ITEM_TAG.getCode())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                specialCustomer.setCodeList(codeList);
                strategyRuleRespDto.setSpecialPersonItemTag((DgCustomerAuditStrategyRuleRespDto.SpecialItemTag)specialCustomer);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.APPOINT_AUDIT_NO_PASS_ITEM_TAG.getCode())) {
                specialCustomer = new DgCustomerAuditStrategyRuleRespDto.SpecialItemTag();
                CubeBeanUtils.copyProperties((Object)specialCustomer, (Object)strategyConfItemEo, (String[])new String[0]);
                specialCustomer.setEnable(strategyConfItemEo.getEnable());
                codeList = Optional.ofNullable(strategyConfItemSuitMap.get(DgStrategyConfItemTypeEnum.APPOINT_AUDIT_NO_PASS_ITEM_TAG.getCode())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                specialCustomer.setCodeList(codeList);
                strategyRuleRespDto.setSpecialNoPassItemTag((DgCustomerAuditStrategyRuleRespDto.SpecialItemTag)specialCustomer);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.INSTALLATION_VERIFICATION_STRATEGY.getCode())) {
                strategyRuleRespDto.setInstallationVerificationStrategy(strategyConfItemEo.getEnable());
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.AUTOMATIC_PUSH_INSTALLATION.getCode())) {
                strategyRuleRespDto.setAutomaticPushInstallation(strategyConfItemEo.getEnable());
                continue;
            }
            if (!StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.ORDER_NUMBER_JUDGMENT.getCode())) continue;
            DgCustomerAuditStrategyRuleRespDto.OrderNumberJudgment orderNumberJudgment = new DgCustomerAuditStrategyRuleRespDto.OrderNumberJudgment();
            CubeBeanUtils.copyProperties((Object)orderNumberJudgment, (Object)strategyConfItemEo, (String[])new String[0]);
            orderNumberJudgment.setContent(strategyConfItemEo.getContent());
            content2 = strategyConfItemEo.getContent();
            if (StringUtils.isNotBlank((CharSequence)content2)) {
                map = (HashMap)JSON.parseObject((String)content2, HashMap.class);
                orderNumberJudgment.setValue(Integer.valueOf(Integer.parseInt(((HashMap)map).get("value").toString())));
            }
            strategyRuleRespDto.setOrderNumberJudgment(orderNumberJudgment);
        }
    }

    public String getLatestNo() {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderWrapper.eq(DgStrategyRuleEo::getStrategyType, (Object)DgCisStrategyOrderTypeEnum.CUSTOMER.getCode())).orderByDesc(BaseEo::getId)).orderByDesc(BaseEo::getCreateTime)).last(" limit 1");
        DgStrategyRuleEo dgStrategyRuleEo = this.strategyRuleDas.getOne(queryOrderWrapper);
        if (dgStrategyRuleEo == null) {
            return "";
        }
        return dgStrategyRuleEo.getRuleCode();
    }

    @Override
    public DgCustomerAuditStrategyRuleRespDto queryByRuleCode(String code) {
        DgCustomerAuditStrategyRuleRespDto dgCustomerAuditStrategyRuleRespDto = new DgCustomerAuditStrategyRuleRespDto();
        try {
            LambdaQueryWrapper queryStrategyRuleEo = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryStrategyRuleEo.eq(BaseEo::getDr, (Object)0)).eq(DgStrategyRuleEo::getStrategyType, (Object)code);
            DgStrategyRuleEo dgStrategyRuleEo = this.strategyRuleDas.getOne(queryStrategyRuleEo);
            AssertUtils.notNull((Object)dgStrategyRuleEo, (String)"\u67e5\u8be2\u7b56\u7565\u4e3a\u7a7a\u8bf7\u6838\u5b9e");
            Long id = dgStrategyRuleEo.getId();
            dgCustomerAuditStrategyRuleRespDto = this.queryCustomerAuditStrategyById(id);
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u7b56\u7565\u62a5\u9519", (Throwable)e);
        }
        return dgCustomerAuditStrategyRuleRespDto;
    }

    @Override
    public boolean verifyOrderInstallStrategy(DgCustomerAuditStrategyRuleRespDto dgCustomerAuditStrategyRuleRespDto, String shopCode) {
        List applicableList;
        boolean action = false;
        DgCustomerAuditStrategyRuleRespDto.ApplyShop applyShop = dgCustomerAuditStrategyRuleRespDto.getApplyShop();
        if (applyShop.getApplicableType().equals("ALL")) {
            action = true;
        }
        if (applyShop.getApplicableType().equals("SELECT") && (applicableList = applyShop.getApplicableList()).contains(shopCode)) {
            action = true;
        }
        return action;
    }
}

