/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.orderStrategy.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.data.dto.DictDto;
import com.yunxi.dg.base.center.data.dto.DictValueDto;
import com.yunxi.dg.base.center.data.proxy.api.IDictQueryApiProxy;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgPlatFormEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyConfItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyRuleSuitTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfItemSuitDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfirmReceiptDetailDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfirmReceiptRuleDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleSuitDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IResetRedisNoIndexCommon;
import com.yunxi.dg.base.center.trade.dto.strategy.DgReceiveStrategyRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyConfirmReceiptRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyConfirmReceiptRuleRespDto;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleEo;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleSuitEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemSuitEo;
import com.yunxi.dg.base.center.trade.service.orderConfig.IDgOrderTypeService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgStrategyConfirmReceiptRuleService;
import com.yunxi.dg.base.center.trade.utils.NoGreateInUtil;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgStrategyConfirmReceiptRuleServiceImpl
implements IDgStrategyConfirmReceiptRuleService,
IResetRedisNoIndexCommon {
    @Resource
    private IDgStrategyConfirmReceiptRuleDomain strategyConfirmReceiptRuleDomain;
    @Resource
    private IDgStrategyConfirmReceiptDetailDomain strategyConfirmReceiptDetailDomain;
    @Resource
    private IDgOrderTypeService iDgOrderTypeService;
    @Resource
    private NoGreateInUtil noGreateInUtil;
    @Resource
    private IDgStrategyRuleDomain dgStrategyRuleDomain;
    @Resource
    private IDgStrategyConfItemDomain dgStrategyConfItemDomain;
    @Resource
    private IDgStrategyConfItemSuitDomain dgStrategyConfItemSuitDomain;
    @Resource
    private IDictQueryApiProxy dictQueryApiProxy;
    @Resource
    private IDgStrategyRuleSuitDomain dgStrategyRuleSuitDomain;

    @Override
    public Long addStrategyConfirmReceiptRule(DgStrategyConfirmReceiptRuleReqDto addReqDto) {
        this.checkRule(addReqDto);
        RestResponse dictDtoRestResponse = this.dictQueryApiProxy.queryByGroupCodeAndCodeAndStatus("toB_order_type", "toB_order_type", Integer.valueOf(1));
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)dictDtoRestResponse);
        List dictValueList = dictDto.getDictValueList();
        Map<String, String> orderTypeMap = dictValueList.stream().collect(Collectors.toMap(DictValueDto::getValue, DictValueDto::getLabel, (e1, e2) -> e1));
        DgStrategyRuleEo dgStrategyRuleEo = new DgStrategyRuleEo();
        CubeBeanUtils.copyProperties((Object)dgStrategyRuleEo, (Object)addReqDto, (String[])new String[0]);
        String code = DgCisStrategyOrderTypeEnum.CONFIRM_RECEIPT_STRATEGY.getCode();
        dgStrategyRuleEo.setStrategyType(code);
        dgStrategyRuleEo.setPriority(Integer.valueOf(0));
        dgStrategyRuleEo.setRuleCode(this.noGreateInUtil.confirmReceiptStrategyRuleNo());
        dgStrategyRuleEo.setPlatForm(DgPlatFormEnum.PLATFORM_2B.getCode());
        this.dgStrategyRuleDomain.insert((BaseEo)dgStrategyRuleEo);
        Long id = dgStrategyRuleEo.getId();
        DgReceiveStrategyRuleReqDto.DetermineDeliveryTime deliveryTime = new DgReceiveStrategyRuleReqDto.DetermineDeliveryTime(addReqDto.getConfirmReceiptDay());
        deliveryTime.setRuleId(id);
        ArrayList<StrategyConfItemEo> strategyConfItemEos = new ArrayList<StrategyConfItemEo>();
        StrategyConfItemEo deliveryTimeEo = new StrategyConfItemEo();
        CubeBeanUtils.copyProperties((Object)deliveryTimeEo, (Object)deliveryTime, (String[])new String[0]);
        strategyConfItemEos.add(deliveryTimeEo);
        DgReceiveStrategyRuleReqDto.ReceiveStrategyChannel receiveStrategyChannel = new DgReceiveStrategyRuleReqDto.ReceiveStrategyChannel(addReqDto.getOrderChannelCode(), addReqDto.getOrderChannelName());
        receiveStrategyChannel.setRuleId(id);
        StrategyConfItemEo receiveStrategyChannelEo = new StrategyConfItemEo();
        CubeBeanUtils.copyProperties((Object)receiveStrategyChannelEo, (Object)receiveStrategyChannel, (String[])new String[0]);
        receiveStrategyChannelEo.setExtension(addReqDto.getOrderChannelCode());
        receiveStrategyChannelEo.setExtension1(addReqDto.getOrderChannelName());
        strategyConfItemEos.add(receiveStrategyChannelEo);
        DgStrategyRuleSuitEo dgStrategyRuleSuitEo = new DgStrategyRuleSuitEo();
        dgStrategyRuleSuitEo.setRuleId(id);
        dgStrategyRuleSuitEo.setSuitMatchCode(DgStrategyRuleSuitTypeEnum.SUITTYPE_ALL.getCode() + "_ALL");
        dgStrategyRuleSuitEo.setSuitKey("ALL");
        dgStrategyRuleSuitEo.setSuitType(DgStrategyRuleSuitTypeEnum.SUITTYPE_ALL.getCode());
        dgStrategyRuleSuitEo.setSuitSelectType("ALL");
        dgStrategyRuleSuitEo.setStrategyType(DgCisStrategyOrderTypeEnum.CONFIRM_RECEIPT_STRATEGY.getCode());
        dgStrategyRuleSuitEo.setMd5("1");
        this.dgStrategyRuleSuitDomain.insert((BaseEo)dgStrategyRuleSuitEo);
        List orderTypeCodeList = addReqDto.getOrderTypeCodeList();
        ArrayList strategyConfItemSuitEoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)orderTypeCodeList)) {
            DgReceiveStrategyRuleReqDto.ReceiveStrategyOrderType receiveStrategyOrderType = new DgReceiveStrategyRuleReqDto.ReceiveStrategyOrderType();
            receiveStrategyOrderType.setRuleId(id);
            StrategyConfItemEo receiveStrategyOrderTypeEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)receiveStrategyOrderTypeEo, (Object)receiveStrategyOrderType, (String[])new String[0]);
            strategyConfItemEos.add(receiveStrategyOrderTypeEo);
            for (String orderType : orderTypeCodeList) {
                StrategyConfItemSuitEo confItemSuitEo = new StrategyConfItemSuitEo();
                confItemSuitEo.setRuleId(dgStrategyRuleEo.getId());
                confItemSuitEo.setSuitType(DgStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode());
                confItemSuitEo.setSuitValue(orderType);
                confItemSuitEo.setSuitMatchCode(DgStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode() + "_" + orderType);
                confItemSuitEo.setExtension(orderTypeMap.get(orderType));
                strategyConfItemSuitEoList.add(confItemSuitEo);
            }
        }
        this.dgStrategyConfItemDomain.insertBatch(strategyConfItemEos);
        this.dgStrategyConfItemSuitDomain.insertBatch((List)strategyConfItemSuitEoList);
        return id;
    }

    private void checkRule(DgStrategyConfirmReceiptRuleReqDto reqDto) {
        List strategyRuleList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgStrategyRuleDomain.filter().eq((Object)"strategy_type", (Object)DgCisStrategyOrderTypeEnum.CONFIRM_RECEIPT_STRATEGY.getCode())).eq((Object)"plat_form", (Object)DgPlatFormEnum.PLATFORM_2B.getCode())).list();
        List collect = strategyRuleList.stream().map(BaseEo::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return;
        }
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgStrategyConfItemDomain.filter().eq((Object)"strategy_type", (Object)DgStrategyConfItemTypeEnum.ADAPTATION_CHANNEL.getCode())).in((Object)"rule_id", collect)).eq((Object)"dr", (Object)0)).eq((Object)"extension", (Object)reqDto.getOrderChannelCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List ruleId = list.stream().map(StrategyConfItemEo::getRuleId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(ruleId)) {
                ruleId.remove(reqDto.getId());
            }
            if (ruleId.isEmpty()) {
                return;
            }
            List StrategyConfItemSuitEoList = ((ExtQueryChainWrapper)this.dgStrategyConfItemSuitDomain.filter().in((Object)"rule_id", ruleId)).list();
            Map<String, String> map = StrategyConfItemSuitEoList.stream().filter(e -> e.getExtension() != null).collect(Collectors.toMap(StrategyConfItemSuitEo::getSuitValue, StrategyConfItemSuitEo::getExtension, (e1, e2) -> e1));
            Set<String> keySet = map.keySet();
            List intersection = (List)CollectionUtils.intersection((Collection)reqDto.getOrderTypeCodeList(), new ArrayList<String>(keySet));
            if (CollectionUtils.isNotEmpty((Collection)intersection)) {
                ArrayList<String> result = new ArrayList<String>();
                for (String s : intersection) {
                    String orderTypeName = map.get(s);
                    result.add(orderTypeName);
                }
                throw new BizException("\u8be5\u6e20\u9053\u8ba2\u5355\u7b56\u7565\u5df2\u7ecf\u5b58\u5728:" + reqDto.getOrderChannelName() + ",\u8ba2\u5355\u7c7b\u578b\u4e3a:" + result.toString());
            }
        }
    }

    @Override
    public void modifyStrategyConfirmReceiptRule(DgStrategyConfirmReceiptRuleReqDto modifyReqDto) {
        this.checkRule(modifyReqDto);
        DgStrategyRuleEo dgStrategyRuleEo = new DgStrategyRuleEo();
        CubeBeanUtils.copyProperties((Object)dgStrategyRuleEo, (Object)modifyReqDto, (String[])new String[0]);
        this.dgStrategyRuleDomain.updateSelective((BaseEo)dgStrategyRuleEo);
        RestResponse dictDtoRestResponse = this.dictQueryApiProxy.queryByGroupCodeAndCodeAndStatus("toB_order_type", "toB_order_type", Integer.valueOf(1));
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)dictDtoRestResponse);
        List dictValueList = dictDto.getDictValueList();
        Map<String, String> orderTypeMap = dictValueList.stream().collect(Collectors.toMap(DictValueDto::getValue, DictValueDto::getLabel, (e1, e2) -> e1));
        StrategyConfItemEo queryEo = new StrategyConfItemEo();
        queryEo.setRuleId(modifyReqDto.getId());
        List strategyConfItemEos = this.dgStrategyConfItemDomain.selectList((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(1000));
        Map confItemEoMap = strategyConfItemEos.stream().collect(Collectors.toMap(StrategyConfItemEo::getStrategyType, Function.identity()));
        confItemEoMap.forEach((k, v) -> {
            if (k.equals(DgStrategyConfItemTypeEnum.TIME_LIMIT.getCode())) {
                DgReceiveStrategyRuleReqDto.DetermineDeliveryTime deliveryTime = new DgReceiveStrategyRuleReqDto.DetermineDeliveryTime(modifyReqDto.getConfirmReceiptDay());
                CubeBeanUtils.copyProperties((Object)v, (Object)deliveryTime, (String[])new String[0]);
            }
            if (k.equals(DgStrategyConfItemTypeEnum.ADAPTATION_CHANNEL.getCode())) {
                DgReceiveStrategyRuleReqDto.ReceiveStrategyChannel receiveStrategyChannel = new DgReceiveStrategyRuleReqDto.ReceiveStrategyChannel(modifyReqDto.getOrderChannelCode(), modifyReqDto.getOrderChannelName());
                CubeBeanUtils.copyProperties((Object)v, (Object)receiveStrategyChannel, (String[])new String[0]);
                v.setExtension(modifyReqDto.getOrderChannelCode());
                v.setExtension1(modifyReqDto.getOrderChannelName());
            }
        });
        Collection values = confItemEoMap.values();
        for (StrategyConfItemEo value : values) {
            this.dgStrategyConfItemDomain.updateSelective((BaseEo)value);
        }
        List orderTypeCodeList = modifyReqDto.getOrderTypeCodeList();
        ArrayList strategyConfItemSuitEoList = Lists.newArrayList();
        StrategyConfItemSuitEo confItemSuitEoDelete = new StrategyConfItemSuitEo();
        confItemSuitEoDelete.setRuleId(modifyReqDto.getId());
        this.dgStrategyConfItemSuitDomain.logicDelete((BaseEo)confItemSuitEoDelete);
        if (CollectionUtils.isNotEmpty((Collection)orderTypeCodeList)) {
            for (String orderType : orderTypeCodeList) {
                StrategyConfItemSuitEo confItemSuitEo = new StrategyConfItemSuitEo();
                confItemSuitEo.setRuleId(modifyReqDto.getId());
                confItemSuitEo.setSuitType(DgStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode());
                confItemSuitEo.setSuitValue(orderType);
                confItemSuitEo.setSuitMatchCode(DgStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode() + "_" + orderType);
                confItemSuitEo.setExtension(orderTypeMap.get(orderType));
                strategyConfItemSuitEoList.add(confItemSuitEo);
            }
        }
        this.dgStrategyConfItemSuitDomain.insertBatch((List)strategyConfItemSuitEoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStrategyConfirmReceiptRule(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            DgStrategyRuleEo dgStrategyRuleEo = (DgStrategyRuleEo)this.dgStrategyRuleDomain.selectByPrimaryKey(Long.valueOf(id));
            if (dgStrategyRuleEo.getRuleStatus() == 1) {
                throw new BizException("\u7b56\u7565\u4e3a\u542f\u52a8\u72b6\u6001,\u4e0d\u53ef\u4ee5\u5220\u9664");
            }
            this.dgStrategyRuleDomain.logicDeleteById(Long.valueOf(id));
            StrategyConfItemEo strategyConfItemEo = new StrategyConfItemEo();
            strategyConfItemEo.setRuleId(Long.valueOf(id));
            this.dgStrategyConfItemDomain.logicDelete((BaseEo)strategyConfItemEo);
            StrategyConfItemSuitEo strategyConfItemSuitEo = new StrategyConfItemSuitEo();
            strategyConfItemSuitEo.setRuleId(Long.valueOf(id));
            this.dgStrategyConfItemSuitDomain.logicDelete((BaseEo)strategyConfItemSuitEo);
        }
    }

    @Override
    public void updateStatus(String ids, Integer status) {
        List idList = Arrays.asList(ids.split(",")).stream().collect(Collectors.toList());
        this.dgStrategyRuleDomain.updateStatus(idList.stream().map(Long::valueOf).collect(Collectors.toList()), status);
    }

    @Override
    public DgStrategyConfirmReceiptRuleRespDto queryById(Long id) {
        DgStrategyConfirmReceiptRuleRespDto dgStrategyConfirmReceiptRuleRespDto = new DgStrategyConfirmReceiptRuleRespDto();
        DgStrategyRuleEo dgStrategyRuleEo = (DgStrategyRuleEo)this.dgStrategyRuleDomain.selectByPrimaryKey(id);
        dgStrategyConfirmReceiptRuleRespDto.setRuleStatus(dgStrategyRuleEo.getRuleStatus());
        StrategyConfItemEo strategyConfItemEo = new StrategyConfItemEo();
        strategyConfItemEo.setRuleId(dgStrategyRuleEo.getId());
        List strategyConfItemEos = this.dgStrategyConfItemDomain.selectList((BaseEo)strategyConfItemEo, Integer.valueOf(1), Integer.valueOf(1000));
        Map confItemEoMap = strategyConfItemEos.stream().collect(Collectors.toMap(StrategyConfItemEo::getStrategyType, Function.identity(), (e1, e2) -> e1));
        confItemEoMap.forEach((k, v) -> {
            if (k.equals("TIME_LIMIT")) {
                dgStrategyConfirmReceiptRuleRespDto.setConfirmReceiptDay(Integer.valueOf(v.getContent()));
            }
            if (k.equals("ADAPTATION_CHANNEL")) {
                String content = v.getContent();
                HashMap hashMap = (HashMap)JSON.parseObject((String)content, Map.class);
                hashMap.forEach((h, i) -> {
                    dgStrategyConfirmReceiptRuleRespDto.setOrderChannelName(String.valueOf(i));
                    dgStrategyConfirmReceiptRuleRespDto.setOrderChannelCode(String.valueOf(h));
                });
            }
        });
        StrategyConfItemSuitEo strategyConfItemSuitEo = new StrategyConfItemSuitEo();
        strategyConfItemSuitEo.setRuleId(dgStrategyRuleEo.getId());
        List strategyConfItemSuitEos = this.dgStrategyConfItemSuitDomain.selectList((BaseEo)strategyConfItemSuitEo, Integer.valueOf(1), Integer.valueOf(1000));
        List collect = strategyConfItemSuitEos.stream().filter(e -> null != e.getExtension()).map(StrategyConfItemSuitEo::getExtension).collect(Collectors.toList());
        List collectCode = strategyConfItemSuitEos.stream().filter(e -> null != e.getExtension()).map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            dgStrategyConfirmReceiptRuleRespDto.setOrderTypeName(collect.stream().collect(Collectors.joining(",")));
            dgStrategyConfirmReceiptRuleRespDto.setOrderTypeCode(collectCode.stream().collect(Collectors.joining(",")));
        }
        return dgStrategyConfirmReceiptRuleRespDto;
    }

    @Override
    public PageInfo<DgStrategyConfirmReceiptRuleRespDto> queryByPage(DgStrategyConfirmReceiptRuleReqDto reqDto, Integer pageNum, Integer pageSize) {
        return this.strategyConfirmReceiptRuleDomain.queryPage(reqDto, pageNum, pageSize);
    }

    @Override
    public List<DgStrategyConfirmReceiptRuleRespDto> queryByList(DgStrategyConfirmReceiptRuleReqDto reqDto) {
        return this.strategyConfirmReceiptRuleDomain.queryListNew(reqDto);
    }

    public String getLatestNo() {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderWrapper.eq(DgStrategyRuleEo::getStrategyType, (Object)"CONFIRM_RECEIPT_STRATEGY")).orderByDesc(BaseEo::getId)).orderByDesc(BaseEo::getCreateTime)).last(" limit 1");
        DgStrategyRuleEo dgStrategyRuleEo = this.dgStrategyRuleDomain.getOne(queryOrderWrapper);
        if (dgStrategyRuleEo == null) {
            return "";
        }
        return dgStrategyRuleEo.getRuleCode();
    }
}

