/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.orderStrategy.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.MD5Util;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordChangeRespDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordLinkPageReqDto;
import com.yunxi.dg.base.center.report.proxy.tag.IReBizTagRecordApiProxy;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.CisStrategyContentTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgLabelStrategyEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgPlatFormEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyLabelTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderAddrExtDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgStrategyRulePageReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderAddrRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderLabelStrategyQueryDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgLabelStrategyRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgLabelStrategyRuleRestDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyRuleRespDto;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemSuitEo;
import com.yunxi.dg.base.center.trade.service.oms.common.ICommonOrderQueryService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgLabelStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.impl.DgStrategyRuleServiceImpl;
import com.yunxi.dg.base.center.trade.service.orderStrategy.observer.EventStrategyListener;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateInUtil;
import com.yunxi.dg.base.center.trade.vo.DgLabelStrategyAdaptVo;
import com.yunxi.dg.base.center.trade.vo.DgLabelStrategyConfItemRangeVo;
import com.yunxi.dg.base.center.trade.vo.DgLabelStrategyConfItemSwitchVo;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IDgLabelStrategyRuleServiceImpl
extends DgStrategyRuleServiceImpl
implements IDgLabelStrategyRuleService {
    private static Logger logger = LoggerFactory.getLogger(IDgLabelStrategyRuleServiceImpl.class);
    @Resource
    private NoGreateInUtil noGreateInUtil;
    @Resource
    private IDgStrategyRuleDomain strategyRuleDomain;
    @Resource
    private EventStrategyListener eventStrategyListener;
    @Resource
    private IDgPerformOrderAddrExtDomain dgSaleOrderAddrDomain;
    @Resource
    private IDgPerformOrderItemDomain dgPerformOrderItemDomain;
    @Resource
    private ICommonOrderQueryService commonOrderQueryService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IReBizTagRecordApiProxy iReBizTagRecordApiProxy;

    @Override
    public Long addOrderLabelStrategyRule(DgLabelStrategyRuleReqDto addReqDto) {
        if (Objects.isNull(addReqDto.getPeriodicEnd()) || Objects.isNull(addReqDto.getPeriodicStart())) {
            throw new BizException("\u5468\u671f\u5f00\u59cb\u65f6\u95f4\u548c\u5468\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == addReqDto.getLabelCode() || null == addReqDto.getPlatForm()) {
            throw new BizException("\u6807\u7b7e\u7f16\u7801||\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.checkUniqueRuleName(addReqDto);
        DgStrategyRuleEo dgStrategyRuleEo = new DgStrategyRuleEo();
        CubeBeanUtils.copyProperties((Object)dgStrategyRuleEo, (Object)addReqDto, (String[])new String[0]);
        if (addReqDto.getPlatForm().equals(DgPlatFormEnum.PLATFORM_2B.getCode())) {
            dgStrategyRuleEo.setRuleCode(this.noGreateInUtil.generateLabelNo("OLB"));
        } else {
            dgStrategyRuleEo.setRuleCode(this.noGreateInUtil.generateLabelNo("OLC"));
        }
        dgStrategyRuleEo.setStrategyType(DgCisStrategyOrderTypeEnum.LABEL.getCode());
        this.strategyRuleDomain.insert((BaseEo)dgStrategyRuleEo);
        ArrayList confItemEoList = Lists.newArrayList();
        ArrayList strategyConfItemSuitEoList = Lists.newArrayList();
        this.extractedDealInsertData(addReqDto, dgStrategyRuleEo, confItemEoList, strategyConfItemSuitEoList);
        this.dgStrategyConfItemDomain.insertBatch((List)confItemEoList);
        this.dgStrategyConfItemSuitDomain.insertBatch((List)strategyConfItemSuitEoList);
        try {
            this.eventStrategyListener.handle();
        }
        catch (Exception e) {
            logger.info("\u66f4\u65b0\u81ea\u52a8\u6807\u7b7e\u6d4b\u8bd5\u7f13\u5b58\u5931\u8d25");
            e.printStackTrace();
        }
        return dgStrategyRuleEo.getId();
    }

    private void checkUniqueRuleName(DgLabelStrategyRuleReqDto addReqDto) {
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.strategyRuleDomain.filter().eq(StringUtils.isNotEmpty((CharSequence)addReqDto.getRuleName()), (Object)"rule_name", (Object)addReqDto.getRuleName())).eq(StringUtils.isNotEmpty((CharSequence)addReqDto.getPlatForm()), (Object)"plat_form", (Object)addReqDto.getPlatForm())).eq(StringUtils.isNotEmpty((CharSequence)addReqDto.getStrategyType()), (Object)"strategy_type", (Object)addReqDto.getStrategyType())).ne(Objects.nonNull(addReqDto.getId()), (Object)"id", (Object)addReqDto.getId())).list(Integer.valueOf(1));
        if (list.size() >= 1) {
            throw new BizException("\u89c4\u5219\u540d\u79f0\u5df2\u91cd\u590d\u8bf7\u6838\u5b9e");
        }
    }

    @Override
    public void modifyOrderLabelStrategyRule(DgLabelStrategyRuleReqDto modifyReqDto) {
        AssertUtils.notNull((Object)modifyReqDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkUniqueRuleName(modifyReqDto);
        DgStrategyRuleEo newDgStrategyRuleEo = new DgStrategyRuleEo();
        CubeBeanUtils.copyProperties((Object)newDgStrategyRuleEo, (Object)modifyReqDto, (String[])new String[0]);
        this.strategyRuleDomain.updateSelective((BaseEo)newDgStrategyRuleEo);
        this.modifyStrategyConfItems(modifyReqDto);
        try {
            this.eventStrategyListener.handle();
        }
        catch (Exception e) {
            logger.info("\u66f4\u65b0\u81ea\u52a8\u6807\u7b7e\u6d4b\u8bd5\u7f13\u5b58\u5931\u8d25");
            e.printStackTrace();
        }
    }

    private void modifyStrategyConfItems(DgLabelStrategyRuleReqDto modifyReqDto) {
        LambdaQueryWrapper queryStrategyConfItemEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyConfItemEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemEo::getRuleId, (Object)modifyReqDto.getId());
        List strategyConfItemEoList = this.dgStrategyConfItemDomain.list(queryStrategyConfItemEo);
        Map<String, StrategyConfItemEo> groupStrategyMap = strategyConfItemEoList.stream().collect(Collectors.toMap(StrategyConfItemEo::getStrategyType, Function.identity(), (v1, v2) -> v2));
        this.extractedDealModifyData(modifyReqDto, groupStrategyMap);
    }

    private void extractedDealModifyData(DgLabelStrategyRuleReqDto modifyReqDto, Map<String, StrategyConfItemEo> groupStrategyMap) {
        Map keyMap = DgStrategyLabelTypeEnum.NAME_LOOKUP;
        Set<String> keySet = groupStrategyMap.keySet();
        try {
            Field[] fields;
            Long id = modifyReqDto.getId();
            Class<DgLabelStrategyRuleReqDto> clazz = DgLabelStrategyRuleReqDto.class;
            for (Field field : fields = clazz.getDeclaredFields()) {
                DgLabelStrategyRuleReqDto.SpecialList specialList;
                String name = field.getName();
                field.setAccessible(true);
                DgStrategyLabelTypeEnum dgStrategyLabelTypeEnum = (DgStrategyLabelTypeEnum)keyMap.get(name);
                String code = dgStrategyLabelTypeEnum.getCode();
                String desc = dgStrategyLabelTypeEnum.getDesc();
                if (dgStrategyLabelTypeEnum.getType().equals("list")) {
                    specialList = (DgLabelStrategyRuleReqDto.SpecialList)field.get(modifyReqDto);
                    this.extractedModify(modifyReqDto.getId(), groupStrategyMap, dgStrategyLabelTypeEnum, code, desc, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialList, id);
                    if (null == specialList && keySet.contains(code)) {
                        this.extractedDelete(id, code);
                    }
                }
                if (dgStrategyLabelTypeEnum.getType().equals("list_object")) {
                    DgLabelStrategyRuleReqDto.SpecialListType specialListType = (DgLabelStrategyRuleReqDto.SpecialListType)field.get(modifyReqDto);
                    this.extractedModify(modifyReqDto.getId(), groupStrategyMap, dgStrategyLabelTypeEnum, code, desc, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialListType, id);
                    if (null == specialListType && keySet.contains(code)) {
                        this.extractedDelete(id, code);
                    }
                }
                if (dgStrategyLabelTypeEnum.getType().equals("time_range")) {
                    specialList = (DgLabelStrategyRuleReqDto.SpecialTimeRange)field.get(modifyReqDto);
                    this.extractedModify(modifyReqDto.getId(), groupStrategyMap, dgStrategyLabelTypeEnum, code, desc, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialList, id);
                    if (null == specialList && keySet.contains(code)) {
                        this.extractedDelete(id, code);
                    }
                }
                if (dgStrategyLabelTypeEnum.getType().equals("amount_range")) {
                    specialList = (DgLabelStrategyRuleReqDto.SpecialAmountRange)field.get(modifyReqDto);
                    this.extractedModify(modifyReqDto.getId(), groupStrategyMap, dgStrategyLabelTypeEnum, code, desc, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialList, id);
                    if (null == specialList && keySet.contains(code)) {
                        this.extractedDelete(id, code);
                    }
                }
                if (dgStrategyLabelTypeEnum.getType().equals("remark")) {
                    specialList = (DgLabelStrategyRuleReqDto.ActionRemark)field.get(modifyReqDto);
                    this.extractedModify(modifyReqDto.getId(), groupStrategyMap, dgStrategyLabelTypeEnum, code, desc, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialList, id);
                    if (null == specialList && keySet.contains(code)) {
                        this.extractedDelete(id, code);
                    }
                }
                if (!dgStrategyLabelTypeEnum.getType().equals("string")) continue;
                specialList = (DgLabelStrategyRuleReqDto.SpecialString)field.get(modifyReqDto);
                this.extractedModify(modifyReqDto.getId(), groupStrategyMap, dgStrategyLabelTypeEnum, code, desc, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialList, id);
                if (null != specialList || !keySet.contains(code)) continue;
                this.extractedDelete(id, code);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void extractedDelete(Long id, String code) {
        StrategyConfItemEo strategyConfItemEo = new StrategyConfItemEo();
        strategyConfItemEo.setRuleId(id);
        strategyConfItemEo.setStrategyType(code);
        this.dgStrategyConfItemDomain.logicDelete((BaseEo)strategyConfItemEo);
        StrategyConfItemSuitEo strategyConfItemSuitEo = new StrategyConfItemSuitEo();
        strategyConfItemSuitEo.setRuleId(id);
        strategyConfItemSuitEo.setSuitType(code);
        this.dgStrategyConfItemSuitDomain.logicDelete((BaseEo)strategyConfItemSuitEo);
    }

    private void extractedModify(Long id, Map<String, StrategyConfItemEo> groupStrategyMap, DgStrategyLabelTypeEnum dgStrategyLabelTypeEnum, String code, String desc, DgLabelStrategyRuleReqDto.SpecialStrategy specialList, Long ids) {
        if (Objects.nonNull(specialList)) {
            StrategyConfItemEo orderType = groupStrategyMap.get(code);
            String orderMd5 = MD5Util.getMd5ByString((String)String.valueOf(specialList.getMd5()));
            if (orderType != null) {
                if (!StringUtils.equals((CharSequence)specialList.getMd5(), (CharSequence)orderMd5)) {
                    logger.info("\u3010\u4fee\u6539\u6807\u7b7e\u7b56\u7565\u3011+" + desc + "+\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)specialList);
                    StrategyConfItemEo confEo = new StrategyConfItemEo();
                    confEo.setId(orderType.getId());
                    confEo.setEnable(specialList.getEnable());
                    if (!dgStrategyLabelTypeEnum.getType().equals("list") || dgStrategyLabelTypeEnum.getType().equals("list_object")) {
                        confEo.setContent(specialList.getContent());
                    }
                    confEo.setMd5(orderMd5);
                    this.dgStrategyConfItemDomain.updateSelective((BaseEo)confEo);
                    if (dgStrategyLabelTypeEnum.getType().equals("list") || dgStrategyLabelTypeEnum.getType().equals("list_object")) {
                        StrategyConfItemSuitEo deleteEo = new StrategyConfItemSuitEo();
                        deleteEo.setRuleId(id);
                        deleteEo.setSuitType(code);
                        this.dgStrategyConfItemSuitDomain.logicDeleteByExample(deleteEo);
                        if (CollectionUtils.isNotEmpty((Collection)specialList.getCodeList())) {
                            ArrayList strategyConfItemSuitEoList = Lists.newArrayList();
                            for (String code1 : specialList.getCodeList()) {
                                StrategyConfItemSuitEo confItemSuitEo = new StrategyConfItemSuitEo();
                                confItemSuitEo.setRuleId(id);
                                confItemSuitEo.setSuitType(code);
                                confItemSuitEo.setSuitValue(code1);
                                confItemSuitEo.setSuitMatchCode(code + "_" + code1);
                                strategyConfItemSuitEoList.add(confItemSuitEo);
                            }
                            this.dgStrategyConfItemSuitDomain.insertBatch((List)strategyConfItemSuitEoList);
                        }
                    }
                }
            } else {
                StrategyConfItemEo confEo = new StrategyConfItemEo();
                CubeBeanUtils.copyProperties((Object)confEo, (Object)specialList, (String[])new String[0]);
                confEo.setRuleId(ids);
                confEo.setEnable(specialList.getEnable());
                confEo.setStrategyType(code);
                confEo.setStrategyTypeName(desc);
                confEo.setContentType(dgStrategyLabelTypeEnum.getType());
                if (StringUtils.isNotBlank((CharSequence)specialList.getContent())) {
                    confEo.setContent(specialList.getContent());
                }
                confEo.setMd5(orderMd5);
                this.dgStrategyConfItemDomain.insert((BaseEo)confEo);
                if (CollectionUtils.isNotEmpty((Collection)specialList.getCodeList())) {
                    ArrayList strategyConfItemSuitEoList = Lists.newArrayList();
                    for (String code1 : specialList.getCodeList()) {
                        StrategyConfItemSuitEo confItemSuitEo = new StrategyConfItemSuitEo();
                        confItemSuitEo.setRuleId(ids);
                        confItemSuitEo.setSuitType(code);
                        confItemSuitEo.setSuitValue(code1);
                        confItemSuitEo.setSuitMatchCode(code + "_" + code1);
                        strategyConfItemSuitEoList.add(confItemSuitEo);
                    }
                    this.dgStrategyConfItemSuitDomain.insertBatch((List)strategyConfItemSuitEoList);
                }
            }
        }
    }

    private void extractedDealInsertData(DgLabelStrategyRuleReqDto addReqDto, DgStrategyRuleEo dgStrategyRuleEo, List<StrategyConfItemEo> confItemEoList, List<StrategyConfItemSuitEo> strategyConfItemSuitEoList) {
        Map keyMap = DgStrategyLabelTypeEnum.NAME_LOOKUP;
        try {
            Field[] fields;
            Class<DgLabelStrategyRuleReqDto> clazz = DgLabelStrategyRuleReqDto.class;
            for (Field field : fields = clazz.getDeclaredFields()) {
                DgLabelStrategyRuleReqDto.SpecialListType specialListType;
                DgLabelStrategyRuleReqDto.SpecialList specialList;
                String name = field.getName();
                field.setAccessible(true);
                DgStrategyLabelTypeEnum dgStrategyLabelTypeEnum = (DgStrategyLabelTypeEnum)keyMap.get(name);
                if (!Objects.nonNull(dgStrategyLabelTypeEnum)) continue;
                String code = dgStrategyLabelTypeEnum.getCode();
                String desc = dgStrategyLabelTypeEnum.getDesc();
                if (dgStrategyLabelTypeEnum.getType().equals("list") && Objects.nonNull(specialList = (DgLabelStrategyRuleReqDto.SpecialList)field.get(addReqDto))) {
                    this.extractedConfigList(dgStrategyRuleEo, confItemEoList, strategyConfItemSuitEoList, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialList, code, desc);
                }
                if (dgStrategyLabelTypeEnum.getType().equals("list_object") && Objects.nonNull(specialListType = (DgLabelStrategyRuleReqDto.SpecialListType)field.get(addReqDto))) {
                    this.extractedConfigList(dgStrategyRuleEo, confItemEoList, strategyConfItemSuitEoList, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialListType, code, desc);
                }
                if (dgStrategyLabelTypeEnum.getType().equals("time_range") && Objects.nonNull(specialList = (DgLabelStrategyRuleReqDto.SpecialTimeRange)field.get(addReqDto))) {
                    this.extractedInsertConfigContent(dgStrategyRuleEo, confItemEoList, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialList, code, desc);
                }
                if (dgStrategyLabelTypeEnum.getType().equals("amount_range") && Objects.nonNull(specialList = (DgLabelStrategyRuleReqDto.SpecialAmountRange)field.get(addReqDto))) {
                    this.extractedInsertConfigContent(dgStrategyRuleEo, confItemEoList, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialList, code, desc);
                }
                if (dgStrategyLabelTypeEnum.getType().equals("remark") && Objects.nonNull(specialList = (DgLabelStrategyRuleReqDto.ActionRemark)field.get(addReqDto))) {
                    this.extractedInsertConfigContent(dgStrategyRuleEo, confItemEoList, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialList, code, desc);
                }
                if (!dgStrategyLabelTypeEnum.getType().equals("string") || !Objects.nonNull(specialList = (DgLabelStrategyRuleReqDto.SpecialString)field.get(addReqDto))) continue;
                this.extractedInsertConfigContent(dgStrategyRuleEo, confItemEoList, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialList, code, desc);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void extractedConfigList(DgStrategyRuleEo dgStrategyRuleEo, List<StrategyConfItemEo> confItemEoList, List<StrategyConfItemSuitEo> strategyConfItemSuitEoList, DgLabelStrategyRuleReqDto.SpecialStrategy specialChannel, String specialChannelCode, String specialChannelDesc) {
        if (Objects.nonNull(specialChannel)) {
            List codeList = specialChannel.getCodeList();
            StrategyConfItemEo specialWarehouseConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)specialWarehouseConfEo, (Object)specialChannel, (String[])new String[0]);
            specialWarehouseConfEo.setRuleId(dgStrategyRuleEo.getId());
            specialWarehouseConfEo.setStrategyType(specialChannelCode);
            specialWarehouseConfEo.setStrategyTypeName(specialChannelDesc);
            specialWarehouseConfEo.setMd5(MD5Util.getMd5ByString((String)specialChannel.getMD5Content()));
            confItemEoList.add(specialWarehouseConfEo);
            if (CollectionUtils.isNotEmpty((Collection)codeList)) {
                for (String warehouseCode : codeList) {
                    StrategyConfItemSuitEo confItemSuitEo = new StrategyConfItemSuitEo();
                    confItemSuitEo.setRuleId(dgStrategyRuleEo.getId());
                    confItemSuitEo.setSuitType(specialChannelCode);
                    confItemSuitEo.setSuitValue(warehouseCode);
                    confItemSuitEo.setSuitMatchCode(specialChannelCode + "_" + warehouseCode);
                    strategyConfItemSuitEoList.add(confItemSuitEo);
                }
            }
        }
    }

    private void extractedInsertConfigContent(DgStrategyRuleEo dgStrategyRuleEo, List<StrategyConfItemEo> confItemEoList, DgLabelStrategyRuleReqDto.SpecialStrategy specialFreight, String code, String desc) {
        StrategyConfItemEo delayAuditConfEo = new StrategyConfItemEo();
        CubeBeanUtils.copyProperties((Object)delayAuditConfEo, (Object)specialFreight, (String[])new String[0]);
        delayAuditConfEo.setContent(specialFreight.getContent());
        delayAuditConfEo.setRuleId(dgStrategyRuleEo.getId());
        delayAuditConfEo.setMd5(MD5Util.getMd5ByString((String)specialFreight.getMD5Content()));
        delayAuditConfEo.setStrategyType(code);
        delayAuditConfEo.setStrategyTypeName(desc);
        confItemEoList.add(delayAuditConfEo);
    }

    @Override
    public DgLabelStrategyRuleRestDto queryLabelStrategyById(Long id) {
        LambdaQueryWrapper queryStrategyRuleEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyRuleEo.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)id);
        DgStrategyRuleEo dgStrategyRuleEo = this.strategyRuleDomain.getOne(queryStrategyRuleEo);
        AssertUtils.notNull((Object)dgStrategyRuleEo, (String)"\u7b56\u7565\u4e0d\u5b58\u5728");
        DgLabelStrategyRuleRestDto labelRuleRespDto = new DgLabelStrategyRuleRestDto();
        CubeBeanUtils.copyProperties((Object)labelRuleRespDto, (Object)dgStrategyRuleEo, (String[])new String[0]);
        this.getStrategyConfItems(id, labelRuleRespDto);
        return labelRuleRespDto;
    }

    @Override
    public ReBizTagRecordChangeRespDto queryByParam(DgPerformOrderRespDto dgPerformOrderRespDto) {
        logger.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)dgPerformOrderRespDto));
        DgPerformOrderLabelStrategyQueryDto dgPerformOrderLabelStrategyQueryDto = new DgPerformOrderLabelStrategyQueryDto();
        CubeBeanUtils.copyProperties((Object)dgPerformOrderLabelStrategyQueryDto, (Object)dgPerformOrderRespDto, (String[])new String[0]);
        Long id = dgPerformOrderRespDto.getId();
        List dgPerformOrderItemRespDtos = this.dgPerformOrderItemDomain.queryOrderItemByOrderId(id);
        DgPerformOrderAddrDto dgPerformOrderAddrDto = this.dgSaleOrderAddrDomain.queryAddressByOrderId(id);
        dgPerformOrderLabelStrategyQueryDto.setItemList(dgPerformOrderItemRespDtos);
        dgPerformOrderLabelStrategyQueryDto.setOrderAddrReqDto(dgPerformOrderAddrDto);
        ReBizTagRecordChangeRespDto reBizTagRecordChangeRespDto = this.getReBizTagRecordChangeRespDto(dgPerformOrderRespDto, dgPerformOrderLabelStrategyQueryDto);
        return reBizTagRecordChangeRespDto;
    }

    @Override
    public ReBizTagRecordChangeRespDto matchLabel(String orderNo) {
        logger.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)orderNo);
        DgBizPerformOrderRespDto dgBizPerformOrderRespDto = this.commonOrderQueryService.queryByOrderNo(orderNo);
        DgPerformOrderLabelStrategyQueryDto dgPerformOrderLabelStrategyQueryDto = new DgPerformOrderLabelStrategyQueryDto();
        CubeBeanUtils.copyProperties((Object)dgPerformOrderLabelStrategyQueryDto, (Object)dgBizPerformOrderRespDto, (String[])new String[0]);
        Long id = dgBizPerformOrderRespDto.getId();
        List dgPerformOrderItemRespDtos = this.dgPerformOrderItemDomain.queryOrderItemByOrderId(id);
        DgPerformOrderAddrDto dgPerformOrderAddrDto = this.dgSaleOrderAddrDomain.queryAddressByOrderId(id);
        dgPerformOrderLabelStrategyQueryDto.setItemList(dgPerformOrderItemRespDtos);
        dgPerformOrderLabelStrategyQueryDto.setOrderAddrReqDto(dgPerformOrderAddrDto);
        this.eventStrategyListener.handle();
        ReBizTagRecordChangeRespDto reBizTagRecordChangeRespDto = this.getReBizTagRecordChangeRespDto((DgPerformOrderRespDto)dgBizPerformOrderRespDto, dgPerformOrderLabelStrategyQueryDto);
        return reBizTagRecordChangeRespDto;
    }

    private ReBizTagRecordChangeRespDto getReBizTagRecordChangeRespDto(DgPerformOrderRespDto dgPerformOrderRespDto, DgPerformOrderLabelStrategyQueryDto dgPerformOrderLabelStrategyQueryDto) {
        ArrayList specialListAdapt = new ArrayList();
        String platform = DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode().equals(dgPerformOrderRespDto.getBizModel()) ? "2c" : "2b";
        String spacialAdaptStrategy = (String)this.cacheService.getCache("SpacialAdaptStrategy", String.class);
        if (StringUtils.isNotBlank((CharSequence)spacialAdaptStrategy)) {
            this.eventStrategyListener.handle();
            spacialAdaptStrategy = (String)this.cacheService.getCache("SpacialAdaptStrategy", String.class);
        }
        logger.info("\u8f6c\u6362\u6570\u636e\u7b56\u7565\uff1a{}", (Object)spacialAdaptStrategy);
        Map mapObj = (Map)JSONObject.parseObject((String)spacialAdaptStrategy, Map.class);
        HashMap<Long, DgStrategyRuleRespDto> transformedAdaptStrategy = new HashMap<Long, DgStrategyRuleRespDto>();
        if (CollectionUtil.isEmpty((Map)mapObj)) {
            logger.info("\u67e5\u4e0d\u5230\u6807\u7b7e\u8bb0\u5f55");
            return new ReBizTagRecordChangeRespDto();
        }
        Set longs = mapObj.keySet();
        for (Long aLong : longs) {
            JSONObject jsonObject = (JSONObject)mapObj.get(aLong);
            DgStrategyRuleRespDto javaObject = (DgStrategyRuleRespDto)jsonObject.toJavaObject(DgStrategyRuleRespDto.class);
            if (!javaObject.getPlatForm().equals(platform)) continue;
            transformedAdaptStrategy.put(aLong, javaObject);
        }
        String spacialAdapt = (String)this.cacheService.getCache("SpacialAdapt", String.class);
        logger.info("\u8f6c\u6362\u6570\u636e\uff1a{}", (Object)spacialAdapt);
        Map mapObj1 = (Map)JSONObject.parseObject((String)spacialAdapt, Map.class);
        HashMap<Long, DgLabelStrategyAdaptVo> transformedSpecialAdapt = new HashMap<Long, DgLabelStrategyAdaptVo>();
        Set longs1 = transformedAdaptStrategy.keySet();
        for (Long aLong : longs1) {
            JSONObject jsonObject = (JSONObject)mapObj1.get(aLong);
            DgLabelStrategyAdaptVo javaObject = (DgLabelStrategyAdaptVo)jsonObject.toJavaObject(DgLabelStrategyAdaptVo.class);
            transformedSpecialAdapt.put(aLong, javaObject);
        }
        if (transformedSpecialAdapt.isEmpty()) {
            logger.info("\u6ca1\u6709\u5339\u914d\u5230\u6807\u7b7e\u7b56\u7565");
            return new ReBizTagRecordChangeRespDto();
        }
        transformedSpecialAdapt.forEach((k, v) -> {
            switch (DgLabelStrategyEnum.getEnumByCode((String)v.getAdaptTypeString())) {
                case ADAPT_LIST: {
                    List<Long> list = this.adaptLabelStategyListResult((Long)k, (DgLabelStrategyAdaptVo)v, dgPerformOrderLabelStrategyQueryDto);
                    specialListAdapt.addAll(list);
                    break;
                }
                case ADAPT_RANGE: {
                    List<Long> rangeCList = this.adaptLabelStategyRange((Long)k, (DgLabelStrategyAdaptVo)v, dgPerformOrderLabelStrategyQueryDto);
                    if (v.getAdaptType() == DgLabelStrategyEnum.TWO.getNum().intValue()) {
                        List<Long> remarkBList = this.adaptLabelStategyRemark((Long)k, (DgLabelStrategyAdaptVo)v, dgPerformOrderLabelStrategyQueryDto);
                        IDgLabelStrategyRuleServiceImpl.extractedIntersect(specialListAdapt, rangeCList, remarkBList);
                        break;
                    }
                    specialListAdapt.addAll(rangeCList);
                    break;
                }
                case ADAPT_REMARKS: {
                    List<Long> remarkBList = this.adaptLabelStategyRemark((Long)k, (DgLabelStrategyAdaptVo)v, dgPerformOrderLabelStrategyQueryDto);
                    if (!CollectionUtils.isNotEmpty(remarkBList)) break;
                    specialListAdapt.addAll(remarkBList);
                    break;
                }
            }
        });
        ReBizTagRecordChangeRespDto reBizTagRecordChangeRespDto = new ReBizTagRecordChangeRespDto();
        if (CollectionUtils.isNotEmpty(specialListAdapt)) {
            List dgStrategyRuleEos = this.strategyRuleDomain.selectByIds(specialListAdapt);
            ArrayList dgStrategyRuleRespDtos = new ArrayList();
            CubeBeanUtils.copyCollection(dgStrategyRuleRespDtos, (Collection)dgStrategyRuleEos, DgStrategyRuleRespDto.class);
            ReBizTagRecordLinkPageReqDto reBizTagRecordLinkPageReqDto = new ReBizTagRecordLinkPageReqDto();
            reBizTagRecordLinkPageReqDto.setRecordLinkId(dgPerformOrderRespDto.getId());
            List collectLabelCode = dgStrategyRuleEos.stream().map(DgStrategyRuleEo::getLabelCode).distinct().collect(Collectors.toList());
            reBizTagRecordLinkPageReqDto.setRecordChangeCode(collectLabelCode);
            reBizTagRecordLinkPageReqDto.setRecordSourceModel("LABEL_STRATEGY");
            logger.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)reBizTagRecordLinkPageReqDto));
            reBizTagRecordChangeRespDto = (ReBizTagRecordChangeRespDto)this.iReBizTagRecordApiProxy.recordExchange(reBizTagRecordLinkPageReqDto).getData();
        }
        return reBizTagRecordChangeRespDto;
    }

    @Override
    public ReBizTagRecordChangeRespDto applicationOfLabelingStrategy(DgBizPerformOrderRespDto dgBizPerformOrderRespDto, List<DgStrategyRuleReqDto> dgStrategyRuleReqDtos) {
        ReBizTagRecordChangeRespDto reBizTagRecordChangeRespDto = new ReBizTagRecordChangeRespDto();
        if (CollectionUtils.isNotEmpty(dgStrategyRuleReqDtos)) {
            ArrayList dgStrategyRuleRespDtos = new ArrayList();
            CubeBeanUtils.copyCollection(dgStrategyRuleRespDtos, dgStrategyRuleReqDtos, DgStrategyRuleRespDto.class);
            ReBizTagRecordLinkPageReqDto reBizTagRecordLinkPageReqDto = new ReBizTagRecordLinkPageReqDto();
            reBizTagRecordLinkPageReqDto.setRecordLinkId(dgBizPerformOrderRespDto.getId());
            List collectLabelCode = dgStrategyRuleReqDtos.stream().map(DgStrategyRuleReqDto::getLabelCode).distinct().collect(Collectors.toList());
            reBizTagRecordLinkPageReqDto.setRecordChangeCode(collectLabelCode);
            reBizTagRecordLinkPageReqDto.setRecordSourceModel("LABEL_STRATEGY");
            logger.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)reBizTagRecordLinkPageReqDto));
            reBizTagRecordChangeRespDto = (ReBizTagRecordChangeRespDto)this.iReBizTagRecordApiProxy.recordExchange(reBizTagRecordLinkPageReqDto).getData();
        }
        return reBizTagRecordChangeRespDto;
    }

    private static void extractedIntersect(ArrayList<Long> specialListAdapt, List<Long> remarkBList, List<Long> rangeBList) {
        remarkBList.retainAll(rangeBList);
        if (CollectionUtils.isNotEmpty(remarkBList)) {
            specialListAdapt.addAll(remarkBList);
        }
    }

    private List<Long> adaptLabelStategyListResult(Long k, DgLabelStrategyAdaptVo v, DgPerformOrderLabelStrategyQueryDto dgPerformOrderLabelStrategyQueryDto) {
        ArrayList<Long> adaptId = new ArrayList<Long>();
        switch (DgLabelStrategyEnum.getEnumByNum((Integer)v.getAdaptType())) {
            case ONE: {
                List<Long> list1 = this.adaptLabelStategyList(k, v, dgPerformOrderLabelStrategyQueryDto);
                adaptId.addAll(list1);
                break;
            }
            case TWO: {
                List<Long> list2 = this.adaptLabelStategyList(k, v, dgPerformOrderLabelStrategyQueryDto);
                if (v.getAdaptTypeSubString().equals("remark")) {
                    List<Long> remarkList = this.adaptLabelStategyRemark(k, v, dgPerformOrderLabelStrategyQueryDto);
                    IDgLabelStrategyRuleServiceImpl.extractedIntersect(adaptId, list2, remarkList);
                    break;
                }
                if (!v.getAdaptTypeSubString().equals("range")) break;
                List<Long> rangeList = this.adaptLabelStategyRange(k, v, dgPerformOrderLabelStrategyQueryDto);
                IDgLabelStrategyRuleServiceImpl.extractedIntersect(adaptId, list2, rangeList);
                break;
            }
            case THREE: {
                List<Long> list3 = this.adaptLabelStategyList(k, v, dgPerformOrderLabelStrategyQueryDto);
                List<Long> remarkList = this.adaptLabelStategyRemark(k, v, dgPerformOrderLabelStrategyQueryDto);
                List<Long> rangeList = this.adaptLabelStategyRange(k, v, dgPerformOrderLabelStrategyQueryDto);
                list3.retainAll(remarkList);
                list3.retainAll(rangeList);
                if (!CollectionUtils.isNotEmpty(list3)) break;
                adaptId.addAll(list3);
            }
        }
        return adaptId;
    }

    private List<Long> adaptLabelStategyRange(Long k, DgLabelStrategyAdaptVo v, DgPerformOrderLabelStrategyQueryDto dgPerformOrderLabelStrategyQueryDto) {
        Object collect;
        List dgLabelStrategyConfItemRangeVos = v.getDgLabelStrategyConfItemRangeVos();
        ArrayList<Long> adaptRangeLongs = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)dgLabelStrategyConfItemRangeVos)) {
            collect = dgLabelStrategyConfItemRangeVos.stream().collect(Collectors.toMap(e -> e.getStrategyType(), Function.identity()));
            Set<String> strings = collect.keySet();
            for (String string : strings) {
                DgLabelStrategyConfItemRangeVo dgLabelStrategyConfItemRangeVo = (DgLabelStrategyConfItemRangeVo)collect.get(string);
                switch (DgStrategyLabelTypeEnum.forCode((String)string)) {
                    case SPECIAL_CREATE_TIME: {
                        Date createTime = dgPerformOrderLabelStrategyQueryDto.getCreateTime();
                        IDgLabelStrategyRuleServiceImpl.extractedTime(dgLabelStrategyConfItemRangeVo, createTime, adaptRangeLongs, k);
                        break;
                    }
                    case SPECIAL_PAYTIME: {
                        Date payTime = dgPerformOrderLabelStrategyQueryDto.getPerformOrderPaymentDto().getPayTime();
                        IDgLabelStrategyRuleServiceImpl.extractedTime(dgLabelStrategyConfItemRangeVo, payTime, adaptRangeLongs, k);
                        break;
                    }
                    case SPECIAL_WEIGHT: {
                        List itemList = dgPerformOrderLabelStrategyQueryDto.getItemList();
                        BigDecimal weight = itemList.stream().map(DgPerformOrderItemDto::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                        IDgLabelStrategyRuleServiceImpl.extractedRange(dgLabelStrategyConfItemRangeVo, weight, adaptRangeLongs, k);
                        break;
                    }
                    case SPECIAL_VOLUME: {
                        List itemVolumeList = dgPerformOrderLabelStrategyQueryDto.getItemList();
                        BigDecimal volume = itemVolumeList.stream().map(DgPerformOrderItemDto::getVolume).reduce(BigDecimal.ZERO, BigDecimal::add);
                        IDgLabelStrategyRuleServiceImpl.extractedRange(dgLabelStrategyConfItemRangeVo, volume, adaptRangeLongs, k);
                        break;
                    }
                    case SPECIAL_NUM: {
                        List bigDecimals = dgPerformOrderLabelStrategyQueryDto.getItemList().stream().map(DgPerformOrderItemDto::getItemNum).collect(Collectors.toList());
                        BigDecimal sum = bigDecimals.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                        IDgLabelStrategyRuleServiceImpl.extractedRange(dgLabelStrategyConfItemRangeVo, sum, adaptRangeLongs, k);
                        break;
                    }
                    case SPECIAL_AMOUNT_RANGE: {
                        List itemTypeList = dgPerformOrderLabelStrategyQueryDto.getItemList();
                        int size1 = itemTypeList.stream().map(DgPerformOrderItemDto::getItemCode).distinct().collect(Collectors.toList()).size();
                        IDgLabelStrategyRuleServiceImpl.extractedRange(dgLabelStrategyConfItemRangeVo, new BigDecimal(size1), adaptRangeLongs, k);
                        break;
                    }
                    case SPECIAL_PAY_AMOUNT: {
                        BigDecimal orderTotalAmount = dgPerformOrderLabelStrategyQueryDto.getPayAmount();
                        IDgLabelStrategyRuleServiceImpl.extractedRange(dgLabelStrategyConfItemRangeVo, orderTotalAmount, adaptRangeLongs, k);
                        break;
                    }
                    case SPECIAL_PAY_REAL_AMOUNT: {
                        BigDecimal payAmount = dgPerformOrderLabelStrategyQueryDto.getRealPayAmount();
                        IDgLabelStrategyRuleServiceImpl.extractedRange(dgLabelStrategyConfItemRangeVo, payAmount, adaptRangeLongs, k);
                        break;
                    }
                    case SPECIAL_TOTAL_AMOUNT: {
                        BigDecimal goodsTotalAmount = dgPerformOrderLabelStrategyQueryDto.getGoodsTotalAmount();
                        IDgLabelStrategyRuleServiceImpl.extractedRange(dgLabelStrategyConfItemRangeVo, goodsTotalAmount, adaptRangeLongs, k);
                        break;
                    }
                    case SPECIAL_FREIGHT: {
                        BigDecimal freightCost = dgPerformOrderLabelStrategyQueryDto.getFreightCost();
                        IDgLabelStrategyRuleServiceImpl.extractedRange(dgLabelStrategyConfItemRangeVo, freightCost, adaptRangeLongs, k);
                    }
                }
            }
        }
        if (CollectionUtils.isEmpty(adaptRangeLongs)) {
            return new ArrayList<Long>();
        }
        collect = adaptRangeLongs.stream().distinct().collect(Collectors.toList());
        return collect;
    }

    private static void extractedRange(DgLabelStrategyConfItemRangeVo dgLabelStrategyConfItemRangeVo, BigDecimal compare, ArrayList<Long> specialListAdapt, Long k) {
        DgLabelStrategyRuleReqDto.SpecialAmountRange specialAmountRange = (DgLabelStrategyRuleReqDto.SpecialAmountRange)JSON.parseObject((String)dgLabelStrategyConfItemRangeVo.getContent(), DgLabelStrategyRuleReqDto.SpecialAmountRange.class);
        BigDecimal minAmount = specialAmountRange.getMinAmount();
        BigDecimal maxAmount = specialAmountRange.getMaxAmount();
        int lowerComparison = compare.compareTo(minAmount);
        int upperComparison = compare.compareTo(maxAmount);
        if (lowerComparison >= 0 && upperComparison <= 0) {
            System.out.println("compare\u5728\u8303\u56f4\u5185");
            specialListAdapt.add(k);
        } else {
            specialListAdapt.clear();
        }
    }

    private static void extractedTime(DgLabelStrategyConfItemRangeVo dgLabelStrategyConfItemRangeVo, Date time, ArrayList<Long> specialListAdapt, Long k) {
        DgLabelStrategyRuleReqDto.SpecialTimeRange specialTimeRange = (DgLabelStrategyRuleReqDto.SpecialTimeRange)JSON.parseObject((String)dgLabelStrategyConfItemRangeVo.getContent(), DgLabelStrategyRuleReqDto.SpecialTimeRange.class);
        Date startTime = specialTimeRange.getStartTime();
        Date endTime = specialTimeRange.getEndTime();
        if (time.after(startTime) && time.before(endTime)) {
            System.out.println("Time\u5728\u65f6\u95f4\u8303\u56f4\u5185");
            specialListAdapt.add(k);
        } else {
            specialListAdapt.clear();
        }
    }

    private List<Long> adaptLabelStategyRemark(Long k, DgLabelStrategyAdaptVo v, DgPerformOrderLabelStrategyQueryDto dgPerformOrderLabelStrategyQueryDto) {
        ArrayList<Long> remakeApdateId = new ArrayList<Long>();
        String buyerRemark = Optional.ofNullable(dgPerformOrderLabelStrategyQueryDto.getBuyerRemark()).orElse("");
        String sellerRemark = Optional.ofNullable(dgPerformOrderLabelStrategyQueryDto.getSellerRemark()).orElse("");
        String remark = Optional.ofNullable(dgPerformOrderLabelStrategyQueryDto.getRemark()).orElse("");
        String receiveAddress = Optional.ofNullable(dgPerformOrderLabelStrategyQueryDto.getOrderAddrReqDto().getReceiveAddress()).orElse("");
        String adaptString = v.getAdaptString();
        try {
            DgLabelStrategyConfItemSwitchVo dgLabelStrategyConfItemSwitchVo = v.getDgLabelStrategyConfItemSwitchVo();
            ObjectMapper objectMapper = new ObjectMapper();
            HashMap memoTextMatching = (HashMap)objectMapper.readValue(adaptString, HashMap.class);
            Set adaptCode = memoTextMatching.keySet();
            for (String s : adaptCode) {
                switch (DgStrategyLabelTypeEnum.forCode((String)s)) {
                    case SPECIAL_REMARK: {
                        String remarkType = dgLabelStrategyConfItemSwitchVo.getRemarkType();
                        IDgLabelStrategyRuleServiceImpl.extractedRemark(k, remakeApdateId, remark, remarkType, (String)memoTextMatching.get(s));
                        break;
                    }
                    case SPECIAL_SELLER: {
                        String remarkBuyerType = dgLabelStrategyConfItemSwitchVo.getRemarkSellerType();
                        IDgLabelStrategyRuleServiceImpl.extractedRemark(k, remakeApdateId, sellerRemark, remarkBuyerType, (String)memoTextMatching.get(s));
                        break;
                    }
                    case SPECIAL_BUYER: {
                        String remarkSellerType = dgLabelStrategyConfItemSwitchVo.getRemarkBuyerType();
                        IDgLabelStrategyRuleServiceImpl.extractedRemark(k, remakeApdateId, buyerRemark, remarkSellerType, (String)memoTextMatching.get(s));
                        break;
                    }
                    case SPECIAL_AREA_DETAIL: {
                        String s1 = (String)memoTextMatching.get(s);
                        List<String> receiveAddressString = Arrays.asList(s1.split(","));
                        boolean action = true;
                        for (String s2 : receiveAddressString) {
                            if (!receiveAddress.contains(s2)) continue;
                            remakeApdateId.add(k);
                            action = false;
                            break;
                        }
                        if (!action) break;
                        remakeApdateId.clear();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (CollectionUtils.isNotEmpty(remakeApdateId)) {
            return remakeApdateId.stream().distinct().collect(Collectors.toList());
        }
        return remakeApdateId;
    }

    private static void extractedRemark(Long k, ArrayList<Long> remakeApdateId, String remark, String remarkType, String s2) {
        List<String> receiveAddressString = Arrays.asList(s2.split(","));
        boolean action = true;
        for (String adapt : receiveAddressString) {
            if (remarkType.equals("0")) {
                remakeApdateId.add(k);
                action = false;
                break;
            }
            if (!remarkType.equals("1") || !remark.contains(adapt)) continue;
            remakeApdateId.add(k);
            action = false;
            break;
        }
        if (action) {
            remakeApdateId.clear();
        }
    }

    private List<Long> adaptLabelStategyList(Long id, DgLabelStrategyAdaptVo v, DgPerformOrderLabelStrategyQueryDto dgPerformOrderLabelStrategyQueryDto) {
        ArrayList<Long> listAdaptElement = new ArrayList<Long>();
        List adaptList = v.getAdaptList();
        List adaptTypeList = v.getAdaptTypeList();
        ArrayList adaptationArrayList = new ArrayList();
        List itemList = dgPerformOrderLabelStrategyQueryDto.getItemList();
        if (CollectionUtils.isNotEmpty((Collection)adaptTypeList)) {
            adaptTypeList.forEach(e -> {
                switch (DgStrategyLabelTypeEnum.forCode((String)e)) {
                    case SPECIAL_SKUS: {
                        IDgLabelStrategyRuleServiceImpl.extractedAdaptItemCode(id, v, listAdaptElement, adaptList, adaptationArrayList, itemList);
                        break;
                    }
                    case SPECIAL_ORDER_TYPE: {
                        IDgLabelStrategyRuleServiceImpl.extractedOrderType(id, dgPerformOrderLabelStrategyQueryDto, listAdaptElement, adaptList);
                        break;
                    }
                    case SPECIAL_AREA: {
                        IDgLabelStrategyRuleServiceImpl.extractedArea(id, dgPerformOrderLabelStrategyQueryDto, listAdaptElement, adaptList);
                        break;
                    }
                    case SPECIAL_SHOP: {
                        IDgLabelStrategyRuleServiceImpl.extractedAdaptShop(id, dgPerformOrderLabelStrategyQueryDto, listAdaptElement, adaptList);
                        break;
                    }
                }
            });
        }
        return listAdaptElement;
    }

    private static void extractedAdaptShop(Long id, DgPerformOrderLabelStrategyQueryDto dgPerformOrderLabelStrategyQueryDto, ArrayList<Long> listAdaptElement, List<String> adaptList) {
        DgPerformOrderSnapshotDto performOrderSnapshotDto = dgPerformOrderLabelStrategyQueryDto.getPerformOrderSnapshotDto();
        String shopCode = performOrderSnapshotDto.getShopCode();
        if (adaptList.contains(shopCode)) {
            listAdaptElement.add(id);
        }
    }

    private static void extractedArea(Long id, DgPerformOrderLabelStrategyQueryDto dgPerformOrderLabelStrategyQueryDto, ArrayList<Long> listAdaptElement, List<String> adaptList) {
        DgPerformOrderAddrDto orderAddrReqDto = dgPerformOrderLabelStrategyQueryDto.getOrderAddrReqDto();
        String provinceCode = orderAddrReqDto.getProvinceCode();
        String cityCode = orderAddrReqDto.getCityCode();
        String countyCode = orderAddrReqDto.getCountyCode();
        if (adaptList.contains(provinceCode) || adaptList.contains(cityCode) || adaptList.contains(countyCode)) {
            listAdaptElement.add(id);
        }
    }

    private static void extractedOrderType(Long id, DgPerformOrderLabelStrategyQueryDto dgPerformOrderLabelStrategyQueryDto, ArrayList<Long> listAdaptElement, List<String> adaptList) {
        String orderType = dgPerformOrderLabelStrategyQueryDto.getOrderType();
        if (StringUtils.isNotEmpty((CharSequence)orderType)) {
            if (adaptList.contains(orderType)) {
                listAdaptElement.add(id);
            } else {
                listAdaptElement.clear();
            }
        }
    }

    private static void extractedAdaptItemCode(Long id, DgLabelStrategyAdaptVo v, ArrayList<Long> listAdaptElement, List<String> adaptList, ArrayList<String> adaptationArrayList, List<DgPerformOrderItemRespDto> itemList) {
        block2: {
            List<Object> itemCodes;
            block3: {
                DgLabelStrategyConfItemSwitchVo dgLabelStrategyConfItemSwitchVo;
                itemCodes = new ArrayList();
                if (CollectionUtils.isNotEmpty(itemList)) {
                    itemCodes = itemList.stream().map(DgPerformOrderItemDto::getSkuCode).collect(Collectors.toList());
                    adaptationArrayList.addAll(itemCodes);
                }
                if (!CollectionUtils.isNotEmpty(itemCodes) || Objects.isNull(dgLabelStrategyConfItemSwitchVo = v.getDgLabelStrategyConfItemSwitchVo())) break block2;
                String matchingRules = dgLabelStrategyConfItemSwitchVo.getMatchingRules();
                if (!matchingRules.equals("0")) break block3;
                if (!IDgLabelStrategyRuleServiceImpl.areListsEqual(adaptList, itemCodes)) break block2;
                listAdaptElement.add(id);
                break block2;
            }
            for (String string : itemCodes) {
                if (!adaptList.contains(string)) continue;
                listAdaptElement.add(id);
                break;
            }
        }
    }

    public static <T> boolean areListsEqual(List<T> list1, List<T> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.contains(list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static void extractedPrepareData(DgBizPerformOrderRespDto dgBizPerformOrderRespDto, ArrayList<String> listAdaptElement) {
        String orderType = dgBizPerformOrderRespDto.getOrderType();
        listAdaptElement.add(orderType);
        String saleChannel = dgBizPerformOrderRespDto.getSaleChannel();
        listAdaptElement.add(saleChannel);
        DgPerformOrderAddrRespDto orderAddrRespDto = dgBizPerformOrderRespDto.getOrderAddrRespDto();
        String provinceCode = orderAddrRespDto.getProvinceCode();
        listAdaptElement.add(provinceCode);
        String cityCode = orderAddrRespDto.getCityCode();
        listAdaptElement.add(cityCode);
        String shippingType = dgBizPerformOrderRespDto.getShippingType();
        listAdaptElement.add(shippingType);
        DgPerformOrderSnapshotDto performOrderSnapshotDto = dgBizPerformOrderRespDto.getPerformOrderSnapshotDto();
        String shopCode = performOrderSnapshotDto.getShopCode();
        String customerCode = performOrderSnapshotDto.getCustomerCode();
        listAdaptElement.add(shopCode);
        listAdaptElement.add(customerCode);
    }

    @Override
    public List<DgStrategyRuleRespDto> queryEffectiveAndInitiatedPolicies(DgStrategyRulePageReqDto dgStrategyRulePageReqDto) {
        return this.strategyRuleDomain.queryEffectiveAndInitiatedPolicies(dgStrategyRulePageReqDto);
    }

    private void getStrategyConfItems(Long id, DgLabelStrategyRuleRestDto labelRuleRespDto) {
        LambdaQueryWrapper queryStrategyConfItemEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyConfItemEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemEo::getRuleId, (Object)id);
        List strategyConfItemEoList = this.dgStrategyConfItemDomain.list(queryStrategyConfItemEo);
        AssertUtils.notEmpty((Collection)strategyConfItemEoList, (String)"\u7b56\u7565\u914d\u7f6e\u9879\u4e3a\u7a7a");
        LambdaQueryWrapper queryStrategyConfItemSuitEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyConfItemSuitEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemSuitEo::getRuleId, (Object)id);
        List strategyConfItemSuitEoList = this.dgStrategyConfItemSuitDomain.list(queryStrategyConfItemSuitEo);
        Map<String, List<StrategyConfItemSuitEo>> strategyConfItemSuitMap = Optional.ofNullable(strategyConfItemSuitEoList).orElseGet(Collections::emptyList).stream().collect(Collectors.groupingBy(StrategyConfItemSuitEo::getSuitType));
        Class<?> aClass = labelRuleRespDto.getClass();
        strategyConfItemEoList.forEach(strategyConfItemEo -> {
            switch (CisStrategyContentTypeEnum.forCode((String)strategyConfItemEo.getContentType())) {
                case LIST: {
                    DgLabelStrategyRuleRestDto.SpecialList specialList = new DgLabelStrategyRuleRestDto.SpecialList();
                    List collectItemSuitCode = Optional.ofNullable(strategyConfItemSuitMap.get(strategyConfItemEo.getStrategyType())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                    CubeBeanUtils.copyProperties((Object)specialList, (Object)strategyConfItemEo, (String[])new String[0]);
                    specialList.setCodeList(collectItemSuitCode);
                    String fieldName = DgStrategyLabelTypeEnum.forCode((String)strategyConfItemEo.getStrategyType()).getName();
                    try {
                        Field declaredField = aClass.getDeclaredField(fieldName);
                        declaredField.setAccessible(true);
                        declaredField.set(labelRuleRespDto, specialList);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                case LIST_OBJECT: {
                    DgLabelStrategyRuleRestDto.SpecialListType specialListType = new DgLabelStrategyRuleRestDto.SpecialListType();
                    List collectItemSuitCodeOFType = Optional.ofNullable(strategyConfItemSuitMap.get(strategyConfItemEo.getStrategyType())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                    CubeBeanUtils.copyProperties((Object)specialListType, (Object)strategyConfItemEo, (String[])new String[0]);
                    specialListType.setCodeList(collectItemSuitCodeOFType);
                    DgLabelStrategyRuleReqDto.SwitchType switchType = (DgLabelStrategyRuleReqDto.SwitchType)JSON.parseObject((String)strategyConfItemEo.getContent(), DgLabelStrategyRuleReqDto.SwitchType.class);
                    specialListType.setSwitchType(switchType);
                    String specialListTypeName = DgStrategyLabelTypeEnum.forCode((String)strategyConfItemEo.getStrategyType()).getName();
                    try {
                        Field declaredField = aClass.getDeclaredField(specialListTypeName);
                        declaredField.setAccessible(true);
                        declaredField.set(labelRuleRespDto, specialListType);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                case RANGE: {
                    DgLabelStrategyRuleRestDto.SpecialAmountRange specialAmountRange = new DgLabelStrategyRuleRestDto.SpecialAmountRange();
                    CubeBeanUtils.copyProperties((Object)specialAmountRange, (Object)strategyConfItemEo, (String[])new String[0]);
                    String content = strategyConfItemEo.getContent();
                    if (StringUtils.isNotBlank((CharSequence)content)) {
                        HashMap map = (HashMap)JSON.parseObject((String)content, HashMap.class);
                        specialAmountRange.setMinAmount(new BigDecimal(map.get("minAmount").toString()));
                        specialAmountRange.setMaxAmount(new BigDecimal(map.get("maxAmount").toString()));
                    }
                    try {
                        String specialAmountRangeFieldName = DgStrategyLabelTypeEnum.forCode((String)strategyConfItemEo.getStrategyType()).getName();
                        Field declaredField = aClass.getDeclaredField(specialAmountRangeFieldName);
                        declaredField.setAccessible(true);
                        declaredField.set(labelRuleRespDto, specialAmountRange);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                case TIME_RANGE: {
                    DgLabelStrategyRuleRestDto.SpecialTimeRange specialTimeRange = new DgLabelStrategyRuleRestDto.SpecialTimeRange();
                    CubeBeanUtils.copyProperties((Object)specialTimeRange, (Object)strategyConfItemEo, (String[])new String[0]);
                    String specialTimeRangeContent = strategyConfItemEo.getContent();
                    if (StringUtils.isNotBlank((CharSequence)specialTimeRangeContent)) {
                        HashMap map = (HashMap)JSON.parseObject((String)specialTimeRangeContent, HashMap.class);
                        specialTimeRange.setStartTime(DateUtil.parse((String)MapUtils.getString((Map)map, (Object)"startTime"), (String)"yyyy-MM-dd HH:mm:ss"));
                        specialTimeRange.setEndTime(DateUtil.parse((String)MapUtils.getString((Map)map, (Object)"endTime"), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    try {
                        String specialTimeRangeFieldName = DgStrategyLabelTypeEnum.forCode((String)strategyConfItemEo.getStrategyType()).getName();
                        Field declaredField = aClass.getDeclaredField(specialTimeRangeFieldName);
                        declaredField.setAccessible(true);
                        declaredField.set(labelRuleRespDto, specialTimeRange);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                case REMARK: {
                    DgLabelStrategyRuleRestDto.ActionRemark actionRemark = new DgLabelStrategyRuleRestDto.ActionRemark();
                    CubeBeanUtils.copyProperties((Object)actionRemark, (Object)strategyConfItemEo, (String[])new String[0]);
                    String actionRemarkContent = strategyConfItemEo.getContent();
                    if (StringUtils.isNotBlank((CharSequence)actionRemarkContent)) {
                        HashMap map = (HashMap)JSON.parseObject((String)actionRemarkContent, HashMap.class);
                        actionRemark.setRemarkType(MapUtils.getString((Map)map, (Object)"remarkType", (String)"0"));
                        actionRemark.setKeyWords(MapUtils.getString((Map)map, (Object)"keyWords"));
                    }
                    try {
                        String actionRemarkFieldName = DgStrategyLabelTypeEnum.forCode((String)strategyConfItemEo.getStrategyType()).getName();
                        Field declaredField = aClass.getDeclaredField(actionRemarkFieldName);
                        declaredField.setAccessible(true);
                        declaredField.set(labelRuleRespDto, actionRemark);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                case STRING: {
                    DgLabelStrategyRuleRestDto.SpecialString specialString = new DgLabelStrategyRuleRestDto.SpecialString();
                    CubeBeanUtils.copyProperties((Object)specialString, (Object)strategyConfItemEo, (String[])new String[0]);
                    String content1 = strategyConfItemEo.getContent();
                    if (StringUtils.isNotBlank((CharSequence)content1)) {
                        specialString.setContent(content1);
                    }
                    try {
                        String actionRemarkFieldName = DgStrategyLabelTypeEnum.forCode((String)strategyConfItemEo.getStrategyType()).getName();
                        Field declaredField = aClass.getDeclaredField(actionRemarkFieldName);
                        declaredField.setAccessible(true);
                        declaredField.set(labelRuleRespDto, specialString);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }
}

