/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.utils;

import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class TransactionUtil {
    @Resource
    protected PlatformTransactionManager transactionManager;

    public TransactionStatus begin() {
        return this.begin(-1, 0);
    }

    public TransactionStatus begin(int isolationLevel, int transactionDefinition) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setIsolationLevel(isolationLevel);
        def.setPropagationBehavior(transactionDefinition);
        return this.transactionManager.getTransaction((TransactionDefinition)def);
    }

    public void commit(TransactionStatus transaction) {
        this.transactionManager.commit(transaction);
    }

    public void rollback(TransactionStatus transaction) {
        this.transactionManager.rollback(transaction);
    }

    public static void doAfterCommit(final Commit commit) {
        boolean transactionActive = TransactionSynchronizationManager.isActualTransactionActive();
        if (transactionActive) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    commit.doCommit();
                }
            });
        } else {
            commit.doCommit();
        }
    }

    public static interface Commit {
        public void doCommit();
    }
}

