/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.utils.selector;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.yunxi.dg.base.center.account.dto.biz.AccountTradeRespDto;
import com.yunxi.dg.base.center.data.dto.DictDto;
import com.yunxi.dg.base.center.data.proxy.api.IDictQueryApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.common.IOrderPayAction;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.pay.base.DgBasePayReqDto;
import com.yunxi.dg.base.center.trade.enums.B2COrderPayWayEnum;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class B2COrderPaySelector {
    private static final Logger logger = LoggerFactory.getLogger(B2COrderPaySelector.class);
    private String way;
    private IOrderPayAction orderPayAction;

    public B2COrderPaySelector(String way) {
        this.way = way;
        this.orderPayAction = (IOrderPayAction)SpringBeanUtil.getBean((String)B2COrderPayWayEnum.toInstanceName((String)way), IOrderPayAction.class);
    }

    public static B2COrderPaySelector newInstance(String way) {
        return new B2COrderPaySelector(way);
    }

    public static B2COrderPaySelector newInstance() {
        IDictQueryApiProxy dictQueryApiProxy = (IDictQueryApiProxy)SpringBeanUtil.getBean(IDictQueryApiProxy.class);
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)dictQueryApiProxy.queryByGroupCodeAndCode("yunxi-dg-base-center-trade", "B2C_PAY_WAY"));
        String way = Optional.ofNullable(dictDto).map(m -> dictDto.getValue()).orElse(B2COrderPayWayEnum.DEF_WAY.getWay());
        logger.info("\u8bfb\u53d6\u8d26\u6237\u914d\u7f6eway\uff1a{}", (Object)way);
        return new B2COrderPaySelector(way);
    }

    public RestResponse<Void> pay(Long id, List<DgPerformOrderLineDto> orderLineDtoList, List<DgBasePayReqDto> payReqDtoList) {
        return this.orderPayAction.pay(id, orderLineDtoList, payReqDtoList);
    }

    public RestResponse<Void> preemptionToActualPayment(Long id, List<DgBasePayReqDto> payReqDtoList) {
        return this.orderPayAction.preemptionToActualPayment(id, payReqDtoList);
    }

    public RestResponse<Void> preemptionToReturn(Long orderId, List<DgPerformOrderLineDto> orderLineList, List<DgBasePayReqDto> payReqDtos) {
        return this.orderPayAction.preemptionToReturn(orderId, orderLineList, payReqDtos);
    }

    public RestResponse<List<AccountTradeRespDto>> refund(Long id, List<DgBasePayReqDto> payReqDtos, DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        return this.orderPayAction.refund(id, payReqDtos, afterSaleOrderRespDto);
    }

    public RestResponse<List<AccountTradeRespDto>> noOrignaleOrderRefund(Long id, List<DgBasePayReqDto> payReqDtoList, DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        return this.orderPayAction.noOrignaleOrderRefund(id, payReqDtoList, afterSaleOrderRespDto);
    }
}

