/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.basic.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.trade.api.constant.aftersale.AfterSaleOrderStatusEnum;
import com.yunxi.dg.base.center.account.constants.ItemCountsTypeEnum;
import com.yunxi.dg.base.center.account.dto.biz.AccountTradeRespDto;
import com.yunxi.dg.base.center.inventory.api.warehouse.ILogicWarehouseApi;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicalWarehouseRespDto;
import com.yunxi.dg.base.center.shop.proxy.query.IShopReturnWarehouseConfigApiProxy;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.basic.IDgAfterSaleOrderBasicOptAction;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.basic.IDgAfterSaleOrderLineOptAction;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderRefundStatusEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.dao.base.QueryWrapBuilder;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderExchangeAddressDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderLogisticsWarehouseDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderReturnAddressDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderReturnShippingSnDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgRefundDetailDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgRefundDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgRefundItemDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterBatchReturnWarehouseReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderBatchReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterUpdateLogisticsNoReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderVoucherDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.pay.base.DgBasePayReqDto;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderItemTypeEnum;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.enums.NewDgRefundDetailStatusEnum;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderLogisticsWarehouseEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderReturnShippingSnEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgRefundDetailEo;
import com.yunxi.dg.base.center.trade.eo.DgRefundEo;
import com.yunxi.dg.base.center.trade.eo.DgRefundItemEo;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.TradeUtil;
import com.yunxi.dg.base.center.trade.utils.selector.B2COrderPaySelector;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgAfterSaleOrderBasicOptAction
implements IDgAfterSaleOrderBasicOptAction {
    private static final Logger log = LoggerFactory.getLogger(DgAfterSaleOrderBasicOptAction.class);
    private static final int INNER_REMARK_MAX_LENGTH = 100;
    @Resource
    private ILogicWarehouseApi logicWarehouseApi;
    @Resource
    private IDgAfterSaleOrderReturnShippingSnDomain dgAfterSaleOrderReturnShippingSnDomain;
    @Resource
    private IDgAfterSaleOrderDomain dgAfterSaleOrderDomain;
    @Resource
    private IDgAfterSaleOrderReturnAddressDomain dgAfterSaleOrderReturnAddressDomain;
    @Resource
    private IDgAfterSaleOrderExchangeAddressDomain dgAfterSaleOrderExchangeAddressDomain;
    @Resource
    private IDgAfterSaleOrderLogisticsWarehouseDomain dgAfterSaleOrderLogisticsWarehouseDomain;
    @Resource
    private IDgPerformOrderItemLineDomain dgPerformOrderItemLineDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain dgPerformOrderItemLineAmountDomain;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain dgPerformOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgAfterSaleOrderItemDomain dgAfterSaleOrderItemDomain;
    @Resource
    private IDgRefundDomain dgRefundDomain;
    @Resource
    private IDgRefundDetailDomain dgRefundDetailDomain;
    @Resource
    private IDgRefundItemDomain dgRefundItemDomain;
    @Resource
    private IDgAfterSaleOrderLineOptAction dgAfterSaleOrderLineOptAction;
    @Resource
    private IShopReturnWarehouseConfigApiProxy shopReturnWarehouseConfigApiProxy;

    @Override
    public void batchModifyInnerRemark(DgAfterSaleOrderBatchReqDto dto) {
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)dto.getAfterSaleOrderIds()), (String)"\u5165\u53c2\u552e\u540e\u5355ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List afterSaleOrderIds = dto.getAfterSaleOrderIds();
        List afterSaleOrderEos = this.dgAfterSaleOrderDomain.selectByIds(afterSaleOrderIds);
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)afterSaleOrderEos), (String)"\u672a\u67e5\u5230\u552e\u540e\u5355\u4fe1\u606f");
        Map orderEoMap = afterSaleOrderEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (Long orderId : afterSaleOrderIds) {
            DgAfterSaleOrderEo saleOrderEo = (DgAfterSaleOrderEo)orderEoMap.get(orderId);
            if (Objects.isNull(saleOrderEo)) continue;
            String remark = dto.getInnerRemark();
            if (remark.length() > 100) {
                throw new BizException("\u5907\u6ce8\u957f\u5ea6\u8d85\u8fc7\u9650\u5236");
            }
            DgAfterSaleOrderEo eo = new DgAfterSaleOrderEo();
            eo.setId(orderId);
            eo.setInnerRemark(remark);
            this.dgAfterSaleOrderDomain.updateSelective((BaseEo)eo);
        }
    }

    @Override
    public void batchModifyInnerRemarkByAfsIds(List<Long> afsIds, String innerRemark) {
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty(afsIds), (String)"\u5165\u53c2\u552e\u540e\u5355ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotBlank((CharSequence)innerRemark)) {
            AssertUtils.isFalse((innerRemark.length() > 100 ? 1 : 0) != 0, (String)"\u5185\u90e8\u5907\u6ce8\u957f\u5ea6\u8d85\u8fc7\u9650\u5236");
        }
        this.dgAfterSaleOrderDomain.batchModifyInnerRemarkByAfsIds(afsIds, innerRemark);
    }

    @Override
    public void batchModifyAfterSaleOrderReason(DgAfterSaleOrderBatchReqDto dto) {
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)dto.getAfterSaleOrderIds()), (String)"\u5165\u53c2\u552e\u540e\u5355ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List afterSaleOrderIds = dto.getAfterSaleOrderIds();
        List afterSaleOrderEos = this.dgAfterSaleOrderDomain.selectByIds(afterSaleOrderIds);
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)afterSaleOrderEos), (String)"\u672a\u67e5\u5230\u552e\u540e\u5355\u4fe1\u606f");
        Map orderEoMap = afterSaleOrderEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (Long orderId : afterSaleOrderIds) {
            DgAfterSaleOrderEo saleOrderEo = (DgAfterSaleOrderEo)orderEoMap.get(orderId);
            if (Objects.isNull(saleOrderEo)) continue;
            String afterSaleOrderReason = dto.getAfterSaleOrderReason();
            DgAfterSaleOrderEo eo = new DgAfterSaleOrderEo();
            eo.setId(orderId);
            eo.setAfterSaleOrderReason(afterSaleOrderReason);
            this.dgAfterSaleOrderDomain.updateSelective((BaseEo)eo);
        }
    }

    @Override
    public void batchModifyAfterSaleOrderReasonByAfsIds(List<Long> afsIds, String reason) {
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty(afsIds), (String)"\u5165\u53c2\u552e\u540e\u5355ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        this.dgAfterSaleOrderDomain.batchModifyAfterSaleOrderReasonByAfsIds(afsIds, reason);
    }

    @Override
    public void updateLogisticsNo(DgAfterUpdateLogisticsNoReqDto reqDto) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)reqDto.getOrderNo()), (String)"\u53c2\u6570\u552e\u540e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderEo eo = new DgAfterSaleOrderEo();
        eo.setDr(0);
        eo.setAfterSaleOrderNo(reqDto.getOrderNo());
        DgAfterSaleOrderEo afterSaleOrderEo = (DgAfterSaleOrderEo)this.dgAfterSaleOrderDomain.selectOne((BaseEo)eo);
        AssertUtils.isFalse((afterSaleOrderEo == null ? 1 : 0) != 0, (String)"\u552e\u540e\u5355\u4e0d\u5b58\u5728");
        DgAfterSaleOrderLogisticsWarehouseEo logisticsWarehouseEo = (DgAfterSaleOrderLogisticsWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgAfterSaleOrderLogisticsWarehouseDomain.filter().eq((Object)"after_sale_order_id", (Object)afterSaleOrderEo.getId())).eq((Object)"dr", (Object)0)).one();
        AssertUtils.isFalse((logisticsWarehouseEo == null ? 1 : 0) != 0, (String)"\u552e\u540e\u7269\u6d41\u4fe1\u606f\u4e0d\u5b58\u5728");
        DgAfterSaleOrderLogisticsWarehouseEo update = new DgAfterSaleOrderLogisticsWarehouseEo();
        update.setId(afterSaleOrderEo.getId());
        update.setReturnShippingSn(reqDto.getLogisticsNo());
        update.setShippingName(reqDto.getLogisticsCompany());
        update.setShippingCode(reqDto.getLogisticsCode());
        this.dgAfterSaleOrderLogisticsWarehouseDomain.updateSelective((BaseEo)update);
    }

    @Override
    public void batchModifyReturnWarehouse(DgAfterBatchReturnWarehouseReqDto dto) {
        List dgAfterSaleOrderEos = this.dgAfterSaleOrderDomain.selectByIds(dto.getAfterSaleOrderIds());
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)dgAfterSaleOrderEos), (String)"\u672a\u627e\u5230\u552e\u540e\u5355\u4fe1\u606f");
        for (DgAfterSaleOrderEo dgAfterSaleOrderEo : dgAfterSaleOrderEos) {
            AssertUtils.isTrue((dgAfterSaleOrderEo.getStatus().equals(AfterSaleOrderStatusEnum.WAIT_AUDIT.getCode()) || dgAfterSaleOrderEo.getStatus().equals(AfterSaleOrderStatusEnum.WAIT_RETURN.getCode()) ? 1 : 0) != 0, (String)"\u4ec5\u5f85\u5ba1\u6838\u3001\u5f85\u9000\u8d27\u7684\u53ef\u6307\u5b9a\u9000\u8d27\u4ed3");
        }
        LogicalWarehouseRespDto warehouseRespDto = this.getLogicWarehouseRespDto(dto);
        Map afterSaleOrderEoMap = dgAfterSaleOrderEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        List logisticsWarehouseEos = ((ExtQueryChainWrapper)this.dgAfterSaleOrderLogisticsWarehouseDomain.filter().in((Object)"after_sale_order_id", (Collection)dto.getAfterSaleOrderIds())).list();
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)logisticsWarehouseEos), (String)"\u672a\u67e5\u5230\u552e\u540e\u5355\u9000\u8d27\u7269\u6d41\u4fe1\u606f");
        logisticsWarehouseEos.forEach(orderLogisticsWarehouseEo -> {
            DgAfterSaleOrderEo afterSaleOrderEo = (DgAfterSaleOrderEo)afterSaleOrderEoMap.get(orderLogisticsWarehouseEo.getAfterSaleOrderId());
            AssertUtils.notNull((Object)afterSaleOrderEo, (String)"\u5339\u914d\u4e0d\u5230\u552e\u540e\u5355\u5173\u7cfb");
            if (afterSaleOrderEo.getSaleOrderId() != null) {
                DgPerformOrderRespDto performOrderRespDto = this.dgPerformOrderInfoDomain.queryDtoById(afterSaleOrderEo.getSaleOrderId());
                AssertUtils.notNull((Object)performOrderRespDto, (String)(afterSaleOrderEo.getAfterSaleOrderNo() + "\u83b7\u53d6\u4e0d\u5230\u539f\u5355\u9500\u552e\u5355\u4fe1\u606f"));
                this.checkReturnWarehouseCode(afterSaleOrderEo, performOrderRespDto, warehouseRespDto.getWarehouseCode());
            }
            DgAfterSaleOrderLogisticsWarehouseEo eo = new DgAfterSaleOrderLogisticsWarehouseEo();
            eo.setId(orderLogisticsWarehouseEo.getId());
            eo.setReturnWarehouseCode(warehouseRespDto.getWarehouseCode());
            eo.setReturnWarehouseName(warehouseRespDto.getWarehouseName());
            eo.setReturnWarehouseId(warehouseRespDto.getId());
            this.dgAfterSaleOrderLogisticsWarehouseDomain.updateSelective((BaseEo)eo);
        });
    }

    private void checkReturnWarehouseCode(DgAfterSaleOrderEo afterSaleOrderEo, DgPerformOrderRespDto dgPerformOrderRespDto, String warehouseCode) {
        AssertUtils.notBlank((String)warehouseCode, (String)"\u9000\u8d27\u5165\u5e93\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)afterSaleOrderEo.getShopCode(), (String)"\u5173\u8054\u5e97\u94fa\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dgPerformOrderRespDto.getDeliveryLogicalWarehouseCode(), (String)"\u539f\u5355\u53d1\u8d27\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("\u6821\u9a8c\u9000\u8d27\u5165\u5e93\u4ed3\u662f\u5426\u6709\u6548 {} {} {}", new Object[]{warehouseCode, dgPerformOrderRespDto.getDeliveryLogicalWarehouseCode(), afterSaleOrderEo.getShopCode()});
        List shopReturnWarehouseConfigList = (List)RestResponseHelper.extractData((RestResponse)this.shopReturnWarehouseConfigApiProxy.getByCode(dgPerformOrderRespDto.getDeliveryLogicalWarehouseCode(), afterSaleOrderEo.getShopCode()));
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shopReturnWarehouseConfigList)) {
            throw new BizException(afterSaleOrderEo.getShopCode() + "\u5e97\u94fa\u672a\u914d\u7f6e\u9000\u8d27\u5165\u5e93\u4ed3");
        }
        if (shopReturnWarehouseConfigList.stream().noneMatch(ld -> ld.getReturnWarehouseCode().equals(warehouseCode))) {
            throw new BizException(afterSaleOrderEo.getShopCode() + "\u5e97\u94fa\u9000\u8d27\u4ed3\u5e93\u672a\u914d\u7f6e\u6b64\u9000\u8d27\u5165\u5e93\u4ed3");
        }
    }

    private LogicalWarehouseRespDto getLogicWarehouseRespDto(DgAfterBatchReturnWarehouseReqDto dto) {
        LogicalWarehouseRespDto logicalWarehouseRespDto = (LogicalWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApi.queryLogicWarehouseByCode(dto.getReturnWarehouseCode()));
        AssertUtils.isFalse((boolean)ObjectUtils.isEmpty((Object)logicalWarehouseRespDto), (String)"\u9000\u8d27\u4ed3\u4e0d\u5b58\u5728");
        log.info("\u6839\u636e\u4ed3\u5e93code\u67e5\u8be2\u51fa\u7684\u9000\u8d27\u4ed3\uff1a{}", (Object)logicalWarehouseRespDto);
        return logicalWarehouseRespDto;
    }

    @Override
    public void modifyLogiscticWarehouseInfo(DgAfterSaleOrderReqDto modifyReqDto) {
        DgAfterSaleOrderLogisticsWarehouseEo logisticsWarehouseEo = this.dgAfterSaleOrderLogisticsWarehouseDomain.selectByAfterSaleOrderId(modifyReqDto.getId());
        AssertUtils.isFalse((logisticsWarehouseEo == null ? 1 : 0) != 0, (String)"\u672a\u67e5\u5230\u552e\u540e\u5355\u7269\u6d41\u4fe1\u606f\uff0c\u66f4\u65b0\u5f02\u5e38");
        DgAfterSaleOrderLogisticsWarehouseEo updateEo = new DgAfterSaleOrderLogisticsWarehouseEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)modifyReqDto, (String[])new String[0]);
        updateEo.setId(logisticsWarehouseEo.getId());
        this.dgAfterSaleOrderLogisticsWarehouseDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void modifyAfterSaleOrderInfo(DgAfterSaleOrderReqDto afterSaleOrderReqDto) {
        AssertUtils.isFalse((afterSaleOrderReqDto.getId() == null ? 1 : 0) != 0, (String)"\u53c2\u6570\u552e\u540e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        CubeBeanUtils.copyProperties((Object)dgAfterSaleOrderEo, (Object)afterSaleOrderReqDto, (String[])new String[0]);
        this.dgAfterSaleOrderDomain.updateSelective((BaseEo)dgAfterSaleOrderEo);
    }

    @Override
    public void modifyAfterSaleOrderCompleteDate(Long id, Date completeDate) {
        AssertUtils.isFalse((id == null ? 1 : 0) != 0, (String)"\u53c2\u6570\u552e\u540e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        dgAfterSaleOrderEo.setId(id);
        dgAfterSaleOrderEo.setCompleteDate(completeDate);
        this.dgAfterSaleOrderDomain.updateSelective((BaseEo)dgAfterSaleOrderEo);
    }

    @Override
    public void updateAbolishFlag(Long afsOrderId, String abolishFlag) {
        AssertUtils.isFalse((afsOrderId == null ? 1 : 0) != 0, (String)"\u53c2\u6570\u552e\u540e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)abolishFlag), (String)"\u53c2\u6570\u4f5c\u5e9f\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        dgAfterSaleOrderEo.setId(afsOrderId);
        dgAfterSaleOrderEo.setAbolishFlag(abolishFlag);
        this.dgAfterSaleOrderDomain.updateSelective((BaseEo)dgAfterSaleOrderEo);
    }

    @Override
    public void updateBatchPlanPickUpDate(List<DgAfterSaleOrderDto> reqDtoList) {
        this.dgAfterSaleOrderDomain.updateBatchPlanPickUpDate(reqDtoList);
    }

    @Override
    public void modifyVoucher(DgAfterSaleOrderVoucherDto reqDto) {
        AssertUtils.notEmpty((Collection)reqDto.getAfterSalesVoucherList(), (String)"\u552e\u540e\u51ed\u8bc1\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((Objects.isNull(reqDto.getId()) && StringUtils.isBlank((CharSequence)reqDto.getAfterSaleOrderNo()) ? 1 : 0) != 0, (String)"id\u6216\u8005\u5355\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        StringBuilder builder = new StringBuilder();
        String separator = ";";
        for (String image : reqDto.getAfterSalesVoucherList()) {
            image = image.replace(separator, "\\" + separator);
            builder.append(image).append(separator);
        }
        DgAfterSaleOrderEo eo = new DgAfterSaleOrderEo();
        eo.setAfterSalesVoucher(builder.toString());
        QueryWrapBuilder updateWrapper = new QueryWrapBuilder((BaseEo)eo);
        if (Objects.nonNull(reqDto.getId())) {
            updateWrapper.eq(BaseEo::getId, (Object)reqDto.getId());
        } else if (StringUtils.isNotBlank((CharSequence)reqDto.getAfterSaleOrderNo())) {
            updateWrapper.eq(DgAfterSaleOrderEo::getAfterSaleOrderNo, (Object)reqDto.getAfterSaleOrderNo());
        }
        updateWrapper.builder();
        this.dgAfterSaleOrderDomain.updateSelectiveSqlFilter((BaseEo)eo);
    }

    @Override
    public void updateAmount(ArrayList<DgAfterSaleOrderItemDto> updateItemList, List<DgAfterSaleOrderItemRespDto> dgAfterSaleOrderItemRespDtos) {
        log.info("\u65e0\u539f\u5355\u552e\u540e\u5355\u66f4\u65b0\u5b9e\u9000\u91d1\u989d\uff1a{}", (Object)JSON.toJSONString(dgAfterSaleOrderItemRespDtos));
        dgAfterSaleOrderItemRespDtos.forEach(dgAfterSaleOrderItemRespDto -> {
            dgAfterSaleOrderItemRespDto.setCustomerAnalyseNum(dgAfterSaleOrderItemRespDto.getQualityTestAnalyseNum());
            dgAfterSaleOrderItemRespDto.setActualRefundAmount(dgAfterSaleOrderItemRespDto.getCustomerAnalyseNum().multiply(dgAfterSaleOrderItemRespDto.getRefundPrice()));
            dgAfterSaleOrderItemRespDto.setActualRefundPrice(BigDecimal.ZERO);
            if (ObjectUtil.isNotEmpty((Object)dgAfterSaleOrderItemRespDto.getActualReturnNum()) && dgAfterSaleOrderItemRespDto.getActualReturnNum() != 0) {
                dgAfterSaleOrderItemRespDto.setActualRefundPrice(dgAfterSaleOrderItemRespDto.getActualRefundAmount().divide(BigDecimal.valueOf(dgAfterSaleOrderItemRespDto.getActualReturnNum().intValue()), 2, RoundingMode.HALF_UP));
            }
            dgAfterSaleOrderItemRespDto.setSettlementAmount(dgAfterSaleOrderItemRespDto.getCustomerAnalyseNum().multiply(dgAfterSaleOrderItemRespDto.getRefundPrice()).setScale(2, RoundingMode.HALF_UP));
            dgAfterSaleOrderItemRespDto.setSettlementPrice(BigDecimal.ZERO);
            if (ObjectUtil.isNotEmpty((Object)dgAfterSaleOrderItemRespDto.getActualReturnNum()) && dgAfterSaleOrderItemRespDto.getActualReturnNum() != 0) {
                dgAfterSaleOrderItemRespDto.setSettlementPrice(dgAfterSaleOrderItemRespDto.getSettlementAmount().divide(BigDecimal.valueOf(dgAfterSaleOrderItemRespDto.getActualReturnNum().intValue()), 2, RoundingMode.HALF_UP));
            }
            updateItemList.add((DgAfterSaleOrderItemDto)dgAfterSaleOrderItemRespDto);
        });
        DgAfterSaleOrderDto afterSaleOrderDto = new DgAfterSaleOrderDto();
        afterSaleOrderDto.setItemDtoList(updateItemList);
        this.dgAfterSaleOrderItemDomain.fillAfterItemNum(afterSaleOrderDto);
        log.info("\u66f4\u65b0\u91d1\u989d\u5546\u54c1\u5217\u8868\uff1a{}", (Object)JSON.toJSONString(updateItemList));
    }

    @Override
    public void refund(Long afsOrderId) {
        AssertUtils.isFalse((afsOrderId == null ? 1 : 0) != 0, (String)"\u53c2\u6570\u552e\u540e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = this.dgAfterSaleOrderDomain.queryById(afsOrderId);
        AssertUtils.isFalse((afterSaleOrderRespDto == null ? 1 : 0) != 0, (String)"\u552e\u540e\u5355\u672a\u67e5\u5230");
        List dgAfterSaleOrderItemEos = this.dgAfterSaleOrderItemDomain.queryEosByAfterSaleOrderId(afsOrderId);
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)dgAfterSaleOrderItemEos), (String)"\u552e\u540e\u5546\u54c1\u672a\u67e5\u5230");
        List orderItemLineEos = this.dgPerformOrderItemLineDomain.queryItemLineByAfterOrderId(afsOrderId);
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)orderItemLineEos), (String)"\u552e\u540e\u5546\u54c1\u660e\u7ec6\u884c\u672a\u67e5\u5230");
        List saleItemLineAmountDtos = this.dgPerformOrderItemLineAmountDomain.queryByOrderItemLineIds(orderItemLineEos.stream().map(DgPerformOrderItemLineEo::getShReleationItemLineId).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty((Collection)saleItemLineAmountDtos)) {
            log.info("\u6ca1\u6709\u652f\u4ed8\u8bb0\u5f55\u7684,\u9ed8\u8ba4\u90fd\u662f\u5e73\u53f0\u5355\u8fc7\u6765\u7684\u6570\u636e,\u76f4\u63a5\u6267\u884c\u540e\u7eed\u7684\u66f4\u6539\u9000\u6b3e\u72b6\u6001\u4e0e\u5546\u54c1\u884c\u72b6\u6001");
            return;
        }
        List orderItemLineAmountDtos = saleItemLineAmountDtos.stream().filter(dto -> dto.getAmountSource().equals(DgOrderAmountSourceEnum.COST.getCode())).collect(Collectors.toList());
        ArrayList refundOrderItemLineAmountDtos = Lists.newArrayList();
        refundOrderItemLineAmountDtos = new ArrayList(orderItemLineAmountDtos);
        Map<String, List<DgPerformOrderItemLineAmountDto>> refundMethodMap = refundOrderItemLineAmountDtos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineAmountDto::getAccountType));
        DgRefundEo refundEo = this.buildRefundEo(afterSaleOrderRespDto, dgAfterSaleOrderItemEos);
        ArrayList refundDetailEos = Lists.newArrayList();
        for (Map.Entry<String, List<DgPerformOrderItemLineAmountDto>> map : refundMethodMap.entrySet()) {
            String payMethod = map.getKey();
            List<DgPerformOrderItemLineAmountDto> itemLineAmountDtos = map.getValue();
            BigDecimal refundAmount = itemLineAmountDtos.stream().map(DgPerformOrderItemLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            DgRefundDetailEo refundDetailEo = this.buildRefundDetailEo(payMethod, refundAmount, refundEo);
            refundDetailEos.add(refundDetailEo);
        }
        List<DgBasePayReqDto> payReqDtos = this.buildPayInfoReqDtos(refundDetailEos);
        B2COrderPaySelector.newInstance().refund(afterSaleOrderRespDto.getSaleOrderId(), payReqDtos, afterSaleOrderRespDto);
    }

    @Override
    public void updateStorageStatus(Long afsOrderId, String storageStatus) {
        AssertUtils.isFalse((afsOrderId == null ? 1 : 0) != 0, (String)"\u5165\u53c2\u552e\u540e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderEo afterSaleOrderEo = new DgAfterSaleOrderEo();
        afterSaleOrderEo.setId(afsOrderId);
        afterSaleOrderEo.setStorageStatus(storageStatus);
        this.dgAfterSaleOrderDomain.updateSelective((BaseEo)afterSaleOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void B2CRefund(Long afsOrderId) {
        AssertUtils.isFalse((afsOrderId == null ? 1 : 0) != 0, (String)"\u53c2\u6570\u552e\u540e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = this.dgAfterSaleOrderDomain.queryById(afsOrderId);
        AssertUtils.isFalse((afterSaleOrderRespDto == null ? 1 : 0) != 0, (String)"\u552e\u540e\u5355\u672a\u67e5\u5230");
        if (afterSaleOrderRespDto.getSaleOrderId() == null) {
            log.info("\u65e0\u539f\u5355\u4e0d\u5904\u7406\u8d26\u6237\u9000\u6b3e");
            return;
        }
        if (!(AfterSaleOrderTypeEnum.THTK.getCode().equals(afterSaleOrderRespDto.getAfterSaleOrderType()) || AfterSaleOrderTypeEnum.FHHTK.getCode().equals(afterSaleOrderRespDto.getAfterSaleOrderType()) || AfterSaleOrderTypeEnum.HH.getCode().equals(afterSaleOrderRespDto.getAfterSaleOrderType()))) {
            log.info("\u552e\u540e\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u53ea\u6709\u53d1\u8d27\u540e\u9000\u6b3e\uff0c\u9000\u8d27\u9000\u6b3e\u624d\u9700\u8981\u9000\u6b3e");
            return;
        }
        List afterSaleOrderItemEos = this.dgAfterSaleOrderItemDomain.queryEosByAfterSaleOrderId(afsOrderId);
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)afterSaleOrderItemEos), (String)"\u552e\u540e\u5546\u54c1\u672a\u67e5\u5230");
        List<DgAfterSaleOrderItemEo> dgAfterSaleOrderItemEos = afterSaleOrderItemEos.stream().filter(d -> d.getAfterSaleOrderItemType().equals(AfterSaleOrderItemTypeEnum.SH.getType())).collect(Collectors.toList());
        List orderLineIds = dgAfterSaleOrderItemEos.stream().map(DgAfterSaleOrderItemEo::getSaleOrderItemId).collect(Collectors.toList());
        List dgPerformOrderLineDtos = this.dgPerformOrderLineDomain.queryDtosByOrderIdAndIdList(afterSaleOrderRespDto.getSaleOrderId(), orderLineIds);
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)dgPerformOrderLineDtos), (String)"\u552e\u540e\u5355\u5173\u8054\u8ba2\u5355\u884c\u4fe1\u606f\u672a\u627e\u5230");
        List orderLineAmountDtos = this.dgPerformOrderLineAmountDomain.queryByOrderLineIdsAndSource(orderLineIds, DgOrderAmountSourceEnum.ORDER_LINE_AMOUNT.getCode());
        if (CollectionUtils.isEmpty((Collection)orderLineAmountDtos)) {
            log.info("\u8ba2\u5355\u672a\u5173\u8054\u4ed8\u6b3e\u8bb0\u5f55,\u4e0d\u9700\u8981\u9000\u6b3e");
            return;
        }
        List refundItemEoList = this.dgRefundItemDomain.queryEosBySaleOrderItemIds(orderLineIds);
        if (AfterSaleOrderTypeEnum.THTK.getCode().equals(afterSaleOrderRespDto.getAfterSaleOrderType()) || AfterSaleOrderTypeEnum.HH.getCode().equals(afterSaleOrderRespDto.getAfterSaleOrderType())) {
            this.b2cTHTKRefund(afterSaleOrderRespDto, dgPerformOrderLineDtos, dgAfterSaleOrderItemEos, orderLineAmountDtos, refundItemEoList);
        } else {
            this.b2cFHHJTKRefund(afterSaleOrderRespDto, dgAfterSaleOrderItemEos, orderLineAmountDtos);
        }
    }

    @Override
    public void updateRefundStatus(Long afsOrderId, String refundStatus) {
        AssertUtils.isFalse((afsOrderId == null ? 1 : 0) != 0, (String)"\u5165\u53c2\u552e\u540e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderEo afterSaleOrderEo = new DgAfterSaleOrderEo();
        afterSaleOrderEo.setId(afsOrderId);
        afterSaleOrderEo.setRefundStatus(refundStatus);
        this.dgAfterSaleOrderDomain.updateSelective((BaseEo)afterSaleOrderEo);
    }

    @Override
    public void modifyReceiveRejectReason(Long id, String reason) {
        AssertUtils.isFalse((id == null ? 1 : 0) != 0, (String)"\u5165\u53c2\u552e\u540e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderEo afterSaleOrderEo = new DgAfterSaleOrderEo();
        afterSaleOrderEo.setId(id);
        afterSaleOrderEo.setReceiveRejectReason(reason);
        this.dgAfterSaleOrderDomain.updateSelective((BaseEo)afterSaleOrderEo);
    }

    @Override
    public void modifyQualityRejectReason(Long id, String reason) {
        AssertUtils.isFalse((id == null ? 1 : 0) != 0, (String)"\u5165\u53c2\u552e\u540e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderEo afterSaleOrderEo = new DgAfterSaleOrderEo();
        afterSaleOrderEo.setId(id);
        afterSaleOrderEo.setQualityRejectReason(reason);
        this.dgAfterSaleOrderDomain.updateSelective((BaseEo)afterSaleOrderEo);
    }

    @Override
    public void updateCancelDesc(Long id, String cancelDesc, Date date) {
        AssertUtils.isFalse((id == null ? 1 : 0) != 0, (String)"\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderEo updateEo = new DgAfterSaleOrderEo();
        updateEo.setId(id);
        updateEo.setCancelDesc(cancelDesc);
        updateEo.setCancelTime(date);
        this.dgAfterSaleOrderDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void updateOaAuditStatus(Long id, String oaAuditStatus) {
        AssertUtils.isFalse((id == null ? 1 : 0) != 0, (String)"\u552e\u540e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)oaAuditStatus), (String)"OA\u5ba1\u6838\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderEo updateEo = new DgAfterSaleOrderEo();
        updateEo.setId(id);
        updateEo.setOaAuditStatus(oaAuditStatus);
        this.dgAfterSaleOrderDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void updateInWarehouseDate(Long businessId, Date date) {
        AssertUtils.isFalse((businessId == null ? 1 : 0) != 0, (String)"\u552e\u540e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderEo eo = new DgAfterSaleOrderEo();
        eo.setId(businessId);
        eo.setInWarehouseDate(new Date());
        this.dgAfterSaleOrderDomain.updateSelective((BaseEo)eo);
    }

    @Override
    public void updaAfsOrderItemActualyAmountByApplyRefundAmount(Long afsOrderId) {
        AssertUtils.isFalse((afsOrderId == null ? 1 : 0) != 0, (String)"\u53c2\u6570afsOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        List itemEoList = this.dgAfterSaleOrderItemDomain.queryEosByAfterSaleOrderId(afsOrderId);
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)itemEoList), (String)"\u672a\u67e5\u8be2\u5230\u9000\u8d27\u5546\u54c1\u660e\u7ec6");
        for (DgAfterSaleOrderItemEo afsOrderItem : itemEoList) {
            DgAfterSaleOrderItemEo afterSaleOrderItemEo = new DgAfterSaleOrderItemEo();
            afterSaleOrderItemEo.setActualRefundPrice(afsOrderItem.getRefundPrice());
            afterSaleOrderItemEo.setActualRefundAmount(afsOrderItem.getRefundAmount());
            afterSaleOrderItemEo.setActualReturnNum(afsOrderItem.getReturnNum());
            afterSaleOrderItemEo.setSettlementAmount(afsOrderItem.getRefundAmount());
            afterSaleOrderItemEo.setSettlementPrice(afsOrderItem.getRefundPrice());
            afterSaleOrderItemEo.setId(afsOrderItem.getId());
            this.dgAfterSaleOrderItemDomain.updateSelective((BaseEo)afterSaleOrderItemEo);
        }
    }

    @Override
    public void updateWmsRevokeReason(Long id, String revokeReason) {
        AssertUtils.isFalse((id == null ? 1 : 0) != 0, (String)"\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        dgAfterSaleOrderEo.setId(id);
        dgAfterSaleOrderEo.setRevokeReason(revokeReason);
        this.dgAfterSaleOrderDomain.updateSelective((BaseEo)dgAfterSaleOrderEo);
    }

    @Override
    public void modifyReturnType(Long id, Integer code) {
        AssertUtils.isFalse((id == null ? 1 : 0) != 0, (String)"\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        dgAfterSaleOrderEo.setId(id);
        dgAfterSaleOrderEo.setReturnType(code);
        this.dgAfterSaleOrderDomain.updateSelective((BaseEo)dgAfterSaleOrderEo);
    }

    @Override
    public void modifyInWarehouseTime(Long id, Date date) {
        AssertUtils.isFalse((id == null ? 1 : 0) != 0, (String)"\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        dgAfterSaleOrderEo.setId(id);
        dgAfterSaleOrderEo.setInWarehouseDate(date);
        this.dgAfterSaleOrderDomain.updateSelective((BaseEo)dgAfterSaleOrderEo);
    }

    @Override
    public void logicDeleteAndSaveReturnShippingSnList(Long afterSaleId, String returnShippingSn) {
        AssertUtils.isFalse((afterSaleId == null ? 1 : 0) != 0, (String)"\u53c2\u6570afterSaleId\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotBlank((CharSequence)returnShippingSn)) {
            this.dgAfterSaleOrderReturnShippingSnDomain.logicDeleteByAfsOrderId(afterSaleId);
            String[] returnShippings = returnShippingSn.split(",");
            ArrayList returnShippingSnEos = Lists.newArrayList();
            for (String returnShipping : returnShippings) {
                DgAfterSaleOrderReturnShippingSnEo eo = new DgAfterSaleOrderReturnShippingSnEo();
                eo.setAfterSaleOrderId(afterSaleId);
                eo.setReturnShippingSn(returnShipping);
                eo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                returnShippingSnEos.add(eo);
            }
            this.dgAfterSaleOrderReturnShippingSnDomain.insertBatch((List)returnShippingSnEos);
        }
    }

    private void b2cTHTKRefund(DgAfterSaleOrderRespDto afterSaleOrderRespDto, List<DgPerformOrderLineDto> dgPerformOrderLineDtos, List<DgAfterSaleOrderItemEo> dgAfterSaleOrderItemEos, List<DgPerformOrderLineAmountDto> orderLineAmountDtos, List<DgRefundItemEo> refundItemEoList) {
        Map lineDtoMap = dgPerformOrderLineDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity()));
        Map<Long, List<DgPerformOrderLineAmountDto>> orderLinePayMap = orderLineAmountDtos.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountDto::getOrderLineId));
        this.buildOrderLineSettlementAmount(dgPerformOrderLineDtos, orderLinePayMap);
        Map<Object, Object> saleOrderItemRefundMap = new HashMap();
        if (CollectionUtils.isNotEmpty(refundItemEoList)) {
            saleOrderItemRefundMap = refundItemEoList.stream().collect(Collectors.groupingBy(DgRefundItemEo::getBizItemId));
        }
        DgRefundEo dgRefundEo = new DgRefundEo();
        ArrayList dgRefundDetailEos = Lists.newArrayList();
        ArrayList dgRefundItemEoList = Lists.newArrayList();
        for (DgAfterSaleOrderItemEo dgAfterSaleOrderItemEo : dgAfterSaleOrderItemEos) {
            DgPerformOrderLineDto orderLineDto = (DgPerformOrderLineDto)lineDtoMap.get(dgAfterSaleOrderItemEo.getSaleOrderItemId());
            List<DgPerformOrderLineAmountDto> lineAmountDtoList = orderLinePayMap.get(dgAfterSaleOrderItemEo.getSaleOrderItemId());
            ArrayList lineAmountDtos = Lists.newArrayList();
            Map<String, List<DgPerformOrderLineAmountDto>> listMap = lineAmountDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountDto::getAccountType));
            for (Map.Entry<String, List<DgPerformOrderLineAmountDto>> map : listMap.entrySet()) {
                BigDecimal decimal = map.getValue().stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                DgPerformOrderLineAmountDto lineAmountDto = new DgPerformOrderLineAmountDto();
                CubeBeanUtils.copyProperties((Object)lineAmountDto, (Object)map.getValue().get(0), (String[])new String[0]);
                lineAmountDto.setAmount(decimal);
                lineAmountDtos.add(lineAmountDto);
            }
            BigDecimal refundedNumber = new BigDecimal(dgAfterSaleOrderItemEo.getItemNum());
            BigDecimal refundedAmount = BigDecimal.ZERO;
            List dgRefundItemEos = (List)saleOrderItemRefundMap.get(dgAfterSaleOrderItemEo.getSaleOrderItemId());
            if (CollectionUtils.isNotEmpty((Collection)dgRefundItemEos)) {
                refundedAmount = dgRefundItemEos.stream().map(DgRefundItemEo::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            BigDecimal settlementRefundAmount = this.caculateOrderLineSettlementRefundAmount(dgAfterSaleOrderItemEo.getSaleOrderItemId(), orderLineDto.getSettlementAmount(), new BigDecimal(dgAfterSaleOrderItemEo.getItemNum()), orderLineDto.getItemNum(), refundedNumber, refundedAmount);
            this.caculateRefundItemAccountRefundDetails(settlementRefundAmount, dgRefundItemEos, dgAfterSaleOrderItemEo, lineAmountDtos, refundedNumber, orderLineDto.getItemNum(), dgRefundItemEoList);
        }
        this.buildRefundDetailsEosByRefundItemEos(dgRefundItemEoList, afterSaleOrderRespDto, dgRefundDetailEos);
        dgRefundEo = this.buildRefundEoByRefundDetails(afterSaleOrderRespDto, dgRefundDetailEos);
        for (DgRefundItemEo refundItemEo : dgRefundItemEoList) {
            refundItemEo.setRefundId(dgRefundEo.getId());
            refundItemEo.setRefundOrderNo(dgRefundEo.getRefundNo());
            refundItemEo.setAfterSaleOrderId(afterSaleOrderRespDto.getId());
            refundItemEo.setAfterSaleOrderNo(afterSaleOrderRespDto.getAfterSaleOrderNo());
        }
        for (DgRefundDetailEo dfRefundDetailEo : dgRefundDetailEos) {
            dfRefundDetailEo.setRefundId(dgRefundEo.getId());
            dfRefundDetailEo.setRefundOrderNo(dgRefundEo.getRefundNo());
            dfRefundDetailEo.setAfterSaleOrderId(afterSaleOrderRespDto.getId());
            dfRefundDetailEo.setAfterSaleOrderNo(afterSaleOrderRespDto.getAfterSaleOrderNo());
        }
        List<DgBasePayReqDto> payReqDtos = this.buildPayInfoReqDtos(dgRefundDetailEos);
        this.dgRefundDomain.insert((BaseEo)dgRefundEo);
        this.dgRefundDetailDomain.insertBatch((List)dgRefundDetailEos);
        this.dgRefundItemDomain.insertBatch((List)dgRefundItemEoList);
        RestResponse<List<AccountTradeRespDto>> restResponse = B2COrderPaySelector.newInstance().refund(afterSaleOrderRespDto.getSaleOrderId(), payReqDtos, afterSaleOrderRespDto);
        if (restResponse.getResultCode().equals("0")) {
            Date date = new Date();
            dgRefundEo.setStatus(DgAfterSaleOrderRefundStatusEnum.REFUNDED.getCode());
            this.dgRefundDomain.updateSelective((BaseEo)dgRefundEo);
            List tradeRespDtos = (List)restResponse.getData();
            for (DgRefundDetailEo refundDetailEo : dgRefundDetailEos) {
                for (AccountTradeRespDto tradeRespDto : tradeRespDtos) {
                    if (!refundDetailEo.getRefundWay().equals(tradeRespDto.getAccountType())) continue;
                    refundDetailEo.setRefundTradeNo(tradeRespDto.getFlowNo());
                }
                refundDetailEo.setRefundTime(date);
                refundDetailEo.setStatus(NewDgRefundDetailStatusEnum.REFUND_SUCCESSFUL.getCode());
                this.dgRefundDetailDomain.updateSelective((BaseEo)refundDetailEo);
            }
        }
    }

    private DgRefundEo buildRefundEoByRefundDetails(DgAfterSaleOrderRespDto afterSaleOrderRespDto, List<DgRefundDetailEo> dfRefundDetailEos) {
        BigDecimal refundAmount = dfRefundDetailEos.stream().map(DgRefundDetailEo::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        DgRefundEo refundEo = new DgRefundEo();
        refundEo.setBizOrderId(afterSaleOrderRespDto.getSaleOrderId());
        refundEo.setBizOrderNo(afterSaleOrderRespDto.getSaleOrderNo());
        refundEo.setRefundAmount(refundAmount);
        refundEo.setRefundNo(TradeUtil.generateTradeNo((String)afterSaleOrderRespDto.getSaleOrderNo()));
        refundEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
        refundEo.setStatus(DgAfterSaleOrderRefundStatusEnum.WAIT_REFUND.getCode());
        refundEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
        refundEo.setAfterSaleOrderId(afterSaleOrderRespDto.getId());
        refundEo.setAfterSaleOrderNo(afterSaleOrderRespDto.getAfterSaleOrderNo());
        log.info("refundEo:{}", (Object)JSON.toJSONString((Object)refundEo));
        return refundEo;
    }

    private List<DgRefundDetailEo> buildRefundDetailsEosByRefundItemEos(List<DgRefundItemEo> dgRefundItemEoList, DgAfterSaleOrderRespDto afterSaleOrderRespDto, List<DgRefundDetailEo> dgRefundDetailEos) {
        Map<String, List<DgRefundItemEo>> refundWayMap = dgRefundItemEoList.stream().collect(Collectors.groupingBy(DgRefundItemEo::getRefundWay));
        for (Map.Entry<String, List<DgRefundItemEo>> map : refundWayMap.entrySet()) {
            Long id = IdGenrator.getDistributedId();
            List<DgRefundItemEo> dgRefundItemEos = map.getValue();
            BigDecimal refundAmount = dgRefundItemEos.stream().map(DgRefundItemEo::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            DgRefundDetailEo dgRefundDetailEo = new DgRefundDetailEo();
            dgRefundDetailEo.setRefundWay(map.getKey());
            dgRefundDetailEo.setRefundType(ItemCountsTypeEnum.NO.getCode());
            dgRefundDetailEo.setRefundAmount(refundAmount);
            dgRefundDetailEo.setBizOrderId(afterSaleOrderRespDto.getSaleOrderId());
            dgRefundDetailEo.setBizOrderNo(afterSaleOrderRespDto.getSaleOrderNo());
            dgRefundDetailEo.setStatus(NewDgRefundDetailStatusEnum.TO_BE_REFUNDED.getCode());
            dgRefundDetailEo.setAfterSaleOrderNo(afterSaleOrderRespDto.getAfterSaleOrderNo());
            dgRefundDetailEo.setId(id);
            for (DgRefundItemEo dgRefundItemEo : dgRefundItemEos) {
                dgRefundItemEo.setRefundDetailId(id);
            }
            dgRefundDetailEos.add(dgRefundDetailEo);
        }
        log.info("dgRefundDetailEos:{}", (Object)JSON.toJSONString(dgRefundDetailEos));
        return dgRefundDetailEos;
    }

    private List<DgRefundItemEo> caculateRefundItemAccountRefundDetails(BigDecimal settlementRefundAmount, List<DgRefundItemEo> dgRefundItemEos, DgAfterSaleOrderItemEo dgAfterSaleOrderItemEo, List<DgPerformOrderLineAmountDto> lineAmountDtos, BigDecimal refundedNum, BigDecimal itemNum, List<DgRefundItemEo> dgRefundItemEoList) {
        log.info("\u7ed3\u7b97\u91d1\u989d-settlementRefundAmount:{},\u5df2\u9000\u6b3e\u660e\u7ec6-dgRefundItemEos:{},\u552e\u540e\u5546\u54c1\u884c\u660e\u7ec6:{},lineAmountDtos:{}", new Object[]{settlementRefundAmount, JSON.toJSONString(dgRefundItemEos), JSON.toJSONString((Object)dgAfterSaleOrderItemEo), JSON.toJSONString(lineAmountDtos)});
        log.info("\u552e\u540e\u5546\u54c1\u884c\u660e\u7ec6:{}", (Object)JSON.toJSONString(dgRefundItemEos));
        log.info("lineAmountDtos:{}", (Object)JSON.toJSONString(lineAmountDtos));
        log.info("refundedNum:{},itemNum:{}", (Object)refundedNum, (Object)itemNum);
        Map<Object, Object> refundWayMap = new HashMap();
        if (CollectionUtils.isNotEmpty(dgRefundItemEos)) {
            refundWayMap = dgRefundItemEos.stream().collect(Collectors.groupingBy(DgRefundItemEo::getRefundWay));
        }
        log.info("\u5546\u54c1\u5df2\u9000\u6b3e\u6570\u91cf\uff1a{},\u5546\u54c1\u552e\u540e\u6570\u91cf:{},\u5546\u54c1\u9500\u552e\u6570\u91cf:{}", new Object[]{refundedNum, dgAfterSaleOrderItemEo.getItemNum(), itemNum});
        if (refundedNum.add(new BigDecimal(dgAfterSaleOrderItemEo.getItemNum())).compareTo(itemNum) == 0) {
            log.info("\u8be5\u5546\u54c1\u6700\u540e\u4e00\u4e2a\u6570\u91cf\u9000\u6b3e,\u51cf\u6cd5\u8ba1\u7b97\u6bcf\u4e2a\u8d26\u6237\u5269\u4f59\u5e94\u9000\u91d1\u989d");
            for (DgPerformOrderLineAmountDto lineAmountDto : lineAmountDtos) {
                BigDecimal refundedAmount = BigDecimal.ZERO;
                BigDecimal needRefundAmount = BigDecimal.ZERO;
                List refundItemEoList = (List)refundWayMap.get(lineAmountDto.getAccountType());
                if (CollectionUtils.isNotEmpty((Collection)refundItemEoList)) {
                    refundedAmount = refundItemEoList.stream().map(DgRefundItemEo::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                needRefundAmount = lineAmountDto.getAmount().multiply(BigDecimal.valueOf(dgAfterSaleOrderItemEo.getItemNum().intValue())).subtract(refundedAmount);
                DgRefundItemEo dgRefundItemEo = this.buildRefundItemEo(needRefundAmount, lineAmountDto, dgAfterSaleOrderItemEo);
                dgRefundItemEoList.add(dgRefundItemEo);
            }
        } else {
            log.info("\u8be5\u5546\u54c1\u975e\u6700\u540e\u4e00\u4e2a\u6570\u91cf\u9000\u6b3e,\u767e\u5206\u6bd4\u8ba1\u7b97\u5e94\u9000\u91d1\u989d");
            BigDecimal YFP_REFUND_AMOUNT = BigDecimal.ZERO;
            int i = 1;
            for (DgPerformOrderLineAmountDto lineAmountDto : lineAmountDtos) {
                BigDecimal needRefundAmount = BigDecimal.ZERO;
                needRefundAmount = lineAmountDtos.size() == i ? settlementRefundAmount.subtract(YFP_REFUND_AMOUNT) : lineAmountDto.getAmount().multiply(new BigDecimal(dgAfterSaleOrderItemEo.getItemNum())).divide(itemNum, 2, 1);
                YFP_REFUND_AMOUNT = YFP_REFUND_AMOUNT.add(needRefundAmount);
                DgRefundItemEo dgRefundItemEo = this.buildRefundItemEo(needRefundAmount, lineAmountDto, dgAfterSaleOrderItemEo);
                dgRefundItemEoList.add(dgRefundItemEo);
                ++i;
            }
        }
        log.info("\u9000\u6b3e\u660e\u7ec6:{}", (Object)JSON.toJSONString(dgRefundItemEoList));
        return dgRefundItemEoList;
    }

    private DgRefundItemEo buildRefundItemEo(BigDecimal refundedAmount, DgPerformOrderLineAmountDto lineAmountDto, DgAfterSaleOrderItemEo dgAfterSaleOrderItemEo) {
        DgRefundItemEo dgRefundItemEo = new DgRefundItemEo();
        dgRefundItemEo.setItemCode(dgAfterSaleOrderItemEo.getItemCode());
        dgRefundItemEo.setItemName(dgAfterSaleOrderItemEo.getItemName());
        dgRefundItemEo.setSkuCode(dgAfterSaleOrderItemEo.getSkuCode());
        dgRefundItemEo.setSkuName(dgAfterSaleOrderItemEo.getSkuName());
        dgRefundItemEo.setSaleOrderItemId(dgAfterSaleOrderItemEo.getSaleOrderItemId());
        dgRefundItemEo.setBizItemId(dgAfterSaleOrderItemEo.getSaleOrderItemId());
        dgRefundItemEo.setRefundWay(lineAmountDto.getAccountType());
        dgRefundItemEo.setRefundAmount(refundedAmount);
        return dgRefundItemEo;
    }

    private BigDecimal caculateOrderLineSettlementRefundAmount(Long saleOrderItemId, BigDecimal settlementAmount, BigDecimal applyRefundItemNum, BigDecimal totelItemNum, BigDecimal refundedNumber, BigDecimal refundedAmount) {
        BigDecimal refundAmount = BigDecimal.ZERO;
        refundAmount = refundedNumber.add(applyRefundItemNum).compareTo(totelItemNum) == 0 ? settlementAmount.multiply(applyRefundItemNum).subtract(refundedAmount) : settlementAmount.multiply(applyRefundItemNum);
        log.info("\u8ba2\u5355ID:{},\u7533\u8bf7\u9000\u6b3e\u6570\u91cf:{},\u5df2\u9000\u6570\u91cf:{},\u5e94\u9000\u91d1\u989d:{}", new Object[]{saleOrderItemId, applyRefundItemNum, refundedNumber, refundAmount});
        return refundAmount;
    }

    private void buildOrderLineSettlementAmount(List<DgPerformOrderLineDto> dgPerformOrderLineDtos, Map<Long, List<DgPerformOrderLineAmountDto>> lineAmountMap) {
        for (DgPerformOrderLineDto dgPerformOrderLineDto : dgPerformOrderLineDtos) {
            List<DgPerformOrderLineAmountDto> dgPerformOrderLineAmountDtos = lineAmountMap.get(dgPerformOrderLineDto.getId());
            BigDecimal settlementAmount = dgPerformOrderLineAmountDtos.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            dgPerformOrderLineDto.setSettlementAmount(settlementAmount);
            log.info("\u8ba2\u5355\u884cID:{},\u7ed3\u7b97\u91d1\u989d\u4e3a:{}", (Object)dgPerformOrderLineDto.getId(), (Object)settlementAmount);
        }
    }

    private void b2cFHHJTKRefund(DgAfterSaleOrderRespDto afterSaleOrderRespDto, List<DgAfterSaleOrderItemEo> dgAfterSaleOrderItemEos, List<DgPerformOrderLineAmountDto> orderLineAmountDtos) {
    }

    private List<DgBasePayReqDto> buildPayInfoReqDtos(List<DgRefundDetailEo> refundDetailEos) {
        ArrayList payReqDtoList = Lists.newArrayList();
        for (DgRefundDetailEo refundDetailEo : refundDetailEos) {
            DgBasePayReqDto payReqDto = new DgBasePayReqDto();
            payReqDto.setPayMethod(refundDetailEo.getRefundWay());
            payReqDto.setPayAmount(refundDetailEo.getRefundAmount());
            payReqDto.setRefundNo(refundDetailEo.getRefundTradeNo());
            payReqDto.setItemCountsType(ItemCountsTypeEnum.NO.getCode());
            payReqDto.setBusinessOrderNo(refundDetailEo.getAfterSaleOrderNo());
            payReqDtoList.add(payReqDto);
        }
        return payReqDtoList;
    }

    private DgRefundDetailEo buildRefundDetailEo(String payMethod, BigDecimal refundAmount, DgRefundEo refundEo) {
        DgRefundDetailEo refundDetailEo = new DgRefundDetailEo();
        refundDetailEo.setRefundId(refundEo.getId());
        refundDetailEo.setRefundOrderNo(refundEo.getBizOrderNo());
        refundDetailEo.setRefundWay(payMethod);
        refundDetailEo.setRefundAmount(refundAmount);
        return refundDetailEo;
    }

    private DgRefundEo buildRefundEo(DgAfterSaleOrderRespDto afterSaleOrderRespDto, List<DgAfterSaleOrderItemEo> afterSaleOrderItemEos) {
        int refundNumber = afterSaleOrderItemEos.stream().mapToInt(DgAfterSaleOrderItemEo::getItemNum).sum();
        BigDecimal refundAmount = afterSaleOrderItemEos.stream().map(DgAfterSaleOrderItemEo::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        DgRefundEo refundEo = new DgRefundEo();
        refundEo.setBizOrderId(afterSaleOrderRespDto.getSaleOrderId());
        refundEo.setRefundNum(Integer.valueOf(refundNumber));
        refundEo.setRefundAmount(refundAmount);
        refundEo.setBizOrderNo(afterSaleOrderRespDto.getSaleOrderNo());
        refundEo.setRefundNo(TradeUtil.generateTradeNo((String)afterSaleOrderRespDto.getSaleOrderNo()));
        refundEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
        refundEo.setStatus(DgAfterSaleOrderRefundStatusEnum.WAIT_REFUND.getCode());
        refundEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
        return refundEo;
    }
}

