/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.channel.Impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OptTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.AuditTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.OrderAuditReqDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.account.dto.biz.AccountMatchesItemRespDto;
import com.yunxi.dg.base.center.account.dto.entity.AccountDto;
import com.yunxi.dg.base.center.credit.dto.entity.CreditRepaymentSimpleDto;
import com.yunxi.dg.base.center.credit.dto.entity.RepaymentStrategiesSimpleDto;
import com.yunxi.dg.base.center.credit.proxy.entity.ICreditRepaymentDgApiProxy;
import com.yunxi.dg.base.center.credit.proxy.entity.IDemandRepaymentStrategiesDgApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.channel.IChannelOrderAuditAction;
import com.yunxi.dg.base.center.trade.action.oms.channel.IChannelOrderPayAction;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BAuditRevokeReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BOrderRejectReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.pay.DgPerformOrderPayReqDto;
import com.yunxi.dg.base.center.trade.dto.pay.base.DgBasePayReqDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderPaymentEo;
import com.yunxi.dg.base.center.trade.eo.OptLogEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgAccountProportionalControlService;
import com.yunxi.dg.base.center.trade.service.entity.IDgBusinessAuditService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelAccountService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelFeeControlService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IOptLogService;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ChannelOrderAuditActionImpl
implements IChannelOrderAuditAction {
    private static final Logger log = LoggerFactory.getLogger(ChannelOrderAuditActionImpl.class);
    @Resource
    private ICreditRepaymentDgApiProxy creditRepaymentDgApiProxy;
    @Resource
    private IChannelOrderPayAction channelOrderPayAction;
    @Resource
    private IContext context;
    @Resource
    private IOptLogService optLogService;
    @Resource
    private IChannelAccountService channelAccountService;
    @Resource
    private IDgBusinessAuditService dgBusinessAuditService;
    @Resource
    private IChannelFeeControlService channelFeeControlService;
    @Resource
    private IDgAccountProportionalControlService dgAccountProportionalControlService;
    @Resource
    private IDemandRepaymentStrategiesDgApiProxy demandRepaymentStrategiesDgApiProxy;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPerformOrderPaymentDomain performOrderPaymentDomain;

    @Override
    public void auditSaveOptLog(DgPerformOrderRespDto throughDtoDefine, OrderAuditReqDto request) {
        log.info("\u3010\u5ba1\u6838\u64cd\u4f5c\uff0c\u4fdd\u5b58\u5ba1\u6838\u64cd\u4f5c\u65e5\u5fd7,\u5ba1\u6838\u7c7b\u578b:{}\u3011", (Object)request.getAuditType());
        this.saveAuditOptRecord(throughDtoDefine, request);
    }

    @Override
    public RestResponse<Void> addBoOptLog(String bizNo, OptBizTypeEnum optBizTypeEnum, OptTypeEnum optTypeEnum, String desc) {
        log.info("\u4fdd\u5b58\u8ba2\u5355\u64cd\u4f5c\u65e5\u5fd7:{}", (Object)desc);
        this.optLogService.saveOptLog(optBizTypeEnum.getType(), bizNo, optTypeEnum.getType(), desc);
        return RestResponse.VOID;
    }

    @Override
    public void businessAuditPass(DgPerformOrderRespDto throughDtoDefine, OrderAuditReqDto request) {
        log.info("\u3010\u4e1a\u52a1\u5ba1\u6838\u901a\u8fc7\uff0c\u6682\u65f6\u65e0\u76f8\u5173\u4e1a\u52a1\u9700\u8981\u5904\u7406\u3011");
    }

    @Override
    public void financialAuditPass(DgPerformOrderRespDto throughDtoDefine, OrderAuditReqDto request) {
        log.info("\u3010\u8d22\u52a1\u5ba1\u6838\u901a\u8fc7\uff0c\u6682\u65f6\u65e0\u76f8\u5173\u4e1a\u52a1\u9700\u8981\u5904\u7406\u3011");
    }

    @Override
    public DgPerformOrderPayReqDto autoPayHandle(DgPerformOrderRespDto order, List<AccountCategoryEnum> accountCategoryEnums) {
        if (order.getPerformOrderPaymentDto().getRemainingPayAmount().compareTo(BigDecimal.ZERO) <= 0) {
            log.info("\u8ba2\u5355\u5df2\u7ecf\u5b8c\u6210\u652f\u4ed8");
            return new DgPerformOrderPayReqDto();
        }
        List<AccountDto> accountDtoList = this.channelAccountService.queryCapitalAccount(order.getSaleOrderNo(), accountCategoryEnums);
        List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(order.getId());
        order.setOrderLineList(orderLineDtos);
        this.feeControl(accountDtoList, order);
        return this.autoPay(order, accountDtoList);
    }

    private void feeControl(List<AccountDto> accountDtoList, DgPerformOrderRespDto order) {
        if (CollectionUtil.isNotEmpty(accountDtoList)) {
            this.channelFeeControlService.feeControlByAutoPay(accountDtoList, order);
        }
    }

    @Override
    public DgPerformOrderPayReqDto autoPay(DgPerformOrderRespDto order, List<AccountDto> accountDtoList) {
        DgPerformOrderPayReqDto payReqDto = new DgPerformOrderPayReqDto();
        payReqDto.setValidNegative(Boolean.TRUE);
        CreditRepaymentSimpleDto repaymentSimpleDto = null;
        log.info("\u8d26\u6237\u4fe1\u606f\uff1a{}", JSON.toJSON(accountDtoList));
        if (CollectionUtils.isEmpty(accountDtoList)) {
            log.info("[\u6784\u5efa\u81ea\u52a8\u6263\u6b3e\u9879]\u8ba2\u5355:{}\u6ca1\u6709\u8d26\u6237\u4fe1\u606f", (Object)order.getSaleOrderNo());
            return payReqDto;
        }
        Map<Long, BigDecimal> orderLineNeedPayAmountMap = this.calculateNeedPayAmount(order.getOrderLineList());
        log.info("\u5269\u4f59\u5546\u54c1\u5f85\u652f\u4ed8\u91d1\u989d\uff1a{}", JSON.toJSON(orderLineNeedPayAmountMap));
        Map<String, BigDecimal> accountPayMaxAmountMap = this.dgAccountProportionalControlService.getAccountPayMaxAmount(order, accountDtoList);
        List<DgBasePayReqDto> payReqDtos = this.getDgBasePayReqDtos(order, accountDtoList, payReqDto, order.getOrderLineList(), orderLineNeedPayAmountMap, accountPayMaxAmountMap);
        log.info("\u8d26\u6237\u5206\u644a\u4fe1\u606f\uff1a{}", JSON.toJSON(payReqDtos));
        if (CollectionUtils.isNotEmpty(payReqDtos)) {
            repaymentSimpleDto = this.creditRepayment(payReqDtos, accountDtoList, order, payReqDto, orderLineNeedPayAmountMap, accountPayMaxAmountMap);
            log.info("\u8fd8\u6b3e\u5165\u53c2\uff1a{}", JSON.toJSON((Object)repaymentSimpleDto));
            if (null != repaymentSimpleDto && repaymentSimpleDto.getIntercept().booleanValue()) {
                if (repaymentSimpleDto.getAmount().compareTo(BigDecimal.ZERO) > 0 || repaymentSimpleDto.getRebateAmount().compareTo(BigDecimal.ZERO) > 0) {
                    RestResponseHelper.checkOrThrow((RestResponse)this.creditRepaymentDgApiProxy.demandRepayment(repaymentSimpleDto));
                }
                log.info("\u968f\u5355\u8fd8\u6b3e -- \u6253\u65ad\u8fd8\u6b3e\u6d41\u7a0b");
                return payReqDto;
            }
        }
        payReqDto.setOrderId(order.getId());
        payReqDto.setPayReqDtos(payReqDtos);
        this.channelOrderPayAction.wholePay(order, payReqDto, false);
        if (null != repaymentSimpleDto) {
            RestResponseHelper.checkOrThrow((RestResponse)this.creditRepaymentDgApiProxy.demandRepayment(repaymentSimpleDto));
        }
        return payReqDto;
    }

    private CreditRepaymentSimpleDto creditRepayment(List<DgBasePayReqDto> payReqDtos, List<AccountDto> accountDtoList, DgPerformOrderRespDto order, DgPerformOrderPayReqDto payReqDto, Map<Long, BigDecimal> orderLineNeedPayAmountMap, Map<String, BigDecimal> accountPayMaxAmountMap) {
        BigDecimal advanceAmount = accountDtoList.stream().filter(e -> e.getAccountType().equals("YFK")).map(AccountDto::getDisposable).reduce(BigDecimal.ZERO, BigDecimal::add);
        log.info("\u9884\u4ed8\u6b3e\u8d26\u6237\u4f59\u989d:{}", (Object)advanceAmount);
        BigDecimal remainingPayAmount = order.getPerformOrderPaymentDto().getRemainingPayAmount();
        BigDecimal rebateAmount = payReqDtos.stream().filter(payReq -> Objects.equals(AccountCategoryEnum.COST.getCode(), payReq.getAccountCategory())).map(DgBasePayReqDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal paidAmount = remainingPayAmount.subtract(rebateAmount);
        log.info("\u968f\u5355\u8fd8\u6b3e\u8ba1\u7b97\u53c2\u6570 === \u8ba2\u5355\u5269\u4f59\u652f\u4ed8\u603b\u91d1\u989d:{} || \u8d39\u7528\u4f7f\u7528\u91d1\u989d:{} || \u5b9e\u4ed8\u91d1\u989d:{} ", new Object[]{remainingPayAmount, rebateAmount, paidAmount});
        Map<String, BigDecimal> map = this.getCreditAllWaitDebtAmount(order, rebateAmount, paidAmount);
        BigDecimal allWaitDebtAmount = map.get("allWaitDebtAmount");
        if (allWaitDebtAmount.compareTo(BigDecimal.ZERO) > 0) {
            log.info("\u81ea\u52a8\u4ed8\u6b3e--\u8fdb\u5165\u968f\u5355\u8fd8\u6b3e\u91cd\u7b97\u6d41\u7a0b,\u91d1\u989d:{}", (Object)allWaitDebtAmount);
            BigDecimal waitDebtAmount = map.get("waitDebtAmount");
            BigDecimal waitRebatePayableAmount = map.get("waitRebatePayableAmount");
            CreditRepaymentSimpleDto repaymentSimpleDto = new CreditRepaymentSimpleDto();
            repaymentSimpleDto.setCustomerId(order.getPerformOrderSnapshotDto().getCustomerId());
            repaymentSimpleDto.setCustomerCode(order.getPerformOrderSnapshotDto().getCustomerCode());
            repaymentSimpleDto.setBizNo(order.getSaleOrderNo());
            repaymentSimpleDto.setBillType(Integer.valueOf(1));
            repaymentSimpleDto.setShopId(order.getPerformOrderSnapshotDto().getShopId());
            repaymentSimpleDto.setReturnDate(new Date());
            repaymentSimpleDto.setValidNegative(Boolean.TRUE);
            repaymentSimpleDto.setIntercept(Boolean.FALSE);
            for (AccountDto accountDto : accountDtoList) {
                if (!"YFK".equals(accountDto.getAccountType())) continue;
                BigDecimal currPayAmount = BigDecimal.ZERO;
                if (accountDto.getIsPaymentPeriod() != null && YesNoEnum.YES.getValue().equals(accountDto.getIsPaymentPeriod())) {
                    log.info("\u8d26\u671f\u5ba2\u6237");
                    currPayAmount = allWaitDebtAmount;
                    repaymentSimpleDto.setValidNegative(Boolean.FALSE);
                    repaymentSimpleDto.setAmount(waitDebtAmount);
                    repaymentSimpleDto.setRebateAmount(waitRebatePayableAmount);
                } else if (accountDto.getDisposableMax().subtract(accountDto.getDisposable()).compareTo(allWaitDebtAmount) >= 0) {
                    log.info("\u4f59\u989d\u8db3\u591f-\u5168\u90e8\uff1a{}", (Object)accountDto.getDisposableMax());
                    currPayAmount = allWaitDebtAmount;
                    repaymentSimpleDto.setAmount(waitDebtAmount);
                    repaymentSimpleDto.setRebateAmount(waitRebatePayableAmount);
                } else if (accountDto.getDisposableMax().subtract(accountDto.getDisposable()).compareTo(allWaitDebtAmount) < 0 && accountDto.getDisposableMax().compareTo(allWaitDebtAmount) >= 0) {
                    log.info("\u4f59\u989d\u8db3\u591f-\u90e8\u5206\uff1a{}", (Object)accountDto.getDisposableMax());
                    currPayAmount = allWaitDebtAmount;
                    repaymentSimpleDto.setAmount(waitDebtAmount);
                    repaymentSimpleDto.setRebateAmount(waitRebatePayableAmount);
                    accountDto.setDisposable(accountDto.getDisposableMax().subtract(allWaitDebtAmount));
                } else {
                    log.info("\u4f59\u989d\u4e0d\u8db3\uff1a{}", (Object)accountDto.getDisposableMax());
                    currPayAmount = accountDto.getDisposableMax();
                    if (waitDebtAmount.compareTo(currPayAmount) > 0) {
                        waitDebtAmount = currPayAmount;
                        waitRebatePayableAmount = BigDecimal.ZERO;
                        repaymentSimpleDto.setAmount(currPayAmount);
                        repaymentSimpleDto.setRebateAmount(BigDecimal.ZERO);
                    }
                    if (currPayAmount.compareTo(waitDebtAmount) > 0 && currPayAmount.subtract(waitDebtAmount).compareTo(waitRebatePayableAmount) < 0) {
                        repaymentSimpleDto.setAmount(waitDebtAmount);
                        waitRebatePayableAmount = currPayAmount.subtract(waitDebtAmount);
                        repaymentSimpleDto.setRebateAmount(currPayAmount.subtract(waitDebtAmount));
                    }
                    repaymentSimpleDto.setIntercept(Boolean.TRUE);
                    accountDto.setDisposable(BigDecimal.ZERO);
                }
                log.info("\u9884\u4ed8\u6b3e\u8fd8\u6b3e\u968f\u5355\u8fd8\u6b3e\u91d1\u989d\uff1a{}", (Object)currPayAmount);
                break;
            }
            DgPerformOrderPaymentEo performOrderPaymentEo = this.performOrderPaymentDomain.selectByOrderId(order.getId());
            log.info("\u539f\u500d\u6570\u91d1\u989d\uff1a{} || \u539f\u500d\u6570\u8fd4\u5229\uff1a{}", (Object)performOrderPaymentEo.getRepaymentAmount(), (Object)performOrderPaymentEo.getRepaymentRebateAmount());
            DgPerformOrderPaymentEo orderPaymentEo = new DgPerformOrderPaymentEo();
            orderPaymentEo.setId(performOrderPaymentEo.getId());
            orderPaymentEo.setRepaymentAmount(performOrderPaymentEo.getRepaymentAmount().add(waitDebtAmount));
            orderPaymentEo.setRepaymentRebateAmount(performOrderPaymentEo.getRepaymentRebateAmount().add(waitRebatePayableAmount));
            this.performOrderPaymentDomain.updateSelective((BaseEo)orderPaymentEo);
            if (!repaymentSimpleDto.getIntercept().booleanValue()) {
                accountDtoList = accountDtoList.stream().filter(a -> a.getDisposable().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
                log.info("\u81ea\u52a8\u4ed8\u6b3e--\u968f\u5355\u8fd8\u6b3e\u6263\u9664\u968f\u5355\u540e\u8d26\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(accountDtoList));
                log.info("\u81ea\u52a8\u4ed8\u6b3e--\u8fdb\u5165\u8d26\u6237\u91cd\u65b0\u5206\u644a\u6d41\u7a0b");
                payReqDtos = this.getDgBasePayReqDtos(order, accountDtoList, payReqDto, order.getOrderLineList(), orderLineNeedPayAmountMap, accountPayMaxAmountMap);
            }
            return repaymentSimpleDto;
        }
        return null;
    }

    private List<DgBasePayReqDto> getDgBasePayReqDtos(DgPerformOrderRespDto order, List<AccountDto> accountDtoList, DgPerformOrderPayReqDto payReqDto, List<DgPerformOrderLineDto> orderLineDtos, Map<Long, BigDecimal> orderLineNeedPayAmountMap, Map<String, BigDecimal> accountPayMaxAmountMap) {
        BigDecimal remainingPayAmount = order.getPerformOrderPaymentDto().getRemainingPayAmount();
        ArrayList<DgBasePayReqDto> payReqDtos = new ArrayList<DgBasePayReqDto>();
        for (AccountDto accountDto : accountDtoList) {
            if (remainingPayAmount.compareTo(BigDecimal.ZERO) <= 0 || accountDto == null) continue;
            if (accountDto.getAccountType().equals("YDJ")) {
                log.info("\u9884\u5b9a\u91d1\u8d26\u6237\u4e0d\u81ea\u52a8\u4ed8\u6b3e");
                continue;
            }
            accountDto.setDisposableMax(accountDto.getDisposable());
            BigDecimal totalDisposable = accountDto.getDisposable();
            if (accountPayMaxAmountMap.containsKey(accountDto.getAccountType())) {
                BigDecimal maxPayAmount = accountPayMaxAmountMap.get(accountDto.getAccountType());
                totalDisposable = totalDisposable.min(maxPayAmount);
                accountDto.setDisposable(totalDisposable);
            }
            BigDecimal totalNeedPayAmount = BigDecimal.ZERO;
            if (CollectionUtil.isNotEmpty((Collection)accountDto.getItems())) {
                log.info("\u8d26\u6237\u3010{}\u3011\u9002\u914d\u5546\u54c1\uff1a{}", (Object)accountDto.getAccountType(), (Object)JSON.toJSONString((Object)accountDto.getItems()));
                List ids = accountDto.getItems().stream().map(AccountMatchesItemRespDto::getOrderItemId).collect(Collectors.toList());
                for (DgPerformOrderLineDto line : orderLineDtos) {
                    if (!ids.contains(line.getId()) || orderLineNeedPayAmountMap.get(line.getId()) == null) continue;
                    totalNeedPayAmount = totalNeedPayAmount.add(orderLineNeedPayAmountMap.get(line.getId()));
                }
                totalDisposable = totalDisposable.min(totalNeedPayAmount);
                accountDto.setDisposable(totalDisposable);
                log.info("\u8d26\u6237\u3010{}\u3011\u8fc7\u6ee4\u5546\u54c1\u540e\u53ef\u7528\u91d1\u989d\u4e3a\uff1a{}", (Object)accountDto.getAccountType(), (Object)totalDisposable);
            }
            if (accountDto.getIsPaymentPeriod() != null && YesNoEnum.YES.getValue().equals(accountDto.getIsPaymentPeriod())) {
                totalDisposable = remainingPayAmount;
                payReqDto.setValidNegative(Boolean.FALSE);
            }
            if (totalDisposable.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal currPayAmount = totalDisposable.min(remainingPayAmount);
            remainingPayAmount = remainingPayAmount.subtract(currPayAmount);
            DgBasePayReqDto dgBasePayReqDto = new DgBasePayReqDto();
            dgBasePayReqDto.setPayAmount(currPayAmount.setScale(2, 4));
            dgBasePayReqDto.setDisposable(accountDto.getDisposable());
            dgBasePayReqDto.setPayMethod(accountDto.getAccountType());
            dgBasePayReqDto.setAccountCategory(accountDto.getAccountCategory());
            dgBasePayReqDto.setAccountDtos(accountDto.getAccountDtos());
            dgBasePayReqDto.setMatchesItems(accountDto.getItems());
            dgBasePayReqDto.setGroup(accountDto.isGroup());
            dgBasePayReqDto.setItemCountsType(accountDto.getItemCountsType());
            dgBasePayReqDto.setCreditFileNo(accountDto.getCreditFileNo());
            dgBasePayReqDto.setSaleCompanyCode(accountDto.getSaleCompanyCode());
            payReqDtos.add(dgBasePayReqDto);
        }
        return payReqDtos;
    }

    private Map<String, BigDecimal> getCreditAllWaitDebtAmount(DgPerformOrderRespDto order, BigDecimal rebateAmount, BigDecimal paidAmount) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put("waitDebtAmount", BigDecimal.ZERO);
        map.put("waitRebatePayableAmount", BigDecimal.ZERO);
        map.put("allWaitDebtAmount", BigDecimal.ZERO);
        RepaymentStrategiesSimpleDto demandRepaymentStrategiesReqDto = new RepaymentStrategiesSimpleDto();
        demandRepaymentStrategiesReqDto.setBiNo(order.getSaleOrderNo());
        demandRepaymentStrategiesReqDto.setShopId(order.getPerformOrderSnapshotDto().getShopId());
        demandRepaymentStrategiesReqDto.setCustomerId(order.getPerformOrderSnapshotDto().getCustomerId());
        demandRepaymentStrategiesReqDto.setPaidAmount(paidAmount);
        demandRepaymentStrategiesReqDto.setRebateAmount(rebateAmount);
        log.info("[\u8ba2\u5355\u652f\u4ed8\u4fe1\u7528\u8fd8\u6b3e]\u8ba2\u5355\uff1a{}\uff0c\u67e5\u8be2\u968f\u5355\u8fd8\u6b3e\u91d1\u989d\u5165\u53c2\uff1a{}", (Object)order.getSaleOrderNo(), (Object)JSON.toJSONString((Object)demandRepaymentStrategiesReqDto));
        RepaymentStrategiesSimpleDto repaymentStrategiesSimpleDto = (RepaymentStrategiesSimpleDto)RestResponseHelper.extractData((RestResponse)this.demandRepaymentStrategiesDgApiProxy.getRepaymentAmount(demandRepaymentStrategiesReqDto));
        log.info("[\u8ba2\u5355\u652f\u4ed8\u4fe1\u7528\u8fd8\u6b3e]\u8ba2\u5355\uff1a{}\uff0c\u67e5\u8be2\u968f\u5355\u8fd8\u6b3e\u91d1\u989d\u51fa\u53c2\uff1a{}", (Object)order.getSaleOrderNo(), (Object)JSON.toJSONString((Object)repaymentStrategiesSimpleDto));
        BigDecimal allWaitDebtAmount = BigDecimal.ZERO;
        BigDecimal payableAmount = Optional.ofNullable(repaymentStrategiesSimpleDto.getPayableAmount()).orElse(BigDecimal.ZERO);
        BigDecimal waitDebtAmount = BigDecimal.ZERO;
        if (payableAmount.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal repaidMultipleAmount = Optional.ofNullable(repaymentStrategiesSimpleDto.getRepaidMultipleAmount()).orElse(BigDecimal.ZERO);
            waitDebtAmount = payableAmount.subtract(repaidMultipleAmount);
            if (waitDebtAmount.compareTo(BigDecimal.ZERO) >= 0) {
                allWaitDebtAmount = allWaitDebtAmount.add(waitDebtAmount);
                map.put("waitDebtAmount", waitDebtAmount);
            } else {
                allWaitDebtAmount = allWaitDebtAmount.add(payableAmount);
            }
        }
        BigDecimal rebatePayableAmount = Optional.ofNullable(repaymentStrategiesSimpleDto.getRebatePayableAmount()).orElse(BigDecimal.ZERO);
        BigDecimal waitRebatePayableAmount = BigDecimal.ZERO;
        if (rebatePayableAmount.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal repaidRebateAmount = Optional.ofNullable(repaymentStrategiesSimpleDto.getRepaidRebateAmount()).orElse(BigDecimal.ZERO);
            waitRebatePayableAmount = rebatePayableAmount.subtract(repaidRebateAmount);
            if (waitRebatePayableAmount.compareTo(BigDecimal.ZERO) >= 0) {
                allWaitDebtAmount = allWaitDebtAmount.add(waitRebatePayableAmount);
                map.put("waitRebatePayableAmount", waitRebatePayableAmount);
            } else {
                allWaitDebtAmount = allWaitDebtAmount.add(rebatePayableAmount);
            }
        }
        map.put("allWaitDebtAmount", allWaitDebtAmount);
        log.info("[\u8ba2\u5355\u652f\u4ed8\u4fe1\u7528\u8fd8\u6b3e]\u672c\u6b21\u652f\u4ed8\u500d\u6570\u968f\u5355\u8fd8\u6b3e\u91d1\u989d\uff1a{}\uff0c\u672c\u6b21\u652f\u4ed8\u8fd4\u5229\u62b5\u5145\u6b20\u6b3e\u968f\u5355\u8fd8\u6b3e\u91d1\u989d{},\u603b\u8fd8\u6b3e\u91d1\u989d\uff1a{}", new Object[]{waitDebtAmount, waitRebatePayableAmount, allWaitDebtAmount});
        return map;
    }

    private Map<Long, BigDecimal> calculateNeedPayAmount(List<DgPerformOrderLineDto> orderLineDtos) {
        HashMap<Long, BigDecimal> orderLineSurplusAmountMap = new HashMap<Long, BigDecimal>();
        for (DgPerformOrderLineDto line : orderLineDtos) {
            ArrayList transactionAmountList = CollectionUtil.isNotEmpty((Collection)line.getAmountDtoList()) ? line.getAmountDtoList().stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode())).collect(Collectors.toList()) : new ArrayList();
            BigDecimal transactionAmount = transactionAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            ArrayList payAmountList = CollectionUtil.isNotEmpty((Collection)line.getAmountDtoList()) ? line.getAmountDtoList().stream().filter(a -> a.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_LINE_AMOUNT.getCode()) || a.getAmountSource().equals(DgOrderAmountSourceEnum.COST.getCode())).collect(Collectors.toList()) : new ArrayList();
            BigDecimal payAmount = payAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal itemNeedPaymount = transactionAmount.subtract(payAmount);
            log.info("\u5546\u54c1\uff1a{}\uff0c\u6210\u4ea4\u91d1\u989d\uff1a{}\uff0c\u5df2\u7ecf\u652f\u4ed8\u8fc7\u7684\uff08\u8d44\u91d1+\u8d39\u7528\uff09\u91d1\u989d\uff1a{}\uff0c\u9700\u8981\u4ed8\u6b3e\u91d1\u989d\uff1a{}", new Object[]{line.getId(), transactionAmount, payAmount, itemNeedPaymount});
            orderLineSurplusAmountMap.put(line.getId(), itemNeedPaymount);
        }
        return orderLineSurplusAmountMap;
    }

    @Override
    public RestResponse<Void> businessAuditRevoke(DgPerformOrderRespDto throughDtoDefine, DgF2BAuditRevokeReqDto request) {
        log.info("\u8ba2\u5355:{},\u6267\u884c\u4e1a\u52a1\u5ba1\u6838\u64a4\u56de\u64cd\u4f5c,\u5c06\u5f85\u8d22\u52a1\u5ba1\u6838\u8ba2\u5355\u66f4\u65b0\u4e3a\u5f85\u4e1a\u52a1\u5ba1\u6838,\u72b6\u6001\u53d8\u66f4\u7531\u72b6\u6001\u673a\u6267\u884c,\u8fd9\u91cc\u6267\u884c\u5176\u4ed6\u4e1a\u52a1\u64cd\u4f5c!", (Object)throughDtoDefine.getSaleOrderNo());
        log.info("\u6267\u884c\u4e1a\u52a1\u5ba1\u6838\u64a4\u56de\u64cd\u4f5c,\u6682\u65f6\u65e0\u5176\u4ed6\u76f8\u5173\u4e1a\u52a1\u9700\u8981\u5904\u7406");
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> financialAuditRevoke(DgPerformOrderRespDto throughDtoDefine, DgF2BAuditRevokeReqDto request) {
        log.info("\u8ba2\u5355:{},\u6267\u884c\u64a4\u56de\u8d22\u5ba1\u64cd\u4f5c,\u5c06\u5f85\u53d1\u8d27\u8ba2\u5355\u66f4\u65b0\u4e3a\u5f85\u4e1a\u52a1\u5ba1\u6838,\u72b6\u6001\u53d8\u66f4\u7531\u72b6\u6001\u673a\u6267\u884c,\u8fd9\u91cc\u6267\u884c\u5176\u4ed6\u4e1a\u52a1\u64cd\u4f5c!", (Object)throughDtoDefine.getSaleOrderNo());
        log.info("\u6267\u884c\u8d22\u5ba1\u64a4\u56de\u64cd\u4f5c,\u6682\u65f6\u65e0\u5176\u4ed6\u76f8\u5173\u4e1a\u52a1\u9700\u8981\u5904\u7406");
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> businessAuditReject(DgF2BOrderRejectReqDto request) {
        log.info("\u8ba2\u5355ID:{},\u6267\u884c\u4e1a\u52a1\u5ba1\u6838\u9a73\u56de\u64cd\u4f5c,\u5c06\u5f85\u4e1a\u52a1\u5ba1\u6838\u8ba2\u5355\u66f4\u65b0\u4e3a\u5f85\u786e\u8ba4\u72b6\u6001,\u72b6\u6001\u53d8\u66f4\u7531\u72b6\u6001\u673a\u6267\u884c,\u8fd9\u91cc\u6267\u884c\u5176\u4ed6\u4e1a\u52a1\u64cd\u4f5c!", (Object)request.getOrderId());
        log.info("\u6267\u884c\u4e1a\u52a1\u5ba1\u6838\u9a73\u56de\u64cd\u4f5c,\u6682\u65f6\u65e0\u5176\u4ed6\u76f8\u5173\u4e1a\u52a1\u9700\u8981\u5904\u7406");
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> financialAuditReject(DgF2BOrderRejectReqDto request) {
        log.info("\u8ba2\u5355ID:{},\u6267\u884c\u8d22\u52a1\u5ba1\u6838\u9a73\u56de\u64cd\u4f5c,\u5c06\u5f85\u8d22\u52a1\u5ba1\u6838\u8ba2\u5355\u66f4\u65b0\u4e3a\u5f85\u786e\u8ba4\u72b6\u6001,\u72b6\u6001\u53d8\u66f4\u7531\u72b6\u6001\u673a\u6267\u884c,\u8fd9\u91cc\u6267\u884c\u5176\u4ed6\u4e1a\u52a1\u64cd\u4f5c!", (Object)request.getOrderId());
        log.info("\u6267\u884c\u8d22\u52a1\u5ba1\u6838\u9a73\u56de\u64cd\u4f5c,\u6682\u65f6\u65e0\u5176\u4ed6\u76f8\u5173\u4e1a\u52a1\u9700\u8981\u5904\u7406");
        return RestResponse.VOID;
    }

    @Override
    public void auditSaveAuditLog(DgPerformOrderRespDto throughDtoDefine, OrderAuditReqDto request) {
        this.dgBusinessAuditService.saveAuditRecord(request.getAuditor(), throughDtoDefine.getId(), throughDtoDefine.getSaleOrderNo(), 1, request.getAuditType(), request.getAuditDesc(), request.getAuditResult());
    }

    private void saveAuditOptRecord(DgPerformOrderRespDto throughDtoDefine, OrderAuditReqDto request) {
        OptLogEo optLogEo = new OptLogEo();
        optLogEo.setBizType(OptBizTypeEnum.ORDER.getType());
        optLogEo.setBizNo(throughDtoDefine.getSaleOrderNo());
        AuditTypeEnum auditTypeEnum = AuditTypeEnum.getByCode((String)request.getAuditType());
        String auditDesc = StringUtils.isNotBlank((String)request.getAuditDesc()) ? request.getAuditDesc() : "\u65e0";
        switch (auditTypeEnum) {
            case CS_AUDIT: {
                optLogEo.setOptType(OptTypeEnum.ORDER_CUSTOMER_AUDIT.getType());
                if (Objects.equals(request.getAuditResult(), 1)) {
                    optLogEo.setDescription(auditDesc);
                    break;
                }
                optLogEo.setDescription(auditDesc);
                break;
            }
            case FINANCE_AUDIT: {
                optLogEo.setOptType(OptTypeEnum.ORDER_FINANCE_AUDIT.getType());
                if (Objects.equals(request.getAuditResult(), 1)) {
                    optLogEo.setDescription(auditDesc);
                    break;
                }
                optLogEo.setDescription(auditDesc);
                break;
            }
            case RETURN_AUDIT: {
                break;
            }
            case REFUND_AUDIT: {
                break;
            }
            case FIN_REFUND_CHECK: {
                break;
            }
            case ORDER_REFUND_AUDIT: {
                optLogEo.setOptType(OptTypeEnum.ORDER_REFUND_AUDIT.getType());
                optLogEo.setDescription("\u3010\u5f85\u8d22\u52a1\u5ba1\u6838\u3011\u8ba2\u8d27\u5355\u53cd\u5ba1\u6838\u901a\u8fc7,\u5f85\u8d22\u52a1\u5ba1\u6838\uff0c\u5ba1\u6838\u610f\u89c1\uff1a" + auditDesc);
                break;
            }
            case ORDER_CS_REFUND_AUDIT: {
                optLogEo.setOptType(OptTypeEnum.ORDER_CS_REFUND_AUDIT.getType());
                optLogEo.setDescription("\u3010\u5f85\u4e1a\u52a1\u5ba1\u6838\u3011\u8ba2\u8d27\u5355\u53cd\u5ba1\u6838\u901a\u8fc7,\u5f85\u4e1a\u52a1\u5ba1\u6838\uff0c\u5ba1\u6838\u610f\u89c1\uff1a" + auditDesc);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + auditTypeEnum);
            }
        }
        optLogEo.setOptTime(new Date());
        optLogEo.setOptPerson(this.context.userName());
        if (StringUtils.isNotBlank((String)request.getAuditor())) {
            optLogEo.setOptPerson(request.getAuditor());
        }
        this.optLogService.addBoOptLog(optLogEo);
    }
}

