/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.common.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateRespDto;
import com.yunxi.dg.base.center.trade.action.oms.common.IOrderInventoryHandleAction;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.SaleItemStatusEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformNoticeSyncRecordShippingDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeShipmentEnterpriseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordShippingService;
import com.yunxi.dg.base.center.trade.service.oms.common.IOrderInventoryHandleService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrderInventoryHandleActionImpl
implements IOrderInventoryHandleAction {
    private static final Logger log = LoggerFactory.getLogger(OrderInventoryHandleActionImpl.class);
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IOrderInventoryHandleService orderInventoryHandleService;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private IDgPerformNoticeSyncRecordShippingService performNoticeSyncRecordShippingService;

    @Override
    public RestResponse<DgArrangeShipmentEnterpriseReqDto> arrangeShipmentEnterpriseNotice(DgPerformOrderRespDto respDto, DgArrangeShipmentEnterpriseReqDto reqDto) {
        if (reqDto != null) {
            this.inventoryApiServcie.updateOrderShipmentInfo(respDto, reqDto);
        }
        return new RestResponse((Object)reqDto);
    }

    @Override
    public RestResponse<InventoryOperateRespDto> preemptLogicInventoryByOrderAppointDeliveryWarehouse(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        return new RestResponse((Object)this.orderInventoryHandleService.preemptLogicInventoryByOrderAppointDeliveryWarehouse(respDto));
    }

    @Override
    public RestResponse<Void> releaseChannelInventory(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.orderInventoryHandleService.releaseChannelInventory(respDto.getId());
        return RestResponse.VOID;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void sendMsgForDeliveryResult(DgPerformOrderRespDto saleOrderRespDto, DgOmsSaleOrderStatus saleOrderStatus, DgOutDeliveryResultReqDto outDeliveryResultReqDto) {
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"saleOrderRespDto \u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Integer status = 0;
        switch (saleOrderStatus) {
            case WAIT_DELIVERY: {
                status = 1;
                break;
            }
            case DELIVERY_ALL: {
                status = 3;
                break;
            }
            case COMPLETE: {
                status = 4;
                break;
            }
        }
        HashMap<String, Object> msgMap = new HashMap<String, Object>();
        msgMap.put("orderNo", saleOrderRespDto.getPlatformOrderNo());
        msgMap.put("status", status);
        msgMap.put("consignType", saleOrderRespDto.getConsignType());
        msgMap.put("saleOrderNo", saleOrderRespDto.getSaleOrderNo());
        msgMap.put("orderStatus", saleOrderRespDto.getOrderStatus());
        msgMap.put("platformOrderStatus", saleOrderRespDto.getPlatformOrderStatus());
        msgMap.put("platformParentOrderNo", saleOrderRespDto.getPlatformParentOrderNo());
        msgMap.put("orderSourceSystemCode", saleOrderRespDto.getOrderSourceSystemCode());
        msgMap.put("orderSourceSystemName", saleOrderRespDto.getOrderSourceSystemName());
        msgMap.put("orderSource", saleOrderRespDto.getOrderSource());
        if (Objects.nonNull(outDeliveryResultReqDto)) {
            msgMap.put("saleOrderId", saleOrderRespDto.getId());
            msgMap.put("outNoticeOrderNo", outDeliveryResultReqDto.getOutNoticeOrderNo());
            msgMap.put("channelCode", saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode());
            msgMap.put("shippingNo", outDeliveryResultReqDto.getShippingNo());
            msgMap.put("shipmentEnterpriseCode", outDeliveryResultReqDto.getPlatformShipmentEnterpriseCode());
            msgMap.put("shipmentEnterpriseName", outDeliveryResultReqDto.getPlatformShipmentEnterpriseName());
            List<DgPerformNoticeSyncRecordShippingDto> shippingDtoList = this.performNoticeSyncRecordShippingService.queryByOrderId(saleOrderRespDto.getId());
            if (CollectionUtils.isNotEmpty(shippingDtoList)) {
                List collect = shippingDtoList.stream().map(m -> {
                    DgWmsShippingInfoReqDto shippingInfoReqDto = new DgWmsShippingInfoReqDto();
                    shippingInfoReqDto.setDeliveryTime(m.getDeliveryTime());
                    shippingInfoReqDto.setOutNoticeOrderNo(m.getNoticeOrderNo());
                    shippingInfoReqDto.setShippingCompanyCode(m.getShippingCompanyCode());
                    shippingInfoReqDto.setShippingCompanyName(m.getShippingCompany());
                    shippingInfoReqDto.setShippingNo(m.getConsignmentNo());
                    return shippingInfoReqDto;
                }).collect(Collectors.toList());
                msgMap.put("shippingInfoList", collect);
            } else if (StringUtils.isNotEmpty((CharSequence)outDeliveryResultReqDto.getPlatformShipmentEnterpriseCode())) {
                ArrayList wmsShippingInfoReqDtos = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)wmsShippingInfoReqDtos, (Collection)outDeliveryResultReqDto.getShippingInfoList(), DgWmsShippingInfoReqDto.class);
                wmsShippingInfoReqDtos.forEach(dto -> {
                    dto.setShippingCompanyCode(outDeliveryResultReqDto.getPlatformShipmentEnterpriseCode());
                    dto.setShippingCompanyName(outDeliveryResultReqDto.getPlatformShipmentEnterpriseName());
                });
                msgMap.put("shippingInfoList", wmsShippingInfoReqDtos);
            } else {
                msgMap.put("shipmentEnterpriseCode", outDeliveryResultReqDto.getShipmentEnterpriseCode());
                msgMap.put("shipmentEnterpriseName", outDeliveryResultReqDto.getShipmentEnterpriseName());
                msgMap.put("shippingInfoList", outDeliveryResultReqDto.getShippingInfoList());
            }
            List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(saleOrderRespDto.getId());
            if (DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode().equals(saleOrderRespDto.getBizModel())) {
                if (!CollectionUtils.isNotEmpty((Collection)orderLineDtos)) {
                    log.info("\u8ba2\u5355{} \u5546\u54c1\u4e0d\u5b58\u5728", (Object)saleOrderRespDto.getId());
                    return;
                }
                Map itemLineMap = orderLineDtos.stream().collect(Collectors.toMap(DgPerformOrderLineDto::getSkuCode, Function.identity(), (v1, v2) -> v2));
                ArrayList itemMapList = com.google.common.collect.Lists.newArrayList();
                msgMap.put("goodsList", itemMapList);
                List itemDtoList = orderLineDtos.stream().map(dto -> {
                    HashMap itemMap = Maps.newHashMap();
                    itemMap.put("tradeOrderItemId", dto.getId());
                    itemMap.put("platformOrderItemNo", dto.getPlatformOrderItemNo());
                    itemMap.put("itemCode", dto.getItemCode());
                    itemMap.put("skuCode", dto.getSkuCode());
                    itemMap.put("snCode", dto.getSnCode());
                    itemMap.put("itemNum", dto.getItemNum());
                    return itemMap;
                }).collect(Collectors.toList());
                msgMap.put("orderItemList", itemDtoList);
            } else {
                Map itemRespDtoMap = orderLineDtos.stream().collect(Collectors.toMap(DgPerformOrderLineDto::getSkuCode, Function.identity(), (v1, v2) -> v2));
                Map orderItemRespDtoMap = orderLineDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (v1, v2) -> v2));
                ArrayList itemMapList = com.google.common.collect.Lists.newArrayList();
                ((List)Optional.ofNullable(outDeliveryResultReqDto.getDeliveryDetailList()).orElse(new ArrayList())).forEach(item -> Optional.ofNullable(itemRespDtoMap.get(item.getLongCode())).ifPresent(saleOrderItemRespDto -> {
                    HashMap itemMap = Maps.newHashMap();
                    itemMap.put("saleOrderNo", saleOrderRespDto.getSaleOrderNo());
                    itemMap.put("itemCode", saleOrderItemRespDto.getItemCode());
                    itemMap.put("skuCode", saleOrderItemRespDto.getSkuCode());
                    itemMap.put("snCode", saleOrderItemRespDto.getSnCode());
                    itemMap.put("itemNum", item.getOutQuantity());
                    itemMap.put("batchNo", item.getBatch());
                    if (item.getTradeOrderItemId() != null && orderItemRespDtoMap.get(item.getTradeOrderItemId()) != null) {
                        DgPerformOrderLineDto oriOrderItemRespDto = (DgPerformOrderLineDto)orderItemRespDtoMap.get(item.getTradeOrderItemId());
                        itemMap.put("platformOrderItemNo", oriOrderItemRespDto.getPlatformOrderItemNo());
                        itemMap.put("gift", oriOrderItemRespDto.getGiftFlag());
                        itemMap.put("tradeOrderItemId", item.getTradeOrderItemId());
                    } else {
                        itemMap.put("platformOrderItemNo", saleOrderItemRespDto.getPlatformOrderItemNo());
                    }
                    itemMapList.add(itemMap);
                }));
                msgMap.put("goodsList", itemMapList);
                List itemDtoList = orderLineDtos.stream().filter(dto -> SaleItemStatusEnum.NORMAL.getCode().equals(dto.getStatus())).map(dto -> {
                    HashMap itemMap = Maps.newHashMap();
                    itemMap.put("itemCode", dto.getItemCode());
                    itemMap.put("skuCode", dto.getSkuCode());
                    itemMap.put("snCode", dto.getSnCode());
                    itemMap.put("itemNum", dto.getItemNum());
                    itemMap.put("platformOrderItemNo", dto.getPlatformOrderItemNo());
                    itemMap.put("tradeOrderItemId", dto.getId());
                    return itemMap;
                }).collect(Collectors.toList());
                msgMap.put("orderItemList", itemDtoList);
            }
        }
        if (Objects.nonNull(saleOrderRespDto.getExchangeOrderNo())) {
            DgAfterSaleOrderRespDto afterDgPerformOrderRespDto = this.afterSaleOrderDomain.queryByNo(saleOrderRespDto.getExchangeOrderNo());
            Optional.ofNullable(afterDgPerformOrderRespDto).ifPresent(afterSaleOrder -> msgMap.put("platformRefundOrderSn", afterSaleOrder.getPlatformRefundOrderSn()));
        }
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)JSON.toJSONString(msgMap));
        log.info("[\u51fa\u5e93\u56de\u4f20\u53d1\u9001mq]\u53d1\u9001mq\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        this.commonsMqService.publishMessage("DELIVERY_RESULT_B2B_MESSAGE_TAG", (Object)messageVo);
    }
}

