/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.after.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.AfterSaleOrderOaAuditDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.AttachementReqDto;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.yunxi.dg.base.center.inventory.api.warehouse.ILogicWarehouseApi;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicalWarehouseRespDto;
import com.yunxi.dg.base.center.report.dto.entity.DgOrderAfterReportDto;
import com.yunxi.dg.base.center.shop.dto.request.DgShopQueryReqDto;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.shop.proxy.query.IDgShopQueryApiProxy;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.basic.IDgAfterSaleOrderBasicOptAction;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.basic.IDgAfterSaleOrderBasicQueryOptAction;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderAbolishEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderBizSystemEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderRefundStatusEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.convert.entity.DgAfterSaleOrderConverter;
import com.yunxi.dg.base.center.trade.dao.das.IDgAfterSaleOrderDas;
import com.yunxi.dg.base.center.trade.dao.mapper.DgAfterSaleOrderMapper;
import com.yunxi.dg.base.center.trade.dao.vo.DgAfterSaleOrderQueryVo;
import com.yunxi.dg.base.center.trade.domain.entity.IAttachementDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderExchangeAddressDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderLogisticsWarehouseDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderReturnAddressDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.AfterSaleOrder2TransferReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterBatchReturnWarehouseReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderBatchReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemModifyReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderTagRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderTagRecordRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderValidReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterUpdateLogisticsNoReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderTagRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderVoucherDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderTagDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderTagRespDto;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderExchangeAddressEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderLogisticsWarehouseEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderReturnAddressEo;
import com.yunxi.dg.base.center.trade.service.after.IAfterSaleOrderInventoryHandleService;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderService;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderTagRecordService;
import com.yunxi.dg.base.center.trade.service.mark.IDgOrderTagService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.DgNoGreateUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgAfterSaleOrderServiceImpl
extends BaseServiceImpl<DgAfterSaleOrderDto, DgAfterSaleOrderEo, IDgAfterSaleOrderDomain>
implements IDgAfterSaleOrderService {
    private static final Logger log = LoggerFactory.getLogger(DgAfterSaleOrderServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(DgAfterSaleOrderServiceImpl.class);
    @Resource
    private IDgAfterSaleOrderDas afterSaleOrderDas;
    @Resource
    private IDgAfterSaleOrderItemService dgAfterSaleOrderItemService;
    @Resource
    private DgAfterSaleOrderMapper dgAfterSaleOrderMapper;
    @Resource
    private DgNoGreateUtil dgNoGreateUtil;
    @Resource
    private IDgOrderTagService orderTagService;
    @Resource
    private IDgAfterSaleOrderTagRecordService afterSaleOrderTagRecordService;
    @Resource
    private ILogicWarehouseApi logicWarehouseApi;
    @Resource
    private IDgAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private IDgAfterSaleOrderItemDomain afterSaleOrderItemDomain;
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private IAttachementDomain attachementDomain;
    @Resource
    private IDgAfterSaleOrderBasicOptAction dgAfterSaleOrderBasicOptAction;
    @Resource
    private IDgAfterSaleOrderBasicQueryOptAction dgAfterSaleOrderBasicQueryOptAction;
    @Resource
    private IDgAfterSaleOrderReturnAddressDomain dgAfterSaleOrderReturnAddressDomain;
    @Resource
    private IDgAfterSaleOrderExchangeAddressDomain dgAfterSaleOrderExchangeAddressDomain;
    @Resource
    private IDgAfterSaleOrderLogisticsWarehouseDomain dgAfterSaleOrderLogisticsWarehouseDomain;
    @Resource
    protected IDgAfterSaleOrderItemDomain dgAfterSaleOrderItemDomain;
    @Resource
    private IDgShopQueryApiProxy dgShopQueryApiProxy;
    @Resource
    private IAfterSaleOrderInventoryHandleService afterSaleOrderInventoryHandleService;
    @Resource
    private ICacheService cacheService;
    public static ExecutorService QUERY_THREAD_POOL = new ThreadPoolExecutor(4, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactoryBuilder().setNameFormat("afterSaleOrderQuery-pool-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    public DgAfterSaleOrderServiceImpl(IDgAfterSaleOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgAfterSaleOrderDto, DgAfterSaleOrderEo> converter() {
        return DgAfterSaleOrderConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addAfterSaleOrder(DgAfterSaleOrderDto addReqDto) {
        if (StringUtils.isEmpty((CharSequence)addReqDto.getAfterSaleOrderNo())) {
            addReqDto.setAfterSaleOrderNo(this.dgNoGreateUtil.generateAfterSaleOrderNo());
        }
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        CubeBeanUtils.copyProperties((Object)dgAfterSaleOrderEo, (Object)addReqDto, (String[])new String[0]);
        if (StringUtils.isEmpty((CharSequence)dgAfterSaleOrderEo.getBizSystem())) {
            dgAfterSaleOrderEo.setBizSystem(DgAfterSaleOrderBizSystemEnum.DEFAULT.getCode());
        }
        this.afterSaleOrderDas.insert((BaseEo)dgAfterSaleOrderEo);
        if (AfterSaleOrderTypeEnum.THTK.getCode().equals(addReqDto.getAfterSaleOrderType()) || AfterSaleOrderTypeEnum.EXCHANGE.getCode().equals(addReqDto.getAfterSaleOrderType()) || AfterSaleOrderTypeEnum.HH.getCode().equals(addReqDto.getAfterSaleOrderType())) {
            DgAfterSaleOrderReturnAddressEo returnAddressEo = new DgAfterSaleOrderReturnAddressEo();
            CubeBeanUtils.copyProperties((Object)returnAddressEo, (Object)addReqDto, (String[])new String[0]);
            returnAddressEo.setAfterSaleOrderId(dgAfterSaleOrderEo.getId());
            this.dgAfterSaleOrderReturnAddressDomain.insert((BaseEo)returnAddressEo);
        }
        if (AfterSaleOrderTypeEnum.EXCHANGE.getCode().equals(addReqDto.getAfterSaleOrderType()) || AfterSaleOrderTypeEnum.HH.getCode().equals(addReqDto.getAfterSaleOrderType())) {
            DgAfterSaleOrderExchangeAddressEo exchangeAddressEo = new DgAfterSaleOrderExchangeAddressEo();
            CubeBeanUtils.copyProperties((Object)exchangeAddressEo, (Object)addReqDto, (String[])new String[0]);
            exchangeAddressEo.setAfterSaleOrderId(dgAfterSaleOrderEo.getId());
            this.dgAfterSaleOrderExchangeAddressDomain.insert((BaseEo)exchangeAddressEo);
        }
        DgAfterSaleOrderLogisticsWarehouseEo logisticsWarehouseEo = new DgAfterSaleOrderLogisticsWarehouseEo();
        CubeBeanUtils.copyProperties((Object)logisticsWarehouseEo, (Object)addReqDto, (String[])new String[0]);
        logisticsWarehouseEo.setAfterSaleOrderId(dgAfterSaleOrderEo.getId());
        this.dgAfterSaleOrderLogisticsWarehouseDomain.insert((BaseEo)logisticsWarehouseEo);
        return dgAfterSaleOrderEo.getId();
    }

    @Override
    public void modifyAfterSaleOrder(DgAfterSaleOrderReqDto modifyReqDto) {
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)dgAfterSaleOrderEo);
        dgAfterSaleOrderEo.setUpdateTime(new Date());
        this.afterSaleOrderDas.updateSelective((BaseEo)dgAfterSaleOrderEo);
    }

    @Override
    public void reimbursement(List<Long> ids) {
        log.info("\u4fee\u6539\u9000\u8d27\u5355\u6838\u9500\u72b6\u6001\uff1a{}", ids);
        List<DgAfterSaleOrderRespDto> list = this.queryByIds(ids);
        for (DgAfterSaleOrderRespDto afterSaleOrderEo : list) {
            boolean flag = false;
            if (null != afterSaleOrderEo.getReimbursementStatus() && afterSaleOrderEo.getReimbursementStatus() == 0 && null != afterSaleOrderEo.getReimbursementOrderNo()) {
                flag = true;
            }
            if (!flag) {
                throw new BizException("\u5df2\u6838\u9500\u6216\u62a5\u9500\u5355\u53f7\u4e3a\u7a7a");
            }
            DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
            DtoHelper.dto2Eo((BaseVo)afterSaleOrderEo, (BaseEo)dgAfterSaleOrderEo);
            dgAfterSaleOrderEo.setUpdateTime(new Date());
            dgAfterSaleOrderEo.setReimbursementStatus(Integer.valueOf(1));
            this.afterSaleOrderDas.updateSelective((BaseEo)dgAfterSaleOrderEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAfterSaleOrder(String ids, Long instanceId) {
        String[] removeIds = ids.split(",");
        ArrayList afsIds = Lists.newArrayList();
        for (String removeId : removeIds) {
            afsIds.add(Long.valueOf(removeId));
        }
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)afsIds), (String)"\u53c2\u6570\u552e\u540e\u5355ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List returnAddressEos = this.dgAfterSaleOrderReturnAddressDomain.selectByAfterSaleOrderIds((List)afsIds);
        List exchangeAddressEos = this.dgAfterSaleOrderExchangeAddressDomain.selectByAfterSaleOrderIds((List)afsIds);
        List logisticsWarehouseEos = this.dgAfterSaleOrderLogisticsWarehouseDomain.selectByAfterSaleOrderIds((List)afsIds);
        this.afterSaleOrderDas.logicDeleteByIds((List)afsIds);
        if (CollectionUtils.isNotEmpty((Collection)returnAddressEos)) {
            this.dgAfterSaleOrderReturnAddressDomain.logicDeleteByIds(returnAddressEos.stream().map(BaseEo::getId).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)exchangeAddressEos)) {
            this.dgAfterSaleOrderExchangeAddressDomain.logicDeleteByIds(exchangeAddressEos.stream().map(BaseEo::getId).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)logisticsWarehouseEos)) {
            this.dgAfterSaleOrderLogisticsWarehouseDomain.logicDeleteByIds(logisticsWarehouseEos.stream().map(BaseEo::getId).collect(Collectors.toList()));
        }
    }

    @Override
    public DgAfterSaleOrderRespDto queryById(Long id) {
        return this.dgAfterSaleOrderBasicQueryOptAction.aggregatedQueryByAfsId(id);
    }

    @Override
    public List<DgAfterSaleOrderRespDto> queryByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        ArrayList<CompletableFuture<DgAfterSaleOrderRespDto>> futures = new ArrayList<CompletableFuture<DgAfterSaleOrderRespDto>>();
        String requestId = ServiceContext.getContext().getRequestId();
        for (Long id : ids) {
            CompletableFuture<DgAfterSaleOrderRespDto> future = CompletableFuture.supplyAsync(() -> {
                MDC.put((String)"yes.req.requestId", (String)requestId);
                ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
                return this.dgAfterSaleOrderBasicQueryOptAction.aggregatedQueryByAfsId(id);
            }, QUERY_THREAD_POOL);
            futures.add(future);
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        List<DgAfterSaleOrderRespDto> results = futures.stream().map(CompletableFuture::join).collect(Collectors.toList());
        return results;
    }

    @Override
    public DgAfterSaleOrderRespDto queryByNo(String afterSaleOrderNo) {
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = this.dgAfterSaleOrderBasicQueryOptAction.aggregatedQueryByAfsOrderNo(afterSaleOrderNo);
        afterSaleOrderRespDto.setReturnAddress(afterSaleOrderRespDto.getReturnProvinceName() + afterSaleOrderRespDto.getReturnCityName() + afterSaleOrderRespDto.getReturnCountyName() + afterSaleOrderRespDto.getReturnAddress());
        if (!Objects.equals(afterSaleOrderRespDto.getRefundStatus(), DgAfterSaleOrderRefundStatusEnum.REFUNDED.getCode())) {
            afterSaleOrderRespDto.setLastChanged(null);
        }
        List itemEoList = this.dgAfterSaleOrderItemDomain.queryEosByAfterSaleOrderId(afterSaleOrderRespDto.getId());
        Integer totalItemNum = itemEoList.stream().map(DgAfterSaleOrderItemEo::getReturnNum).filter(Objects::nonNull).reduce(0, Integer::sum);
        ArrayList itemDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemDtoList, (Collection)itemEoList, DgAfterSaleOrderItemDto.class);
        afterSaleOrderRespDto.setItemDtoList((List)itemDtoList);
        ArrayList itemRespDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemRespDtoList, (Collection)itemEoList, DgAfterSaleOrderItemRespDto.class);
        afterSaleOrderRespDto.setItemRespDtoList((List)itemRespDtoList);
        afterSaleOrderRespDto.setTotalItemNum(totalItemNum);
        afterSaleOrderRespDto.setRelationBillList(this.dgAfterSaleOrderBasicQueryOptAction.queryRelateBillInfo(afterSaleOrderRespDto));
        afterSaleOrderRespDto.setTagRecordCodes(this.dgAfterSaleOrderBasicQueryOptAction.queryAfsOrderTagRecords(afterSaleOrderRespDto.getId()));
        afterSaleOrderRespDto.setLabelRecordCodes(this.dgAfterSaleOrderBasicQueryOptAction.queryAfsOrderLabelRecords(afterSaleOrderRespDto.getId()));
        return afterSaleOrderRespDto;
    }

    @Override
    public List<DgAfterSaleOrderRespDto> queryByPlatformOrderNo(String platFormOrderNo) {
        AssertUtils.notBlank((String)platFormOrderNo, (String)"\u5e73\u53f0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        DgBizAfterSaleOrderReqDto dgBizAfterSaleOrderReqDto = new DgBizAfterSaleOrderReqDto();
        dgBizAfterSaleOrderReqDto.setPlatformOrderNo(platFormOrderNo);
        List dgAfterSaleOrderRespDtos = ((IDgAfterSaleOrderDomain)this.domain).queryByBizAfterSaleOrderReqDto(dgBizAfterSaleOrderReqDto);
        return dgAfterSaleOrderRespDtos;
    }

    @Override
    public List<DgAfterSaleOrderRespDto> queryByBizAfterSaleOrderReqDto(DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        List saleOrderEos;
        if (StringUtils.isBlank((CharSequence)bizAfterSaleOrderReqDto.getPlatformOrderNo()) && StringUtils.isBlank((CharSequence)bizAfterSaleOrderReqDto.getPlatformRefundOrderSn()) && StringUtils.isBlank((CharSequence)bizAfterSaleOrderReqDto.getSaleOrderNo()) && CollectionUtils.isEmpty((Collection)bizAfterSaleOrderReqDto.getPlatformRefundOrderSnList())) {
            AssertUtils.notBlank((String)bizAfterSaleOrderReqDto.getPlatformOrderNo(), (String)"platformOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notBlank((String)bizAfterSaleOrderReqDto.getPlatformRefundOrderSn(), (String)"platformRefundOrderSn\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notBlank((String)bizAfterSaleOrderReqDto.getSaleOrderNo(), (String)"saleOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
            if (CollectionUtils.isEmpty((Collection)bizAfterSaleOrderReqDto.getPlatformRefundOrderSnList())) {
                throw new BizException("platformRefundOrderSnList\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        CubeBeanUtils.copyProperties((Object)dgAfterSaleOrderEo, (Object)bizAfterSaleOrderReqDto, (String[])new String[0]);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)dgAfterSaleOrderEo);
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        queryWrapper.eq(DgAfterSaleOrderEo::getAbolishFlag, (Object)DgAfterSaleOrderAbolishEnum.NO.getCode());
        queryWrapper.orderByDesc(DgAfterSaleOrderEo::getPlatformCreated);
        if (CollectionUtils.isNotEmpty((Collection)bizAfterSaleOrderReqDto.getPlatformRefundOrderSnList())) {
            queryWrapper.in(DgAfterSaleOrderEo::getPlatformRefundOrderSn, (Collection)bizAfterSaleOrderReqDto.getPlatformRefundOrderSnList());
        }
        if (CollectionUtils.isNotEmpty((Collection)bizAfterSaleOrderReqDto.getAfterSaleOrderTypeList())) {
            queryWrapper.in(DgAfterSaleOrderEo::getAfterSaleOrderType, (Collection)bizAfterSaleOrderReqDto.getAfterSaleOrderTypeList());
        }
        if (CollectionUtils.isEmpty((Collection)(saleOrderEos = this.afterSaleOrderDas.getMapper().selectList((Wrapper)queryWrapper)))) {
            return Lists.newArrayList();
        }
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)saleOrderEos, DgAfterSaleOrderRespDto.class);
        return resultList;
    }

    @Override
    public List<DgAfterSaleOrderRespDto> querNeedRefreshSaleOrderStatusList(DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        AssertUtils.notNull((Object)bizAfterSaleOrderReqDto.getUpdateBeginTime(), (String)"\u66f4\u65b0\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u672a\u7a7a");
        AssertUtils.notNull((Object)bizAfterSaleOrderReqDto.getUpdateEndTime(), (String)"\u66f4\u65b0\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u672a\u7a7a");
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        CubeBeanUtils.copyProperties((Object)dgAfterSaleOrderEo, (Object)bizAfterSaleOrderReqDto, (String[])new String[0]);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)dgAfterSaleOrderEo);
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        queryWrapper.eq(DgAfterSaleOrderEo::getAbolishFlag, (Object)DgAfterSaleOrderAbolishEnum.NO.getCode());
        queryWrapper.eq(DgAfterSaleOrderEo::getStatus, (Object)DgAfterSaleOrderStatusEnum.FINISH.getCode());
        queryWrapper.and(wrapper -> {
            wrapper.isNull(DgAfterSaleOrderEo::getRelateToPlatformOrder);
            wrapper.or(wp -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wp.eq(DgAfterSaleOrderEo::getRelateToPlatformOrder, (Object)"0");
            });
        });
        queryWrapper.orderByDesc(DgAfterSaleOrderEo::getPlatformCreated);
        queryWrapper.between(BaseEo::getUpdateTime, (Object)bizAfterSaleOrderReqDto.getUpdateBeginTime(), (Object)bizAfterSaleOrderReqDto.getUpdateEndTime());
        List saleOrderEos = this.afterSaleOrderDas.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)saleOrderEos)) {
            return Lists.newArrayList();
        }
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)saleOrderEos, DgAfterSaleOrderRespDto.class);
        return resultList;
    }

    @Override
    public PageInfo<DgAfterSaleOrderRespDto> queryByPage(DgAfterSaleOrderValidReqDto afterSaleOrderReqDto, Integer pageNum, Integer pageSize) {
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        DtoHelper.dto2Eo((BaseVo)afterSaleOrderReqDto, (BaseEo)dgAfterSaleOrderEo);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        DgAfterSaleOrderQueryVo afterSaleOrderQueryVo = new DgAfterSaleOrderQueryVo();
        CubeBeanUtils.copyProperties((Object)afterSaleOrderQueryVo, (Object)afterSaleOrderReqDto, (String[])new String[0]);
        PageInfo eoPageInfo = new PageInfo(this.dgAfterSaleOrderMapper.aggregatedQueryByParamVo(afterSaleOrderQueryVo));
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List<Object> dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoPageInfo.getList(), DgAfterSaleOrderRespDto.class);
        dtoPageInfo.setList(dtoList);
        List orderIds = dtoList.stream().map(BaseDto::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orderIds)) {
            DgAfterSaleOrderTagRecordReqDto orderTagRecordReqDto = new DgAfterSaleOrderTagRecordReqDto();
            orderTagRecordReqDto.setOrderIds(orderIds);
            List<DgAfterSaleOrderTagRecordRespDto> afterSaleOrderTagRecordRespDtos = this.afterSaleOrderTagRecordService.queryByParam(orderTagRecordReqDto);
            if (ObjectUtils.isNotEmpty((Object)afterSaleOrderReqDto.getNeedTag()) && StringUtils.isNotBlank((CharSequence)afterSaleOrderReqDto.getTagCode())) {
                if (afterSaleOrderReqDto.getNeedTag() == 1) {
                    List selectTagOrderIds = afterSaleOrderTagRecordRespDtos.stream().filter(afterSaleOrderRespDto -> afterSaleOrderRespDto.getTagCode().equals(afterSaleOrderReqDto.getTagCode())).map(DgAfterSaleOrderTagRecordDto::getOrderId).collect(Collectors.toList());
                    List respDtos = dtoPageInfo.getList().stream().filter(dgAfterSaleOrderRespDto -> selectTagOrderIds.contains(dgAfterSaleOrderRespDto.getId())).collect(Collectors.toList());
                    dtoList = respDtos;
                } else if (afterSaleOrderReqDto.getNeedTag() == 0) {
                    List hasTagIds = afterSaleOrderTagRecordRespDtos.stream().map(DgAfterSaleOrderTagRecordDto::getOrderId).collect(Collectors.toList());
                    List notHasTagIds = orderIds.stream().filter(orderId -> !hasTagIds.contains(orderId)).collect(Collectors.toList());
                    List selectTagOrderIds = afterSaleOrderTagRecordRespDtos.stream().filter(afterSaleOrderRespDto -> !afterSaleOrderRespDto.getTagCode().equals(afterSaleOrderReqDto.getTagCode())).map(DgAfterSaleOrderTagRecordDto::getOrderId).collect(Collectors.toList());
                    selectTagOrderIds.addAll(notHasTagIds);
                    List respDtos = dtoPageInfo.getList().stream().filter(dgAfterSaleOrderRespDto -> selectTagOrderIds.contains(dgAfterSaleOrderRespDto.getId())).collect(Collectors.toList());
                    dtoList = respDtos;
                }
                dtoPageInfo.setList(dtoList);
            }
            if (CollectionUtils.isNotEmpty(afterSaleOrderTagRecordRespDtos)) {
                List<String> tagCodes = afterSaleOrderTagRecordRespDtos.stream().map(DgAfterSaleOrderTagRecordDto::getTagCode).collect(Collectors.toList());
                List<DgOrderTagRespDto> tagEoList = this.orderTagService.queryByTagCodes(tagCodes);
                Map tagEoMap = tagEoList.stream().collect(Collectors.toMap(DgOrderTagDto::getTagCode, Function.identity()));
                Map<Long, List<DgAfterSaleOrderTagRecordRespDto>> tagRecordMap = afterSaleOrderTagRecordRespDtos.stream().collect(Collectors.groupingBy(DgAfterSaleOrderTagRecordDto::getOrderId));
                dtoList.forEach(dto -> {
                    if (CollectionUtils.isNotEmpty((Collection)((Collection)tagRecordMap.get(dto.getId())))) {
                        dto.setTagRecordCodes(((List)tagRecordMap.get(dto.getId())).stream().map(e -> (DgOrderTagRespDto)tagEoMap.get(e.getTagCode())).collect(Collectors.toList()));
                    }
                });
            }
        }
        return dtoPageInfo;
    }

    @Override
    public List<DgAfterSaleOrderRespDto> queryBySaleOrderNo(String saleOrderNo) {
        return this.dgAfterSaleOrderBasicQueryOptAction.aggregatedQueryBySaleOrderNo(saleOrderNo);
    }

    @Override
    public void batchModifyInnerRemark(DgAfterSaleOrderBatchReqDto dto) {
        this.dgAfterSaleOrderBasicOptAction.batchModifyInnerRemarkByAfsIds(dto.getAfterSaleOrderIds(), dto.getInnerRemark());
    }

    @Override
    public void batchModifyAfterSaleOrderReason(DgAfterSaleOrderBatchReqDto dto) {
        this.dgAfterSaleOrderBasicOptAction.batchModifyAfterSaleOrderReasonByAfsIds(dto.getAfterSaleOrderIds(), dto.getAfterSaleOrderReason());
    }

    @Override
    public void updateBatchPlanPickUpDate(List<DgAfterSaleOrderDto> reqDtoList) {
        List collect = reqDtoList.stream().filter(reqDto -> reqDto.getId() == null).collect(Collectors.toList());
        AssertUtils.notEmpty(collect, (String)"\u552e\u540e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        this.dgAfterSaleOrderBasicOptAction.updateBatchPlanPickUpDate(reqDtoList);
    }

    @Override
    public void preemptChannelInventory(Long orderId) {
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = this.dgAfterSaleOrderBasicQueryOptAction.queryById(orderId);
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)afterSaleOrderRespDto, (String)"\u552e\u540e\u5355id=%s\u4e0d\u5b58\u5728", (Object[])new Object[]{orderId});
        List afterSaleOrderItemRespDtos = this.afterSaleOrderItemDomain.queryByAfterSaleOrderId(orderId);
        this.inventoryApiServcie.preemptChannelInventoryForExchange(afterSaleOrderItemRespDtos, afterSaleOrderRespDto);
    }

    @Override
    public void translateChannelInventory(Long orderId) {
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = this.dgAfterSaleOrderBasicQueryOptAction.queryById(orderId);
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)afterSaleOrderRespDto, (String)"\u552e\u540e\u5355id=%s\u4e0d\u5b58\u5728", (Object[])new Object[]{orderId});
        List afterSaleOrderItemRespDtos = this.afterSaleOrderItemDomain.queryByAfterSaleOrderId(orderId);
        this.inventoryApiServcie.translateChannelInventory(afterSaleOrderItemRespDtos, afterSaleOrderRespDto);
    }

    @Override
    public DgAfterSaleOrderRespDto querySaleReturnOrder(String platformRefundOrderSn) {
        return this.dgAfterSaleOrderBasicQueryOptAction.aggregatedQueryByPlatformRefundOrderSn(platformRefundOrderSn);
    }

    @Override
    public void modifyVoucher(DgAfterSaleOrderVoucherDto reqDto) {
        this.dgAfterSaleOrderBasicOptAction.modifyVoucher(reqDto);
    }

    @Override
    public Boolean queryTKTKExistByPlatformOrderNo(String platformOrderNo) {
        return this.dgAfterSaleOrderBasicQueryOptAction.queryTKTKExistByPlatformOrderNo(platformOrderNo);
    }

    @Override
    public Boolean queryTKTKExistBySaleOrderNo(String saleOrderNo) {
        return this.dgAfterSaleOrderBasicQueryOptAction.queryTKTKExistBySaleOrderNo(saleOrderNo);
    }

    @Override
    public void updateAfterSaleOrderActuallyAmount(Long afterSaleId) {
        List afterSaleOrderItemRespDtos = this.afterSaleOrderItemDomain.queryByAfterSaleOrderId(afterSaleId);
        for (DgAfterSaleOrderItemRespDto afterSaleOrderItemRespDto : afterSaleOrderItemRespDtos) {
            DgAfterSaleOrderItemEo afterSaleOrderItemEo = new DgAfterSaleOrderItemEo();
            afterSaleOrderItemEo.setActualRefundPrice(afterSaleOrderItemRespDto.getRefundPrice());
            afterSaleOrderItemEo.setActualRefundAmount(afterSaleOrderItemRespDto.getRefundAmount());
            afterSaleOrderItemEo.setActualReturnNum(afterSaleOrderItemRespDto.getReturnNum());
            afterSaleOrderItemEo.setSettlementAmount(afterSaleOrderItemRespDto.getRefundAmount());
            afterSaleOrderItemEo.setSettlementPrice(afterSaleOrderItemRespDto.getRefundPrice());
            afterSaleOrderItemEo.setId(afterSaleOrderItemRespDto.getId());
        }
        List itemDtoList = BeanUtil.copyToList((Collection)afterSaleOrderItemRespDtos, DgAfterSaleOrderItemDto.class);
        this.dgAfterSaleOrderItemService.updateBatchById(itemDtoList);
    }

    @Override
    public void batchModifyReturnWarehouse(DgAfterBatchReturnWarehouseReqDto dto) {
        this.dgAfterSaleOrderBasicOptAction.batchModifyReturnWarehouse(dto);
    }

    @Override
    public DgBizAfterSaleOrderReqDto convertModifyReturnWarehouseReqDto(DgAfterBatchReturnWarehouseReqDto dto, DgAfterSaleOrderRespDto respDto) {
        LogicalWarehouseRespDto warehouseRespDto = this.getLogicWarehouseRespDto(dto);
        DgBizAfterSaleOrderReqDto afterSaleOrderReqDto = new DgBizAfterSaleOrderReqDto();
        CubeBeanUtils.copyProperties((Object)afterSaleOrderReqDto, (Object)respDto, (String[])new String[0]);
        List<DgAfterSaleOrderItemRespDto> dgAfterSaleOrderItemRespDtos = this.dgAfterSaleOrderItemService.queryByAfterSaleOrderId(respDto.getId());
        ArrayList dgAfterSaleOrderItemModifyReqDtos = new ArrayList();
        CubeBeanUtils.copyCollection(dgAfterSaleOrderItemModifyReqDtos, dgAfterSaleOrderItemRespDtos, DgAfterSaleOrderItemModifyReqDto.class);
        afterSaleOrderReqDto.setAfterSaleOrderItemReqDtoList(dgAfterSaleOrderItemModifyReqDtos);
        afterSaleOrderReqDto.setReturnWarehouseCode(warehouseRespDto.getWarehouseCode());
        afterSaleOrderReqDto.setReturnWarehouseName(warehouseRespDto.getWarehouseName());
        afterSaleOrderReqDto.setReturnWarehouseId(warehouseRespDto.getId());
        return afterSaleOrderReqDto;
    }

    private LogicalWarehouseRespDto getLogicWarehouseRespDto(DgAfterBatchReturnWarehouseReqDto dto) {
        LogicalWarehouseRespDto logicalWarehouseRespDto = (LogicalWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApi.queryLogicWarehouseByCode(dto.getReturnWarehouseCode()));
        if (ObjectUtils.isEmpty((Object)logicalWarehouseRespDto)) {
            throw new BizException("1000001", "\u9000\u8d27\u4ed3\u4e0d\u5b58\u5728");
        }
        this.logger.info("\u6839\u636e\u4ed3\u5e93code\u67e5\u8be2\u51fa\u7684\u9000\u8d27\u4ed3\uff1a{}", (Object)logicalWarehouseRespDto);
        return logicalWarehouseRespDto;
    }

    @Override
    public void updateLogisticsNo(DgAfterUpdateLogisticsNoReqDto reqDto) {
        this.dgAfterSaleOrderBasicOptAction.updateLogisticsNo(reqDto);
    }

    private void setAfterAttachment(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        this.logger.info("\u8bbe\u7f6e\u9000\u8d27\u5355\u9644\u4ef6\u4fe1\u606f\uff1a{}", (Object)afterSaleOrderRespDto.getAfterSaleOrderNo());
        if (StringUtils.isBlank((CharSequence)afterSaleOrderRespDto.getAfterSaleOrderNo())) {
            ArrayList types = Lists.newArrayList((Object[])new String[]{OptBizTypeEnum.RETURN.getType(), OptBizTypeEnum.RETURN_RECEIVING_REPORT.getType()});
            List eoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.attachementDomain.filter().eq((Object)"biz_no", (Object)afterSaleOrderRespDto.getAfterSaleOrderNo())).in((Object)"biz_type", (Collection)types)).list();
            if (CollectionUtils.isNotEmpty((Collection)eoList)) {
                ArrayList reqDtoList = new ArrayList();
                DtoHelper.eoList2DtoList((Collection)eoList, reqDtoList, AttachementReqDto.class);
                List attachementReqDtoList = reqDtoList.stream().filter(f -> f.getBizType().equals(OptBizTypeEnum.RETURN.getType())).collect(Collectors.toList());
                afterSaleOrderRespDto.setAttachmentList(attachementReqDtoList);
                List receivingReportList = reqDtoList.stream().filter(f -> f.getBizType().equals(OptBizTypeEnum.RETURN_RECEIVING_REPORT.getType())).collect(Collectors.toList());
                afterSaleOrderRespDto.setReceivingReportList(receivingReportList);
            }
        }
    }

    @Override
    public DgAfterSaleOrderRespDto queryReturnOrderByNo(String afterSaleOrderNo) {
        DgAfterSaleOrderRespDto dgAfterSaleOrderRespDto = this.afterSaleOrderDomain.queryByNo(afterSaleOrderNo);
        AssertUtils.notNull((Object)dgAfterSaleOrderRespDto, (String)"\u8be5\u9000\u8d27\u5355\u53f7\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9500\u552e\u9000\u5355");
        return dgAfterSaleOrderRespDto;
    }

    @Override
    public void updateOaAudit(AfterSaleOrderOaAuditDto dto) {
        this.logger.info("\u4fee\u6539\u9000\u8d27\u5355OA\u5ba1\u6838\u72b6\u6001\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        List afterSaleOrderEoList = ((ExtQueryChainWrapper)this.afterSaleOrderDomain.filter().in((Object)"after_sale_order_no", (Collection)dto.getAfterSaleOrderNoList())).list();
        if (CollectionUtils.isNotEmpty((Collection)afterSaleOrderEoList)) {
            afterSaleOrderEoList.forEach(eo -> {
                DgAfterSaleOrderEo upd = new DgAfterSaleOrderEo();
                upd.setId(eo.getId());
                upd.setOaAuditId(dto.getAuditId());
                upd.setOaAuditStatus(dto.getAuditStatus());
                upd.setIsOaAudit(dto.getIsOaAudit());
                this.afterSaleOrderDomain.updateSelective((BaseEo)upd);
            });
            return;
        }
        this.logger.error("\u4fee\u6539\u9000\u8d27\u5355OA\u5ba1\u6838\u72b6\u6001\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u9000\u8d27\u5355");
    }

    @Override
    public void updateStatus(DgAfterSaleOrderReqDto dto) {
        this.logger.info("\u4fee\u6539\u9000\u8d27\u5355\u72b6\u6001\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        AssertUtils.isFalse((ObjectUtils.isEmpty((Object)dto.getId()) && StringUtils.isBlank((CharSequence)dto.getAfterSaleOrderNo()) ? 1 : 0) != 0, (String)"id\u4e0e\u5355\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getStatus()), (String)"status\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderEo orderEo = (DgAfterSaleOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.afterSaleOrderDomain.filter().eq(ObjectUtils.isNotEmpty((Object)dto.getId()), (Object)"id", (Object)dto.getId())).eq(StringUtils.isNotBlank((CharSequence)dto.getAfterSaleOrderNo()), (Object)"after_sale_order_no", (Object)dto.getAfterSaleOrderNo())).one();
        AssertUtils.isFalse((boolean)ObjectUtils.isEmpty((Object)orderEo), (String)"\u627e\u4e0d\u5230\u9000\u8d27\u5355");
        DgAfterSaleOrderEo updateEo = new DgAfterSaleOrderEo();
        updateEo.setId(orderEo.getId());
        updateEo.setStatus(dto.getStatus());
        this.afterSaleOrderDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public List<DgAfterSaleOrderRespDto> queryByPlatformRefundOrderSn(List<String> platformOrderRefundSns) {
        AssertUtils.isFalse((boolean)CollectionUtil.isEmpty(platformOrderRefundSns), (String)"\u5e73\u53f0\u552e\u540e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<DgAfterSaleOrderRespDto> result = new ArrayList<DgAfterSaleOrderRespDto>();
        List dgAfterSaleOrderEos = this.afterSaleOrderDomain.queryByPlatformRefundOrderSn(platformOrderRefundSns);
        if (CollectionUtils.isNotEmpty((Collection)dgAfterSaleOrderEos)) {
            CubeBeanUtils.copyCollection(result, (Collection)dgAfterSaleOrderEos, DgAfterSaleOrderRespDto.class);
        }
        return result;
    }

    @Override
    public void updateAutomaticRefundStatus(DgAfterSaleOrderReqDto dto) {
        this.logger.info("\u66f4\u65b0\u81ea\u52a8\u9000\u6b3e\u72b6\u6001\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getPlatformRefundOrderSn()), (String)"\u5e73\u53f0\u552e\u540e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)ObjectUtils.isEmpty((Object)dto.getAutomaticRefundStatus()), (String)"\u81ea\u52a8\u9000\u6b3e\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        List dgAfterSaleOrderEos = this.afterSaleOrderDomain.queryByPlatformRefundOrderSn((List)Lists.newArrayList((Object[])new String[]{dto.getPlatformRefundOrderSn()}));
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)dgAfterSaleOrderEos), (String)("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u552e\u540e\u5355\uff1a" + dto.getPlatformRefundOrderSn()));
        dgAfterSaleOrderEos.forEach(eo -> {
            AssertUtils.isFalse((boolean)ObjectUtils.isEmpty((Object)eo.getId()), (String)"\u53c2\u6570\u5f02\u5e38\uff0cid\u4e3a\u7a7a");
            DgAfterSaleOrderEo orderEo = new DgAfterSaleOrderEo();
            orderEo.setId(eo.getId());
            orderEo.setAutomaticRefundStatus(dto.getAutomaticRefundStatus());
            orderEo.setAutomaticRefundFailReason(dto.getAutomaticRefundFailReason());
            this.afterSaleOrderDomain.updateSelective((BaseEo)orderEo);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAfterSaleOrder2Transfer(AfterSaleOrder2TransferReqDto reqDto) {
        String cache_key = "AutoCreateReverseTransferOrderTask";
        if (!this.cacheService.setIfAbsent(cache_key, "1").booleanValue()) {
            log.error("\u5df2\u5b58\u5728\u81ea\u52a8\u6267\u884c\u9000\u8d27\u5355\u751f\u6210\u8c03\u62e8\u5355\u4efb\u52a1\u3002");
            return;
        }
        try {
            this.doExecuteAfterSaleOrder2Transfer(reqDto);
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u81ea\u52a8\u6267\u884c\u9000\u8d27\u5355\u751f\u6210\u8c03\u62e8\u5355\u4efb\u52a1\u51fa\u9519\u4e86", (Throwable)e);
            return;
        }
        finally {
            log.info("\u6267\u884c\u81ea\u52a8\u6267\u884c\u9000\u8d27\u5355\u751f\u6210\u8c03\u62e8\u5355\u4efb\u52a1\u91ca\u653e\uff1a{}\uff0c{}", (Object)Thread.currentThread().getName(), (Object)System.currentTimeMillis());
            this.cacheService.delCache(cache_key);
        }
    }

    @Override
    public List<DgAfterSaleOrderRespDto> queryByDgAfterSaleOrderDto(DgAfterSaleOrderDto dgAfterSaleOrderDto) {
        this.logger.info("\u5bfc\u5165\u9000\u56de\u5feb\u9012\u5355\u53f7\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dgAfterSaleOrderDto));
        ExtQueryChainWrapper filter = this.afterSaleOrderDomain.filter();
        filter.in(Optional.ofNullable(dgAfterSaleOrderDto.getStatusList()).isPresent(), (Object)"status", (Collection)dgAfterSaleOrderDto.getStatusList());
        filter.in((Object)"after_sale_order_type", (Collection)Lists.newArrayList((Object[])new String[]{AfterSaleOrderTypeEnum.THTK.getCode(), AfterSaleOrderTypeEnum.HH.getCode()}));
        filter.and(wrapper -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq(Optional.ofNullable(dgAfterSaleOrderDto.getPlatformRefundOrderSn()).isPresent(), (Object)"platform_refund_order_sn", (Object)dgAfterSaleOrderDto.getPlatformRefundOrderSn())).or()).eq(Optional.ofNullable(dgAfterSaleOrderDto.getAfterSaleOrderNo()).isPresent(), (Object)"after_sale_order_no", (Object)dgAfterSaleOrderDto.getAfterSaleOrderNo())).or()).eq(Optional.ofNullable(dgAfterSaleOrderDto.getReturnShippingSn()).isPresent(), (Object)"return_shipping_sn", (Object)dgAfterSaleOrderDto.getReturnShippingSn())).or()).eq(Optional.ofNullable(dgAfterSaleOrderDto.getPlatformOrderNo()).isPresent(), (Object)"platform_order_no", (Object)dgAfterSaleOrderDto.getPlatformOrderNo());
        });
        List list = filter.list();
        ArrayList<DgAfterSaleOrderRespDto> listRespDto = new ArrayList<DgAfterSaleOrderRespDto>();
        CubeBeanUtils.copyCollection(listRespDto, (Collection)list, DgAfterSaleOrderRespDto.class);
        log.info("\u5185\u90e8\u552e\u540e\u5355\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONObject.toJSONString(listRespDto));
        return listRespDto;
    }

    @Override
    public List<DgAfterSaleOrderDto> getExistAfterSaleOrdersBySaleOrderNo(String saleOrderNo) {
        List eoList = ((IDgAfterSaleOrderDomain)this.domain).getExistAfterSaleOrdersBySaleOrderNo(saleOrderNo);
        return this.converter().toDtoList(eoList);
    }

    @Override
    public List<DgAfterSaleOrderDto> getExistAfterSaleOrdersByPlatformOrderNo(String platformOrderNo) {
        List eoList = ((IDgAfterSaleOrderDomain)this.domain).getExistAfterSaleOrdersByPlatformOrderNo(platformOrderNo);
        return this.converter().toDtoList(eoList);
    }

    public void doExecuteAfterSaleOrder2Transfer(AfterSaleOrder2TransferReqDto reqDto) {
        Map shopCode2DtoMap = this.queryShopList().stream().collect(Collectors.toMap(DgShopRespDto::getStoreCode, Function.identity(), (k1, k2) -> k1));
        if (CollUtil.isEmpty(shopCode2DtoMap)) {
            log.info("\u5e73\u53f0\u5382\u9001\u7684\u5e97\u94fa\u672a\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002");
            return;
        }
        log.info("doExecuteAfterSaleOrder2Transfer\u5382\u9001\u5e97\u94fa:{}", (Object)JSONObject.toJSONString(shopCode2DtoMap.keySet()));
        ArrayList all = Lists.newArrayList();
        AtomicInteger pageNum = new AtomicInteger(1);
        Integer pageSize = 1000;
        DgAfterSaleOrderValidReqDto queryParam = new DgAfterSaleOrderValidReqDto();
        queryParam.setBizModel(reqDto.getBizModel());
        queryParam.setShopCodes(new ArrayList<String>(shopCode2DtoMap.keySet()));
        queryParam.setInWarehouseDateStart(reqDto.getCompleteDateStart());
        queryParam.setInWarehouseDateEnd(reqDto.getCompleteDateEnd());
        queryParam.setExcludeSettledTransferStatus(Integer.valueOf(1));
        while (true) {
            int pagNum;
            PageInfo<DgAfterSaleOrderRespDto> pageInfo;
            if ((pageInfo = this.queryByPage(queryParam, pagNum = pageNum.get(), pageSize)) == null || !CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) break;
            List<DgOrderAfterReportDto> dgOrderAfterReportDtos = this.buildDgOrderAfterReportDto(pageInfo.getList());
            if (CollectionUtils.isNotEmpty(dgOrderAfterReportDtos)) {
                all.addAll(dgOrderAfterReportDtos);
            }
            log.info("\u67e5\u8be2\u5f53\u65e5\u552e\u540e\u8ba2\u5355\u5546\u54c1\u884c, \u5f53\u524d\u7b2c{}\u9875", (Object)pagNum);
            pageNum.addAndGet(1);
        }
        log.info("\u67e5\u8be2\u5f53\u65e5\u552e\u540e\u8ba2\u5355\u5546\u54c1\u884c\u5b8c\u6bd5");
        Map<String, List<DgOrderAfterReportDto>> collect = all.stream().filter(x -> shopCode2DtoMap.containsKey(x.getShopCode())).collect(Collectors.groupingBy(x -> {
            x.setSettlementWarehouseCode(((DgShopRespDto)shopCode2DtoMap.get(x.getShopCode())).getSettlementWarehouseCode());
            return "SUMMARY_TRANSFER".equals(reqDto.getConfig()) ? StrUtil.join((CharSequence)"_", (Object[])new Object[]{x.getSettlementWarehouseCode(), x.getReturnWarehouseCode()}) : x.getAfterSaleOrderNo();
        }));
        for (Map.Entry<String, List<DgOrderAfterReportDto>> entry : collect.entrySet()) {
            List<DgOrderAfterReportDto> orderDetails = entry.getValue();
            if (CollUtil.isEmpty(orderDetails)) {
                log.info("{}\u4e0d\u5b58\u5728\u9700\u8981\u5904\u7406\u7684\u552e\u540e\u5355", (Object)entry.getKey());
                continue;
            }
            try {
                this.afterSaleOrderInventoryHandleService.doGenerateTransferOrder(orderDetails);
            }
            catch (Exception e) {
                log.error("\u5e73\u53f0\u5382\u9001\u9000\u8d27\u5165\u5e93\u81ea\u52a8\u4ece\u7ed3\u7b97\u4ed3\u8c03\u62e8\u56de\u552e\u540e\u4ed3\u4efb\u52a1\u6267\u884c\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public List<DgOrderAfterReportDto> buildDgOrderAfterReportDto(List<DgAfterSaleOrderRespDto> respDtos) {
        Map id2DtoMap = respDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (k1, k2) -> k1));
        if (CollUtil.isEmpty(id2DtoMap)) {
            return null;
        }
        ArrayList<DgOrderAfterReportDto> resultList = new ArrayList<DgOrderAfterReportDto>();
        List<DgAfterSaleOrderItemRespDto> dgAfterSaleOrderItemRespDtos = this.queryByAfterSaleOrderIds(new ArrayList<Long>(id2DtoMap.keySet()));
        for (DgAfterSaleOrderItemRespDto respDto : dgAfterSaleOrderItemRespDtos) {
            DgOrderAfterReportDto afterReportDto = new DgOrderAfterReportDto();
            CubeBeanUtils.copyProperties((Object)afterReportDto, (Object)respDto, (String[])new String[0]);
            DgAfterSaleOrderRespDto dgAfterSaleOrderRespDto = (DgAfterSaleOrderRespDto)id2DtoMap.get(respDto.getAfterSaleOrderId());
            if (dgAfterSaleOrderRespDto != null) {
                afterReportDto.setAfterSaleOrderNo(dgAfterSaleOrderRespDto.getAfterSaleOrderNo());
                afterReportDto.setAfterSaleOrderId(dgAfterSaleOrderRespDto.getId());
                afterReportDto.setShopCode(dgAfterSaleOrderRespDto.getShopCode());
                afterReportDto.setReturnWarehouseCode(dgAfterSaleOrderRespDto.getReturnWarehouseCode());
                if ("B2C".equals(dgAfterSaleOrderRespDto.getBizModel())) {
                    afterReportDto.setItemNum(new BigDecimal(respDto.getItemNum()));
                } else {
                    afterReportDto.setItemNum(new BigDecimal(respDto.getReturnNum()));
                }
                afterReportDto.setPlatformOrderNo(dgAfterSaleOrderRespDto.getPlatformOrderNo());
                afterReportDto.setInnerOrderNo(dgAfterSaleOrderRespDto.getAfterSaleOrderNo());
                afterReportDto.setOrderItemId(respDto.getId());
            }
            resultList.add(afterReportDto);
        }
        return resultList;
    }

    private List<DgAfterSaleOrderItemRespDto> queryByAfterSaleOrderIds(List<Long> afterSaleOrderIds) {
        List itemEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.afterSaleOrderItemDomain.filter().eq((Object)"after_sale_order_item_type", (Object)0)).in((Object)"after_sale_order_id", afterSaleOrderIds)).list();
        ArrayList<DgAfterSaleOrderItemRespDto> targetItemList = new ArrayList<DgAfterSaleOrderItemRespDto>();
        CubeBeanUtils.copyCollection(targetItemList, (Collection)itemEoList, DgAfterSaleOrderItemRespDto.class);
        return targetItemList;
    }

    public List<DgShopRespDto> queryShopList() {
        DgShopQueryReqDto reqDto = new DgShopQueryReqDto();
        reqDto.setUseSettlementWarehouse(Integer.valueOf(1));
        reqDto.setStatusList(Collections.singletonList(1));
        return (List)this.dgShopQueryApiProxy.queryListShop(reqDto).getData();
    }
}

