/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.JacksonUtil;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.dto.finance.KeepAccountsDetailDto;
import com.yunxi.dg.base.center.trade.dto.finance.PushStatusToTradeDto;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderExtensionEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.trade.service.entity.IPerformOrderSysFinanceService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IPerformOrderSysFinanceServiceImpl
implements IPerformOrderSysFinanceService {
    private static final Logger log = LoggerFactory.getLogger(IPerformOrderSysFinanceServiceImpl.class);
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgPerformOrderExtensionDomain dgPerformOrderExtensionDomain;
    @Resource
    private IDgPerformOrderItemLineDomain dgPerformOrderItemLineDomain;
    @Resource
    private IDgAfterSaleOrderItemDomain dgAfterSaleOrderItemDomain;
    @Resource
    private IDgAfterSaleOrderDomain dgAfterSaleOrderDomain;

    @Override
    public void assembleSaleOrderAction(PushStatusToTradeDto pushStatusToTradeDto) {
        log.info("\u6b63\u5411\u5355\u636e\u540c\u6b65\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)pushStatusToTradeDto));
        ArrayList detailDtos = pushStatusToTradeDto.getDetailDtos();
        String voucherType = ((KeepAccountsDetailDto)detailDtos.get(0)).getVoucherType();
        List orderNos = detailDtos.stream().map(KeepAccountsDetailDto::getOrderNo).collect(Collectors.toList());
        List saleOrderNo = ((ExtQueryChainWrapper)this.dgPerformOrderInfoDomain.filter().in((Object)"sale_order_no", orderNos)).list();
        Map<String, Long> dgPerformOrderInfoEoMap = saleOrderNo.stream().collect(Collectors.toMap(DgPerformOrderInfoEo::getSaleOrderNo, BaseEo::getId));
        Map infoEoMap = saleOrderNo.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (e1, e2) -> e1));
        HashMap dgPerformOrderInfoEoShipMap = new HashMap();
        dgPerformOrderInfoEoMap.forEach((k, v) -> {
            List dgPerformOrderItemLineEoList = new ArrayList();
            DgPerformOrderInfoEo dgPerformOrderInfoEo = (DgPerformOrderInfoEo)infoEoMap.get(v);
            Integer orderSource = dgPerformOrderInfoEo.getOrderSource();
            if (null != orderSource && orderSource == 4) {
                List lineIds = ((ExtQueryChainWrapper)this.dgPerformOrderLineDomain.filter().eq((Object)"order_id", v)).list().stream().map(BaseEo::getId).collect(Collectors.toList());
                dgPerformOrderItemLineEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderItemLineDomain.filter().in((Object)"order_line_id", lineIds)).eq((Object)"sh_flag", (Object)0)).list();
            } else {
                dgPerformOrderItemLineEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderItemLineDomain.filter().eq((Object)"order_id", v)).eq((Object)"sh_flag", (Object)0)).list();
            }
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
            for (DgPerformOrderItemLineEo dgPerformOrderItemLineEo : dgPerformOrderItemLineEoList) {
                Integer deliveryStatus = dgPerformOrderItemLineEo.getDeliveryStatus();
                if (deliveryStatus == 1) {
                    if (map.containsKey(dgPerformOrderItemLineEo.getSkuCode())) {
                        BigDecimal currentValue = (BigDecimal)map.get(dgPerformOrderItemLineEo.getSkuCode());
                        map.put(dgPerformOrderItemLineEo.getSkuCode(), currentValue.add(dgPerformOrderItemLineEo.getItemNum()));
                        continue;
                    }
                    map.put(dgPerformOrderItemLineEo.getSkuCode(), dgPerformOrderItemLineEo.getItemNum());
                    continue;
                }
                map.put(dgPerformOrderItemLineEo.getSkuCode(), dgPerformOrderItemLineEo.getItemNum());
            }
            dgPerformOrderInfoEoShipMap.put(k, map);
        });
        log.info("dgPerformOrderInfoEoShipMap: {}", (Object)JacksonUtil.toJson(dgPerformOrderInfoEoShipMap));
        Map<String, List<KeepAccountsDetailDto>> financeAccountMap = detailDtos.stream().collect(Collectors.groupingBy(KeepAccountsDetailDto::getOrderNo));
        financeAccountMap.forEach((k, v) -> {
            Long aLong = (Long)dgPerformOrderInfoEoMap.get(k);
            List dgPerformOrderLineEos = ((ExtQueryChainWrapper)this.dgPerformOrderLineDomain.filter().eq((Object)"order_id", (Object)aLong)).list();
            Map decimalMap = (Map)dgPerformOrderInfoEoShipMap.get(k);
            if (CollUtil.isNotEmpty((Map)decimalMap)) {
                HashMap<String, String> comparedDliveryResult = new HashMap<String, String>();
                HashMap<String, String> comparedBillingResult = new HashMap<String, String>();
                for (KeepAccountsDetailDto keepAccountsDetailDto : v) {
                    if (keepAccountsDetailDto.getVoucherType().equals("0")) {
                        IPerformOrderSysFinanceServiceImpl.extractedCompareNum(decimalMap, comparedDliveryResult, keepAccountsDetailDto);
                        continue;
                    }
                    IPerformOrderSysFinanceServiceImpl.extractedCompareNum(decimalMap, comparedBillingResult, keepAccountsDetailDto);
                }
                for (DgPerformOrderLineEo dgPerformOrderLineEo : dgPerformOrderLineEos) {
                    String s2;
                    String s1;
                    String[] split;
                    String s;
                    String skuCode = dgPerformOrderLineEo.getSkuCode();
                    if (comparedDliveryResult.containsKey(skuCode)) {
                        s = comparedDliveryResult.get(skuCode);
                        split = s.split("-");
                        s1 = split[0];
                        dgPerformOrderLineEo.setLineDeliveryAccounting(s1);
                        s2 = split[1];
                        dgPerformOrderLineEo.setDeliveryAccountingNum(s2);
                    }
                    if (comparedBillingResult.containsKey(skuCode)) {
                        s = comparedBillingResult.get(skuCode);
                        split = s.split("-");
                        s1 = split[0];
                        dgPerformOrderLineEo.setLineBillingAccounting(s1);
                        s2 = split[1];
                        dgPerformOrderLineEo.setBillingAccountingNum(s2);
                    }
                    this.dgPerformOrderLineDomain.updateSelective((BaseEo)dgPerformOrderLineEo);
                }
                String actionDelivery = "";
                String actionbill = "";
                List financeAccountItemCodes = v.stream().map(KeepAccountsDetailDto::getItemCode).distinct().collect(Collectors.toList());
                if (voucherType.equals("0")) {
                    List<String> lineDeliveryList = dgPerformOrderLineEos.stream().filter(e -> null != e.getLineDeliveryAccounting() && financeAccountItemCodes.contains(e.getSkuCode())).map(DgPerformOrderLineEo::getLineDeliveryAccounting).collect(Collectors.toList());
                    actionDelivery = IPerformOrderSysFinanceServiceImpl.extractedActionCompara(lineDeliveryList);
                } else {
                    List<String> lineBillList = dgPerformOrderLineEos.stream().filter(e -> null != e.getLineBillingAccounting() && financeAccountItemCodes.contains(e.getSkuCode())).map(DgPerformOrderLineEo::getLineBillingAccounting).collect(Collectors.toList());
                    actionbill = IPerformOrderSysFinanceServiceImpl.extractedActionCompara(lineBillList);
                }
                DgPerformOrderExtensionEo dgPerformOrderExtensionEo = (DgPerformOrderExtensionEo)((ExtQueryChainWrapper)this.dgPerformOrderExtensionDomain.filter().eq((Object)"order_id", (Object)aLong)).one();
                if (StringUtils.isNotEmpty((CharSequence)actionDelivery)) {
                    dgPerformOrderExtensionEo.setDeliveryAccounting(actionDelivery);
                }
                if (StringUtils.isNotEmpty((CharSequence)actionbill)) {
                    dgPerformOrderExtensionEo.setBillingAccounting(actionbill);
                }
                this.dgPerformOrderExtensionDomain.updateSelective((BaseEo)dgPerformOrderExtensionEo);
                DgPerformOrderInfoEo dgPerformOrderInfoEo = (DgPerformOrderInfoEo)this.dgPerformOrderInfoDomain.selectByPrimaryKey(aLong);
                dgPerformOrderInfoEo.setUpdateTime(new Date());
                this.dgPerformOrderInfoDomain.updateSelective((BaseEo)dgPerformOrderInfoEo);
            }
        });
    }

    private static String extractedActionCompara(List<String> lineDeliveryList) {
        String s = "";
        if (CollUtil.isNotEmpty(lineDeliveryList)) {
            List list = lineDeliveryList.stream().distinct().collect(Collectors.toList());
            int size = list.size();
            s = size == 0 ? "UNACCOUNTED" : (size == 1 ? lineDeliveryList.get(0) : "PARTIALLY_ACCOUNTED");
        }
        return s;
    }

    private static void extractedCompareNum(Map<String, BigDecimal> decimalMap, HashMap<String, String> compareResult, KeepAccountsDetailDto keepAccountsDetailDto) {
        String itemCode = keepAccountsDetailDto.getItemCode();
        Integer itemNum = keepAccountsDetailDto.getItemNum();
        if (decimalMap.containsKey(itemCode)) {
            BigDecimal bigDecimal = decimalMap.get(itemCode);
            if (bigDecimal.compareTo(new BigDecimal(itemNum)) == 0) {
                compareResult.put(itemCode, "ACCOUNTED-" + itemNum);
            } else if (new BigDecimal(itemNum).compareTo(BigDecimal.ZERO) == 0) {
                compareResult.put(itemCode, "UNACCOUNTED-" + itemNum);
            } else {
                compareResult.put(itemCode, "PARTIALLY_ACCOUNTED-" + itemNum);
            }
        }
    }

    @Override
    public void assembleAfterSaleOrderAction(PushStatusToTradeDto pushStatusToTradeDto) {
        log.info("\u552e\u540e\u5355\u636e\u63a8\u9001\u72b6\u6001:{}", (Object)JSON.toJSONString((Object)pushStatusToTradeDto));
        ArrayList detailDtos = pushStatusToTradeDto.getDetailDtos();
        String voucherType = ((KeepAccountsDetailDto)detailDtos.get(0)).getVoucherType();
        List orderNos = detailDtos.stream().map(KeepAccountsDetailDto::getOrderNo).distinct().collect(Collectors.toList());
        List afterSaleOrderNo = ((ExtQueryChainWrapper)this.dgAfterSaleOrderDomain.filter().in((Object)"after_sale_order_no", orderNos)).list();
        Map<String, Long> map = afterSaleOrderNo.stream().collect(Collectors.toMap(DgAfterSaleOrderEo::getAfterSaleOrderNo, BaseEo::getId));
        Map<String, List<KeepAccountsDetailDto>> detailDtoMap = detailDtos.stream().collect(Collectors.groupingBy(KeepAccountsDetailDto::getOrderNo));
        detailDtoMap.forEach((k, v) -> {
            Long aLong = (Long)map.get(k);
            List dgAfterSaleOrderItemEos = ((ExtQueryChainWrapper)this.dgAfterSaleOrderItemDomain.filter().eq((Object)"after_sale_order_id", (Object)aLong)).list();
            Map<String, BigDecimal> decimalMap = dgAfterSaleOrderItemEos.stream().collect(Collectors.toMap(DgAfterSaleOrderItemEo::getSkuCode, e -> new BigDecimal(e.getItemNum()), (k1, k2) -> k1));
            HashMap<String, String> comparedDliveryResult = new HashMap<String, String>();
            HashMap<String, String> comparedBillingResult = new HashMap<String, String>();
            for (KeepAccountsDetailDto keepAccountsDetailDto : v) {
                if (keepAccountsDetailDto.getVoucherType().equals("0")) {
                    IPerformOrderSysFinanceServiceImpl.extractedCompareNum(decimalMap, comparedDliveryResult, keepAccountsDetailDto);
                    continue;
                }
                IPerformOrderSysFinanceServiceImpl.extractedCompareNum(decimalMap, comparedBillingResult, keepAccountsDetailDto);
            }
            for (DgAfterSaleOrderItemEo dgAfterSaleOrderItemEo : dgAfterSaleOrderItemEos) {
                String s1;
                String[] split;
                String s;
                AssertUtils.notNull((Object)dgAfterSaleOrderItemEo.getId(), (String)"\u83b7\u53d6\u5230\u552e\u540e\u5546\u54c1\u884c\u5355id\u4e3a\u7a7a");
                DgAfterSaleOrderItemEo updateSaleOrderItemEo = new DgAfterSaleOrderItemEo();
                updateSaleOrderItemEo.setId(dgAfterSaleOrderItemEo.getId());
                String skuCode = dgAfterSaleOrderItemEo.getSkuCode();
                if (comparedDliveryResult.containsKey(skuCode)) {
                    s = comparedDliveryResult.get(skuCode);
                    split = s.split("-");
                    s1 = split[0];
                    updateSaleOrderItemEo.setAfterDeliveryAccounting(s1);
                }
                if (comparedBillingResult.containsKey(skuCode)) {
                    s = comparedBillingResult.get(skuCode);
                    split = s.split("-");
                    s1 = split[0];
                    updateSaleOrderItemEo.setAfterBillingAccounting(s1);
                }
                if (updateSaleOrderItemEo.getAfterBillingAccounting() != null) {
                    this.dgAfterSaleOrderItemDomain.updateSelective((BaseEo)updateSaleOrderItemEo);
                    continue;
                }
                log.info("\u884cAfterBillingAccounting\u4e3a\u7a7a\uff0c\u4e0d\u66f4\u65b0 {}", (Object)updateSaleOrderItemEo.getId());
            }
            String actionDelivery = "";
            String actionbill = "";
            List financeAccountItemCodes = v.stream().map(KeepAccountsDetailDto::getItemCode).distinct().collect(Collectors.toList());
            if (voucherType.equals("0")) {
                List<String> lineDeliveryList = dgAfterSaleOrderItemEos.stream().filter(e -> null != e.getAfterDeliveryAccounting() && financeAccountItemCodes.contains(e.getSkuCode())).map(DgAfterSaleOrderItemEo::getAfterDeliveryAccounting).collect(Collectors.toList());
                actionDelivery = IPerformOrderSysFinanceServiceImpl.extractedActionCompara(lineDeliveryList);
            } else {
                List<String> lineBillList = dgAfterSaleOrderItemEos.stream().filter(e -> null != e.getAfterBillingAccounting() && financeAccountItemCodes.contains(e.getSkuCode())).map(DgAfterSaleOrderItemEo::getAfterBillingAccounting).collect(Collectors.toList());
                actionbill = IPerformOrderSysFinanceServiceImpl.extractedActionCompara(lineBillList);
            }
            DgAfterSaleOrderEo dgAfterSaleOrderEo = (DgAfterSaleOrderEo)this.dgAfterSaleOrderDomain.selectByPrimaryKey(aLong);
            AssertUtils.notNull((Object)dgAfterSaleOrderEo.getId(), (String)("\u83b7\u53d6\u4e0d\u5230\u552e\u540e\u5355\u4fe1\u606f" + aLong));
            DgAfterSaleOrderEo updateSaleOrderEo = new DgAfterSaleOrderEo();
            updateSaleOrderEo.setId(dgAfterSaleOrderEo.getId());
            if (StringUtils.isNotEmpty((CharSequence)actionDelivery)) {
                updateSaleOrderEo.setAfterDeliveryAccounting(actionDelivery);
            }
            if (StringUtils.isNotEmpty((CharSequence)actionbill)) {
                updateSaleOrderEo.setAfterBillingAccounting(actionbill);
            }
            if (updateSaleOrderEo.getAfterBillingAccounting() != null) {
                this.dgAfterSaleOrderDomain.updateSelective((BaseEo)updateSaleOrderEo);
            } else {
                log.info("\u5934AfterBillingAccounting\u4e3a\u7a7a\uff0c\u4e0d\u66f4\u65b0 {}", (Object)updateSaleOrderEo.getId());
            }
        });
    }
}

