/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.trade.convert.entity.AutomaticRefundConfigConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IAutomaticRefundConfigDomain;
import com.yunxi.dg.base.center.trade.dto.entity.AutomaticRefundConfigDto;
import com.yunxi.dg.base.center.trade.eo.AutomaticRefundConfigEo;
import com.yunxi.dg.base.center.trade.service.entity.IAutomaticRefundConfigService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AutomaticRefundConfigServiceImpl
extends BaseServiceImpl<AutomaticRefundConfigDto, AutomaticRefundConfigEo, IAutomaticRefundConfigDomain>
implements IAutomaticRefundConfigService {
    private static final Logger logger = LoggerFactory.getLogger(AutomaticRefundConfigServiceImpl.class);

    public AutomaticRefundConfigServiceImpl(IAutomaticRefundConfigDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<AutomaticRefundConfigDto, AutomaticRefundConfigEo> converter() {
        return AutomaticRefundConfigConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void coverUpdate(List<AutomaticRefundConfigDto> dtoList) {
        List ids;
        logger.info("\u8986\u76d6\u66f4\u65b0\u81ea\u52a8\u9000\u6b3e\u914d\u7f6e\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(dtoList));
        if (CollectionUtil.isNotEmpty(dtoList)) {
            dtoList.stream().collect(Collectors.groupingBy(AutomaticRefundConfigDto::getShopCode)).forEach((key, value) -> AssertUtils.isFalse((value.size() > 1 ? 1 : 0) != 0, (String)("\u5e97\u94fa\u91cd\u590d\u6dfb\u52a0\uff1a" + key)));
        }
        if (CollectionUtil.isNotEmpty(ids = ((IAutomaticRefundConfigDomain)this.domain).selectAll().stream().map(BaseEo::getId).collect(Collectors.toList()))) {
            ((IAutomaticRefundConfigDomain)this.domain).logicDeleteByIds(ids);
        }
        if (CollectionUtil.isNotEmpty(dtoList)) {
            dtoList.forEach(dto -> {
                AutomaticRefundConfigEo configEo = new AutomaticRefundConfigEo();
                configEo.setShopCode(dto.getShopCode());
                configEo.setShopName(dto.getShopName());
                ((IAutomaticRefundConfigDomain)this.domain).insert((BaseEo)configEo);
            });
        }
    }

    @Override
    public AutomaticRefundConfigDto queryByShopCode(String shopCode) {
        logger.info("\u6839\u636e\u5e97\u94fa\u7f16\u7801\u67e5\u8be2\uff1a{}", (Object)shopCode);
        List eoList = ((ExtQueryChainWrapper)((IAutomaticRefundConfigDomain)this.domain).filter().eq((Object)"shop_code", (Object)shopCode)).list();
        if (CollectionUtil.isNotEmpty((Collection)eoList)) {
            AutomaticRefundConfigDto dto = new AutomaticRefundConfigDto();
            CubeBeanUtils.copyProperties((Object)dto, eoList.get(0), (String[])new String[0]);
            return dto;
        }
        return null;
    }
}

