/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.wh.center.data.api.dto.response.AreaRespDto;
import com.wh.center.data.api.query.IAreaBaseQueryApi;
import com.yunxi.dg.base.center.trade.constants.NationalSupplementAreaRuleStatusEnum;
import com.yunxi.dg.base.center.trade.convert.entity.NationalSupplementAreaRuleAreaConverter;
import com.yunxi.dg.base.center.trade.domain.entity.INationalSupplementAreaRuleAreaDomain;
import com.yunxi.dg.base.center.trade.dto.entity.NationalSupplementAreaRuleAreaDto;
import com.yunxi.dg.base.center.trade.dto.entity.NationalSupplementAreaRuleDto;
import com.yunxi.dg.base.center.trade.eo.NationalSupplementAreaRuleAreaEo;
import com.yunxi.dg.base.center.trade.eo.NationalSupplementAreaRuleEo;
import com.yunxi.dg.base.center.trade.service.entity.INationalSupplementAreaRuleAreaService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class NationalSupplementAreaRuleAreaServiceImpl
extends BaseServiceImpl<NationalSupplementAreaRuleAreaDto, NationalSupplementAreaRuleAreaEo, INationalSupplementAreaRuleAreaDomain>
implements INationalSupplementAreaRuleAreaService {
    @Resource
    private IAreaBaseQueryApi areaBaseQueryApi;

    public NationalSupplementAreaRuleAreaServiceImpl(INationalSupplementAreaRuleAreaDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<NationalSupplementAreaRuleAreaDto, NationalSupplementAreaRuleAreaEo> converter() {
        return NationalSupplementAreaRuleAreaConverter.INSTANCE;
    }

    @Override
    public void replaceAreaList(NationalSupplementAreaRuleDto dto) {
        this.replaceAreaList(dto.getId(), dto.getAreaList());
    }

    @Override
    public void replaceAreaList(Long ruleId, List<NationalSupplementAreaRuleAreaDto> areaList) {
        areaList = Optional.ofNullable(areaList).orElse(Collections.emptyList());
        List dbAreaList = ((INationalSupplementAreaRuleAreaDomain)this.domain).getByRuleId(ruleId);
        Set dbAreaIds = dbAreaList.stream().map(BaseEo::getId).collect(Collectors.toSet());
        ArrayList insertList = new ArrayList();
        ArrayList updateList = new ArrayList();
        areaList.forEach(area -> {
            area.setRuleId(ruleId);
            if (area.getId() != null) {
                dbAreaIds.remove(area.getId());
                updateList.add(area);
            } else {
                insertList.add(area);
            }
        });
        this.fillAreaInfo(areaList);
        if (!insertList.isEmpty()) {
            List eoList = this.converter().toEoList(insertList);
            ((INationalSupplementAreaRuleAreaDomain)this.domain).insertBatch(eoList);
        }
        if (!updateList.isEmpty()) {
            updateList.forEach(dto -> {
                NationalSupplementAreaRuleAreaEo eo = (NationalSupplementAreaRuleAreaEo)this.converter().toEo((BaseDto)dto);
                ((INationalSupplementAreaRuleAreaDomain)this.domain).updateSelective((BaseEo)eo);
            });
        }
        if (!dbAreaIds.isEmpty()) {
            ((INationalSupplementAreaRuleAreaDomain)this.domain).logicDeleteByIds(new ArrayList(dbAreaIds));
        }
    }

    @Override
    public List<NationalSupplementAreaRuleAreaDto> getDtoListByRuleId(Long ruleId) {
        List areaList = ((INationalSupplementAreaRuleAreaDomain)this.domain).getByRuleId(ruleId);
        return this.converter().toDtoList(areaList);
    }

    @Override
    public List<NationalSupplementAreaRuleAreaDto> getDtoListByRuleIds(Collection<Long> ruleIds) {
        List areaList = ((INationalSupplementAreaRuleAreaDomain)this.domain).getByRuleIds(ruleIds);
        return this.converter().toDtoList(areaList);
    }

    @Override
    public Map<Long, List<NationalSupplementAreaRuleAreaDto>> getDtoMapByRuleIds(Collection<Long> ruleIds) {
        return this.getDtoListByRuleIds(ruleIds).stream().collect(Collectors.groupingBy(NationalSupplementAreaRuleAreaDto::getRuleId));
    }

    @Override
    public List<Long> matchRules(List<NationalSupplementAreaRuleEo> rules, String provinceCode, String cityCode, String areaCode) {
        Date now = new Date();
        Map<Integer, List<NationalSupplementAreaRuleEo>> limitGroup = rules.stream().filter(s -> NationalSupplementAreaRuleStatusEnum.ENABLE.getCode().equals(s.getStatus())).filter(s -> !now.before(s.getStartTime()) && !now.after(s.getEndTime())).collect(Collectors.groupingBy(NationalSupplementAreaRuleEo::getAreaLimit));
        if (limitGroup.isEmpty()) {
            return Collections.emptyList();
        }
        List<Long> result = ((List)limitGroup.getOrDefault(1, new ArrayList())).stream().map(BaseEo::getId).collect(Collectors.toList());
        List ruleIds = ((List)limitGroup.getOrDefault(2, new ArrayList())).stream().map(BaseEo::getId).collect(Collectors.toList());
        if (!ruleIds.isEmpty() && StrUtil.isNotBlank((CharSequence)provinceCode)) {
            ruleIds = ((INationalSupplementAreaRuleAreaDomain)this.domain).matchRulesByAreaCodes(ruleIds, provinceCode, cityCode, areaCode);
            result.addAll(ruleIds);
        }
        return result;
    }

    private void fillAreaInfo(List<NationalSupplementAreaRuleAreaDto> ruleAreaList) {
        Set<String> areaCodes = ruleAreaList.stream().map(NationalSupplementAreaRuleAreaDto::getTargetCode).collect(Collectors.toSet());
        HashMap<String, AreaRespDto> areaMap = new HashMap<String, AreaRespDto>();
        this.putAllAreaPathToMap(areaMap, areaCodes);
        ruleAreaList.forEach(ruleArea -> {
            AreaRespDto area1 = (AreaRespDto)areaMap.get(ruleArea.getTargetCode());
            if (area1 == null) {
                return;
            }
            ruleArea.setTargetName(area1.getName());
            ruleArea.setTargetType(area1.getLevelId());
            switch (ruleArea.getTargetType()) {
                case 0: {
                    ruleArea.setProvinceCode(area1.getCode());
                    ruleArea.setProvinceName(area1.getName());
                    break;
                }
                case 1: {
                    ruleArea.setCityCode(area1.getCode());
                    ruleArea.setCityName(area1.getName());
                    Optional.ofNullable(areaMap.get(area1.getParentCode())).ifPresent(province -> {
                        ruleArea.setProvinceCode(province.getCode());
                        ruleArea.setProvinceName(province.getName());
                    });
                    break;
                }
                case 2: {
                    ruleArea.setAreaCode(area1.getCode());
                    ruleArea.setAreaName(area1.getName());
                    Optional.ofNullable(areaMap.get(area1.getParentCode())).ifPresent(city -> {
                        ruleArea.setCityCode(city.getCode());
                        ruleArea.setCityName(city.getName());
                        Optional.ofNullable(areaMap.get(city.getParentCode())).ifPresent(province -> {
                            ruleArea.setProvinceCode(province.getCode());
                            ruleArea.setProvinceName(province.getName());
                        });
                    });
                    break;
                }
                default: {
                    throw new BizException(String.format("\u4e0d\u652f\u6301\u7684\u533a\u57df\u7c7b\u578b\uff1a[%s - %s - %s]", ruleArea.getTargetCode(), ruleArea.getTargetName(), ruleArea.getTargetType()));
                }
            }
        });
    }

    private void putAllAreaPathToMap(Map<String, AreaRespDto> areaMap, Set<String> areaCodes) {
        if (areaCodes.isEmpty()) {
            return;
        }
        RestResponse resp = this.areaBaseQueryApi.queryInCodes(new ArrayList<String>(areaCodes));
        List areaList = (List)RestResponseHelper.extractData((RestResponse)resp);
        HashSet<String> parentCodes = new HashSet<String>();
        areaList.forEach(area -> {
            areaMap.put(area.getCode(), (AreaRespDto)area);
            if (Objects.equals(0, area.getLevelId()) || StrUtil.isBlank((CharSequence)area.getParentCode())) {
                return;
            }
            if (!areaMap.containsKey(area.getParentCode())) {
                parentCodes.add(area.getParentCode());
            }
        });
        this.putAllAreaPathToMap(areaMap, parentCodes);
    }
}

