/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.wh.center.data.api.IAreaExtApi;
import com.wh.center.data.api.dto.request.AreaNameReqDto;
import com.wh.center.data.api.dto.request.MatchByNameOrAliasReqDto;
import com.wh.center.data.api.dto.response.AreaMatchRespDto;
import com.wh.center.data.api.dto.response.AreaNodeDto;
import com.yunxi.dg.base.center.finance.api.entity.IRelatedTradeShopKeepingApi;
import com.yunxi.dg.base.center.finance.dto.entity.MatchRelatedTradeShopKeepDto;
import com.yunxi.dg.base.center.finance.dto.entity.MatchRelatedTradeShopReqDto;
import com.yunxi.dg.base.center.trade.constants.NationalSupplementAreaRuleStatusEnum;
import com.yunxi.dg.base.center.trade.convert.entity.NationalSupplementAreaRuleConverter;
import com.yunxi.dg.base.center.trade.domain.entity.INationalSupplementAreaRuleDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.NationalSupplementAreaRuleAreaDto;
import com.yunxi.dg.base.center.trade.dto.entity.NationalSupplementAreaRuleDto;
import com.yunxi.dg.base.center.trade.dto.entity.NationalSupplementAreaRulePageReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.NationalSupplementAreaRulePlatformCompanyDto;
import com.yunxi.dg.base.center.trade.dto.entity.NationalSupplementValidateDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.eo.NationalSupplementAreaRuleEo;
import com.yunxi.dg.base.center.trade.service.entity.INationalSupplementAreaRuleAreaService;
import com.yunxi.dg.base.center.trade.service.entity.INationalSupplementAreaRuleService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class NationalSupplementAreaRuleServiceImpl
extends BaseServiceImpl<NationalSupplementAreaRuleDto, NationalSupplementAreaRuleEo, INationalSupplementAreaRuleDomain>
implements INationalSupplementAreaRuleService {
    private static final Logger log = LoggerFactory.getLogger(NationalSupplementAreaRuleServiceImpl.class);
    @Resource
    private INationalSupplementAreaRuleAreaService nationalSupplementAreaRuleAreaService;
    @Resource
    private ILockService lockService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IAreaExtApi areaExtApi;
    @Resource
    private IRelatedTradeShopKeepingApi relatedTradeShopKeepingApi;

    public NationalSupplementAreaRuleServiceImpl(INationalSupplementAreaRuleDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<NationalSupplementAreaRuleDto, NationalSupplementAreaRuleEo> converter() {
        return NationalSupplementAreaRuleConverter.INSTANCE;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> insert(NationalSupplementAreaRuleDto dto) {
        dto.processBeforeReq();
        this.validate(dto);
        dto.setStatus(NationalSupplementAreaRuleStatusEnum.ENABLE.getCode());
        dto.setCode(this.makeCode());
        NationalSupplementAreaRuleEo eo = (NationalSupplementAreaRuleEo)this.converter().toEo((BaseDto)dto);
        ((INationalSupplementAreaRuleDomain)this.domain).insert((BaseEo)eo);
        dto.setId(eo.getId());
        this.nationalSupplementAreaRuleAreaService.replaceAreaList(dto);
        return new RestResponse((Object)eo.getId());
    }

    private void validate(NationalSupplementAreaRuleDto dto) {
        NationalSupplementAreaRuleEo dbEo = this.getBySaleCompanyCode(dto.getSaleCompanyCode());
        if (!(dbEo == null || dto.getId() != null && Objects.equals(dbEo.getId(), dto.getId()))) {
            throw new BizException("\u5df2\u5b58\u5728\u9500\u552e\u4e3b\u4f53\u7f16\u7801\u4e3a[" + dto.getSaleCompanyCode() + "]\u7684\u8bb0\u5f55");
        }
        List platformCompanyCodes = dto.getPlatformCompanies().stream().map(NationalSupplementAreaRulePlatformCompanyDto::getCode).distinct().collect(Collectors.toList());
        List rules = ((INationalSupplementAreaRuleDomain)this.domain).getByPlatformCompanyCodes(platformCompanyCodes);
        Set codes = rules.stream().filter(k -> dto.getId() == null || !Objects.equals(k.getId(), dto.getId())).flatMap(k -> JacksonUtil.readList((String)k.getPlatformCompanyJson(), NationalSupplementAreaRulePlatformCompanyDto.class).stream()).map(NationalSupplementAreaRulePlatformCompanyDto::getCode).collect(Collectors.toSet());
        if (!codes.isEmpty()) {
            throw new BizException("\u5e73\u53f0\u4e3b\u4f53\u7f16\u7801" + codes + "\u5df2\u5b58\u5728");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Integer> insertBatch(List<NationalSupplementAreaRuleDto> dtos) {
        dtos.forEach(this::insert);
        return new RestResponse();
    }

    public RestResponse<Integer> update(NationalSupplementAreaRuleDto dto) {
        dto.processBeforeReq();
        this.validate(dto);
        RestResponse rs = super.update((BaseDto)dto);
        this.nationalSupplementAreaRuleAreaService.replaceAreaList(dto);
        return rs;
    }

    @Override
    public NationalSupplementAreaRuleEo getBySaleCompanyCode(String saleCompanyCode) {
        return ((INationalSupplementAreaRuleDomain)this.domain).getBySaleCompanyCode(saleCompanyCode);
    }

    @Override
    public void updateStatus(List<Long> idList, String status) {
        ((INationalSupplementAreaRuleDomain)this.domain).updateStatus(idList, status);
    }

    public RestResponse<NationalSupplementAreaRuleDto> get(Long id) {
        NationalSupplementAreaRuleEo eo = (NationalSupplementAreaRuleEo)((INationalSupplementAreaRuleDomain)this.domain).selectByPrimaryKey(id);
        Assert.isTrue((eo != null ? 1 : 0) != 0, (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        NationalSupplementAreaRuleDto rule = (NationalSupplementAreaRuleDto)this.converter().toDto((BaseEo)eo);
        List<NationalSupplementAreaRuleAreaDto> ruleAreas = this.nationalSupplementAreaRuleAreaService.getDtoListByRuleId(id);
        rule.setAreaList(ruleAreas);
        rule.processBeforeReturn();
        return new RestResponse((Object)rule);
    }

    @Override
    public RestResponse<PageInfo<NationalSupplementAreaRuleDto>> page(NationalSupplementAreaRulePageReqDto dto) {
        PageInfo eoPage = PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize()).doSelectPageInfo(() -> ((INationalSupplementAreaRuleDomain)this.domain).queryList(dto));
        List<Long> ruleIds = eoPage.getList().stream().map(BaseEo::getId).collect(Collectors.toList());
        Map<Long, List<NationalSupplementAreaRuleAreaDto>> areaGroup = this.nationalSupplementAreaRuleAreaService.getDtoMapByRuleIds(ruleIds);
        PageInfo page = new PageInfo();
        page.setPageNum(eoPage.getPageNum());
        page.setPageSize(eoPage.getPageSize());
        page.setTotal(eoPage.getTotal());
        List rules = eoPage.getList().stream().map(eo -> {
            NationalSupplementAreaRuleDto r = (NationalSupplementAreaRuleDto)this.converter().toDto((BaseEo)eo);
            List areaList = areaGroup.getOrDefault(eo.getId(), Collections.emptyList());
            r.setAreaList(areaList);
            r.processBeforeReturn();
            return r;
        }).collect(Collectors.toList());
        page.setList(rules);
        page.calcByNavigatePages(8);
        return new RestResponse((Object)page);
    }

    @Override
    public void validateAndResetRelatedInfo(DgBizPerformOrderReqDto dto) {
        NationalSupplementValidateDto ns;
        if (!Objects.equals(dto.getSubsidiesType(), 1)) {
            log.info("\u975e\u56fd\u8865\u8ba2\u5355\uff0c\u65e0\u9700\u6821\u9a8c\u56fd\u8865\u533a\u57df\u914d\u7f6e\u548c\u5173\u8054\u4ea4\u6613\u4fe1\u606f: platformOrderNo={}, saleOrderNo={}", (Object)dto.getPlatformOrderNo(), (Object)dto.getSaleOrderNo());
            return;
        }
        String provinceName = Optional.ofNullable(dto.getOrderAddrReqDto()).map(DgPerformOrderAddrDto::getProvince).orElse(null);
        String cityName = Optional.ofNullable(dto.getOrderAddrReqDto()).map(DgPerformOrderAddrDto::getCity).orElse(null);
        String areaName = Optional.ofNullable(dto.getOrderAddrReqDto()).map(DgPerformOrderAddrDto::getCounty).orElse(null);
        if (Objects.equals(dto.getIsMultiArea(), 1)) {
            ns = this.validateByPlatformCompanyAndNameOrAlias(dto.getPlatformSellerEntityNumber(), provinceName, cityName, areaName);
        } else {
            String enterpriseCode = dto.getPerformOrderSnapshotDto().getEnterpriseCode();
            ns = this.validateBySaleCompanyCodeAndNameOrAlias(enterpriseCode, provinceName, cityName, areaName);
        }
        if (!ns.getSuccess().booleanValue()) {
            throw new BizException(ns.getErrorMsg());
        }
        if (Objects.equals(dto.getIsMultiArea(), 1)) {
            MatchRelatedTradeShopReqDto matchReq = MatchRelatedTradeShopReqDto.builder().orderNo(dto.getSaleOrderNo()).shopCode(dto.getPerformOrderSnapshotDto().getShopCode()).siteCode(dto.getPerformOrderSnapshotDto().getSiteCode()).subsidiesType(dto.getSubsidiesType()).isMultiArea(dto.getIsMultiArea()).platformNo(dto.getPlatformOrderNo()).platformSellerEntityNumber(dto.getPlatformSellerEntityNumber()).build();
            log.info("\u5339\u914d\u5173\u8054\u4ea4\u6613\u4fe1\u606f\u53c2\u6570\uff1a{}", (Object)JacksonUtil.toJson((Object)matchReq));
            RestResponse resp = this.relatedTradeShopKeepingApi.matchRelatedTradeShop(matchReq);
            log.info("\u5339\u914d\u5173\u8054\u4ea4\u6613\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)JacksonUtil.toJson((Object)resp));
            MatchRelatedTradeShopKeepDto matchResp = (MatchRelatedTradeShopKeepDto)RestResponseHelper.extractData((RestResponse)resp);
            if (matchResp == null || matchResp.getRelatedTradeMatchResult() == null || !matchResp.getRelatedTradeMatchResult().booleanValue()) {
                throw new BizException("\u5339\u914d\u5173\u8054\u4ea4\u6613\u4fe1\u606f\u5931\u8d25");
            }
            dto.setRelatedEntityNumber(matchResp.getRelatedEntityNumber());
            dto.setRelatedEntityName(matchResp.getRelatedEntityName());
        }
    }

    @Override
    public NationalSupplementValidateDto validateByPlatformCompanyAndNameOrAlias(String platformCompanyCode, String provinceName, String cityName, String areaName) {
        log.info("\u6839\u636e\u5e73\u53f0\u4e3b\u4f53\u7f16\u7801\u548c\u7701\u5e02\u533a\u540d\u79f0\u6821\u9a8c\u56fd\u8865\u533a\u57df\uff1aplatformCompanyCode={}, provinceName={}, cityName={}, areaName={}", new Object[]{platformCompanyCode, provinceName, cityName, areaName});
        List rules = ((INationalSupplementAreaRuleDomain)this.domain).getUsableByPlatformCompanyCode(platformCompanyCode);
        String[] path = this.matchAreaNameOrAlias(provinceName, cityName, areaName);
        NationalSupplementValidateDto ns = this.validateByRules(rules, path[0], path[1], path[2]);
        ns.setPlatformCompanyCode(platformCompanyCode);
        return ns;
    }

    @Override
    public NationalSupplementValidateDto validateByPlatformCompany(String platformCompanyCode, String provinceCode, String cityCode, String areaCode) {
        log.info("\u6839\u636e\u5e73\u53f0\u4e3b\u4f53\u7f16\u7801\u548c\u7701\u5e02\u533a\u7f16\u7801\u6821\u9a8c\u56fd\u8865\u533a\u57df\uff1aplatformCompanyCode={}, provinceCode={}, cityCode={}, areaCode={}", new Object[]{platformCompanyCode, provinceCode, cityCode, areaCode});
        List rules = ((INationalSupplementAreaRuleDomain)this.domain).getUsableByPlatformCompanyCode(platformCompanyCode);
        NationalSupplementValidateDto ns = this.validateByRules(rules, provinceCode, cityCode, areaCode);
        ns.setPlatformCompanyCode(platformCompanyCode);
        return ns;
    }

    @Override
    public NationalSupplementValidateDto validateBySaleCompanyCodeAndNameOrAlias(String saleCompanyCode, String provinceName, String cityName, String areaName) {
        log.info("\u6839\u636e\u5185\u90e8\u9500\u552e\u4e3b\u4f53\u7f16\u7801\u548c\u7701\u5e02\u533a\u540d\u79f0\u6821\u9a8c\u56fd\u8865\u533a\u57df\uff1asaleCompanyCode={}, provinceName={}, cityName={}, areaName={}", new Object[]{saleCompanyCode, provinceName, cityName, areaName});
        NationalSupplementAreaRuleEo rule = ((INationalSupplementAreaRuleDomain)this.domain).getUsableBySaleCompanyCode(saleCompanyCode);
        String[] path = this.matchAreaNameOrAlias(provinceName, cityName, areaName);
        ArrayList rules = rule == null ? Collections.emptyList() : Lists.newArrayList((Object[])new NationalSupplementAreaRuleEo[]{rule});
        return this.validateByRules(rules, path[0], path[1], path[2]);
    }

    @Override
    public NationalSupplementValidateDto validateBySaleCompanyCode(String saleCompanyCode, String provinceCode, String cityCode, String areaCode) {
        log.info("\u6839\u636e\u5185\u90e8\u9500\u552e\u4e3b\u4f53\u7f16\u7801\u548c\u7701\u5e02\u533a\u7f16\u7801\u6821\u9a8c\u56fd\u8865\u533a\u57df\uff1aplatformCompanyCode={}, provinceCode={}, cityCode={}, areaCode={}", new Object[]{saleCompanyCode, provinceCode, cityCode, areaCode});
        NationalSupplementAreaRuleEo rule = ((INationalSupplementAreaRuleDomain)this.domain).getUsableBySaleCompanyCode(saleCompanyCode);
        ArrayList rules = rule == null ? Collections.emptyList() : Lists.newArrayList((Object[])new NationalSupplementAreaRuleEo[]{rule});
        return this.validateByRules(rules, provinceCode, cityCode, areaCode);
    }

    @Override
    public List<NationalSupplementAreaRuleDto> queryDtoListBySaleCompanyCodes(List<String> saleCompanyCodes) {
        List eoList = ((INationalSupplementAreaRuleDomain)this.domain).queryBySaleCompanyCodes(saleCompanyCodes);
        return this.converter().toDtoList(eoList);
    }

    @Override
    public List<NationalSupplementAreaRuleDto> queryDtoListByPlatformCompanyCodes(List<String> platformCompanyCodes) {
        List eoList = ((INationalSupplementAreaRuleDomain)this.domain).getByPlatformCompanyCodes(platformCompanyCodes);
        return this.converter().toDtoList(eoList);
    }

    private String[] matchAreaNameOrAlias(String provinceName, String cityName, String areaName) {
        log.info("\u5f00\u59cb\u5339\u914d\u7701\u5e02\u533a\u540d\u79f0\uff1aprovinceName={}, cityName={}, areaName={}", new Object[]{provinceName, cityName, areaName});
        if (StrUtil.isBlank((CharSequence)provinceName)) {
            log.info("\u7701\u4efd\u540d\u79f0\u4e3a\u7a7a\uff0c\u65e0\u9700\u7ee7\u7eed\u5339\u914d");
            return new String[3];
        }
        AreaNameReqDto provinceReq = new AreaNameReqDto();
        provinceReq.setLevelId(Integer.valueOf(0));
        provinceReq.setName(provinceName);
        MatchByNameOrAliasReqDto req = new MatchByNameOrAliasReqDto();
        req.setProvinces((List)Lists.newArrayList((Object[])new AreaNameReqDto[]{provinceReq}));
        if (StrUtil.isNotBlank((CharSequence)cityName)) {
            AreaNameReqDto cityReq = new AreaNameReqDto();
            cityReq.setLevelId(Integer.valueOf(1));
            cityReq.setName(cityName);
            provinceReq.setChildren((List)Lists.newArrayList((Object[])new AreaNameReqDto[]{cityReq}));
            if (StrUtil.isNotBlank((CharSequence)areaName)) {
                AreaNameReqDto areaReq = new AreaNameReqDto();
                areaReq.setLevelId(Integer.valueOf(2));
                areaReq.setName(areaName);
                cityReq.setChildren((List)Lists.newArrayList((Object[])new AreaNameReqDto[]{areaReq}));
            }
        }
        log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JacksonUtil.toJson((Object)req));
        RestResponse resp = this.areaExtApi.matchByNameOrAlias(req);
        log.info("\u54cd\u5e94\u53c2\u6570\uff1a{}", (Object)JacksonUtil.toJson((Object)resp));
        AreaMatchRespDto match = (AreaMatchRespDto)RestResponseHelper.extractData((RestResponse)resp);
        if (match == null || match.getProvinces() == null || match.getProvinces().isEmpty()) {
            return new String[3];
        }
        AreaNodeDto province = (AreaNodeDto)match.getProvinces().get(0);
        AreaNodeDto city = CollectionUtils.isEmpty((Collection)province.getChildren()) ? null : (AreaNodeDto)province.getChildren().get(0);
        AreaNodeDto area = city == null || CollectionUtils.isEmpty((Collection)city.getChildren()) ? null : (AreaNodeDto)city.getChildren().get(0);
        String provinceCode = province.getCode();
        String cityCode = city == null ? null : city.getCode();
        String areaCode = area == null ? null : area.getCode();
        log.info("\u7701\u5e02\u533a\u540d\u79f0\u540d\u79f0\u5339\u914d\u7ed3\u679c\uff1a{}-{}, {}-{}, {}-{}", new Object[]{provinceName, provinceCode, cityName, cityCode, areaName, areaCode});
        return new String[]{provinceCode, cityCode, areaCode};
    }

    private NationalSupplementValidateDto validateByRules(List<NationalSupplementAreaRuleEo> rules, String provinceCode, String cityCode, String areaCode) {
        rules = Optional.ofNullable(rules).orElse(Collections.emptyList());
        Map<Long, NationalSupplementAreaRuleEo> ruleMap = rules.stream().collect(Collectors.toMap(BaseEo::getId, v -> v));
        List<Long> ruleIds = new ArrayList<Long>(ruleMap.keySet());
        log.info("\u51c6\u5907\u6821\u9a8c\u56fd\u8865\u533a\u57df\uff1a\u89c4\u5219ID={}, provinceCode={}, cityCode={}, areaCode={}", new Object[]{ruleIds, provinceCode, cityCode, areaCode});
        if (rules.isEmpty()) {
            return NationalSupplementValidateDto.buildError((String)"\u8be5\u5e97\u94fa\u672a\u914d\u7f6e\u533a\u57df\u89c4\u5219");
        }
        ruleIds = this.nationalSupplementAreaRuleAreaService.matchRules(rules, provinceCode, cityCode, areaCode);
        NationalSupplementAreaRuleEo eo = ruleIds.stream().map(ruleMap::get).max(Comparator.comparing(BaseEo::getUpdateTime)).orElse(null);
        log.info("\u5339\u914d\u5230\u7684\u56fd\u8865\u533a\u57df\u89c4\u5219\uff1a{}", (Object)(eo == null ? null : eo.getId()));
        if (eo == null) {
            return NationalSupplementValidateDto.buildError((String)"\u8be5\u8ba2\u5355\u533a\u57df\u89c4\u5219\u4e0d\u5339\u914d");
        }
        return NationalSupplementValidateDto.buildSuccess((String)eo.getSaleCompanyCode(), (String)eo.getSaleCompanyName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String makeCode() {
        String prefix = "GBXZ" + LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        Mutex lock = null;
        int numLength = 4;
        try {
            Long nextNum;
            lock = this.lockService.lock("national_supplement_area_rule_lock", prefix);
            String cacheKey = "national_supplement_area_rule_code:" + prefix;
            if (this.cacheService.exists(cacheKey)) {
                nextNum = this.cacheService.incr(cacheKey);
            } else {
                String maxCode = ((INationalSupplementAreaRuleDomain)this.domain).getMaxCodeByPrefix(prefix);
                nextNum = StrUtil.isBlank((CharSequence)maxCode) ? 1L : this.toNum(maxCode, prefix) + 1L;
                this.cacheService.setCache(cacheKey, (Object)nextNum);
            }
            if (nextNum > this.maxNum(numLength)) {
                throw new BizException("\u7f16\u7801\u8d85\u51fa\u957f\u5ea6");
            }
            String string = prefix + String.format("%0" + numLength + "d", nextNum);
            return string;
        }
        finally {
            if (lock != null) {
                this.lockService.unlock(lock);
            }
        }
    }

    private Long maxNum(int numLength) {
        return Long.parseLong(String.format("%0" + numLength + "d", 0).replace("0", "9"));
    }

    private Long toNum(String maxCode, String prefix) {
        return Long.parseLong(maxCode.substring(prefix.length()));
    }
}

