/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.b2b.Impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.IdGenrator;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCustomerQueryApiProxy;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderSourceEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountCategoryEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAttachmentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderWarehouseInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderLineReleationItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.oms.ContextDtoUtil;
import com.yunxi.dg.base.center.trade.dto.config.ShopAdjustmentWarehouseConfigReqDto;
import com.yunxi.dg.base.center.trade.dto.config.ShopAdjustmentWarehouseConfigRespDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderExtensionDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderPaymentDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderWarehouseInfoDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAttachmentEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderExtensionEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderPaymentEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderWarehouseInfoEo;
import com.yunxi.dg.base.center.trade.eo.OrderLineReleationItemLineEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.entity.IItemPayRecordService;
import com.yunxi.dg.base.center.trade.service.entity.IPayRecordService;
import com.yunxi.dg.base.center.trade.service.oms.b2b.IB2BOrderCreateService;
import com.yunxi.dg.base.center.trade.service.orderConfig.IShopAdjustmentWarehouseConfigService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.center.trade.utils.DgPerformOrderNoGreateUtil;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class B2BOrderCreateServiceImpl
implements IB2BOrderCreateService {
    private static final Logger log = LoggerFactory.getLogger(B2BOrderCreateServiceImpl.class);
    private static List<String> INDEMPOTENT_ORDERTYPE_CHECK = new ArrayList<String>();
    @Resource
    private ContextDtoUtil contextDtoUtil;
    @Resource
    private DgPerformOrderNoGreateUtil performOrderNoGreateUtil;
    @Resource
    private IDgCustomerQueryApiProxy dgCustomerQueryApiProxy;
    @Resource
    private IPayRecordService payRecordService;
    @Resource
    private IItemPayRecordService itemPayRecordService;
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private IShopAdjustmentWarehouseConfigService shopAdjustmentWarehouseConfigService;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoDomain performOrderWarehouseInfoDomain;
    @Resource
    private IDgPerformOrderExtensionDomain performOrderExtensionDomain;
    @Resource
    private IDgPerformOrderPaymentDomain performOrderPaymentDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain performOrderSnapshotDomain;
    @Resource
    private IDgPerformOrderAmountDomain performOrderAmountDomain;
    @Resource
    private IDgPerformOrderAddrDomain performOrderAddrDomain;
    @Resource
    private IDgPerformOrderAttachmentDomain performOrderAttachmentDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPerformOrderLineDomain performOrderLineDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain performOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain performOrderItemLineAmountDomain;
    @Resource
    private IOrderLineReleationItemLineDomain orderLineReleationItemLineDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DgPerformOrderRespDto synchronizationOrder(DgBizPerformOrderReqDto performOrderRespDto) {
        boolean checkPlatformOrder;
        log.info("\u6e20\u9053\u8ba2\u5355\u540c\u6b65\uff1a{}", (Object)JSON.toJSONString((Object)performOrderRespDto));
        boolean checkPromotionOrder = !DgSaleOrderSourceEnum.PROMOTION.getType().equals(performOrderRespDto.getOrderSource()) || this.checkPromotionOrderRepeat((DgPerformOrderInfoDto)performOrderRespDto);
        boolean bl = checkPlatformOrder = INDEMPOTENT_ORDERTYPE_CHECK.contains(performOrderRespDto.getOrderType()) || this.checkPlatformOrderRepeat((DgPerformOrderInfoDto)performOrderRespDto);
        if (checkPromotionOrder && checkPlatformOrder) {
            this.saveOrderData(performOrderRespDto);
        } else {
            log.error("\u8ba2\u5355\u540c\u6b65\u6821\u9a8c\u5931\u8d25 checkPromotionOrder\uff1a{} \uff0ccheckPlatformOrder:{}", (Object)checkPromotionOrder, (Object)checkPlatformOrder);
        }
        DgPerformOrderRespDto dto = (DgPerformOrderRespDto)BeanUtil.copyProperties((Object)performOrderRespDto, DgPerformOrderRespDto.class, (String[])new String[0]);
        return dto;
    }

    private void saveOrderData(DgBizPerformOrderReqDto performOrderReqDto) {
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        CubeBeanUtils.copyProperties((Object)performOrderInfoEo, (Object)performOrderReqDto, (String[])new String[]{"id", "createTime", "createPerson", "updateTime", "updatePerson"});
        performOrderInfoEo.setSaleOrderNo(this.performOrderNoGreateUtil.generateOrderNo());
        this.performOrderInfoDomain.insert((BaseEo)performOrderInfoEo);
        performOrderReqDto.setId(performOrderInfoEo.getId());
        performOrderReqDto.setSaleOrderNo(performOrderInfoEo.getSaleOrderNo());
        DgPerformOrderExtensionDto performOrderExtensionDto = performOrderReqDto.getPerformOrderExtensionDto();
        DgPerformOrderExtensionEo extensionEo = new DgPerformOrderExtensionEo();
        CubeBeanUtils.copyProperties((Object)extensionEo, (Object)performOrderExtensionDto, (String[])new String[]{"id", "createTime", "createPerson", "updateTime", "updatePerson"});
        extensionEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderExtensionDomain.insert((BaseEo)extensionEo);
        performOrderExtensionDto.setId(extensionEo.getId());
        DgPerformOrderSnapshotDto performOrderSnapshotDto = performOrderReqDto.getPerformOrderSnapshotDto();
        DgPerformOrderSnapshotEo snapshotEo = new DgPerformOrderSnapshotEo();
        CubeBeanUtils.copyProperties((Object)snapshotEo, (Object)performOrderSnapshotDto, (String[])new String[]{"id", "createTime", "createPerson", "updateTime", "updatePerson"});
        snapshotEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderSnapshotDomain.insert((BaseEo)snapshotEo);
        performOrderSnapshotDto.setId(snapshotEo.getId());
        DgPerformOrderAmountDto performOrderAmountDto = performOrderReqDto.getPerformOrderAmountDto();
        DgPerformOrderAmountEo amountEo = new DgPerformOrderAmountEo();
        CubeBeanUtils.copyProperties((Object)amountEo, (Object)performOrderAmountDto, (String[])new String[]{"id", "createTime", "createPerson", "updateTime", "updatePerson"});
        amountEo.setOrderNo(performOrderInfoEo.getSaleOrderNo());
        amountEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderAmountDomain.insert((BaseEo)amountEo);
        performOrderAmountDto.setId(amountEo.getId());
        DgPerformOrderPaymentDto performOrderPaymentDto = performOrderReqDto.getPerformOrderPaymentDto();
        DgPerformOrderPaymentEo paymentEo = new DgPerformOrderPaymentEo();
        CubeBeanUtils.copyProperties((Object)paymentEo, (Object)performOrderPaymentDto, (String[])new String[]{"id", "createTime", "createPerson", "updateTime", "updatePerson"});
        paymentEo.setOrderId(performOrderInfoEo.getId());
        paymentEo.setRemainingPayAmount(amountEo.getPayAmount());
        this.performOrderPaymentDomain.insert((BaseEo)paymentEo);
        performOrderPaymentDto.setId(paymentEo.getId());
        DgPerformOrderWarehouseInfoDto performOrderWarehouseInfoDto = performOrderReqDto.getPerformOrderWarehouseInfoDto();
        DgPerformOrderWarehouseInfoEo warehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
        CubeBeanUtils.copyProperties((Object)warehouseInfoEo, (Object)performOrderWarehouseInfoDto, (String[])new String[]{"id", "createTime", "createPerson", "updateTime", "updatePerson"});
        warehouseInfoEo.setOrderId(performOrderInfoEo.getId());
        this.defDeliverWarehouse(performOrderReqDto, warehouseInfoEo);
        this.performOrderWarehouseInfoDomain.insert((BaseEo)warehouseInfoEo);
        performOrderWarehouseInfoDto.setId(warehouseInfoEo.getId());
        DgPerformOrderAddrEo performOrderAddrEo = new DgPerformOrderAddrEo();
        CubeBeanUtils.copyProperties((Object)performOrderAddrEo, (Object)performOrderReqDto.getOrderAddrReqDto(), (String[])new String[]{"id"});
        performOrderAddrEo.setOrderId(performOrderReqDto.getId());
        performOrderAddrEo.setOrderNo(performOrderReqDto.getSaleOrderNo());
        this.performOrderAddrDomain.insert((BaseEo)performOrderAddrEo);
        List attachmentDtos = performOrderReqDto.getAttachmentFileList();
        if (CollectionUtils.isNotEmpty((Collection)attachmentDtos)) {
            List attachmentEos = attachmentDtos.stream().map(attachmentEo -> {
                DgPerformOrderAttachmentEo dgPerformOrderAttachmentEo = new DgPerformOrderAttachmentEo();
                CubeBeanUtils.copyProperties((Object)dgPerformOrderAttachmentEo, (Object)attachmentEo, (String[])new String[]{"id", "createTime", "createPerson", "updateTime", "updatePerson"});
                dgPerformOrderAttachmentEo.setOrderId(performOrderReqDto.getId());
                return dgPerformOrderAttachmentEo;
            }).collect(Collectors.toList());
            this.performOrderAttachmentDomain.insertBatch(attachmentEos);
        }
        HashMap newOrderLineMap = new HashMap();
        ArrayList newOrderLineList = new ArrayList();
        ArrayList newOrderLineAmountDtoList = new ArrayList();
        List orderLineDtoList = performOrderReqDto.getOrderLineDetails();
        log.info("\u540c\u6b65\u8ba2\u5355--\u8ba2\u5355\u884c\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)orderLineDtoList));
        orderLineDtoList.forEach(orderLineDto -> {
            Long orderLineId = IdGenrator.getDistributedId();
            DgPerformOrderLineEo newOrderLine = new DgPerformOrderLineEo();
            CubeBeanUtils.copyProperties((Object)newOrderLine, (Object)orderLineDto, (String[])new String[]{"id", "orderId", "orderNo", "createTime", "createPerson", "updateTime", "updatePerson"});
            newOrderLine.setId(orderLineId);
            newOrderLine.setOrderId(performOrderReqDto.getId());
            newOrderLine.setOrderNo(performOrderReqDto.getSaleOrderNo());
            newOrderLine.setPlatformOrderId(performOrderReqDto.getId());
            newOrderLine.setParentOrderNo(performOrderReqDto.getSaleOrderNo());
            newOrderLine.setPlatformOrderItemNo(orderLineDto.getId().toString());
            newOrderLine.setDeliveryItemBatchNo(orderLineDto.getBatchNo());
            newOrderLine.setLogicalWarehouseId(performOrderWarehouseInfoDto.getLogicalWarehouseId());
            newOrderLine.setLogicalWarehouseCode(performOrderWarehouseInfoDto.getLogicalWarehouseCode());
            newOrderLine.setLogicalWarehouseName(performOrderWarehouseInfoDto.getLogicalWarehouseName());
            newOrderLineList.add(newOrderLine);
            newOrderLineMap.put(orderLineDto.getId(), newOrderLine);
            orderLineDto.getAmountDtoList().forEach(orderLineAmount -> {
                DgPerformOrderLineAmountEo orderLineAmountEo = new DgPerformOrderLineAmountEo();
                CubeBeanUtils.copyProperties((Object)orderLineAmountEo, (Object)orderLineAmount, (String[])new String[]{"id", "orderId", "orderLineId", "createTime", "createPerson", "updateTime", "updatePerson"});
                orderLineAmountEo.setOrderId(performOrderReqDto.getId());
                orderLineAmountEo.setOrderLineId(orderLineId);
                if ((orderLineAmount.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode()) || orderLineAmount.getAmountSource().equals(DgOrderAmountSourceEnum.KNEAD.getCode())) && orderLineAmount.getAccountCategory().equals(DgOrderAmountCategoryEnum.OMS_F2B.getCode())) {
                    orderLineAmountEo.setAccountCategory(DgOrderAmountCategoryEnum.OMS_B2B.getCode());
                }
                newOrderLineAmountDtoList.add(orderLineAmountEo);
            });
        });
        ArrayList newItemOrderLineList = new ArrayList();
        ArrayList newItemOrderLineAmountDtoList = new ArrayList();
        ArrayList newOrderLineReleationItemLineList = new ArrayList();
        List orderItemLineDtoList = Optional.ofNullable(performOrderReqDto.getOrderItemLineDtoList()).orElse(Lists.newArrayList());
        orderItemLineDtoList.forEach(itemLineDto -> {
            DgPerformOrderLineEo newOrderLine = (DgPerformOrderLineEo)newOrderLineMap.get(itemLineDto.getOrderLineId());
            if (null != newOrderLine) {
                Long orderItemLineId = IdGenrator.getDistributedId();
                DgPerformOrderItemLineEo itemLine = new DgPerformOrderItemLineEo();
                CubeBeanUtils.copyProperties((Object)itemLine, (Object)itemLineDto, (String[])new String[]{"id", "orderId", "orderNo", "orderLineId", "createTime", "createPerson", "updateTime", "updatePerson"});
                itemLine.setId(orderItemLineId);
                itemLine.setOrderId(performOrderReqDto.getId());
                itemLine.setOrderNo(performOrderReqDto.getSaleOrderNo());
                itemLine.setPlatformOrderItemNo(itemLineDto.getId().toString());
                itemLine.setOrderLineId(newOrderLine.getId());
                newItemOrderLineList.add(itemLine);
                OrderLineReleationItemLineEo releationItemLineEo = new OrderLineReleationItemLineEo();
                releationItemLineEo.setOrderLineId(newOrderLine.getId());
                releationItemLineEo.setOrderItemLineId(orderItemLineId);
                newOrderLineReleationItemLineList.add(releationItemLineEo);
                List orderItemLineAmountDtos = itemLineDto.getPerformOrderItemLineAmountDtoList();
                if (CollectionUtil.isNotEmpty((Collection)orderItemLineAmountDtos)) {
                    orderItemLineAmountDtos.forEach(orderItemLineAmount -> {
                        DgPerformOrderItemLineAmountEo orderItemLineAmountEo = new DgPerformOrderItemLineAmountEo();
                        CubeBeanUtils.copyProperties((Object)orderItemLineAmountEo, (Object)orderItemLineAmount, (String[])new String[]{"id", "orderId", "orderItemLineId"});
                        orderItemLineAmountEo.setOrderId(performOrderReqDto.getId());
                        orderItemLineAmountEo.setOrderItemLineId(orderItemLineId);
                        if ((orderItemLineAmount.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_ITEM_BASE.getCode()) || orderItemLineAmount.getAmountSource().equals(DgOrderAmountSourceEnum.KNEAD.getCode())) && orderItemLineAmount.getAccountCategory().equals(DgOrderAmountCategoryEnum.OMS_F2B.getCode())) {
                            orderItemLineAmountEo.setAccountCategory(DgOrderAmountCategoryEnum.OMS_B2B.getCode());
                        }
                        newItemOrderLineAmountDtoList.add(orderItemLineAmountEo);
                    });
                }
            } else {
                log.error("\u540c\u6b65\u8ba2\u5355--\u5546\u54c1\u884c\u4e0d\u5b58\u5728\uff1a{}", (Object)itemLineDto.getOrderLineId());
            }
        });
        this.performOrderLineDomain.insertBatch(newOrderLineList);
        this.performOrderLineAmountDomain.insertBatch(newOrderLineAmountDtoList);
        this.performOrderItemLineDomain.insertBatch(newItemOrderLineList);
        this.performOrderItemLineAmountDomain.insertBatch(newItemOrderLineAmountDtoList);
        this.orderLineReleationItemLineDomain.insertBatch(newOrderLineReleationItemLineList);
    }

    private boolean checkPlatformOrderRepeat(DgPerformOrderInfoDto addReqDto) {
        if (StringUtils.isNotBlank((CharSequence)addReqDto.getSaleOrderNo())) {
            LambdaQueryWrapper queryPlatformWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryPlatformWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderInfoEo::getPlatformOrderNo, (Object)addReqDto.getSaleOrderNo());
            List list = this.performOrderInfoDomain.getMapper().selectList((Wrapper)queryPlatformWrapper);
            List saleOrderEos = Optional.ofNullable(list).orElseGet(Collections::emptyList).stream().filter(saleOrderEo -> !DgSaleOrderStatusEnum.OBSOLETE.getCode().equals(saleOrderEo.getOrderStatus())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(saleOrderEos)) {
                log.error("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u8be5\u5e73\u53f0\u8ba2\u5355\uff08{}\uff09\u5df2\u751f\u6210\u5bf9\u5e94\u7684\u9500\u552e\u8ba2\u5355\uff08{}\uff09\uff0c\u4e0d\u53ef\u591a\u6b21\u751f\u6210\u9500\u552e\u5355", (Object)addReqDto.getPlatformOrderNo(), (Object)((DgPerformOrderInfoEo)saleOrderEos.get(0)).getSaleOrderNo());
                throw DgPcpTradeExceptionCode.MUTIL_SALE_ORDER_EXCEPTION.builderException();
            }
            return true;
        }
        return true;
    }

    private boolean checkPromotionOrderRepeat(DgPerformOrderInfoDto addReqDto) {
        if (StringUtils.isNotBlank((CharSequence)addReqDto.getSaleOrderNo())) {
            LambdaQueryWrapper queryPlatformWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryPlatformWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderInfoEo::getPlatformOrderNo, (Object)addReqDto.getSaleOrderNo());
            List list = this.performOrderInfoDomain.getMapper().selectList((Wrapper)queryPlatformWrapper);
            boolean match = Optional.ofNullable(list).orElseGet(Collections::emptyList).stream().anyMatch(e -> DgSaleOrderSourceEnum.PROMOTION.getType().equals(e.getOrderSource()));
            AssertUtils.isTrue((!match ? 1 : 0) != 0, (String)"\u5f53\u524d\u5e73\u53f0\u8ba2\u5355\u5df2\u5b58\u5728\u5bf9\u5e94\u7684\u5185\u90e8\u4fc3\u9500\u8ba2\u5355\u4e86");
            return true;
        }
        return true;
    }

    private void defDeliverWarehouse(DgBizPerformOrderReqDto performOrderReqDto, DgPerformOrderWarehouseInfoEo warehouseInfoEo) {
        log.info("\u9ed8\u8ba4\u6307\u5b9a\u53d1\u8d27\u4ed3\uff1a{}", (Object)performOrderReqDto.getSaleOrderNo());
        if (performOrderReqDto.getOrderType().equals(DgSaleOrderTypeEnum.ACCOUNT_REGULATION_ORDER.getType()) && ObjectUtil.isNotEmpty((Object)performOrderReqDto) && StringUtils.isNotBlank((CharSequence)performOrderReqDto.getPerformOrderSnapshotDto().getShopCode())) {
            ShopAdjustmentWarehouseConfigReqDto reqDto = new ShopAdjustmentWarehouseConfigReqDto();
            reqDto.setShopCode(performOrderReqDto.getPerformOrderSnapshotDto().getShopCode());
            ShopAdjustmentWarehouseConfigRespDto configRespDto = this.shopAdjustmentWarehouseConfigService.queryByOne(reqDto);
            if (ObjectUtil.isNotEmpty((Object)configRespDto)) {
                warehouseInfoEo.setLogicalWarehouseId(configRespDto.getWarehouseId());
                warehouseInfoEo.setLogicalWarehouseCode(configRespDto.getWarehouseCode());
                warehouseInfoEo.setLogicalWarehouseName(configRespDto.getWarehouseName());
                warehouseInfoEo.setDeliveryLogicalWarehouseCode(configRespDto.getWarehouseCode());
            }
        }
    }

    @Override
    public Boolean preemptChannelInventory(Long orderId) {
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)performOrderRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        List performOrderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(orderId);
        return this.inventoryApiServcie.preemptChannelInventoryV2(performOrderLineDtos, performOrderRespDto);
    }

    static {
        INDEMPOTENT_ORDERTYPE_CHECK.add(DgSaleOrderTypeEnum.REPLENISH_ORDER.getType());
        INDEMPOTENT_ORDERTYPE_CHECK.add(DgSaleOrderTypeEnum.EXCHANGE_ORDER.getType());
    }
}

