/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.b2c.Impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordChangeRespDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordLinkPageReqDto;
import com.yunxi.dg.base.center.report.proxy.tag.IReBizTagRecordApiProxy;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgLabelStrategyEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyLabelTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderAddrExtDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderLabelStrategyQueryDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgLabelStrategyRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyRuleRespDto;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleEo;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsLabelStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.impl.DgStrategyRuleServiceImpl;
import com.yunxi.dg.base.center.trade.service.orderStrategy.impl.IDgLabelStrategyRuleServiceImpl;
import com.yunxi.dg.base.center.trade.vo.DgLabelStrategyAdaptVo;
import com.yunxi.dg.base.center.trade.vo.DgLabelStrategyConfItemRangeVo;
import com.yunxi.dg.base.center.trade.vo.DgLabelStrategyConfItemSwitchVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DgOmsLabelStrategyRuleServiceImpl
extends DgStrategyRuleServiceImpl
implements IDgOmsLabelStrategyRuleService {
    private static Logger logger = LoggerFactory.getLogger(DgOmsLabelStrategyRuleServiceImpl.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private IReBizTagRecordApiProxy iReBizTagRecordApiProxy;
    @Resource
    private IDgPerformOrderAddrExtDomain dgSaleOrderAddrDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgStrategyRuleDomain strategyRuleDomain;

    @Override
    public ReBizTagRecordChangeRespDto queryByParam(DgPerformOrderRespDto dgPerformOrderRespDto) {
        logger.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)dgPerformOrderRespDto));
        DgPerformOrderLabelStrategyQueryDto dgPerformOrderLabelStrategyQueryDto = new DgPerformOrderLabelStrategyQueryDto();
        CubeBeanUtils.copyProperties((Object)dgPerformOrderLabelStrategyQueryDto, (Object)dgPerformOrderRespDto, (String[])new String[0]);
        Long id = dgPerformOrderRespDto.getId();
        List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(id);
        DgPerformOrderAddrDto dgPerformOrderAddrDto = this.dgSaleOrderAddrDomain.queryAddressByOrderId(id);
        dgPerformOrderLabelStrategyQueryDto.setOrderLineDtos(orderLineDtos);
        dgPerformOrderLabelStrategyQueryDto.setOrderAddrReqDto(dgPerformOrderAddrDto);
        ReBizTagRecordChangeRespDto reBizTagRecordChangeRespDto = this.getReBizTagRecordChangeRespDto(dgPerformOrderRespDto, dgPerformOrderLabelStrategyQueryDto);
        return reBizTagRecordChangeRespDto;
    }

    private ReBizTagRecordChangeRespDto getReBizTagRecordChangeRespDto(DgPerformOrderRespDto dgPerformOrderRespDto, DgPerformOrderLabelStrategyQueryDto dgPerformOrderLabelStrategyQueryDto) {
        ArrayList specialListAdapt = new ArrayList();
        String platform = DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode().equals(dgPerformOrderRespDto.getBizModel()) ? "2c" : "2b";
        String spacialAdaptStrategy = (String)this.cacheService.getCache("SpacialAdaptStrategy", String.class);
        logger.info("\u8f6c\u6362\u6570\u636e\u7b56\u7565\uff1a{}", (Object)spacialAdaptStrategy);
        if (StringUtils.isBlank((CharSequence)spacialAdaptStrategy)) {
            logger.info("\u67e5\u8be2\u4e0d\u5230\u6807\u7b7e\u7b56\u7565");
            return new ReBizTagRecordChangeRespDto();
        }
        Map mapObj = (Map)JSONObject.parseObject((String)spacialAdaptStrategy, Map.class);
        HashMap<Long, DgStrategyRuleRespDto> transformedAdaptStrategy = new HashMap<Long, DgStrategyRuleRespDto>();
        if (mapObj.isEmpty()) {
            logger.info("\u67e5\u4e0d\u5230\u6807\u7b7e\u6d4b\u8bd5");
            return new ReBizTagRecordChangeRespDto();
        }
        Set longs = mapObj.keySet();
        for (Long aLong : longs) {
            JSONObject jsonObject = (JSONObject)mapObj.get(aLong);
            DgStrategyRuleRespDto javaObject = (DgStrategyRuleRespDto)jsonObject.toJavaObject(DgStrategyRuleRespDto.class);
            if (!javaObject.getPlatForm().equals(platform)) continue;
            transformedAdaptStrategy.put(aLong, javaObject);
        }
        String spacialAdapt = (String)this.cacheService.getCache("SpacialAdapt", String.class);
        logger.info("\u8f6c\u6362\u6570\u636e\uff1a{}", (Object)spacialAdapt);
        Map mapObj1 = (Map)JSONObject.parseObject((String)spacialAdapt, Map.class);
        HashMap<Long, DgLabelStrategyAdaptVo> transformedSpecialAdapt = new HashMap<Long, DgLabelStrategyAdaptVo>();
        Set longs1 = transformedAdaptStrategy.keySet();
        for (Long aLong : longs1) {
            JSONObject jsonObject = (JSONObject)mapObj1.get(aLong);
            DgLabelStrategyAdaptVo javaObject = (DgLabelStrategyAdaptVo)jsonObject.toJavaObject(DgLabelStrategyAdaptVo.class);
            transformedSpecialAdapt.put(aLong, javaObject);
        }
        if (transformedSpecialAdapt.isEmpty()) {
            logger.info("\u6ca1\u6709\u5339\u914d\u5230\u6807\u7b7e\u7b56\u7565");
            return new ReBizTagRecordChangeRespDto();
        }
        transformedSpecialAdapt.forEach((k, v) -> {
            switch (DgLabelStrategyEnum.getEnumByCode((String)v.getAdaptTypeString())) {
                case ADAPT_LIST: {
                    List<Long> list = this.adaptLabelStategyListResult((Long)k, (DgLabelStrategyAdaptVo)v, dgPerformOrderLabelStrategyQueryDto);
                    specialListAdapt.addAll(list);
                    break;
                }
                case ADAPT_RANGE: {
                    List<Long> rangeCList = this.adaptLabelStategyRange((Long)k, (DgLabelStrategyAdaptVo)v, dgPerformOrderLabelStrategyQueryDto);
                    if (v.getAdaptType() == DgLabelStrategyEnum.TWO.getNum().intValue()) {
                        List<Long> remarkBList = this.adaptLabelStategyRemark((Long)k, (DgLabelStrategyAdaptVo)v, dgPerformOrderLabelStrategyQueryDto);
                        DgOmsLabelStrategyRuleServiceImpl.extractedIntersect(specialListAdapt, rangeCList, remarkBList);
                        break;
                    }
                    specialListAdapt.addAll(rangeCList);
                    break;
                }
                case ADAPT_REMARKS: {
                    List<Long> remarkBList = this.adaptLabelStategyRemark((Long)k, (DgLabelStrategyAdaptVo)v, dgPerformOrderLabelStrategyQueryDto);
                    if (!CollectionUtils.isNotEmpty(remarkBList)) break;
                    specialListAdapt.addAll(remarkBList);
                    break;
                }
            }
        });
        ReBizTagRecordChangeRespDto reBizTagRecordChangeRespDto = new ReBizTagRecordChangeRespDto();
        if (CollectionUtils.isNotEmpty(specialListAdapt)) {
            List dgStrategyRuleEos = this.strategyRuleDomain.selectByIds(specialListAdapt);
            ArrayList dgStrategyRuleRespDtos = new ArrayList();
            CubeBeanUtils.copyCollection(dgStrategyRuleRespDtos, (Collection)dgStrategyRuleEos, DgStrategyRuleRespDto.class);
            ReBizTagRecordLinkPageReqDto reBizTagRecordLinkPageReqDto = new ReBizTagRecordLinkPageReqDto();
            reBizTagRecordLinkPageReqDto.setRecordLinkId(dgPerformOrderRespDto.getId());
            List collectLabelCode = dgStrategyRuleEos.stream().map(DgStrategyRuleEo::getLabelCode).distinct().collect(Collectors.toList());
            reBizTagRecordLinkPageReqDto.setRecordChangeCode(collectLabelCode);
            reBizTagRecordLinkPageReqDto.setRecordSourceModel("LABEL_STRATEGY");
            logger.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)reBizTagRecordLinkPageReqDto));
            reBizTagRecordChangeRespDto = (ReBizTagRecordChangeRespDto)this.iReBizTagRecordApiProxy.recordExchange(reBizTagRecordLinkPageReqDto).getData();
        }
        return reBizTagRecordChangeRespDto;
    }

    private List<Long> adaptLabelStategyListResult(Long k, DgLabelStrategyAdaptVo v, DgPerformOrderLabelStrategyQueryDto dgPerformOrderLabelStrategyQueryDto) {
        ArrayList<Long> adaptId = new ArrayList<Long>();
        switch (DgLabelStrategyEnum.getEnumByNum((Integer)v.getAdaptType())) {
            case ONE: {
                List<Long> list1 = this.adaptLabelStategyList(k, v, dgPerformOrderLabelStrategyQueryDto);
                adaptId.addAll(list1);
                break;
            }
            case TWO: {
                List<Long> list2 = this.adaptLabelStategyList(k, v, dgPerformOrderLabelStrategyQueryDto);
                if (v.getAdaptTypeSubString().equals("remark")) {
                    List<Long> remarkList = this.adaptLabelStategyRemark(k, v, dgPerformOrderLabelStrategyQueryDto);
                    DgOmsLabelStrategyRuleServiceImpl.extractedIntersect(adaptId, list2, remarkList);
                    break;
                }
                if (!v.getAdaptTypeSubString().equals("range")) break;
                List<Long> rangeList = this.adaptLabelStategyRange(k, v, dgPerformOrderLabelStrategyQueryDto);
                DgOmsLabelStrategyRuleServiceImpl.extractedIntersect(adaptId, list2, rangeList);
                break;
            }
            case THREE: {
                List<Long> list3 = this.adaptLabelStategyList(k, v, dgPerformOrderLabelStrategyQueryDto);
                List<Long> remarkList = this.adaptLabelStategyRemark(k, v, dgPerformOrderLabelStrategyQueryDto);
                List<Long> rangeList = this.adaptLabelStategyRange(k, v, dgPerformOrderLabelStrategyQueryDto);
                list3.retainAll(remarkList);
                list3.retainAll(rangeList);
                if (!CollectionUtils.isNotEmpty(list3)) break;
                adaptId.addAll(list3);
            }
        }
        return adaptId;
    }

    private List<Long> adaptLabelStategyRange(Long k, DgLabelStrategyAdaptVo v, DgPerformOrderLabelStrategyQueryDto dgPerformOrderLabelStrategyQueryDto) {
        Object collect;
        List dgLabelStrategyConfItemRangeVos = v.getDgLabelStrategyConfItemRangeVos();
        ArrayList<Long> adaptRangeLongs = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)dgLabelStrategyConfItemRangeVos)) {
            collect = dgLabelStrategyConfItemRangeVos.stream().collect(Collectors.toMap(e -> e.getStrategyType(), Function.identity()));
            Set<String> strings = collect.keySet();
            for (String string : strings) {
                DgLabelStrategyConfItemRangeVo dgLabelStrategyConfItemRangeVo = (DgLabelStrategyConfItemRangeVo)collect.get(string);
                switch (DgStrategyLabelTypeEnum.forCode((String)string)) {
                    case SPECIAL_CREATE_TIME: {
                        Date createTime = dgPerformOrderLabelStrategyQueryDto.getCreateTime();
                        DgOmsLabelStrategyRuleServiceImpl.extractedTime(dgLabelStrategyConfItemRangeVo, createTime, adaptRangeLongs, k);
                        break;
                    }
                    case SPECIAL_PAYTIME: {
                        Date payTime = dgPerformOrderLabelStrategyQueryDto.getPerformOrderPaymentDto().getPayTime();
                        DgOmsLabelStrategyRuleServiceImpl.extractedTime(dgLabelStrategyConfItemRangeVo, payTime, adaptRangeLongs, k);
                        break;
                    }
                    case SPECIAL_WEIGHT: {
                        List orderLineDtos = dgPerformOrderLabelStrategyQueryDto.getOrderLineDtos();
                        BigDecimal weight = orderLineDtos.stream().map(DgPerformOrderLineDto::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                        DgOmsLabelStrategyRuleServiceImpl.extractedRange(dgLabelStrategyConfItemRangeVo, weight, adaptRangeLongs, k);
                        break;
                    }
                    case SPECIAL_VOLUME: {
                        List itemVolumeList = dgPerformOrderLabelStrategyQueryDto.getOrderLineDtos();
                        BigDecimal volume = itemVolumeList.stream().map(DgPerformOrderLineDto::getVolume).reduce(BigDecimal.ZERO, BigDecimal::add);
                        DgOmsLabelStrategyRuleServiceImpl.extractedRange(dgLabelStrategyConfItemRangeVo, volume, adaptRangeLongs, k);
                        break;
                    }
                    case SPECIAL_NUM: {
                        List bigDecimals = dgPerformOrderLabelStrategyQueryDto.getOrderLineDtos().stream().map(DgPerformOrderLineDto::getItemNum).collect(Collectors.toList());
                        BigDecimal sum = bigDecimals.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                        DgOmsLabelStrategyRuleServiceImpl.extractedRange(dgLabelStrategyConfItemRangeVo, sum, adaptRangeLongs, k);
                        break;
                    }
                    case SPECIAL_AMOUNT_RANGE: {
                        List itemTypeList = dgPerformOrderLabelStrategyQueryDto.getOrderLineDtos();
                        int size1 = itemTypeList.stream().map(DgPerformOrderLineDto::getItemCode).distinct().collect(Collectors.toList()).size();
                        DgOmsLabelStrategyRuleServiceImpl.extractedRange(dgLabelStrategyConfItemRangeVo, new BigDecimal(size1), adaptRangeLongs, k);
                        break;
                    }
                    case SPECIAL_PAY_AMOUNT: {
                        BigDecimal orderTotalAmount = dgPerformOrderLabelStrategyQueryDto.getPayAmount();
                        DgOmsLabelStrategyRuleServiceImpl.extractedRange(dgLabelStrategyConfItemRangeVo, orderTotalAmount, adaptRangeLongs, k);
                        break;
                    }
                    case SPECIAL_PAY_REAL_AMOUNT: {
                        BigDecimal payAmount = dgPerformOrderLabelStrategyQueryDto.getRealPayAmount();
                        DgOmsLabelStrategyRuleServiceImpl.extractedRange(dgLabelStrategyConfItemRangeVo, payAmount, adaptRangeLongs, k);
                        break;
                    }
                    case SPECIAL_TOTAL_AMOUNT: {
                        BigDecimal goodsTotalAmount = dgPerformOrderLabelStrategyQueryDto.getGoodsTotalAmount();
                        DgOmsLabelStrategyRuleServiceImpl.extractedRange(dgLabelStrategyConfItemRangeVo, goodsTotalAmount, adaptRangeLongs, k);
                        break;
                    }
                    case SPECIAL_FREIGHT: {
                        BigDecimal freightCost = dgPerformOrderLabelStrategyQueryDto.getFreightCost();
                        DgOmsLabelStrategyRuleServiceImpl.extractedRange(dgLabelStrategyConfItemRangeVo, freightCost, adaptRangeLongs, k);
                    }
                }
            }
        }
        if (CollectionUtils.isEmpty(adaptRangeLongs)) {
            return new ArrayList<Long>();
        }
        collect = adaptRangeLongs.stream().distinct().collect(Collectors.toList());
        return collect;
    }

    private static void extractedTime(DgLabelStrategyConfItemRangeVo dgLabelStrategyConfItemRangeVo, Date time, ArrayList<Long> specialListAdapt, Long k) {
        DgLabelStrategyRuleReqDto.SpecialTimeRange specialTimeRange = (DgLabelStrategyRuleReqDto.SpecialTimeRange)JSON.parseObject((String)dgLabelStrategyConfItemRangeVo.getContent(), DgLabelStrategyRuleReqDto.SpecialTimeRange.class);
        Date startTime = specialTimeRange.getStartTime();
        Date endTime = specialTimeRange.getEndTime();
        if (time.after(startTime) && time.before(endTime)) {
            System.out.println("Time\u5728\u65f6\u95f4\u8303\u56f4\u5185");
            specialListAdapt.add(k);
        } else {
            specialListAdapt.clear();
        }
    }

    private static void extractedRange(DgLabelStrategyConfItemRangeVo dgLabelStrategyConfItemRangeVo, BigDecimal compare, ArrayList<Long> specialListAdapt, Long k) {
        DgLabelStrategyRuleReqDto.SpecialAmountRange specialAmountRange = (DgLabelStrategyRuleReqDto.SpecialAmountRange)JSON.parseObject((String)dgLabelStrategyConfItemRangeVo.getContent(), DgLabelStrategyRuleReqDto.SpecialAmountRange.class);
        BigDecimal minAmount = specialAmountRange.getMinAmount();
        BigDecimal maxAmount = specialAmountRange.getMaxAmount();
        int lowerComparison = compare.compareTo(minAmount);
        int upperComparison = compare.compareTo(maxAmount);
        if (lowerComparison >= 0 && upperComparison <= 0) {
            System.out.println("compare\u5728\u8303\u56f4\u5185");
            specialListAdapt.add(k);
        } else {
            specialListAdapt.clear();
        }
    }

    private List<Long> adaptLabelStategyRemark(Long k, DgLabelStrategyAdaptVo v, DgPerformOrderLabelStrategyQueryDto dgPerformOrderLabelStrategyQueryDto) {
        ArrayList<Long> remakeApdateId = new ArrayList<Long>();
        String buyerRemark = Optional.ofNullable(dgPerformOrderLabelStrategyQueryDto.getBuyerRemark()).orElse("");
        String sellerRemark = Optional.ofNullable(dgPerformOrderLabelStrategyQueryDto.getSellerRemark()).orElse("");
        String remark = Optional.ofNullable(dgPerformOrderLabelStrategyQueryDto.getRemark()).orElse("");
        String receiveAddress = Optional.ofNullable(dgPerformOrderLabelStrategyQueryDto.getOrderAddrReqDto().getReceiveAddress()).orElse("");
        String adaptString = v.getAdaptString();
        try {
            DgLabelStrategyConfItemSwitchVo dgLabelStrategyConfItemSwitchVo = v.getDgLabelStrategyConfItemSwitchVo();
            ObjectMapper objectMapper = new ObjectMapper();
            HashMap memoTextMatching = (HashMap)objectMapper.readValue(adaptString, HashMap.class);
            Set adaptCode = memoTextMatching.keySet();
            for (String s : adaptCode) {
                switch (DgStrategyLabelTypeEnum.forCode((String)s)) {
                    case SPECIAL_REMARK: {
                        String remarkType = dgLabelStrategyConfItemSwitchVo.getRemarkType();
                        DgOmsLabelStrategyRuleServiceImpl.extractedRemark(k, remakeApdateId, remark, remarkType, (String)memoTextMatching.get(s));
                        break;
                    }
                    case SPECIAL_SELLER: {
                        String remarkBuyerType = dgLabelStrategyConfItemSwitchVo.getRemarkSellerType();
                        DgOmsLabelStrategyRuleServiceImpl.extractedRemark(k, remakeApdateId, sellerRemark, remarkBuyerType, (String)memoTextMatching.get(s));
                        break;
                    }
                    case SPECIAL_BUYER: {
                        String remarkSellerType = dgLabelStrategyConfItemSwitchVo.getRemarkBuyerType();
                        DgOmsLabelStrategyRuleServiceImpl.extractedRemark(k, remakeApdateId, buyerRemark, remarkSellerType, (String)memoTextMatching.get(s));
                        break;
                    }
                    case SPECIAL_AREA_DETAIL: {
                        String s1 = (String)memoTextMatching.get(s);
                        List<String> receiveAddressString = Arrays.asList(s1.split(","));
                        boolean action = true;
                        for (String s2 : receiveAddressString) {
                            if (!receiveAddress.contains(s2)) continue;
                            remakeApdateId.add(k);
                            action = false;
                            break;
                        }
                        if (!action) break;
                        remakeApdateId.clear();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (CollectionUtils.isNotEmpty(remakeApdateId)) {
            return remakeApdateId.stream().distinct().collect(Collectors.toList());
        }
        return remakeApdateId;
    }

    private static void extractedRemark(Long k, ArrayList<Long> remakeApdateId, String remark, String remarkType, String s2) {
        List<String> receiveAddressString = Arrays.asList(s2.split(","));
        boolean action = true;
        for (String adapt : receiveAddressString) {
            if (remarkType.equals("0") && StringUtils.isNotBlank((CharSequence)remark)) {
                remakeApdateId.add(k);
                action = false;
                break;
            }
            if (!remarkType.equals("1") || !remark.contains(adapt)) continue;
            remakeApdateId.add(k);
            action = false;
            break;
        }
        if (action) {
            remakeApdateId.clear();
        }
    }

    private List<Long> adaptLabelStategyList(Long id, DgLabelStrategyAdaptVo v, DgPerformOrderLabelStrategyQueryDto dgPerformOrderLabelStrategyQueryDto) {
        ArrayList<Long> listAdaptElement = new ArrayList<Long>();
        List adaptList = v.getAdaptList();
        List adaptTypeList = v.getAdaptTypeList();
        ArrayList adaptationArrayList = new ArrayList();
        List orderLineDtos = dgPerformOrderLabelStrategyQueryDto.getOrderLineDtos();
        if (CollectionUtils.isNotEmpty((Collection)adaptTypeList)) {
            adaptTypeList.forEach(e -> {
                switch (DgStrategyLabelTypeEnum.forCode((String)e)) {
                    case SPECIAL_SKUS: {
                        DgOmsLabelStrategyRuleServiceImpl.extractedAdaptItemCode(id, v, listAdaptElement, adaptList, adaptationArrayList, orderLineDtos);
                        break;
                    }
                    case SPECIAL_ORDER_TYPE: {
                        DgOmsLabelStrategyRuleServiceImpl.extractedOrderType(id, dgPerformOrderLabelStrategyQueryDto, listAdaptElement, adaptList);
                        break;
                    }
                    case SPECIAL_AREA: {
                        DgOmsLabelStrategyRuleServiceImpl.extractedArea(id, dgPerformOrderLabelStrategyQueryDto, listAdaptElement, adaptList);
                        break;
                    }
                    case SPECIAL_SHOP: {
                        DgOmsLabelStrategyRuleServiceImpl.extractedAdaptShop(id, dgPerformOrderLabelStrategyQueryDto, listAdaptElement, adaptList);
                        break;
                    }
                }
            });
        }
        return listAdaptElement;
    }

    private static void extractedAdaptItemCode(Long id, DgLabelStrategyAdaptVo v, ArrayList<Long> listAdaptElement, List<String> adaptList, ArrayList<String> adaptationArrayList, List<DgPerformOrderLineDto> orderLineDtos) {
        block2: {
            List<Object> itemCodes;
            block3: {
                DgLabelStrategyConfItemSwitchVo dgLabelStrategyConfItemSwitchVo;
                itemCodes = new ArrayList();
                if (CollectionUtils.isNotEmpty(orderLineDtos)) {
                    itemCodes = orderLineDtos.stream().map(DgPerformOrderLineDto::getSkuCode).collect(Collectors.toList());
                    adaptationArrayList.addAll(itemCodes);
                }
                if (!CollectionUtils.isNotEmpty(itemCodes) || Objects.isNull(dgLabelStrategyConfItemSwitchVo = v.getDgLabelStrategyConfItemSwitchVo())) break block2;
                String matchingRules = dgLabelStrategyConfItemSwitchVo.getMatchingRules();
                if (!matchingRules.equals("0")) break block3;
                if (!IDgLabelStrategyRuleServiceImpl.areListsEqual(adaptList, itemCodes)) break block2;
                listAdaptElement.add(id);
                break block2;
            }
            for (String string : itemCodes) {
                if (!adaptList.contains(string)) continue;
                listAdaptElement.add(id);
                break;
            }
        }
    }

    private static void extractedOrderType(Long id, DgPerformOrderLabelStrategyQueryDto dgPerformOrderLabelStrategyQueryDto, ArrayList<Long> listAdaptElement, List<String> adaptList) {
        String orderType = dgPerformOrderLabelStrategyQueryDto.getOrderType();
        if (StringUtils.isNotEmpty((CharSequence)orderType)) {
            if (adaptList.contains(orderType)) {
                listAdaptElement.add(id);
            } else {
                listAdaptElement.clear();
            }
        }
    }

    private static void extractedArea(Long id, DgPerformOrderLabelStrategyQueryDto dgPerformOrderLabelStrategyQueryDto, ArrayList<Long> listAdaptElement, List<String> adaptList) {
        DgPerformOrderAddrDto orderAddrReqDto = dgPerformOrderLabelStrategyQueryDto.getOrderAddrReqDto();
        String provinceCode = orderAddrReqDto.getProvinceCode();
        String cityCode = orderAddrReqDto.getCityCode();
        String countyCode = orderAddrReqDto.getCountyCode();
        if (adaptList.contains(provinceCode) || adaptList.contains(cityCode) || adaptList.contains(countyCode)) {
            listAdaptElement.add(id);
        }
    }

    private static void extractedAdaptShop(Long id, DgPerformOrderLabelStrategyQueryDto dgPerformOrderLabelStrategyQueryDto, ArrayList<Long> listAdaptElement, List<String> adaptList) {
        DgPerformOrderSnapshotDto performOrderSnapshotDto = dgPerformOrderLabelStrategyQueryDto.getPerformOrderSnapshotDto();
        String shopCode = performOrderSnapshotDto.getShopCode();
        if (adaptList.contains(shopCode)) {
            listAdaptElement.add(id);
        }
    }

    private static void extractedIntersect(ArrayList<Long> specialListAdapt, List<Long> remarkBList, List<Long> rangeBList) {
        remarkBList.retainAll(rangeBList);
        if (CollectionUtils.isNotEmpty(remarkBList)) {
            specialListAdapt.addAll(remarkBList);
        }
    }
}

