/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.b2c.Impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutNoticeOrderPageReqDto;
import com.yunxi.dg.base.center.inventory.proxy.baseorder.IInOutNoticeOrderApiProxy;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutNoticeOrderDto;
import com.yunxi.dg.base.center.report.proxy.inventory.IDgOutNoticeOrderApiProxy;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformNoticeSyncRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAttachmentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoOutNoticeSyncRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSplitReleationDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformNoticeSyncRecordShippingDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAttachmentDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderExtensionDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderWarehouseInfoDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderKneadRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderAddrRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemExtRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgRelatedOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderExtensionEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSplitReleationEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordShippingService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderQueryService;
import com.yunxi.dg.base.center.trade.service.oms.common.ICommonOrderQueryService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgOmsOrderQueryServiceImpl
implements IDgOmsOrderQueryService {
    private static final Logger log = LoggerFactory.getLogger(DgOmsOrderQueryServiceImpl.class);
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgPerformOrderAddrDomain performOrderAddrDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPerformOrderAttachmentDomain dgPerformOrderAttachmentDomain;
    @Resource
    private IDgPerformOrderItemLineDomain orderItemLineDomain;
    @Resource
    private IDgPerformOrderExtensionDomain dgPerformOrderExtensionDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain dgPerformOrderSnapshotDomain;
    @Resource
    private IDgPerformOrderSplitReleationDomain performOrderSplitReleationDomain;
    @Resource
    private IDgPerformNoticeSyncRecordDomain dgPerformNoticeSyncRecordDomain;
    @Resource
    private IDgPerformOrderInfoOutNoticeSyncRecordDomain dgPerformOrderInfoOutNoticeSyncRecordDomain;
    @Resource
    private IInOutNoticeOrderApiProxy noticeOrderApiProxy;
    @Resource
    private ICommonOrderQueryService commonOrderQueryService;
    @Resource
    private IDgPerformNoticeSyncRecordShippingService performNoticeSyncRecordShippingService;
    @Resource
    private IDgOutNoticeOrderApiProxy dgOutNoticeOrderApiProxy;

    @Override
    public DgBizPerformOrderRespDto queryByOrderNo(String orderNo) {
        AssertUtils.notNull((Object)orderNo, (String)"\u8ba2\u5355orderNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgPerformOrderReqDto queryDto = new DgPerformOrderReqDto();
        queryDto.setSaleOrderNo(orderNo);
        DgPerformOrderRespDto performOrderInfoDto = this.omsOrderInfoQueryDomain.queryByDto(queryDto);
        AssertUtils.notNull((Object)performOrderInfoDto, (String)"%s\u8ba2\u5355\u4e0d\u5b58\u5728", (Object[])new Object[]{orderNo});
        DgBizPerformOrderRespDto saleOrderRespDto = new DgBizPerformOrderRespDto();
        CubeBeanUtils.copyProperties((Object)saleOrderRespDto, (Object)performOrderInfoDto, (String[])new String[0]);
        CubeBeanUtils.copyProperties((Object)saleOrderRespDto, (Object)performOrderInfoDto.getPerformOrderWarehouseInfoDto(), (String[])new String[]{"id"});
        CubeBeanUtils.copyProperties((Object)saleOrderRespDto, (Object)performOrderInfoDto.getPerformOrderAmountDto(), (String[])new String[]{"id"});
        if (StringUtils.isBlank((CharSequence)saleOrderRespDto.getPerformOrderWarehouseInfoDto().getTransportTypeCode())) {
            saleOrderRespDto.getPerformOrderWarehouseInfoDto().setTransportTypeCode(performOrderInfoDto.getPerformOrderWarehouseInfoDto().getPlanTransportTypeCode());
        }
        if (StringUtils.isBlank((CharSequence)saleOrderRespDto.getPerformOrderWarehouseInfoDto().getTransportTypeName())) {
            saleOrderRespDto.getPerformOrderWarehouseInfoDto().setTransportTypeName(performOrderInfoDto.getPerformOrderWarehouseInfoDto().getPlanTransportTypeName());
        }
        List<DgRelatedOrderRespDto> relatedOrderRespDtos = this.queryDgRelatedOrder(saleOrderRespDto);
        saleOrderRespDto.setRelatedOrderList(relatedOrderRespDtos);
        LambdaQueryWrapper queryAddrWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryAddrWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderAddrEo::getOrderId, (Object)performOrderInfoDto.getId());
        DgPerformOrderAddrDto orderAddrDasOne = this.performOrderAddrDomain.queryAddressByOrderId(performOrderInfoDto.getId());
        DgPerformOrderAddrRespDto orderAddrRespDto = new DgPerformOrderAddrRespDto();
        CubeBeanUtils.copyProperties((Object)orderAddrRespDto, (Object)orderAddrDasOne, (String[])new String[0]);
        saleOrderRespDto.setOrderAddrRespDto(orderAddrRespDto);
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(performOrderInfoDto.getId());
        ArrayList itemList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemList, (Collection)orderLineDtoList, DgPerformOrderItemExtRespDto.class);
        itemList.forEach(item -> {
            List amountDtoList = item.getAmountDtoList();
            if (!CollectionUtils.isNotEmpty((Collection)amountDtoList)) {
                log.info("\u5546\u54c1 {} \u91d1\u989d\u4e3a\u7a7a", (Object)item.getSkuCode());
            }
        });
        saleOrderRespDto.setItemList((List)itemList);
        Long id = performOrderInfoDto.getId();
        DgPerformOrderExtensionEo dgPerformOrderExtensionEo = (DgPerformOrderExtensionEo)((ExtQueryChainWrapper)this.dgPerformOrderExtensionDomain.filter().eq((Object)"order_id", (Object)id)).one();
        DgPerformOrderExtensionDto dgPerformOrderExtensionDto = new DgPerformOrderExtensionDto();
        CubeBeanUtils.copyProperties((Object)dgPerformOrderExtensionDto, (Object)dgPerformOrderExtensionEo, (String[])new String[0]);
        saleOrderRespDto.setPerformOrderExtensionDto(dgPerformOrderExtensionDto);
        List orderItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.orderItemLineDomain.filter().eq((Object)"order_id", (Object)performOrderInfoDto.getId())).eq((Object)"dr", (Object)0)).list();
        ArrayList orderLineDtos = Lists.newArrayList();
        ArrayList orderItemLineDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)orderLineDtoList)) {
            CubeBeanUtils.copyCollection((Collection)orderLineDtos, (Collection)orderLineDtoList, DgPerformOrderLineDto.class);
            orderLineDtos.forEach(e -> {
                e.setKneadeAmount(e.getKneadeAmount() == null ? BigDecimal.ZERO : e.getKneadeAmount());
                e.setPromotionKneadeAmount(e.getPromotionKneadeAmount() == null ? BigDecimal.ZERO : e.getPromotionKneadeAmount());
                e.setCostKneadeAmount(e.getCostKneadeAmount() == null ? BigDecimal.ZERO : e.getCostKneadeAmount());
                DgBizPerformOrderKneadRespDto kneadRespDto = new DgBizPerformOrderKneadRespDto();
                kneadRespDto.setOrderItemId(e.getId());
                kneadRespDto.setPromotionKneadTotal(e.getPromotionKneadeAmount());
                kneadRespDto.setCostKneadTotal(e.getCostKneadeAmount());
                kneadRespDto.setKneadTotal(e.getKneadeAmount());
                kneadRespDto.setKneadPrice(e.getKneadeAmount() != null ? e.getKneadeAmount().divide(e.getCalcItemNum(), 6, 4) : BigDecimal.ZERO);
                kneadRespDto.setKneadLaterTotal(BigDecimal.ZERO);
                kneadRespDto.setKneadLaterTax(BigDecimal.ZERO);
                kneadRespDto.setKneadLaterTotalNotTax(BigDecimal.ZERO);
                e.setKneadRespDto(kneadRespDto);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)orderItemLineEos)) {
            CubeBeanUtils.copyCollection((Collection)orderItemLineDtos, (Collection)orderItemLineEos, DgPerformOrderItemLineDto.class);
        }
        saleOrderRespDto.setOrderLineList((List)orderLineDtos);
        saleOrderRespDto.setOrderItemLineList((List)orderItemLineDtos);
        List attachmentEos = this.dgPerformOrderAttachmentDomain.queryAttachmentByOrderId(performOrderInfoDto.getId());
        saleOrderRespDto.setAttachmentFileList(((List)Optional.ofNullable(attachmentEos).orElse(new ArrayList())).stream().map(eo -> (DgPerformOrderAttachmentDto)BeanUtil.toBean((Object)eo, DgPerformOrderAttachmentDto.class)).collect(Collectors.toList()));
        List<DgPerformNoticeSyncRecordShippingDto> shippingDtoList = this.performNoticeSyncRecordShippingService.queryByOrderId(saleOrderRespDto.getId());
        if (CollectionUtils.isNotEmpty(shippingDtoList)) {
            DgPerformNoticeSyncRecordShippingDto shippingDto = shippingDtoList.get(0);
            saleOrderRespDto.setShippingCompanyCode(shippingDto.getShippingCompanyCode());
            saleOrderRespDto.setShippingCompanyName(shippingDto.getShippingCompany());
            String shippingNos = shippingDtoList.stream().map(DgPerformNoticeSyncRecordShippingDto::getConsignmentNo).collect(Collectors.joining("\uff0c"));
            saleOrderRespDto.setShippingNo(shippingNos);
        } else if (ObjectUtil.isNotEmpty((Object)saleOrderRespDto.getPerformOrderWarehouseInfoDto())) {
            DgPerformOrderWarehouseInfoDto warehouseInfoDto = saleOrderRespDto.getPerformOrderWarehouseInfoDto();
            if (StringUtils.isNotBlank((CharSequence)warehouseInfoDto.getShipmentEnterpriseName())) {
                saleOrderRespDto.setShippingCompanyCode(warehouseInfoDto.getShipmentEnterpriseCode());
                saleOrderRespDto.setShippingCompanyName(warehouseInfoDto.getShipmentEnterpriseName());
            } else {
                saleOrderRespDto.setShippingCompanyCode(warehouseInfoDto.getPlanShipmentEnterpriseCode());
                saleOrderRespDto.setShippingCompanyName(warehouseInfoDto.getPlanShipmentEnterpriseName());
            }
        }
        if (StringUtils.isBlank((CharSequence)saleOrderRespDto.getShippingNo())) {
            DgOutNoticeOrderDto dgOutNoticeOrderDto;
            log.info("\u517c\u5bb9\u4e45\u6570\u636e");
            List<DgWmsShippingInfoReqDto> dgWmsShippingInfoReqDtoList = this.commonOrderQueryService.queryOrderShippingInfoList(saleOrderRespDto.getId());
            if (CollectionUtils.isNotEmpty(dgWmsShippingInfoReqDtoList)) {
                DgWmsShippingInfoReqDto infoReqDto = dgWmsShippingInfoReqDtoList.get(0);
                saleOrderRespDto.setShippingNo(StringUtils.isNotBlank((CharSequence)infoReqDto.getShippingNo()) ? infoReqDto.getShippingNo() : infoReqDto.getConsignNo());
                saleOrderRespDto.setShippingCompanyCode(infoReqDto.getShippingCompanyCode());
                saleOrderRespDto.setShippingCompanyName(infoReqDto.getShippingCompanyName());
            }
            if (StringUtils.isBlank((CharSequence)saleOrderRespDto.getShippingNo()) && (dgOutNoticeOrderDto = (DgOutNoticeOrderDto)this.dgOutNoticeOrderApiProxy.queryByRelevanceNo(saleOrderRespDto.getSaleOrderNo()).getData()) != null && "0".equals(dgOutNoticeOrderDto.getTransportStyle())) {
                saleOrderRespDto.setShippingNo(dgOutNoticeOrderDto.getLogisticsOrderNo());
            }
        }
        DgPerformOrderSnapshotDto dgPerformOrderSnapshotDto = this.dgPerformOrderSnapshotDomain.selectDtoByOrderId(performOrderInfoDto.getId());
        saleOrderRespDto.setPerformOrderSnapshotDto(dgPerformOrderSnapshotDto);
        return saleOrderRespDto;
    }

    private Map<String, String> getLogisticsNos(String orderNo) {
        HashMap logisticsNoMap = Maps.newHashMap();
        if (StringUtils.isBlank((CharSequence)orderNo)) {
            return logisticsNoMap;
        }
        try {
            InOutNoticeOrderPageReqDto pageReqDto = new InOutNoticeOrderPageReqDto();
            pageReqDto.setRelevanceNo(orderNo);
            pageReqDto.setPageNum(Integer.valueOf(1));
            pageReqDto.setPageSize(Integer.valueOf(1000));
            PageInfo page = (PageInfo)RestResponseHelper.extractData((RestResponse)this.noticeOrderApiProxy.page(pageReqDto));
            if (Objects.isNull(page) || CollectionUtils.isEmpty((Collection)page.getList())) {
                return logisticsNoMap;
            }
            List list = page.getList();
            Optional.ofNullable(list).ifPresent(noticeList -> noticeList.forEach(notice -> {
                if (!Objects.equals("ono_cancel", notice.getOrderStatus())) {
                    logisticsNoMap.put(notice.getRelevanceNo(), StringUtils.isNotBlank((CharSequence)notice.getShippingCode()) ? notice.getShippingCode() : notice.getLogisticsOrderNo());
                }
            }));
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u7269\u6d41\u5355\u53f7\u5f02\u5e38\uff1a{},{},{}", new Object[]{orderNo, e, Throwables.getStackTraceAsString((Throwable)e)});
        }
        log.info("\u67e5\u8be2\u7269\u6d41\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)logisticsNoMap));
        return logisticsNoMap;
    }

    public List<DgRelatedOrderRespDto> queryDgRelatedOrder(DgBizPerformOrderRespDto orderRespDto) {
        DgPerformOrderRespDto mianOrder;
        DgPerformOrderSplitReleationEo releationEo;
        List<Object> respDtoList = Lists.newArrayList();
        Map<Long, Long> childIdOrder = this.queryAllChildByOrderId(orderRespDto.getId());
        if (CollectionUtil.isNotEmpty(childIdOrder)) {
            List relatedOrderList = this.omsOrderInfoQueryDomain.queryDtoByIdsNoReleationInfo(new ArrayList<Long>(childIdOrder.keySet()));
            Map map = relatedOrderList.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (a, b) -> a));
            if (CollectionUtils.isNotEmpty((Collection)relatedOrderList)) {
                log.info("[\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5]\u5f53\u524d\u8ba2\u5355\u4e3a\u4e3b\u8ba2\u5355\uff08{}\uff09\uff0c\u5b50\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)orderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)relatedOrderList));
                respDtoList = relatedOrderList.stream().map(order -> {
                    DgRelatedOrderRespDto relatedOrderRespDto = new DgRelatedOrderRespDto();
                    relatedOrderRespDto.setId(order.getId());
                    relatedOrderRespDto.setMainOrder(Boolean.FALSE);
                    relatedOrderRespDto.setSaleOrderNo(order.getSaleOrderNo());
                    relatedOrderRespDto.setOrderStatus(order.getOrderStatus());
                    Long mainId = (Long)childIdOrder.get(order.getId());
                    DgPerformOrderRespDto mainOrder = (DgPerformOrderRespDto)map.get(mainId);
                    if (null != mainOrder) {
                        relatedOrderRespDto.setMainOrderNo(mainOrder.getSaleOrderNo());
                        relatedOrderRespDto.setOrignalOrderNo(mainOrder.getSaleOrderNo());
                    }
                    return relatedOrderRespDto;
                }).collect(Collectors.toList());
            }
        }
        if (null != (releationEo = this.performOrderSplitReleationDomain.queryByChildId(orderRespDto.getId())) && Objects.nonNull(mianOrder = this.omsOrderInfoQueryDomain.queryDtoById(releationEo.getOrderId()))) {
            DgRelatedOrderRespDto mainOrderRespDto = new DgRelatedOrderRespDto();
            mainOrderRespDto.setId(mianOrder.getId());
            mainOrderRespDto.setMainOrder(Boolean.TRUE);
            mainOrderRespDto.setOrderStatus(mianOrder.getOrderStatus());
            mainOrderRespDto.setSaleOrderNo(mianOrder.getSaleOrderNo());
            mainOrderRespDto.setMainOrderNo(mianOrder.getMainOrderNo());
            respDtoList.add(mainOrderRespDto);
        }
        log.info("[\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5]\u5173\u8054\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)respDtoList));
        return respDtoList;
    }

    public Map<Long, Long> queryAllChildByOrderId(Long orderId) {
        HashMap<Long, Long> allOrder = new HashMap<Long, Long>();
        List releationEos = this.performOrderSplitReleationDomain.queryByOrderId(orderId);
        releationEos.forEach(releation -> allOrder.put(releation.getChildOrderId(), releation.getOrderId()));
        List ids = releationEos.stream().map(DgPerformOrderSplitReleationEo::getChildOrderId).collect(Collectors.toList());
        log.info("\u5df2\u62c6\u5206\u5b50\u5355\uff1a{}", ids);
        int i = 1;
        while (CollectionUtil.isNotEmpty(ids)) {
            List subReleationEos = this.performOrderSplitReleationDomain.queryByOrderIds(ids);
            releationEos.forEach(releation -> allOrder.put(releation.getChildOrderId(), releation.getOrderId()));
            List subIds = subReleationEos.stream().map(DgPerformOrderSplitReleationEo::getChildOrderId).collect(Collectors.toList());
            log.info("{} \u7ea7\u5df2\u62c6\u5206\u5b50\u5355\uff1a{}", (Object)i, subIds);
            if (CollectionUtil.isNotEmpty(subIds)) {
                ids = subIds;
                ++i;
                continue;
            }
            ids = new ArrayList();
        }
        return allOrder;
    }

    @Override
    public List<DgPerformOrderRespDto> queryByOrderNoList(List<String> orderNoList) {
        return this.omsOrderInfoQueryDomain.queryDtoByOrderNoList(orderNoList);
    }
}

