/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.channel.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ActivityConstant;
import com.dtyunxi.yundt.cube.center.trade.api.constants.activity.ActivityTypeTobEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoJoinReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.activity.OrderActivityDetailRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderActivityDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgF2BPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BOrderContextVo;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.activity.DgOrderActivityBizReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.DgOrderPreviewReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgF2BOrderPreviewContext;
import com.yunxi.dg.base.center.trade.eo.OrderActivityEo;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelActiveService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgCalcActivityService;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ChannelActiveServiceImpl
implements IChannelActiveService {
    private static final Logger log = LoggerFactory.getLogger(ChannelActiveServiceImpl.class);
    @Resource
    private IDgCalcActivityService dgCalcActivityService;
    @Resource
    private IOrderActivityDomain orderActivityDomain;
    @Resource
    private IActivityExtQueryApi activityExtQueryApi;

    @Override
    public void supplementAndCheckInfo(DgF2BOrderContextVo dgF2BOrderContextVo, DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        DgOrderPreviewReqDto previewReqDto = dgF2BOrderContextVo.getPreviewReqDto();
        List activityList = Optional.ofNullable(dgF2BOrderContextVo.getPreviewReqDto().getActivityList()).orElse(Lists.newArrayList());
        if (previewReqDto.isImportOrderMatchActivity() || previewReqDto.getMatchActivity().booleanValue()) {
            List<Long> itemIds = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto().getItemList().stream().map(DgPerformOrderItemDto::getItemId).collect(Collectors.toList());
            long activityStartTime = System.currentTimeMillis();
            List<DgOrderActivityBizReqDto> promotionActivityList = this.dgCalcActivityService.getPromotionActivityList(Lists.newArrayList((Object[])new Long[]{dgF2BOrderContextVo.getShopRespDto().getId()}), itemIds, dgF2BOrderContextVo.getDgCustomerRespDto().getId());
            long activityEndTime = System.currentTimeMillis();
            log.info("\u67e5\u8be2\u6d3b\u52a8\u8017\u65f6:{}", (Object)(activityEndTime - activityStartTime));
            if (CollectionUtils.isNotEmpty(promotionActivityList)) {
                activityList.addAll(promotionActivityList);
            }
        }
        dgF2BOrderContextVo.setActivityList(activityList);
        OrderActivityInfoJoinReqDto activityInfoJoinReqDto = new OrderActivityInfoJoinReqDto();
        activityInfoJoinReqDto.setActivityList(this.convertOrderActivityInfoReqDtos(activityList));
        DgF2BPerformOrderReqDto f2BPerformOrderReqDto = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
        f2BPerformOrderReqDto.setActivity(activityInfoJoinReqDto);
        f2BPerformOrderReqDto.setMatchActivity(dgF2BOrderContextVo.getPreviewReqDto().getMatchActivity().booleanValue());
    }

    private List<OrderActivityInfoReqDto> convertOrderActivityInfoReqDtos(List<DgOrderActivityBizReqDto> activityList) {
        if (CollectionUtils.isEmpty(activityList)) {
            return Collections.EMPTY_LIST;
        }
        HashSet<Long> set = new HashSet<Long>();
        ArrayList<DgOrderActivityBizReqDto> newActivityList = new ArrayList<DgOrderActivityBizReqDto>(activityList.size());
        for (DgOrderActivityBizReqDto activityBizReqDto : activityList) {
            if (!set.add(activityBizReqDto.getActivityId())) continue;
            newActivityList.add(activityBizReqDto);
        }
        return newActivityList.stream().map(orderActivityBizReqDto -> {
            OrderActivityInfoReqDto orderActivityInfoReqDto = new OrderActivityInfoReqDto();
            orderActivityInfoReqDto.setType(orderActivityBizReqDto.getType());
            if (CollectionUtils.isNotEmpty((Collection)orderActivityBizReqDto.getCouponIds())) {
                orderActivityInfoReqDto.setType(ActivityConstant.COUPON_ACTIVITY);
                orderActivityInfoReqDto.setActivityItemIds(orderActivityBizReqDto.getCouponIds());
            }
            orderActivityInfoReqDto.setActivityId(orderActivityBizReqDto.getActivityId());
            orderActivityInfoReqDto.setSelectedGiftReqDtos(orderActivityBizReqDto.getSelectedGiftReqDtos());
            orderActivityInfoReqDto.setSelectedGiftItemDtos(orderActivityBizReqDto.getSelectedGiftItemDtos());
            return orderActivityInfoReqDto;
        }).collect(Collectors.toList());
    }

    @Override
    public List<OrderActivityDetailRespDto> queryOrderDetailActivity(String orderNo) {
        OrderActivityEo orderActivityEo = new OrderActivityEo();
        orderActivityEo.setOrderNo(orderNo);
        List resultList = this.orderActivityDomain.selectList((BaseEo)orderActivityEo);
        ArrayList<OrderActivityDetailRespDto> activityList = new ArrayList<OrderActivityDetailRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            DtoHelper.eoList2DtoList((Collection)resultList, activityList, OrderActivityDetailRespDto.class);
            List activityIds = activityList.stream().map(act -> Long.valueOf(act.getActivityId())).collect(Collectors.toList());
            List activityRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.activityExtQueryApi.queryActivityListByIds(activityIds));
            Map<Long, ActivityRespDto> activityMap = activityRespDtoList.stream().collect(Collectors.toMap(ActivityRespDto::getId, act -> act, (e1, e2) -> e1));
            for (OrderActivityDetailRespDto activityRespDto : activityList) {
                ActivityRespDto activity = activityMap.get(Long.valueOf(activityRespDto.getActivityId()));
                ActivityTypeTobEnum activityTypeTobEnum = ActivityTypeTobEnum.fromCode((Long)activity.getActivityTemplateId());
                activityRespDto.setActivityCode(activity.getActivityCode());
                activityRespDto.setActivityName(activity.getActivityName());
                activityRespDto.setActivityType(activityTypeTobEnum.getTradeDesc());
                activityRespDto.setBeginTime(activity.getBeginTime());
                activityRespDto.setEndTime(activity.getEndTime());
            }
            return activityList;
        }
        return null;
    }
}

