/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.channel.impl;

import com.yunxi.dg.base.center.customer.dto.response.DgCustomerRespDto;
import com.yunxi.dg.base.center.trade.action.oms.channel.IPreInfoQueryAction;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BOrderContextVo;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.DgOrderPreviewReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgF2BOrderPreviewContext;
import com.yunxi.dg.base.center.trade.service.entity.IDgCustomerBlacklistService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelCustomerService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ChannelCustomerServiceImpl
implements IChannelCustomerService {
    private static final Logger log = LoggerFactory.getLogger(ChannelCustomerServiceImpl.class);
    @Resource
    private IDgCustomerBlacklistService dgCustomerBlacklistService;
    @Resource
    private IPreInfoQueryAction preInfoQueryAction;

    @Override
    public void supplementAndCheckInfo(DgF2BOrderContextVo dgF2BOrderContextVo, DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        DgOrderPreviewReqDto previewReqDto = dgF2BOrderContextVo.getPreviewReqDto();
        DgCustomerRespDto dgCustomerRespDto = null;
        if (previewReqDto.getCustomerId() != null) {
            AssertUtils.isFalse((boolean)this.dgCustomerBlacklistService.isInBlackList(previewReqDto.getCustomerId(), null, null), (String)"\u8be5\u5ba2\u6237\u5728\u9ed1\u540d\u5355\u4e2d\uff0c\u4e0d\u5141\u8bb8\u4e0b\u5355");
            dgCustomerRespDto = this.preInfoQueryAction.getCustomerRespDto(previewReqDto.getCustomerId());
            AssertUtils.notNull((Object)dgCustomerRespDto, (String)"\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        dgCustomerRespDto = Optional.ofNullable(dgCustomerRespDto).orElse(new DgCustomerRespDto());
        dgF2BOrderContextVo.setDgCustomerRespDto(dgCustomerRespDto);
        f2BOrderPreviewContext.setDgCustomerRespDto(dgCustomerRespDto);
    }
}

