/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.channel.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.TradeSchedulerEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.AuditTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.PayConfigTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderStayReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.activity.OrderActivityAddReqDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.credit.proxy.entity.IDemandRepaymentStrategiesDgApiProxy;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgBusinessAuditDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrApplyDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAttachmentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSplitReleationDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IOptLogDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderActivityDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IPayRecordDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgF2BOrderInfoBizDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrItemExtDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAttachmentDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderPaymentDto;
import com.yunxi.dg.base.center.trade.dto.entity.ItemPayRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.PayRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderLabelReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizOrderItemRefundInfoRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderKneadRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelBaseRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderAddrRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgRelatedOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.CustomAllotInventoryRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.OrderAddrFulfillmentRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.OrderFulfillmentRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.OrderItemFulfillmentRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.order.DgShopOrderResultRespDto;
import com.yunxi.dg.base.center.trade.dto.response.AddrGroupItemRespDto;
import com.yunxi.dg.base.center.trade.dto.response.ChannelOrderDetailRespDto;
import com.yunxi.dg.base.center.trade.dto.response.CustomPackageOrderDetailRespDto;
import com.yunxi.dg.base.center.trade.dto.response.DgPerformOrderLineDetailDto;
import com.yunxi.dg.base.center.trade.enums.ItemLineCancelStatusEnum;
import com.yunxi.dg.base.center.trade.eo.DgBusinessAuditEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrApplyEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderExtensionEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderPaymentEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSplitReleationEo;
import com.yunxi.dg.base.center.trade.eo.OrderActivityEo;
import com.yunxi.dg.base.center.trade.eo.PayRecordEo;
import com.yunxi.dg.base.center.trade.service.entity.IPayRecordService;
import com.yunxi.dg.base.center.trade.service.mark.IDgOrderLabelService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelOrderService;
import com.yunxi.dg.base.center.trade.service.oms.common.ICommonOrderQueryService;
import com.yunxi.dg.base.center.trade.service.oms.common.IScheduleService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.TaxAmountUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChannelOrderServiceImpl
implements IChannelOrderService {
    private static final Logger log = LoggerFactory.getLogger(ChannelOrderServiceImpl.class);
    @Resource
    private IScheduleService scheduleService;
    @Resource
    private IOptLogDomain optLogDomain;
    @Resource
    private IPayRecordDomain payRecordDomain;
    @Resource
    private ICommonOrderQueryService commonOrderQueryService;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;
    @Resource
    private IDgBusinessAuditDomain dgBusinessAuditDomain;
    @Resource
    private IDgOrderLabelRecordDomain orderLabelRecordDomain;
    @Resource
    private IDgOrderLabelService orderLabelService;
    @Resource
    private IDemandRepaymentStrategiesDgApiProxy demandRepaymentStrategiesDgApiProxy;
    @Resource
    private IDgPerformOrderPaymentDomain performOrderPaymentDomain;
    @Resource
    private IDgPerformOrderExtensionDomain performOrderExtensionDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgPerformOrderAddrItemDomain dgPerformOrderAddrItemDomain;
    @Resource
    private IPayRecordService payRecordService;
    @Resource
    private IDgPerformOrderAddrDomain dgPerformOrderAddrDomain;
    @Resource
    private IDgF2BOrderInfoBizDomain f2bOrderInfoBizDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPerformOrderSplitReleationDomain performOrderSplitReleationDomain;
    @Resource
    private IDgPerformOrderAttachmentDomain dgPerformOrderAttachmentDomain;
    @Resource
    private IDgPerformOrderAddrDomain performOrderAddrDomain;
    @Resource
    private IOrderActivityDomain orderActivityDomain;
    @Resource
    private IDgPerformOrderAddrApplyDomain dgPerformOrderAddrApplyDomain;

    @Override
    public ChannelOrderDetailRespDto orderDetailByOrderNo(String orderNo) {
        AssertUtils.notNull((Object)orderNo, (String)"\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoByOrderNo(orderNo);
        AssertUtils.notNull((Object)performOrderRespDto, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        ChannelOrderDetailRespDto respDto = new ChannelOrderDetailRespDto();
        CubeBeanUtils.copyProperties((Object)respDto, (Object)performOrderRespDto, (String[])new String[0]);
        DgPerformOrderAddrDto orderAddrDasOne = this.performOrderAddrDomain.queryAddressByOrderId(performOrderRespDto.getId());
        DgPerformOrderAddrRespDto orderAddrRespDto = new DgPerformOrderAddrRespDto();
        CubeBeanUtils.copyProperties((Object)orderAddrRespDto, (Object)orderAddrDasOne, (String[])new String[0]);
        respDto.setOrderAddrRespDto(orderAddrRespDto);
        List addrApplyEos = this.dgPerformOrderAddrApplyDomain.queryWaitAuditAddrInfo((List)Lists.newArrayList((Object[])new Long[]{performOrderRespDto.getId()}));
        if (CollectionUtil.isNotEmpty((Collection)addrApplyEos)) {
            DgPerformOrderAddrRespDto waitAuditAddr = new DgPerformOrderAddrRespDto();
            CubeBeanUtils.copyProperties((Object)waitAuditAddr, addrApplyEos.get(0), (String[])new String[0]);
            waitAuditAddr.setId(null);
            waitAuditAddr.setAddressType(((DgPerformOrderAddrApplyEo)addrApplyEos.get(0)).getChangeType());
            respDto.setOrderAddrReqDtoWaitAudit(waitAuditAddr);
        }
        this.setOrderLineDetails(respDto);
        this.setAuditRemark(respDto);
        this.setOrderAmountByOrderLines(respDto);
        this.setPayWayName(respDto);
        this.orderRemainingPayAmount(orderNo, respDto);
        this.queryCostDetails(respDto);
        if (CollectionUtil.isNotEmpty((Collection)respDto.getOrderLineDetails())) {
            HashSet<String> itemSet = new HashSet<String>();
            for (DgPerformOrderLineDetailDto item : respDto.getOrderLineDetails()) {
                itemSet.add(item.getSkuCode());
            }
            respDto.setItemCodeCount(new BigDecimal(itemSet.size()));
        }
        this.setRelatedOrderList(respDto);
        this.setAttachmentFileList(respDto);
        List dgOrderLabelRecordRespDtos = this.orderLabelRecordDomain.queryByOrderId(performOrderRespDto.getId());
        if (CollectionUtils.isNotEmpty((Collection)dgOrderLabelRecordRespDtos)) {
            List lableCodes = dgOrderLabelRecordRespDtos.stream().map(DgOrderLabelBaseRespDto::getLabelCode).collect(Collectors.toList());
            DgOrderLabelReqDto dgOrderLabelReqDto = new DgOrderLabelReqDto();
            dgOrderLabelReqDto.setLabelCodes(lableCodes);
            List<DgOrderLabelRespDto> labelEoList = this.orderLabelService.queryByList(dgOrderLabelReqDto);
            Map labelEoMap = labelEoList.stream().collect(Collectors.toMap(DgOrderLabelRespDto::getLabelCode, Function.identity()));
            ArrayList labelRecordCodes = Lists.newArrayList(labelEoMap.values());
            respDto.setLabelRecordCodes((List)labelRecordCodes);
            if (CollectionUtils.isNotEmpty(lableCodes) && lableCodes.stream().anyMatch(code -> DgOrderLabelEnum.LOCK.getCode().equals(code) || DgOrderLabelEnum.F2B_LOCK.getCode().equals(code))) {
                respDto.setLockFlag(Integer.valueOf(1));
            } else {
                respDto.setLockFlag(Integer.valueOf(0));
            }
        }
        this.setOrderRepayAmount(respDto);
        this.setHandmadeAmount(respDto);
        return respDto;
    }

    private void setRelatedOrderList(ChannelOrderDetailRespDto respDto) {
        List splitReleationEos = this.performOrderSplitReleationDomain.queryByOrderId(respDto.getId());
        List<Object> respDtoList = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty((Collection)splitReleationEos)) {
            List ids = splitReleationEos.stream().map(DgPerformOrderSplitReleationEo::getChildOrderId).collect(Collectors.toList());
            List performOrderRespDtos = this.omsOrderInfoQueryDomain.queryDtoByIds(ids);
            respDtoList = performOrderRespDtos.stream().map(item -> {
                DgRelatedOrderRespDto relatedOrderRespDto = new DgRelatedOrderRespDto();
                relatedOrderRespDto.setId(item.getId());
                relatedOrderRespDto.setSaleOrderNo(item.getSaleOrderNo());
                relatedOrderRespDto.setMainOrderNo(respDto.getSaleOrderNo());
                relatedOrderRespDto.setOrderStatus(item.getOrderStatus());
                relatedOrderRespDto.setMainOrder(Boolean.FALSE);
                relatedOrderRespDto.setOrignalOrderNo(item.getOriginalOrderNo());
                return relatedOrderRespDto;
            }).collect(Collectors.toList());
            respDto.setRelatedOrderList((List)respDtoList);
        }
    }

    private void setAttachmentFileList(ChannelOrderDetailRespDto respDto) {
        List attachmentEos = this.dgPerformOrderAttachmentDomain.queryAttachmentByOrderId(respDto.getId());
        respDto.setAttachmentFileList(((List)Optional.ofNullable(attachmentEos).orElse(new ArrayList())).stream().map(eo -> (DgPerformOrderAttachmentDto)BeanUtil.toBean((Object)eo, DgPerformOrderAttachmentDto.class)).collect(Collectors.toList()));
    }

    private void setAuditRemark(ChannelOrderDetailRespDto respDto) {
        DgBusinessAuditEo csAuditEo = (DgBusinessAuditEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgBusinessAuditDomain.filter().eq((Object)"business_id", (Object)respDto.getId())).eq((Object)"business_no", (Object)respDto.getSaleOrderNo())).eq((Object)"business_type", (Object)1)).eq((Object)"audit_type", (Object)AuditTypeEnum.CS_AUDIT.getType())).orderByDesc((Object)"create_time")).last("limit 1")).one();
        DgBusinessAuditEo financeAuditEo = (DgBusinessAuditEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgBusinessAuditDomain.filter().eq((Object)"business_id", (Object)respDto.getId())).eq((Object)"business_no", (Object)respDto.getSaleOrderNo())).eq((Object)"business_type", (Object)1)).eq((Object)"audit_type", (Object)AuditTypeEnum.FINANCE_AUDIT.getType())).orderByDesc((Object)"create_time")).last("limit 1")).one();
        DgBusinessAuditEo externalAuditEo = (DgBusinessAuditEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgBusinessAuditDomain.filter().eq((Object)"business_id", (Object)respDto.getId())).eq((Object)"business_no", (Object)respDto.getSaleOrderNo())).eq((Object)"business_type", (Object)1)).eq((Object)"audit_type", (Object)AuditTypeEnum.EXTERNAL_AUDIT.getType())).orderByDesc((Object)"create_time")).last("limit 1")).one();
        if (csAuditEo != null) {
            respDto.setCustomerAuditRemark(csAuditEo.getAuditDesc());
            respDto.setCustomerAuditTime(csAuditEo.getAuditTime());
            respDto.setCustomerAuditPerson(csAuditEo.getCreatePerson());
        }
        if (financeAuditEo != null) {
            respDto.setFinancialAuditRemark(financeAuditEo.getAuditDesc());
            respDto.setFinancialAuditTime(financeAuditEo.getAuditTime());
            respDto.setFinancialAuditPerson(financeAuditEo.getCreatePerson());
        }
        if (externalAuditEo != null) {
            respDto.setExternalAuditRemark(externalAuditEo.getAuditDesc());
            respDto.setExternalAuditTime(externalAuditEo.getAuditTime());
            respDto.setExternalAuditPerson(externalAuditEo.getCreatePerson());
        }
    }

    @Override
    public CustomPackageOrderDetailRespDto customPackageOrderDetailByOrderNo(String orderNo) {
        ChannelOrderDetailRespDto orderDetail = this.orderDetailByOrderNo(orderNo);
        CustomPackageOrderDetailRespDto orderDetailRespDto = (CustomPackageOrderDetailRespDto)BeanUtil.copyProperties((Object)orderDetail, CustomPackageOrderDetailRespDto.class, (String[])new String[0]);
        Map orderLineIdDetailMap = orderDetailRespDto.getOrderLineDetails().stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
        ArrayList<AddrGroupItemRespDto> addrGroupItemDtoList = new ArrayList<AddrGroupItemRespDto>();
        List addrItemExtDtoList = this.dgPerformOrderAddrItemDomain.queryItemAddrInfo(orderDetailRespDto.getId());
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)addrItemExtDtoList), (String)"\u8ba2\u5355\u884c\u5730\u5740\u5173\u8054\u4fe1\u606f\u4e3a\u7a7a");
        Map<Long, List<DgPerformOrderAddrItemExtDto>> addrMap = addrItemExtDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderAddrItemDto::getOrderAddrId));
        for (Map.Entry<Long, List<DgPerformOrderAddrItemExtDto>> entry : addrMap.entrySet()) {
            DgPerformOrderAddrItemExtDto addrItemExtDto = (DgPerformOrderAddrItemExtDto)entry.getValue().stream().findFirst().get();
            ArrayList orderLineDetails = Lists.newArrayList();
            for (DgPerformOrderAddrItemExtDto itemExtDto : entry.getValue()) {
                DgPerformOrderLineDetailDto dgPerformOrderLineDetailDto = (DgPerformOrderLineDetailDto)orderLineIdDetailMap.get(itemExtDto.getOrderItemId());
                if (dgPerformOrderLineDetailDto == null) continue;
                dgPerformOrderLineDetailDto.setStocksCode(itemExtDto.getStocksCode());
                dgPerformOrderLineDetailDto.setOriginalSkuCode(itemExtDto.getOriginalSkuCode());
                dgPerformOrderLineDetailDto.setSpotGoodsNum(Optional.ofNullable(itemExtDto.getSpotGoodsNum()).orElse(BigDecimal.ZERO));
                dgPerformOrderLineDetailDto.setDeliveryReformNum(Optional.ofNullable(itemExtDto.getDeliveryReformNum()).orElse(BigDecimal.ZERO));
                dgPerformOrderLineDetailDto.setProductionReformNum(Optional.ofNullable(itemExtDto.getProductionReformNum()).orElse(BigDecimal.ZERO));
                dgPerformOrderLineDetailDto.setFulfillmentedNum(Optional.ofNullable(itemExtDto.getFulfillmentedNum()).orElse(BigDecimal.ZERO));
                dgPerformOrderLineDetailDto.setStockoutNum(Optional.ofNullable(itemExtDto.getStockoutNum()).orElse(BigDecimal.ZERO));
                dgPerformOrderLineDetailDto.setWaitFulfillmentNum(itemExtDto.getPlaceItemNum().subtract(dgPerformOrderLineDetailDto.getSpotGoodsNum()).subtract(dgPerformOrderLineDetailDto.getDeliveryReformNum()).subtract(dgPerformOrderLineDetailDto.getProductionReformNum()));
                if (dgPerformOrderLineDetailDto.getItemNum() != null && dgPerformOrderLineDetailDto.getItemNum().compareTo(BigDecimal.ZERO) > 0) {
                    dgPerformOrderLineDetailDto.setBoxNum(dgPerformOrderLineDetailDto.getItemNum().divide(dgPerformOrderLineDetailDto.getPackingNumber(), 2, RoundingMode.HALF_UP));
                }
                orderLineDetails.add(dgPerformOrderLineDetailDto);
            }
            AddrGroupItemRespDto addrGroupItem = (AddrGroupItemRespDto)BeanUtil.toBean((Object)addrItemExtDto, AddrGroupItemRespDto.class);
            addrGroupItem.setId(addrItemExtDto.getOrderAddrId());
            addrGroupItem.setAddrType(Integer.valueOf(Objects.isNull(addrItemExtDto.getOrderAddrId()) ? 1 : 2));
            addrGroupItem.setPurchaseOrderNo(addrItemExtDto.getPurchaseOrderNo());
            addrGroupItem.setOrderLineDetails((List)orderLineDetails);
            addrGroupItem.setAddrSaleOrderNo(addrItemExtDto.getAddrSaleOrderNo());
            addrGroupItem.setOrderAmount(orderLineDetails.stream().map(DgPerformOrderLineDto::getSaleAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            addrGroupItem.setTotalAmount(orderLineDetails.stream().map(DgPerformOrderLineDto::getPayAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            addrGroupItemDtoList.add(addrGroupItem);
        }
        orderDetailRespDto.setAddrGroupItemDtoList(addrGroupItemDtoList);
        return orderDetailRespDto;
    }

    @Override
    public List<CustomAllotInventoryRespDto> queryAllotInventory(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        List dgPerformOrderLineSummaryDtos = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(orderId);
        List dgPerformOrderAddrItemExtDtos = this.dgPerformOrderAddrItemDomain.queryItemAddrInfo(orderId);
        Map addrItemMap = dgPerformOrderAddrItemExtDtos.stream().collect(Collectors.toMap(DgPerformOrderAddrItemDto::getOrderItemId, Function.identity(), (e1, e2) -> e1));
        List<CustomAllotInventoryRespDto> allotInventoryRespDtos = dgPerformOrderLineSummaryDtos.stream().map(orderLineDto -> {
            DgPerformOrderAddrItemExtDto addrItemExtDto = (DgPerformOrderAddrItemExtDto)addrItemMap.get(orderLineDto.getId());
            AssertUtils.notNull((Object)addrItemExtDto, (String)"\u5730\u5740\u5173\u8054\u8ba2\u5355\u884c\u6570\u636e\u4e0d\u5b58\u5728");
            CustomAllotInventoryRespDto allotInventoryRespDto = new CustomAllotInventoryRespDto();
            allotInventoryRespDto.setAddrItemId(addrItemExtDto.getId());
            allotInventoryRespDto.setOriginalSkuCode(addrItemExtDto.getOriginalSkuCode());
            allotInventoryRespDto.setStockoutNum(addrItemExtDto.getStockoutNum());
            allotInventoryRespDto.setDeliveryReformNum(addrItemExtDto.getDeliveryReformNum());
            allotInventoryRespDto.setProductionReformNum(addrItemExtDto.getProductionReformNum());
            allotInventoryRespDto.setOrderLineId(orderLineDto.getId());
            allotInventoryRespDto.setSkuCode(orderLineDto.getSkuCode());
            allotInventoryRespDto.setSkuName(orderLineDto.getSkuName());
            allotInventoryRespDto.setOrderItemUnit(orderLineDto.getOrderItemUnit());
            allotInventoryRespDto.setOrderItemUnitName(orderLineDto.getOrderItemUnitName());
            allotInventoryRespDto.setPlaceItemNum(orderLineDto.getPlaceItemNum());
            return allotInventoryRespDto;
        }).collect(Collectors.toList());
        return allotInventoryRespDtos;
    }

    @Override
    public OrderFulfillmentRespDto queryOrderFulfillmentList(Long orderId) {
        DgPerformOrderRespDto dgPerformOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)dgPerformOrderRespDto, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        List dgPerformOrderAddrDtos = this.dgPerformOrderAddrDomain.queryByOrderId(orderId);
        List dgPerformOrderLineSummaryDtos = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(orderId);
        Map orderLineMap = dgPerformOrderLineSummaryDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
        List dgPerformOrderAddrItemExtDtos = this.dgPerformOrderAddrItemDomain.queryItemAddrInfo(orderId);
        Map<Long, List<OrderItemFulfillmentRespDto>> fulfillmentGroup = dgPerformOrderAddrItemExtDtos.stream().map(addrItemExtDto -> {
            DgPerformOrderLineDto orderLineDto = (DgPerformOrderLineDto)orderLineMap.get(addrItemExtDto.getOrderItemId());
            AssertUtils.notNull((Object)orderLineDto, (String)"\u8ba2\u5355\u884c\u4e0d\u5b58\u5728");
            BigDecimal packingNumber = Optional.ofNullable(orderLineDto.getBasicNum()).orElse(BigDecimal.ZERO).divide(Optional.ofNullable(orderLineDto.getItemNum()).orElse(BigDecimal.ONE), 2, 1);
            OrderItemFulfillmentRespDto itemFulfillmentRespDto = new OrderItemFulfillmentRespDto();
            itemFulfillmentRespDto.setOrderLineId(addrItemExtDto.getOrderItemId());
            itemFulfillmentRespDto.setOrderAddrId(addrItemExtDto.getOrderAddrId());
            itemFulfillmentRespDto.setAddrItemId(addrItemExtDto.getId());
            itemFulfillmentRespDto.setOriginalSkuCode(addrItemExtDto.getOriginalSkuCode());
            itemFulfillmentRespDto.setSkuCode(addrItemExtDto.getSkuCode());
            itemFulfillmentRespDto.setSpotGoodsNum(addrItemExtDto.getSpotGoodsNum());
            itemFulfillmentRespDto.setFulfillmentedNum(Optional.ofNullable(addrItemExtDto.getFulfillmentedNum()).orElse(BigDecimal.ZERO));
            itemFulfillmentRespDto.setWaitFulfillmentNum(orderLineDto.getItemNum().subtract(itemFulfillmentRespDto.getFulfillmentedNum()));
            itemFulfillmentRespDto.setSkuName(orderLineDto.getSkuName());
            itemFulfillmentRespDto.setMinPackage(packingNumber);
            itemFulfillmentRespDto.setOrderItemUnit(orderLineDto.getOrderItemUnit());
            itemFulfillmentRespDto.setOrderItemUnitName(orderLineDto.getOrderItemUnitName());
            itemFulfillmentRespDto.setPlaceItemNum(orderLineDto.getPlaceItemNum());
            itemFulfillmentRespDto.setItemNum(orderLineDto.getItemNum());
            itemFulfillmentRespDto.setCancelNum(BigDecimal.ZERO);
            return itemFulfillmentRespDto;
        }).collect(Collectors.groupingBy(OrderItemFulfillmentRespDto::getOrderAddrId));
        List addrFulfillmentRespDtos = dgPerformOrderAddrDtos.stream().map(orderAddrDto -> {
            OrderAddrFulfillmentRespDto addrFulfillmentRespDto = (OrderAddrFulfillmentRespDto)BeanUtil.copyProperties((Object)orderAddrDto, OrderAddrFulfillmentRespDto.class, (String[])new String[0]);
            addrFulfillmentRespDto.setOrderItemFulfillmentRespDtos((List)fulfillmentGroup.get(orderAddrDto.getId()));
            return addrFulfillmentRespDto;
        }).collect(Collectors.toList());
        OrderFulfillmentRespDto fulfillmentRespDto = new OrderFulfillmentRespDto();
        fulfillmentRespDto.setOrderId(dgPerformOrderRespDto.getId());
        fulfillmentRespDto.setSaleOrderNo(dgPerformOrderRespDto.getSaleOrderNo());
        fulfillmentRespDto.setCustomerId(dgPerformOrderRespDto.getPerformOrderSnapshotDto().getCustomerId());
        fulfillmentRespDto.setCustomerCode(dgPerformOrderRespDto.getPerformOrderSnapshotDto().getCustomerCode());
        fulfillmentRespDto.setCustomerName(dgPerformOrderRespDto.getPerformOrderSnapshotDto().getCustomerName());
        fulfillmentRespDto.setShopId(dgPerformOrderRespDto.getPerformOrderSnapshotDto().getShopId());
        fulfillmentRespDto.setShopCode(dgPerformOrderRespDto.getPerformOrderSnapshotDto().getShopCode());
        fulfillmentRespDto.setShopName(dgPerformOrderRespDto.getPerformOrderSnapshotDto().getShopName());
        fulfillmentRespDto.setCustomerBatch(dgPerformOrderRespDto.getPerformOrderExtensionDto().getCustomerBatch());
        fulfillmentRespDto.setOrderAddrFulfillmentRespDtos(addrFulfillmentRespDtos);
        return fulfillmentRespDto;
    }

    @Override
    public DgPerformOrderRespDto queryById(Long orderId) {
        return this.commonOrderQueryService.querySaleOrderById(orderId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logicDeleteOrder(Long id) {
        this.f2bOrderInfoBizDomain.logicDeleteById(id);
    }

    private void setOrderAmountByOrderLines(ChannelOrderDetailRespDto respDto) {
        List orderLineDetails = respDto.getOrderLineDetails();
        if (CollectionUtils.isNotEmpty((Collection)orderLineDetails)) {
            BigDecimal saleAmount = orderLineDetails.stream().map(DgPerformOrderLineDto::getSaleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal discountAmount = orderLineDetails.stream().map(DgPerformOrderLineDto::getPromotionDiscountAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal costAmount = orderLineDetails.stream().map(DgPerformOrderLineDetailDto::getTotalUseCostAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal transactionAmount = orderLineDetails.stream().map(DgPerformOrderLineDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            Iterator iterator = orderLineDetails.iterator();
            while (iterator.hasNext()) {
                DgPerformOrderLineDetailDto orderLineDetail;
                orderLineDetail.setHandmadeDiscount((orderLineDetail = (DgPerformOrderLineDetailDto)iterator.next()).getHandmadeDiscount() == null ? BigDecimal.ZERO : orderLineDetail.getHandmadeDiscount());
                orderLineDetail.setHandmadeDiscountAmount(orderLineDetail.getHandmadeDiscountAmount() == null ? BigDecimal.ZERO : orderLineDetail.getHandmadeDiscountAmount());
            }
            BigDecimal totalHandmadeDiscountAmount = orderLineDetails.stream().map(DgPerformOrderLineDetailDto::getHandmadeDiscountAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            respDto.setGoodsTotalAmount(saleAmount);
            respDto.setOrigAmount(transactionAmount);
            respDto.setPayAmount(transactionAmount.subtract(costAmount));
            respDto.setDiscountAmount(discountAmount);
            respDto.setTotalOrderDiscountAmount(BigDecimal.ZERO);
            respDto.setDiscountGoodsAmount(discountAmount);
            respDto.setTotalHandmadeDiscountAmount(totalHandmadeDiscountAmount);
        }
    }

    public void setOrderLineDetails(ChannelOrderDetailRespDto respDto) {
        List<PayRecordDto> payRecordDtos = this.payRecordService.selectListByOrderNo(respDto.getSaleOrderNo());
        Map<Long, List<ItemPayRecordDto>> orderLinePayRecordMap = payRecordDtos.stream().filter(recordDto -> !Objects.equals(PayStatusEnum.BACKED.getCode(), recordDto.getPayStatus())).filter(recordDto -> CollectionUtils.isNotEmpty((Collection)recordDto.getItemPayRecordDtos())).peek(recordDto -> recordDto.getItemPayRecordDtos().stream().forEach(itemPayRecordDto -> itemPayRecordDto.setSaleCompanyCode(recordDto.getSellerId()))).map(PayRecordDto::getItemPayRecordDtos).flatMap(Collection::stream).collect(Collectors.groupingBy(ItemPayRecordDto::getOrderItemId));
        List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(respDto.getId());
        ArrayList orderLineDetails = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)orderLineDetails, (Collection)orderLineDtos, DgPerformOrderLineDetailDto.class);
        List orderItemLineDtos = this.performOrderItemLineDomain.queryInfoByOrderId(respDto.getId());
        AtomicReference<BigDecimal> totalVolume = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> totalWeight = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        if (CollectionUtils.isNotEmpty((Collection)orderLineDetails)) {
            int kneadFlag = respDto.getPerformOrderSnapshotDto().getKneadeFlag() != null ? respDto.getPerformOrderSnapshotDto().getKneadeFlag() : 0;
            Map<Long, List<DgPerformOrderItemLineDto>> itemLineMap = orderItemLineDtos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getOrderLineId));
            orderLineDetails.stream().filter(orderLineEo -> orderLineEo.getItemNum() != null && orderLineEo.getItemNum().compareTo(BigDecimal.ZERO) > 0).forEach(e -> {
                List itemLineDts = (List)itemLineMap.get(e.getId());
                List amountList = e.getAmountDtoList();
                List saleAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode())).collect(Collectors.toList());
                BigDecimal saleAmount = CollectionUtil.isNotEmpty(saleAmountList) ? saleAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
                List payAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode())).collect(Collectors.toList());
                BigDecimal payAmount = CollectionUtil.isNotEmpty(payAmountList) ? payAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
                List realPayAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode())).collect(Collectors.toList());
                BigDecimal realPayAmount = CollectionUtil.isNotEmpty(realPayAmountList) ? realPayAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
                List costAmountList = amountList.stream().filter(a -> a.getAccountCategory().equals(DgOmsOrderAmountTypeEnum.LINE_COST_AMOUNT.getCode()) && a.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode())).collect(Collectors.toList());
                BigDecimal costAmount = CollectionUtil.isNotEmpty(costAmountList) ? costAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
                List discountAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode())).collect(Collectors.toList());
                BigDecimal discountAmount = CollectionUtil.isNotEmpty(discountAmountList) ? discountAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
                List handmadeDiscountAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_HANDMADE_DISCOUNT_AMOUNT.getCode())).collect(Collectors.toList());
                BigDecimal handmadeDiscountAmount = CollectionUtil.isNotEmpty(handmadeDiscountAmountList) ? handmadeDiscountAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
                List promotionKneadAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_PROMOTION_KNEAD_TOTAL.getCode())).collect(Collectors.toList());
                BigDecimal promotionKneadAmount = CollectionUtil.isNotEmpty(promotionKneadAmountList) ? promotionKneadAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
                List costKneadAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_COST_KNEAD_TOTAL.getCode())).collect(Collectors.toList());
                BigDecimal costKneadAmount = CollectionUtil.isNotEmpty(costKneadAmountList) ? costKneadAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
                BigDecimal kneadAmount = promotionKneadAmount.add(costKneadAmount);
                List kneadLaterAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_KNEAD_LATER_SETTLEMENT_AMOUNT.getCode())).collect(Collectors.toList());
                BigDecimal kneadLaterAmount = CollectionUtil.isNotEmpty(kneadLaterAmountList) ? kneadLaterAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
                e.setSaleAmount(saleAmount);
                e.setPayAmount(payAmount);
                e.setRealPayAmount(realPayAmount);
                e.setTotalUseCostAmount(costAmount);
                e.setCostAmount(costAmount);
                e.setGoodsDiscountAmount(discountAmount);
                e.setDiscountAmount(discountAmount);
                e.setOrderDiscountAmount(BigDecimal.ZERO);
                e.setPromotionDiscountAmount(discountAmount);
                e.setSettlementAmount(e.getRealPayAmount());
                if (costAmount.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal costAmountProportion = costAmount.divide(payAmount, 4, 4);
                    if (costAmountProportion.compareTo(BigDecimal.ONE) > 0) {
                        costAmountProportion = BigDecimal.ONE;
                        log.error("\u8fd4\u5229\u5206\u644a\u6bd4\u4f8b\u8ba1\u7b97\u9519\u8bef");
                    }
                    costAmountProportion = BigDecimal.ONE.subtract(costAmountProportion);
                    costAmountProportion = costAmountProportion.multiply(new BigDecimal(100)).setScale(2, 4);
                    e.setCostAmountProportion(costAmountProportion);
                } else {
                    e.setCostAmountProportion(new BigDecimal(100.0));
                }
                e.setPrice(e.getSettlementAmount().divide(e.getCalcItemNum(), 2, 4));
                e.setItemOrigPrice(e.getPayAmount().divide(e.getCalcItemNum(), 2, 4));
                e.setItemMarketPrice(e.getSalePrice());
                BigDecimal waitDeliveryNum = BigDecimal.ZERO;
                BigDecimal deliveryNum = BigDecimal.ZERO;
                BigDecimal cancelNum = BigDecimal.ZERO;
                BigDecimal refundPayAmount = BigDecimal.ZERO;
                BigDecimal refundCost = BigDecimal.ZERO;
                BigDecimal refundKneadAmount = BigDecimal.ZERO;
                BigDecimal refundKneadCost = BigDecimal.ZERO;
                BigDecimal packingNumber = Optional.ofNullable(e.getBasicNum()).orElse(BigDecimal.ZERO).divide(Optional.ofNullable(e.getItemNum()).orElse(BigDecimal.ONE), 2, 4);
                for (DgPerformOrderItemLineDto itemLineDto : itemLineDts) {
                    waitDeliveryNum = waitDeliveryNum.add(itemLineDto.getItemNum().subtract(itemLineDto.getOutItemNum()));
                    deliveryNum = deliveryNum.add(itemLineDto.getOutItemNum());
                    if (respDto.getOrderStatus().equals(DgOmsSaleOrderStatus.CANCEL.getCode()) || respDto.getOrderStatus().equals(DgOmsSaleOrderStatus.FINISH.getCode()) || respDto.getOrderStatus().equals(DgOmsSaleOrderStatus.RECEIVED.getCode())) {
                        cancelNum = waitDeliveryNum;
                    }
                    if (null == itemLineDto.getCancelStatus() || !ItemLineCancelStatusEnum.YES.getType().equals(itemLineDto.getCancelStatus())) continue;
                    refundPayAmount = refundPayAmount.add(itemLineDto.getPayAmountRefund() == null ? BigDecimal.ZERO : itemLineDto.getPayAmountRefund());
                    refundCost = refundCost.add(refundCost.add(itemLineDto.getCostAmountRefund() == null ? BigDecimal.ZERO : itemLineDto.getCostAmountRefund()));
                    if (1 != kneadFlag) continue;
                    BigDecimal kneadePayAmount = BigDecimal.ZERO;
                    for (DgPerformOrderItemLineDto orderItemLineDto : itemLineDts) {
                        List kneadList = orderItemLineDto.getPerformOrderItemLineAmountDtoList().stream().filter(amount -> amount.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_KNEAD_LATER_SETTLEMENT_AMOUNT.getCode())).collect(Collectors.toList());
                        if (!CollectionUtil.isNotEmpty(kneadList)) continue;
                        kneadePayAmount = kneadePayAmount.add(kneadList.stream().map(DgPerformOrderItemLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                    }
                    refundKneadAmount = refundKneadAmount.add(kneadePayAmount.multiply(cancelNum).divide(e.getItemNum(), 2, RoundingMode.HALF_UP));
                    refundKneadCost = refundKneadCost.add(costKneadAmount.multiply(cancelNum).divide(e.getItemNum(), 2, RoundingMode.HALF_UP));
                }
                DgBizOrderItemRefundInfoRespDto refundInfoRespDto = new DgBizOrderItemRefundInfoRespDto();
                refundInfoRespDto.setRefundPayAmount(refundPayAmount);
                refundInfoRespDto.setRefundCost(refundCost);
                refundInfoRespDto.setRefundKneadAmount(refundKneadAmount);
                refundInfoRespDto.setRefundKneadCost(refundKneadCost);
                e.setOrderItemRefundInfoDto(refundInfoRespDto);
                e.setNoDeliveryNum(waitDeliveryNum);
                e.setDeliveredNum(deliveryNum);
                e.setCancelNum(cancelNum);
                e.setNotDeliveredNum(waitDeliveryNum);
                e.setRefundedItemNum(cancelNum);
                e.setItemAttr(e.getItemAttribute());
                e.setGift(e.getGiftFlag());
                e.setPackingNumber(packingNumber);
                e.setTaxRate(e.getRate());
                if (e.getRate() != null && e.getRate().compareTo(BigDecimal.ZERO) > 0) {
                    e.setRealPayAmountNoTax(TaxAmountUtil.noTaxAmountGet(e.getRate(), e.getRealPayAmount()));
                    e.setPayAmountNoTax(TaxAmountUtil.noTaxAmountGet(e.getRate(), e.getPayAmount()));
                    e.setLineTaxAmount(TaxAmountUtil.taxAmountGet(e.getRate(), e.getRealPayAmount()));
                    e.setTaxAmount(e.getLineTaxAmount());
                }
                if (1 == kneadFlag && DgF2BOrderStatus.ALLOT_STATUS.contains(respDto.getOrderStatus())) {
                    e.setPromotionKneadeAmount(promotionKneadAmount);
                    e.setCostKneadeAmount(costKneadAmount);
                    e.setKneadeAmount(kneadAmount);
                    DgBizPerformOrderKneadRespDto kneadRespDto = new DgBizPerformOrderKneadRespDto();
                    kneadRespDto.setOrderItemId(e.getId());
                    kneadRespDto.setPromotionKneadTotal(e.getPromotionKneadeAmount());
                    kneadRespDto.setCostKneadTotal(e.getCostKneadeAmount());
                    kneadRespDto.setKneadTotal(e.getKneadeAmount());
                    kneadRespDto.setKneadPrice(e.getKneadeAmount().divide(e.getCalcItemNum(), 2, 4));
                    kneadRespDto.setKneadLaterTotal(kneadLaterAmount);
                    kneadRespDto.setKneadLaterPrice(kneadRespDto.getKneadLaterTotal().divide(e.getCalcItemNum(), 2, 4));
                    if (e.getRate() != null && e.getRate().compareTo(BigDecimal.ZERO) > 0) {
                        kneadRespDto.setKneadLaterTax(TaxAmountUtil.taxAmountGet(e.getRate(), kneadRespDto.getKneadLaterTotal()));
                        kneadRespDto.setKneadLaterTotalNotTax(TaxAmountUtil.noTaxAmountGet(e.getRate(), kneadRespDto.getKneadLaterTotal()));
                    }
                    kneadRespDto.setKneadLaterTransactionTotal(kneadRespDto.getKneadLaterTotal().add(kneadRespDto.getCostKneadTotal()));
                    kneadRespDto.setKneadLaterTransactionPrice(kneadRespDto.getKneadLaterTransactionTotal().divide(e.getCalcItemNum(), 4, 4));
                    e.setKneadRespDto(kneadRespDto);
                }
                totalVolume.set(((BigDecimal)totalVolume.get()).add(e.getVolume().multiply(e.getCalcItemNum())));
                totalWeight.set(((BigDecimal)totalWeight.get()).add(e.getWeight().multiply(e.getCalcItemNum())));
                BigDecimal unitCoefficient = e.getCalcItemNum().divide(e.getItemNum(), 2, 4);
                e.setUnitCoefficient(unitCoefficient);
                ArrayList payRecordDetialDtos = Lists.newArrayList();
                List itemPayRecordDtos = (List)orderLinePayRecordMap.get(e.getId());
                if (CollectionUtils.isNotEmpty((Collection)itemPayRecordDtos)) {
                    e.setItemPayRecordDtos(itemPayRecordDtos);
                    Map<String, List<ItemPayRecordDto>> map = itemPayRecordDtos.stream().collect(Collectors.groupingBy(itemPayRecord -> itemPayRecord.getAccountType() + "&" + itemPayRecord.getSaleCompanyCode()));
                    for (Map.Entry<String, List<ItemPayRecordDto>> entry : map.entrySet()) {
                        ItemPayRecordDto itemPayRecordDto = entry.getValue().get(0);
                        itemPayRecordDto.setAmount(entry.getValue().stream().map(ItemPayRecordDto::getAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
                        payRecordDetialDtos.add(itemPayRecordDto);
                    }
                }
                e.setPayRecordDetialDtos((List)payRecordDetialDtos);
            });
        }
        respDto.setTotalVolume(totalVolume.get().setScale(6, 4));
        respDto.setTotalWeight(totalWeight.get().setScale(6, 4));
        respDto.setOrderLineDetails((List)orderLineDetails);
    }

    private void setPayWayName(ChannelOrderDetailRespDto respDto) {
        List payRecordEos;
        DgPerformOrderPaymentDto performOrderPaymentDto = respDto.getPerformOrderPaymentDto();
        if (Objects.nonNull(performOrderPaymentDto) && CollectionUtils.isNotEmpty((Collection)(payRecordEos = this.payRecordDomain.selectListByOrderNo(respDto.getSaleOrderNo())))) {
            List payWays = payRecordEos.stream().map(PayRecordEo::getPayMethodName).distinct().collect(Collectors.toList());
            performOrderPaymentDto.setPayWay(String.join((CharSequence)"\u3001", payWays));
            BigDecimal yfkTotalAmount = payRecordEos.stream().filter(dto -> Objects.equals(dto.getPayStatus(), PayStatusEnum.SUCCESS.getName()) && Objects.equals(dto.getPayMethod(), PayConfigTypeEnum.YFK_ACCOUNT.getType())).map(PayRecordEo::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            respDto.setYfkPayAmount(yfkTotalAmount);
        }
    }

    private void orderRemainingPayAmount(String orderNo, ChannelOrderDetailRespDto respDto) {
        respDto.setRemainingPayAmount(respDto.getPerformOrderPaymentDto().getRemainingPayAmount());
    }

    private void queryCostDetails(ChannelOrderDetailRespDto respDto) {
        if (respDto.getPerformOrderPaymentDto().getTotalUseCostAmount() != null) {
            PayRecordEo payRecordEo = new PayRecordEo();
            payRecordEo.setOrderNo(respDto.getSaleOrderNo());
            payRecordEo.setAccountCategory(AccountCategoryEnum.COST.getCode());
            List payRecordEos = this.payRecordDomain.selectList((BaseEo)payRecordEo);
            List payRecordDtos = BeanUtil.copyToList((Collection)payRecordEos, PayRecordDto.class);
            respDto.setPayRecordDtos(payRecordDtos);
            Set costAccountTypes = payRecordEos.stream().map(PayRecordEo::getPayMethod).collect(Collectors.toSet());
            respDto.setCostAccountTypes(costAccountTypes);
        }
    }

    private void setOrderRepayAmount(ChannelOrderDetailRespDto respDto) {
        String orderStatus = respDto.getOrderStatus();
        DgPerformOrderPaymentDto performOrderPaymentDto = respDto.getPerformOrderPaymentDto();
        if (!Objects.equals(DgSaleOrderTypeEnum.INTACT_GOODS_RECEIVE.getType(), respDto.getOrderType())) {
            DgPerformOrderPaymentEo orderPaymentEo = this.performOrderPaymentDomain.selectByOrderId(respDto.getId());
            performOrderPaymentDto.setRepaymentAmount(orderPaymentEo.getRepaymentAmount());
            performOrderPaymentDto.setRepaymentRebateAmount(orderPaymentEo.getRepaymentRebateAmount());
        }
    }

    private void setHandmadeAmount(ChannelOrderDetailRespDto respDto) {
    }

    @Override
    public DgShopOrderResultRespDto saveOrder(DgBizPerformOrderReqDto dgBizPerformOrderReqDto) {
        DgShopOrderResultRespDto dgShopOrderResultRespDto = new DgShopOrderResultRespDto();
        dgShopOrderResultRespDto.setShopId(dgBizPerformOrderReqDto.getPerformOrderSnapshotDto().getShopId());
        dgShopOrderResultRespDto.setShopCode(dgBizPerformOrderReqDto.getPerformOrderSnapshotDto().getShopCode());
        dgShopOrderResultRespDto.setShopName(dgBizPerformOrderReqDto.getPerformOrderSnapshotDto().getShopName());
        log.info("\u8ba2\u5355\u6301\u4e45\u5316\u5165\u53c2\u4fe1\u606fdgBizPerformOrderReqDto:" + JSON.toJSONString((Object)dgBizPerformOrderReqDto));
        if (dgBizPerformOrderReqDto.getId() == null) {
            DgPerformOrderRespDto performOrderRespDto = this.f2bOrderInfoBizDomain.addF2BSaleOrder(dgBizPerformOrderReqDto);
            log.info("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u8ba2\u5355\u4fdd\u5b58\u6210\u529f\uff0c\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)performOrderRespDto));
            dgShopOrderResultRespDto.setOrderId(performOrderRespDto.getId());
            dgShopOrderResultRespDto.setSaleOrderNo(performOrderRespDto.getSaleOrderNo());
        } else {
            DgPerformOrderRespDto performOrderRespDto = this.f2bOrderInfoBizDomain.updateF2BSaleOrder(dgBizPerformOrderReqDto);
            log.info("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u8ba2\u5355\u4fee\u6539\u6210\u529f\uff0c\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)performOrderRespDto));
            dgShopOrderResultRespDto.setOrderId(performOrderRespDto.getId());
            dgShopOrderResultRespDto.setSaleOrderNo(performOrderRespDto.getSaleOrderNo());
        }
        this.preJoinActivity(dgBizPerformOrderReqDto);
        dgShopOrderResultRespDto.setSucc(true);
        return dgShopOrderResultRespDto;
    }

    public void preJoinActivity(DgBizPerformOrderReqDto dgBizPerformOrderReqDto) {
        if (dgBizPerformOrderReqDto.getActivity() != null && CollectionUtils.isNotEmpty((Collection)dgBizPerformOrderReqDto.getActivity().getActivityList())) {
            List activityList = dgBizPerformOrderReqDto.getActivity().getActivityList();
            activityList.stream().filter(activity -> activity.getDiscountAmount() != null && BigDecimal.ZERO.compareTo(activity.getDiscountAmount()) < 0).forEach(activity -> {
                OrderActivityAddReqDto activityAddReqDto = new OrderActivityAddReqDto();
                activityAddReqDto.setTradeNo(dgBizPerformOrderReqDto.getSaleOrderNo());
                activityAddReqDto.setOrderNo(dgBizPerformOrderReqDto.getSaleOrderNo());
                activityAddReqDto.setUserId(dgBizPerformOrderReqDto.getPerformOrderSnapshotDto().getCustomerId() + "");
                activityAddReqDto.setStatus(Integer.valueOf(0));
                activityAddReqDto.setParentType(activity.getType());
                activityAddReqDto.setType(activity.getType());
                activityAddReqDto.setParentActivityId("0L");
                activityAddReqDto.setActivityId(activity.getActivityId().toString());
                activityAddReqDto.setActivityName(activity.getActivityName());
                activityAddReqDto.setDiscountAmount(activity.getDiscountAmount());
                activityAddReqDto.setExtension(JSON.toJSONString((Object)activity));
                OrderActivityEo orderActivityEo = new OrderActivityEo();
                DtoHelper.dto2Eo((BaseVo)activityAddReqDto, (BaseEo)orderActivityEo);
                this.orderActivityDomain.insert((BaseEo)orderActivityEo);
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<DgOrderLabelEnum> modifyOrderStay(OrderStayReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto.getId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList orderLabelEnumList = Lists.newArrayList();
        DgPerformOrderExtensionEo dgPerformOrderExtensionEo = this.performOrderExtensionDomain.selectByOrderId(reqDto.getId());
        AssertUtils.isFalse((!this.checkOrderStayTime(dgPerformOrderExtensionEo.getStayTime(), reqDto.getStayTime()) ? 1 : 0) != 0, (String)"\u8ba2\u5355\u7559\u5355\u622a\u6b62\u65f6\u95f4\u672a\u6709\u53d8\u5316");
        AssertUtils.isFalse((Objects.nonNull(reqDto.getStayTime()) && reqDto.getStayTime().compareTo(DateUtil.getSysDate()) <= 0 ? 1 : 0) != 0, (String)"\u8ba2\u5355\u622a\u5355\u7559\u5355\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4");
        DgPerformOrderInfoEo dgPerformOrderInfoEo = this.dgPerformOrderInfoDomain.queryEoById(reqDto.getId());
        Date endTime = dgPerformOrderInfoEo.getCloseTime();
        this.performOrderExtensionDomain.updateOrderStayTime(reqDto.getId(), reqDto.getStayTime());
        dgPerformOrderInfoEo.setUpdateTime(new Date());
        this.dgPerformOrderInfoDomain.updateSaleOrderById(dgPerformOrderInfoEo.getId(), dgPerformOrderInfoEo);
        if (Objects.nonNull(reqDto.getStayTime())) {
            orderLabelEnumList.add(DgOrderLabelEnum.STAY);
            endTime = reqDto.getStayTime();
        }
        if (Objects.nonNull(endTime)) {
            Date sysDate = DateUtil.getSysDate();
            if (endTime.compareTo(sysDate) <= 0) {
                endTime = DateUtil.addMinutes((Date)sysDate, (int)2);
            }
            this.scheduleService.addOrderTask(dgPerformOrderInfoEo.getSaleOrderNo(), TradeSchedulerEnum.F2B_AUTO_CANCEL_ORDER, endTime, -1L, -1L);
        }
        return orderLabelEnumList;
    }

    private boolean checkOrderStayTime(Date oldStayTime, Date newStayTime) {
        if (oldStayTime == newStayTime) {
            return false;
        }
        return oldStayTime == null || newStayTime == null || oldStayTime.compareTo(newStayTime) != 0;
    }
}

