/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.common.Impl;

import cn.hutool.core.collection.CollectionUtil;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.service.oms.common.ICalculateAmountService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CalculateAmountServiceImpl
implements ICalculateAmountService {
    private static final Logger log = LoggerFactory.getLogger(CalculateAmountServiceImpl.class);

    @Override
    public Map<Long, BigDecimal> calculateOrderLineBasicAmount(List<DgPerformOrderLineDto> orderLineDtos, String type) {
        HashMap<Long, BigDecimal> orderLineAmountMap = new HashMap<Long, BigDecimal>();
        for (DgPerformOrderLineDto orderLineDto : orderLineDtos) {
            if (CollectionUtil.isNotEmpty((Collection)orderLineDto.getAmountDtoList())) {
                List amountDtoList = orderLineDto.getAmountDtoList().stream().filter(amount -> amount.getAccountType().equals(type)).collect(Collectors.toList());
                if (!CollectionUtil.isNotEmpty(amountDtoList)) continue;
                BigDecimal amount2 = amountDtoList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                orderLineAmountMap.put(orderLineDto.getId(), amount2);
                continue;
            }
            log.info("\u8ba2\u5355\u884c\uff1a{} \u91d1\u989d\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)orderLineDto.getId());
        }
        return orderLineAmountMap;
    }

    @Override
    public Map<Long, BigDecimal> calculateOrderLineBasicAmount(List<DgPerformOrderLineDto> orderLineDtos, String source, String type) {
        HashMap<Long, BigDecimal> orderLineAmountMap = new HashMap<Long, BigDecimal>();
        for (DgPerformOrderLineDto orderLineDto : orderLineDtos) {
            if (CollectionUtil.isNotEmpty((Collection)orderLineDto.getAmountDtoList())) {
                List amountDtoList = orderLineDto.getAmountDtoList().stream().filter(amount -> amount.getAmountSource().equals(source) && amount.getAccountType().equals(type)).collect(Collectors.toList());
                if (!CollectionUtil.isNotEmpty(amountDtoList)) continue;
                BigDecimal amount2 = amountDtoList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                orderLineAmountMap.put(orderLineDto.getId(), amount2);
                continue;
            }
            log.info("\u8ba2\u5355\u884c\uff1a{} \u91d1\u989d\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)orderLineDto.getId());
        }
        return orderLineAmountMap;
    }
}

