/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.orderStrategy.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.account.dto.entity.AccountTypeDto;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountTypeApiProxy;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerSearchListReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerTypeQueryReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgTobCustomerAreaQueryReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgTobCustomerGroupQueryReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgTobCustomerLevelQueryReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCompanyAndCustomerInfoRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerSearchListRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerTypeRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgTobCustomerAreaRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgTobCustomerGroupRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgTobCustomerLevelRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCustomerGroupQueryApiProxy;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCustomerQueryApiProxy;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCustomerTypeQueryApiProxy;
import com.yunxi.dg.base.center.customer.proxy.query.IDgTobCustomerLevelQueryApiProxy;
import com.yunxi.dg.base.center.customer.proxy.query.ITransactionCustomerQueryApiProxy;
import com.yunxi.dg.base.center.customer.proxy.query.impl.DgTobCustomerAreaQueryApiProxyImpl;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyConfItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyRuleSuitTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfItemSuitDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleSuitDomain;
import com.yunxi.dg.base.center.trade.dto.strategy.DgAccountApplyStrategyRuleRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgAccountPayScaleDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgAccountStrategyRuleRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgBizStrategyRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgMatchStrategyResultDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyRuleRespDto;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleEo;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleSuitEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemSuitEo;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgAccountPayScaleRuleService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgPolicySubRuleProcessingLogicService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgStrategyPoolService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.impl.DgStrategyRuleServiceImpl;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class DgAccountPayScaleRuleServiceImpl
extends DgStrategyRuleServiceImpl
implements IDgAccountPayScaleRuleService {
    private static final Logger log = LoggerFactory.getLogger(DgAccountPayScaleRuleServiceImpl.class);
    @Resource
    private IDgStrategyPoolService dgStrategyPoolService;
    @Resource
    private IDgPolicySubRuleProcessingLogicService dgPolicySubRuleProcessingLogicService;
    @Resource
    private IDgStrategyRuleDomain strategyRuleDas;
    @Resource
    private IDgStrategyRuleSuitDomain strategyRuleSuitDas;
    @Resource
    private IDgStrategyConfItemSuitDomain strategyConfItemSuitDas;
    @Resource
    private IAccountTypeApiProxy accountTypeApi;
    @Resource
    private IDgCustomerQueryApiProxy customerQueryApiProxy;
    @Resource
    private DgTobCustomerAreaQueryApiProxyImpl dgTobCustomerAreaQueryApiProxy;
    @Resource
    private IDgTobCustomerLevelQueryApiProxy dgTobCustomerLevelQueryApiProxy;
    @Resource
    private IDgCustomerGroupQueryApiProxy dgCustomerGroupQueryApiProxy;
    @Resource
    private IDgCustomerTypeQueryApiProxy dgCustomerTypeQueryApiProxy;
    @Resource
    private ITransactionCustomerQueryApiProxy transactionCustomerQueryApiProxy;

    @Override
    public PageInfo<DgAccountStrategyRuleRespDto> queryByAccountPage(DgBizStrategyRuleReqDto strategyRuleReqDto, Integer pageNum, Integer pageSize) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        if (strategyRuleReqDto.getRuleStatus() != null) {
            queryWrapper.eq(DgStrategyRuleEo::getRuleStatus, (Object)strategyRuleReqDto.getRuleStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getStrategyType())) {
            queryWrapper.eq(DgStrategyRuleEo::getStrategyType, (Object)strategyRuleReqDto.getStrategyType());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getCreateStartTime())) {
            ((LambdaQueryWrapper)queryWrapper.ge(BaseEo::getCreateTime, (Object)strategyRuleReqDto.getCreateStartTime())).le(BaseEo::getCreateTime, (Object)strategyRuleReqDto.getCreateEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getUpdateStartTime())) {
            ((LambdaQueryWrapper)queryWrapper.ge(BaseEo::getUpdateTime, (Object)strategyRuleReqDto.getUpdateStartTime())).le(BaseEo::getUpdateTime, (Object)strategyRuleReqDto.getUpdateEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getPlatForm())) {
            queryWrapper.eq(DgStrategyRuleEo::getPlatForm, (Object)strategyRuleReqDto.getPlatForm());
        }
        if (CollectionUtils.isNotEmpty((Collection)strategyRuleReqDto.getLabelNameList())) {
            queryWrapper.in(DgStrategyRuleEo::getLabelName, (Collection)strategyRuleReqDto.getLabelNameList());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getRuleName()) || StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getRuleCode())) {
            queryWrapper.and(wrapper -> ((LambdaQueryWrapper)wrapper.like(DgStrategyRuleEo::getRuleName, (Object)("%" + strategyRuleReqDto.getRuleName() + "%"))).or(wp -> wp.like(DgStrategyRuleEo::getRuleCode, (Object)("%" + strategyRuleReqDto.getRuleCode() + "%"))));
        }
        queryWrapper.orderByDesc(BaseEo::getUpdateTime);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List dgStrategyRuleEos = this.dgStrategyRuleDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)dgStrategyRuleEos)) {
            return new PageInfo();
        }
        PageInfo info = new PageInfo(dgStrategyRuleEos);
        PageInfo dtoPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)dtoPageInfo);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)info, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<DgAccountStrategyRuleRespDto> dtoList = new ArrayList<DgAccountStrategyRuleRespDto>();
        DtoHelper.eoList2DtoList((Collection)info.getList(), dtoList, DgAccountStrategyRuleRespDto.class);
        this.setApplyNameInfo(dtoList);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private void setApplyNameInfo(List<DgAccountStrategyRuleRespDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List ids = dtoList.stream().map(DgStrategyRuleRespDto::getId).collect(Collectors.toList());
        LambdaQueryWrapper queryStrategyRuleSuitEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyRuleSuitEo.eq(BaseEo::getDr, (Object)0)).in(DgStrategyRuleSuitEo::getRuleId, ids);
        List strategyRuleSuitList = this.strategyRuleSuitDas.list(queryStrategyRuleSuitEo);
        if (CollectionUtils.isEmpty((Collection)strategyRuleSuitList)) {
            return;
        }
        HashMap<String, DgCustomerSearchListRespDto> customerMap = new HashMap<String, DgCustomerSearchListRespDto>();
        HashMap<Long, DgTobCustomerAreaRespDto> customerAreaMap = new HashMap<Long, DgTobCustomerAreaRespDto>();
        HashMap<Long, DgCustomerTypeRespDto> customerTypeMap = new HashMap<Long, DgCustomerTypeRespDto>();
        HashMap<Long, DgTobCustomerLevelRespDto> customerGradeMap = new HashMap<Long, DgTobCustomerLevelRespDto>();
        HashMap<Long, DgTobCustomerGroupRespDto> customerGroupMap = new HashMap<Long, DgTobCustomerGroupRespDto>();
        this.getApiInfoToMap(strategyRuleSuitList, customerMap, customerAreaMap, customerTypeMap, customerGradeMap, customerGroupMap);
        Map<Long, List<DgStrategyRuleSuitEo>> suitGroupMap = strategyRuleSuitList.stream().collect(Collectors.groupingBy(DgStrategyRuleSuitEo::getRuleId));
        for (DgAccountStrategyRuleRespDto dto : dtoList) {
            if (suitGroupMap.isEmpty() || !suitGroupMap.containsKey(dto.getId())) continue;
            List<DgStrategyRuleSuitEo> dgStrategyRuleSuitEos = suitGroupMap.get(dto.getId());
            Map<String, List<DgStrategyRuleSuitEo>> ruleSuitMap = dgStrategyRuleSuitEos.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getSuitType())).collect(Collectors.groupingBy(DgStrategyRuleSuitEo::getSuitType));
            for (String k : ruleSuitMap.keySet()) {
                this.setRuleSuitApply(customerMap, customerAreaMap, customerTypeMap, customerGradeMap, customerGroupMap, dto, ruleSuitMap, k);
            }
        }
    }

    private void setRuleSuitApply(Map<String, DgCustomerSearchListRespDto> customerMap, Map<Long, DgTobCustomerAreaRespDto> customerAreaMap, Map<Long, DgCustomerTypeRespDto> customerTypeMap, Map<Long, DgTobCustomerLevelRespDto> customerGradeMap, Map<Long, DgTobCustomerGroupRespDto> customerGroupMap, DgAccountStrategyRuleRespDto dto, Map<String, List<DgStrategyRuleSuitEo>> ruleSuitMap, String k) {
        List<DgStrategyRuleSuitEo> v = ruleSuitMap.get(k);
        DgStrategyRuleSuitTypeEnum dgStrategyRuleSuitTypeEnum = DgStrategyRuleSuitTypeEnum.forCode((String)k);
        switch (dgStrategyRuleSuitTypeEnum) {
            case SUITTYPE_CLEINT: {
                DgAccountStrategyRuleRespDto.ApplyCodeName applyClient = new DgAccountStrategyRuleRespDto.ApplyCodeName();
                DgStrategyRuleSuitEo dgStrategyClientRuleSuitEo = v.get(0);
                this.extractedAttributeAssignment(v, dgStrategyClientRuleSuitEo, (DgAccountStrategyRuleRespDto.Apply)applyClient);
                this.setCustomerInfoByMap(applyClient, customerMap);
                dto.setApplyClient(applyClient);
                break;
            }
            case SUITTYPE_BUSINESS_AREA: {
                DgAccountStrategyRuleRespDto.ApplyCodeName applyClientArea = new DgAccountStrategyRuleRespDto.ApplyCodeName();
                DgStrategyRuleSuitEo dgStrategyClientAreaRuleSuitEo = v.get(0);
                this.extractedAttributeAssignment(v, dgStrategyClientAreaRuleSuitEo, (DgAccountStrategyRuleRespDto.Apply)applyClientArea);
                this.setCustomerAreaByMap(applyClientArea, customerAreaMap);
                dto.setApplyBusinessArea(applyClientArea);
                break;
            }
            case SUITTYPE_CLIENT_TYPE: {
                DgAccountStrategyRuleRespDto.ApplyCodeName applyClientType = new DgAccountStrategyRuleRespDto.ApplyCodeName();
                DgStrategyRuleSuitEo dgStrategyClientTypeRuleSuitEo = v.get(0);
                this.extractedAttributeAssignment(v, dgStrategyClientTypeRuleSuitEo, (DgAccountStrategyRuleRespDto.Apply)applyClientType);
                this.setCustomerTypeByMap(applyClientType, customerTypeMap);
                dto.setApplyClientType(applyClientType);
                break;
            }
            case SUITTYPE_CLIENT_GRADE: {
                DgAccountStrategyRuleRespDto.ApplyCodeName applyClientGrade = new DgAccountStrategyRuleRespDto.ApplyCodeName();
                DgStrategyRuleSuitEo dgStrategyClientGeadeRuleSuitEo = v.get(0);
                this.extractedAttributeAssignment(v, dgStrategyClientGeadeRuleSuitEo, (DgAccountStrategyRuleRespDto.Apply)applyClientGrade);
                this.setCustomerGradeByMap(applyClientGrade, customerGradeMap);
                dto.setApplyClientGrade(applyClientGrade);
                break;
            }
            case SUITTYPE_CLIENT_GROUP: {
                DgAccountStrategyRuleRespDto.ApplyCodeName applyClientGroup = new DgAccountStrategyRuleRespDto.ApplyCodeName();
                DgStrategyRuleSuitEo dgStrategyClientGroupRuleSuitEo = v.get(0);
                this.extractedAttributeAssignment(v, dgStrategyClientGroupRuleSuitEo, (DgAccountStrategyRuleRespDto.Apply)applyClientGroup);
                this.setCustomerGroupByMap(applyClientGroup, customerGroupMap);
                dto.setApplyClientGroup(applyClientGroup);
                break;
            }
        }
    }

    private void getApiInfoToMap(List<DgStrategyRuleSuitEo> strategyRuleSuitList, Map<String, DgCustomerSearchListRespDto> customerMap, Map<Long, DgTobCustomerAreaRespDto> customerAreaMap, Map<Long, DgCustomerTypeRespDto> customerTypeMap, Map<Long, DgTobCustomerLevelRespDto> customerGradeMap, Map<Long, DgTobCustomerGroupRespDto> customerGroupMap) {
        DgTobCustomerAreaQueryReqDto searchDto;
        List idList;
        HashSet<String> customerCodeSet = new HashSet<String>();
        HashSet<String> customerAreaSet = new HashSet<String>();
        HashSet<String> customerTypeSet = new HashSet<String>();
        HashSet<String> customerGradeSet = new HashSet<String>();
        HashSet<String> customerGroupSet = new HashSet<String>();
        for (DgStrategyRuleSuitEo dgStrategyRuleSuitEo : strategyRuleSuitList) {
            DgStrategyRuleSuitTypeEnum dgStrategyRuleSuitTypeEnum = DgStrategyRuleSuitTypeEnum.forCode((String)dgStrategyRuleSuitEo.getSuitType());
            if (!StringUtils.equals((CharSequence)dgStrategyRuleSuitEo.getSuitSelectType(), (CharSequence)SELECT)) continue;
            switch (dgStrategyRuleSuitTypeEnum) {
                case SUITTYPE_CLEINT: {
                    customerCodeSet.add(dgStrategyRuleSuitEo.getSuitKey());
                    break;
                }
                case SUITTYPE_BUSINESS_AREA: {
                    customerAreaSet.add(dgStrategyRuleSuitEo.getSuitKey());
                    break;
                }
                case SUITTYPE_CLIENT_TYPE: {
                    customerTypeSet.add(dgStrategyRuleSuitEo.getSuitKey());
                    break;
                }
                case SUITTYPE_CLIENT_GRADE: {
                    customerGradeSet.add(dgStrategyRuleSuitEo.getSuitKey());
                    break;
                }
                case SUITTYPE_CLIENT_GROUP: {
                    customerGroupSet.add(dgStrategyRuleSuitEo.getSuitKey());
                    break;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(customerCodeSet)) {
            DgCustomerSearchListReqDto dgCustomerSearchListReqDto = new DgCustomerSearchListReqDto();
            dgCustomerSearchListReqDto.setCustomerCodeList(new ArrayList(customerCodeSet));
            List dgCustomerSearchListRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApiProxy.queryList(dgCustomerSearchListReqDto));
            if (CollectionUtils.isNotEmpty((Collection)dgCustomerSearchListRespDtos)) {
                customerMap.putAll(dgCustomerSearchListRespDtos.stream().collect(Collectors.toMap(DgCustomerSearchListRespDto::getCode, Function.identity(), (k1, k2) -> k1)));
            }
        }
        if (CollectionUtils.isNotEmpty(customerAreaSet)) {
            idList = customerAreaSet.stream().map(x -> Long.valueOf(x)).collect(Collectors.toList());
            searchDto = new DgTobCustomerAreaQueryReqDto();
            searchDto.setIds(idList);
            List dgTobCustomerAreaRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgTobCustomerAreaQueryApiProxy.queryList(searchDto));
            if (CollectionUtils.isNotEmpty((Collection)dgTobCustomerAreaRespDtos)) {
                customerAreaMap.putAll(dgTobCustomerAreaRespDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (k1, k2) -> k1)));
            }
        }
        if (CollectionUtils.isNotEmpty(customerTypeSet)) {
            idList = customerTypeSet.stream().map(x -> Long.valueOf(x)).collect(Collectors.toList());
            searchDto = new DgCustomerTypeQueryReqDto();
            searchDto.setIds(idList);
            List dgCustomerTypeRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgCustomerTypeQueryApiProxy.queryList((DgCustomerTypeQueryReqDto)searchDto));
            if (CollectionUtils.isNotEmpty((Collection)dgCustomerTypeRespDtos)) {
                customerTypeMap.putAll(dgCustomerTypeRespDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (k1, k2) -> k1)));
            }
        }
        if (CollectionUtils.isNotEmpty(customerGradeSet)) {
            idList = customerGradeSet.stream().map(x -> Long.valueOf(x)).collect(Collectors.toList());
            searchDto = new DgTobCustomerLevelQueryReqDto();
            searchDto.setIds(idList);
            List customerLevelRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgTobCustomerLevelQueryApiProxy.queryList((DgTobCustomerLevelQueryReqDto)searchDto));
            if (CollectionUtils.isNotEmpty((Collection)customerLevelRespDtos)) {
                customerGradeMap.putAll(customerLevelRespDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (k1, k2) -> k1)));
            }
        }
        if (CollectionUtils.isNotEmpty(customerGroupSet)) {
            idList = customerGroupSet.stream().map(x -> Long.valueOf(x)).collect(Collectors.toList());
            searchDto = new DgTobCustomerGroupQueryReqDto();
            searchDto.setIds(idList);
            List customerGroupRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgCustomerGroupQueryApiProxy.queryList((DgTobCustomerGroupQueryReqDto)searchDto));
            if (CollectionUtils.isNotEmpty((Collection)customerGroupRespDtos)) {
                customerGroupMap.putAll(customerGroupRespDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (k1, k2) -> k1)));
            }
        }
    }

    @Override
    public DgAccountStrategyRuleRespDto queryStrategyByType(Long id, String strategyType) {
        List list;
        LambdaQueryWrapper queryStrategyRuleEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyRuleEo.eq(BaseEo::getDr, (Object)0)).eq(DgStrategyRuleEo::getStrategyType, (Object)strategyType);
        if (Objects.nonNull(id)) {
            queryStrategyRuleEo.eq(BaseEo::getId, (Object)id);
        }
        if (CollectionUtils.isEmpty((Collection)(list = this.strategyRuleDas.list(queryStrategyRuleEo)))) {
            log.info("\u6839\u636e\u7b56\u7565\u7c7b\u578b\u67e5\u8be2\u7b56\u7565\u4e0d\u5b58\u5728");
            return null;
        }
        DgStrategyRuleEo dgStrategyRuleEo = (DgStrategyRuleEo)list.get(0);
        id = dgStrategyRuleEo.getId();
        DgAccountStrategyRuleRespDto strategyRuleRespDto = new DgAccountStrategyRuleRespDto();
        DtoHelper.eo2Dto((BaseEo)dgStrategyRuleEo, (BaseVo)strategyRuleRespDto);
        this.getStrategyConfItems(id, strategyRuleRespDto);
        LambdaQueryWrapper queryStrategyRuleSuitEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyRuleSuitEo.eq(BaseEo::getDr, (Object)0)).eq(DgStrategyRuleSuitEo::getRuleId, (Object)id);
        List strategyRuleSuitList = this.strategyRuleSuitDas.list(queryStrategyRuleSuitEo);
        HashMap<String, DgCustomerSearchListRespDto> customerMap = new HashMap<String, DgCustomerSearchListRespDto>();
        HashMap<Long, DgTobCustomerAreaRespDto> customerAreaMap = new HashMap<Long, DgTobCustomerAreaRespDto>();
        HashMap<Long, DgCustomerTypeRespDto> customerTypeMap = new HashMap<Long, DgCustomerTypeRespDto>();
        HashMap<Long, DgTobCustomerLevelRespDto> customerGradeMap = new HashMap<Long, DgTobCustomerLevelRespDto>();
        HashMap<Long, DgTobCustomerGroupRespDto> customerGroupMap = new HashMap<Long, DgTobCustomerGroupRespDto>();
        this.getApiInfoToMap(strategyRuleSuitList, customerMap, customerAreaMap, customerTypeMap, customerGradeMap, customerGroupMap);
        Map<String, List<DgStrategyRuleSuitEo>> ruleSuitMap = strategyRuleSuitList.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getSuitType())).collect(Collectors.groupingBy(DgStrategyRuleSuitEo::getSuitType));
        for (String k : ruleSuitMap.keySet()) {
            this.setRuleSuitApply(customerMap, customerAreaMap, customerTypeMap, customerGradeMap, customerGroupMap, strategyRuleRespDto, ruleSuitMap, k);
        }
        return strategyRuleRespDto;
    }

    private void getStrategyConfItems(Long id, DgAccountStrategyRuleRespDto strategyRuleRespDto) {
        LambdaQueryWrapper queryStrategyConfItemEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyConfItemEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemEo::getRuleId, (Object)id);
        List strategyConfItemEoList = this.dgStrategyConfItemDomain.list(queryStrategyConfItemEo);
        AssertUtils.notEmpty((Collection)strategyConfItemEoList, (String)"\u7b56\u7565\u914d\u7f6e\u9879\u4e3a\u7a7a");
        LambdaQueryWrapper queryStrategyConfItemSuitEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyConfItemSuitEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemSuitEo::getRuleId, (Object)id);
        List strategyConfItemSuitEoList = this.strategyConfItemSuitDas.list(queryStrategyConfItemSuitEo);
        Map<String, List<StrategyConfItemSuitEo>> strategyConfItemSuitMap = Optional.ofNullable(strategyConfItemSuitEoList).orElseGet(Collections::emptyList).stream().collect(Collectors.groupingBy(StrategyConfItemSuitEo::getSuitType));
        for (StrategyConfItemEo strategyConfItemEo : strategyConfItemEoList) {
            List accountTypeDtos;
            if (!StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.ACCOUNT_PAY_SCALE.getCode()) && !StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)DgStrategyConfItemTypeEnum.ACCOUNT_PAY_SCALE_CUSTOMER.getCode())) continue;
            DgAccountStrategyRuleRespDto.SpecialAccountPayScale accountPayScale = new DgAccountStrategyRuleRespDto.SpecialAccountPayScale();
            CubeBeanUtils.copyProperties((Object)accountPayScale, (Object)strategyConfItemEo, (String[])new String[0]);
            accountPayScale.setEnable(strategyConfItemEo.getEnable());
            List<StrategyConfItemSuitEo> confItemSuitEos = strategyConfItemSuitMap.get(strategyConfItemEo.getStrategyType());
            List codeList = confItemSuitEos.stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
            Map<Object, Object> accountTypeMap = new HashMap();
            if (CollectionUtils.isNotEmpty(codeList) && CollectionUtils.isNotEmpty((Collection)(accountTypeDtos = (List)RestResponseHelper.extractData((RestResponse)this.accountTypeApi.queryByCodes(codeList))))) {
                accountTypeMap = accountTypeDtos.stream().collect(Collectors.toMap(AccountTypeDto::getAccountTypeCode, AccountTypeDto::getCustomName));
            }
            ArrayList accountPayScaleList = Lists.newArrayList();
            for (StrategyConfItemSuitEo confItemSuitEo : confItemSuitEos) {
                DgAccountPayScaleDto dgAccountPayScaleDto = new DgAccountPayScaleDto();
                dgAccountPayScaleDto.setAccountCode(confItemSuitEo.getSuitValue());
                if (!accountTypeMap.isEmpty() && accountTypeMap.containsKey(dgAccountPayScaleDto.getAccountCode())) {
                    dgAccountPayScaleDto.setAccountName((String)accountTypeMap.get(dgAccountPayScaleDto.getAccountCode()));
                }
                dgAccountPayScaleDto.setScaleValue(confItemSuitEo.getExtension());
                accountPayScaleList.add(dgAccountPayScaleDto);
            }
            accountPayScale.setAccountPayScaleList((List)accountPayScaleList);
            strategyRuleRespDto.setAccountPayScale(accountPayScale);
        }
    }

    private void extractedAttributeAssignment(List<DgStrategyRuleSuitEo> strategyRuleSuitList, DgStrategyRuleSuitEo dgStrategyRuleSuitEo, DgAccountStrategyRuleRespDto.Apply apply) {
        apply.setApplicableType(dgStrategyRuleSuitEo.getSuitSelectType());
        if (StringUtils.equals((CharSequence)dgStrategyRuleSuitEo.getSuitSelectType(), (CharSequence)SELECT)) {
            List codeList = strategyRuleSuitList.stream().map(DgStrategyRuleSuitEo::getSuitKey).collect(Collectors.toList());
            apply.setApplicableList(codeList);
        }
    }

    private void setCustomerInfoByMap(DgAccountStrategyRuleRespDto.ApplyCodeName applyCodeName, Map<String, DgCustomerSearchListRespDto> customerMap) {
        List codeList = applyCodeName.getApplicableList();
        if (CollectionUtils.isEmpty((Collection)codeList) || customerMap.isEmpty()) {
            return;
        }
        ArrayList applyList = Lists.newArrayList();
        for (String code : codeList) {
            if (!customerMap.containsKey(code)) continue;
            DgCustomerSearchListRespDto dgCustomerSearchListRespDto = customerMap.get(code);
            DgAccountApplyStrategyRuleRespDto accountApplyDto = new DgAccountApplyStrategyRuleRespDto();
            accountApplyDto.setCode(dgCustomerSearchListRespDto.getCode());
            accountApplyDto.setName(dgCustomerSearchListRespDto.getName());
            applyList.add(accountApplyDto);
        }
        applyCodeName.setApplyList((List)applyList);
    }

    private void setCustomerAreaByMap(DgAccountStrategyRuleRespDto.ApplyCodeName applyCodeName, Map<Long, DgTobCustomerAreaRespDto> customerAreaMap) {
        List codeList = applyCodeName.getApplicableList();
        if (CollectionUtils.isEmpty((Collection)codeList) || customerAreaMap.isEmpty()) {
            return;
        }
        List idList = codeList.stream().map(x -> Long.valueOf(x)).collect(Collectors.toList());
        ArrayList applyList = Lists.newArrayList();
        for (Long id : idList) {
            if (!customerAreaMap.containsKey(id)) continue;
            DgTobCustomerAreaRespDto dto = customerAreaMap.get(id);
            DgAccountApplyStrategyRuleRespDto accountApplyDto = new DgAccountApplyStrategyRuleRespDto();
            accountApplyDto.setId(dto.getId());
            accountApplyDto.setCode(dto.getCode());
            accountApplyDto.setName(dto.getName());
            applyList.add(accountApplyDto);
        }
        applyCodeName.setApplyList((List)applyList);
    }

    private void setCustomerTypeByMap(DgAccountStrategyRuleRespDto.ApplyCodeName applyCodeName, Map<Long, DgCustomerTypeRespDto> customerTypeMap) {
        List codeList = applyCodeName.getApplicableList();
        if (CollectionUtils.isEmpty((Collection)codeList) || customerTypeMap.isEmpty()) {
            return;
        }
        List idList = codeList.stream().map(x -> Long.valueOf(x)).collect(Collectors.toList());
        ArrayList applyList = Lists.newArrayList();
        for (Long id : idList) {
            if (!customerTypeMap.containsKey(id)) continue;
            DgCustomerTypeRespDto dto = customerTypeMap.get(id);
            DgAccountApplyStrategyRuleRespDto accountApplyDto = new DgAccountApplyStrategyRuleRespDto();
            accountApplyDto.setId(dto.getId());
            accountApplyDto.setCode(dto.getCode());
            accountApplyDto.setName(dto.getName());
            applyList.add(accountApplyDto);
        }
        applyCodeName.setApplyList((List)applyList);
    }

    private void setCustomerGradeByMap(DgAccountStrategyRuleRespDto.ApplyCodeName applyCodeName, Map<Long, DgTobCustomerLevelRespDto> customerGradeMap) {
        List codeList = applyCodeName.getApplicableList();
        if (CollectionUtils.isEmpty((Collection)codeList) || customerGradeMap.isEmpty()) {
            return;
        }
        List idList = codeList.stream().map(x -> Long.valueOf(x)).collect(Collectors.toList());
        ArrayList applyList = Lists.newArrayList();
        for (Long id : idList) {
            if (!customerGradeMap.containsKey(id)) continue;
            DgTobCustomerLevelRespDto dto = customerGradeMap.get(id);
            DgAccountApplyStrategyRuleRespDto accountApplyDto = new DgAccountApplyStrategyRuleRespDto();
            accountApplyDto.setId(dto.getId());
            accountApplyDto.setCode(dto.getCode());
            accountApplyDto.setName(dto.getName());
            applyList.add(accountApplyDto);
        }
        applyCodeName.setApplyList((List)applyList);
    }

    private void setCustomerGroupByMap(DgAccountStrategyRuleRespDto.ApplyCodeName applyCodeName, Map<Long, DgTobCustomerGroupRespDto> customerGroupMap) {
        List codeList = applyCodeName.getApplicableList();
        if (CollectionUtils.isEmpty((Collection)codeList) || customerGroupMap.isEmpty()) {
            return;
        }
        List idList = codeList.stream().map(x -> Long.valueOf(x)).collect(Collectors.toList());
        ArrayList applyList = Lists.newArrayList();
        for (Long id : idList) {
            if (!customerGroupMap.containsKey(id)) continue;
            DgTobCustomerGroupRespDto dto = customerGroupMap.get(id);
            DgAccountApplyStrategyRuleRespDto accountApplyDto = new DgAccountApplyStrategyRuleRespDto();
            accountApplyDto.setId(dto.getId());
            accountApplyDto.setCode(dto.getErpCode());
            accountApplyDto.setName(dto.getGroupName());
            applyList.add(accountApplyDto);
        }
        applyCodeName.setApplyList((List)applyList);
    }

    @Override
    public DgMatchStrategyResultDto matchOrderStrtegyOfAccout(Long customerId) {
        AssertUtils.notNull((Object)customerId, (String)"customerId \u4e0d\u80fd\u4e3a\u7a7a");
        DgCompanyAndCustomerInfoRespDto dgCustomerRespDto = (DgCompanyAndCustomerInfoRespDto)RestResponseHelper.extractData((RestResponse)this.transactionCustomerQueryApiProxy.getCompanyCustomerInfo(customerId));
        AssertUtils.notNull((Object)dgCustomerRespDto, (String)String.format("customerId=%s\u7684\u5ba2\u6237\u4e0d\u5b58\u5728", customerId));
        log.info("[\u81ea\u52a8\u7b56\u7565]\u5ba2\u6237\uff08customerId={}\uff09\u7684\u8be6\u60c5\u4e3a\uff1a{}", (Object)customerId, (Object)JSON.toJSONString((Object)dgCustomerRespDto));
        return null;
    }
}

