/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.orderStrategy.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.MD5Util;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ItemPromotionDto;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.CisStrategyContentTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgPlatFormEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyConfItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyFeeScaleTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyRuleSuitTypeEnum;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.cost.AccountPreviewDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgFeeScaleStrategyRulePageQueryReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgFeeScaleStrategyRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgFeeScaleStrategyRuleRestDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgMatchStrategyResultDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgOrderFeeAmountDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgOrderFeeScaleControllerReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyRuleFeeScaleRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyRuleRespDto;
import com.yunxi.dg.base.center.trade.enums.GiftEnum;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleEo;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleSuitEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemSuitEo;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgFeeScaleStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.impl.DgStrategyRuleServiceImpl;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.FeeScaleTypeUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateInUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class DgFeeScaleStrategyRuleServiceImpl
extends DgStrategyRuleServiceImpl
implements IDgFeeScaleStrategyRuleService {
    private static Logger logger = LoggerFactory.getLogger(DgFeeScaleStrategyRuleServiceImpl.class);
    @Resource
    private NoGreateInUtil noGreateInUtil;
    @Resource
    private FeeScaleTypeUtils feeScaleTypeUtils;

    @Override
    public Long addFeeScaleStrategyRule(DgFeeScaleStrategyRuleReqDto addReqDto) {
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgStrategyRuleDomain.filter().eq((Object)"dr", (Object)0)).eq(StringUtils.isNotEmpty((CharSequence)addReqDto.getRuleName()), (Object)"rule_name", (Object)addReqDto.getRuleName())).eq(StringUtils.isNotEmpty((CharSequence)addReqDto.getPlatForm()), (Object)"plat_form", (Object)addReqDto.getPlatForm())).list();
        if (list.size() >= 1) {
            throw new BizException("\u89c4\u5219\u540d\u79f0\u5df2\u91cd\u590d\u8bf7\u6838\u5b9e");
        }
        DgStrategyRuleEo dgStrategyRuleEo = new DgStrategyRuleEo();
        CubeBeanUtils.copyProperties((Object)dgStrategyRuleEo, (Object)addReqDto, (String[])new String[0]);
        dgStrategyRuleEo.setRuleCode(this.noGreateInUtil.generateFeeScaleNo());
        dgStrategyRuleEo.setStrategyType(DgCisStrategyOrderTypeEnum.FEE_SCALE_CONTROL.getCode());
        dgStrategyRuleEo.setPlatForm(DgPlatFormEnum.PLATFORM_F2B.getCode());
        if (Objects.isNull(addReqDto.getPriority())) {
            dgStrategyRuleEo.setPriority(Integer.valueOf(1));
        }
        if (Objects.isNull(addReqDto.getPeriodicStart())) {
            dgStrategyRuleEo.setPeriodicStart(DateUtil.getSysDate());
        }
        if (Objects.isNull(addReqDto.getPeriodicEnd())) {
            dgStrategyRuleEo.setPeriodicEnd(DateUtil.addYear((Date)DateUtil.getSysDate(), (int)100));
        }
        this.dgStrategyRuleDomain.insert((BaseEo)dgStrategyRuleEo);
        ArrayList confItemEoList = Lists.newArrayList();
        ArrayList strategyConfItemSuitEoList = Lists.newArrayList();
        this.extractedDealInsertData(addReqDto, dgStrategyRuleEo, confItemEoList, strategyConfItemSuitEoList);
        this.dgStrategyConfItemDomain.insertBatch((List)confItemEoList);
        this.dgStrategyConfItemSuitDomain.insertBatch((List)strategyConfItemSuitEoList);
        ArrayList dgStrategyRuleSuitEoList = Lists.newArrayList();
        this.popStrategyRuleSuits(addReqDto, dgStrategyRuleEo, dgStrategyRuleSuitEoList);
        this.dgStrategyRuleSuitDomain.insertBatch((List)dgStrategyRuleSuitEoList);
        return dgStrategyRuleEo.getId();
    }

    @Override
    public void modifyFeeScaleStrategyRule(DgFeeScaleStrategyRuleReqDto modifyReqDto) {
        AssertUtils.notNull((Object)modifyReqDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        DgStrategyRuleEo newDgStrategyRuleEo = new DgStrategyRuleEo();
        CubeBeanUtils.copyProperties((Object)newDgStrategyRuleEo, (Object)modifyReqDto, (String[])new String[0]);
        this.dgStrategyRuleDomain.updateSelective((BaseEo)newDgStrategyRuleEo);
        this.modifyStrategyConfItems(modifyReqDto);
        this.extractedModifyRange(modifyReqDto);
    }

    private void modifyStrategyConfItems(DgFeeScaleStrategyRuleReqDto modifyReqDto) {
        LambdaQueryWrapper queryStrategyConfItemEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyConfItemEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemEo::getRuleId, (Object)modifyReqDto.getId());
        List strategyConfItemEoList = this.dgStrategyConfItemDomain.list(queryStrategyConfItemEo);
        Map<String, StrategyConfItemEo> groupStrategyMap = strategyConfItemEoList.stream().collect(Collectors.toMap(StrategyConfItemEo::getStrategyType, Function.identity(), (v1, v2) -> v2));
        this.extractedDealModifyData(modifyReqDto, groupStrategyMap);
    }

    private void extractedDealModifyData(DgFeeScaleStrategyRuleReqDto modifyReqDto, Map<String, StrategyConfItemEo> groupStrategyMap) {
        Map keyMap = DgStrategyFeeScaleTypeEnum.NAME_LOOKUP;
        try {
            Field[] fields;
            Long id = modifyReqDto.getId();
            Class<DgFeeScaleStrategyRuleReqDto> clazz = DgFeeScaleStrategyRuleReqDto.class;
            for (Field field : fields = clazz.getDeclaredFields()) {
                DgFeeScaleStrategyRuleReqDto.SpecialList specialList;
                String name = field.getName();
                field.setAccessible(true);
                DgStrategyFeeScaleTypeEnum dgStrategyFeeScaleTypeEnum = (DgStrategyFeeScaleTypeEnum)keyMap.get(name);
                if (Objects.isNull(dgStrategyFeeScaleTypeEnum)) continue;
                String code = dgStrategyFeeScaleTypeEnum.getCode();
                String desc = dgStrategyFeeScaleTypeEnum.getDesc();
                if (dgStrategyFeeScaleTypeEnum.getType().equals("list")) {
                    specialList = (DgFeeScaleStrategyRuleReqDto.SpecialList)field.get(modifyReqDto);
                    this.extractedModify(modifyReqDto.getId(), groupStrategyMap, dgStrategyFeeScaleTypeEnum, code, desc, (DgFeeScaleStrategyRuleReqDto.SpecialStrategy)specialList, id);
                }
                if (dgStrategyFeeScaleTypeEnum.getType().equals("number")) {
                    specialList = (DgFeeScaleStrategyRuleReqDto.FeeScaleValue)field.get(modifyReqDto);
                    this.extractedModify(modifyReqDto.getId(), groupStrategyMap, dgStrategyFeeScaleTypeEnum, code, desc, (DgFeeScaleStrategyRuleReqDto.SpecialStrategy)specialList, id);
                }
                if (!dgStrategyFeeScaleTypeEnum.getType().equals("string")) continue;
                specialList = (DgFeeScaleStrategyRuleReqDto.OrderAmountType)field.get(modifyReqDto);
                this.extractedModify(modifyReqDto.getId(), groupStrategyMap, dgStrategyFeeScaleTypeEnum, code, desc, (DgFeeScaleStrategyRuleReqDto.SpecialStrategy)specialList, id);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void extractedModifyRange(DgFeeScaleStrategyRuleReqDto modifyReqDto) {
        if (Objects.nonNull(modifyReqDto.getApplyShop())) {
            DgFeeScaleStrategyRuleReqDto.ApplyShop applyShop = modifyReqDto.getApplyShop();
            this.extractedModifyRange(modifyReqDto, (DgFeeScaleStrategyRuleReqDto.Apply)applyShop, DgStrategyRuleSuitTypeEnum.SUITTYPE_SHOP.getCode());
        }
        if (Objects.nonNull(modifyReqDto.getApplyOrderType())) {
            DgFeeScaleStrategyRuleReqDto.ApplyOrderType applyOrderType = modifyReqDto.getApplyOrderType();
            this.extractedModifyRange(modifyReqDto, (DgFeeScaleStrategyRuleReqDto.Apply)applyOrderType, DgStrategyRuleSuitTypeEnum.SUITTYPE_ORDER_TYPE.getCode());
        }
        if (Objects.nonNull(modifyReqDto.getApplyClient())) {
            DgFeeScaleStrategyRuleReqDto.ApplyClient applyClient = modifyReqDto.getApplyClient();
            this.extractedModifyRange(modifyReqDto, (DgFeeScaleStrategyRuleReqDto.Apply)applyClient, DgStrategyRuleSuitTypeEnum.SUITTYPE_CLEINT.getCode());
        }
    }

    private void extractedModifyRange(DgFeeScaleStrategyRuleReqDto modifyReqDto, DgFeeScaleStrategyRuleReqDto.Apply apply, String suitType) {
        DgStrategyRuleSuitEo deleteEo = new DgStrategyRuleSuitEo();
        deleteEo.setRuleId(modifyReqDto.getId());
        deleteEo.setSuitType(suitType);
        this.dgStrategyRuleSuitDomain.logicDeleteByExample(deleteEo);
        ArrayList dgStrategyRuleSuitEoList = Lists.newArrayList();
        DgStrategyRuleSuitEo dgStrategyRuleSuitEo = new DgStrategyRuleSuitEo();
        dgStrategyRuleSuitEo.setRuleId(modifyReqDto.getId());
        dgStrategyRuleSuitEo.setSuitType(suitType);
        dgStrategyRuleSuitEo.setStrategyType(modifyReqDto.getStrategyType());
        dgStrategyRuleSuitEo.setMd5(MD5Util.getMd5ByString((String)apply.getMD5Content()));
        if (StringUtils.equals((CharSequence)apply.getApplicableType(), (CharSequence)ALL)) {
            dgStrategyRuleSuitEo.setSuitKey(ALL);
            dgStrategyRuleSuitEo.setSuitSelectType(ALL);
            dgStrategyRuleSuitEo.setSuitMatchCode(dgStrategyRuleSuitEo.getSuitType() + "_" + dgStrategyRuleSuitEo.getSuitSelectType() + "_" + dgStrategyRuleSuitEo.getSuitKey());
            dgStrategyRuleSuitEoList.add(dgStrategyRuleSuitEo);
        } else if (CollectionUtils.isNotEmpty((Collection)apply.getApplicableList())) {
            for (String shopCode : apply.getApplicableList()) {
                dgStrategyRuleSuitEo = new DgStrategyRuleSuitEo();
                dgStrategyRuleSuitEo.setRuleId(modifyReqDto.getId());
                dgStrategyRuleSuitEo.setSuitType(suitType);
                dgStrategyRuleSuitEo.setStrategyType(modifyReqDto.getStrategyType());
                dgStrategyRuleSuitEo.setSuitKey(shopCode);
                dgStrategyRuleSuitEo.setSuitSelectType(SELECT);
                dgStrategyRuleSuitEo.setSuitMatchCode(dgStrategyRuleSuitEo.getSuitType() + "_" + dgStrategyRuleSuitEo.getSuitSelectType() + "_" + shopCode);
                dgStrategyRuleSuitEo.setMd5(MD5Util.getMd5ByString((String)apply.getMD5Content()));
                dgStrategyRuleSuitEoList.add(dgStrategyRuleSuitEo);
            }
        }
        this.dgStrategyRuleSuitDomain.insertBatch((List)dgStrategyRuleSuitEoList);
    }

    private void extractedModify(Long id, Map<String, StrategyConfItemEo> groupStrategyMap, DgStrategyFeeScaleTypeEnum dgStrategyFeeScaleTypeEnum, String code, String desc, DgFeeScaleStrategyRuleReqDto.SpecialStrategy specialList, Long ids) {
        if (Objects.nonNull(specialList)) {
            StrategyConfItemEo orderType = groupStrategyMap.get(code);
            String orderMd5 = MD5Util.getMd5ByString((String)String.valueOf(specialList.getMd5()));
            if (orderType != null) {
                if (!StringUtils.equals((CharSequence)specialList.getMd5(), (CharSequence)orderMd5)) {
                    logger.info("\u3010\u4fee\u6539\u6807\u7b7e\u7b56\u7565\u3011+" + desc + "+\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)specialList);
                    StrategyConfItemEo confEo = new StrategyConfItemEo();
                    confEo.setId(orderType.getId());
                    confEo.setEnable(specialList.getEnable());
                    if (!dgStrategyFeeScaleTypeEnum.getType().equals("list")) {
                        confEo.setContent(specialList.getContent());
                    }
                    confEo.setMd5(orderMd5);
                    this.dgStrategyConfItemDomain.updateSelective((BaseEo)confEo);
                    if (dgStrategyFeeScaleTypeEnum.getType().equals("list")) {
                        StrategyConfItemSuitEo deleteEo = new StrategyConfItemSuitEo();
                        deleteEo.setRuleId(id);
                        deleteEo.setSuitType(code);
                        this.dgStrategyConfItemSuitDomain.logicDeleteByExample(deleteEo);
                        if (CollectionUtils.isNotEmpty((Collection)specialList.getCodeList())) {
                            ArrayList strategyConfItemSuitEoList = Lists.newArrayList();
                            for (String code1 : specialList.getCodeList()) {
                                StrategyConfItemSuitEo confItemSuitEo = new StrategyConfItemSuitEo();
                                confItemSuitEo.setRuleId(id);
                                confItemSuitEo.setSuitType(code);
                                confItemSuitEo.setSuitValue(code1);
                                confItemSuitEo.setSuitMatchCode(code + "_" + code1);
                                strategyConfItemSuitEoList.add(confItemSuitEo);
                            }
                            this.dgStrategyConfItemSuitDomain.insertBatch((List)strategyConfItemSuitEoList);
                        }
                    }
                }
            } else {
                StrategyConfItemEo confEo = new StrategyConfItemEo();
                CubeBeanUtils.copyProperties((Object)confEo, (Object)specialList, (String[])new String[0]);
                confEo.setRuleId(ids);
                confEo.setEnable(specialList.getEnable());
                confEo.setStrategyType(code);
                confEo.setStrategyTypeName(desc);
                confEo.setContentType(dgStrategyFeeScaleTypeEnum.getType());
                if (StringUtils.isNotBlank((CharSequence)specialList.getContent())) {
                    confEo.setContent(specialList.getContent());
                }
                confEo.setMd5(orderMd5);
                this.dgStrategyConfItemDomain.insert((BaseEo)confEo);
                if (CollectionUtils.isNotEmpty((Collection)specialList.getCodeList())) {
                    ArrayList strategyConfItemSuitEoList = Lists.newArrayList();
                    for (String code1 : specialList.getCodeList()) {
                        StrategyConfItemSuitEo confItemSuitEo = new StrategyConfItemSuitEo();
                        confItemSuitEo.setRuleId(ids);
                        confItemSuitEo.setSuitType(code);
                        confItemSuitEo.setSuitValue(code1);
                        confItemSuitEo.setSuitMatchCode(code + "_" + code1);
                        strategyConfItemSuitEoList.add(confItemSuitEo);
                    }
                    this.dgStrategyConfItemSuitDomain.insertBatch((List)strategyConfItemSuitEoList);
                }
            }
        }
    }

    private void extractedDealInsertData(DgFeeScaleStrategyRuleReqDto addReqDto, DgStrategyRuleEo dgStrategyRuleEo, List<StrategyConfItemEo> confItemEoList, List<StrategyConfItemSuitEo> strategyConfItemSuitEoList) {
        Map keyMap = DgStrategyFeeScaleTypeEnum.NAME_LOOKUP;
        try {
            Field[] fields;
            Class<DgFeeScaleStrategyRuleReqDto> clazz = DgFeeScaleStrategyRuleReqDto.class;
            for (Field field : fields = clazz.getDeclaredFields()) {
                DgFeeScaleStrategyRuleReqDto.OrderAmountType orderAmountType;
                DgFeeScaleStrategyRuleReqDto.FeeScaleValue feeScaleValue;
                DgFeeScaleStrategyRuleReqDto.SpecialList specialList;
                String name = field.getName();
                field.setAccessible(true);
                DgStrategyFeeScaleTypeEnum dgStrategyFeeScaleTypeEnum = (DgStrategyFeeScaleTypeEnum)keyMap.get(name);
                if (!Objects.nonNull(dgStrategyFeeScaleTypeEnum)) continue;
                String code = dgStrategyFeeScaleTypeEnum.getCode();
                String desc = dgStrategyFeeScaleTypeEnum.getDesc();
                if (dgStrategyFeeScaleTypeEnum.getType().equals("list") && Objects.nonNull(specialList = (DgFeeScaleStrategyRuleReqDto.SpecialList)field.get(addReqDto))) {
                    this.extractedConfigList(dgStrategyRuleEo, confItemEoList, strategyConfItemSuitEoList, (DgFeeScaleStrategyRuleReqDto.SpecialStrategy)specialList, code, desc);
                }
                if (dgStrategyFeeScaleTypeEnum.getType().equals("number") && Objects.nonNull(feeScaleValue = (DgFeeScaleStrategyRuleReqDto.FeeScaleValue)field.get(addReqDto))) {
                    this.extractedInsertConfigContent(dgStrategyRuleEo, confItemEoList, (DgFeeScaleStrategyRuleReqDto.SpecialStrategy)feeScaleValue, code, desc);
                }
                if (!dgStrategyFeeScaleTypeEnum.getType().equals("string") || !Objects.nonNull(orderAmountType = (DgFeeScaleStrategyRuleReqDto.OrderAmountType)field.get(addReqDto))) continue;
                this.extractedInsertConfigContent(dgStrategyRuleEo, confItemEoList, (DgFeeScaleStrategyRuleReqDto.SpecialStrategy)orderAmountType, code, desc);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void extractedConfigList(DgStrategyRuleEo dgStrategyRuleEo, List<StrategyConfItemEo> confItemEoList, List<StrategyConfItemSuitEo> strategyConfItemSuitEoList, DgFeeScaleStrategyRuleReqDto.SpecialStrategy specialChannel, String specialChannelCode, String specialChannelDesc) {
        if (Objects.nonNull(specialChannel)) {
            List codeList = specialChannel.getCodeList();
            StrategyConfItemEo specialWarehouseConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)specialWarehouseConfEo, (Object)specialChannel, (String[])new String[0]);
            specialWarehouseConfEo.setRuleId(dgStrategyRuleEo.getId());
            specialWarehouseConfEo.setStrategyType(specialChannelCode);
            specialWarehouseConfEo.setStrategyTypeName(specialChannelDesc);
            specialWarehouseConfEo.setMd5(MD5Util.getMd5ByString((String)specialChannel.getMD5Content()));
            confItemEoList.add(specialWarehouseConfEo);
            if (CollectionUtils.isNotEmpty((Collection)codeList)) {
                for (String warehouseCode : codeList) {
                    StrategyConfItemSuitEo confItemSuitEo = new StrategyConfItemSuitEo();
                    confItemSuitEo.setRuleId(dgStrategyRuleEo.getId());
                    confItemSuitEo.setSuitType(specialChannelCode);
                    confItemSuitEo.setSuitValue(warehouseCode);
                    confItemSuitEo.setSuitMatchCode(specialChannelCode + "_" + warehouseCode);
                    strategyConfItemSuitEoList.add(confItemSuitEo);
                }
            }
        }
    }

    private void extractedInsertConfigContent(DgStrategyRuleEo dgStrategyRuleEo, List<StrategyConfItemEo> confItemEoList, DgFeeScaleStrategyRuleReqDto.SpecialStrategy orderAmountType, String code, String desc) {
        StrategyConfItemEo delayAuditConfEo = new StrategyConfItemEo();
        CubeBeanUtils.copyProperties((Object)delayAuditConfEo, (Object)orderAmountType, (String[])new String[0]);
        delayAuditConfEo.setContent(orderAmountType.getContent());
        delayAuditConfEo.setContentType(orderAmountType.getContentType());
        delayAuditConfEo.setRuleId(dgStrategyRuleEo.getId());
        delayAuditConfEo.setMd5(MD5Util.getMd5ByString((String)orderAmountType.getMD5Content()));
        delayAuditConfEo.setStrategyType(code);
        delayAuditConfEo.setStrategyTypeName(desc);
        confItemEoList.add(delayAuditConfEo);
    }

    @Override
    public DgFeeScaleStrategyRuleRestDto queryFeeScaleStrategyById(Long id) {
        LambdaQueryWrapper queryStrategyRuleEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyRuleEo.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)id);
        DgStrategyRuleEo dgStrategyRuleEo = this.dgStrategyRuleDomain.getOne(queryStrategyRuleEo);
        AssertUtils.notNull((Object)dgStrategyRuleEo, (String)"\u7b56\u7565\u4e0d\u5b58\u5728");
        DgFeeScaleStrategyRuleRestDto strategyRuleRespDto = new DgFeeScaleStrategyRuleRestDto();
        CubeBeanUtils.copyProperties((Object)strategyRuleRespDto, (Object)dgStrategyRuleEo, (String[])new String[0]);
        this.getStrategyConfItems(id, strategyRuleRespDto);
        LambdaQueryWrapper queryStrategyRuleSuitEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyRuleSuitEo.eq(BaseEo::getDr, (Object)0)).eq(DgStrategyRuleSuitEo::getRuleId, (Object)id);
        List strategyRuleSuitList = this.dgStrategyRuleSuitDomain.list(queryStrategyRuleSuitEo);
        strategyRuleSuitList.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getSuitType())).collect(Collectors.groupingBy(DgStrategyRuleSuitEo::getSuitType)).forEach((k, v) -> {
            DgStrategyRuleSuitTypeEnum dgStrategyRuleSuitTypeEnum = DgStrategyRuleSuitTypeEnum.forCode((String)k);
            switch (dgStrategyRuleSuitTypeEnum) {
                case SUITTYPE_SHOP: {
                    DgFeeScaleStrategyRuleRestDto.ApplyShop applyShop = new DgFeeScaleStrategyRuleRestDto.ApplyShop();
                    DgStrategyRuleSuitEo dgStrategyRuleSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyRuleSuitEo, (DgFeeScaleStrategyRuleRestDto.Apply)applyShop);
                    strategyRuleRespDto.setApplyShop(applyShop);
                    break;
                }
                case SUITTYPE_ORDER_TYPE: {
                    DgFeeScaleStrategyRuleRestDto.ApplyOrderType applyOrderType = new DgFeeScaleStrategyRuleRestDto.ApplyOrderType();
                    DgStrategyRuleSuitEo dgStrategyRuleOrderTypeSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyRuleOrderTypeSuitEo, (DgFeeScaleStrategyRuleRestDto.Apply)applyOrderType);
                    strategyRuleRespDto.setApplyOrderType(applyOrderType);
                    break;
                }
                case SUITTYPE_CLEINT: {
                    DgFeeScaleStrategyRuleRestDto.ApplyClient applyClient = new DgFeeScaleStrategyRuleRestDto.ApplyClient();
                    DgStrategyRuleSuitEo dgStrategyClientRuleSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyClientRuleSuitEo, (DgFeeScaleStrategyRuleRestDto.Apply)applyClient);
                    strategyRuleRespDto.setApplyClient(applyClient);
                    break;
                }
            }
        });
        return strategyRuleRespDto;
    }

    private void extractedAttributeAssignment(List<DgStrategyRuleSuitEo> strategyRuleSuitList, DgStrategyRuleSuitEo dgStrategyRuleSuitEo, DgFeeScaleStrategyRuleRestDto.Apply apply) {
        apply.setApplicableType(dgStrategyRuleSuitEo.getSuitSelectType());
        if (StringUtils.equals((CharSequence)dgStrategyRuleSuitEo.getSuitSelectType(), (CharSequence)SELECT)) {
            List shopCodeList = strategyRuleSuitList.stream().map(DgStrategyRuleSuitEo::getSuitKey).collect(Collectors.toList());
            apply.setApplicableList(shopCodeList);
        }
    }

    private void getStrategyConfItems(Long id, DgFeeScaleStrategyRuleRestDto dgFeeScaleStrategyRuleRestDto) {
        LambdaQueryWrapper queryStrategyConfItemEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyConfItemEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemEo::getRuleId, (Object)id);
        List strategyConfItemEoList = this.dgStrategyConfItemDomain.list(queryStrategyConfItemEo);
        AssertUtils.notEmpty((Collection)strategyConfItemEoList, (String)"\u7b56\u7565\u914d\u7f6e\u9879\u4e3a\u7a7a");
        LambdaQueryWrapper queryStrategyConfItemSuitEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyConfItemSuitEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemSuitEo::getRuleId, (Object)id);
        List strategyConfItemSuitEoList = this.dgStrategyConfItemSuitDomain.list(queryStrategyConfItemSuitEo);
        Map<String, List<StrategyConfItemSuitEo>> strategyConfItemSuitMap = Optional.ofNullable(strategyConfItemSuitEoList).orElseGet(Collections::emptyList).stream().collect(Collectors.groupingBy(StrategyConfItemSuitEo::getSuitType));
        Class<?> aClass = dgFeeScaleStrategyRuleRestDto.getClass();
        strategyConfItemEoList.forEach(strategyConfItemEo -> {
            switch (CisStrategyContentTypeEnum.forCode((String)strategyConfItemEo.getContentType())) {
                case LIST: {
                    DgFeeScaleStrategyRuleRestDto.SpecialList specialList = new DgFeeScaleStrategyRuleRestDto.SpecialList();
                    List collectItemSuitCode = Optional.ofNullable(strategyConfItemSuitMap.get(strategyConfItemEo.getStrategyType())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                    CubeBeanUtils.copyProperties((Object)specialList, (Object)strategyConfItemEo, (String[])new String[0]);
                    specialList.setCodeList(collectItemSuitCode);
                    String fieldName = DgStrategyFeeScaleTypeEnum.forCode((String)strategyConfItemEo.getStrategyType()).getName();
                    try {
                        Field declaredField = aClass.getDeclaredField(fieldName);
                        declaredField.setAccessible(true);
                        declaredField.set(dgFeeScaleStrategyRuleRestDto, specialList);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                case NUMBER: {
                    DgFeeScaleStrategyRuleRestDto.FeeScaleValue feeScaleValue = new DgFeeScaleStrategyRuleRestDto.FeeScaleValue();
                    CubeBeanUtils.copyProperties((Object)feeScaleValue, (Object)strategyConfItemEo, (String[])new String[0]);
                    String content = strategyConfItemEo.getContent();
                    if (StringUtils.isNotBlank((CharSequence)content)) {
                        feeScaleValue.setValue(Integer.valueOf(content));
                    }
                    try {
                        String specialNumberFieldName = DgStrategyFeeScaleTypeEnum.forCode((String)strategyConfItemEo.getStrategyType()).getName();
                        Field declaredField = aClass.getDeclaredField(specialNumberFieldName);
                        declaredField.setAccessible(true);
                        declaredField.set(dgFeeScaleStrategyRuleRestDto, feeScaleValue);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                case STRING: {
                    DgFeeScaleStrategyRuleRestDto.OrderAmountType specialString = new DgFeeScaleStrategyRuleRestDto.OrderAmountType();
                    CubeBeanUtils.copyProperties((Object)specialString, (Object)strategyConfItemEo, (String[])new String[0]);
                    String content1 = strategyConfItemEo.getContent();
                    if (StringUtils.isNotBlank((CharSequence)content1)) {
                        specialString.setValue(content1);
                    }
                    try {
                        String actionRemarkFieldName = DgStrategyFeeScaleTypeEnum.forCode((String)strategyConfItemEo.getStrategyType()).getName();
                        Field declaredField = aClass.getDeclaredField(actionRemarkFieldName);
                        declaredField.setAccessible(true);
                        declaredField.set(dgFeeScaleStrategyRuleRestDto, specialString);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    private void popStrategyRuleSuits(DgFeeScaleStrategyRuleReqDto addReqDto, DgStrategyRuleEo dgStrategyRuleEo, List<DgStrategyRuleSuitEo> dgStrategyRuleSuitEoList) {
        DgFeeScaleStrategyRuleReqDto.ApplyShop applyShop = addReqDto.getApplyShop();
        DgFeeScaleStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgFeeScaleStrategyRuleReqDto.Apply)applyShop, DgStrategyRuleSuitTypeEnum.SUITTYPE_SHOP.getCode(), addReqDto);
        DgFeeScaleStrategyRuleReqDto.ApplyOrderType applyOrderType = addReqDto.getApplyOrderType();
        DgFeeScaleStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgFeeScaleStrategyRuleReqDto.Apply)applyOrderType, DgStrategyRuleSuitTypeEnum.SUITTYPE_ORDER_TYPE.getCode(), addReqDto);
        DgFeeScaleStrategyRuleReqDto.ApplyClient applyClient = addReqDto.getApplyClient();
        DgFeeScaleStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgFeeScaleStrategyRuleReqDto.Apply)applyClient, DgStrategyRuleSuitTypeEnum.SUITTYPE_CLEINT.getCode(), addReqDto);
    }

    private static void extractedAddRange(DgStrategyRuleEo dgStrategyRuleEo, List<DgStrategyRuleSuitEo> dgStrategyRuleSuitEoList, DgFeeScaleStrategyRuleReqDto.Apply apply, String suitType, DgFeeScaleStrategyRuleReqDto addReqDto) {
        DgStrategyRuleSuitEo dgStrategyRuleSuitEo = new DgStrategyRuleSuitEo();
        dgStrategyRuleSuitEo.setRuleId(dgStrategyRuleEo.getId());
        dgStrategyRuleSuitEo.setSuitType(suitType);
        dgStrategyRuleSuitEo.setStrategyType(addReqDto.getStrategyType());
        dgStrategyRuleSuitEo.setMd5(MD5Util.getMd5ByString((String)apply.getMD5Content()));
        if (StringUtils.equals((CharSequence)apply.getApplicableType(), (CharSequence)ALL)) {
            dgStrategyRuleSuitEo.setSuitKey(ALL);
            dgStrategyRuleSuitEo.setSuitSelectType(ALL);
            dgStrategyRuleSuitEo.setSuitMatchCode(dgStrategyRuleSuitEo.getSuitType() + "_" + dgStrategyRuleSuitEo.getSuitSelectType() + "_" + dgStrategyRuleSuitEo.getSuitKey());
            dgStrategyRuleSuitEoList.add(dgStrategyRuleSuitEo);
        } else if (CollectionUtils.isNotEmpty((Collection)apply.getApplicableList())) {
            for (String shopCode : apply.getApplicableList()) {
                dgStrategyRuleSuitEo = new DgStrategyRuleSuitEo();
                dgStrategyRuleSuitEo.setRuleId(dgStrategyRuleEo.getId());
                dgStrategyRuleSuitEo.setSuitType(suitType);
                dgStrategyRuleSuitEo.setStrategyType(addReqDto.getStrategyType());
                dgStrategyRuleSuitEo.setSuitKey(shopCode);
                dgStrategyRuleSuitEo.setSuitSelectType(SELECT);
                dgStrategyRuleSuitEo.setSuitMatchCode(dgStrategyRuleSuitEo.getSuitType() + "_" + dgStrategyRuleSuitEo.getSuitSelectType() + "_" + shopCode);
                dgStrategyRuleSuitEo.setMd5(MD5Util.getMd5ByString((String)apply.getMD5Content()));
                dgStrategyRuleSuitEoList.add(dgStrategyRuleSuitEo);
            }
        }
    }

    @Override
    public PageInfo<DgStrategyRuleFeeScaleRespDto> queryFeeScaleByPage(DgFeeScaleStrategyRulePageQueryReqDto strategyRuleReqDto) {
        boolean feeScaleQueryFlag;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        if (strategyRuleReqDto.getRuleStatus() != null) {
            queryWrapper.eq(DgStrategyRuleEo::getRuleStatus, (Object)strategyRuleReqDto.getRuleStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getStrategyType())) {
            queryWrapper.eq(DgStrategyRuleEo::getStrategyType, (Object)strategyRuleReqDto.getStrategyType());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getCreateStartTime())) {
            ((LambdaQueryWrapper)queryWrapper.ge(BaseEo::getCreateTime, (Object)strategyRuleReqDto.getCreateStartTime())).le(BaseEo::getCreateTime, (Object)strategyRuleReqDto.getCreateEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getUpdateStartTime())) {
            ((LambdaQueryWrapper)queryWrapper.ge(BaseEo::getUpdateTime, (Object)strategyRuleReqDto.getUpdateStartTime())).le(BaseEo::getUpdateTime, (Object)strategyRuleReqDto.getUpdateEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getPlatForm())) {
            queryWrapper.eq(DgStrategyRuleEo::getPlatForm, (Object)strategyRuleReqDto.getPlatForm());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getRuleName()) || StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getRuleCode())) {
            queryWrapper.and(wrapper -> ((LambdaQueryWrapper)wrapper.like(DgStrategyRuleEo::getRuleName, (Object)("%" + strategyRuleReqDto.getRuleName() + "%"))).or(wp -> wp.like(DgStrategyRuleEo::getRuleCode, (Object)("%" + strategyRuleReqDto.getRuleCode() + "%"))));
        }
        if (feeScaleQueryFlag = this.feeScaleQuery(strategyRuleReqDto, (LambdaQueryWrapper<DgStrategyRuleEo>)queryWrapper)) {
            return new PageInfo();
        }
        queryWrapper.orderByDesc(BaseEo::getUpdateTime);
        PageHelper.startPage((int)strategyRuleReqDto.getPageNum(), (int)strategyRuleReqDto.getPageSize());
        List dgStrategyRuleEos = this.dgStrategyRuleDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)dgStrategyRuleEos)) {
            return new PageInfo();
        }
        PageInfo info = new PageInfo(dgStrategyRuleEos);
        PageInfo dtoPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)dtoPageInfo);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)info, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<DgStrategyRuleFeeScaleRespDto> dtoList = new ArrayList<DgStrategyRuleFeeScaleRespDto>();
        DtoHelper.eoList2DtoList((Collection)info.getList(), dtoList, DgStrategyRuleFeeScaleRespDto.class);
        this.setFeeScaleDetail(strategyRuleReqDto, dtoList);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private boolean feeScaleQuery(DgFeeScaleStrategyRulePageQueryReqDto strategyRuleReqDto, LambdaQueryWrapper<DgStrategyRuleEo> queryWrapper) {
        LambdaQueryWrapper suitEoLambdaQueryWrapper;
        if (!Objects.equals(strategyRuleReqDto.getStrategyType(), DgCisStrategyOrderTypeEnum.FEE_SCALE_CONTROL.getCode())) {
            return true;
        }
        List<Object> ruleId = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getSpecialFeeType())) {
            suitEoLambdaQueryWrapper = new LambdaQueryWrapper();
            suitEoLambdaQueryWrapper.eq(BaseEo::getDr, (Object)0);
            suitEoLambdaQueryWrapper.eq(StrategyConfItemSuitEo::getSuitType, (Object)DgStrategyFeeScaleTypeEnum.SPECIAL_FEE_TYPE.getCode());
            suitEoLambdaQueryWrapper.eq(StrategyConfItemSuitEo::getSuitValue, (Object)strategyRuleReqDto.getSpecialFeeType());
            List feeTypeSuitItemRuleList = this.dgStrategyConfItemSuitDomain.list(suitEoLambdaQueryWrapper);
            if (CollectionUtils.isEmpty((Collection)feeTypeSuitItemRuleList)) {
                logger.info("\u672a\u67e5\u8be2\u51fa\u8d39\u7528\u7c7b\u578b\u7684\u89c4\u5219\u6570\u636e");
                return true;
            }
            ruleId = feeTypeSuitItemRuleList.stream().map(StrategyConfItemSuitEo::getRuleId).distinct().collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getSpecialExcludeItemType())) {
            suitEoLambdaQueryWrapper = new LambdaQueryWrapper();
            suitEoLambdaQueryWrapper.eq(BaseEo::getDr, (Object)0);
            suitEoLambdaQueryWrapper.eq(StrategyConfItemSuitEo::getSuitType, (Object)DgStrategyFeeScaleTypeEnum.SPECIAL_EXCLUDE_ITEM_TYPE.getCode());
            suitEoLambdaQueryWrapper.eq(StrategyConfItemSuitEo::getSuitValue, (Object)strategyRuleReqDto.getSpecialExcludeItemType());
            List excludeItemSuitItemRuleList = this.dgStrategyConfItemSuitDomain.list(suitEoLambdaQueryWrapper);
            if (CollectionUtils.isEmpty((Collection)excludeItemSuitItemRuleList)) {
                logger.info("\u672a\u67e5\u8be2\u51fa\u6392\u9664\u5546\u54c1\u884c\u7c7b\u578b\u7684\u89c4\u5219\u6570\u636e");
                return true;
            }
            List excludeItemRuleIdList = excludeItemSuitItemRuleList.stream().map(StrategyConfItemSuitEo::getRuleId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty((Collection)ruleId)) {
                ruleId = excludeItemRuleIdList;
            } else if (CollectionUtils.isEmpty((Collection)(ruleId = ruleId.stream().filter(excludeItemRuleIdList::contains).collect(Collectors.toList())))) {
                logger.info("\u672a\u67e5\u8be2\u5339\u914d\u7b56\u7565\u4ea4\u96c6\u7684\u89c4\u5219\u6570\u636e");
                return true;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getOrderAmountType())) {
            suitEoLambdaQueryWrapper = new LambdaQueryWrapper();
            suitEoLambdaQueryWrapper.eq(BaseEo::getDr, (Object)0);
            suitEoLambdaQueryWrapper.eq(StrategyConfItemEo::getStrategyType, (Object)DgStrategyConfItemTypeEnum.ORDER_AMOUNT_TYPE.getCode());
            suitEoLambdaQueryWrapper.eq(StrategyConfItemEo::getContent, (Object)strategyRuleReqDto.getOrderAmountType());
            List amountTypeItemRuleList = this.dgStrategyConfItemDomain.list(suitEoLambdaQueryWrapper);
            if (CollectionUtils.isEmpty((Collection)amountTypeItemRuleList)) {
                logger.info("\u672a\u67e5\u8be2\u51fa\u8ba2\u5355\u91d1\u989d\u7c7b\u578b\u7684\u89c4\u5219\u6570\u636e");
                return true;
            }
            List amountTypeItemRuleIdList = amountTypeItemRuleList.stream().map(StrategyConfItemEo::getRuleId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty((Collection)ruleId)) {
                ruleId = amountTypeItemRuleIdList;
            } else if (CollectionUtils.isEmpty((Collection)(ruleId = ruleId.stream().filter(amountTypeItemRuleIdList::contains).collect(Collectors.toList())))) {
                logger.info("\u672a\u67e5\u8be2\u5339\u914d\u8ba2\u5355\u91d1\u989d\u4ea4\u96c6\u7684\u89c4\u5219\u6570\u636e");
                return true;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)ruleId)) {
            queryWrapper.in(BaseEo::getId, (Collection)ruleId);
        }
        return false;
    }

    private void setFeeScaleDetail(DgFeeScaleStrategyRulePageQueryReqDto strategyRuleReqDto, List<DgStrategyRuleFeeScaleRespDto> dtoList) {
        if (Objects.equals(strategyRuleReqDto.getStrategyType(), DgCisStrategyOrderTypeEnum.FEE_SCALE_CONTROL.getCode())) {
            List ruleIdList = dtoList.stream().map(DgStrategyRuleRespDto::getId).collect(Collectors.toList());
            LambdaQueryWrapper suitEoLambdaQueryWrapper = new LambdaQueryWrapper();
            suitEoLambdaQueryWrapper.eq(BaseEo::getDr, (Object)0);
            suitEoLambdaQueryWrapper.in(StrategyConfItemEo::getRuleId, ruleIdList);
            List confItemRuleList = this.dgStrategyConfItemDomain.list(suitEoLambdaQueryWrapper);
            Map<Long, List<StrategyConfItemEo>> confItemMap = confItemRuleList.stream().collect(Collectors.groupingBy(StrategyConfItemEo::getRuleId));
            LambdaQueryWrapper itemSuitEoLambdaQueryWrapper = new LambdaQueryWrapper();
            itemSuitEoLambdaQueryWrapper.eq(BaseEo::getDr, (Object)0);
            itemSuitEoLambdaQueryWrapper.in(StrategyConfItemSuitEo::getRuleId, ruleIdList);
            List confItemSuitRuleList = this.dgStrategyConfItemSuitDomain.list(itemSuitEoLambdaQueryWrapper);
            Map<Long, List<StrategyConfItemSuitEo>> confItemSuitMap = confItemSuitRuleList.stream().collect(Collectors.groupingBy(StrategyConfItemSuitEo::getRuleId));
            Map<String, String> FeeTypeDictMap = this.feeScaleTypeUtils.feeTypeMap();
            for (DgStrategyRuleFeeScaleRespDto ruleFeeScaleRespDto : dtoList) {
                StrategyConfItemEo feeScaleValueEo = confItemMap.get(ruleFeeScaleRespDto.getId()).stream().filter(dto -> Objects.equals(dto.getStrategyType(), DgStrategyFeeScaleTypeEnum.FEE_SCALE_VALUE.getCode())).findFirst().get();
                ruleFeeScaleRespDto.setFeeScaleValue(feeScaleValueEo.getContent());
                StrategyConfItemEo orderAmountTypeEo = confItemMap.get(ruleFeeScaleRespDto.getId()).stream().filter(dto -> Objects.equals(dto.getStrategyType(), DgStrategyFeeScaleTypeEnum.ORDER_AMOUNT_TYPE.getCode())).findFirst().get();
                ruleFeeScaleRespDto.setOrderAmountType(DgStrategyAmountTypeEnum.forCode((String)orderAmountTypeEo.getContent()).getDesc());
                List feeTypeEoList = confItemSuitMap.get(ruleFeeScaleRespDto.getId()).stream().filter(dto -> Objects.equals(dto.getSuitType(), DgStrategyFeeScaleTypeEnum.SPECIAL_FEE_TYPE.getCode())).collect(Collectors.toList());
                String feeType = "";
                if (CollectionUtils.isNotEmpty(feeTypeEoList)) {
                    for (StrategyConfItemSuitEo feeTypeEo : feeTypeEoList) {
                        if (StringUtils.isEmpty((CharSequence)feeType)) {
                            feeType = FeeTypeDictMap.get(feeTypeEo.getSuitValue());
                            continue;
                        }
                        feeType = feeType + "," + FeeTypeDictMap.get(feeTypeEo.getSuitValue());
                    }
                }
                ruleFeeScaleRespDto.setFeeType(feeType);
                String specialExcludeItemType = "";
                List specialExcludeItemTypeEoList = confItemSuitMap.get(ruleFeeScaleRespDto.getId()).stream().filter(dto -> Objects.equals(dto.getSuitType(), DgStrategyFeeScaleTypeEnum.SPECIAL_EXCLUDE_ITEM_TYPE.getCode())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(specialExcludeItemTypeEoList)) {
                    for (StrategyConfItemSuitEo specialExcludeItemTypeEo : specialExcludeItemTypeEoList) {
                        if (StringUtils.isEmpty((CharSequence)specialExcludeItemType)) {
                            specialExcludeItemType = FeeTypeDictMap.get(specialExcludeItemTypeEo.getSuitValue());
                            continue;
                        }
                        specialExcludeItemType = specialExcludeItemType + "," + FeeTypeDictMap.get(specialExcludeItemTypeEo.getSuitValue());
                    }
                }
                ruleFeeScaleRespDto.setSpecialExcludeItemType(specialExcludeItemType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DgMatchStrategyResultDto matchOrderStaretegyOfFeeScale(DgOrderFeeScaleControllerReqDto feeScaleControllerReqDto) {
        DgPerformOrderRespDto performOrderRespDto = this.feeScaleDtoToPerformOrder(feeScaleControllerReqDto);
        Long orderId = performOrderRespDto.getId();
        logger.info("\u8d39\u6bd4\u63a7\u5236\u8ba2\u5355\uff08orderId={}\uff09\u8ba2\u5355\u7684\u5165\u53c2\u4e3a\uff1a{}", (Object)orderId, (Object)JSON.toJSONString((Object)feeScaleControllerReqDto));
        try {
            DgMatchStrategyResultDto matchStrategyResult = new DgMatchStrategyResultDto();
            String message = "";
            DgStrategyRuleEo dgStrategyRuleEo = this.queryValidRule(performOrderRespDto, DgCisStrategyOrderTypeEnum.FEE_SCALE_CONTROL.getCode());
            if (dgStrategyRuleEo == null) {
                logger.info("\u8d39\u6bd4\u63a7\u5236\u8ba2\u5355\uff08orderId={}\uff09\u8ba2\u5355\u6ca1\u6709\u5339\u914d\u4e0a\u7b56\u7565", (Object)orderId);
                matchStrategyResult.setMatchStrategy(Boolean.valueOf(false));
                matchStrategyResult.setCostAccountRespDto(feeScaleControllerReqDto.getCostAccountRespDto());
                DgMatchStrategyResultDto dgMatchStrategyResultDto = matchStrategyResult;
                return dgMatchStrategyResultDto;
            }
            List<StrategyConfItemSuitEo> confItemSuitRuleList = this.queryRuleConfItemSuitList(dgStrategyRuleEo);
            List<StrategyConfItemEo> confItemRuleList = this.queryValidRuleConfItemList(dgStrategyRuleEo);
            this.verifyOrderCostRatioControl(confItemSuitRuleList, confItemRuleList, matchStrategyResult, feeScaleControllerReqDto, message);
            DgMatchStrategyResultDto dgMatchStrategyResultDto = matchStrategyResult;
            return dgMatchStrategyResultDto;
        }
        finally {
            this.cleanHitStrategyOrder();
        }
    }

    private void verifyOrderCostRatioControl(List<StrategyConfItemSuitEo> confItemSuitRuleList, List<StrategyConfItemEo> confItemRuleList, DgMatchStrategyResultDto matchStrategyResult, DgOrderFeeScaleControllerReqDto feeScaleControllerReqDto, String message) {
        List feeTypeEoList = confItemSuitRuleList.stream().filter(dto -> Objects.equals(dto.getSuitType(), DgStrategyFeeScaleTypeEnum.SPECIAL_FEE_TYPE.getCode())).collect(Collectors.toList());
        List feeTypeList = feeTypeEoList.stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
        List specialExcludeItemTypeEoList = confItemSuitRuleList.stream().filter(dto -> Objects.equals(dto.getSuitType(), DgStrategyFeeScaleTypeEnum.SPECIAL_EXCLUDE_ITEM_TYPE.getCode())).collect(Collectors.toList());
        List excludeItemTypeList = specialExcludeItemTypeEoList.stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
        StrategyConfItemEo feeScaleValueEo = confItemRuleList.stream().filter(dto -> Objects.equals(dto.getStrategyType(), DgStrategyFeeScaleTypeEnum.FEE_SCALE_VALUE.getCode())).findFirst().get();
        Integer feeScaleValue = Integer.valueOf(feeScaleValueEo.getContent());
        matchStrategyResult.setFeeType(feeTypeList);
        matchStrategyResult.setFeeScaleFlag(Boolean.valueOf(false));
        List orderAmountDtoList = feeScaleControllerReqDto.getOrderFeeAmountDtoList();
        StrategyConfItemEo orderAmountTypeEo = confItemRuleList.stream().filter(dto -> Objects.equals(dto.getStrategyType(), DgStrategyFeeScaleTypeEnum.ORDER_AMOUNT_TYPE.getCode())).findFirst().get();
        String orderAmountTypeCode = orderAmountTypeEo.getContent();
        this.buildCaculateAmount(DgStrategyAmountTypeEnum.forCode((String)orderAmountTypeCode), orderAmountDtoList);
        BigDecimal orderTotalAmount = BigDecimal.ZERO;
        BigDecimal itemPromotionTotalAmount = BigDecimal.ZERO;
        BigDecimal feeTypeTotalAmount = BigDecimal.ZERO;
        BigDecimal excludeFeeTypeTotalAmount = BigDecimal.ZERO;
        BigDecimal costCapAmount = BigDecimal.ZERO;
        BigDecimal feeCaculateTotalAmount = BigDecimal.ZERO;
        logger.info("\u3010\u9700\u8981\u8ba1\u7b97\u7684\u8d39\u7528\u7c7b\u578b\u4e3a:{}\u3011", feeTypeList);
        logger.info("\u3010\u9700\u8981\u6392\u9664\u7684\u8d39\u7528\u7c7b\u578b\u4e3a:{}\u3011", excludeItemTypeList);
        for (DgOrderFeeAmountDto dgOrderFeeAmountDto : orderAmountDtoList) {
            logger.info("\u5546\u54c1\u3010{}\u3011\u7684\u91d1\u989d\u4e3a:{},\u8d39\u7528\u7c7b\u578b\u4e3a:{}", new Object[]{dgOrderFeeAmountDto.getSkuCode(), dgOrderFeeAmountDto.getCalculateAmount(), dgOrderFeeAmountDto.getFeeType()});
            orderTotalAmount = orderTotalAmount.add(dgOrderFeeAmountDto.getCalculateAmount());
            boolean feeTypeFlag = false;
            for (String feeType : feeTypeList) {
                if (dgOrderFeeAmountDto.getFeeType().contains(feeType) || dgOrderFeeAmountDto.getGift().equals(GiftEnum.GIFT.getType())) {
                    feeTypeFlag = true;
                }
                if (!CollectionUtils.isNotEmpty((Collection)dgOrderFeeAmountDto.getItemPromotionDtos())) continue;
                logger.info("\u3010\u5546\u54c1\u7684\u4fc3\u9500\u4f18\u60e0\u4fe1\u606f\u4e3a:{}\u3011", (Object)JSON.toJSONString((Object)dgOrderFeeAmountDto.getItemPromotionDtos()));
                for (ItemPromotionDto itemPromotionDto : dgOrderFeeAmountDto.getItemPromotionDtos()) {
                    if (!itemPromotionDto.getPromotionType().equals(feeType)) continue;
                    itemPromotionTotalAmount = itemPromotionTotalAmount.add(itemPromotionDto.getDiscountAmount());
                }
            }
            if (feeTypeFlag) {
                feeTypeTotalAmount = feeTypeTotalAmount.add(dgOrderFeeAmountDto.getCalculateAmount());
            }
            if (!CollectionUtils.isNotEmpty(excludeItemTypeList)) continue;
            for (String feeType : excludeItemTypeList) {
                if (!dgOrderFeeAmountDto.getFeeType().contains(feeType)) continue;
                excludeFeeTypeTotalAmount = excludeFeeTypeTotalAmount.add(dgOrderFeeAmountDto.getCalculateAmount());
            }
        }
        feeCaculateTotalAmount = feeTypeTotalAmount.subtract(excludeFeeTypeTotalAmount);
        logger.info("\u3010\u7b26\u5408\u8981\u6c42\u7684\u5546\u54c1\u8d39\u7528\u884c\u603b\u91d1\u989d:{},\u9700\u8981\u6392\u9664\u7684\u5546\u54c1\u8d39\u7528\u884c\u603b\u91d1\u989d:{},\u5269\u4f59\u53c2\u4e0e\u8d39\u6bd4\u8ba1\u7b97\u7684\u603b\u91d1\u989d:{}\u3011", new Object[]{feeTypeTotalAmount, excludeFeeTypeTotalAmount, feeCaculateTotalAmount});
        logger.info("\u3010\u8d39\u6bd4\u767e\u5206\u6bd4\u4e3a:{}\u3011", (Object)feeScaleValue);
        costCapAmount = feeCaculateTotalAmount.multiply(new BigDecimal(feeScaleValue)).divide(new BigDecimal("100"), 2, 4);
        if (costCapAmount.compareTo(BigDecimal.ZERO) < 0) {
            costCapAmount = BigDecimal.ZERO;
        }
        logger.info("\u3010\u7b26\u5408\u8d39\u7528\u7c7b\u578b\u53ef\u7528\u603b\u91d1\u989d\u4e0a\u9650\u4e3a:{}\u3011", (Object)costCapAmount);
        logger.info("\u3010\u7b26\u5408\u8d39\u7528\u7c7b\u578b\u7684\u5546\u54c1\u884c\u7684\u4f18\u60e0\u603b\u91d1\u989d\u4e3a:{}\u3011", (Object)itemPromotionTotalAmount);
        matchStrategyResult.setUpperLimitAmount(costCapAmount);
        matchStrategyResult.setFeeScaleAmount(itemPromotionTotalAmount);
        if (costCapAmount.compareTo(itemPromotionTotalAmount) < 0) {
            matchStrategyResult.setFeeScaleFlag(Boolean.valueOf(true));
            message = message.concat("\u672c\u5355\u8d39\u6bd4\u63a7\u5236\u53ef\u7528\u603b\u989d\u4e3a:").concat(costCapAmount.toString()).concat(",\u672c\u5355\u4fc3\u9500\u4f18\u60e0\u603b\u989d\u4e3a").concat(itemPromotionTotalAmount.toString()).concat(",\u4fc3\u9500\u4f18\u60e0\u603b\u989d\u8d85\u8fc7\u8d39\u6bd4\u63a7\u5236\u4e0a\u9650");
            logger.error("\u672c\u5355\u4fc3\u9500\u4f18\u60e0\u603b\u989d\u8d85\u8fc7\u8d39\u6bd4\u63a7\u5236\u7684\u767e\u5206\u6bd4\u4e0a\u9650");
        }
        BigDecimal otherAmount = costCapAmount.subtract(itemPromotionTotalAmount);
        logger.info("\u3010\u975e\u4fc3\u9500\u8d39\u7528\u7c7b\u578b\u53ef\u7528\u989d\u5ea6\u4e3a(\u8ba2\u5355\u91d1\u989d*\u8d39\u6bd4\u767e\u5206\u6bd4-\u4fc3\u9500\u8d39\u7528\u603b\u91d1\u989d):{}\u3011", (Object)otherAmount);
        ArrayList notPormotionFeeTypes = Lists.newArrayList();
        if (feeScaleControllerReqDto.getCostAccountRespDto() != null && CollectionUtils.isNotEmpty((Collection)feeScaleControllerReqDto.getCostAccountRespDto().getAccountPreviewDtos())) {
            for (AccountPreviewDto accountPreviewDto : feeScaleControllerReqDto.getCostAccountRespDto().getAccountPreviewDtos()) {
                for (String feeType : feeTypeList) {
                    if (!accountPreviewDto.getAccountType().equals(feeType)) continue;
                    notPormotionFeeTypes.add(feeType);
                }
            }
        }
        logger.info("\u6392\u9664\u4fc3\u9500\u8d39\u7528\u884c\u540e\uff0c\u9700\u8981\u53c2\u4e0e\u8ba1\u7b97\u7684\u8d39\u7528\u7c7b\u578b:{},\u6700\u5927\u53ef\u4f7f\u7528\u989d\u5ea6\u4e3a:{}", (Object)JSON.toJSONString((Object)notPormotionFeeTypes), (Object)otherAmount);
        matchStrategyResult.setNotPormotionFeeTypes((List)notPormotionFeeTypes);
        matchStrategyResult.setNotPormotionTotalAmount(otherAmount);
        BigDecimal payAmount = BigDecimal.ZERO;
        if (feeScaleControllerReqDto.getCostAccountRespDto() != null && CollectionUtils.isNotEmpty((Collection)feeScaleControllerReqDto.getCostAccountRespDto().getAccountPreviewDtos())) {
            payAmount = feeScaleControllerReqDto.getCostAccountRespDto().getAccountPreviewDtos().stream().filter(e -> e.getAccountCategory().equals(AccountCategoryEnum.COST.getCode())).map(AccountPreviewDto::getOrderAvaBalance).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        logger.info("\u3010\u4f20\u5165\u7684\u8d39\u7528\u8d26\u6237\u8d39\u7528\u603b\u989d\u4e3a:{}\u3011", (Object)payAmount);
        if (payAmount.compareTo(BigDecimal.ZERO) > 0) {
            logger.info("\u4f20\u5165\u4e86\u8d26\u6237\u4f7f\u7528\u989d\u5ea6\uff0c\u6821\u9a8c\u662f\u5426\u8d85\u8fc7\u8d39\u6bd4\u9650\u989d");
            BigDecimal notPromotionUseAmount = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)notPormotionFeeTypes)) {
                for (AccountPreviewDto payReqDto : feeScaleControllerReqDto.getCostAccountRespDto().getAccountPreviewDtos()) {
                    for (String notPormotionFeeType : notPormotionFeeTypes) {
                        if (!notPormotionFeeType.equals(payReqDto.getAccountType())) continue;
                        notPromotionUseAmount = notPromotionUseAmount.add(payReqDto.getOrderAvaBalance());
                    }
                }
            }
            logger.info("\u975e\u4fc3\u9500\u5546\u54c1\u8d39\u7528\u7c7b\u578b\u7684\u5176\u4ed6\u8d39\u7528\u7c7b\u578b\u4f20\u5165\u603b\u989d\u4e3a:{}", (Object)notPromotionUseAmount);
            if (notPromotionUseAmount.compareTo(otherAmount) > 0) {
                matchStrategyResult.setFeeScaleFlag(Boolean.valueOf(true));
                message = "\u53c2\u4e0e\u8d39\u7528\u62b5\u6263\u6700\u5927\u53ef\u7528\u989d\u5ea6\u4e3a:" + costCapAmount + ",\u8d85\u8fc7\u8d39\u6bd4\u63a7\u5236\u7684\u6700\u5927\u53ef\u4f7f\u7528\u989d\u5ea6";
            }
        }
        matchStrategyResult.setUpperLimitAmount(otherAmount);
        matchStrategyResult.setCostAccountRespDto(feeScaleControllerReqDto.getCostAccountRespDto());
        matchStrategyResult.setMessage(message);
    }

    private void buildCaculateAmount(DgStrategyAmountTypeEnum orderAmountTypeEnum, List<DgOrderFeeAmountDto> orderAmountDtoList) {
        switch (orderAmountTypeEnum) {
            case ITEM_TAX_TOTAL_AMOUNT: {
                orderAmountDtoList.forEach(e -> e.setCalculateAmount(e.getTotalAmount()));
                break;
            }
            case ITEM_TOTAL_AMOUNT: {
                orderAmountDtoList.forEach(e -> e.setCalculateAmount(e.getNoTaxTotalAmount()));
                break;
            }
            case TOTAL_TAX_AMOUNT: {
                orderAmountDtoList.forEach(e -> e.setCalculateAmount(e.getPayAmount()));
                break;
            }
            case TOTAL_AMOUNT: {
                orderAmountDtoList.forEach(e -> e.setCalculateAmount(e.getNoTaxPayAmount()));
                break;
            }
            case PAY_TAX_AMOUNT: {
                orderAmountDtoList.forEach(e -> e.setCalculateAmount(e.getRealPayAmount()));
                break;
            }
            case PAY_AMOUNT: {
                orderAmountDtoList.forEach(e -> e.setCalculateAmount(e.getNoTaxRealPayAmount()));
                break;
            }
            default: {
                orderAmountDtoList.forEach(e -> e.setCalculateAmount(e.getTotalAmount()));
            }
        }
    }

    private DgOrderAmountTypeEnum getAmountTypeByFeeType(DgStrategyAmountTypeEnum orderAmountTypeEnum) {
        DgOrderAmountTypeEnum amountTypeEnum = DgOrderAmountTypeEnum.SALE_TOTAL;
        switch (orderAmountTypeEnum) {
            case ITEM_TAX_TOTAL_AMOUNT: {
                amountTypeEnum = DgOrderAmountTypeEnum.SALE_TOTAL;
                break;
            }
            case ITEM_TOTAL_AMOUNT: {
                amountTypeEnum = DgOrderAmountTypeEnum.SALE_TOTAL_NOTAX;
                break;
            }
            case TOTAL_TAX_AMOUNT: {
                amountTypeEnum = DgOrderAmountTypeEnum.ORIG_AMOUNT;
                break;
            }
            case TOTAL_AMOUNT: {
                amountTypeEnum = DgOrderAmountTypeEnum.ORIG_AMOUNT_NOTAX;
                break;
            }
            case PAY_TAX_AMOUNT: {
                amountTypeEnum = DgOrderAmountTypeEnum.PAY_AMOUNT;
                break;
            }
            case PAY_AMOUNT: {
                amountTypeEnum = DgOrderAmountTypeEnum.PAY_AMOUNT_NOTAX;
                break;
            }
        }
        return amountTypeEnum;
    }

    private List<StrategyConfItemSuitEo> queryRuleConfItemSuitList(DgStrategyRuleEo dgStrategyRuleEo) {
        LambdaQueryWrapper itemSuitEoLambdaQueryWrapper = new LambdaQueryWrapper();
        itemSuitEoLambdaQueryWrapper.eq(BaseEo::getDr, (Object)0);
        itemSuitEoLambdaQueryWrapper.eq(StrategyConfItemSuitEo::getRuleId, (Object)dgStrategyRuleEo.getId());
        List confItemSuitRuleList = this.dgStrategyConfItemSuitDomain.list(itemSuitEoLambdaQueryWrapper);
        logger.info("\u8ba2\u5355\u5339\u914d\u8d39\u6bd4\u7ba1\u63a7\u7b56\u7565\u4e2d\u751f\u6548\u7684\u7ec6\u5219\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)confItemSuitRuleList));
        return confItemSuitRuleList;
    }

    private DgPerformOrderRespDto feeScaleDtoToPerformOrder(DgOrderFeeScaleControllerReqDto feeScaleControllerReqDto) {
        DgPerformOrderRespDto performOrderRespDto = new DgPerformOrderRespDto();
        performOrderRespDto.setId(feeScaleControllerReqDto.getOrderId());
        performOrderRespDto.setSaleOrderNo(feeScaleControllerReqDto.getOrderNo());
        performOrderRespDto.setPlatformOrderId(feeScaleControllerReqDto.getPlatformOrderId());
        performOrderRespDto.setPlatformOrderNo(feeScaleControllerReqDto.getPlatformOrderNo());
        performOrderRespDto.setOrderType(feeScaleControllerReqDto.getOrderType());
        DgPerformOrderSnapshotDto performOrderSnapshotDto = new DgPerformOrderSnapshotDto();
        performOrderSnapshotDto.setShopCode(feeScaleControllerReqDto.getShopCode());
        performOrderSnapshotDto.setCustomerCode(feeScaleControllerReqDto.getCustomerCode());
        performOrderRespDto.setPerformOrderSnapshotDto(performOrderSnapshotDto);
        return performOrderRespDto;
    }
}

