/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.tc.order.constant;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.constant.DgTcOrderStatus;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.constant.DgTcOrderStatusRelEnum;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public enum DgTcOrderMachineStatus {
    EMPTY("EMPTY", "\u7a7a\u72b6\u6001", new DgTcOrderStatusRelEnum[0]),
    INIT_STATE("INIT_STATE", "\u521d\u59cb\u72b6\u6001", new DgTcOrderStatusRelEnum[0]),
    CREATE_ORDER("CREATE_ORDER", "\u5df2\u521b\u5efa", DgTcOrderStatusRelEnum.CREATED),
    CREATE_ORDER_CHOOSE("CREATE_ORDER_CHOOSE", "\u521b\u5efa\u8ba2\u5355-\u9009\u62e9\u5668", new DgTcOrderStatusRelEnum[0]),
    SPLIT_ORDER_CHOOSE("SPLIT_ORDER_CHOOSE", "\u62c6\u5355-\u9009\u62e9\u5668", new DgTcOrderStatusRelEnum[0]),
    CS_WAIT_PICK_SOURCE_ORDER_CHOOSE("CS_WAIT_PICK_SOURCE_ORDER_CHOOSE", "\u5f85\u914d\u8d27\u5bfb\u6e90-\u9009\u62e9\u5668", new DgTcOrderStatusRelEnum[0]),
    CS_SOURCE_RESULT_CHOOSE("CS_SOURCE_RESULT_CHOOSE", "\u5bfb\u6e90\u7ed3\u679c-\u9009\u62e9\u5668", new DgTcOrderStatusRelEnum[0]),
    PART_SPLIT_PICK_CHOOSE("PART_SPLIT_PICK_CHOOSE", "\u90e8\u5206\u62c6\u5355\u53d1\u8d27-\u9009\u62e9\u5668", new DgTcOrderStatusRelEnum[0]),
    AUTO_PICK_SOURCE_CHOOSE("AUTO_PICK_SOURCE_CHOOSE", "\u81ea\u52a8\u914d\u8d27\u5bfb\u6e90-\u9009\u62e9\u5668", new DgTcOrderStatusRelEnum[0]),
    CS_SOURCE_SPLIT_RESULT_CHOOSE("CS_SOURCE_SPLIT_RESULT_CHOOSE", "\u5bfb\u6e90\u62c6\u5355\u7ed3\u679c-\u9009\u62e9\u5668", new DgTcOrderStatusRelEnum[0]),
    STATE_PCP_WAIT_CHECK("STATE_PCP_WAIT_CHECK", "\u5f85\u786e\u8ba4", DgTcOrderStatusRelEnum.WAIT_CHECK),
    STATE_OMS_WAIT_PICK("STATE_OMS_WAIT_PICK", "\u5f85\u914d\u8d27", DgTcOrderStatusRelEnum.WAIT_PICK),
    STATE_PCP_WAIT_DELIVERY("STATE_PCP_WAIT_DELIVERY", "\u5f85\u53d1\u8d27", DgTcOrderStatusRelEnum.WAIT_DELIVERY),
    STATE_PCP_COMPLETE("STATE_PCP_COMPLETE", "\u5df2\u5b8c\u6210", DgTcOrderStatusRelEnum.COMPLETE),
    STATE_PCP_RECEIVED("STATE_PCP_RECEIVED", "\u5df2\u7b7e\u6536", DgTcOrderStatusRelEnum.RECEIVED),
    STATE_PCP_CANCEL("STATE_PCP_CANCEL", "\u5df2\u53d6\u6d88", DgTcOrderStatusRelEnum.CANCEL),
    STATE_PCP_CANCELING("STATE_PCP_CANCELING", "\u53d6\u6d88\u4e2d", DgTcOrderStatusRelEnum.CANCELING),
    STATE_PCP_OBSOLETE("STATE_PCP_OBSOLETE", "\u5df2\u4f5c\u5e9f", DgTcOrderStatusRelEnum.OBSOLETE),
    STATE_PCP_SPLIT("STATE_PCP_SPLIT", "\u88ab\u62c6\u5206", DgTcOrderStatusRelEnum.SPLIT);

    private String code;
    private String desc;
    public static final Map<String, DgTcOrderMachineStatus> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;
    private final Set<DgTcOrderStatusRelEnum> dgTcOrderStatusRelEnumsSet;
    private static final Map<DgTcOrderStatusRelEnum, Set<DgTcOrderMachineStatus>> CIS_SALE_ORDER_STATUS_ENUM_LIST_MAP;

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private DgTcOrderMachineStatus(String code, String desc, DgTcOrderStatusRelEnum ... dgTcOrderStatusRelEnums) {
        this.code = code;
        this.desc = desc;
        this.dgTcOrderStatusRelEnumsSet = new HashSet<DgTcOrderStatusRelEnum>(Arrays.asList(dgTcOrderStatusRelEnums));
    }

    public static DgTcOrderMachineStatus forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public Set<DgTcOrderStatusRelEnum> getCisSaleOrderStatusEnumsSet() {
        return this.dgTcOrderStatusRelEnumsSet;
    }

    public static Set<DgTcOrderMachineStatus> getStateByStatus(DgTcOrderStatusRelEnum dgTcOrderStatusRelEnum) {
        return CIS_SALE_ORDER_STATUS_ENUM_LIST_MAP.get((Object)dgTcOrderStatusRelEnum);
    }

    public static DgTcOrderMachineStatus exchangeDgTcOrderStatus(String omsSaleOrderStatus) {
        DgTcOrderStatus dgTcOrderStatus = Optional.ofNullable(DgTcOrderStatus.forCode(omsSaleOrderStatus)).orElseThrow(() -> new BizException(omsSaleOrderStatus + "\u672a\u77e5\u5b9e\u4f53\u72b6\u6001"));
        DgTcOrderStatusRelEnum dgTcOrderStatusRelEnum = Optional.ofNullable(DgTcOrderStatusRelEnum.forOrderStatus(dgTcOrderStatus)).orElseThrow(() -> new BizException(dgTcOrderStatus.getDesc() + "\u672a\u914d\u7f6e\u72b6\u6001\u5173\u7cfb"));
        Set<DgTcOrderMachineStatus> dgTcOrderMachineStatusSet = Optional.ofNullable(CIS_SALE_ORDER_STATUS_ENUM_LIST_MAP.get((Object)dgTcOrderStatusRelEnum)).orElseThrow(() -> new BizException(dgTcOrderStatusRelEnum.getDesc() + "\u672a\u914d\u7f6e\u72b6\u6001\u673a\u72b6\u6001\u5173\u7cfb"));
        if (dgTcOrderMachineStatusSet.size() > 1) {
            throw new BizException("\u72b6\u6001\u673a\u6620\u5c04\u5173\u7cfb\u91cd\u590d:" + dgTcOrderMachineStatusSet.stream().map(DgTcOrderMachineStatus::getCode).collect(Collectors.joining(",")));
        }
        return (DgTcOrderMachineStatus)((Object)dgTcOrderMachineStatusSet.stream().findFirst().orElseThrow(() -> new BizException("\u5173\u7cfb\u914d\u7f6e\u7684set\u96c6\u5408\u7a7a")));
    }

    static {
        CODE_LOOKUP = Arrays.stream(DgTcOrderMachineStatus.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(DgTcOrderMachineStatus.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
        CIS_SALE_ORDER_STATUS_ENUM_LIST_MAP = new HashMap<DgTcOrderStatusRelEnum, Set<DgTcOrderMachineStatus>>();
        Arrays.stream(DgTcOrderMachineStatus.values()).forEach(state -> state.dgTcOrderStatusRelEnumsSet.forEach(status -> {
            Set statusList = Optional.ofNullable(CIS_SALE_ORDER_STATUS_ENUM_LIST_MAP.get(status)).orElse(new HashSet());
            CIS_SALE_ORDER_STATUS_ENUM_LIST_MAP.put((DgTcOrderStatusRelEnum)((Object)((Object)status)), statusList);
            statusList.add(state);
        }));
    }
}

