/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.tc.order.constant;

import com.yunxi.dg.base.center.trade.statemachine.tc.order.constant.DgTcOrderStatus;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public enum DgTcOrderStatusRelEnum {
    CREATED(DgTcOrderStatus.CREATED),
    DRAFT(DgTcOrderStatus.DRAFT),
    WAIT_AUDIT(DgTcOrderStatus.WAIT_AUDIT),
    WAIT_CUSTOMER_AUDIT(DgTcOrderStatus.WAIT_CUSTOMER_AUDIT),
    WAIT_BUSINESS_AUDIT(DgTcOrderStatus.WAIT_BUSINESS_AUDIT),
    WAIT_CHECK(DgTcOrderStatus.WAIT_CHECK),
    LACK(DgTcOrderStatus.LACK),
    WAIT_PICK(DgTcOrderStatus.WAIT_PICK),
    PICKED(DgTcOrderStatus.PICKED),
    WAIT_PICK_UNLOCK(WAIT_PICK, DgTcOrderStatus.WAIT_PICK_UNLOCK),
    WAIT_WAREHOUSE_SOURCE(WAIT_PICK, DgTcOrderStatus.WAIT_WAREHOUSE_SOURCE),
    WAIT_LOGISTICS_SOURCE(WAIT_PICK, DgTcOrderStatus.WAIT_LOGISTICS_SOURCE),
    WAIT_LOCK_INVENTORY(WAIT_PICK, DgTcOrderStatus.WAIT_LOCK_INVENTORY),
    WAIT_ASSIGN(WAIT_PICK, DgTcOrderStatus.WAIT_ASSIGN),
    WAIT_DELIVERY(DgTcOrderStatus.WAIT_DELIVERY),
    DELIVERED(DgTcOrderStatus.DELIVERED),
    DELIVERY_PART(DELIVERED, DgTcOrderStatus.DELIVERY_PART),
    DELIVERY_ALL(DELIVERED, DgTcOrderStatus.DELIVERY_ALL),
    COMPLETE(DgTcOrderStatus.COMPLETE),
    RECEIVED(DgTcOrderStatus.RECEIVED),
    CANCEL(DgTcOrderStatus.CANCEL),
    FINISH(DgTcOrderStatus.FINISH),
    SPLIT(DgTcOrderStatus.SPLIT),
    SPLIT_CANCELING(DgTcOrderStatus.SPLIT, DgTcOrderStatus.SPLIT_CANCELING),
    CANCELING(DgTcOrderStatus.CANCELING),
    OBSOLETE(DgTcOrderStatus.OBSOLETE);

    private final DgTcOrderStatusRelEnum parenStatus;
    private final String code;
    private final String desc;
    private final DgTcOrderStatus targetStatus;
    private final DgTcOrderStatus showStatus;
    public static final Map<String, DgTcOrderStatusRelEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;
    public static final Map<DgTcOrderStatus, DgTcOrderStatusRelEnum> ORDER_STATUS_REL_ENUM_MAP;

    private DgTcOrderStatusRelEnum(DgTcOrderStatus targetStatus) {
        this(targetStatus, targetStatus);
    }

    private DgTcOrderStatusRelEnum(DgTcOrderStatusRelEnum parenStatus, DgTcOrderStatus targetStatus) {
        this.code = targetStatus.getCode();
        this.desc = targetStatus.getDesc();
        this.targetStatus = targetStatus;
        this.parenStatus = parenStatus;
        this.showStatus = parenStatus.getTargetStatus();
    }

    private DgTcOrderStatusRelEnum(DgTcOrderStatus showStatus, DgTcOrderStatus targetStatus) {
        this.code = targetStatus.getCode();
        this.desc = targetStatus.getDesc();
        this.targetStatus = targetStatus;
        this.parenStatus = null;
        this.showStatus = showStatus;
    }

    public static DgTcOrderStatusRelEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public static DgTcOrderStatusRelEnum forOrderStatus(DgTcOrderStatus code) {
        return ORDER_STATUS_REL_ENUM_MAP.get((Object)code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public DgTcOrderStatusRelEnum getParenStatus() {
        return this.parenStatus;
    }

    public DgTcOrderStatus getTargetStatus() {
        return this.targetStatus;
    }

    public DgTcOrderStatus getShowStatus() {
        return this.showStatus;
    }

    static {
        CODE_LOOKUP = Arrays.stream(DgTcOrderStatusRelEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(DgTcOrderStatusRelEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
        ORDER_STATUS_REL_ENUM_MAP = new ConcurrentHashMap<DgTcOrderStatus, DgTcOrderStatusRelEnum>();
        Arrays.stream(DgTcOrderStatusRelEnum.values()).forEach(state -> ORDER_STATUS_REL_ENUM_MAP.put(state.getTargetStatus(), (DgTcOrderStatusRelEnum)((Object)state)));
    }
}

