/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.tc.order.config.engine.action;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.statemachine.engine.action.AbstractCisBaseStatemachineAction;
import com.dtyunxi.cube.statemachine.engine.action.CisActionDefine;
import com.dtyunxi.cube.statemachine.engine.exception.CisStatemachineExceptionCode;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisBaseOrderMessageHeaders;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisBaseRequest;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisActionResult;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.AllotTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderBySourceInfoReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.source.dto.extend.OrderItemResultRespDto;
import com.yunxi.dg.base.center.source.dto.extend.SourceOrderResultRespDto;
import com.yunxi.dg.base.center.trade.action.tc.IDgTcPerformOrderOptAction;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderService;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.constant.DgTcOrderActionDefineEnum;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.constant.DgTcOrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.constant.DgTcOrderMachineStatus;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.vo.DgTcOrderThroughRespDto;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DgTcMaiyouSourceDeliveryAction
extends AbstractCisBaseStatemachineAction<DgTcOrderActionDefineEnum, DgTcOrderMachineStatus, DgTcOrderMachineEvents, RestResponse<SourceOrderResultRespDto>, RestResponse<Boolean>, DgTcOrderThroughRespDto> {
    private static final Logger logger = LoggerFactory.getLogger(DgTcMaiyouSourceDeliveryAction.class);
    @Resource
    private IDgTcPerformOrderOptAction dgTcPerformOrderOptAction;
    @Resource
    private ISaleOrderService saleOrderService;
    @Resource
    private ISaleOrderItemService saleOrderItemService;

    public DgTcMaiyouSourceDeliveryAction() {
        super((CisActionDefine)DgTcOrderActionDefineEnum.MAIYOU_SOURCE_DELIVERY, false);
    }

    public RestResponse<Boolean> executeSub(DgTcOrderThroughRespDto throughSaleOrderDto, RestResponse<SourceOrderResultRespDto> request) {
        logger.info("\u8fdb\u5165\u9ea6\u4f18\u8ba2\u5355-\u666e\u901a\u5bfb\u6e90\u6210\u529f\u540e\u914d\u8d27");
        SaleOrderRespDto saleOrderRespDto = this.saleOrderService.querySaleOrderById(throughSaleOrderDto.getId());
        if (!Objects.equals(saleOrderRespDto.getAllotType(), AllotTypeEnum.MAIYOU_BC_SAME_ORG_ALLOT.getType())) {
            throw new BizException("\u975ebc\u540c\u7ec4\u7ec7\u8c03\u62e8\u6d41\u7a0b\u5f02\u5e38:" + saleOrderRespDto.getAllotType());
        }
        List orderItemRespDtoList = this.saleOrderItemService.queryOrderItemByOrderId(throughSaleOrderDto.getId());
        List<SplitOrderBySourceInfoReqDto> sourceInfoReqDtoList = this.convertSourceInfoReqDtoList(saleOrderRespDto, orderItemRespDtoList, (SourceOrderResultRespDto)request.getData());
        this.dgTcPerformOrderOptAction.maiyouAllotDelivery(throughSaleOrderDto.getId(), sourceInfoReqDtoList);
        return new RestResponse((Object)Boolean.TRUE);
    }

    private List<SplitOrderBySourceInfoReqDto> convertSourceInfoReqDtoList(SaleOrderRespDto saleOrder, List<SaleOrderItemRespDto> orderItemRespDtoList, SourceOrderResultRespDto sourceOrderResultRespDto) {
        ArrayList<SplitOrderBySourceInfoReqDto> list = new ArrayList<SplitOrderBySourceInfoReqDto>();
        Map<String, List<OrderItemResultRespDto>> wCodeItemListMap = sourceOrderResultRespDto.getOrderItemResultRespDtoList().stream().collect(Collectors.groupingBy(OrderItemResultRespDto::getDeliveryLogicWarehouseCode));
        Map<Long, SaleOrderItemRespDto> orderItemListMap = orderItemRespDtoList.stream().collect(Collectors.toMap(SaleOrderItemRespDto::getId, v1 -> v1));
        wCodeItemListMap.forEach((warehouseCode, orderItemResultRespDtoList) -> {
            SplitOrderBySourceInfoReqDto splitOrderReqDto = new SplitOrderBySourceInfoReqDto();
            splitOrderReqDto.setSaleOrderId(saleOrder.getId());
            splitOrderReqDto.setSaleOrderNo(saleOrder.getSaleOrderNo());
            splitOrderReqDto.setIntransitPreemptFlag(sourceOrderResultRespDto.getIntransitPreemptFlag());
            splitOrderReqDto.setDeliveryType(saleOrder.getAllotType());
            splitOrderReqDto.setDeliveryLogicWarehouseCode(((OrderItemResultRespDto)orderItemResultRespDtoList.get(0)).getDeliveryLogicWarehouseCode());
            splitOrderReqDto.setDeliveryLogicWarehouseId(((OrderItemResultRespDto)orderItemResultRespDtoList.get(0)).getDeliveryLogicWarehouseId());
            splitOrderReqDto.setDeliveryLogicWarehouseName(((OrderItemResultRespDto)orderItemResultRespDtoList.get(0)).getDeliveryLogicWarehouseName());
            splitOrderReqDto.setInLogicWarehouseCode(saleOrder.getAllotInWarehouseCode());
            splitOrderReqDto.setInLogicWarehouseName(saleOrder.getAllotInWarehouseName());
            ArrayList goodsList = Lists.newArrayList();
            for (OrderItemResultRespDto sourcingOrderItemVO : orderItemResultRespDtoList) {
                SaleOrderItemRespDto saleOrderItemRespDto = (SaleOrderItemRespDto)orderItemListMap.get(sourcingOrderItemVO.getLinkOrderItemId());
                AssertUtils.notNull((Object)saleOrderItemRespDto, (String)("\u5339\u914d\u4e0d\u5230\u539f\u8ba2\u5355\u884c\u6570\u636e" + sourcingOrderItemVO.getLinkOrderItemId()));
                SplitOrderItemReqDto splitOrderItemReqDto = new SplitOrderItemReqDto();
                splitOrderItemReqDto.setDeliveryItemBatchNo(sourcingOrderItemVO.getDeliveryItemBatchNo());
                splitOrderItemReqDto.setGoodsCode(saleOrderItemRespDto.getItemCode());
                splitOrderItemReqDto.setGoodsId(saleOrderItemRespDto.getItemId());
                splitOrderItemReqDto.setIsGiftFlag(Integer.valueOf(0));
                splitOrderItemReqDto.setGoodsNum(sourcingOrderItemVO.getDeliveryItemNum());
                splitOrderItemReqDto.setGoodsSku(sourcingOrderItemVO.getLinkItemSkuCode());
                splitOrderItemReqDto.setOriginalOrderGoodsId(saleOrderItemRespDto.getId());
                splitOrderItemReqDto.setWarehouseItemNum(sourcingOrderItemVO.getWarehouseItemNum());
                splitOrderItemReqDto.setZtDeliveryWarehouseItemNum(sourcingOrderItemVO.getZtDeliveryWarehouseItemNum());
                splitOrderItemReqDto.setZtWarehouseItemNum(sourcingOrderItemVO.getZtWarehouseItemNum());
                goodsList.add(splitOrderItemReqDto);
            }
            splitOrderReqDto.setGoodsList((List)goodsList);
            list.add(splitOrderReqDto);
        });
        logger.info("bc\u8de8\u7ec4\u7ec7\u8c03\u62e8\u9500\u552e\u5355\u53d1\u8d27\u5165\u53c2={}", (Object)JSON.toJSONString(list));
        return list;
    }

    public RestResponse<SourceOrderResultRespDto> exchangeRequest(CisBaseOrderMessageHeaders<DgTcOrderActionDefineEnum, DgTcOrderMachineStatus, DgTcOrderMachineEvents, ?, DgTcOrderThroughRespDto> cisBaseOrderMessageHeaders, CisActionResult<DgTcOrderActionDefineEnum, ?> lastCisActionResult) {
        if (lastCisActionResult == null) {
            return (RestResponse)((CisBaseRequest)cisBaseOrderMessageHeaders.getRequest()).getRequestData();
        }
        if (lastCisActionResult.getResultData() instanceof RestResponse) {
            return (RestResponse)lastCisActionResult.getResultData();
        }
        throw CisStatemachineExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u672a\u914d\u7f6erequest\u8f6c\u6362"});
    }
}

