/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.tc.order.config.engine.action;

import com.dtyunxi.cube.statemachine.engine.action.AbstractCisBaseStatemachineAction;
import com.dtyunxi.cube.statemachine.engine.action.CisActionDefine;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.OrderOptLabelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.yunxi.dg.base.center.source.dto.extend.OrderItemReqDto;
import com.yunxi.dg.base.center.source.dto.extend.SaleOrderOldBatchMatchReqDto;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderOptService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderService;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.constant.DgTcOrderActionDefineEnum;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.constant.DgTcOrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.constant.DgTcOrderMachineStatus;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.vo.DgTcOrderThroughRespDto;
import com.yunxi.dg.base.center.trade.utils.OrderOptLabelUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DgTcSourceZtStockAction
extends AbstractCisBaseStatemachineAction<DgTcOrderActionDefineEnum, DgTcOrderMachineStatus, DgTcOrderMachineEvents, Object, RestResponse<Void>, DgTcOrderThroughRespDto> {
    private final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private ISaleOrderOptService saleOrderOptService;
    @Resource
    private ISaleOrderItemService saleOrderItemService;
    @Resource
    private ISaleOrderService saleOrderService;

    public DgTcSourceZtStockAction() {
        super((CisActionDefine)DgTcOrderActionDefineEnum.SALE_ORDER_SOURCE_ZT);
    }

    public RestResponse<Void> executeSub(DgTcOrderThroughRespDto throughDtoDefine, Object request) {
        this.LOGGER.info("[\u72b6\u6001\u673a]\u9500\u552e\u5355\u5bfb\u6e90\u5728\u9014\u6570-action");
        SaleOrderRespDto saleOrderRespDto = this.saleOrderService.querySaleOrderById(throughDtoDefine.getId());
        List saleOrderItemRespDtos = this.saleOrderItemService.queryOrderItemByOrderId(throughDtoDefine.getId());
        if (StringUtils.isEmpty((CharSequence)((SaleOrderItemRespDto)saleOrderItemRespDtos.get(0)).getLogicalWarehouseCode())) {
            this.LOGGER.info("\u8ba2\u5355\u5546\u54c1\u660e\u7ec6\u53d1\u8d27\u4ed3code\u4e3a\u7a7a");
            return RestResponse.VOID;
        }
        String optLabel = throughDtoDefine.getOptLabel();
        if (!OrderOptLabelUtils.containsLabel((String)optLabel, (String)OrderOptLabelEnum.MODIFY_LOGICAL_WAREHOUSE.getCode()).booleanValue()) {
            this.LOGGER.info("\u4e0d\u662f\u6307\u5b9a\u53d1\u8d27\u4ed3\u4e0d\u8d70\u5728\u9014\u6807\u8bc6\u5224\u65ad");
            return RestResponse.VOID;
        }
        SaleOrderOldBatchMatchReqDto reqDto = new SaleOrderOldBatchMatchReqDto();
        reqDto.setLinkOrderNo(throughDtoDefine.getSaleOrderNo());
        reqDto.setLinkOrderChannelWarehouseCode(saleOrderRespDto.getChannelWarehouseCode());
        reqDto.setLogicWarehouseId(((SaleOrderItemRespDto)saleOrderItemRespDtos.get(0)).getLogicalWarehouseId());
        reqDto.setLogicWarehouseCode(((SaleOrderItemRespDto)saleOrderItemRespDtos.get(0)).getLogicalWarehouseCode());
        List orderItemReqDtoList = saleOrderItemRespDtos.stream().map(saleOrderItemExtRespDto -> {
            OrderItemReqDto orderItemReqDto = new OrderItemReqDto();
            CubeBeanUtils.copyProperties((Object)orderItemReqDto, (Object)saleOrderItemExtRespDto, (String[])new String[0]);
            orderItemReqDto.setLinkOrderItemId(saleOrderItemExtRespDto.getId());
            orderItemReqDto.setLinkOrderType(throughDtoDefine.getOrderType());
            orderItemReqDto.setItemSkuCode(saleOrderItemExtRespDto.getSkuCode());
            orderItemReqDto.setItemBatchNo(saleOrderItemExtRespDto.getBatchNo());
            orderItemReqDto.setItemGiftType(saleOrderItemExtRespDto.getGift());
            orderItemReqDto.setLinkOrderNo(throughDtoDefine.getSaleOrderNo());
            return orderItemReqDto;
        }).collect(Collectors.toList());
        reqDto.setOrderItemReqDtoList(orderItemReqDtoList);
        this.saleOrderOptService.saleSourceZtNum(reqDto);
        return RestResponse.VOID;
    }
}

