/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.tc.order.config.engine.action;

import com.dtyunxi.cube.statemachine.engine.action.AbstractCisBaseStatemachineAction;
import com.dtyunxi.cube.statemachine.engine.action.CisActionDefine;
import com.dtyunxi.cube.statemachine.engine.exception.CisStatemachineExceptionCode;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisBaseOrderMessageHeaders;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisActionResult;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderDomain;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderOptService;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.constant.DgTcOrderActionDefineEnum;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.constant.DgTcOrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.constant.DgTcOrderMachineStatus;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.vo.DgTcOrderThroughRespDto;
import com.yunxi.dg.base.center.trade.vo.StatemachineInvalidOrderDto;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class DgTcInvalidChildOrderAction
extends AbstractCisBaseStatemachineAction<DgTcOrderActionDefineEnum, DgTcOrderMachineStatus, DgTcOrderMachineEvents, RestResponse<StatemachineInvalidOrderDto>, RestResponse<StatemachineInvalidOrderDto>, DgTcOrderThroughRespDto> {
    @Resource
    private IDgSaleOrderDomain dgSaleOrderDomain;
    @Resource
    private ISaleOrderOptService saleOrderOptService;

    public DgTcInvalidChildOrderAction() {
        super((CisActionDefine)DgTcOrderActionDefineEnum.RESET, true);
    }

    public RestResponse<StatemachineInvalidOrderDto> executeSub(DgTcOrderThroughRespDto throughDtoDefine, RestResponse<StatemachineInvalidOrderDto> restResponse) {
        StatemachineInvalidOrderDto data = (StatemachineInvalidOrderDto)restResponse.getData();
        if (Objects.nonNull(data) && CollectionUtils.isNotEmpty((Collection)data.getChildSaleOrderNos())) {
            for (SaleOrderRespDto saleOrderRespDto : data.getChildSaleOrderNos()) {
                if (!SaleOrderStatusEnum.CANCEL.getCode().equals(saleOrderRespDto.getOrderStatus())) continue;
                DgSaleOrderEo updateSaleOrder = new DgSaleOrderEo();
                updateSaleOrder.setOrderStatus(SaleOrderStatusEnum.OBSOLETE.getCode());
                this.saleOrderOptService.optimisticSaleOrderStatus(updateSaleOrder, saleOrderRespDto.getId(), new SaleOrderStatusEnum[]{SaleOrderStatusEnum.CANCEL});
            }
        }
        return restResponse;
    }

    public RestResponse<StatemachineInvalidOrderDto> exchangeRequest(CisBaseOrderMessageHeaders<DgTcOrderActionDefineEnum, DgTcOrderMachineStatus, DgTcOrderMachineEvents, ?, DgTcOrderThroughRespDto> cisBaseOrderMessageHeaders, CisActionResult<DgTcOrderActionDefineEnum, ?> lastCisActionResult) {
        if (lastCisActionResult.getResultData() instanceof RestResponse) {
            return (RestResponse)lastCisActionResult.getResultData();
        }
        throw CisStatemachineExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u4f5c\u5e9f\u5b50\u5355request\u8f6c\u6362\u7c7b\u578b\u5f02\u5e38"});
    }
}

