/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.b2c.order.scheduled;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.trade.api.order.IPerformOrderQueryApi;
import com.yunxi.dg.base.center.trade.api.strategy.IDgReceiveStrategyApi;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.dto.entity.DgReceiveStrategyDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgReceiveStrategyPageReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.constant.DgB2COrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.execute.DgB2COrderStatemachineExecutor;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"cis.statemachine.oms.config.enable"}, havingValue="true")
@Component
public class DgAutoConfirmReceivedGoodsScheduled {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgAutoConfirmReceivedGoodsScheduled.class);
    private static final String AUTO_CONFIRM_GOODS_LOCK_KEY = "AUTO_CONFIRM_GOODS_LOCK_KEY";
    @Resource
    private ICacheService cacheService;
    @Resource
    private IPerformOrderQueryApi saleOrderQueryApiImpl;
    @Resource
    private IDgReceiveStrategyApi receiveStrategyQueryApi;
    @Resource
    private DgB2COrderStatemachineExecutor orderStatemachineExecutor;

    @Scheduled(cron="${oms.sale.order.auto.confirm.received.goods.cron:0 55 23 * * ?}")
    public void autoConfirmReceivedGoods() {
        CompletableFuture.runAsync(this::autoHandleAutoConfirmReceiveGoods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoHandleAutoConfirmReceiveGoods() {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u786e\u8ba4\u6536\u8d27]\u5b9a\u65f6\u5668\u5f00\u59cb\u6267\u884c\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u4efb\u52a1!");
        Long lockFlag = this.cacheService.setnx(AUTO_CONFIRM_GOODS_LOCK_KEY, "1");
        if (lockFlag == 1L) {
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u786e\u8ba4\u6536\u8d27]\u5b9a\u65f6\u5668\u542f\u52a8");
            try {
                this.handleAutoConfirmReceiveGoods(null);
            }
            catch (Exception e) {
                LOGGER.error("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u786e\u8ba4\u6536\u8d27]\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            }
            finally {
                this.cacheService.delCache(AUTO_CONFIRM_GOODS_LOCK_KEY);
            }
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u786e\u8ba4\u6536\u8d27]\u5b9a\u65f6\u5668\u4efb\u52a1\u6267\u884c\u5b8c\u6210!");
        } else {
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u786e\u8ba4\u6536\u8d27]\u5b9a\u65f6\u5668\u4efb\u52a1\u672a\u6267\u884c!");
        }
    }

    private void handleAutoConfirmReceiveGoods(Long nextBeginId) {
        List saleOrderRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApiImpl.queryNeedConfirmGoodsOrderList(nextBeginId, Integer.valueOf(1000)));
        LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u786e\u8ba4\u6536\u8d27]\u83b7\u53d6\u5230\u9700\u786e\u8ba4\u6536\u8d27\u8ba2\u5355\u6570={}", (Object)Optional.ofNullable(saleOrderRespDtoList).map(List::size).orElse(0));
        if (CollectionUtils.isEmpty((Collection)saleOrderRespDtoList)) {
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u786e\u8ba4\u6536\u8d27]\u65e0\u9700\u786e\u8ba4\u6536\u8d27\u8ba2\u5355-\u7ed3\u675f");
            return;
        }
        HashSet channelCodeSet = new HashSet();
        Map<String, List<DgPerformOrderRespDto>> sourceChannelMap = saleOrderRespDtoList.stream().filter(order -> StringUtils.isNotBlank((CharSequence)order.getPerformOrderSnapshotDto().getChannelCode())).map(dto -> {
            channelCodeSet.add(dto.getPerformOrderSnapshotDto().getChannelCode());
            return dto;
        }).collect(Collectors.groupingBy(dto -> dto.getPerformOrderSnapshotDto().getChannelCode()));
        DgReceiveStrategyPageReqDto receiveStrategyParamQueryReqDto = new DgReceiveStrategyPageReqDto();
        receiveStrategyParamQueryReqDto.setChannelCodeList(new ArrayList(channelCodeSet));
        List receiveStrategyPageRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.receiveStrategyQueryApi.queryParam(receiveStrategyParamQueryReqDto));
        LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u786e\u8ba4\u6536\u8d27]\u83b7\u53d6\u5230\u786e\u8ba4\u6536\u8d27\u7b56\u7565receiveStrategyPageRespDtoList={}", (Object)JSON.toJSONString((Object)receiveStrategyPageRespDtoList));
        if (CollectionUtils.isEmpty((Collection)receiveStrategyPageRespDtoList)) {
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u786e\u8ba4\u6536\u8d27]\u83b7\u53d6\u4e0d\u5230\u786e\u8ba4\u6536\u8d27\u7b56\u7565-\u7ed3\u675f");
            return;
        }
        Map receiveStrategyPageRespDtoMap = receiveStrategyPageRespDtoList.stream().collect(Collectors.toMap(DgReceiveStrategyDto::getChannelCode, Function.identity()));
        sourceChannelMap.forEach((channelCode, list) -> {
            DgReceiveStrategyDto respDto = (DgReceiveStrategyDto)receiveStrategyPageRespDtoMap.get(channelCode);
            if (respDto != null) {
                list.forEach(order -> {
                    if (order.getDeliveryCompleteDate() == null) {
                        LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u786e\u8ba4\u6536\u8d27]\u53d1\u8d27\u5b8c\u6210\u65f6\u95f4\u4e3a\u7a7a{}", (Object)order.getId());
                    } else {
                        Date deliveryDate = DateUtil.getStartOfDay((Date)order.getDeliveryCompleteDate());
                        Integer strategyDay = Optional.ofNullable(respDto).map(DgReceiveStrategyDto::getStrategyDay).orElse(0);
                        strategyDay = strategyDay == 0 ? 0 : strategyDay + 1;
                        Date afterCheckDate = DateUtil.addDays((Date)deliveryDate, (int)strategyDay);
                        LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u786e\u8ba4\u6536\u8d27]\u5339\u914d\u5230\u786e\u8ba4\u6536\u8d27\u7b56\u7565id={},afterCheckDate={},channelCode={},respDto={}", new Object[]{order.getId(), afterCheckDate, channelCode, JSON.toJSONString((Object)respDto)});
                        if (afterCheckDate.compareTo(new Date()) <= 0) {
                            try {
                                this.orderStatemachineExecutor.executeStatemachine(DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode(), order.getId(), null, (Object)DgB2COrderMachineEvents.CONFIRM_RECEIVE_GOODS);
                                Thread.sleep(50L);
                            }
                            catch (Exception e) {
                                LOGGER.error(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                });
            }
        });
        if (saleOrderRespDtoList.size() >= 1000) {
            Long lastSaleOrderId = ((DgPerformOrderRespDto)saleOrderRespDtoList.get(saleOrderRespDtoList.size() - 1)).getId();
            if (lastSaleOrderId == null || lastSaleOrderId.equals(nextBeginId)) {
                LOGGER.info("lastSaleOrderId\u5f02\u5e38\u7ed3\u675f\u5bfb\u6e90nextBeginId={},lastSaleOrderId={}", (Object)nextBeginId, (Object)lastSaleOrderId);
                return;
            }
            this.handleAutoConfirmReceiveGoods(lastSaleOrderId);
        }
    }
}

