/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.b2c.aftersale.config.engine.guard.impl;

import com.dtyunxi.util.JacksonUtil;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderCheckModelEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderSourceEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgCisAfterSaleBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.PlatformAfterSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.PlatformApplyRefundTypeEnum;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemModifyReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.statemachine.b2c.aftersale.config.engine.guard.IDgB2CAfterSaleOrderGuard;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgAfterSaleOrderGuardImpl
implements IDgB2CAfterSaleOrderGuard {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Boolean validationAfterSaleOrder(DgBizAfterSaleOrderReqDto reqDto, String checkModel) {
        DgPerformOrderInfoDto dgPerformOrderInfoDto = new DgPerformOrderInfoDto();
        this.logger.info("validationAfterSaleOrder checkModel: {}, reqDto: {}", (Object)checkModel, (Object)JacksonUtil.toJson((Object)reqDto));
        switch (DgAfterSaleOrderCheckModelEnum.forCode((String)checkModel)) {
            case PLATFORM_CREATE: {
                AssertUtils.notBlank((String)reqDto.getPlatformApplyRefundType(), (String)"\u5e73\u53f0\u552e\u540e\u5355(platformApplyRefundType)\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notInMap((Object)reqDto.getPlatformApplyRefundType(), (Map)PlatformApplyRefundTypeEnum.CODE_LOOKUP, (String)"\u5e73\u53f0\u552e\u540e\u5355(platformApplyRefundType)\u7c7b\u578b\u4e0d\u6b63\u786e", (Object[])new Object[0]);
                AssertUtils.notBlank((String)reqDto.getPlatformOrderNo(), (String)"\u5e73\u53f0\u552e\u540e\u5355(platformOrderNo)\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notBlank((String)reqDto.getChannelCode(), (String)"\u5e73\u53f0\u552e\u540e\u5355(channelCode)\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notBlank((String)reqDto.getPlatformRefundOrderSn(), (String)"\u5e73\u53f0\u552e\u540e\u5355(platformRefundOrderSn)\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notBlank((String)reqDto.getPlatformRefundOrderId(), (String)"\u5e73\u53f0\u552e\u540e\u5355(platformRefundOrderId)\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notBlank((String)reqDto.getPlatformSyncStatus(), (String)"\u5e73\u53f0\u552e\u540e\u5355(platformSyncStatus)\u4e0d\u80fd\u4e3a\u7a7a");
                if (!PlatformApplyRefundTypeEnum.EXCHANGE.getCode().equalsIgnoreCase(reqDto.getAfterSaleOrderType())) {
                    AssertUtils.notBlank((String)reqDto.getRefundStatus(), (String)"\u5e73\u53f0\u552e\u540e\u5355(refundStatus)\u4e0d\u80fd\u4e3a\u7a7a");
                }
                AssertUtils.notNull((Object)PlatformAfterSaleOrderStatusEnum.forCode((String)reqDto.getPlatformSyncStatus()), (String)("\u9519\u8bef\u540c\u6b65\u72b6\u6001" + reqDto.getPlatformSyncStatus()));
                AssertUtils.notEmpty((Collection)reqDto.getAfterSaleOrderItemReqDtoList(), (String)"\u5e73\u53f0\u552e\u540e\u5355(afterSaleOrderItemReqDtoList)\u4e0d\u80fd\u4e3a\u7a7a");
                reqDto.getAfterSaleOrderItemReqDtoList().forEach(dto -> this.checkItemParam(reqDto, (DgAfterSaleOrderItemModifyReqDto)dto, 0));
                break;
            }
            case PLATFORM_SYNC: {
                AssertUtils.notBlank((String)reqDto.getPlatformOrderNo(), (String)"\u5e73\u53f0\u552e\u540e\u5355(platformOrderNo)\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notBlank((String)reqDto.getPlatformRefundOrderSn(), (String)"\u5e73\u53f0\u552e\u540e\u5355(platformRefundOrderSn)\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notBlank((String)reqDto.getPlatformRefundOrderId(), (String)"\u5e73\u53f0\u552e\u540e\u5355(platformRefundOrderId)\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notBlank((String)reqDto.getPlatformSyncStatus(), (String)"\u5e73\u53f0\u552e\u540e\u5355(platformSyncStatus)\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notNull((Object)PlatformAfterSaleOrderStatusEnum.forCode((String)reqDto.getPlatformSyncStatus()), (String)("\u9519\u8bef\u540c\u6b65\u72b6\u6001" + reqDto.getPlatformSyncStatus()));
                break;
            }
            case CREATE: {
                AssertUtils.notBlank((String)reqDto.getAfterSaleOrderType(), (String)"\u5173\u8054\u552e\u540e\u5355\u7c7b\u578b(afterSaleOrderType)\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notBlank((String)reqDto.getChannelCode(), (String)"\u5e73\u53f0\u552e\u540e\u5355(channelCode)\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.cannotEquals((Object)AfterSaleOrderTypeEnum.forCode((String)reqDto.getAfterSaleOrderType().toUpperCase()), (Object)AfterSaleOrderTypeEnum.JTK, (String)"\u8be5\u5165\u53e3\u4e0d\u5141\u8bb8\u53d1\u8d77\u53d1\u8d27\u524d\u4ec5\u9000\u6b3e\u5355", (Object[])new Object[0]);
                AssertUtils.notNull((Object)reqDto.getOrderSource(), (String)"\u8ba2\u5355\u6765\u6e90(orderSource)\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notBlank((String)reqDto.getStatus(), (String)"\u8ba2\u5355\u72b6\u6001(status)\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notNull((Object)reqDto.getRefundFee(), (String)"\u9000\u6b3e\u91d1\u989d(refundFee)\u4e0d\u80fd\u4e3a\u7a7a");
                if (!DgCisAfterSaleBizModelEnum.HH.getCode().equalsIgnoreCase(reqDto.getAfterSaleOrderType())) {
                    AssertUtils.notBlank((String)reqDto.getRefundStatus(), (String)"\u5e73\u53f0\u552e\u540e\u5355(refundStatus)\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (reqDto.getRelateToPlatformOrder() == null || reqDto.getRelateToPlatformOrder() == 0) {
                    AssertUtils.notBlank((String)reqDto.getSaleOrderNo(), (String)"\u5185\u90e8\u9500\u552e\u5355\u53f7(saleOrderNo)\u4e0d\u80fd\u4e3a\u7a7a");
                    AssertUtils.notNull((Object)reqDto.getSaleOrderId(), (String)"\u5185\u90e8\u9500\u552e\u5355id(saleOrderId)\u4e0d\u80fd\u4e3a\u7a7a");
                    reqDto.getAfterSaleOrderItemReqDtoList().forEach(dto -> this.checkItemParam(reqDto, (DgAfterSaleOrderItemModifyReqDto)dto, 0));
                    break;
                }
                reqDto.getAfterSaleOrderItemReqDtoList().forEach(dto -> this.checkItemParam(reqDto, (DgAfterSaleOrderItemModifyReqDto)dto, 1));
            }
        }
        return true;
    }

    @Override
    public boolean isManualSource(DgBizAfterSaleOrderReqDto reqDto) {
        return DgAfterSaleOrderSourceEnum.CREATE.getType().equals(reqDto.getOrderSource());
    }

    @Override
    public boolean haveLogiscticNo(DgBizAfterSaleOrderReqDto reqDto) {
        return StringUtils.isNotBlank((CharSequence)reqDto.getReturnShippingSn());
    }

    private void checkItemParam(DgBizAfterSaleOrderReqDto reqDto, DgAfterSaleOrderItemModifyReqDto itemReqDto, Integer checkType) {
        String afterSaleOrderType = reqDto.getAfterSaleOrderType();
        AssertUtils.notBlank((String)itemReqDto.getSkuCode(), (String)"\u5185\u90e8\u552e\u540e\u5355(skuCode)\u4e0d\u80fd\u4e3a\u7a7a");
        if (afterSaleOrderType.equalsIgnoreCase(AfterSaleOrderTypeEnum.THTK.getCode()) || afterSaleOrderType.equalsIgnoreCase(AfterSaleOrderTypeEnum.HH.getCode())) {
            AssertUtils.notNull((Object)itemReqDto.getItemNum(), (String)("\u5185\u90e8\u552e\u540e\u5355-" + itemReqDto.getSkuCode() + "-itemNum\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        AssertUtils.notNull((Object)itemReqDto.getRefundAmount(), (String)("\u5185\u90e8\u552e\u540e\u5355-" + itemReqDto.getSkuCode() + "-refundAmount\u4e0d\u80fd\u4e3a\u7a7a"));
        AssertUtils.notNull((Object)itemReqDto.getAfterSaleOrderItemType(), (String)("\u5185\u90e8\u552e\u540e\u5355-" + itemReqDto.getSkuCode() + "afterSaleOrderItemType\u4e0d\u80fd\u4e3a\u7a7a"));
        if (itemReqDto.getAfterSaleOrderItemType() == 0) {
            AssertUtils.notNull((Object)itemReqDto.getRefundAmount(), (String)String.format("\u5185\u90e8\u552e\u540e\u5355-%s-refundAmount\u4e0d\u80fd\u4e3a\u7a7a", itemReqDto.getSkuCode()));
        }
    }
}

