/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.b2c.aftersale.Interceptor;

import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.trade.action.oms.B2C.IDgMqMessageAction;
import com.yunxi.dg.base.center.trade.dao.das.IDgAfterSaleOrderDas;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.statemachine.b2c.aftersale.vo.DgB2CAfterSaleStatusChangeEvent;
import javax.annotation.Resource;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class DgB2CAfterStatusChangeEventListener {
    private static final Logger log = LoggerFactory.getLogger(DgB2CAfterStatusChangeEventListener.class);
    @Resource
    private IDgMqMessageAction dgMqMessageAction;
    @Resource
    private IDgAfterSaleOrderDas dgAfterSaleOrderDas;
    @Resource
    private SqlSessionTemplate sqlSessionTemplate;

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={DgB2CAfterSaleStatusChangeEvent.class})
    public void handleB2CAftersaleOrderStatusChangeEvent(DgB2CAfterSaleStatusChangeEvent event) {
        log.info("\u76d1\u542c\u5230\u6709\u4e8b\u52a1\u7684\u552e\u540e\u5355\u72b6\u6001\u53d8\u66f4,\u53d1\u9001MQ");
        this.dgMqMessageAction.sendMsgAfterSaleOrderStatusChange((DgAfterSaleOrderRespDto)event, event.getBeforeStatus(), event.getChangeByEvent());
    }

    @TransactionalEventListener(phase=TransactionPhase.BEFORE_COMMIT, classes={DgB2CAfterSaleStatusChangeEvent.class})
    public void handleB2CAftersaleOrderStatusChangeEventBC(DgB2CAfterSaleStatusChangeEvent event) {
        log.info("\u76d1\u542c\u5230\u6709\u4e8b\u52a1\u7684\u552e\u540e\u5355\u72b6\u6001\u53d8\u66f4,\u63d0\u4ea4\u524d\uff0c\u5220\u9664\u7f13\u5b58 {}", (Object)event.getId());
        this.delAfterSaleOrderCache(event);
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMPLETION, classes={DgB2CAfterSaleStatusChangeEvent.class})
    public void handleB2CAftersaleOrderStatusChangeEventAC(DgB2CAfterSaleStatusChangeEvent event) {
        log.info("\u76d1\u542c\u5230\u6709\u4e8b\u52a1\u7684\u552e\u540e\u5355\u72b6\u6001\u53d8\u66f4,\u5b8c\u6574\u540e\uff0c\u5220\u9664\u7f13\u5b58 {}", (Object)event.getId());
        this.delAfterSaleOrderCache(event);
    }

    private void delAfterSaleOrderCache(DgB2CAfterSaleStatusChangeEvent event) {
        try {
            if (this.dgAfterSaleOrderDas.isUseCache()) {
                log.info("\u5220\u9664\u5168\u90e8\u7f13\u5b58");
                this.sqlSessionTemplate.clearCache();
                DgAfterSaleOrderEo cacheDelEo = new DgAfterSaleOrderEo();
                cacheDelEo.setId(event.getId());
                this.dgAfterSaleOrderDas.removeLogicCache((BaseEo)cacheDelEo);
                this.dgAfterSaleOrderDas.removeCache((Object)cacheDelEo.getId());
                this.dgAfterSaleOrderDas.removeCacheByExample((BaseEo)cacheDelEo);
            } else {
                log.info("\u5220\u9664\u4e00\u7ea7\u7f13\u5b58");
                this.sqlSessionTemplate.clearCache();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

